# -*- coding: utf-8 -*-

###############################################################################
#
# Stats
# Retrieves the account information for the user associated with the given authorized access token.
#
# Python versions 2.6, 2.7, 3.x
#
# Copyright 2014, Temboo Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
# either express or implied. See the License for the specific
# language governing permissions and limitations under the License.
#
#
###############################################################################

from temboo.core.choreography import Choreography
from temboo.core.choreography import InputSet
from temboo.core.choreography import ResultSet
from temboo.core.choreography import ChoreographyExecution

import json

class Stats(Choreography):

    def __init__(self, temboo_session):
        """
        Create a new instance of the Stats Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
        """
        super(Stats, self).__init__(temboo_session, '/Library/Dwolla/Transactions/Stats')


    def new_input_set(self):
        return StatsInputSet()

    def _make_result_set(self, result, path):
        return StatsResultSet(result, path)

    def _make_execution(self, session, exec_id, path):
        return StatsChoreographyExecution(session, exec_id, path)

class StatsInputSet(InputSet):
    """
    An InputSet with methods appropriate for specifying the inputs to the Stats
    Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
    """
    def set_AccessToken(self, value):
        """
        Set the value of the AccessToken input for this Choreo. ((required, string) A valid OAuth token.)
        """
        super(StatsInputSet, self)._set_input('AccessToken', value)
    def set_EndDate(self, value):
        """
        Set the value of the EndDate input for this Choreo. ((optional, string) Ending date and time to for which to process transactions stats. Defaults to current date and time in UTC.)
        """
        super(StatsInputSet, self)._set_input('EndDate', value)
    def set_StartDate(self, value):
        """
        Set the value of the StartDate input for this Choreo. ((optional, string) Starting date and time to for which to process transactions stats. Defaults to 0300 of the current day in UTC.)
        """
        super(StatsInputSet, self)._set_input('StartDate', value)
    def set_Types(self, value):
        """
        Set the value of the Types input for this Choreo. ((optional, string) Types of status to retrieve. Must be comma delimited. Options are TransactionsCount and TransactionsTotal. Defaults to include all stats.)
        """
        super(StatsInputSet, self)._set_input('Types', value)

class StatsResultSet(ResultSet):
    """
    A ResultSet with methods tailored to the values returned by the Stats Choreo.
    The ResultSet object is used to retrieve the results of a Choreo execution.
    """

    def getJSONFromString(self, str):
        return json.loads(str)

    def get_Response(self):
        """
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Dwolla.)
        """
        return self._output.get('Response', None)

class StatsChoreographyExecution(ChoreographyExecution):

    def _make_result_set(self, response, path):
        return StatsResultSet(response, path)
