# -*- coding: utf-8 -*-

###############################################################################
#
# ConvertLead
# Converts a lead to a potential, account, or contact in your Zoho CRM account.
#
# Python versions 2.6, 2.7, 3.x
#
# Copyright 2014, Temboo Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
# either express or implied. See the License for the specific
# language governing permissions and limitations under the License.
#
#
###############################################################################

from temboo.core.choreography import Choreography
from temboo.core.choreography import InputSet
from temboo.core.choreography import ResultSet
from temboo.core.choreography import ChoreographyExecution

import json

class ConvertLead(Choreography):

    def __init__(self, temboo_session):
        """
        Create a new instance of the ConvertLead Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
        """
        super(ConvertLead, self).__init__(temboo_session, '/Library/Zoho/CRM/ConvertLead')


    def new_input_set(self):
        return ConvertLeadInputSet()

    def _make_result_set(self, result, path):
        return ConvertLeadResultSet(result, path)

    def _make_execution(self, session, exec_id, path):
        return ConvertLeadChoreographyExecution(session, exec_id, path)

class ConvertLeadInputSet(InputSet):
    """
    An InputSet with methods appropriate for specifying the inputs to the ConvertLead
    Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
    """
    def set_Amount(self, value):
        """
        Set the value of the Amount input for this Choreo. ((conditional, decimal) Corresponds to the Amount field in Zoho. Required if CreatePotential is set to 1.)
        """
        super(ConvertLeadInputSet, self)._set_input('Amount', value)
    def set_AssignTo(self, value):
        """
        Set the value of the AssignTo input for this Choreo. ((optional, string) Corresponds to the Assign To field in Zoho)
        """
        super(ConvertLeadInputSet, self)._set_input('AssignTo', value)
    def set_AuthenticationToken(self, value):
        """
        Set the value of the AuthenticationToken input for this Choreo. ((required, string) A valid authentication token. Permanent authentication tokens can be generated by the GenerateAuthToken Choreo.)
        """
        super(ConvertLeadInputSet, self)._set_input('AuthenticationToken', value)
    def set_ClosingDate(self, value):
        """
        Set the value of the ClosingDate input for this Choreo. ((conditional, date) Corresponds to the Closing Date field in Zoho. Formatted like MM/dd/yyyy. Required if CreatePotential is set to 1.)
        """
        super(ConvertLeadInputSet, self)._set_input('ClosingDate', value)
    def set_ContactRole(self, value):
        """
        Set the value of the ContactRole input for this Choreo. ((conditional, string) Corresponds to the Contact Role field in Zoho. Required if CreatePotential is set to 1.)
        """
        super(ConvertLeadInputSet, self)._set_input('ContactRole', value)
    def set_CreatePotential(self, value):
        """
        Set the value of the CreatePotential input for this Choreo. ((optional, boolean) Whether or not to create a potential)
        """
        super(ConvertLeadInputSet, self)._set_input('CreatePotential', value)
    def set_ID(self, value):
        """
        Set the value of the ID input for this Choreo. ((required, integer) The ID for the lead that you wish to convert to a potential)
        """
        super(ConvertLeadInputSet, self)._set_input('ID', value)
    def set_NotifyLeadOwner(self, value):
        """
        Set the value of the NotifyLeadOwner input for this Choreo. ((optional, boolean) Whether or not to notifiy the lead owner. Defaults to 0 for false.)
        """
        super(ConvertLeadInputSet, self)._set_input('NotifyLeadOwner', value)
    def set_NotifyNewEntityOwner(self, value):
        """
        Set the value of the NotifyNewEntityOwner input for this Choreo. ((optional, boolean) Whether or not to notify the new entity owner. Defaults to 0 for false.)
        """
        super(ConvertLeadInputSet, self)._set_input('NotifyNewEntityOwner', value)
    def set_PotentialName(self, value):
        """
        Set the value of the PotentialName input for this Choreo. ((conditional, string) Corresponds to the Potential Name field in Zoho. Required if CreatePotential is set to 1.)
        """
        super(ConvertLeadInputSet, self)._set_input('PotentialName', value)
    def set_PotentialStage(self, value):
        """
        Set the value of the PotentialStage input for this Choreo. ((conditional, string) Corresponds to the Potential Stage field in Zoho. Required if CreatePotential is set to 1.)
        """
        super(ConvertLeadInputSet, self)._set_input('PotentialStage', value)
    def set_Probability(self, value):
        """
        Set the value of the Probability input for this Choreo. ((conditional, integer) Corresponds to the Probability field in Zoho. Required if CreatePotential is set to 1.)
        """
        super(ConvertLeadInputSet, self)._set_input('Probability', value)
    def set_ResponseFormat(self, value):
        """
        Set the value of the ResponseFormat input for this Choreo. ((optional, string) The format that the response should be in. Valid formats are: json and xml (the default).)
        """
        super(ConvertLeadInputSet, self)._set_input('ResponseFormat', value)

class ConvertLeadResultSet(ResultSet):
    """
    A ResultSet with methods tailored to the values returned by the ConvertLead Choreo.
    The ResultSet object is used to retrieve the results of a Choreo execution.
    """

    def getJSONFromString(self, str):
        return json.loads(str)

    def get_Response(self):
        """
        Retrieve the value for the "Response" output from this Choreo execution. (The response from Zoho. Format corresponds to the ResponseFormat input. Defaults to xml.)
        """
        return self._output.get('Response', None)

class ConvertLeadChoreographyExecution(ChoreographyExecution):

    def _make_result_set(self, response, path):
        return ConvertLeadResultSet(response, path)
