# -*- coding: utf-8 -*-

###############################################################################
#
# GetRecentNewsItems
# Retrieves recent news items.
#
# Python versions 2.6, 2.7, 3.x
#
# Copyright 2014, Temboo Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
# either express or implied. See the License for the specific
# language governing permissions and limitations under the License.
#
#
###############################################################################

from temboo.core.choreography import Choreography
from temboo.core.choreography import InputSet
from temboo.core.choreography import ResultSet
from temboo.core.choreography import ChoreographyExecution

import json

class GetRecentNewsItems(Choreography):

    def __init__(self, temboo_session):
        """
        Create a new instance of the GetRecentNewsItems Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
        """
        super(GetRecentNewsItems, self).__init__(temboo_session, '/Library/NYTimes/TimesNewswire/GetRecentNewsItems')


    def new_input_set(self):
        return GetRecentNewsItemsInputSet()

    def _make_result_set(self, result, path):
        return GetRecentNewsItemsResultSet(result, path)

    def _make_execution(self, session, exec_id, path):
        return GetRecentNewsItemsChoreographyExecution(session, exec_id, path)

class GetRecentNewsItemsInputSet(InputSet):
    """
    An InputSet with methods appropriate for specifying the inputs to the GetRecentNewsItems
    Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
    """
    def set_APIKey(self, value):
        """
        Set the value of the APIKey input for this Choreo. ((required, string) The API Key provided by NY Times.)
        """
        super(GetRecentNewsItemsInputSet, self)._set_input('APIKey', value)
    def set_Limit(self, value):
        """
        Set the value of the Limit input for this Choreo. ((optional, integer) The number of results to return. Defaults to 20.)
        """
        super(GetRecentNewsItemsInputSet, self)._set_input('Limit', value)
    def set_Offset(self, value):
        """
        Set the value of the Offset input for this Choreo. ((optional, integer) A numeric value indicating the starting point of the result set. This can be used in combination with the Limit input to page through results.)
        """
        super(GetRecentNewsItemsInputSet, self)._set_input('Offset', value)
    def set_ResponseFormat(self, value):
        """
        Set the value of the ResponseFormat input for this Choreo. ((optional, string) The format that the response should be in. Valid values are: json (the default) and xml.)
        """
        super(GetRecentNewsItemsInputSet, self)._set_input('ResponseFormat', value)
    def set_Section(self, value):
        """
        Set the value of the Section input for this Choreo. ((optional, string) Limits the set of items by one or more sections. Separate sections by semicolons. Defaults to "all" to get all sections. See Choreo documentation for more options for this input.)
        """
        super(GetRecentNewsItemsInputSet, self)._set_input('Section', value)
    def set_Source(self, value):
        """
        Set the value of the Source input for this Choreo. ((optional, string) Limits the set of items by originating source. Set to "nyt" for New York Times items only and "iht" for International Herald Tribune items. Set to "all" for both (the default).)
        """
        super(GetRecentNewsItemsInputSet, self)._set_input('Source', value)
    def set_TimePeriod(self, value):
        """
        Set the value of the TimePeriod input for this Choreo. ((optional, integer) Limits the set of items by time published. Valid range is number of hours, 1–720 (in hours). Defaults to 24.)
        """
        super(GetRecentNewsItemsInputSet, self)._set_input('TimePeriod', value)

class GetRecentNewsItemsResultSet(ResultSet):
    """
    A ResultSet with methods tailored to the values returned by the GetRecentNewsItems Choreo.
    The ResultSet object is used to retrieve the results of a Choreo execution.
    """

    def getJSONFromString(self, str):
        return json.loads(str)

    def get_Response(self):
        """
        Retrieve the value for the "Response" output from this Choreo execution. (The response from the NY Times API.)
        """
        return self._output.get('Response', None)

class GetRecentNewsItemsChoreographyExecution(ChoreographyExecution):

    def _make_result_set(self, response, path):
        return GetRecentNewsItemsResultSet(response, path)
