# -*- coding: utf-8 -*-

###############################################################################
#
# SearchLoans
# Returns a keyword search for loan listings by multiple criteria.
#
# Python versions 2.6, 2.7, 3.x
#
# Copyright 2014, Temboo Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
# either express or implied. See the License for the specific
# language governing permissions and limitations under the License.
#
#
###############################################################################

from temboo.core.choreography import Choreography
from temboo.core.choreography import InputSet
from temboo.core.choreography import ResultSet
from temboo.core.choreography import ChoreographyExecution

import json

class SearchLoans(Choreography):

    def __init__(self, temboo_session):
        """
        Create a new instance of the SearchLoans Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
        """
        super(SearchLoans, self).__init__(temboo_session, '/Library/Kiva/Loans/SearchLoans')


    def new_input_set(self):
        return SearchLoansInputSet()

    def _make_result_set(self, result, path):
        return SearchLoansResultSet(result, path)

    def _make_execution(self, session, exec_id, path):
        return SearchLoansChoreographyExecution(session, exec_id, path)

class SearchLoansInputSet(InputSet):
    """
    An InputSet with methods appropriate for specifying the inputs to the SearchLoans
    Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
    """
    def set_AppID(self, value):
        """
        Set the value of the AppID input for this Choreo. ((optional, string) Your unique application ID, usually in reverse DNS notation.)
        """
        super(SearchLoansInputSet, self)._set_input('AppID', value)
    def set_CountryCode(self, value):
        """
        Set the value of the CountryCode input for this Choreo. ((optional, string) A list of two-character ISO codes of countries by which to filter results.)
        """
        super(SearchLoansInputSet, self)._set_input('CountryCode', value)
    def set_Gender(self, value):
        """
        Set the value of the Gender input for this Choreo. ((optional, string) If supplied, results are filtered to loans with entrepreneurs of the specified gender. In the case of group loans, this matches against the predominate gender in the group: male or female.)
        """
        super(SearchLoansInputSet, self)._set_input('Gender', value)
    def set_Page(self, value):
        """
        Set the value of the Page input for this Choreo. ((optional, integer) The page position of results to return. Defaults to 1.)
        """
        super(SearchLoansInputSet, self)._set_input('Page', value)
    def set_Partner(self, value):
        """
        Set the value of the Partner input for this Choreo. ((optional, string) A list of partner IDs for which to filter results.)
        """
        super(SearchLoansInputSet, self)._set_input('Partner', value)
    def set_Query(self, value):
        """
        Set the value of the Query input for this Choreo. ((optional, string) A query string against which results should be returned.)
        """
        super(SearchLoansInputSet, self)._set_input('Query', value)
    def set_Region(self, value):
        """
        Set the value of the Region input for this Choreo. ((optional, string) List of two-letter codes corresponding to regions in which Kiva operates. If supplied, results are filtered to loans only from the specified regions: na, ca, sa, af, as, me, ee.)
        """
        super(SearchLoansInputSet, self)._set_input('Region', value)
    def set_ResponseType(self, value):
        """
        Set the value of the ResponseType input for this Choreo. ((optional, string) Output returned can be XML or JSON. Defaults to JSON.)
        """
        super(SearchLoansInputSet, self)._set_input('ResponseType', value)
    def set_Sector(self, value):
        """
        Set the value of the Sector input for this Choreo. ((optional, string) A list of business sectors for which to filter results.)
        """
        super(SearchLoansInputSet, self)._set_input('Sector', value)
    def set_SortBy(self, value):
        """
        Set the value of the SortBy input for this Choreo. ((optional, string) The order by which to sort results. Acceptable values: popularity, loan_amount, oldest, expiration, newest, amount_remaining, repayment_term. Defaults to newest.)
        """
        super(SearchLoansInputSet, self)._set_input('SortBy', value)
    def set_Status(self, value):
        """
        Set the value of the Status input for this Choreo. ((optional, string) The status of loans to return: fundraising, funded, in_repayment, paid, ended_with_loss.)
        """
        super(SearchLoansInputSet, self)._set_input('Status', value)

class SearchLoansResultSet(ResultSet):
    """
    A ResultSet with methods tailored to the values returned by the SearchLoans Choreo.
    The ResultSet object is used to retrieve the results of a Choreo execution.
    """

    def getJSONFromString(self, str):
        return json.loads(str)

    def get_Response(self):
        """
        Retrieve the value for the "Response" output from this Choreo execution. (The response from Kiva.)
        """
        return self._output.get('Response', None)

class SearchLoansChoreographyExecution(ChoreographyExecution):

    def _make_result_set(self, response, path):
        return SearchLoansResultSet(response, path)
