# -*- coding: utf-8 -*-

###############################################################################
#
# PutBucketTagging
# Adds a set of billing tags to an existing bucket.
#
# Python versions 2.6, 2.7, 3.x
#
# Copyright 2014, Temboo Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
# either express or implied. See the License for the specific
# language governing permissions and limitations under the License.
#
#
###############################################################################

from temboo.core.choreography import Choreography
from temboo.core.choreography import InputSet
from temboo.core.choreography import ResultSet
from temboo.core.choreography import ChoreographyExecution

import json

class PutBucketTagging(Choreography):

    def __init__(self, temboo_session):
        """
        Create a new instance of the PutBucketTagging Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
        """
        super(PutBucketTagging, self).__init__(temboo_session, '/Library/Amazon/S3/PutBucketTagging')


    def new_input_set(self):
        return PutBucketTaggingInputSet()

    def _make_result_set(self, result, path):
        return PutBucketTaggingResultSet(result, path)

    def _make_execution(self, session, exec_id, path):
        return PutBucketTaggingChoreographyExecution(session, exec_id, path)

class PutBucketTaggingInputSet(InputSet):
    """
    An InputSet with methods appropriate for specifying the inputs to the PutBucketTagging
    Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
    """
    def set_Tags(self, value):
        """
        Set the value of the Tags input for this Choreo. ((optional, xml) An XML file describing the key/values for the tag set. Note - if you use this input, the Key and Value input variables will be ignored.)
        """
        super(PutBucketTaggingInputSet, self)._set_input('Tags', value)
    def set_AWSAccessKeyId(self, value):
        """
        Set the value of the AWSAccessKeyId input for this Choreo. ((required, string) The Access Key ID provided by Amazon Web Services.)
        """
        super(PutBucketTaggingInputSet, self)._set_input('AWSAccessKeyId', value)
    def set_AWSSecretKeyId(self, value):
        """
        Set the value of the AWSSecretKeyId input for this Choreo. ((required, string) The Secret Key ID provided by Amazon Web Services.)
        """
        super(PutBucketTaggingInputSet, self)._set_input('AWSSecretKeyId', value)
    def set_BucketName(self, value):
        """
        Set the value of the BucketName input for this Choreo. ((required, string) The name of the bucket to add tags to.)
        """
        super(PutBucketTaggingInputSet, self)._set_input('BucketName', value)
    def set_Key(self, value):
        """
        Set the value of the Key input for this Choreo. ((conditional, string) The tag name.)
        """
        super(PutBucketTaggingInputSet, self)._set_input('Key', value)
    def set_UserRegion(self, value):
        """
        Set the value of the UserRegion input for this Choreo. ((required, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".)
        """
        super(PutBucketTaggingInputSet, self)._set_input('UserRegion', value)
    def set_Value(self, value):
        """
        Set the value of the Value input for this Choreo. ((conditional, string) The tag value.)
        """
        super(PutBucketTaggingInputSet, self)._set_input('Value', value)

class PutBucketTaggingResultSet(ResultSet):
    """
    A ResultSet with methods tailored to the values returned by the PutBucketTagging Choreo.
    The ResultSet object is used to retrieve the results of a Choreo execution.
    """

    def getJSONFromString(self, str):
        return json.loads(str)

    def get_Response(self):
        """
        Retrieve the value for the "Response" output from this Choreo execution. (Stores the response from Amazon. Note that for a successful execution, no content is returned and this output variable should be empty.)
        """
        return self._output.get('Response', None)

class PutBucketTaggingChoreographyExecution(ChoreographyExecution):

    def _make_result_set(self, response, path):
        return PutBucketTaggingResultSet(response, path)
