# -*- coding: utf-8 -*-

###############################################################################
#
# GetLocationElevation
# Obtain elevation information for a path generated by a set of geo-coordinates.
#
# Python versions 2.6, 2.7, 3.x
#
# Copyright 2014, Temboo Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
# either express or implied. See the License for the specific
# language governing permissions and limitations under the License.
#
#
###############################################################################

from temboo.core.choreography import Choreography
from temboo.core.choreography import InputSet
from temboo.core.choreography import ResultSet
from temboo.core.choreography import ChoreographyExecution

import json

class GetLocationElevation(Choreography):

    def __init__(self, temboo_session):
        """
        Create a new instance of the GetLocationElevation Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
        """
        super(GetLocationElevation, self).__init__(temboo_session, '/Library/Google/Elevation/GetLocationElevation')


    def new_input_set(self):
        return GetLocationElevationInputSet()

    def _make_result_set(self, result, path):
        return GetLocationElevationResultSet(result, path)

    def _make_execution(self, session, exec_id, path):
        return GetLocationElevationChoreographyExecution(session, exec_id, path)

class GetLocationElevationInputSet(InputSet):
    """
    An InputSet with methods appropriate for specifying the inputs to the GetLocationElevation
    Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
    """
    def set_APIKey(self, value):
        """
        Set the value of the APIKey input for this Choreo. ((required, string) The API Key provided by Google.)
        """
        super(GetLocationElevationInputSet, self)._set_input('APIKey', value)
    def set_Locations(self, value):
        """
        Set the value of the Locations input for this Choreo. ((required, string) Enter the location(s) for which elevation data will be obtained.  Input formats: a single latitude/longitude coordinate pair; an array of coordinates separated by a |. A set of encoded coordinates.)
        """
        super(GetLocationElevationInputSet, self)._set_input('Locations', value)
    def set_ResponseFormat(self, value):
        """
        Set the value of the ResponseFormat input for this Choreo. ((optional, string) The format that response should be in. Can be set to xml or json. Defaults to json.)
        """
        super(GetLocationElevationInputSet, self)._set_input('ResponseFormat', value)
    def set_Sensor(self, value):
        """
        Set the value of the Sensor input for this Choreo. ((optional, boolean) Indicates whether or not the directions request is from a device with a location sensor. Value must be either 1 or 0. Defaults to 0 (false).)
        """
        super(GetLocationElevationInputSet, self)._set_input('Sensor', value)

class GetLocationElevationResultSet(ResultSet):
    """
    A ResultSet with methods tailored to the values returned by the GetLocationElevation Choreo.
    The ResultSet object is used to retrieve the results of a Choreo execution.
    """

    def getJSONFromString(self, str):
        return json.loads(str)

    def get_Response(self):
        """
        Retrieve the value for the "Response" output from this Choreo execution. ((xml) The response from Google.)
        """
        return self._output.get('Response', None)

class GetLocationElevationChoreographyExecution(ChoreographyExecution):

    def _make_result_set(self, response, path):
        return GetLocationElevationResultSet(response, path)
