# -*- coding: utf-8 -*-

###############################################################################
#
# GetFeedback
# Retrieves the feedback left for a specified user or the summary feedback data for a specific order line item or item listing.
#
# Python versions 2.6, 2.7, 3.x
#
# Copyright 2014, Temboo Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
# either express or implied. See the License for the specific
# language governing permissions and limitations under the License.
#
#
###############################################################################

from temboo.core.choreography import Choreography
from temboo.core.choreography import InputSet
from temboo.core.choreography import ResultSet
from temboo.core.choreography import ChoreographyExecution

import json

class GetFeedback(Choreography):

    def __init__(self, temboo_session):
        """
        Create a new instance of the GetFeedback Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
        """
        super(GetFeedback, self).__init__(temboo_session, '/Library/eBay/Trading/GetFeedback')


    def new_input_set(self):
        return GetFeedbackInputSet()

    def _make_result_set(self, result, path):
        return GetFeedbackResultSet(result, path)

    def _make_execution(self, session, exec_id, path):
        return GetFeedbackChoreographyExecution(session, exec_id, path)

class GetFeedbackInputSet(InputSet):
    """
    An InputSet with methods appropriate for specifying the inputs to the GetFeedback
    Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
    """
    def set_CommentType(self, value):
        """
        Set the value of the CommentType input for this Choreo. ((optional, string) Returns feedback of a specified type. Valid values are: Positive, Neutral, Negative, Withdrawn, IndependentlyWithdrawn.)
        """
        super(GetFeedbackInputSet, self)._set_input('CommentType', value)
    def set_DetailLevel(self, value):
        """
        Set the value of the DetailLevel input for this Choreo. ((optional, string) The response detail level. Valid values are: ReturnAll.)
        """
        super(GetFeedbackInputSet, self)._set_input('DetailLevel', value)
    def set_EntriesPerPage(self, value):
        """
        Set the value of the EntriesPerPage input for this Choreo. ((optional, integer) The maximum number of records to return in the result.)
        """
        super(GetFeedbackInputSet, self)._set_input('EntriesPerPage', value)
    def set_FeedbackID(self, value):
        """
        Set the value of the FeedbackID input for this Choreo. ((optional, string) An ID that uniquely identifies a feedback record to be retrieved)
        """
        super(GetFeedbackInputSet, self)._set_input('FeedbackID', value)
    def set_FeedbackType(self, value):
        """
        Set the value of the FeedbackType input for this Choreo. ((optional, string) The type of feedback to return. Valid values are: FeedbackReceivedAsSeller, FeedbackReceivedAsBuyer, FeedbackReceived, FeedbackLeft, CustomCode.)
        """
        super(GetFeedbackInputSet, self)._set_input('FeedbackType', value)
    def set_ItemID(self, value):
        """
        Set the value of the ItemID input for this Choreo. ((optional, string) The unique identifier for an eBay item listing.)
        """
        super(GetFeedbackInputSet, self)._set_input('ItemID', value)
    def set_OrderLineItemID(self, value):
        """
        Set the value of the OrderLineItemID input for this Choreo. ((optional, string) The unique identifier for an eBay order line item. This id generated by concatenating ItemID and TransactionID with a hyphen in between the IDs.)
        """
        super(GetFeedbackInputSet, self)._set_input('OrderLineItemID', value)
    def set_PageNumber(self, value):
        """
        Set the value of the PageNumber input for this Choreo. ((optional, integer) Specifies the page number of the results to return.)
        """
        super(GetFeedbackInputSet, self)._set_input('PageNumber', value)
    def set_ResponseFormat(self, value):
        """
        Set the value of the ResponseFormat input for this Choreo. ((optional, string) The format that the response should be in. Valid values are: json (the default) and xml.)
        """
        super(GetFeedbackInputSet, self)._set_input('ResponseFormat', value)
    def set_SandboxMode(self, value):
        """
        Set the value of the SandboxMode input for this Choreo. ((conditional, boolean) Indicates that the request should be made to the sandbox endpoint instead of the production endpoint. Set to 1 to enable sandbox mode.)
        """
        super(GetFeedbackInputSet, self)._set_input('SandboxMode', value)
    def set_SiteID(self, value):
        """
        Set the value of the SiteID input for this Choreo. ((optional, string) The eBay site ID that you want to access. Defaults to 0 indicating the US site.)
        """
        super(GetFeedbackInputSet, self)._set_input('SiteID', value)
    def set_TransactionID(self, value):
        """
        Set the value of the TransactionID input for this Choreo. ((optional, string) The unique identifier for an eBay order line item (transaction).)
        """
        super(GetFeedbackInputSet, self)._set_input('TransactionID', value)
    def set_UserID(self, value):
        """
        Set the value of the UserID input for this Choreo. ((conditional, string) The seller's UserID.)
        """
        super(GetFeedbackInputSet, self)._set_input('UserID', value)
    def set_UserToken(self, value):
        """
        Set the value of the UserToken input for this Choreo. ((required, string) A valid eBay Auth Token.)
        """
        super(GetFeedbackInputSet, self)._set_input('UserToken', value)

class GetFeedbackResultSet(ResultSet):
    """
    A ResultSet with methods tailored to the values returned by the GetFeedback Choreo.
    The ResultSet object is used to retrieve the results of a Choreo execution.
    """

    def getJSONFromString(self, str):
        return json.loads(str)

    def get_Response(self):
        """
        Retrieve the value for the "Response" output from this Choreo execution. (The response from eBay.)
        """
        return self._output.get('Response', None)

class GetFeedbackChoreographyExecution(ChoreographyExecution):

    def _make_result_set(self, response, path):
        return GetFeedbackResultSet(response, path)
