# -*- coding: utf-8 -*-

###############################################################################
#
# ListRecentPhotos
# Retrieve public photos that have been recently uploaded to Flickr.
#
# Python versions 2.6, 2.7, 3.x
#
# Copyright 2014, Temboo Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
# either express or implied. See the License for the specific
# language governing permissions and limitations under the License.
#
#
###############################################################################

from temboo.core.choreography import Choreography
from temboo.core.choreography import InputSet
from temboo.core.choreography import ResultSet
from temboo.core.choreography import ChoreographyExecution

import json

class ListRecentPhotos(Choreography):

    def __init__(self, temboo_session):
        """
        Create a new instance of the ListRecentPhotos Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
        """
        super(ListRecentPhotos, self).__init__(temboo_session, '/Library/Flickr/Photos/ListRecentPhotos')


    def new_input_set(self):
        return ListRecentPhotosInputSet()

    def _make_result_set(self, result, path):
        return ListRecentPhotosResultSet(result, path)

    def _make_execution(self, session, exec_id, path):
        return ListRecentPhotosChoreographyExecution(session, exec_id, path)

class ListRecentPhotosInputSet(InputSet):
    """
    An InputSet with methods appropriate for specifying the inputs to the ListRecentPhotos
    Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
    """
    def set_APIKey(self, value):
        """
        Set the value of the APIKey input for this Choreo. ((required, string) The API Key provided by Flickr (AKA the OAuth Consumer Key).)
        """
        super(ListRecentPhotosInputSet, self)._set_input('APIKey', value)
    def set_Extras(self, value):
        """
        Set the value of the Extras input for this Choreo. ((optional, string) A comma-separated list returning additional photo information such as: license, description, date_upload, date_taken.  Additional options are listed on this method's API doc page.)
        """
        super(ListRecentPhotosInputSet, self)._set_input('Extras', value)
    def set_Page(self, value):
        """
        Set the value of the Page input for this Choreo. ((optional, integer) Specify the page of photos that is to be returned.  If unspecified, the first page is returned.)
        """
        super(ListRecentPhotosInputSet, self)._set_input('Page', value)
    def set_PerPage(self, value):
        """
        Set the value of the PerPage input for this Choreo. ((optional, integer) Specify how many photos to display per page. Default is set to: 100. The mamimum allowed value is: 500.)
        """
        super(ListRecentPhotosInputSet, self)._set_input('PerPage', value)
    def set_ResponseFormat(self, value):
        """
        Set the value of the ResponseFormat input for this Choreo. ((optional, string) The format that the response should be in. Valid values are: xml and json. Defaults to json.)
        """
        super(ListRecentPhotosInputSet, self)._set_input('ResponseFormat', value)

class ListRecentPhotosResultSet(ResultSet):
    """
    A ResultSet with methods tailored to the values returned by the ListRecentPhotos Choreo.
    The ResultSet object is used to retrieve the results of a Choreo execution.
    """

    def getJSONFromString(self, str):
        return json.loads(str)

    def get_Response(self):
        """
        Retrieve the value for the "Response" output from this Choreo execution. (The response from Flickr.)
        """
        return self._output.get('Response', None)

class ListRecentPhotosChoreographyExecution(ChoreographyExecution):

    def _make_result_set(self, response, path):
        return ListRecentPhotosResultSet(response, path)
