package com.temboo.Library.Twitter.FriendsAndFollowers;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import processing.data.JSONArray;
import processing.data.JSONObject;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
FriendshipsShow

Returns detailed information about the relationship between two users.
*/
public class FriendshipsShow extends Choreography {

	/**
	Create a new instance of the FriendshipsShow Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public FriendshipsShow(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Twitter/FriendsAndFollowers/FriendshipsShow"));
	}

	/** 
	Set the value of the AccessToken input for this Choreo. 

	@param String - (required, string) The Access Token provided by Twitter or retrieved during the OAuth process.
	*/
	public void setAccessToken(String value) {
		this.inputs.setInput("AccessToken", value);
	}


	/** 
	Set the value of the AccessTokenSecret input for this Choreo. 

	@param String - (required, string) The Access Token Secret provided by Twitter or retrieved during the OAuth process.
	*/
	public void setAccessTokenSecret(String value) {
		this.inputs.setInput("AccessTokenSecret", value);
	}


	/** 
	Set the value of the ConsumerKey input for this Choreo. 

	@param String - (required, string) The API Key (or Consumer Key) provided by Twitter.
	*/
	public void setConsumerKey(String value) {
		this.inputs.setInput("ConsumerKey", value);
	}


	/** 
	Set the value of the ConsumerSecret input for this Choreo. 

	@param String - (required, string) The API Secret (or Consumer Secret) provided by Twitter.
	*/
	public void setConsumerSecret(String value) {
		this.inputs.setInput("ConsumerSecret", value);
	}


	/** 
	Set the value of the SourceScreenName input for this Choreo. 

	@param String - (conditional, string) The screen_name of the subject user. Required unless specifying the SourceUserID instead.
	*/
	public void setSourceScreenName(String value) {
		this.inputs.setInput("SourceScreenName", value);
	}


	/** 
	Set the value of the SourceUserID input for this Choreo. 

	@param String - (conditional, string) The ID of the subject user. Required unless specifying the SourceScreenName instead.
	*/
	public void setSourceUserID(String value) {
		this.inputs.setInput("SourceUserID", value);
	}


	/** 
	Set the value of the TargetScreenName input for this Choreo. 

	@param String - (conditional, string) The screen_name of the target user. Required unless specifying the TargetUserID instead.
	*/
	public void setTargetScreenName(String value) {
		this.inputs.setInput("TargetScreenName", value);
	}


	/** 
	Set the value of the TargetUserID input for this Choreo. 

	@param String - (conditional, string) The ID of the target user. Required unless specifying the TargetScreenName instead.
	*/
	public void setTargetUserID(String value) {
		this.inputs.setInput("TargetUserID", value);
	}


	
	/**
	 * Execute the Choreo, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 */
	@Override
	public FriendshipsShowResultSet run() {
		JSONObject result = super.runWithResults();
		return new FriendshipsShowResultSet(result);
	}
	
}
