package com.temboo.Library.Stripe.Coupons;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import processing.data.JSONArray;
import processing.data.JSONObject;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
CreateCoupon

Creates a coupon that can be redeemed by customers for a discount.
*/
public class CreateCoupon extends Choreography {

	/**
	Create a new instance of the CreateCoupon Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public CreateCoupon(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Stripe/Coupons/CreateCoupon"));
	}

	/** 
	Set the value of the APIKey input for this Choreo. 

	@param String - (required, string) The API Key provided by Stripe
	*/
	public void setAPIKey(String value) {
		this.inputs.setInput("APIKey", value);
	}


	/** 
	Set the value of the CouponID input for this Choreo. 

	@param String - (optional, string) The unique identifier of your choice for the coupon. If not specified, a random code will be generated by Stripe.
	*/
	public void setCouponID(String value) {
		this.inputs.setInput("CouponID", value);
	}


	/** 
	Set the value of the Duration input for this Choreo. 

	@param String - (required, string) Indicates how long the discount will be in effect. Valid values are: forever, once, repeating.
	*/
	public void setDuration(String value) {
		this.inputs.setInput("Duration", value);
	}


	/** 
	Set the value of the DurationInMonths input for this Choreo. 

	@param Integer - (optional, integer) If Duration is set to 'repeating', specify the number of months the discount will be valid.
	*/
	public void setDurationInMonths(Integer value) {
		this.inputs.setInput("DurationInMonths", value);
	}

	/** 
	Set the value of the DurationInMonths input for this Choreo as a String. 

	@param String - (optional, integer) If Duration is set to 'repeating', specify the number of months the discount will be valid.
	*/
	public void setDurationInMonths(String value) {
		this.inputs.setInput("DurationInMonths", value);	
	}
	/** 
	Set the value of the MaxRedemptions input for this Choreo. 

	@param Integer - (optional, integer) Specify the number times the coupon can be used.
	*/
	public void setMaxRedemptions(Integer value) {
		this.inputs.setInput("MaxRedemptions", value);
	}

	/** 
	Set the value of the MaxRedemptions input for this Choreo as a String. 

	@param String - (optional, integer) Specify the number times the coupon can be used.
	*/
	public void setMaxRedemptions(String value) {
		this.inputs.setInput("MaxRedemptions", value);	
	}
	/** 
	Set the value of the PercentOff input for this Choreo. 

	@param Integer - (required, integer) A integer between 1 and 100 that represents the discount that the coupon will apply when used by a customer
	*/
	public void setPercentOff(Integer value) {
		this.inputs.setInput("PercentOff", value);
	}

	/** 
	Set the value of the PercentOff input for this Choreo as a String. 

	@param String - (required, integer) A integer between 1 and 100 that represents the discount that the coupon will apply when used by a customer
	*/
	public void setPercentOff(String value) {
		this.inputs.setInput("PercentOff", value);	
	}
	/** 
	Set the value of the RedeemBy input for this Choreo. 

	@param String - (optional, date) An epoch timestamp in seconds representing the the last time at which the coupon can be used. Specify timestamp in UTC.
	*/
	public void setRedeemBy(String value) {
		this.inputs.setInput("RedeemBy", value);
	}


	
	/**
	 * Execute the Choreo, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 */
	@Override
	public CreateCouponResultSet run() {
		JSONObject result = super.runWithResults();
		return new CreateCouponResultSet(result);
	}
	
}
