package com.temboo.Library.ConstantContact;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import processing.data.JSONArray;
import processing.data.JSONObject;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
UpdateContact

Updates an existing contact in your Constant Contact system when you supply a contact ID to the Choreo.
*/
public class UpdateContact extends Choreography {

	/**
	Create a new instance of the UpdateContact Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public UpdateContact(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/ConstantContact/UpdateContact"));
	}

	/** 
	Set the value of the UpdatedContactXML input for this Choreo. 

	@param String - (required, xml) This input should be the updated XML returned from the ObtainContactInformation Choreo.
	*/
	public void setUpdatedContactXML(String value) {
		this.inputs.setInput("UpdatedContactXML", value);
	}


	/** 
	Set the value of the APIKey input for this Choreo. 

	@param String - (required, string) The API Key provided by Constant Contact.
	*/
	public void setAPIKey(String value) {
		this.inputs.setInput("APIKey", value);
	}


	/** 
	Set the value of the ContactId input for this Choreo. 

	@param Integer - (required, integer) The id for the contact you want to update.
	*/
	public void setContactId(Integer value) {
		this.inputs.setInput("ContactId", value);
	}

	/** 
	Set the value of the ContactId input for this Choreo as a String. 

	@param String - (required, integer) The id for the contact you want to update.
	*/
	public void setContactId(String value) {
		this.inputs.setInput("ContactId", value);	
	}
	/** 
	Set the value of the ListId input for this Choreo. 

	@param Integer - (required, integer) The ID for the list that you want to update
	*/
	public void setListId(Integer value) {
		this.inputs.setInput("ListId", value);
	}

	/** 
	Set the value of the ListId input for this Choreo as a String. 

	@param String - (required, integer) The ID for the list that you want to update
	*/
	public void setListId(String value) {
		this.inputs.setInput("ListId", value);	
	}
	/** 
	Set the value of the Password input for this Choreo. 

	@param String - (required, password) Your Constant Contact password.
	*/
	public void setPassword(String value) {
		this.inputs.setInput("Password", value);
	}


	/** 
	Set the value of the UserName input for this Choreo. 

	@param String - (required, string) You Constant Contact username.
	*/
	public void setUserName(String value) {
		this.inputs.setInput("UserName", value);
	}


	
	/**
	 * Execute the Choreo, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 */
	@Override
	public UpdateContactResultSet run() {
		JSONObject result = super.runWithResults();
		return new UpdateContactResultSet(result);
	}
	
}
