package com.temboo.Library.DarkSky;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import processing.data.JSONArray;
import processing.data.JSONObject;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetForecastByAddress

Returns the current weather conditions for a specified location by address.
*/
public class GetForecastByAddress extends Choreography {

	/**
	Create a new instance of the GetForecastByAddress Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetForecastByAddress(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/DarkSky/GetForecastByAddress"));
	}

	/** 
	Set the value of the APIKey input for this Choreo. 

	@param String - (required, string) The API Key provided by Dark Sky.
	*/
	public void setAPIKey(String value) {
		this.inputs.setInput("APIKey", value);
	}


	/** 
	Set the value of the Address input for this Choreo. 

	@param String - (required, string) The address of the location.
	*/
	public void setAddress(String value) {
		this.inputs.setInput("Address", value);
	}


	/** 
	Set the value of the Exclude input for this Choreo. 

	@param String - (optional, string) Exclude some number of data blocks from the API response. Valid values are: currently, minutely, hourly, daily, alerts, and flags.
	*/
	public void setExclude(String value) {
		this.inputs.setInput("Exclude", value);
	}


	/** 
	Set the value of the Extend input for this Choreo. 

	@param String - (optional, string) When present, returns hour-by-hour data for the next 168 hours, instead of the next 48. Valid value: hourly.
	*/
	public void setExtend(String value) {
		this.inputs.setInput("Extend", value);
	}


	/** 
	Set the value of the GeocodingAPIKey input for this Choreo. 

	@param String - (required, string) Your Google Geocoding API Key.
	*/
	public void setGeocodingAPIKey(String value) {
		this.inputs.setInput("GeocodingAPIKey", value);
	}


	/** 
	Set the value of the Language input for this Choreo. 

	@param String - (optional, string) The language in which to return results e.g., es, fr, it, en (the default). See Choreo notes for a link to a full list of supported languages.
	*/
	public void setLanguage(String value) {
		this.inputs.setInput("Language", value);
	}


	/** 
	Set the value of the Units input for this Choreo. 

	@param String - (optional, string) Return weather conditions in the requested units. Valid values are: auto, ca, uk2, us (use for Farenheit), and si (use for Celsius).
	*/
	public void setUnits(String value) {
		this.inputs.setInput("Units", value);
	}


	
	/**
	 * Execute the Choreo, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 */
	@Override
	public GetForecastByAddressResultSet run() {
		JSONObject result = super.runWithResults();
		return new GetForecastByAddressResultSet(result);
	}
	
}
