package com.temboo.Library.DarkSky;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import processing.data.JSONArray;
import processing.data.JSONObject;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
TimeMachineRequest

Returns the observed (in the past) or forecasted (in the future) hour-by-hour weather and daily weather conditions for a particular date.
*/
public class TimeMachineRequest extends Choreography {

	/**
	Create a new instance of the TimeMachineRequest Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public TimeMachineRequest(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/DarkSky/TimeMachineRequest"));
	}

	/** 
	Set the value of the APIKey input for this Choreo. 

	@param String - (required, string) The API Key provided by Dark Sky.
	*/
	public void setAPIKey(String value) {
		this.inputs.setInput("APIKey", value);
	}


	/** 
	Set the value of the Exclude input for this Choreo. 

	@param String - (optional, string) Exclude some number of data blocks from the API response. Valid values are: currently, minutely, hourly, daily, alerts, and flags.
	*/
	public void setExclude(String value) {
		this.inputs.setInput("Exclude", value);
	}


	/** 
	Set the value of the Extend input for this Choreo. 

	@param String - (optional, string) When present, returns hour-by-hour data for the next 168 hours, instead of the next 48. Valid value: hourly.
	*/
	public void setExtend(String value) {
		this.inputs.setInput("Extend", value);
	}


	/** 
	Set the value of the Language input for this Choreo. 

	@param String - (optional, string) The language in which to return results e.g., es, fr, it, en (the default). See Choreo notes for a link to a full list of supported languages.
	*/
	public void setLanguage(String value) {
		this.inputs.setInput("Language", value);
	}


	/** 
	Set the value of the Latitude input for this Choreo. 

	@param BigDecimal - (required, decimal) The latitude of the location.
	*/
	public void setLatitude(BigDecimal value) {
		this.inputs.setInput("Latitude", value);
	}

	/** 
	Set the value of the Latitude input for this Choreo as a String. 

	@param String - (required, decimal) The latitude of the location.
	*/
	public void setLatitude(String value) {
		this.inputs.setInput("Latitude", value);	
	}
	/** 
	Set the value of the Longitude input for this Choreo. 

	@param BigDecimal - (required, decimal) The longitude of the location.
	*/
	public void setLongitude(BigDecimal value) {
		this.inputs.setInput("Longitude", value);
	}

	/** 
	Set the value of the Longitude input for this Choreo as a String. 

	@param String - (required, decimal) The longitude of the location.
	*/
	public void setLongitude(String value) {
		this.inputs.setInput("Longitude", value);	
	}
	/** 
	Set the value of the Time input for this Choreo. 

	@param String - (required, date) A UNIX timestamp (seconds since midnight GMT on 1 Jan 1970) or a string formatted date e.g., 2016-03-05T15:48:56Z.
	*/
	public void setTime(String value) {
		this.inputs.setInput("Time", value);
	}


	/** 
	Set the value of the Units input for this Choreo. 

	@param String - (optional, string) Return weather conditions in the requested units. Valid values are: auto, ca, uk2, us (use for Farenheit), and si (use for Celsius).
	*/
	public void setUnits(String value) {
		this.inputs.setInput("Units", value);
	}


	
	/**
	 * Execute the Choreo, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 */
	@Override
	public TimeMachineRequestResultSet run() {
		JSONObject result = super.runWithResults();
		return new TimeMachineRequestResultSet(result);
	}
	
}
