package com.temboo.Library.Stripe.Plans;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import processing.data.JSONArray;
import processing.data.JSONObject;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
CreatePlan

Creates a subscription plan
*/
public class CreatePlan extends Choreography {

	/**
	Create a new instance of the CreatePlan Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public CreatePlan(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Stripe/Plans/CreatePlan"));
	}

	/** 
	Set the value of the APIKey input for this Choreo. 

	@param String - (required, string) The API Key provided by Stripe
	*/
	public void setAPIKey(String value) {
		this.inputs.setInput("APIKey", value);
	}


	/** 
	Set the value of the Amount input for this Choreo. 

	@param Integer - (required, integer) The amount in cents to charge on a recurring basis for subscribers of this plan
	*/
	public void setAmount(Integer value) {
		this.inputs.setInput("Amount", value);
	}

	/** 
	Set the value of the Amount input for this Choreo as a String. 

	@param String - (required, integer) The amount in cents to charge on a recurring basis for subscribers of this plan
	*/
	public void setAmount(String value) {
		this.inputs.setInput("Amount", value);	
	}
	/** 
	Set the value of the Currency input for this Choreo. 

	@param String - (optional, string) 3-letter ISO code for currency. Defaults to 'usd' which is currently the only supported currency.
	*/
	public void setCurrency(String value) {
		this.inputs.setInput("Currency", value);
	}


	/** 
	Set the value of the Interval input for this Choreo. 

	@param String - (required, string) Indicates billing frequency. Valid values are: month or year.
	*/
	public void setInterval(String value) {
		this.inputs.setInput("Interval", value);
	}


	/** 
	Set the value of the PlanID input for this Choreo. 

	@param String - (required, string) The unique identifier of the plan you want to create
	*/
	public void setPlanID(String value) {
		this.inputs.setInput("PlanID", value);
	}


	/** 
	Set the value of the PlanName input for this Choreo. 

	@param String - (required, string) The name of the plan which will be displayed in the Stripe web interface.
	*/
	public void setPlanName(String value) {
		this.inputs.setInput("PlanName", value);
	}


	/** 
	Set the value of the TrialPeriodDays input for this Choreo. 

	@param Integer - (optional, integer) The number of days in a trial period (customer will not be billed until the trial period is over)
	*/
	public void setTrialPeriodDays(Integer value) {
		this.inputs.setInput("TrialPeriodDays", value);
	}

	/** 
	Set the value of the TrialPeriodDays input for this Choreo as a String. 

	@param String - (optional, integer) The number of days in a trial period (customer will not be billed until the trial period is over)
	*/
	public void setTrialPeriodDays(String value) {
		this.inputs.setInput("TrialPeriodDays", value);	
	}
	
	/**
	 * Execute the Choreo, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 */
	@Override
	public CreatePlanResultSet run() {
		JSONObject result = super.runWithResults();
		return new CreatePlanResultSet(result);
	}
	
}
