package com.temboo.Library.Facebook.Deleting;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import processing.data.JSONArray;
import processing.data.JSONObject;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
Unlike

Allows a user to "unlike" a Graph API object.
*/
public class Unlike extends Choreography {

	/**
	Create a new instance of the Unlike Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public Unlike(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Facebook/Deleting/Unlike"));
	}

	/** 
	Set the value of the AccessToken input for this Choreo. 

	@param String - (required, string) The access token retrieved from the final step of the OAuth process.
	*/
	public void setAccessToken(String value) {
		this.inputs.setInput("AccessToken", value);
	}


	/** 
	Set the value of the ObjectID input for this Choreo. 

	@param String - (required, string) The id of a graph api object to unlike.
	*/
	public void setObjectID(String value) {
		this.inputs.setInput("ObjectID", value);
	}


	
	/**
	 * Execute the Choreo, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 */
	@Override
	public UnlikeResultSet run() {
		JSONObject result = super.runWithResults();
		return new UnlikeResultSet(result);
	}
	
}
