package com.temboo.Library.Wikipedia;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import processing.data.JSONArray;
import processing.data.JSONObject;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetPageSummary

Retrieves a summary response including a text extract of the first several sentences, as well as information about a thumbnail that represents the page.
*/
public class GetPageSummary extends Choreography {

	/**
	Create a new instance of the GetPageSummary Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetPageSummary(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Wikipedia/GetPageSummary"));
	}

	/** 
	Set the value of the Title input for this Choreo. 

	@param String - (required, string) The Wikipedia page title.
	*/
	public void setTitle(String value) {
		this.inputs.setInput("Title", value);
	}


	
	/**
	 * Execute the Choreo, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 */
	@Override
	public GetPageSummaryResultSet run() {
		JSONObject result = super.runWithResults();
		return new GetPageSummaryResultSet(result);
	}
	
}
