package com.temboo.Library.Utilities.TokenStorage;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import processing.data.JSONArray;
import processing.data.JSONObject;
import java.math.BigDecimal;
import com.temboo.core.Choreography.ResultSet;

	
/**
	A ResultSet with methods tailored to the values returned by the RetrieveToken Choreo.
	The ResultSet object is used to retrieve the results of a Choreo execution.
*/
public  class RetrieveTokenResultSet extends ResultSet {
		
	public RetrieveTokenResultSet(JSONObject doc) {
		super(doc);
	}

	/** 
	Retrieve the value for the "Token" output from this Choreo execution

	@return String - (string) The token value. This will return an empty string if there is no token or if the token has expired.
	*/
	public String getToken() {
		return this.getResultString("Token");
	}
	/** 
	Retrieve the value for the "Locked" output from this Choreo execution

	@return String - (boolean) Returns true or false depending on whether the token is locked or not.
	*/
	public String getLocked() {
		return this.getResultString("Locked");
	}
	/** 
	Retrieve the value for the "Valid" output from this Choreo execution

	@return String - (boolean) Returns true or false depending on whether the token is valid or not.
	*/
	public String getValid() {
		return this.getResultString("Valid");
	}
}