package com.temboo.Library.DarkSky;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import processing.data.JSONArray;
import processing.data.JSONObject;
import java.math.BigDecimal;
import com.temboo.core.Choreography.ResultSet;

	
/**
	A ResultSet with methods tailored to the values returned by the TimeMachineRequest Choreo.
	The ResultSet object is used to retrieve the results of a Choreo execution.
*/
public  class TimeMachineRequestResultSet extends ResultSet {
		
	public TimeMachineRequestResultSet(JSONObject doc) {
		super(doc);
	}

	/** 
	Retrieve the value for the "HourlySummary" output from this Choreo execution

	@return String - (string) The hourly summary.
	*/
	public String getHourlySummary() {
		return this.getResultString("HourlySummary");
	}
	/** 
	Retrieve the value for the "Humidity" output from this Choreo execution

	@return String - (decimal) The current humidity.
	*/
	public String getHumidity() {
		return this.getResultString("Humidity");
	}
	/** 
	Retrieve the value for the "Pressure" output from this Choreo execution

	@return String - (decimal) The current pressure.
	*/
	public String getPressure() {
		return this.getResultString("Pressure");
	}
	/** 
	Retrieve the value for the "Summary" output from this Choreo execution

	@return String - (string) The current weather summary.
	*/
	public String getSummary() {
		return this.getResultString("Summary");
	}
	/** 
	Retrieve the value for the "Temperature" output from this Choreo execution

	@return String - (decimal) The current temperature.
	*/
	public String getTemperature() {
		return this.getResultString("Temperature");
	}
	/** 
	Retrieve the value for the "UVIndex" output from this Choreo execution

	@return String - (integer) The current uv index.
	*/
	public String getUVIndex() {
		return this.getResultString("UVIndex");
	}
	/** 
	Retrieve the value for the "Visibility" output from this Choreo execution

	@return String - (decimal) The current visibility.
	*/
	public String getVisibility() {
		return this.getResultString("Visibility");
	}
	/** 
	Retrieve the value for the "Response" output from this Choreo execution

	@return String - (json) The response from Dark Sky.
	*/
	public String getResponse() {
		return this.getResultString("Response");
	}
}