<?php

/**
 * Temboo PHP SDK Facebook classes
 *
 * Execute Choreographies from the Temboo Facebook bundle.
 *
 * PHP version 5
 *
 * LICENSE: Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   Services
 * @package    Temboo
 * @subpackage Facebook
 * @author     Temboo, Inc.
 * @copyright  2013 Temboo, Inc.
 * @license    http://www.apache.org/licenses/LICENSE-2.0 Apache License 2.0
 * @link       http://www.temboo.com
 */
/**
 * Creates an action that represents a user quoting from a book.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Books_Quotes_CreateQuote extends Temboo_Choreography
{
    /**
     * Creates an action that represents a user quoting from a book.
     *
     * @param Temboo_Session $session The session that owns this CreateQuote Choreo.
     * @return Facebook_Actions_Books_Quotes_CreateQuote New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Actions/Books/Quotes/CreateQuote/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this CreateQuote Choreo.
     *
     * @param Facebook_Actions_Books_Quotes_CreateQuote_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Books_Quotes_CreateQuote_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Books_Quotes_CreateQuote_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Actions_Books_Quotes_CreateQuote_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this CreateQuote Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Books_Quotes_CreateQuote_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Actions_Books_Quotes_CreateQuote_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the CreateQuote Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Books_Quotes_CreateQuote_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the CreateQuote Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Books_Quotes_CreateQuote_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this CreateQuote input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Actions_Books_Quotes_CreateQuote_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Actions_Books_Quotes_CreateQuote_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this CreateQuote Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Actions_Books_Quotes_CreateQuote_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the Body input for this CreateQuote Choreo.
     *
     * @param string $value (required, string) The text of the quote.
     * @return Facebook_Actions_Books_Quotes_CreateQuote_Inputs For method chaining.
     */
    public function setBody($value)
    {
        return $this->set('Body', $value);
    }

    /**
     * Set the value for the Book input for this CreateQuote Choreo.
     *
     * @param string $value (required, string) The URL or ID for an Open Graph object representing the book.
     * @return Facebook_Actions_Books_Quotes_CreateQuote_Inputs For method chaining.
     */
    public function setBook($value)
    {
        return $this->set('Book', $value);
    }

    /**
     * Set the value for the CreatedTime input for this CreateQuote Choreo.
     *
     * @param string $value (optional, date) The time that the action was created (e.g. 2013-06-24T18:53:35+0000).
     * @return Facebook_Actions_Books_Quotes_CreateQuote_Inputs For method chaining.
     */
    public function setCreatedTime($value)
    {
        return $this->set('CreatedTime', $value);
    }

    /**
     * Set the value for the EndTime input for this CreateQuote Choreo.
     *
     * @param string $value (optional, date) The time that the user ended the action (e.g. 2013-06-24T18:53:35+0000).
     * @return Facebook_Actions_Books_Quotes_CreateQuote_Inputs For method chaining.
     */
    public function setEndTime($value)
    {
        return $this->set('EndTime', $value);
    }

    /**
     * Set the value for the ExpiresIn input for this CreateQuote Choreo.
     *
     * @param int $value (optional, integer) The amount of time (in milliseconds) from the publish_time that the action will expire.
     * @return Facebook_Actions_Books_Quotes_CreateQuote_Inputs For method chaining.
     */
    public function setExpiresIn($value)
    {
        return $this->set('ExpiresIn', $value);
    }

    /**
     * Set the value for the ExplicitlyShared input for this CreateQuote Choreo.
     *
     * @param bool $value (optional, boolean) Indicates that the user is explicitly sharing this action. Requires the explicitly_shared capability to be enabled.
     * @return Facebook_Actions_Books_Quotes_CreateQuote_Inputs For method chaining.
     */
    public function setExplicitlyShared($value)
    {
        return $this->set('ExplicitlyShared', $value);
    }

    /**
     * Set the value for the ExplicityShared input for this CreateQuote Choreo.
     *
     * @param bool $value (optional, boolean) Deprecated (retained for backward compatibility only).
     * @return Facebook_Actions_Books_Quotes_CreateQuote_Inputs For method chaining.
     */
    public function setExplicityShared($value)
    {
        return $this->set('ExplicityShared', $value);
    }

    /**
     * Set the value for the Message input for this CreateQuote Choreo.
     *
     * @param string $value (optional, string) A message attached to this action. Setting this parameter requires enabling of message capabilities.
     * @return Facebook_Actions_Books_Quotes_CreateQuote_Inputs For method chaining.
     */
    public function setMessage($value)
    {
        return $this->set('Message', $value);
    }

    /**
     * Set the value for the NoFeedStory input for this CreateQuote Choreo.
     *
     * @param bool $value (optional, boolean) Whether or not this action should be posted to the users feed.
     * @return Facebook_Actions_Books_Quotes_CreateQuote_Inputs For method chaining.
     */
    public function setNoFeedStory($value)
    {
        return $this->set('NoFeedStory', $value);
    }

    /**
     * Set the value for the Place input for this CreateQuote Choreo.
     *
     * @param string $value (optional, string) The URL or ID for an Open Graph object representing the location associated with this action.
     * @return Facebook_Actions_Books_Quotes_CreateQuote_Inputs For method chaining.
     */
    public function setPlace($value)
    {
        return $this->set('Place', $value);
    }

    /**
     * Set the value for the ProfileID input for this CreateQuote Choreo.
     *
     * @param string $value (optional, string) The id of the user's profile. Defaults to "me" indicating the authenticated user.
     * @return Facebook_Actions_Books_Quotes_CreateQuote_Inputs For method chaining.
     */
    public function setProfileID($value)
    {
        return $this->set('ProfileID', $value);
    }

    /**
     * Set the value for the Reference input for this CreateQuote Choreo.
     *
     * @param string $value (optional, string) A string identifier up to 50 characters used for tracking and insights.
     * @return Facebook_Actions_Books_Quotes_CreateQuote_Inputs For method chaining.
     */
    public function setReference($value)
    {
        return $this->set('Reference', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this CreateQuote Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Can be set to xml or json. Defaults to json.
     * @return Facebook_Actions_Books_Quotes_CreateQuote_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }

    /**
     * Set the value for the StartTime input for this CreateQuote Choreo.
     *
     * @param string $value (optional, date) The time that the user started the action (e.g. 2013-06-24T18:53:35+0000).
     * @return Facebook_Actions_Books_Quotes_CreateQuote_Inputs For method chaining.
     */
    public function setStartTime($value)
    {
        return $this->set('StartTime', $value);
    }

    /**
     * Set the value for the Tags input for this CreateQuote Choreo.
     *
     * @param string $value (optional, string) A comma separated list of other profile IDs that also performed this action.
     * @return Facebook_Actions_Books_Quotes_CreateQuote_Inputs For method chaining.
     */
    public function setTags($value)
    {
        return $this->set('Tags', $value);
    }
}


/**
 * Execution object for the CreateQuote Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Books_Quotes_CreateQuote_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the CreateQuote Choreo.
     *
     * @param Temboo_Session $session The session that owns this CreateQuote execution.
     * @param Facebook_Actions_Books_Quotes_CreateQuote $choreo The choreography object for this execution.
     * @param Facebook_Actions_Books_Quotes_CreateQuote_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Books_Quotes_CreateQuote_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Books_Quotes_CreateQuote_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Actions_Books_Quotes_CreateQuote $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this CreateQuote execution.
     *
     * @return Facebook_Actions_Books_Quotes_CreateQuote_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this CreateQuote execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Actions_Books_Quotes_CreateQuote_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Actions_Books_Quotes_CreateQuote_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the CreateQuote Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Books_Quotes_CreateQuote_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the CreateQuote Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Actions_Books_Quotes_CreateQuote_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "ActivityURL" output from this CreateQuote execution.
     *
     * @return string (string) The URL for the newly created action.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getActivityURL()
    {
        return $this->get('ActivityURL');
    }
    /**
     * Retrieve the value for the "Response" output from this CreateQuote execution.
     *
     * @return string The response from Facebook.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Deletes a given quote action.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Books_Quotes_DeleteQuote extends Temboo_Choreography
{
    /**
     * Deletes a given quote action.
     *
     * @param Temboo_Session $session The session that owns this DeleteQuote Choreo.
     * @return Facebook_Actions_Books_Quotes_DeleteQuote New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Actions/Books/Quotes/DeleteQuote/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this DeleteQuote Choreo.
     *
     * @param Facebook_Actions_Books_Quotes_DeleteQuote_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Books_Quotes_DeleteQuote_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Books_Quotes_DeleteQuote_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Actions_Books_Quotes_DeleteQuote_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this DeleteQuote Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Books_Quotes_DeleteQuote_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Actions_Books_Quotes_DeleteQuote_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the DeleteQuote Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Books_Quotes_DeleteQuote_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the DeleteQuote Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Books_Quotes_DeleteQuote_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this DeleteQuote input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Actions_Books_Quotes_DeleteQuote_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Actions_Books_Quotes_DeleteQuote_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this DeleteQuote Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Actions_Books_Quotes_DeleteQuote_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ActionID input for this DeleteQuote Choreo.
     *
     * @param string $value (required, string) The id of an action to delete.
     * @return Facebook_Actions_Books_Quotes_DeleteQuote_Inputs For method chaining.
     */
    public function setActionID($value)
    {
        return $this->set('ActionID', $value);
    }
}


/**
 * Execution object for the DeleteQuote Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Books_Quotes_DeleteQuote_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the DeleteQuote Choreo.
     *
     * @param Temboo_Session $session The session that owns this DeleteQuote execution.
     * @param Facebook_Actions_Books_Quotes_DeleteQuote $choreo The choreography object for this execution.
     * @param Facebook_Actions_Books_Quotes_DeleteQuote_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Books_Quotes_DeleteQuote_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Books_Quotes_DeleteQuote_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Actions_Books_Quotes_DeleteQuote $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this DeleteQuote execution.
     *
     * @return Facebook_Actions_Books_Quotes_DeleteQuote_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this DeleteQuote execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Actions_Books_Quotes_DeleteQuote_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Actions_Books_Quotes_DeleteQuote_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the DeleteQuote Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Books_Quotes_DeleteQuote_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the DeleteQuote Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Actions_Books_Quotes_DeleteQuote_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this DeleteQuote execution.
     *
     * @return bool (boolean) The response from Facebook. Returns "true" on success.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Retrieves one or more quote actions.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Books_Quotes_ReadQuotes extends Temboo_Choreography
{
    /**
     * Retrieves one or more quote actions.
     *
     * @param Temboo_Session $session The session that owns this ReadQuotes Choreo.
     * @return Facebook_Actions_Books_Quotes_ReadQuotes New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Actions/Books/Quotes/ReadQuotes/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this ReadQuotes Choreo.
     *
     * @param Facebook_Actions_Books_Quotes_ReadQuotes_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Books_Quotes_ReadQuotes_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Books_Quotes_ReadQuotes_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Actions_Books_Quotes_ReadQuotes_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this ReadQuotes Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Books_Quotes_ReadQuotes_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Actions_Books_Quotes_ReadQuotes_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the ReadQuotes Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Books_Quotes_ReadQuotes_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the ReadQuotes Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Books_Quotes_ReadQuotes_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this ReadQuotes input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Actions_Books_Quotes_ReadQuotes_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Actions_Books_Quotes_ReadQuotes_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this ReadQuotes Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Actions_Books_Quotes_ReadQuotes_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ActionID input for this ReadQuotes Choreo.
     *
     * @param string $value (optional, string) The id of an action to retrieve. If an id is not provided, a list of all quote actions will be returned.
     * @return Facebook_Actions_Books_Quotes_ReadQuotes_Inputs For method chaining.
     */
    public function setActionID($value)
    {
        return $this->set('ActionID', $value);
    }

    /**
     * Set the value for the Fields input for this ReadQuotes Choreo.
     *
     * @param string $value (optional, string) A comma separated list of fields to return (i.e. id,name).
     * @return Facebook_Actions_Books_Quotes_ReadQuotes_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Limit input for this ReadQuotes Choreo.
     *
     * @param int $value (optional, integer) Used to page through results. Limits the number of records returned in the response.
     * @return Facebook_Actions_Books_Quotes_ReadQuotes_Inputs For method chaining.
     */
    public function setLimit($value)
    {
        return $this->set('Limit', $value);
    }

    /**
     * Set the value for the Offset input for this ReadQuotes Choreo.
     *
     * @param int $value (optional, integer) Used to page through results. Returns results starting from the specified number.
     * @return Facebook_Actions_Books_Quotes_ReadQuotes_Inputs For method chaining.
     */
    public function setOffset($value)
    {
        return $this->set('Offset', $value);
    }

    /**
     * Set the value for the ProfileID input for this ReadQuotes Choreo.
     *
     * @param string $value (optional, string) The id of the user's profile. Defaults to "me" indicating the authenticated user.
     * @return Facebook_Actions_Books_Quotes_ReadQuotes_Inputs For method chaining.
     */
    public function setProfileID($value)
    {
        return $this->set('ProfileID', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this ReadQuotes Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Can be set to xml or json. Defaults to json.
     * @return Facebook_Actions_Books_Quotes_ReadQuotes_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }
}


/**
 * Execution object for the ReadQuotes Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Books_Quotes_ReadQuotes_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the ReadQuotes Choreo.
     *
     * @param Temboo_Session $session The session that owns this ReadQuotes execution.
     * @param Facebook_Actions_Books_Quotes_ReadQuotes $choreo The choreography object for this execution.
     * @param Facebook_Actions_Books_Quotes_ReadQuotes_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Books_Quotes_ReadQuotes_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Books_Quotes_ReadQuotes_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Actions_Books_Quotes_ReadQuotes $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this ReadQuotes execution.
     *
     * @return Facebook_Actions_Books_Quotes_ReadQuotes_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this ReadQuotes execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Actions_Books_Quotes_ReadQuotes_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Actions_Books_Quotes_ReadQuotes_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the ReadQuotes Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Books_Quotes_ReadQuotes_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the ReadQuotes Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Actions_Books_Quotes_ReadQuotes_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "HasNext" output from this ReadQuotes execution.
     *
     * @return bool (boolean) A boolean flag indicating that a next page exists.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getHasNext()
    {
        return $this->get('HasNext');
    }
    /**
     * Retrieve the value for the "HasPrevious" output from this ReadQuotes execution.
     *
     * @return bool (boolean) A boolean flag indicating that a previous page exists.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getHasPrevious()
    {
        return $this->get('HasPrevious');
    }
    /**
     * Retrieve the value for the "Response" output from this ReadQuotes execution.
     *
     * @return string The response from Facebook. Corresponds to the ResponseFormat input. Defaults to JSON.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Updates an existing quote action.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Books_Quotes_UpdateQuote extends Temboo_Choreography
{
    /**
     * Updates an existing quote action.
     *
     * @param Temboo_Session $session The session that owns this UpdateQuote Choreo.
     * @return Facebook_Actions_Books_Quotes_UpdateQuote New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Actions/Books/Quotes/UpdateQuote/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this UpdateQuote Choreo.
     *
     * @param Facebook_Actions_Books_Quotes_UpdateQuote_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Books_Quotes_UpdateQuote_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Books_Quotes_UpdateQuote_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Actions_Books_Quotes_UpdateQuote_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this UpdateQuote Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Books_Quotes_UpdateQuote_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Actions_Books_Quotes_UpdateQuote_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the UpdateQuote Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Books_Quotes_UpdateQuote_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the UpdateQuote Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Books_Quotes_UpdateQuote_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this UpdateQuote input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Actions_Books_Quotes_UpdateQuote_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Actions_Books_Quotes_UpdateQuote_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this UpdateQuote Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Actions_Books_Quotes_UpdateQuote_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ActionID input for this UpdateQuote Choreo.
     *
     * @param string $value (required, string) The id of the action to update.
     * @return Facebook_Actions_Books_Quotes_UpdateQuote_Inputs For method chaining.
     */
    public function setActionID($value)
    {
        return $this->set('ActionID', $value);
    }

    /**
     * Set the value for the Body input for this UpdateQuote Choreo.
     *
     * @param string $value (required, string) The text of the quote.
     * @return Facebook_Actions_Books_Quotes_UpdateQuote_Inputs For method chaining.
     */
    public function setBody($value)
    {
        return $this->set('Body', $value);
    }

    /**
     * Set the value for the Book input for this UpdateQuote Choreo.
     *
     * @param string $value (optional, string) The URL or ID for an Open Graph object representing the book.
     * @return Facebook_Actions_Books_Quotes_UpdateQuote_Inputs For method chaining.
     */
    public function setBook($value)
    {
        return $this->set('Book', $value);
    }

    /**
     * Set the value for the EndTime input for this UpdateQuote Choreo.
     *
     * @param string $value (optional, date) The time that the user ended the action (e.g. 2013-06-24T18:53:35+0000).
     * @return Facebook_Actions_Books_Quotes_UpdateQuote_Inputs For method chaining.
     */
    public function setEndTime($value)
    {
        return $this->set('EndTime', $value);
    }

    /**
     * Set the value for the ExpiresIn input for this UpdateQuote Choreo.
     *
     * @param int $value (optional, integer) The amount of time (in milliseconds) from the publish_time that the action will expire.
     * @return Facebook_Actions_Books_Quotes_UpdateQuote_Inputs For method chaining.
     */
    public function setExpiresIn($value)
    {
        return $this->set('ExpiresIn', $value);
    }

    /**
     * Set the value for the Message input for this UpdateQuote Choreo.
     *
     * @param string $value (optional, string) A message attached to this fitness action. Setting this parameter requires enabling of message capabilities.
     * @return Facebook_Actions_Books_Quotes_UpdateQuote_Inputs For method chaining.
     */
    public function setMessage($value)
    {
        return $this->set('Message', $value);
    }

    /**
     * Set the value for the Place input for this UpdateQuote Choreo.
     *
     * @param string $value (optional, string) The URL or ID for an Open Graph object representing the location associated with this action.
     * @return Facebook_Actions_Books_Quotes_UpdateQuote_Inputs For method chaining.
     */
    public function setPlace($value)
    {
        return $this->set('Place', $value);
    }

    /**
     * Set the value for the Tags input for this UpdateQuote Choreo.
     *
     * @param string $value (optional, string) A comma separated list of other profile IDs that also performed this action.
     * @return Facebook_Actions_Books_Quotes_UpdateQuote_Inputs For method chaining.
     */
    public function setTags($value)
    {
        return $this->set('Tags', $value);
    }
}


/**
 * Execution object for the UpdateQuote Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Books_Quotes_UpdateQuote_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the UpdateQuote Choreo.
     *
     * @param Temboo_Session $session The session that owns this UpdateQuote execution.
     * @param Facebook_Actions_Books_Quotes_UpdateQuote $choreo The choreography object for this execution.
     * @param Facebook_Actions_Books_Quotes_UpdateQuote_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Books_Quotes_UpdateQuote_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Books_Quotes_UpdateQuote_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Actions_Books_Quotes_UpdateQuote $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this UpdateQuote execution.
     *
     * @return Facebook_Actions_Books_Quotes_UpdateQuote_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this UpdateQuote execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Actions_Books_Quotes_UpdateQuote_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Actions_Books_Quotes_UpdateQuote_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the UpdateQuote Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Books_Quotes_UpdateQuote_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the UpdateQuote Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Actions_Books_Quotes_UpdateQuote_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this UpdateQuote execution.
     *
     * @return bool (boolean) The response from Facebook.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Creates an action that represents a user giving a book a rating.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Books_Rates_CreateRating extends Temboo_Choreography
{
    /**
     * Creates an action that represents a user giving a book a rating.
     *
     * @param Temboo_Session $session The session that owns this CreateRating Choreo.
     * @return Facebook_Actions_Books_Rates_CreateRating New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Actions/Books/Rates/CreateRating/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this CreateRating Choreo.
     *
     * @param Facebook_Actions_Books_Rates_CreateRating_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Books_Rates_CreateRating_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Books_Rates_CreateRating_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Actions_Books_Rates_CreateRating_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this CreateRating Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Books_Rates_CreateRating_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Actions_Books_Rates_CreateRating_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the CreateRating Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Books_Rates_CreateRating_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the CreateRating Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Books_Rates_CreateRating_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this CreateRating input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Actions_Books_Rates_CreateRating_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Actions_Books_Rates_CreateRating_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this CreateRating Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Actions_Books_Rates_CreateRating_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the Book input for this CreateRating Choreo.
     *
     * @param string $value (required, string) The URL or ID for an Open Graph object representing the book.
     * @return Facebook_Actions_Books_Rates_CreateRating_Inputs For method chaining.
     */
    public function setBook($value)
    {
        return $this->set('Book', $value);
    }

    /**
     * Set the value for the CreatedTime input for this CreateRating Choreo.
     *
     * @param string $value (optional, date) The time that the action was created (e.g. 2013-06-24T18:53:35+0000).
     * @return Facebook_Actions_Books_Rates_CreateRating_Inputs For method chaining.
     */
    public function setCreatedTime($value)
    {
        return $this->set('CreatedTime', $value);
    }

    /**
     * Set the value for the EndTime input for this CreateRating Choreo.
     *
     * @param string $value (optional, date) The time that the user ended the action (e.g. 2013-06-24T18:53:35+0000).
     * @return Facebook_Actions_Books_Rates_CreateRating_Inputs For method chaining.
     */
    public function setEndTime($value)
    {
        return $this->set('EndTime', $value);
    }

    /**
     * Set the value for the ExpiresIn input for this CreateRating Choreo.
     *
     * @param int $value (optional, integer) The amount of time (in milliseconds) from the publish_time that the action will expire.
     * @return Facebook_Actions_Books_Rates_CreateRating_Inputs For method chaining.
     */
    public function setExpiresIn($value)
    {
        return $this->set('ExpiresIn', $value);
    }

    /**
     * Set the value for the ExplicitlyShared input for this CreateRating Choreo.
     *
     * @param bool $value (optional, boolean) Indicates that the user is explicitly sharing this action. Requires the explicitly_shared capability to be enabled.
     * @return Facebook_Actions_Books_Rates_CreateRating_Inputs For method chaining.
     */
    public function setExplicitlyShared($value)
    {
        return $this->set('ExplicitlyShared', $value);
    }

    /**
     * Set the value for the ExplicityShared input for this CreateRating Choreo.
     *
     * @param bool $value (optional, boolean) Deprecated (retained for backward compatibility only).
     * @return Facebook_Actions_Books_Rates_CreateRating_Inputs For method chaining.
     */
    public function setExplicityShared($value)
    {
        return $this->set('ExplicityShared', $value);
    }

    /**
     * Set the value for the Message input for this CreateRating Choreo.
     *
     * @param string $value (optional, string) A message attached to this action. Setting this parameter requires enabling of message capabilities.
     * @return Facebook_Actions_Books_Rates_CreateRating_Inputs For method chaining.
     */
    public function setMessage($value)
    {
        return $this->set('Message', $value);
    }

    /**
     * Set the value for the NoFeedStory input for this CreateRating Choreo.
     *
     * @param bool $value (optional, boolean) Whether or not this action should be posted to the users feed.
     * @return Facebook_Actions_Books_Rates_CreateRating_Inputs For method chaining.
     */
    public function setNoFeedStory($value)
    {
        return $this->set('NoFeedStory', $value);
    }

    /**
     * Set the value for the Place input for this CreateRating Choreo.
     *
     * @param string $value (optional, string) The URL or ID for an Open Graph object representing the location associated with this action.
     * @return Facebook_Actions_Books_Rates_CreateRating_Inputs For method chaining.
     */
    public function setPlace($value)
    {
        return $this->set('Place', $value);
    }

    /**
     * Set the value for the ProfileID input for this CreateRating Choreo.
     *
     * @param string $value (optional, string) The id of the user's profile. Defaults to "me" indicating the authenticated user.
     * @return Facebook_Actions_Books_Rates_CreateRating_Inputs For method chaining.
     */
    public function setProfileID($value)
    {
        return $this->set('ProfileID', $value);
    }

    /**
     * Set the value for the RatingNormalizedValue input for this CreateRating Choreo.
     *
     * @param float $value (required, decimal) The rating expressed as a decimal value between 0 and 1.0.
     * @return Facebook_Actions_Books_Rates_CreateRating_Inputs For method chaining.
     */
    public function setRatingNormalizedValue($value)
    {
        return $this->set('RatingNormalizedValue', $value);
    }

    /**
     * Set the value for the RatingScale input for this CreateRating Choreo.
     *
     * @param int $value (required, integer) The highest possible value in the rating scale.
     * @return Facebook_Actions_Books_Rates_CreateRating_Inputs For method chaining.
     */
    public function setRatingScale($value)
    {
        return $this->set('RatingScale', $value);
    }

    /**
     * Set the value for the RatingValue input for this CreateRating Choreo.
     *
     * @param float $value (required, decimal) The value of the book rating.
     * @return Facebook_Actions_Books_Rates_CreateRating_Inputs For method chaining.
     */
    public function setRatingValue($value)
    {
        return $this->set('RatingValue', $value);
    }

    /**
     * Set the value for the Reference input for this CreateRating Choreo.
     *
     * @param string $value (optional, string) A string identifier up to 50 characters used for tracking and insights.
     * @return Facebook_Actions_Books_Rates_CreateRating_Inputs For method chaining.
     */
    public function setReference($value)
    {
        return $this->set('Reference', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this CreateRating Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Can be set to xml or json. Defaults to json.
     * @return Facebook_Actions_Books_Rates_CreateRating_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }

    /**
     * Set the value for the Review input for this CreateRating Choreo.
     *
     * @param string $value (optional, string) The URL or ID for an Open Graph object representing a book review.
     * @return Facebook_Actions_Books_Rates_CreateRating_Inputs For method chaining.
     */
    public function setReview($value)
    {
        return $this->set('Review', $value);
    }

    /**
     * Set the value for the ReviewText input for this CreateRating Choreo.
     *
     * @param string $value (conditional, string) The text content of the book review.
     * @return Facebook_Actions_Books_Rates_CreateRating_Inputs For method chaining.
     */
    public function setReviewText($value)
    {
        return $this->set('ReviewText', $value);
    }

    /**
     * Set the value for the StartTime input for this CreateRating Choreo.
     *
     * @param string $value (optional, date) The time that the user started the action (e.g. 2013-06-24T18:53:35+0000).
     * @return Facebook_Actions_Books_Rates_CreateRating_Inputs For method chaining.
     */
    public function setStartTime($value)
    {
        return $this->set('StartTime', $value);
    }

    /**
     * Set the value for the Tags input for this CreateRating Choreo.
     *
     * @param string $value (optional, string) A comma separated list of other profile IDs that also performed this action.
     * @return Facebook_Actions_Books_Rates_CreateRating_Inputs For method chaining.
     */
    public function setTags($value)
    {
        return $this->set('Tags', $value);
    }
}


/**
 * Execution object for the CreateRating Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Books_Rates_CreateRating_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the CreateRating Choreo.
     *
     * @param Temboo_Session $session The session that owns this CreateRating execution.
     * @param Facebook_Actions_Books_Rates_CreateRating $choreo The choreography object for this execution.
     * @param Facebook_Actions_Books_Rates_CreateRating_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Books_Rates_CreateRating_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Books_Rates_CreateRating_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Actions_Books_Rates_CreateRating $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this CreateRating execution.
     *
     * @return Facebook_Actions_Books_Rates_CreateRating_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this CreateRating execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Actions_Books_Rates_CreateRating_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Actions_Books_Rates_CreateRating_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the CreateRating Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Books_Rates_CreateRating_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the CreateRating Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Actions_Books_Rates_CreateRating_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "ActivityURL" output from this CreateRating execution.
     *
     * @return string (string) The URL for the newly created action.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getActivityURL()
    {
        return $this->get('ActivityURL');
    }
    /**
     * Retrieve the value for the "Response" output from this CreateRating execution.
     *
     * @return string The response from Facebook.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Deletes a given book rating action.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Books_Rates_DeleteRating extends Temboo_Choreography
{
    /**
     * Deletes a given book rating action.
     *
     * @param Temboo_Session $session The session that owns this DeleteRating Choreo.
     * @return Facebook_Actions_Books_Rates_DeleteRating New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Actions/Books/Rates/DeleteRating/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this DeleteRating Choreo.
     *
     * @param Facebook_Actions_Books_Rates_DeleteRating_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Books_Rates_DeleteRating_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Books_Rates_DeleteRating_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Actions_Books_Rates_DeleteRating_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this DeleteRating Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Books_Rates_DeleteRating_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Actions_Books_Rates_DeleteRating_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the DeleteRating Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Books_Rates_DeleteRating_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the DeleteRating Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Books_Rates_DeleteRating_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this DeleteRating input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Actions_Books_Rates_DeleteRating_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Actions_Books_Rates_DeleteRating_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this DeleteRating Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Actions_Books_Rates_DeleteRating_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ActionID input for this DeleteRating Choreo.
     *
     * @param string $value (required, string) The id of an action to delete.
     * @return Facebook_Actions_Books_Rates_DeleteRating_Inputs For method chaining.
     */
    public function setActionID($value)
    {
        return $this->set('ActionID', $value);
    }
}


/**
 * Execution object for the DeleteRating Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Books_Rates_DeleteRating_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the DeleteRating Choreo.
     *
     * @param Temboo_Session $session The session that owns this DeleteRating execution.
     * @param Facebook_Actions_Books_Rates_DeleteRating $choreo The choreography object for this execution.
     * @param Facebook_Actions_Books_Rates_DeleteRating_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Books_Rates_DeleteRating_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Books_Rates_DeleteRating_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Actions_Books_Rates_DeleteRating $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this DeleteRating execution.
     *
     * @return Facebook_Actions_Books_Rates_DeleteRating_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this DeleteRating execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Actions_Books_Rates_DeleteRating_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Actions_Books_Rates_DeleteRating_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the DeleteRating Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Books_Rates_DeleteRating_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the DeleteRating Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Actions_Books_Rates_DeleteRating_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this DeleteRating execution.
     *
     * @return bool (boolean) The response from Facebook. Returns "true" on success.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Retrieves one or more book rating actions.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Books_Rates_ReadRatings extends Temboo_Choreography
{
    /**
     * Retrieves one or more book rating actions.
     *
     * @param Temboo_Session $session The session that owns this ReadRatings Choreo.
     * @return Facebook_Actions_Books_Rates_ReadRatings New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Actions/Books/Rates/ReadRatings/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this ReadRatings Choreo.
     *
     * @param Facebook_Actions_Books_Rates_ReadRatings_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Books_Rates_ReadRatings_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Books_Rates_ReadRatings_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Actions_Books_Rates_ReadRatings_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this ReadRatings Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Books_Rates_ReadRatings_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Actions_Books_Rates_ReadRatings_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the ReadRatings Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Books_Rates_ReadRatings_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the ReadRatings Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Books_Rates_ReadRatings_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this ReadRatings input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Actions_Books_Rates_ReadRatings_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Actions_Books_Rates_ReadRatings_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this ReadRatings Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Actions_Books_Rates_ReadRatings_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ActionID input for this ReadRatings Choreo.
     *
     * @param string $value (optional, string) The id of an action to retrieve. If an id is not provided, a list of all rate actions will be returned.
     * @return Facebook_Actions_Books_Rates_ReadRatings_Inputs For method chaining.
     */
    public function setActionID($value)
    {
        return $this->set('ActionID', $value);
    }

    /**
     * Set the value for the Fields input for this ReadRatings Choreo.
     *
     * @param string $value (optional, string) A comma separated list of fields to return (i.e. id,name).
     * @return Facebook_Actions_Books_Rates_ReadRatings_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Limit input for this ReadRatings Choreo.
     *
     * @param int $value (optional, integer) Used to page through results. Limits the number of records returned in the response.
     * @return Facebook_Actions_Books_Rates_ReadRatings_Inputs For method chaining.
     */
    public function setLimit($value)
    {
        return $this->set('Limit', $value);
    }

    /**
     * Set the value for the Offset input for this ReadRatings Choreo.
     *
     * @param int $value (optional, integer) Used to page through results. Returns results starting from the specified number.
     * @return Facebook_Actions_Books_Rates_ReadRatings_Inputs For method chaining.
     */
    public function setOffset($value)
    {
        return $this->set('Offset', $value);
    }

    /**
     * Set the value for the ProfileID input for this ReadRatings Choreo.
     *
     * @param string $value (optional, string) The id of the user's profile. Defaults to "me" indicating the authenticated user.
     * @return Facebook_Actions_Books_Rates_ReadRatings_Inputs For method chaining.
     */
    public function setProfileID($value)
    {
        return $this->set('ProfileID', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this ReadRatings Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Can be set to xml or json. Defaults to json.
     * @return Facebook_Actions_Books_Rates_ReadRatings_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }
}


/**
 * Execution object for the ReadRatings Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Books_Rates_ReadRatings_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the ReadRatings Choreo.
     *
     * @param Temboo_Session $session The session that owns this ReadRatings execution.
     * @param Facebook_Actions_Books_Rates_ReadRatings $choreo The choreography object for this execution.
     * @param Facebook_Actions_Books_Rates_ReadRatings_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Books_Rates_ReadRatings_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Books_Rates_ReadRatings_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Actions_Books_Rates_ReadRatings $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this ReadRatings execution.
     *
     * @return Facebook_Actions_Books_Rates_ReadRatings_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this ReadRatings execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Actions_Books_Rates_ReadRatings_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Actions_Books_Rates_ReadRatings_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the ReadRatings Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Books_Rates_ReadRatings_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the ReadRatings Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Actions_Books_Rates_ReadRatings_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "HasNext" output from this ReadRatings execution.
     *
     * @return bool (boolean) A boolean flag indicating that a next page exists.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getHasNext()
    {
        return $this->get('HasNext');
    }
    /**
     * Retrieve the value for the "HasPrevious" output from this ReadRatings execution.
     *
     * @return bool (boolean) A boolean flag indicating that a previous page exists.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getHasPrevious()
    {
        return $this->get('HasPrevious');
    }
    /**
     * Retrieve the value for the "Response" output from this ReadRatings execution.
     *
     * @return string The response from Facebook. Corresponds to the ResponseFormat input. Defaults to JSON.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Updates an existing book rating action.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Books_Rates_UpdateRating extends Temboo_Choreography
{
    /**
     * Updates an existing book rating action.
     *
     * @param Temboo_Session $session The session that owns this UpdateRating Choreo.
     * @return Facebook_Actions_Books_Rates_UpdateRating New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Actions/Books/Rates/UpdateRating/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this UpdateRating Choreo.
     *
     * @param Facebook_Actions_Books_Rates_UpdateRating_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Books_Rates_UpdateRating_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Books_Rates_UpdateRating_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Actions_Books_Rates_UpdateRating_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this UpdateRating Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Books_Rates_UpdateRating_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Actions_Books_Rates_UpdateRating_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the UpdateRating Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Books_Rates_UpdateRating_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the UpdateRating Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Books_Rates_UpdateRating_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this UpdateRating input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Actions_Books_Rates_UpdateRating_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Actions_Books_Rates_UpdateRating_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this UpdateRating Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Actions_Books_Rates_UpdateRating_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ActionID input for this UpdateRating Choreo.
     *
     * @param string $value (required, string) The id of the action to update.
     * @return Facebook_Actions_Books_Rates_UpdateRating_Inputs For method chaining.
     */
    public function setActionID($value)
    {
        return $this->set('ActionID', $value);
    }

    /**
     * Set the value for the Book input for this UpdateRating Choreo.
     *
     * @param string $value (optional, string) The URL or ID for an Open Graph object representing the book.
     * @return Facebook_Actions_Books_Rates_UpdateRating_Inputs For method chaining.
     */
    public function setBook($value)
    {
        return $this->set('Book', $value);
    }

    /**
     * Set the value for the EndTime input for this UpdateRating Choreo.
     *
     * @param string $value (optional, date) The time that the user ended the action (e.g. 2013-06-24T18:53:35+0000).
     * @return Facebook_Actions_Books_Rates_UpdateRating_Inputs For method chaining.
     */
    public function setEndTime($value)
    {
        return $this->set('EndTime', $value);
    }

    /**
     * Set the value for the ExpiresIn input for this UpdateRating Choreo.
     *
     * @param int $value (optional, integer) The amount of time (in milliseconds) from the publish_time that the action will expire.
     * @return Facebook_Actions_Books_Rates_UpdateRating_Inputs For method chaining.
     */
    public function setExpiresIn($value)
    {
        return $this->set('ExpiresIn', $value);
    }

    /**
     * Set the value for the Message input for this UpdateRating Choreo.
     *
     * @param string $value (optional, string) The id of the user's profile. Defaults to "me" indicating the authenticated user.
     * @return Facebook_Actions_Books_Rates_UpdateRating_Inputs For method chaining.
     */
    public function setMessage($value)
    {
        return $this->set('Message', $value);
    }

    /**
     * Set the value for the Place input for this UpdateRating Choreo.
     *
     * @param string $value (optional, string) The URL or ID for an Open Graph object representing the location associated with this action.
     * @return Facebook_Actions_Books_Rates_UpdateRating_Inputs For method chaining.
     */
    public function setPlace($value)
    {
        return $this->set('Place', $value);
    }

    /**
     * Set the value for the RatingNormalizedValue input for this UpdateRating Choreo.
     *
     * @param float $value (optional, decimal) The rating expressed as a decimal value between 0 and 1.0.
     * @return Facebook_Actions_Books_Rates_UpdateRating_Inputs For method chaining.
     */
    public function setRatingNormalizedValue($value)
    {
        return $this->set('RatingNormalizedValue', $value);
    }

    /**
     * Set the value for the RatingScale input for this UpdateRating Choreo.
     *
     * @param int $value (optional, integer) The highest possible value in the rating scale.
     * @return Facebook_Actions_Books_Rates_UpdateRating_Inputs For method chaining.
     */
    public function setRatingScale($value)
    {
        return $this->set('RatingScale', $value);
    }

    /**
     * Set the value for the RatingValue input for this UpdateRating Choreo.
     *
     * @param float $value (optional, decimal) The value of the book rating.
     * @return Facebook_Actions_Books_Rates_UpdateRating_Inputs For method chaining.
     */
    public function setRatingValue($value)
    {
        return $this->set('RatingValue', $value);
    }

    /**
     * Set the value for the Review input for this UpdateRating Choreo.
     *
     * @param string $value (optional, string) The URL or ID for an Open Graph object representing a book review.
     * @return Facebook_Actions_Books_Rates_UpdateRating_Inputs For method chaining.
     */
    public function setReview($value)
    {
        return $this->set('Review', $value);
    }

    /**
     * Set the value for the ReviewText input for this UpdateRating Choreo.
     *
     * @param string $value (optional, string) The text content of the book review.
     * @return Facebook_Actions_Books_Rates_UpdateRating_Inputs For method chaining.
     */
    public function setReviewText($value)
    {
        return $this->set('ReviewText', $value);
    }

    /**
     * Set the value for the Tags input for this UpdateRating Choreo.
     *
     * @param string $value (optional, string) A comma separated list of other profile IDs that also performed this action.
     * @return Facebook_Actions_Books_Rates_UpdateRating_Inputs For method chaining.
     */
    public function setTags($value)
    {
        return $this->set('Tags', $value);
    }
}


/**
 * Execution object for the UpdateRating Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Books_Rates_UpdateRating_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the UpdateRating Choreo.
     *
     * @param Temboo_Session $session The session that owns this UpdateRating execution.
     * @param Facebook_Actions_Books_Rates_UpdateRating $choreo The choreography object for this execution.
     * @param Facebook_Actions_Books_Rates_UpdateRating_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Books_Rates_UpdateRating_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Books_Rates_UpdateRating_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Actions_Books_Rates_UpdateRating $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this UpdateRating execution.
     *
     * @return Facebook_Actions_Books_Rates_UpdateRating_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this UpdateRating execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Actions_Books_Rates_UpdateRating_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Actions_Books_Rates_UpdateRating_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the UpdateRating Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Books_Rates_UpdateRating_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the UpdateRating Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Actions_Books_Rates_UpdateRating_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this UpdateRating execution.
     *
     * @return string The response from Facebook.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Creates an action that represents a user reading a book.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Books_Reads_CreateReading extends Temboo_Choreography
{
    /**
     * Creates an action that represents a user reading a book.
     *
     * @param Temboo_Session $session The session that owns this CreateReading Choreo.
     * @return Facebook_Actions_Books_Reads_CreateReading New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Actions/Books/Reads/CreateReading/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this CreateReading Choreo.
     *
     * @param Facebook_Actions_Books_Reads_CreateReading_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Books_Reads_CreateReading_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Books_Reads_CreateReading_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Actions_Books_Reads_CreateReading_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this CreateReading Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Books_Reads_CreateReading_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Actions_Books_Reads_CreateReading_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the CreateReading Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Books_Reads_CreateReading_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the CreateReading Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Books_Reads_CreateReading_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this CreateReading input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Actions_Books_Reads_CreateReading_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Actions_Books_Reads_CreateReading_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this CreateReading Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Actions_Books_Reads_CreateReading_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the Book input for this CreateReading Choreo.
     *
     * @param string $value (required, string) The URL or ID for an Open Graph object representing the book.
     * @return Facebook_Actions_Books_Reads_CreateReading_Inputs For method chaining.
     */
    public function setBook($value)
    {
        return $this->set('Book', $value);
    }

    /**
     * Set the value for the CreatedTime input for this CreateReading Choreo.
     *
     * @param string $value (optional, date) The time that the action was created (e.g. 2013-06-24T18:53:35+0000).
     * @return Facebook_Actions_Books_Reads_CreateReading_Inputs For method chaining.
     */
    public function setCreatedTime($value)
    {
        return $this->set('CreatedTime', $value);
    }

    /**
     * Set the value for the EndTime input for this CreateReading Choreo.
     *
     * @param string $value (optional, date) The time that the user ended the action (e.g. 2013-06-24T18:53:35+0000).
     * @return Facebook_Actions_Books_Reads_CreateReading_Inputs For method chaining.
     */
    public function setEndTime($value)
    {
        return $this->set('EndTime', $value);
    }

    /**
     * Set the value for the ExpiresIn input for this CreateReading Choreo.
     *
     * @param int $value (optional, integer) The amount of time (in milliseconds) from the publish_time that the action will expire.
     * @return Facebook_Actions_Books_Reads_CreateReading_Inputs For method chaining.
     */
    public function setExpiresIn($value)
    {
        return $this->set('ExpiresIn', $value);
    }

    /**
     * Set the value for the ExplicitlyShared input for this CreateReading Choreo.
     *
     * @param bool $value (optional, boolean) Indicates that the user is explicitly sharing this action. Requires the explicitly_shared capability to be enabled.
     * @return Facebook_Actions_Books_Reads_CreateReading_Inputs For method chaining.
     */
    public function setExplicitlyShared($value)
    {
        return $this->set('ExplicitlyShared', $value);
    }

    /**
     * Set the value for the ExplicityShared input for this CreateReading Choreo.
     *
     * @param bool $value (optional, boolean) Deprecated (retained for backward compatibility only).
     * @return Facebook_Actions_Books_Reads_CreateReading_Inputs For method chaining.
     */
    public function setExplicityShared($value)
    {
        return $this->set('ExplicityShared', $value);
    }

    /**
     * Set the value for the Message input for this CreateReading Choreo.
     *
     * @param string $value (optional, string) A message attached to this action. Setting this parameter requires enabling of message capabilities.
     * @return Facebook_Actions_Books_Reads_CreateReading_Inputs For method chaining.
     */
    public function setMessage($value)
    {
        return $this->set('Message', $value);
    }

    /**
     * Set the value for the NoFeedStory input for this CreateReading Choreo.
     *
     * @param bool $value (optional, boolean) Whether or not this action should be posted to the users feed.
     * @return Facebook_Actions_Books_Reads_CreateReading_Inputs For method chaining.
     */
    public function setNoFeedStory($value)
    {
        return $this->set('NoFeedStory', $value);
    }

    /**
     * Set the value for the Place input for this CreateReading Choreo.
     *
     * @param string $value (optional, string) The URL or ID for an Open Graph object representing the location associated with this action.
     * @return Facebook_Actions_Books_Reads_CreateReading_Inputs For method chaining.
     */
    public function setPlace($value)
    {
        return $this->set('Place', $value);
    }

    /**
     * Set the value for the ProfileID input for this CreateReading Choreo.
     *
     * @param string $value (optional, string) The id of the user's profile. Defaults to "me" indicating the authenticated user.
     * @return Facebook_Actions_Books_Reads_CreateReading_Inputs For method chaining.
     */
    public function setProfileID($value)
    {
        return $this->set('ProfileID', $value);
    }

    /**
     * Set the value for the ProgressPercentComplete input for this CreateReading Choreo.
     *
     * @param float $value (required, decimal) The percentage progress towards finishing the specified book.
     * @return Facebook_Actions_Books_Reads_CreateReading_Inputs For method chaining.
     */
    public function setProgressPercentComplete($value)
    {
        return $this->set('ProgressPercentComplete', $value);
    }

    /**
     * Set the value for the ProgressTimestamp input for this CreateReading Choreo.
     *
     * @param string $value (required, date) A timestamp representing the time of change in progress towards finishing the specified book (e.g. 1372194363).
     * @return Facebook_Actions_Books_Reads_CreateReading_Inputs For method chaining.
     */
    public function setProgressTimestamp($value)
    {
        return $this->set('ProgressTimestamp', $value);
    }

    /**
     * Set the value for the Reference input for this CreateReading Choreo.
     *
     * @param string $value (optional, string) A string identifier up to 50 characters used for tracking and insights.
     * @return Facebook_Actions_Books_Reads_CreateReading_Inputs For method chaining.
     */
    public function setReference($value)
    {
        return $this->set('Reference', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this CreateReading Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Can be set to xml or json. Defaults to json.
     * @return Facebook_Actions_Books_Reads_CreateReading_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }

    /**
     * Set the value for the StartTime input for this CreateReading Choreo.
     *
     * @param string $value (optional, date) The time that the user started the action (e.g. 2013-06-24T18:53:35+0000).
     * @return Facebook_Actions_Books_Reads_CreateReading_Inputs For method chaining.
     */
    public function setStartTime($value)
    {
        return $this->set('StartTime', $value);
    }

    /**
     * Set the value for the Tags input for this CreateReading Choreo.
     *
     * @param string $value (optional, string) A comma separated list of other profile IDs that also performed this action.
     * @return Facebook_Actions_Books_Reads_CreateReading_Inputs For method chaining.
     */
    public function setTags($value)
    {
        return $this->set('Tags', $value);
    }
}


/**
 * Execution object for the CreateReading Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Books_Reads_CreateReading_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the CreateReading Choreo.
     *
     * @param Temboo_Session $session The session that owns this CreateReading execution.
     * @param Facebook_Actions_Books_Reads_CreateReading $choreo The choreography object for this execution.
     * @param Facebook_Actions_Books_Reads_CreateReading_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Books_Reads_CreateReading_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Books_Reads_CreateReading_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Actions_Books_Reads_CreateReading $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this CreateReading execution.
     *
     * @return Facebook_Actions_Books_Reads_CreateReading_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this CreateReading execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Actions_Books_Reads_CreateReading_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Actions_Books_Reads_CreateReading_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the CreateReading Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Books_Reads_CreateReading_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the CreateReading Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Actions_Books_Reads_CreateReading_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "ActivityURL" output from this CreateReading execution.
     *
     * @return string (string) The URL for the newly created action.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getActivityURL()
    {
        return $this->get('ActivityURL');
    }
    /**
     * Retrieve the value for the "Response" output from this CreateReading execution.
     *
     * @return string The response from Facebook.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Deletes a given book reading action.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Books_Reads_DeleteReading extends Temboo_Choreography
{
    /**
     * Deletes a given book reading action.
     *
     * @param Temboo_Session $session The session that owns this DeleteReading Choreo.
     * @return Facebook_Actions_Books_Reads_DeleteReading New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Actions/Books/Reads/DeleteReading/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this DeleteReading Choreo.
     *
     * @param Facebook_Actions_Books_Reads_DeleteReading_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Books_Reads_DeleteReading_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Books_Reads_DeleteReading_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Actions_Books_Reads_DeleteReading_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this DeleteReading Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Books_Reads_DeleteReading_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Actions_Books_Reads_DeleteReading_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the DeleteReading Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Books_Reads_DeleteReading_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the DeleteReading Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Books_Reads_DeleteReading_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this DeleteReading input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Actions_Books_Reads_DeleteReading_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Actions_Books_Reads_DeleteReading_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this DeleteReading Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Actions_Books_Reads_DeleteReading_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ActionID input for this DeleteReading Choreo.
     *
     * @param string $value (required, string) The id of an action to delete.
     * @return Facebook_Actions_Books_Reads_DeleteReading_Inputs For method chaining.
     */
    public function setActionID($value)
    {
        return $this->set('ActionID', $value);
    }
}


/**
 * Execution object for the DeleteReading Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Books_Reads_DeleteReading_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the DeleteReading Choreo.
     *
     * @param Temboo_Session $session The session that owns this DeleteReading execution.
     * @param Facebook_Actions_Books_Reads_DeleteReading $choreo The choreography object for this execution.
     * @param Facebook_Actions_Books_Reads_DeleteReading_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Books_Reads_DeleteReading_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Books_Reads_DeleteReading_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Actions_Books_Reads_DeleteReading $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this DeleteReading execution.
     *
     * @return Facebook_Actions_Books_Reads_DeleteReading_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this DeleteReading execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Actions_Books_Reads_DeleteReading_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Actions_Books_Reads_DeleteReading_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the DeleteReading Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Books_Reads_DeleteReading_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the DeleteReading Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Actions_Books_Reads_DeleteReading_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this DeleteReading execution.
     *
     * @return bool (boolean) The response from Facebook. Returns "true" on success.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Retrieves one or more book reading actions.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Books_Reads_ReadReadings extends Temboo_Choreography
{
    /**
     * Retrieves one or more book reading actions.
     *
     * @param Temboo_Session $session The session that owns this ReadReadings Choreo.
     * @return Facebook_Actions_Books_Reads_ReadReadings New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Actions/Books/Reads/ReadReadings/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this ReadReadings Choreo.
     *
     * @param Facebook_Actions_Books_Reads_ReadReadings_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Books_Reads_ReadReadings_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Books_Reads_ReadReadings_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Actions_Books_Reads_ReadReadings_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this ReadReadings Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Books_Reads_ReadReadings_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Actions_Books_Reads_ReadReadings_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the ReadReadings Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Books_Reads_ReadReadings_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the ReadReadings Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Books_Reads_ReadReadings_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this ReadReadings input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Actions_Books_Reads_ReadReadings_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Actions_Books_Reads_ReadReadings_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this ReadReadings Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Actions_Books_Reads_ReadReadings_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ActionID input for this ReadReadings Choreo.
     *
     * @param string $value (optional, string) The id of an action to retrieve. If an id is not provided, a list of all reading actions will be returned.
     * @return Facebook_Actions_Books_Reads_ReadReadings_Inputs For method chaining.
     */
    public function setActionID($value)
    {
        return $this->set('ActionID', $value);
    }

    /**
     * Set the value for the Fields input for this ReadReadings Choreo.
     *
     * @param string $value (optional, string) A comma separated list of fields to return (i.e. id,name).
     * @return Facebook_Actions_Books_Reads_ReadReadings_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Limit input for this ReadReadings Choreo.
     *
     * @param int $value (optional, integer) Used to page through results. Limits the number of records returned in the response.
     * @return Facebook_Actions_Books_Reads_ReadReadings_Inputs For method chaining.
     */
    public function setLimit($value)
    {
        return $this->set('Limit', $value);
    }

    /**
     * Set the value for the Offset input for this ReadReadings Choreo.
     *
     * @param int $value (optional, integer) Used to page through results. Returns results starting from the specified number.
     * @return Facebook_Actions_Books_Reads_ReadReadings_Inputs For method chaining.
     */
    public function setOffset($value)
    {
        return $this->set('Offset', $value);
    }

    /**
     * Set the value for the ProfileID input for this ReadReadings Choreo.
     *
     * @param string $value (optional, string) The id of the user's profile. Defaults to "me" indicating the authenticated user.
     * @return Facebook_Actions_Books_Reads_ReadReadings_Inputs For method chaining.
     */
    public function setProfileID($value)
    {
        return $this->set('ProfileID', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this ReadReadings Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Can be set to xml or json. Defaults to json.
     * @return Facebook_Actions_Books_Reads_ReadReadings_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }
}


/**
 * Execution object for the ReadReadings Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Books_Reads_ReadReadings_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the ReadReadings Choreo.
     *
     * @param Temboo_Session $session The session that owns this ReadReadings execution.
     * @param Facebook_Actions_Books_Reads_ReadReadings $choreo The choreography object for this execution.
     * @param Facebook_Actions_Books_Reads_ReadReadings_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Books_Reads_ReadReadings_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Books_Reads_ReadReadings_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Actions_Books_Reads_ReadReadings $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this ReadReadings execution.
     *
     * @return Facebook_Actions_Books_Reads_ReadReadings_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this ReadReadings execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Actions_Books_Reads_ReadReadings_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Actions_Books_Reads_ReadReadings_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the ReadReadings Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Books_Reads_ReadReadings_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the ReadReadings Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Actions_Books_Reads_ReadReadings_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "HasNext" output from this ReadReadings execution.
     *
     * @return bool (boolean) A boolean flag indicating that a next page exists.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getHasNext()
    {
        return $this->get('HasNext');
    }
    /**
     * Retrieve the value for the "HasPrevious" output from this ReadReadings execution.
     *
     * @return bool (boolean) A boolean flag indicating that a previous page exists.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getHasPrevious()
    {
        return $this->get('HasPrevious');
    }
    /**
     * Retrieve the value for the "Response" output from this ReadReadings execution.
     *
     * @return string The response from Facebook. Corresponds to the ResponseFormat input. Defaults to JSON.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Updates an existing book reading action.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Books_Reads_UpdateReading extends Temboo_Choreography
{
    /**
     * Updates an existing book reading action.
     *
     * @param Temboo_Session $session The session that owns this UpdateReading Choreo.
     * @return Facebook_Actions_Books_Reads_UpdateReading New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Actions/Books/Reads/UpdateReading/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this UpdateReading Choreo.
     *
     * @param Facebook_Actions_Books_Reads_UpdateReading_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Books_Reads_UpdateReading_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Books_Reads_UpdateReading_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Actions_Books_Reads_UpdateReading_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this UpdateReading Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Books_Reads_UpdateReading_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Actions_Books_Reads_UpdateReading_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the UpdateReading Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Books_Reads_UpdateReading_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the UpdateReading Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Books_Reads_UpdateReading_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this UpdateReading input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Actions_Books_Reads_UpdateReading_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Actions_Books_Reads_UpdateReading_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this UpdateReading Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Actions_Books_Reads_UpdateReading_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ActionID input for this UpdateReading Choreo.
     *
     * @param string $value (required, string) The id of the action to update.
     * @return Facebook_Actions_Books_Reads_UpdateReading_Inputs For method chaining.
     */
    public function setActionID($value)
    {
        return $this->set('ActionID', $value);
    }

    /**
     * Set the value for the Book input for this UpdateReading Choreo.
     *
     * @param string $value (optional, string) The URL or ID for an Open Graph object representing the book.
     * @return Facebook_Actions_Books_Reads_UpdateReading_Inputs For method chaining.
     */
    public function setBook($value)
    {
        return $this->set('Book', $value);
    }

    /**
     * Set the value for the EndTime input for this UpdateReading Choreo.
     *
     * @param string $value (optional, date) The time that the user ended the action (e.g. 2013-06-24T18:53:35+0000).
     * @return Facebook_Actions_Books_Reads_UpdateReading_Inputs For method chaining.
     */
    public function setEndTime($value)
    {
        return $this->set('EndTime', $value);
    }

    /**
     * Set the value for the ExpiresIn input for this UpdateReading Choreo.
     *
     * @param int $value (optional, integer) The amount of time (in milliseconds) from the publish_time that the action will expire.
     * @return Facebook_Actions_Books_Reads_UpdateReading_Inputs For method chaining.
     */
    public function setExpiresIn($value)
    {
        return $this->set('ExpiresIn', $value);
    }

    /**
     * Set the value for the Message input for this UpdateReading Choreo.
     *
     * @param string $value (optional, string) A message attached to this action. Setting this parameter requires enabling of message capabilities.
     * @return Facebook_Actions_Books_Reads_UpdateReading_Inputs For method chaining.
     */
    public function setMessage($value)
    {
        return $this->set('Message', $value);
    }

    /**
     * Set the value for the Place input for this UpdateReading Choreo.
     *
     * @param string $value (optional, string) The URL or ID for an Open Graph object representing the location associated with this action.
     * @return Facebook_Actions_Books_Reads_UpdateReading_Inputs For method chaining.
     */
    public function setPlace($value)
    {
        return $this->set('Place', $value);
    }

    /**
     * Set the value for the ProgressPercentComplete input for this UpdateReading Choreo.
     *
     * @param float $value (optional, decimal) The percentage progress towards finishing the specified book.
     * @return Facebook_Actions_Books_Reads_UpdateReading_Inputs For method chaining.
     */
    public function setProgressPercentComplete($value)
    {
        return $this->set('ProgressPercentComplete', $value);
    }

    /**
     * Set the value for the ProgressTimestamp input for this UpdateReading Choreo.
     *
     * @param string $value (optional, date) A timestamp representing the time of change in progress towards finishing the specified book (e.g. 1372194363).
     * @return Facebook_Actions_Books_Reads_UpdateReading_Inputs For method chaining.
     */
    public function setProgressTimestamp($value)
    {
        return $this->set('ProgressTimestamp', $value);
    }

    /**
     * Set the value for the Tags input for this UpdateReading Choreo.
     *
     * @param string $value (optional, string) A comma separated list of other profile IDs that also performed this action.
     * @return Facebook_Actions_Books_Reads_UpdateReading_Inputs For method chaining.
     */
    public function setTags($value)
    {
        return $this->set('Tags', $value);
    }
}


/**
 * Execution object for the UpdateReading Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Books_Reads_UpdateReading_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the UpdateReading Choreo.
     *
     * @param Temboo_Session $session The session that owns this UpdateReading execution.
     * @param Facebook_Actions_Books_Reads_UpdateReading $choreo The choreography object for this execution.
     * @param Facebook_Actions_Books_Reads_UpdateReading_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Books_Reads_UpdateReading_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Books_Reads_UpdateReading_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Actions_Books_Reads_UpdateReading $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this UpdateReading execution.
     *
     * @return Facebook_Actions_Books_Reads_UpdateReading_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this UpdateReading execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Actions_Books_Reads_UpdateReading_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Actions_Books_Reads_UpdateReading_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the UpdateReading Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Books_Reads_UpdateReading_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the UpdateReading Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Actions_Books_Reads_UpdateReading_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this UpdateReading execution.
     *
     * @return string The response from Facebook.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Creates an action that represents a user wanting to read a book.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Books_WantsToRead_CreateWantsToRead extends Temboo_Choreography
{
    /**
     * Creates an action that represents a user wanting to read a book.
     *
     * @param Temboo_Session $session The session that owns this CreateWantsToRead Choreo.
     * @return Facebook_Actions_Books_WantsToRead_CreateWantsToRead New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Actions/Books/WantsToRead/CreateWantsToRead/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this CreateWantsToRead Choreo.
     *
     * @param Facebook_Actions_Books_WantsToRead_CreateWantsToRead_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Books_WantsToRead_CreateWantsToRead_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Books_WantsToRead_CreateWantsToRead_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Actions_Books_WantsToRead_CreateWantsToRead_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this CreateWantsToRead Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Books_WantsToRead_CreateWantsToRead_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Actions_Books_WantsToRead_CreateWantsToRead_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the CreateWantsToRead Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Books_WantsToRead_CreateWantsToRead_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the CreateWantsToRead Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Books_WantsToRead_CreateWantsToRead_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this CreateWantsToRead input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Actions_Books_WantsToRead_CreateWantsToRead_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Actions_Books_WantsToRead_CreateWantsToRead_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this CreateWantsToRead Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Actions_Books_WantsToRead_CreateWantsToRead_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the Book input for this CreateWantsToRead Choreo.
     *
     * @param string $value (required, string) The URL or ID for an Open Graph object representing the book.
     * @return Facebook_Actions_Books_WantsToRead_CreateWantsToRead_Inputs For method chaining.
     */
    public function setBook($value)
    {
        return $this->set('Book', $value);
    }

    /**
     * Set the value for the CreatedTime input for this CreateWantsToRead Choreo.
     *
     * @param string $value (optional, date) The time that the action was created (e.g. 2013-06-24T18:53:35+0000).
     * @return Facebook_Actions_Books_WantsToRead_CreateWantsToRead_Inputs For method chaining.
     */
    public function setCreatedTime($value)
    {
        return $this->set('CreatedTime', $value);
    }

    /**
     * Set the value for the EndTime input for this CreateWantsToRead Choreo.
     *
     * @param string $value (optional, date) The time that the user ended the action (e.g. 2013-06-24T18:53:35+0000).
     * @return Facebook_Actions_Books_WantsToRead_CreateWantsToRead_Inputs For method chaining.
     */
    public function setEndTime($value)
    {
        return $this->set('EndTime', $value);
    }

    /**
     * Set the value for the ExpiresIn input for this CreateWantsToRead Choreo.
     *
     * @param int $value (optional, integer) The amount of time (in milliseconds) from the publish_time that the action will expire.
     * @return Facebook_Actions_Books_WantsToRead_CreateWantsToRead_Inputs For method chaining.
     */
    public function setExpiresIn($value)
    {
        return $this->set('ExpiresIn', $value);
    }

    /**
     * Set the value for the ExplicitlyShared input for this CreateWantsToRead Choreo.
     *
     * @param bool $value (optional, boolean) Indicates that the user is explicitly sharing this action. Requires the explicitly_shared capability to be enabled.
     * @return Facebook_Actions_Books_WantsToRead_CreateWantsToRead_Inputs For method chaining.
     */
    public function setExplicitlyShared($value)
    {
        return $this->set('ExplicitlyShared', $value);
    }

    /**
     * Set the value for the ExplicityShared input for this CreateWantsToRead Choreo.
     *
     * @param bool $value (optional, boolean) Deprecated (retained for backward compatibility only).
     * @return Facebook_Actions_Books_WantsToRead_CreateWantsToRead_Inputs For method chaining.
     */
    public function setExplicityShared($value)
    {
        return $this->set('ExplicityShared', $value);
    }

    /**
     * Set the value for the Message input for this CreateWantsToRead Choreo.
     *
     * @param string $value (optional, string) A message attached to this action. Setting this parameter requires enabling of message capabilities.
     * @return Facebook_Actions_Books_WantsToRead_CreateWantsToRead_Inputs For method chaining.
     */
    public function setMessage($value)
    {
        return $this->set('Message', $value);
    }

    /**
     * Set the value for the NoFeedStory input for this CreateWantsToRead Choreo.
     *
     * @param bool $value (optional, boolean) Whether or not this action should be posted to the users feed.
     * @return Facebook_Actions_Books_WantsToRead_CreateWantsToRead_Inputs For method chaining.
     */
    public function setNoFeedStory($value)
    {
        return $this->set('NoFeedStory', $value);
    }

    /**
     * Set the value for the Place input for this CreateWantsToRead Choreo.
     *
     * @param string $value (optional, string) The URL or ID for an Open Graph object representing the location associated with this action.
     * @return Facebook_Actions_Books_WantsToRead_CreateWantsToRead_Inputs For method chaining.
     */
    public function setPlace($value)
    {
        return $this->set('Place', $value);
    }

    /**
     * Set the value for the ProfileID input for this CreateWantsToRead Choreo.
     *
     * @param string $value (optional, string) The id of the user's profile. Defaults to "me" indicating the authenticated user.
     * @return Facebook_Actions_Books_WantsToRead_CreateWantsToRead_Inputs For method chaining.
     */
    public function setProfileID($value)
    {
        return $this->set('ProfileID', $value);
    }

    /**
     * Set the value for the Reference input for this CreateWantsToRead Choreo.
     *
     * @param string $value (optional, string) A string identifier up to 50 characters used for tracking and insights.
     * @return Facebook_Actions_Books_WantsToRead_CreateWantsToRead_Inputs For method chaining.
     */
    public function setReference($value)
    {
        return $this->set('Reference', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this CreateWantsToRead Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Can be set to xml or json. Defaults to json.
     * @return Facebook_Actions_Books_WantsToRead_CreateWantsToRead_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }

    /**
     * Set the value for the StartTime input for this CreateWantsToRead Choreo.
     *
     * @param string $value (optional, date) The time that the user started the action (e.g. 2013-06-24T18:53:35+0000).
     * @return Facebook_Actions_Books_WantsToRead_CreateWantsToRead_Inputs For method chaining.
     */
    public function setStartTime($value)
    {
        return $this->set('StartTime', $value);
    }

    /**
     * Set the value for the Tags input for this CreateWantsToRead Choreo.
     *
     * @param string $value (optional, string) A comma separated list of other profile IDs that also performed this action.
     * @return Facebook_Actions_Books_WantsToRead_CreateWantsToRead_Inputs For method chaining.
     */
    public function setTags($value)
    {
        return $this->set('Tags', $value);
    }
}


/**
 * Execution object for the CreateWantsToRead Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Books_WantsToRead_CreateWantsToRead_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the CreateWantsToRead Choreo.
     *
     * @param Temboo_Session $session The session that owns this CreateWantsToRead execution.
     * @param Facebook_Actions_Books_WantsToRead_CreateWantsToRead $choreo The choreography object for this execution.
     * @param Facebook_Actions_Books_WantsToRead_CreateWantsToRead_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Books_WantsToRead_CreateWantsToRead_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Books_WantsToRead_CreateWantsToRead_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Actions_Books_WantsToRead_CreateWantsToRead $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this CreateWantsToRead execution.
     *
     * @return Facebook_Actions_Books_WantsToRead_CreateWantsToRead_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this CreateWantsToRead execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Actions_Books_WantsToRead_CreateWantsToRead_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Actions_Books_WantsToRead_CreateWantsToRead_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the CreateWantsToRead Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Books_WantsToRead_CreateWantsToRead_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the CreateWantsToRead Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Actions_Books_WantsToRead_CreateWantsToRead_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "ActivityURL" output from this CreateWantsToRead execution.
     *
     * @return string (string) The URL for the newly created action.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getActivityURL()
    {
        return $this->get('ActivityURL');
    }
    /**
     * Retrieve the value for the "Response" output from this CreateWantsToRead execution.
     *
     * @return string The response from Facebook.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Deletes a given wants_to_read action.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Books_WantsToRead_DeleteWantsToRead extends Temboo_Choreography
{
    /**
     * Deletes a given wants_to_read action.
     *
     * @param Temboo_Session $session The session that owns this DeleteWantsToRead Choreo.
     * @return Facebook_Actions_Books_WantsToRead_DeleteWantsToRead New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Actions/Books/WantsToRead/DeleteWantsToRead/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this DeleteWantsToRead Choreo.
     *
     * @param Facebook_Actions_Books_WantsToRead_DeleteWantsToRead_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Books_WantsToRead_DeleteWantsToRead_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Books_WantsToRead_DeleteWantsToRead_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Actions_Books_WantsToRead_DeleteWantsToRead_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this DeleteWantsToRead Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Books_WantsToRead_DeleteWantsToRead_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Actions_Books_WantsToRead_DeleteWantsToRead_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the DeleteWantsToRead Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Books_WantsToRead_DeleteWantsToRead_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the DeleteWantsToRead Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Books_WantsToRead_DeleteWantsToRead_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this DeleteWantsToRead input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Actions_Books_WantsToRead_DeleteWantsToRead_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Actions_Books_WantsToRead_DeleteWantsToRead_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this DeleteWantsToRead Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Actions_Books_WantsToRead_DeleteWantsToRead_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ActionID input for this DeleteWantsToRead Choreo.
     *
     * @param string $value (required, string) The id of an action to delete.
     * @return Facebook_Actions_Books_WantsToRead_DeleteWantsToRead_Inputs For method chaining.
     */
    public function setActionID($value)
    {
        return $this->set('ActionID', $value);
    }
}


/**
 * Execution object for the DeleteWantsToRead Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Books_WantsToRead_DeleteWantsToRead_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the DeleteWantsToRead Choreo.
     *
     * @param Temboo_Session $session The session that owns this DeleteWantsToRead execution.
     * @param Facebook_Actions_Books_WantsToRead_DeleteWantsToRead $choreo The choreography object for this execution.
     * @param Facebook_Actions_Books_WantsToRead_DeleteWantsToRead_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Books_WantsToRead_DeleteWantsToRead_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Books_WantsToRead_DeleteWantsToRead_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Actions_Books_WantsToRead_DeleteWantsToRead $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this DeleteWantsToRead execution.
     *
     * @return Facebook_Actions_Books_WantsToRead_DeleteWantsToRead_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this DeleteWantsToRead execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Actions_Books_WantsToRead_DeleteWantsToRead_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Actions_Books_WantsToRead_DeleteWantsToRead_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the DeleteWantsToRead Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Books_WantsToRead_DeleteWantsToRead_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the DeleteWantsToRead Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Actions_Books_WantsToRead_DeleteWantsToRead_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this DeleteWantsToRead execution.
     *
     * @return bool (boolean) The response from Facebook. Returns "true" on success.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Retrieves one or more wants_to_read actions.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Books_WantsToRead_ReadWantsToReads extends Temboo_Choreography
{
    /**
     * Retrieves one or more wants_to_read actions.
     *
     * @param Temboo_Session $session The session that owns this ReadWantsToReads Choreo.
     * @return Facebook_Actions_Books_WantsToRead_ReadWantsToReads New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Actions/Books/WantsToRead/ReadWantsToReads/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this ReadWantsToReads Choreo.
     *
     * @param Facebook_Actions_Books_WantsToRead_ReadWantsToReads_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Books_WantsToRead_ReadWantsToReads_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Books_WantsToRead_ReadWantsToReads_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Actions_Books_WantsToRead_ReadWantsToReads_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this ReadWantsToReads Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Books_WantsToRead_ReadWantsToReads_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Actions_Books_WantsToRead_ReadWantsToReads_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the ReadWantsToReads Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Books_WantsToRead_ReadWantsToReads_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the ReadWantsToReads Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Books_WantsToRead_ReadWantsToReads_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this ReadWantsToReads input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Actions_Books_WantsToRead_ReadWantsToReads_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Actions_Books_WantsToRead_ReadWantsToReads_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this ReadWantsToReads Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Actions_Books_WantsToRead_ReadWantsToReads_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ActionID input for this ReadWantsToReads Choreo.
     *
     * @param string $value (optional, string) The id of an action to retrieve. If an id is not provided, a list of all wants_to_read actions will be returned.
     * @return Facebook_Actions_Books_WantsToRead_ReadWantsToReads_Inputs For method chaining.
     */
    public function setActionID($value)
    {
        return $this->set('ActionID', $value);
    }

    /**
     * Set the value for the Fields input for this ReadWantsToReads Choreo.
     *
     * @param string $value (optional, string) A comma separated list of fields to return (i.e. id,name).
     * @return Facebook_Actions_Books_WantsToRead_ReadWantsToReads_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Limit input for this ReadWantsToReads Choreo.
     *
     * @param int $value (optional, integer) Used to page through results. Limits the number of records returned in the response.
     * @return Facebook_Actions_Books_WantsToRead_ReadWantsToReads_Inputs For method chaining.
     */
    public function setLimit($value)
    {
        return $this->set('Limit', $value);
    }

    /**
     * Set the value for the Offset input for this ReadWantsToReads Choreo.
     *
     * @param int $value (optional, integer) Used to page through results. Returns results starting from the specified number.
     * @return Facebook_Actions_Books_WantsToRead_ReadWantsToReads_Inputs For method chaining.
     */
    public function setOffset($value)
    {
        return $this->set('Offset', $value);
    }

    /**
     * Set the value for the ProfileID input for this ReadWantsToReads Choreo.
     *
     * @param string $value (optional, string) The id of the user's profile. Defaults to "me" indicating the authenticated user.
     * @return Facebook_Actions_Books_WantsToRead_ReadWantsToReads_Inputs For method chaining.
     */
    public function setProfileID($value)
    {
        return $this->set('ProfileID', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this ReadWantsToReads Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Can be set to xml or json. Defaults to json.
     * @return Facebook_Actions_Books_WantsToRead_ReadWantsToReads_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }
}


/**
 * Execution object for the ReadWantsToReads Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Books_WantsToRead_ReadWantsToReads_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the ReadWantsToReads Choreo.
     *
     * @param Temboo_Session $session The session that owns this ReadWantsToReads execution.
     * @param Facebook_Actions_Books_WantsToRead_ReadWantsToReads $choreo The choreography object for this execution.
     * @param Facebook_Actions_Books_WantsToRead_ReadWantsToReads_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Books_WantsToRead_ReadWantsToReads_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Books_WantsToRead_ReadWantsToReads_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Actions_Books_WantsToRead_ReadWantsToReads $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this ReadWantsToReads execution.
     *
     * @return Facebook_Actions_Books_WantsToRead_ReadWantsToReads_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this ReadWantsToReads execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Actions_Books_WantsToRead_ReadWantsToReads_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Actions_Books_WantsToRead_ReadWantsToReads_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the ReadWantsToReads Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Books_WantsToRead_ReadWantsToReads_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the ReadWantsToReads Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Actions_Books_WantsToRead_ReadWantsToReads_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "HasNext" output from this ReadWantsToReads execution.
     *
     * @return bool (boolean) A boolean flag indicating that a next page exists.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getHasNext()
    {
        return $this->get('HasNext');
    }
    /**
     * Retrieve the value for the "HasPrevious" output from this ReadWantsToReads execution.
     *
     * @return bool (boolean) A boolean flag indicating that a previous page exists.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getHasPrevious()
    {
        return $this->get('HasPrevious');
    }
    /**
     * Retrieve the value for the "Response" output from this ReadWantsToReads execution.
     *
     * @return string The response from Facebook. Corresponds to the ResponseFormat input. Defaults to JSON.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Updates an existing wants_to_read action.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Books_WantsToRead_UpdateWantsToRead extends Temboo_Choreography
{
    /**
     * Updates an existing wants_to_read action.
     *
     * @param Temboo_Session $session The session that owns this UpdateWantsToRead Choreo.
     * @return Facebook_Actions_Books_WantsToRead_UpdateWantsToRead New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Actions/Books/WantsToRead/UpdateWantsToRead/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this UpdateWantsToRead Choreo.
     *
     * @param Facebook_Actions_Books_WantsToRead_UpdateWantsToRead_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Books_WantsToRead_UpdateWantsToRead_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Books_WantsToRead_UpdateWantsToRead_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Actions_Books_WantsToRead_UpdateWantsToRead_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this UpdateWantsToRead Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Books_WantsToRead_UpdateWantsToRead_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Actions_Books_WantsToRead_UpdateWantsToRead_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the UpdateWantsToRead Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Books_WantsToRead_UpdateWantsToRead_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the UpdateWantsToRead Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Books_WantsToRead_UpdateWantsToRead_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this UpdateWantsToRead input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Actions_Books_WantsToRead_UpdateWantsToRead_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Actions_Books_WantsToRead_UpdateWantsToRead_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this UpdateWantsToRead Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Actions_Books_WantsToRead_UpdateWantsToRead_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ActionID input for this UpdateWantsToRead Choreo.
     *
     * @param string $value (required, string) The id of the action to update.
     * @return Facebook_Actions_Books_WantsToRead_UpdateWantsToRead_Inputs For method chaining.
     */
    public function setActionID($value)
    {
        return $this->set('ActionID', $value);
    }

    /**
     * Set the value for the Book input for this UpdateWantsToRead Choreo.
     *
     * @param string $value (optional, string) The URL or ID for an Open Graph object representing the book.
     * @return Facebook_Actions_Books_WantsToRead_UpdateWantsToRead_Inputs For method chaining.
     */
    public function setBook($value)
    {
        return $this->set('Book', $value);
    }

    /**
     * Set the value for the EndTime input for this UpdateWantsToRead Choreo.
     *
     * @param string $value (optional, date) The time that the user ended the action (e.g. 2013-06-24T18:53:35+0000).
     * @return Facebook_Actions_Books_WantsToRead_UpdateWantsToRead_Inputs For method chaining.
     */
    public function setEndTime($value)
    {
        return $this->set('EndTime', $value);
    }

    /**
     * Set the value for the ExpiresIn input for this UpdateWantsToRead Choreo.
     *
     * @param int $value (optional, integer) The amount of time (in milliseconds) from the publish_time that the action will expire.
     * @return Facebook_Actions_Books_WantsToRead_UpdateWantsToRead_Inputs For method chaining.
     */
    public function setExpiresIn($value)
    {
        return $this->set('ExpiresIn', $value);
    }

    /**
     * Set the value for the Message input for this UpdateWantsToRead Choreo.
     *
     * @param string $value (optional, string) A message attached to this action. Setting this parameter requires enabling of message capabilities.
     * @return Facebook_Actions_Books_WantsToRead_UpdateWantsToRead_Inputs For method chaining.
     */
    public function setMessage($value)
    {
        return $this->set('Message', $value);
    }

    /**
     * Set the value for the Place input for this UpdateWantsToRead Choreo.
     *
     * @param string $value (optional, string) The URL or ID for an Open Graph object representing the location associated with this action.
     * @return Facebook_Actions_Books_WantsToRead_UpdateWantsToRead_Inputs For method chaining.
     */
    public function setPlace($value)
    {
        return $this->set('Place', $value);
    }

    /**
     * Set the value for the Tags input for this UpdateWantsToRead Choreo.
     *
     * @param string $value (optional, string) A comma separated list of other profile IDs that also performed this action.
     * @return Facebook_Actions_Books_WantsToRead_UpdateWantsToRead_Inputs For method chaining.
     */
    public function setTags($value)
    {
        return $this->set('Tags', $value);
    }
}


/**
 * Execution object for the UpdateWantsToRead Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Books_WantsToRead_UpdateWantsToRead_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the UpdateWantsToRead Choreo.
     *
     * @param Temboo_Session $session The session that owns this UpdateWantsToRead execution.
     * @param Facebook_Actions_Books_WantsToRead_UpdateWantsToRead $choreo The choreography object for this execution.
     * @param Facebook_Actions_Books_WantsToRead_UpdateWantsToRead_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Books_WantsToRead_UpdateWantsToRead_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Books_WantsToRead_UpdateWantsToRead_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Actions_Books_WantsToRead_UpdateWantsToRead $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this UpdateWantsToRead execution.
     *
     * @return Facebook_Actions_Books_WantsToRead_UpdateWantsToRead_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this UpdateWantsToRead execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Actions_Books_WantsToRead_UpdateWantsToRead_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Actions_Books_WantsToRead_UpdateWantsToRead_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the UpdateWantsToRead Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Books_WantsToRead_UpdateWantsToRead_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the UpdateWantsToRead Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Actions_Books_WantsToRead_UpdateWantsToRead_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this UpdateWantsToRead execution.
     *
     * @return string The response from Facebook.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Creates an Open Graph action that represents a user performing the specified action while using your app.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Custom_CreateAction extends Temboo_Choreography
{
    /**
     * Creates an Open Graph action that represents a user performing the specified action while using your app.
     *
     * @param Temboo_Session $session The session that owns this CreateAction Choreo.
     * @return Facebook_Actions_Custom_CreateAction New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Actions/Custom/CreateAction/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this CreateAction Choreo.
     *
     * @param Facebook_Actions_Custom_CreateAction_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Custom_CreateAction_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Custom_CreateAction_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Actions_Custom_CreateAction_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this CreateAction Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Custom_CreateAction_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Actions_Custom_CreateAction_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the CreateAction Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Custom_CreateAction_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the CreateAction Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Custom_CreateAction_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this CreateAction input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Actions_Custom_CreateAction_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Actions_Custom_CreateAction_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this CreateAction Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Actions_Custom_CreateAction_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ActionType input for this CreateAction Choreo.
     *
     * @param string $value (required, string) The type of action that a user is performing in your app (e.g. runs, walks, bikes).
     * @return Facebook_Actions_Custom_CreateAction_Inputs For method chaining.
     */
    public function setActionType($value)
    {
        return $this->set('ActionType', $value);
    }

    /**
     * Set the value for the AppNamespace input for this CreateAction Choreo.
     *
     * @param string $value (required, string) The namespace that you chose for you app. This can be found in the Settings section of your App page.
     * @return Facebook_Actions_Custom_CreateAction_Inputs For method chaining.
     */
    public function setAppNamespace($value)
    {
        return $this->set('AppNamespace', $value);
    }

    /**
     * Set the value for the CreatedTime input for this CreateAction Choreo.
     *
     * @param string $value (optional, date) The time that the action was created (e.g. 2013-06-24T18:53:35+0000).
     * @return Facebook_Actions_Custom_CreateAction_Inputs For method chaining.
     */
    public function setCreatedTime($value)
    {
        return $this->set('CreatedTime', $value);
    }

    /**
     * Set the value for the EndTime input for this CreateAction Choreo.
     *
     * @param string $value (optional, date) The time that the user ended the action (e.g. 2013-06-24T18:53:35+0000).
     * @return Facebook_Actions_Custom_CreateAction_Inputs For method chaining.
     */
    public function setEndTime($value)
    {
        return $this->set('EndTime', $value);
    }

    /**
     * Set the value for the ExpiresIn input for this CreateAction Choreo.
     *
     * @param int $value (optional, integer) The amount of time (in milliseconds) from the publish_time that the action will expire.
     * @return Facebook_Actions_Custom_CreateAction_Inputs For method chaining.
     */
    public function setExpiresIn($value)
    {
        return $this->set('ExpiresIn', $value);
    }

    /**
     * Set the value for the ExplicitlyShared input for this CreateAction Choreo.
     *
     * @param bool $value (optional, boolean) Indicates that the user is explicitly sharing this action. Requires the explicitly_shared capability to be enabled.
     * @return Facebook_Actions_Custom_CreateAction_Inputs For method chaining.
     */
    public function setExplicitlyShared($value)
    {
        return $this->set('ExplicitlyShared', $value);
    }

    /**
     * Set the value for the ExplicityShared input for this CreateAction Choreo.
     *
     * @param bool $value (optional, boolean) Deprecated (retained for backward compatibility only).
     * @return Facebook_Actions_Custom_CreateAction_Inputs For method chaining.
     */
    public function setExplicityShared($value)
    {
        return $this->set('ExplicityShared', $value);
    }

    /**
     * Set the value for the Message input for this CreateAction Choreo.
     *
     * @param string $value (optional, string) A message attached to this action. Setting this parameter requires enabling of message capabilities.
     * @return Facebook_Actions_Custom_CreateAction_Inputs For method chaining.
     */
    public function setMessage($value)
    {
        return $this->set('Message', $value);
    }

    /**
     * Set the value for the NoFeedStory input for this CreateAction Choreo.
     *
     * @param bool $value (optional, boolean) Whether or not this action should be posted to the users feed.
     * @return Facebook_Actions_Custom_CreateAction_Inputs For method chaining.
     */
    public function setNoFeedStory($value)
    {
        return $this->set('NoFeedStory', $value);
    }

    /**
     * Set the value for the Place input for this CreateAction Choreo.
     *
     * @param string $value (optional, string) The URL or ID for an Open Graph object representing the location associated with this action.
     * @return Facebook_Actions_Custom_CreateAction_Inputs For method chaining.
     */
    public function setPlace($value)
    {
        return $this->set('Place', $value);
    }

    /**
     * Set the value for the ProfileID input for this CreateAction Choreo.
     *
     * @param string $value (optional, string) The id of the user's profile. Defaults to "me" indicating the authenticated user.
     * @return Facebook_Actions_Custom_CreateAction_Inputs For method chaining.
     */
    public function setProfileID($value)
    {
        return $this->set('ProfileID', $value);
    }

    /**
     * Set the value for the PropertyName input for this CreateAction Choreo.
     *
     * @param string $value (required, string) The name of a property that you've defined for this Open Graph story. This will be an object type (e.g. album, song, book). Multiple property names can be separated by commas.
     * @return Facebook_Actions_Custom_CreateAction_Inputs For method chaining.
     */
    public function setPropertyName($value)
    {
        return $this->set('PropertyName', $value);
    }

    /**
     * Set the value for the PropertyValue input for this CreateAction Choreo.
     *
     * @param string $value (required, string) The URL or ID for an Open Graph object representing the object specified as the PropertyName. Multiple property values can be separated by commas.
     * @return Facebook_Actions_Custom_CreateAction_Inputs For method chaining.
     */
    public function setPropertyValue($value)
    {
        return $this->set('PropertyValue', $value);
    }

    /**
     * Set the value for the Reference input for this CreateAction Choreo.
     *
     * @param string $value (optional, string) A string identifier up to 50 characters used for tracking and insights.
     * @return Facebook_Actions_Custom_CreateAction_Inputs For method chaining.
     */
    public function setReference($value)
    {
        return $this->set('Reference', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this CreateAction Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Can be set to xml or json. Defaults to json.
     * @return Facebook_Actions_Custom_CreateAction_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }

    /**
     * Set the value for the StartTime input for this CreateAction Choreo.
     *
     * @param string $value (optional, date) The time that the user started the action (e.g. 2013-06-24T18:53:35+0000).
     * @return Facebook_Actions_Custom_CreateAction_Inputs For method chaining.
     */
    public function setStartTime($value)
    {
        return $this->set('StartTime', $value);
    }

    /**
     * Set the value for the Tags input for this CreateAction Choreo.
     *
     * @param string $value (optional, string) A comma separated list of other profile IDs that also performed this action.
     * @return Facebook_Actions_Custom_CreateAction_Inputs For method chaining.
     */
    public function setTags($value)
    {
        return $this->set('Tags', $value);
    }
}


/**
 * Execution object for the CreateAction Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Custom_CreateAction_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the CreateAction Choreo.
     *
     * @param Temboo_Session $session The session that owns this CreateAction execution.
     * @param Facebook_Actions_Custom_CreateAction $choreo The choreography object for this execution.
     * @param Facebook_Actions_Custom_CreateAction_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Custom_CreateAction_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Custom_CreateAction_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Actions_Custom_CreateAction $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this CreateAction execution.
     *
     * @return Facebook_Actions_Custom_CreateAction_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this CreateAction execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Actions_Custom_CreateAction_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Actions_Custom_CreateAction_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the CreateAction Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Custom_CreateAction_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the CreateAction Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Actions_Custom_CreateAction_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "ActivityURL" output from this CreateAction execution.
     *
     * @return string (string) The URL for the newly created action.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getActivityURL()
    {
        return $this->get('ActivityURL');
    }
    /**
     * Retrieve the value for the "Response" output from this CreateAction execution.
     *
     * @return string The response from Facebook.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Deletes a given custom action.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Custom_DeleteAction extends Temboo_Choreography
{
    /**
     * Deletes a given custom action.
     *
     * @param Temboo_Session $session The session that owns this DeleteAction Choreo.
     * @return Facebook_Actions_Custom_DeleteAction New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Actions/Custom/DeleteAction/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this DeleteAction Choreo.
     *
     * @param Facebook_Actions_Custom_DeleteAction_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Custom_DeleteAction_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Custom_DeleteAction_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Actions_Custom_DeleteAction_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this DeleteAction Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Custom_DeleteAction_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Actions_Custom_DeleteAction_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the DeleteAction Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Custom_DeleteAction_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the DeleteAction Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Custom_DeleteAction_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this DeleteAction input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Actions_Custom_DeleteAction_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Actions_Custom_DeleteAction_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this DeleteAction Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Actions_Custom_DeleteAction_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ActionID input for this DeleteAction Choreo.
     *
     * @param string $value (required, string) The id of an action to delete.
     * @return Facebook_Actions_Custom_DeleteAction_Inputs For method chaining.
     */
    public function setActionID($value)
    {
        return $this->set('ActionID', $value);
    }
}


/**
 * Execution object for the DeleteAction Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Custom_DeleteAction_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the DeleteAction Choreo.
     *
     * @param Temboo_Session $session The session that owns this DeleteAction execution.
     * @param Facebook_Actions_Custom_DeleteAction $choreo The choreography object for this execution.
     * @param Facebook_Actions_Custom_DeleteAction_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Custom_DeleteAction_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Custom_DeleteAction_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Actions_Custom_DeleteAction $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this DeleteAction execution.
     *
     * @return Facebook_Actions_Custom_DeleteAction_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this DeleteAction execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Actions_Custom_DeleteAction_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Actions_Custom_DeleteAction_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the DeleteAction Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Custom_DeleteAction_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the DeleteAction Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Actions_Custom_DeleteAction_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this DeleteAction execution.
     *
     * @return bool (boolean) The response from Facebook. Returns "true" on success.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Retrieves one or more custom actions.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Custom_ReadActions extends Temboo_Choreography
{
    /**
     * Retrieves one or more custom actions.
     *
     * @param Temboo_Session $session The session that owns this ReadActions Choreo.
     * @return Facebook_Actions_Custom_ReadActions New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Actions/Custom/ReadActions/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this ReadActions Choreo.
     *
     * @param Facebook_Actions_Custom_ReadActions_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Custom_ReadActions_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Custom_ReadActions_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Actions_Custom_ReadActions_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this ReadActions Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Custom_ReadActions_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Actions_Custom_ReadActions_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the ReadActions Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Custom_ReadActions_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the ReadActions Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Custom_ReadActions_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this ReadActions input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Actions_Custom_ReadActions_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Actions_Custom_ReadActions_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this ReadActions Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Actions_Custom_ReadActions_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ActionID input for this ReadActions Choreo.
     *
     * @param string $value (conditional, string) The id of an action to retrieve. If an id is not provided, a list of all custom actions will be returned. Required unless you provide the AppNamespace and ActionType to return all custom actions.
     * @return Facebook_Actions_Custom_ReadActions_Inputs For method chaining.
     */
    public function setActionID($value)
    {
        return $this->set('ActionID', $value);
    }

    /**
     * Set the value for the ActionType input for this ReadActions Choreo.
     *
     * @param string $value (conditional, string) The type of action that a user is performing in your app (e.g. runs, walks, bikes). Required unless you provide the ActionID.
     * @return Facebook_Actions_Custom_ReadActions_Inputs For method chaining.
     */
    public function setActionType($value)
    {
        return $this->set('ActionType', $value);
    }

    /**
     * Set the value for the AppNamespace input for this ReadActions Choreo.
     *
     * @param string $value (conditional, string) The namespace that you chose for you app. This can be found in the Settings section of your App page. Required unless you provide the ActionID.
     * @return Facebook_Actions_Custom_ReadActions_Inputs For method chaining.
     */
    public function setAppNamespace($value)
    {
        return $this->set('AppNamespace', $value);
    }

    /**
     * Set the value for the Fields input for this ReadActions Choreo.
     *
     * @param string $value (optional, string) A comma separated list of fields to return (i.e. id,name).
     * @return Facebook_Actions_Custom_ReadActions_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Limit input for this ReadActions Choreo.
     *
     * @param int $value (optional, integer) Used to page through results. Limits the number of records returned in the response.
     * @return Facebook_Actions_Custom_ReadActions_Inputs For method chaining.
     */
    public function setLimit($value)
    {
        return $this->set('Limit', $value);
    }

    /**
     * Set the value for the Offset input for this ReadActions Choreo.
     *
     * @param int $value (optional, integer) Used to page through results. Returns results starting from the specified number.
     * @return Facebook_Actions_Custom_ReadActions_Inputs For method chaining.
     */
    public function setOffset($value)
    {
        return $this->set('Offset', $value);
    }

    /**
     * Set the value for the ProfileID input for this ReadActions Choreo.
     *
     * @param string $value (optional, string) The id of the user's profile. Defaults to "me" indicating the authenticated user.
     * @return Facebook_Actions_Custom_ReadActions_Inputs For method chaining.
     */
    public function setProfileID($value)
    {
        return $this->set('ProfileID', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this ReadActions Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Can be set to xml or json. Defaults to json.
     * @return Facebook_Actions_Custom_ReadActions_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }
}


/**
 * Execution object for the ReadActions Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Custom_ReadActions_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the ReadActions Choreo.
     *
     * @param Temboo_Session $session The session that owns this ReadActions execution.
     * @param Facebook_Actions_Custom_ReadActions $choreo The choreography object for this execution.
     * @param Facebook_Actions_Custom_ReadActions_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Custom_ReadActions_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Custom_ReadActions_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Actions_Custom_ReadActions $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this ReadActions execution.
     *
     * @return Facebook_Actions_Custom_ReadActions_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this ReadActions execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Actions_Custom_ReadActions_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Actions_Custom_ReadActions_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the ReadActions Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Custom_ReadActions_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the ReadActions Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Actions_Custom_ReadActions_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "HasNext" output from this ReadActions execution.
     *
     * @return bool (boolean) A boolean flag indicating that a next page exists.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getHasNext()
    {
        return $this->get('HasNext');
    }
    /**
     * Retrieve the value for the "HasPrevious" output from this ReadActions execution.
     *
     * @return bool (boolean) A boolean flag indicating that a previous page exists.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getHasPrevious()
    {
        return $this->get('HasPrevious');
    }
    /**
     * Retrieve the value for the "Response" output from this ReadActions execution.
     *
     * @return string The response from Facebook. Corresponds to the ResponseFormat input. Defaults to JSON.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Updates an existing custom action.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Custom_UpdateAction extends Temboo_Choreography
{
    /**
     * Updates an existing custom action.
     *
     * @param Temboo_Session $session The session that owns this UpdateAction Choreo.
     * @return Facebook_Actions_Custom_UpdateAction New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Actions/Custom/UpdateAction/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this UpdateAction Choreo.
     *
     * @param Facebook_Actions_Custom_UpdateAction_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Custom_UpdateAction_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Custom_UpdateAction_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Actions_Custom_UpdateAction_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this UpdateAction Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Custom_UpdateAction_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Actions_Custom_UpdateAction_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the UpdateAction Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Custom_UpdateAction_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the UpdateAction Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Custom_UpdateAction_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this UpdateAction input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Actions_Custom_UpdateAction_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Actions_Custom_UpdateAction_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this UpdateAction Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Actions_Custom_UpdateAction_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ActionID input for this UpdateAction Choreo.
     *
     * @param string $value (required, string) The id of the action to update.
     * @return Facebook_Actions_Custom_UpdateAction_Inputs For method chaining.
     */
    public function setActionID($value)
    {
        return $this->set('ActionID', $value);
    }

    /**
     * Set the value for the EndTime input for this UpdateAction Choreo.
     *
     * @param string $value (optional, date) The time that the user ended the action (e.g. 2013-06-24T18:53:35+0000).
     * @return Facebook_Actions_Custom_UpdateAction_Inputs For method chaining.
     */
    public function setEndTime($value)
    {
        return $this->set('EndTime', $value);
    }

    /**
     * Set the value for the ExpiresIn input for this UpdateAction Choreo.
     *
     * @param int $value (optional, integer) The amount of time (in milliseconds) from the publish_time that the action will expire.
     * @return Facebook_Actions_Custom_UpdateAction_Inputs For method chaining.
     */
    public function setExpiresIn($value)
    {
        return $this->set('ExpiresIn', $value);
    }

    /**
     * Set the value for the Message input for this UpdateAction Choreo.
     *
     * @param string $value (optional, string) A message attached to this action. Setting this parameter requires enabling of message capabilities.
     * @return Facebook_Actions_Custom_UpdateAction_Inputs For method chaining.
     */
    public function setMessage($value)
    {
        return $this->set('Message', $value);
    }

    /**
     * Set the value for the Place input for this UpdateAction Choreo.
     *
     * @param string $value (optional, string) The URL or ID for an Open Graph object representing the location associated with this action.
     * @return Facebook_Actions_Custom_UpdateAction_Inputs For method chaining.
     */
    public function setPlace($value)
    {
        return $this->set('Place', $value);
    }

    /**
     * Set the value for the PropertyName input for this UpdateAction Choreo.
     *
     * @param string $value (optional, string) The name of a property that you've defined for this Open Graph story. This will be an object type (e.g. album, song, book). Multiple property names can be separated by commas.
     * @return Facebook_Actions_Custom_UpdateAction_Inputs For method chaining.
     */
    public function setPropertyName($value)
    {
        return $this->set('PropertyName', $value);
    }

    /**
     * Set the value for the PropertyValue input for this UpdateAction Choreo.
     *
     * @param string $value (optional, string) The URL or ID for an Open Graph object representing the object specified as the PropertyName. Multiple property values can be separated by commas.
     * @return Facebook_Actions_Custom_UpdateAction_Inputs For method chaining.
     */
    public function setPropertyValue($value)
    {
        return $this->set('PropertyValue', $value);
    }

    /**
     * Set the value for the Tags input for this UpdateAction Choreo.
     *
     * @param string $value (optional, string) A comma separated list of other profile IDs that also performed this action.
     * @return Facebook_Actions_Custom_UpdateAction_Inputs For method chaining.
     */
    public function setTags($value)
    {
        return $this->set('Tags', $value);
    }
}


/**
 * Execution object for the UpdateAction Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Custom_UpdateAction_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the UpdateAction Choreo.
     *
     * @param Temboo_Session $session The session that owns this UpdateAction execution.
     * @param Facebook_Actions_Custom_UpdateAction $choreo The choreography object for this execution.
     * @param Facebook_Actions_Custom_UpdateAction_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Custom_UpdateAction_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Custom_UpdateAction_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Actions_Custom_UpdateAction $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this UpdateAction execution.
     *
     * @return Facebook_Actions_Custom_UpdateAction_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this UpdateAction execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Actions_Custom_UpdateAction_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Actions_Custom_UpdateAction_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the UpdateAction Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Custom_UpdateAction_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the UpdateAction Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Actions_Custom_UpdateAction_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this UpdateAction execution.
     *
     * @return string The response from Facebook.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Creates an action that represents a user cycling a course.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Fitness_Bikes_CreateBike extends Temboo_Choreography
{
    /**
     * Creates an action that represents a user cycling a course.
     *
     * @param Temboo_Session $session The session that owns this CreateBike Choreo.
     * @return Facebook_Actions_Fitness_Bikes_CreateBike New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Actions/Fitness/Bikes/CreateBike/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this CreateBike Choreo.
     *
     * @param Facebook_Actions_Fitness_Bikes_CreateBike_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Fitness_Bikes_CreateBike_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Fitness_Bikes_CreateBike_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Actions_Fitness_Bikes_CreateBike_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this CreateBike Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Fitness_Bikes_CreateBike_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Actions_Fitness_Bikes_CreateBike_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the CreateBike Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Fitness_Bikes_CreateBike_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the CreateBike Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Fitness_Bikes_CreateBike_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this CreateBike input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Actions_Fitness_Bikes_CreateBike_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Actions_Fitness_Bikes_CreateBike_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this CreateBike Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Actions_Fitness_Bikes_CreateBike_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the Course input for this CreateBike Choreo.
     *
     * @param string $value (required, string) The URL or ID for an Open Graph object representing the course.
     * @return Facebook_Actions_Fitness_Bikes_CreateBike_Inputs For method chaining.
     */
    public function setCourse($value)
    {
        return $this->set('Course', $value);
    }

    /**
     * Set the value for the CreatedTime input for this CreateBike Choreo.
     *
     * @param string $value (optional, date) The time that the action was created (e.g. 2013-06-24T18:53:35+0000).
     * @return Facebook_Actions_Fitness_Bikes_CreateBike_Inputs For method chaining.
     */
    public function setCreatedTime($value)
    {
        return $this->set('CreatedTime', $value);
    }

    /**
     * Set the value for the EndTime input for this CreateBike Choreo.
     *
     * @param string $value (optional, date) The time that the user ended the action (e.g. 2013-06-24T18:53:35+0000).
     * @return Facebook_Actions_Fitness_Bikes_CreateBike_Inputs For method chaining.
     */
    public function setEndTime($value)
    {
        return $this->set('EndTime', $value);
    }

    /**
     * Set the value for the ExpiresIn input for this CreateBike Choreo.
     *
     * @param int $value (optional, integer) The amount of time (in milliseconds) from the publish_time that the action will expire.
     * @return Facebook_Actions_Fitness_Bikes_CreateBike_Inputs For method chaining.
     */
    public function setExpiresIn($value)
    {
        return $this->set('ExpiresIn', $value);
    }

    /**
     * Set the value for the ExplicitlyShared input for this CreateBike Choreo.
     *
     * @param bool $value (optional, boolean) Indicates that the user is explicitly sharing this action. Requires the explicitly_shared capability to be enabled.
     * @return Facebook_Actions_Fitness_Bikes_CreateBike_Inputs For method chaining.
     */
    public function setExplicitlyShared($value)
    {
        return $this->set('ExplicitlyShared', $value);
    }

    /**
     * Set the value for the ExplicityShared input for this CreateBike Choreo.
     *
     * @param bool $value (optional, boolean) Deprecated (retained for backward compatibility only).
     * @return Facebook_Actions_Fitness_Bikes_CreateBike_Inputs For method chaining.
     */
    public function setExplicityShared($value)
    {
        return $this->set('ExplicityShared', $value);
    }

    /**
     * Set the value for the Message input for this CreateBike Choreo.
     *
     * @param string $value (optional, string) A message attached to this action. Setting this parameter requires enabling of message capabilities.
     * @return Facebook_Actions_Fitness_Bikes_CreateBike_Inputs For method chaining.
     */
    public function setMessage($value)
    {
        return $this->set('Message', $value);
    }

    /**
     * Set the value for the NoFeedStory input for this CreateBike Choreo.
     *
     * @param bool $value (optional, boolean) Whether or not this action should be posted to the users feed.
     * @return Facebook_Actions_Fitness_Bikes_CreateBike_Inputs For method chaining.
     */
    public function setNoFeedStory($value)
    {
        return $this->set('NoFeedStory', $value);
    }

    /**
     * Set the value for the Place input for this CreateBike Choreo.
     *
     * @param string $value (optional, string) The URL or ID for an Open Graph object representing the location associated with this action.
     * @return Facebook_Actions_Fitness_Bikes_CreateBike_Inputs For method chaining.
     */
    public function setPlace($value)
    {
        return $this->set('Place', $value);
    }

    /**
     * Set the value for the ProfileID input for this CreateBike Choreo.
     *
     * @param string $value (optional, string) The id of the user's profile. Defaults to "me" indicating the authenticated user.
     * @return Facebook_Actions_Fitness_Bikes_CreateBike_Inputs For method chaining.
     */
    public function setProfileID($value)
    {
        return $this->set('ProfileID', $value);
    }

    /**
     * Set the value for the Reference input for this CreateBike Choreo.
     *
     * @param string $value (optional, string) A string identifier up to 50 characters used for tracking and insights.
     * @return Facebook_Actions_Fitness_Bikes_CreateBike_Inputs For method chaining.
     */
    public function setReference($value)
    {
        return $this->set('Reference', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this CreateBike Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Can be set to xml or json. Defaults to json.
     * @return Facebook_Actions_Fitness_Bikes_CreateBike_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }

    /**
     * Set the value for the StartTime input for this CreateBike Choreo.
     *
     * @param string $value (optional, date) The time that the user started the action (e.g. 2013-06-24T18:53:35+0000).
     * @return Facebook_Actions_Fitness_Bikes_CreateBike_Inputs For method chaining.
     */
    public function setStartTime($value)
    {
        return $this->set('StartTime', $value);
    }

    /**
     * Set the value for the Tags input for this CreateBike Choreo.
     *
     * @param string $value (optional, string) A comma separated list of other profile IDs that also performed this action.
     * @return Facebook_Actions_Fitness_Bikes_CreateBike_Inputs For method chaining.
     */
    public function setTags($value)
    {
        return $this->set('Tags', $value);
    }
}


/**
 * Execution object for the CreateBike Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Fitness_Bikes_CreateBike_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the CreateBike Choreo.
     *
     * @param Temboo_Session $session The session that owns this CreateBike execution.
     * @param Facebook_Actions_Fitness_Bikes_CreateBike $choreo The choreography object for this execution.
     * @param Facebook_Actions_Fitness_Bikes_CreateBike_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Fitness_Bikes_CreateBike_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Fitness_Bikes_CreateBike_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Actions_Fitness_Bikes_CreateBike $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this CreateBike execution.
     *
     * @return Facebook_Actions_Fitness_Bikes_CreateBike_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this CreateBike execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Actions_Fitness_Bikes_CreateBike_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Actions_Fitness_Bikes_CreateBike_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the CreateBike Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Fitness_Bikes_CreateBike_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the CreateBike Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Actions_Fitness_Bikes_CreateBike_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "ActivityURL" output from this CreateBike execution.
     *
     * @return string (string) The URL for the newly created action.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getActivityURL()
    {
        return $this->get('ActivityURL');
    }
    /**
     * Retrieve the value for the "Response" output from this CreateBike execution.
     *
     * @return string The response from Facebook. Corresponds to the ResponseFormat input. Defaults to JSON.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Deletes a given bike action.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Fitness_Bikes_DeleteBike extends Temboo_Choreography
{
    /**
     * Deletes a given bike action.
     *
     * @param Temboo_Session $session The session that owns this DeleteBike Choreo.
     * @return Facebook_Actions_Fitness_Bikes_DeleteBike New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Actions/Fitness/Bikes/DeleteBike/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this DeleteBike Choreo.
     *
     * @param Facebook_Actions_Fitness_Bikes_DeleteBike_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Fitness_Bikes_DeleteBike_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Fitness_Bikes_DeleteBike_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Actions_Fitness_Bikes_DeleteBike_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this DeleteBike Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Fitness_Bikes_DeleteBike_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Actions_Fitness_Bikes_DeleteBike_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the DeleteBike Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Fitness_Bikes_DeleteBike_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the DeleteBike Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Fitness_Bikes_DeleteBike_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this DeleteBike input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Actions_Fitness_Bikes_DeleteBike_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Actions_Fitness_Bikes_DeleteBike_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this DeleteBike Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Actions_Fitness_Bikes_DeleteBike_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ActionID input for this DeleteBike Choreo.
     *
     * @param string $value (required, string) The id of an action to delete.
     * @return Facebook_Actions_Fitness_Bikes_DeleteBike_Inputs For method chaining.
     */
    public function setActionID($value)
    {
        return $this->set('ActionID', $value);
    }
}


/**
 * Execution object for the DeleteBike Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Fitness_Bikes_DeleteBike_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the DeleteBike Choreo.
     *
     * @param Temboo_Session $session The session that owns this DeleteBike execution.
     * @param Facebook_Actions_Fitness_Bikes_DeleteBike $choreo The choreography object for this execution.
     * @param Facebook_Actions_Fitness_Bikes_DeleteBike_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Fitness_Bikes_DeleteBike_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Fitness_Bikes_DeleteBike_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Actions_Fitness_Bikes_DeleteBike $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this DeleteBike execution.
     *
     * @return Facebook_Actions_Fitness_Bikes_DeleteBike_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this DeleteBike execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Actions_Fitness_Bikes_DeleteBike_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Actions_Fitness_Bikes_DeleteBike_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the DeleteBike Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Fitness_Bikes_DeleteBike_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the DeleteBike Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Actions_Fitness_Bikes_DeleteBike_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this DeleteBike execution.
     *
     * @return bool (boolean) The response from Facebook. Returns "true" on success.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Retrieves one or more bike actions.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Fitness_Bikes_ReadBikes extends Temboo_Choreography
{
    /**
     * Retrieves one or more bike actions.
     *
     * @param Temboo_Session $session The session that owns this ReadBikes Choreo.
     * @return Facebook_Actions_Fitness_Bikes_ReadBikes New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Actions/Fitness/Bikes/ReadBikes/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this ReadBikes Choreo.
     *
     * @param Facebook_Actions_Fitness_Bikes_ReadBikes_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Fitness_Bikes_ReadBikes_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Fitness_Bikes_ReadBikes_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Actions_Fitness_Bikes_ReadBikes_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this ReadBikes Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Fitness_Bikes_ReadBikes_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Actions_Fitness_Bikes_ReadBikes_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the ReadBikes Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Fitness_Bikes_ReadBikes_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the ReadBikes Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Fitness_Bikes_ReadBikes_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this ReadBikes input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Actions_Fitness_Bikes_ReadBikes_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Actions_Fitness_Bikes_ReadBikes_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this ReadBikes Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Actions_Fitness_Bikes_ReadBikes_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ActionID input for this ReadBikes Choreo.
     *
     * @param string $value (optional, string) The id of an action to retrieve. If an id is not provided, a list of all bike actions will be returned.
     * @return Facebook_Actions_Fitness_Bikes_ReadBikes_Inputs For method chaining.
     */
    public function setActionID($value)
    {
        return $this->set('ActionID', $value);
    }

    /**
     * Set the value for the Fields input for this ReadBikes Choreo.
     *
     * @param string $value (optional, string) A comma separated list of fields to return (i.e. id,name).
     * @return Facebook_Actions_Fitness_Bikes_ReadBikes_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Limit input for this ReadBikes Choreo.
     *
     * @param int $value (optional, integer) Used to page through results. Limits the number of records returned in the response.
     * @return Facebook_Actions_Fitness_Bikes_ReadBikes_Inputs For method chaining.
     */
    public function setLimit($value)
    {
        return $this->set('Limit', $value);
    }

    /**
     * Set the value for the Offset input for this ReadBikes Choreo.
     *
     * @param int $value (optional, integer) Used to page through results. Returns results starting from the specified number.
     * @return Facebook_Actions_Fitness_Bikes_ReadBikes_Inputs For method chaining.
     */
    public function setOffset($value)
    {
        return $this->set('Offset', $value);
    }

    /**
     * Set the value for the ProfileID input for this ReadBikes Choreo.
     *
     * @param string $value (optional, string) The id of the user's profile. Defaults to "me" indicating the authenticated user.
     * @return Facebook_Actions_Fitness_Bikes_ReadBikes_Inputs For method chaining.
     */
    public function setProfileID($value)
    {
        return $this->set('ProfileID', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this ReadBikes Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Can be set to xml or json. Defaults to json.
     * @return Facebook_Actions_Fitness_Bikes_ReadBikes_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }
}


/**
 * Execution object for the ReadBikes Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Fitness_Bikes_ReadBikes_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the ReadBikes Choreo.
     *
     * @param Temboo_Session $session The session that owns this ReadBikes execution.
     * @param Facebook_Actions_Fitness_Bikes_ReadBikes $choreo The choreography object for this execution.
     * @param Facebook_Actions_Fitness_Bikes_ReadBikes_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Fitness_Bikes_ReadBikes_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Fitness_Bikes_ReadBikes_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Actions_Fitness_Bikes_ReadBikes $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this ReadBikes execution.
     *
     * @return Facebook_Actions_Fitness_Bikes_ReadBikes_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this ReadBikes execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Actions_Fitness_Bikes_ReadBikes_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Actions_Fitness_Bikes_ReadBikes_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the ReadBikes Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Fitness_Bikes_ReadBikes_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the ReadBikes Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Actions_Fitness_Bikes_ReadBikes_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "HasNext" output from this ReadBikes execution.
     *
     * @return bool (boolean) A boolean flag indicating that a next page exists.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getHasNext()
    {
        return $this->get('HasNext');
    }
    /**
     * Retrieve the value for the "HasPrevious" output from this ReadBikes execution.
     *
     * @return bool (boolean) A boolean flag indicating that a previous page exists.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getHasPrevious()
    {
        return $this->get('HasPrevious');
    }
    /**
     * Retrieve the value for the "Response" output from this ReadBikes execution.
     *
     * @return string The response from Facebook. Corresponds to the ResponseFormat input. Defaults to JSON.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Updates an existing bike action.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Fitness_Bikes_UpdateBike extends Temboo_Choreography
{
    /**
     * Updates an existing bike action.
     *
     * @param Temboo_Session $session The session that owns this UpdateBike Choreo.
     * @return Facebook_Actions_Fitness_Bikes_UpdateBike New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Actions/Fitness/Bikes/UpdateBike/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this UpdateBike Choreo.
     *
     * @param Facebook_Actions_Fitness_Bikes_UpdateBike_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Fitness_Bikes_UpdateBike_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Fitness_Bikes_UpdateBike_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Actions_Fitness_Bikes_UpdateBike_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this UpdateBike Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Fitness_Bikes_UpdateBike_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Actions_Fitness_Bikes_UpdateBike_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the UpdateBike Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Fitness_Bikes_UpdateBike_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the UpdateBike Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Fitness_Bikes_UpdateBike_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this UpdateBike input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Actions_Fitness_Bikes_UpdateBike_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Actions_Fitness_Bikes_UpdateBike_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this UpdateBike Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Actions_Fitness_Bikes_UpdateBike_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ActionID input for this UpdateBike Choreo.
     *
     * @param string $value (required, string) The id of the action to update.
     * @return Facebook_Actions_Fitness_Bikes_UpdateBike_Inputs For method chaining.
     */
    public function setActionID($value)
    {
        return $this->set('ActionID', $value);
    }

    /**
     * Set the value for the Course input for this UpdateBike Choreo.
     *
     * @param string $value (optional, string) The URL or ID for an Open Graph object representing the course.
     * @return Facebook_Actions_Fitness_Bikes_UpdateBike_Inputs For method chaining.
     */
    public function setCourse($value)
    {
        return $this->set('Course', $value);
    }

    /**
     * Set the value for the EndTime input for this UpdateBike Choreo.
     *
     * @param string $value (optional, date) The time that the user ended the action (e.g. 2013-06-24T18:53:35+0000).
     * @return Facebook_Actions_Fitness_Bikes_UpdateBike_Inputs For method chaining.
     */
    public function setEndTime($value)
    {
        return $this->set('EndTime', $value);
    }

    /**
     * Set the value for the ExpiresIn input for this UpdateBike Choreo.
     *
     * @param int $value (optional, integer) The amount of time (in milliseconds) from the publish_time that the action will expire.
     * @return Facebook_Actions_Fitness_Bikes_UpdateBike_Inputs For method chaining.
     */
    public function setExpiresIn($value)
    {
        return $this->set('ExpiresIn', $value);
    }

    /**
     * Set the value for the Message input for this UpdateBike Choreo.
     *
     * @param string $value (optional, string) A message attached to this fitness action. Setting this parameter requires enabling of message capabilities.
     * @return Facebook_Actions_Fitness_Bikes_UpdateBike_Inputs For method chaining.
     */
    public function setMessage($value)
    {
        return $this->set('Message', $value);
    }

    /**
     * Set the value for the Place input for this UpdateBike Choreo.
     *
     * @param string $value (optional, string) The URL or ID for an Open Graph object representing the location associated with this action.
     * @return Facebook_Actions_Fitness_Bikes_UpdateBike_Inputs For method chaining.
     */
    public function setPlace($value)
    {
        return $this->set('Place', $value);
    }

    /**
     * Set the value for the Tags input for this UpdateBike Choreo.
     *
     * @param string $value (optional, string) A comma separated list of other profile IDs that also performed this action.
     * @return Facebook_Actions_Fitness_Bikes_UpdateBike_Inputs For method chaining.
     */
    public function setTags($value)
    {
        return $this->set('Tags', $value);
    }
}


/**
 * Execution object for the UpdateBike Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Fitness_Bikes_UpdateBike_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the UpdateBike Choreo.
     *
     * @param Temboo_Session $session The session that owns this UpdateBike execution.
     * @param Facebook_Actions_Fitness_Bikes_UpdateBike $choreo The choreography object for this execution.
     * @param Facebook_Actions_Fitness_Bikes_UpdateBike_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Fitness_Bikes_UpdateBike_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Fitness_Bikes_UpdateBike_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Actions_Fitness_Bikes_UpdateBike $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this UpdateBike execution.
     *
     * @return Facebook_Actions_Fitness_Bikes_UpdateBike_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this UpdateBike execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Actions_Fitness_Bikes_UpdateBike_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Actions_Fitness_Bikes_UpdateBike_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the UpdateBike Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Fitness_Bikes_UpdateBike_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the UpdateBike Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Actions_Fitness_Bikes_UpdateBike_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this UpdateBike execution.
     *
     * @return bool (boolean) The response from Facebook.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Creates an action that represents a user running a course.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Fitness_Runs_CreateRun extends Temboo_Choreography
{
    /**
     * Creates an action that represents a user running a course.
     *
     * @param Temboo_Session $session The session that owns this CreateRun Choreo.
     * @return Facebook_Actions_Fitness_Runs_CreateRun New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Actions/Fitness/Runs/CreateRun/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this CreateRun Choreo.
     *
     * @param Facebook_Actions_Fitness_Runs_CreateRun_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Fitness_Runs_CreateRun_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Fitness_Runs_CreateRun_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Actions_Fitness_Runs_CreateRun_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this CreateRun Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Fitness_Runs_CreateRun_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Actions_Fitness_Runs_CreateRun_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the CreateRun Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Fitness_Runs_CreateRun_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the CreateRun Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Fitness_Runs_CreateRun_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this CreateRun input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Actions_Fitness_Runs_CreateRun_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Actions_Fitness_Runs_CreateRun_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this CreateRun Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Actions_Fitness_Runs_CreateRun_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the Course input for this CreateRun Choreo.
     *
     * @param string $value (required, string) The URL or ID for an Open Graph object representing the course.
     * @return Facebook_Actions_Fitness_Runs_CreateRun_Inputs For method chaining.
     */
    public function setCourse($value)
    {
        return $this->set('Course', $value);
    }

    /**
     * Set the value for the CreatedTime input for this CreateRun Choreo.
     *
     * @param string $value (optional, date) The time that the action was created (e.g. 2013-06-24T18:53:35+0000).
     * @return Facebook_Actions_Fitness_Runs_CreateRun_Inputs For method chaining.
     */
    public function setCreatedTime($value)
    {
        return $this->set('CreatedTime', $value);
    }

    /**
     * Set the value for the EndTime input for this CreateRun Choreo.
     *
     * @param string $value (optional, date) The time that the user ended the action (e.g. 2013-06-24T18:53:35+0000).
     * @return Facebook_Actions_Fitness_Runs_CreateRun_Inputs For method chaining.
     */
    public function setEndTime($value)
    {
        return $this->set('EndTime', $value);
    }

    /**
     * Set the value for the ExpiresIn input for this CreateRun Choreo.
     *
     * @param int $value (optional, integer) The amount of time (in milliseconds) from the publish_time that the action will expire.
     * @return Facebook_Actions_Fitness_Runs_CreateRun_Inputs For method chaining.
     */
    public function setExpiresIn($value)
    {
        return $this->set('ExpiresIn', $value);
    }

    /**
     * Set the value for the ExplicitlyShared input for this CreateRun Choreo.
     *
     * @param bool $value (optional, boolean) Indicates that the user is explicitly sharing this action. Requires the explicitly_shared capability to be enabled.
     * @return Facebook_Actions_Fitness_Runs_CreateRun_Inputs For method chaining.
     */
    public function setExplicitlyShared($value)
    {
        return $this->set('ExplicitlyShared', $value);
    }

    /**
     * Set the value for the ExplicityShared input for this CreateRun Choreo.
     *
     * @param bool $value (optional, boolean) Deprecated (retained for backward compatibility only).
     * @return Facebook_Actions_Fitness_Runs_CreateRun_Inputs For method chaining.
     */
    public function setExplicityShared($value)
    {
        return $this->set('ExplicityShared', $value);
    }

    /**
     * Set the value for the Message input for this CreateRun Choreo.
     *
     * @param string $value (optional, string) A message attached to this action. Setting this parameter requires enabling of message capabilities.
     * @return Facebook_Actions_Fitness_Runs_CreateRun_Inputs For method chaining.
     */
    public function setMessage($value)
    {
        return $this->set('Message', $value);
    }

    /**
     * Set the value for the NoFeedStory input for this CreateRun Choreo.
     *
     * @param bool $value (optional, boolean) Whether or not this action should be posted to the users feed.
     * @return Facebook_Actions_Fitness_Runs_CreateRun_Inputs For method chaining.
     */
    public function setNoFeedStory($value)
    {
        return $this->set('NoFeedStory', $value);
    }

    /**
     * Set the value for the Place input for this CreateRun Choreo.
     *
     * @param string $value (optional, string) The URL or ID for an Open Graph object representing the location associated with this action.
     * @return Facebook_Actions_Fitness_Runs_CreateRun_Inputs For method chaining.
     */
    public function setPlace($value)
    {
        return $this->set('Place', $value);
    }

    /**
     * Set the value for the ProfileID input for this CreateRun Choreo.
     *
     * @param string $value (optional, string) The id of the user's profile. Defaults to "me" indicating the authenticated user.
     * @return Facebook_Actions_Fitness_Runs_CreateRun_Inputs For method chaining.
     */
    public function setProfileID($value)
    {
        return $this->set('ProfileID', $value);
    }

    /**
     * Set the value for the Reference input for this CreateRun Choreo.
     *
     * @param string $value (optional, string) A string identifier up to 50 characters used for tracking and insights.
     * @return Facebook_Actions_Fitness_Runs_CreateRun_Inputs For method chaining.
     */
    public function setReference($value)
    {
        return $this->set('Reference', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this CreateRun Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Can be set to xml or json. Defaults to json.
     * @return Facebook_Actions_Fitness_Runs_CreateRun_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }

    /**
     * Set the value for the StartTime input for this CreateRun Choreo.
     *
     * @param string $value (optional, date) The time that the user started the action (e.g. 2013-06-24T18:53:35+0000).
     * @return Facebook_Actions_Fitness_Runs_CreateRun_Inputs For method chaining.
     */
    public function setStartTime($value)
    {
        return $this->set('StartTime', $value);
    }

    /**
     * Set the value for the Tags input for this CreateRun Choreo.
     *
     * @param string $value (optional, string) A comma separated list of other profile IDs that also performed this action.
     * @return Facebook_Actions_Fitness_Runs_CreateRun_Inputs For method chaining.
     */
    public function setTags($value)
    {
        return $this->set('Tags', $value);
    }
}


/**
 * Execution object for the CreateRun Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Fitness_Runs_CreateRun_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the CreateRun Choreo.
     *
     * @param Temboo_Session $session The session that owns this CreateRun execution.
     * @param Facebook_Actions_Fitness_Runs_CreateRun $choreo The choreography object for this execution.
     * @param Facebook_Actions_Fitness_Runs_CreateRun_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Fitness_Runs_CreateRun_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Fitness_Runs_CreateRun_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Actions_Fitness_Runs_CreateRun $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this CreateRun execution.
     *
     * @return Facebook_Actions_Fitness_Runs_CreateRun_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this CreateRun execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Actions_Fitness_Runs_CreateRun_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Actions_Fitness_Runs_CreateRun_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the CreateRun Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Fitness_Runs_CreateRun_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the CreateRun Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Actions_Fitness_Runs_CreateRun_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "ActivityURL" output from this CreateRun execution.
     *
     * @return string (string) The URL for the newly created action.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getActivityURL()
    {
        return $this->get('ActivityURL');
    }
    /**
     * Retrieve the value for the "Response" output from this CreateRun execution.
     *
     * @return string The response from Facebook. Corresponds to the ResponseFormat input. Defaults to JSON.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Deletes a given run action.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Fitness_Runs_DeleteRun extends Temboo_Choreography
{
    /**
     * Deletes a given run action.
     *
     * @param Temboo_Session $session The session that owns this DeleteRun Choreo.
     * @return Facebook_Actions_Fitness_Runs_DeleteRun New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Actions/Fitness/Runs/DeleteRun/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this DeleteRun Choreo.
     *
     * @param Facebook_Actions_Fitness_Runs_DeleteRun_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Fitness_Runs_DeleteRun_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Fitness_Runs_DeleteRun_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Actions_Fitness_Runs_DeleteRun_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this DeleteRun Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Fitness_Runs_DeleteRun_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Actions_Fitness_Runs_DeleteRun_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the DeleteRun Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Fitness_Runs_DeleteRun_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the DeleteRun Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Fitness_Runs_DeleteRun_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this DeleteRun input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Actions_Fitness_Runs_DeleteRun_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Actions_Fitness_Runs_DeleteRun_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this DeleteRun Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Actions_Fitness_Runs_DeleteRun_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ActionID input for this DeleteRun Choreo.
     *
     * @param string $value (required, string) The id of an action to delete.
     * @return Facebook_Actions_Fitness_Runs_DeleteRun_Inputs For method chaining.
     */
    public function setActionID($value)
    {
        return $this->set('ActionID', $value);
    }
}


/**
 * Execution object for the DeleteRun Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Fitness_Runs_DeleteRun_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the DeleteRun Choreo.
     *
     * @param Temboo_Session $session The session that owns this DeleteRun execution.
     * @param Facebook_Actions_Fitness_Runs_DeleteRun $choreo The choreography object for this execution.
     * @param Facebook_Actions_Fitness_Runs_DeleteRun_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Fitness_Runs_DeleteRun_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Fitness_Runs_DeleteRun_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Actions_Fitness_Runs_DeleteRun $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this DeleteRun execution.
     *
     * @return Facebook_Actions_Fitness_Runs_DeleteRun_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this DeleteRun execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Actions_Fitness_Runs_DeleteRun_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Actions_Fitness_Runs_DeleteRun_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the DeleteRun Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Fitness_Runs_DeleteRun_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the DeleteRun Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Actions_Fitness_Runs_DeleteRun_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this DeleteRun execution.
     *
     * @return bool (boolean) The response from Facebook. Returns "true" on success.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Retrieves one or more run actions.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Fitness_Runs_ReadRuns extends Temboo_Choreography
{
    /**
     * Retrieves one or more run actions.
     *
     * @param Temboo_Session $session The session that owns this ReadRuns Choreo.
     * @return Facebook_Actions_Fitness_Runs_ReadRuns New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Actions/Fitness/Runs/ReadRuns/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this ReadRuns Choreo.
     *
     * @param Facebook_Actions_Fitness_Runs_ReadRuns_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Fitness_Runs_ReadRuns_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Fitness_Runs_ReadRuns_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Actions_Fitness_Runs_ReadRuns_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this ReadRuns Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Fitness_Runs_ReadRuns_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Actions_Fitness_Runs_ReadRuns_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the ReadRuns Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Fitness_Runs_ReadRuns_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the ReadRuns Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Fitness_Runs_ReadRuns_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this ReadRuns input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Actions_Fitness_Runs_ReadRuns_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Actions_Fitness_Runs_ReadRuns_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this ReadRuns Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Actions_Fitness_Runs_ReadRuns_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ActionID input for this ReadRuns Choreo.
     *
     * @param string $value (optional, string) The id of an action to retrieve. If an id is not provided, a list of all run actions will be returned.
     * @return Facebook_Actions_Fitness_Runs_ReadRuns_Inputs For method chaining.
     */
    public function setActionID($value)
    {
        return $this->set('ActionID', $value);
    }

    /**
     * Set the value for the Fields input for this ReadRuns Choreo.
     *
     * @param string $value (optional, string) A comma separated list of fields to return (i.e. id,name).
     * @return Facebook_Actions_Fitness_Runs_ReadRuns_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Limit input for this ReadRuns Choreo.
     *
     * @param int $value (optional, integer) Used to page through results. Limits the number of records returned in the response.
     * @return Facebook_Actions_Fitness_Runs_ReadRuns_Inputs For method chaining.
     */
    public function setLimit($value)
    {
        return $this->set('Limit', $value);
    }

    /**
     * Set the value for the Offset input for this ReadRuns Choreo.
     *
     * @param int $value (optional, integer) Used to page through results. Returns results starting from the specified number.
     * @return Facebook_Actions_Fitness_Runs_ReadRuns_Inputs For method chaining.
     */
    public function setOffset($value)
    {
        return $this->set('Offset', $value);
    }

    /**
     * Set the value for the ProfileID input for this ReadRuns Choreo.
     *
     * @param string $value (optional, string) The id of the user's profile. Defaults to "me" indicating the authenticated user.
     * @return Facebook_Actions_Fitness_Runs_ReadRuns_Inputs For method chaining.
     */
    public function setProfileID($value)
    {
        return $this->set('ProfileID', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this ReadRuns Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Can be set to xml or json. Defaults to json.
     * @return Facebook_Actions_Fitness_Runs_ReadRuns_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }
}


/**
 * Execution object for the ReadRuns Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Fitness_Runs_ReadRuns_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the ReadRuns Choreo.
     *
     * @param Temboo_Session $session The session that owns this ReadRuns execution.
     * @param Facebook_Actions_Fitness_Runs_ReadRuns $choreo The choreography object for this execution.
     * @param Facebook_Actions_Fitness_Runs_ReadRuns_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Fitness_Runs_ReadRuns_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Fitness_Runs_ReadRuns_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Actions_Fitness_Runs_ReadRuns $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this ReadRuns execution.
     *
     * @return Facebook_Actions_Fitness_Runs_ReadRuns_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this ReadRuns execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Actions_Fitness_Runs_ReadRuns_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Actions_Fitness_Runs_ReadRuns_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the ReadRuns Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Fitness_Runs_ReadRuns_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the ReadRuns Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Actions_Fitness_Runs_ReadRuns_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "HasNext" output from this ReadRuns execution.
     *
     * @return bool (boolean) A boolean flag indicating that a next page exists.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getHasNext()
    {
        return $this->get('HasNext');
    }
    /**
     * Retrieve the value for the "HasPrevious" output from this ReadRuns execution.
     *
     * @return bool (boolean) A boolean flag indicating that a previous page exists.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getHasPrevious()
    {
        return $this->get('HasPrevious');
    }
    /**
     * Retrieve the value for the "Response" output from this ReadRuns execution.
     *
     * @return string The response from Facebook. Corresponds to the ResponseFormat input. Defaults to JSON.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Updates an existing run action.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Fitness_Runs_UpdateRun extends Temboo_Choreography
{
    /**
     * Updates an existing run action.
     *
     * @param Temboo_Session $session The session that owns this UpdateRun Choreo.
     * @return Facebook_Actions_Fitness_Runs_UpdateRun New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Actions/Fitness/Runs/UpdateRun/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this UpdateRun Choreo.
     *
     * @param Facebook_Actions_Fitness_Runs_UpdateRun_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Fitness_Runs_UpdateRun_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Fitness_Runs_UpdateRun_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Actions_Fitness_Runs_UpdateRun_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this UpdateRun Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Fitness_Runs_UpdateRun_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Actions_Fitness_Runs_UpdateRun_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the UpdateRun Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Fitness_Runs_UpdateRun_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the UpdateRun Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Fitness_Runs_UpdateRun_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this UpdateRun input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Actions_Fitness_Runs_UpdateRun_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Actions_Fitness_Runs_UpdateRun_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this UpdateRun Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Actions_Fitness_Runs_UpdateRun_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ActionID input for this UpdateRun Choreo.
     *
     * @param string $value (required, string) The id of the action to update.
     * @return Facebook_Actions_Fitness_Runs_UpdateRun_Inputs For method chaining.
     */
    public function setActionID($value)
    {
        return $this->set('ActionID', $value);
    }

    /**
     * Set the value for the Course input for this UpdateRun Choreo.
     *
     * @param string $value (optional, string) The URL or ID for an Open Graph object representing the course.
     * @return Facebook_Actions_Fitness_Runs_UpdateRun_Inputs For method chaining.
     */
    public function setCourse($value)
    {
        return $this->set('Course', $value);
    }

    /**
     * Set the value for the EndTime input for this UpdateRun Choreo.
     *
     * @param string $value (optional, date) The time that the user ended the action (e.g. 2013-06-24T18:53:35+0000).
     * @return Facebook_Actions_Fitness_Runs_UpdateRun_Inputs For method chaining.
     */
    public function setEndTime($value)
    {
        return $this->set('EndTime', $value);
    }

    /**
     * Set the value for the ExpiresIn input for this UpdateRun Choreo.
     *
     * @param int $value (optional, integer) The amount of time (in milliseconds) from the publish_time that the action will expire.
     * @return Facebook_Actions_Fitness_Runs_UpdateRun_Inputs For method chaining.
     */
    public function setExpiresIn($value)
    {
        return $this->set('ExpiresIn', $value);
    }

    /**
     * Set the value for the Message input for this UpdateRun Choreo.
     *
     * @param string $value (optional, string) A message attached to this action. Setting this parameter requires enabling of message capabilities.
     * @return Facebook_Actions_Fitness_Runs_UpdateRun_Inputs For method chaining.
     */
    public function setMessage($value)
    {
        return $this->set('Message', $value);
    }

    /**
     * Set the value for the Place input for this UpdateRun Choreo.
     *
     * @param string $value (optional, string) The URL or ID for an Open Graph object representing the location associated with this action.
     * @return Facebook_Actions_Fitness_Runs_UpdateRun_Inputs For method chaining.
     */
    public function setPlace($value)
    {
        return $this->set('Place', $value);
    }

    /**
     * Set the value for the Tags input for this UpdateRun Choreo.
     *
     * @param string $value (optional, string) A comma separated list of other profile IDs that also performed this action.
     * @return Facebook_Actions_Fitness_Runs_UpdateRun_Inputs For method chaining.
     */
    public function setTags($value)
    {
        return $this->set('Tags', $value);
    }
}


/**
 * Execution object for the UpdateRun Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Fitness_Runs_UpdateRun_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the UpdateRun Choreo.
     *
     * @param Temboo_Session $session The session that owns this UpdateRun execution.
     * @param Facebook_Actions_Fitness_Runs_UpdateRun $choreo The choreography object for this execution.
     * @param Facebook_Actions_Fitness_Runs_UpdateRun_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Fitness_Runs_UpdateRun_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Fitness_Runs_UpdateRun_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Actions_Fitness_Runs_UpdateRun $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this UpdateRun execution.
     *
     * @return Facebook_Actions_Fitness_Runs_UpdateRun_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this UpdateRun execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Actions_Fitness_Runs_UpdateRun_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Actions_Fitness_Runs_UpdateRun_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the UpdateRun Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Fitness_Runs_UpdateRun_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the UpdateRun Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Actions_Fitness_Runs_UpdateRun_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this UpdateRun execution.
     *
     * @return bool (boolean) The response from Facebook.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Creates an action that represents a user walking a course.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Fitness_Walks_CreateWalk extends Temboo_Choreography
{
    /**
     * Creates an action that represents a user walking a course.
     *
     * @param Temboo_Session $session The session that owns this CreateWalk Choreo.
     * @return Facebook_Actions_Fitness_Walks_CreateWalk New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Actions/Fitness/Walks/CreateWalk/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this CreateWalk Choreo.
     *
     * @param Facebook_Actions_Fitness_Walks_CreateWalk_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Fitness_Walks_CreateWalk_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Fitness_Walks_CreateWalk_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Actions_Fitness_Walks_CreateWalk_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this CreateWalk Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Fitness_Walks_CreateWalk_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Actions_Fitness_Walks_CreateWalk_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the CreateWalk Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Fitness_Walks_CreateWalk_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the CreateWalk Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Fitness_Walks_CreateWalk_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this CreateWalk input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Actions_Fitness_Walks_CreateWalk_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Actions_Fitness_Walks_CreateWalk_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this CreateWalk Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Actions_Fitness_Walks_CreateWalk_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the Course input for this CreateWalk Choreo.
     *
     * @param string $value (required, string) The URL or ID for an Open Graph object representing the course.
     * @return Facebook_Actions_Fitness_Walks_CreateWalk_Inputs For method chaining.
     */
    public function setCourse($value)
    {
        return $this->set('Course', $value);
    }

    /**
     * Set the value for the CreatedTime input for this CreateWalk Choreo.
     *
     * @param string $value (optional, date) The time that the action was created (e.g. 2013-06-24T18:53:35+0000).
     * @return Facebook_Actions_Fitness_Walks_CreateWalk_Inputs For method chaining.
     */
    public function setCreatedTime($value)
    {
        return $this->set('CreatedTime', $value);
    }

    /**
     * Set the value for the EndTime input for this CreateWalk Choreo.
     *
     * @param string $value (optional, date) The time that the user ended the action (e.g. 2013-06-24T18:53:35+0000).
     * @return Facebook_Actions_Fitness_Walks_CreateWalk_Inputs For method chaining.
     */
    public function setEndTime($value)
    {
        return $this->set('EndTime', $value);
    }

    /**
     * Set the value for the ExpiresIn input for this CreateWalk Choreo.
     *
     * @param int $value (optional, integer) The amount of time (in milliseconds) from the publish_time that the action will expire.
     * @return Facebook_Actions_Fitness_Walks_CreateWalk_Inputs For method chaining.
     */
    public function setExpiresIn($value)
    {
        return $this->set('ExpiresIn', $value);
    }

    /**
     * Set the value for the ExplicitlyShared input for this CreateWalk Choreo.
     *
     * @param bool $value (optional, boolean) Indicates that the user is explicitly sharing this action. Requires the explicitly_shared capability to be enabled.
     * @return Facebook_Actions_Fitness_Walks_CreateWalk_Inputs For method chaining.
     */
    public function setExplicitlyShared($value)
    {
        return $this->set('ExplicitlyShared', $value);
    }

    /**
     * Set the value for the ExplicityShared input for this CreateWalk Choreo.
     *
     * @param bool $value (optional, boolean) Deprecated (retained for backward compatibility only).
     * @return Facebook_Actions_Fitness_Walks_CreateWalk_Inputs For method chaining.
     */
    public function setExplicityShared($value)
    {
        return $this->set('ExplicityShared', $value);
    }

    /**
     * Set the value for the Message input for this CreateWalk Choreo.
     *
     * @param string $value (optional, string) A message attached to this action. Setting this parameter requires enabling of message capabilities.
     * @return Facebook_Actions_Fitness_Walks_CreateWalk_Inputs For method chaining.
     */
    public function setMessage($value)
    {
        return $this->set('Message', $value);
    }

    /**
     * Set the value for the NoFeedStory input for this CreateWalk Choreo.
     *
     * @param bool $value (optional, boolean) Whether or not this action should be posted to the users feed.
     * @return Facebook_Actions_Fitness_Walks_CreateWalk_Inputs For method chaining.
     */
    public function setNoFeedStory($value)
    {
        return $this->set('NoFeedStory', $value);
    }

    /**
     * Set the value for the Place input for this CreateWalk Choreo.
     *
     * @param string $value (optional, string) The URL or ID for an Open Graph object representing the location associated with this action.
     * @return Facebook_Actions_Fitness_Walks_CreateWalk_Inputs For method chaining.
     */
    public function setPlace($value)
    {
        return $this->set('Place', $value);
    }

    /**
     * Set the value for the ProfileID input for this CreateWalk Choreo.
     *
     * @param string $value (optional, string) The id of the user's profile. Defaults to "me" indicating the authenticated user.
     * @return Facebook_Actions_Fitness_Walks_CreateWalk_Inputs For method chaining.
     */
    public function setProfileID($value)
    {
        return $this->set('ProfileID', $value);
    }

    /**
     * Set the value for the Reference input for this CreateWalk Choreo.
     *
     * @param string $value (optional, string) A string identifier up to 50 characters used for tracking and insights.
     * @return Facebook_Actions_Fitness_Walks_CreateWalk_Inputs For method chaining.
     */
    public function setReference($value)
    {
        return $this->set('Reference', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this CreateWalk Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Can be set to xml or json. Defaults to json.
     * @return Facebook_Actions_Fitness_Walks_CreateWalk_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }

    /**
     * Set the value for the StartTime input for this CreateWalk Choreo.
     *
     * @param string $value (optional, date) The time that the user started the action (e.g. 2013-06-24T18:53:35+0000).
     * @return Facebook_Actions_Fitness_Walks_CreateWalk_Inputs For method chaining.
     */
    public function setStartTime($value)
    {
        return $this->set('StartTime', $value);
    }

    /**
     * Set the value for the Tags input for this CreateWalk Choreo.
     *
     * @param string $value (optional, string) A comma separated list of other profile IDs that also performed this action.
     * @return Facebook_Actions_Fitness_Walks_CreateWalk_Inputs For method chaining.
     */
    public function setTags($value)
    {
        return $this->set('Tags', $value);
    }
}


/**
 * Execution object for the CreateWalk Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Fitness_Walks_CreateWalk_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the CreateWalk Choreo.
     *
     * @param Temboo_Session $session The session that owns this CreateWalk execution.
     * @param Facebook_Actions_Fitness_Walks_CreateWalk $choreo The choreography object for this execution.
     * @param Facebook_Actions_Fitness_Walks_CreateWalk_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Fitness_Walks_CreateWalk_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Fitness_Walks_CreateWalk_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Actions_Fitness_Walks_CreateWalk $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this CreateWalk execution.
     *
     * @return Facebook_Actions_Fitness_Walks_CreateWalk_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this CreateWalk execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Actions_Fitness_Walks_CreateWalk_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Actions_Fitness_Walks_CreateWalk_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the CreateWalk Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Fitness_Walks_CreateWalk_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the CreateWalk Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Actions_Fitness_Walks_CreateWalk_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "ActivityURL" output from this CreateWalk execution.
     *
     * @return string (string) The URL for the newly created action.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getActivityURL()
    {
        return $this->get('ActivityURL');
    }
    /**
     * Retrieve the value for the "Response" output from this CreateWalk execution.
     *
     * @return string The response from Facebook. Corresponds to the ResponseFormat input. Defaults to JSON.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Deletes a given walk action.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Fitness_Walks_DeleteWalk extends Temboo_Choreography
{
    /**
     * Deletes a given walk action.
     *
     * @param Temboo_Session $session The session that owns this DeleteWalk Choreo.
     * @return Facebook_Actions_Fitness_Walks_DeleteWalk New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Actions/Fitness/Walks/DeleteWalk/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this DeleteWalk Choreo.
     *
     * @param Facebook_Actions_Fitness_Walks_DeleteWalk_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Fitness_Walks_DeleteWalk_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Fitness_Walks_DeleteWalk_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Actions_Fitness_Walks_DeleteWalk_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this DeleteWalk Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Fitness_Walks_DeleteWalk_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Actions_Fitness_Walks_DeleteWalk_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the DeleteWalk Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Fitness_Walks_DeleteWalk_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the DeleteWalk Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Fitness_Walks_DeleteWalk_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this DeleteWalk input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Actions_Fitness_Walks_DeleteWalk_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Actions_Fitness_Walks_DeleteWalk_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this DeleteWalk Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Actions_Fitness_Walks_DeleteWalk_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ActionID input for this DeleteWalk Choreo.
     *
     * @param string $value (required, string) The id of an action to delete.
     * @return Facebook_Actions_Fitness_Walks_DeleteWalk_Inputs For method chaining.
     */
    public function setActionID($value)
    {
        return $this->set('ActionID', $value);
    }
}


/**
 * Execution object for the DeleteWalk Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Fitness_Walks_DeleteWalk_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the DeleteWalk Choreo.
     *
     * @param Temboo_Session $session The session that owns this DeleteWalk execution.
     * @param Facebook_Actions_Fitness_Walks_DeleteWalk $choreo The choreography object for this execution.
     * @param Facebook_Actions_Fitness_Walks_DeleteWalk_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Fitness_Walks_DeleteWalk_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Fitness_Walks_DeleteWalk_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Actions_Fitness_Walks_DeleteWalk $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this DeleteWalk execution.
     *
     * @return Facebook_Actions_Fitness_Walks_DeleteWalk_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this DeleteWalk execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Actions_Fitness_Walks_DeleteWalk_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Actions_Fitness_Walks_DeleteWalk_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the DeleteWalk Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Fitness_Walks_DeleteWalk_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the DeleteWalk Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Actions_Fitness_Walks_DeleteWalk_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this DeleteWalk execution.
     *
     * @return bool (boolean) The response from Facebook. Returns "true" on success.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Retrieves one or more walk actions.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Fitness_Walks_ReadWalks extends Temboo_Choreography
{
    /**
     * Retrieves one or more walk actions.
     *
     * @param Temboo_Session $session The session that owns this ReadWalks Choreo.
     * @return Facebook_Actions_Fitness_Walks_ReadWalks New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Actions/Fitness/Walks/ReadWalks/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this ReadWalks Choreo.
     *
     * @param Facebook_Actions_Fitness_Walks_ReadWalks_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Fitness_Walks_ReadWalks_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Fitness_Walks_ReadWalks_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Actions_Fitness_Walks_ReadWalks_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this ReadWalks Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Fitness_Walks_ReadWalks_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Actions_Fitness_Walks_ReadWalks_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the ReadWalks Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Fitness_Walks_ReadWalks_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the ReadWalks Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Fitness_Walks_ReadWalks_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this ReadWalks input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Actions_Fitness_Walks_ReadWalks_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Actions_Fitness_Walks_ReadWalks_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this ReadWalks Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Actions_Fitness_Walks_ReadWalks_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ActionID input for this ReadWalks Choreo.
     *
     * @param string $value (optional, string) The id of an action to retrieve. If an id is not provided, a list of all walk actions will be returned.
     * @return Facebook_Actions_Fitness_Walks_ReadWalks_Inputs For method chaining.
     */
    public function setActionID($value)
    {
        return $this->set('ActionID', $value);
    }

    /**
     * Set the value for the Fields input for this ReadWalks Choreo.
     *
     * @param string $value (optional, string) A comma separated list of fields to return (i.e. id,name).
     * @return Facebook_Actions_Fitness_Walks_ReadWalks_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Limit input for this ReadWalks Choreo.
     *
     * @param int $value (optional, integer) Used to page through results. Limits the number of records returned in the response.
     * @return Facebook_Actions_Fitness_Walks_ReadWalks_Inputs For method chaining.
     */
    public function setLimit($value)
    {
        return $this->set('Limit', $value);
    }

    /**
     * Set the value for the Offset input for this ReadWalks Choreo.
     *
     * @param int $value (optional, integer) Used to page through results. Returns results starting from the specified number.
     * @return Facebook_Actions_Fitness_Walks_ReadWalks_Inputs For method chaining.
     */
    public function setOffset($value)
    {
        return $this->set('Offset', $value);
    }

    /**
     * Set the value for the ProfileID input for this ReadWalks Choreo.
     *
     * @param string $value (optional, string) The id of the user's profile. Defaults to "me" indicating the authenticated user.
     * @return Facebook_Actions_Fitness_Walks_ReadWalks_Inputs For method chaining.
     */
    public function setProfileID($value)
    {
        return $this->set('ProfileID', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this ReadWalks Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Can be set to xml or json. Defaults to json.
     * @return Facebook_Actions_Fitness_Walks_ReadWalks_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }
}


/**
 * Execution object for the ReadWalks Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Fitness_Walks_ReadWalks_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the ReadWalks Choreo.
     *
     * @param Temboo_Session $session The session that owns this ReadWalks execution.
     * @param Facebook_Actions_Fitness_Walks_ReadWalks $choreo The choreography object for this execution.
     * @param Facebook_Actions_Fitness_Walks_ReadWalks_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Fitness_Walks_ReadWalks_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Fitness_Walks_ReadWalks_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Actions_Fitness_Walks_ReadWalks $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this ReadWalks execution.
     *
     * @return Facebook_Actions_Fitness_Walks_ReadWalks_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this ReadWalks execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Actions_Fitness_Walks_ReadWalks_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Actions_Fitness_Walks_ReadWalks_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the ReadWalks Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Fitness_Walks_ReadWalks_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the ReadWalks Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Actions_Fitness_Walks_ReadWalks_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "HasNext" output from this ReadWalks execution.
     *
     * @return bool (boolean) A boolean flag indicating that a next page exists.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getHasNext()
    {
        return $this->get('HasNext');
    }
    /**
     * Retrieve the value for the "HasPrevious" output from this ReadWalks execution.
     *
     * @return bool (boolean) A boolean flag indicating that a previous page exists.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getHasPrevious()
    {
        return $this->get('HasPrevious');
    }
    /**
     * Retrieve the value for the "Response" output from this ReadWalks execution.
     *
     * @return string The response from Facebook. Corresponds to the ResponseFormat input. Defaults to JSON.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Updates an existing walk action.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Fitness_Walks_UpdateWalk extends Temboo_Choreography
{
    /**
     * Updates an existing walk action.
     *
     * @param Temboo_Session $session The session that owns this UpdateWalk Choreo.
     * @return Facebook_Actions_Fitness_Walks_UpdateWalk New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Actions/Fitness/Walks/UpdateWalk/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this UpdateWalk Choreo.
     *
     * @param Facebook_Actions_Fitness_Walks_UpdateWalk_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Fitness_Walks_UpdateWalk_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Fitness_Walks_UpdateWalk_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Actions_Fitness_Walks_UpdateWalk_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this UpdateWalk Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Fitness_Walks_UpdateWalk_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Actions_Fitness_Walks_UpdateWalk_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the UpdateWalk Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Fitness_Walks_UpdateWalk_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the UpdateWalk Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Fitness_Walks_UpdateWalk_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this UpdateWalk input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Actions_Fitness_Walks_UpdateWalk_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Actions_Fitness_Walks_UpdateWalk_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this UpdateWalk Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Actions_Fitness_Walks_UpdateWalk_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ActionID input for this UpdateWalk Choreo.
     *
     * @param string $value (required, string) The id of the action to update.
     * @return Facebook_Actions_Fitness_Walks_UpdateWalk_Inputs For method chaining.
     */
    public function setActionID($value)
    {
        return $this->set('ActionID', $value);
    }

    /**
     * Set the value for the Course input for this UpdateWalk Choreo.
     *
     * @param string $value (optional, string) The URL or ID for an Open Graph object representing the course.
     * @return Facebook_Actions_Fitness_Walks_UpdateWalk_Inputs For method chaining.
     */
    public function setCourse($value)
    {
        return $this->set('Course', $value);
    }

    /**
     * Set the value for the EndTime input for this UpdateWalk Choreo.
     *
     * @param string $value (optional, date) The time that the user ended the action (e.g. 2013-06-24T18:53:35+0000).
     * @return Facebook_Actions_Fitness_Walks_UpdateWalk_Inputs For method chaining.
     */
    public function setEndTime($value)
    {
        return $this->set('EndTime', $value);
    }

    /**
     * Set the value for the ExpiresIn input for this UpdateWalk Choreo.
     *
     * @param int $value (optional, integer) The amount of time (in milliseconds) from the publish_time that the action will expire.
     * @return Facebook_Actions_Fitness_Walks_UpdateWalk_Inputs For method chaining.
     */
    public function setExpiresIn($value)
    {
        return $this->set('ExpiresIn', $value);
    }

    /**
     * Set the value for the Message input for this UpdateWalk Choreo.
     *
     * @param string $value (optional, string) A message attached to this action. Setting this parameter requires enabling of message capabilities.
     * @return Facebook_Actions_Fitness_Walks_UpdateWalk_Inputs For method chaining.
     */
    public function setMessage($value)
    {
        return $this->set('Message', $value);
    }

    /**
     * Set the value for the Place input for this UpdateWalk Choreo.
     *
     * @param string $value (optional, string) The URL or ID for an Open Graph object representing the location associated with this action.
     * @return Facebook_Actions_Fitness_Walks_UpdateWalk_Inputs For method chaining.
     */
    public function setPlace($value)
    {
        return $this->set('Place', $value);
    }

    /**
     * Set the value for the Tags input for this UpdateWalk Choreo.
     *
     * @param string $value (optional, string) A comma separated list of other profile IDs that also performed this action.
     * @return Facebook_Actions_Fitness_Walks_UpdateWalk_Inputs For method chaining.
     */
    public function setTags($value)
    {
        return $this->set('Tags', $value);
    }
}


/**
 * Execution object for the UpdateWalk Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Fitness_Walks_UpdateWalk_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the UpdateWalk Choreo.
     *
     * @param Temboo_Session $session The session that owns this UpdateWalk execution.
     * @param Facebook_Actions_Fitness_Walks_UpdateWalk $choreo The choreography object for this execution.
     * @param Facebook_Actions_Fitness_Walks_UpdateWalk_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Fitness_Walks_UpdateWalk_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Fitness_Walks_UpdateWalk_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Actions_Fitness_Walks_UpdateWalk $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this UpdateWalk execution.
     *
     * @return Facebook_Actions_Fitness_Walks_UpdateWalk_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this UpdateWalk execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Actions_Fitness_Walks_UpdateWalk_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Actions_Fitness_Walks_UpdateWalk_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the UpdateWalk Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Fitness_Walks_UpdateWalk_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the UpdateWalk Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Actions_Fitness_Walks_UpdateWalk_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this UpdateWalk execution.
     *
     * @return bool (boolean) The response from Facebook.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Creates an action that represents someone following a Facebook user.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_General_Follows_CreateFollow extends Temboo_Choreography
{
    /**
     * Creates an action that represents someone following a Facebook user.
     *
     * @param Temboo_Session $session The session that owns this CreateFollow Choreo.
     * @return Facebook_Actions_General_Follows_CreateFollow New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Actions/General/Follows/CreateFollow/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this CreateFollow Choreo.
     *
     * @param Facebook_Actions_General_Follows_CreateFollow_Inputs|array $inputs (optional) Inputs as Facebook_Actions_General_Follows_CreateFollow_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_General_Follows_CreateFollow_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Actions_General_Follows_CreateFollow_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this CreateFollow Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_General_Follows_CreateFollow_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Actions_General_Follows_CreateFollow_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the CreateFollow Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_General_Follows_CreateFollow_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the CreateFollow Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_General_Follows_CreateFollow_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this CreateFollow input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Actions_General_Follows_CreateFollow_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Actions_General_Follows_CreateFollow_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this CreateFollow Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Actions_General_Follows_CreateFollow_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the CreatedTime input for this CreateFollow Choreo.
     *
     * @param string $value (optional, date) The time that the action was created (e.g. 2013-06-24T18:53:35+0000).
     * @return Facebook_Actions_General_Follows_CreateFollow_Inputs For method chaining.
     */
    public function setCreatedTime($value)
    {
        return $this->set('CreatedTime', $value);
    }

    /**
     * Set the value for the EndTime input for this CreateFollow Choreo.
     *
     * @param string $value (optional, date) The time that the user ended the action (e.g. 2013-06-24T18:53:35+0000).
     * @return Facebook_Actions_General_Follows_CreateFollow_Inputs For method chaining.
     */
    public function setEndTime($value)
    {
        return $this->set('EndTime', $value);
    }

    /**
     * Set the value for the ExpiresIn input for this CreateFollow Choreo.
     *
     * @param int $value (optional, integer) The amount of time (in milliseconds) from the publish_time that the action will expire.
     * @return Facebook_Actions_General_Follows_CreateFollow_Inputs For method chaining.
     */
    public function setExpiresIn($value)
    {
        return $this->set('ExpiresIn', $value);
    }

    /**
     * Set the value for the ExplicitlyShared input for this CreateFollow Choreo.
     *
     * @param bool $value (optional, boolean) Indicates that the user is explicitly sharing this action. Requires the explicitly_shared capability to be enabled.
     * @return Facebook_Actions_General_Follows_CreateFollow_Inputs For method chaining.
     */
    public function setExplicitlyShared($value)
    {
        return $this->set('ExplicitlyShared', $value);
    }

    /**
     * Set the value for the ExplicityShared input for this CreateFollow Choreo.
     *
     * @param bool $value (optional, boolean) Deprecated (retained for backward compatibility only).
     * @return Facebook_Actions_General_Follows_CreateFollow_Inputs For method chaining.
     */
    public function setExplicityShared($value)
    {
        return $this->set('ExplicityShared', $value);
    }

    /**
     * Set the value for the Message input for this CreateFollow Choreo.
     *
     * @param string $value (optional, string) A message attached to this action. Setting this parameter requires enabling of message capabilities.
     * @return Facebook_Actions_General_Follows_CreateFollow_Inputs For method chaining.
     */
    public function setMessage($value)
    {
        return $this->set('Message', $value);
    }

    /**
     * Set the value for the NoFeedStory input for this CreateFollow Choreo.
     *
     * @param bool $value (optional, boolean) Whether or not this action should be posted to the users feed.
     * @return Facebook_Actions_General_Follows_CreateFollow_Inputs For method chaining.
     */
    public function setNoFeedStory($value)
    {
        return $this->set('NoFeedStory', $value);
    }

    /**
     * Set the value for the Place input for this CreateFollow Choreo.
     *
     * @param string $value (optional, string) The Facebook Page ID of the location associated with this action.
     * @return Facebook_Actions_General_Follows_CreateFollow_Inputs For method chaining.
     */
    public function setPlace($value)
    {
        return $this->set('Place', $value);
    }

    /**
     * Set the value for the Profile input for this CreateFollow Choreo.
     *
     * @param string $value (required, string) The URL or ID for an Open Graph object representing the profile to follow.
     * @return Facebook_Actions_General_Follows_CreateFollow_Inputs For method chaining.
     */
    public function setProfile($value)
    {
        return $this->set('Profile', $value);
    }

    /**
     * Set the value for the ProfileID input for this CreateFollow Choreo.
     *
     * @param string $value (optional, string) The id of the user's profile. Defaults to "me" indicating the authenticated user.
     * @return Facebook_Actions_General_Follows_CreateFollow_Inputs For method chaining.
     */
    public function setProfileID($value)
    {
        return $this->set('ProfileID', $value);
    }

    /**
     * Set the value for the Reference input for this CreateFollow Choreo.
     *
     * @param string $value (optional, string) A string identifier up to 50 characters used for tracking and insights.
     * @return Facebook_Actions_General_Follows_CreateFollow_Inputs For method chaining.
     */
    public function setReference($value)
    {
        return $this->set('Reference', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this CreateFollow Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Can be set to xml or json. Defaults to json.
     * @return Facebook_Actions_General_Follows_CreateFollow_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }

    /**
     * Set the value for the StartTime input for this CreateFollow Choreo.
     *
     * @param string $value (optional, date) The time that the user started the action (e.g. 2013-06-24T18:53:35+0000).
     * @return Facebook_Actions_General_Follows_CreateFollow_Inputs For method chaining.
     */
    public function setStartTime($value)
    {
        return $this->set('StartTime', $value);
    }

    /**
     * Set the value for the Tags input for this CreateFollow Choreo.
     *
     * @param string $value (optional, string) A comma separated list of other profile IDs that also performed this action.
     * @return Facebook_Actions_General_Follows_CreateFollow_Inputs For method chaining.
     */
    public function setTags($value)
    {
        return $this->set('Tags', $value);
    }
}


/**
 * Execution object for the CreateFollow Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_General_Follows_CreateFollow_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the CreateFollow Choreo.
     *
     * @param Temboo_Session $session The session that owns this CreateFollow execution.
     * @param Facebook_Actions_General_Follows_CreateFollow $choreo The choreography object for this execution.
     * @param Facebook_Actions_General_Follows_CreateFollow_Inputs|array $inputs (optional) Inputs as Facebook_Actions_General_Follows_CreateFollow_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_General_Follows_CreateFollow_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Actions_General_Follows_CreateFollow $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this CreateFollow execution.
     *
     * @return Facebook_Actions_General_Follows_CreateFollow_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this CreateFollow execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Actions_General_Follows_CreateFollow_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Actions_General_Follows_CreateFollow_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the CreateFollow Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_General_Follows_CreateFollow_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the CreateFollow Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Actions_General_Follows_CreateFollow_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "ActivityURL" output from this CreateFollow execution.
     *
     * @return string (string) The URL for the newly created action.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getActivityURL()
    {
        return $this->get('ActivityURL');
    }
    /**
     * Retrieve the value for the "Response" output from this CreateFollow execution.
     *
     * @return string The response from Facebook. Corresponds to the ResponseFormat input. Defaults to JSON.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Deletes a given follow action.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_General_Follows_DeleteFollow extends Temboo_Choreography
{
    /**
     * Deletes a given follow action.
     *
     * @param Temboo_Session $session The session that owns this DeleteFollow Choreo.
     * @return Facebook_Actions_General_Follows_DeleteFollow New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Actions/General/Follows/DeleteFollow/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this DeleteFollow Choreo.
     *
     * @param Facebook_Actions_General_Follows_DeleteFollow_Inputs|array $inputs (optional) Inputs as Facebook_Actions_General_Follows_DeleteFollow_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_General_Follows_DeleteFollow_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Actions_General_Follows_DeleteFollow_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this DeleteFollow Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_General_Follows_DeleteFollow_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Actions_General_Follows_DeleteFollow_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the DeleteFollow Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_General_Follows_DeleteFollow_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the DeleteFollow Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_General_Follows_DeleteFollow_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this DeleteFollow input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Actions_General_Follows_DeleteFollow_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Actions_General_Follows_DeleteFollow_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this DeleteFollow Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Actions_General_Follows_DeleteFollow_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ActionID input for this DeleteFollow Choreo.
     *
     * @param string $value (required, string) The id of an action to delete.
     * @return Facebook_Actions_General_Follows_DeleteFollow_Inputs For method chaining.
     */
    public function setActionID($value)
    {
        return $this->set('ActionID', $value);
    }
}


/**
 * Execution object for the DeleteFollow Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_General_Follows_DeleteFollow_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the DeleteFollow Choreo.
     *
     * @param Temboo_Session $session The session that owns this DeleteFollow execution.
     * @param Facebook_Actions_General_Follows_DeleteFollow $choreo The choreography object for this execution.
     * @param Facebook_Actions_General_Follows_DeleteFollow_Inputs|array $inputs (optional) Inputs as Facebook_Actions_General_Follows_DeleteFollow_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_General_Follows_DeleteFollow_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Actions_General_Follows_DeleteFollow $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this DeleteFollow execution.
     *
     * @return Facebook_Actions_General_Follows_DeleteFollow_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this DeleteFollow execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Actions_General_Follows_DeleteFollow_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Actions_General_Follows_DeleteFollow_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the DeleteFollow Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_General_Follows_DeleteFollow_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the DeleteFollow Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Actions_General_Follows_DeleteFollow_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this DeleteFollow execution.
     *
     * @return bool (boolean) The response from Facebook. Returns "true" on success.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Retrieves one or more follow actions.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_General_Follows_ReadFollows extends Temboo_Choreography
{
    /**
     * Retrieves one or more follow actions.
     *
     * @param Temboo_Session $session The session that owns this ReadFollows Choreo.
     * @return Facebook_Actions_General_Follows_ReadFollows New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Actions/General/Follows/ReadFollows/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this ReadFollows Choreo.
     *
     * @param Facebook_Actions_General_Follows_ReadFollows_Inputs|array $inputs (optional) Inputs as Facebook_Actions_General_Follows_ReadFollows_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_General_Follows_ReadFollows_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Actions_General_Follows_ReadFollows_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this ReadFollows Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_General_Follows_ReadFollows_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Actions_General_Follows_ReadFollows_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the ReadFollows Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_General_Follows_ReadFollows_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the ReadFollows Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_General_Follows_ReadFollows_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this ReadFollows input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Actions_General_Follows_ReadFollows_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Actions_General_Follows_ReadFollows_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this ReadFollows Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Actions_General_Follows_ReadFollows_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ActionID input for this ReadFollows Choreo.
     *
     * @param string $value (optional, string) The id of an action to retrieve. If an id is not provided, a list of all follow actions will be returned.
     * @return Facebook_Actions_General_Follows_ReadFollows_Inputs For method chaining.
     */
    public function setActionID($value)
    {
        return $this->set('ActionID', $value);
    }

    /**
     * Set the value for the Fields input for this ReadFollows Choreo.
     *
     * @param string $value (optional, string) A comma separated list of fields to return (i.e. id,name).
     * @return Facebook_Actions_General_Follows_ReadFollows_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Limit input for this ReadFollows Choreo.
     *
     * @param int $value (optional, integer) Used to page through results. Limits the number of records returned in the response.
     * @return Facebook_Actions_General_Follows_ReadFollows_Inputs For method chaining.
     */
    public function setLimit($value)
    {
        return $this->set('Limit', $value);
    }

    /**
     * Set the value for the Offset input for this ReadFollows Choreo.
     *
     * @param int $value (optional, integer) Used to page through results. Returns results starting from the specified number.
     * @return Facebook_Actions_General_Follows_ReadFollows_Inputs For method chaining.
     */
    public function setOffset($value)
    {
        return $this->set('Offset', $value);
    }

    /**
     * Set the value for the ProfileID input for this ReadFollows Choreo.
     *
     * @param string $value (optional, string) The id of the user's profile. Defaults to "me" indicating the authenticated user.
     * @return Facebook_Actions_General_Follows_ReadFollows_Inputs For method chaining.
     */
    public function setProfileID($value)
    {
        return $this->set('ProfileID', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this ReadFollows Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Can be set to xml or json. Defaults to json.
     * @return Facebook_Actions_General_Follows_ReadFollows_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }
}


/**
 * Execution object for the ReadFollows Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_General_Follows_ReadFollows_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the ReadFollows Choreo.
     *
     * @param Temboo_Session $session The session that owns this ReadFollows execution.
     * @param Facebook_Actions_General_Follows_ReadFollows $choreo The choreography object for this execution.
     * @param Facebook_Actions_General_Follows_ReadFollows_Inputs|array $inputs (optional) Inputs as Facebook_Actions_General_Follows_ReadFollows_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_General_Follows_ReadFollows_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Actions_General_Follows_ReadFollows $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this ReadFollows execution.
     *
     * @return Facebook_Actions_General_Follows_ReadFollows_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this ReadFollows execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Actions_General_Follows_ReadFollows_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Actions_General_Follows_ReadFollows_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the ReadFollows Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_General_Follows_ReadFollows_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the ReadFollows Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Actions_General_Follows_ReadFollows_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "HasNext" output from this ReadFollows execution.
     *
     * @return bool (boolean) A boolean flag indicating that a next page exists.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getHasNext()
    {
        return $this->get('HasNext');
    }
    /**
     * Retrieve the value for the "HasPrevious" output from this ReadFollows execution.
     *
     * @return bool (boolean) A boolean flag indicating that a previous page exists.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getHasPrevious()
    {
        return $this->get('HasPrevious');
    }
    /**
     * Retrieve the value for the "Response" output from this ReadFollows execution.
     *
     * @return string The response from Facebook. Corresponds to the ResponseFormat input. Defaults to JSON.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Update an existing follow action.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_General_Follows_UpdateFollow extends Temboo_Choreography
{
    /**
     * Update an existing follow action.
     *
     * @param Temboo_Session $session The session that owns this UpdateFollow Choreo.
     * @return Facebook_Actions_General_Follows_UpdateFollow New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Actions/General/Follows/UpdateFollow/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this UpdateFollow Choreo.
     *
     * @param Facebook_Actions_General_Follows_UpdateFollow_Inputs|array $inputs (optional) Inputs as Facebook_Actions_General_Follows_UpdateFollow_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_General_Follows_UpdateFollow_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Actions_General_Follows_UpdateFollow_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this UpdateFollow Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_General_Follows_UpdateFollow_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Actions_General_Follows_UpdateFollow_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the UpdateFollow Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_General_Follows_UpdateFollow_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the UpdateFollow Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_General_Follows_UpdateFollow_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this UpdateFollow input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Actions_General_Follows_UpdateFollow_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Actions_General_Follows_UpdateFollow_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this UpdateFollow Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Actions_General_Follows_UpdateFollow_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ActionID input for this UpdateFollow Choreo.
     *
     * @param string $value (required, string) The id of the action to update.
     * @return Facebook_Actions_General_Follows_UpdateFollow_Inputs For method chaining.
     */
    public function setActionID($value)
    {
        return $this->set('ActionID', $value);
    }

    /**
     * Set the value for the EndTime input for this UpdateFollow Choreo.
     *
     * @param string $value (optional, date) The time that the user ended the action (e.g. 2013-06-24T18:53:35+0000).
     * @return Facebook_Actions_General_Follows_UpdateFollow_Inputs For method chaining.
     */
    public function setEndTime($value)
    {
        return $this->set('EndTime', $value);
    }

    /**
     * Set the value for the ExpiresIn input for this UpdateFollow Choreo.
     *
     * @param int $value (optional, integer) The amount of time (in milliseconds) from the publish_time that the action will expire.
     * @return Facebook_Actions_General_Follows_UpdateFollow_Inputs For method chaining.
     */
    public function setExpiresIn($value)
    {
        return $this->set('ExpiresIn', $value);
    }

    /**
     * Set the value for the Message input for this UpdateFollow Choreo.
     *
     * @param string $value (optional, string) A message attached to this fitness action. Setting this parameter requires enabling of message capabilities.
     * @return Facebook_Actions_General_Follows_UpdateFollow_Inputs For method chaining.
     */
    public function setMessage($value)
    {
        return $this->set('Message', $value);
    }

    /**
     * Set the value for the Place input for this UpdateFollow Choreo.
     *
     * @param string $value (optional, string) The URL or ID for an Open Graph object representing the location associated with this action.
     * @return Facebook_Actions_General_Follows_UpdateFollow_Inputs For method chaining.
     */
    public function setPlace($value)
    {
        return $this->set('Place', $value);
    }

    /**
     * Set the value for the Profile input for this UpdateFollow Choreo.
     *
     * @param string $value (optional, string) An action representing someone following a Facebook user
     * @return Facebook_Actions_General_Follows_UpdateFollow_Inputs For method chaining.
     */
    public function setProfile($value)
    {
        return $this->set('Profile', $value);
    }

    /**
     * Set the value for the Tags input for this UpdateFollow Choreo.
     *
     * @param string $value (optional, string) A comma separated list of other profile IDs that also performed this action.
     * @return Facebook_Actions_General_Follows_UpdateFollow_Inputs For method chaining.
     */
    public function setTags($value)
    {
        return $this->set('Tags', $value);
    }
}


/**
 * Execution object for the UpdateFollow Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_General_Follows_UpdateFollow_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the UpdateFollow Choreo.
     *
     * @param Temboo_Session $session The session that owns this UpdateFollow execution.
     * @param Facebook_Actions_General_Follows_UpdateFollow $choreo The choreography object for this execution.
     * @param Facebook_Actions_General_Follows_UpdateFollow_Inputs|array $inputs (optional) Inputs as Facebook_Actions_General_Follows_UpdateFollow_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_General_Follows_UpdateFollow_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Actions_General_Follows_UpdateFollow $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this UpdateFollow execution.
     *
     * @return Facebook_Actions_General_Follows_UpdateFollow_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this UpdateFollow execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Actions_General_Follows_UpdateFollow_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Actions_General_Follows_UpdateFollow_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the UpdateFollow Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_General_Follows_UpdateFollow_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the UpdateFollow Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Actions_General_Follows_UpdateFollow_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this UpdateFollow execution.
     *
     * @return string The response from Facebook. Corresponds to the ResponseFormat input. Defaults to JSON.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Creates an action representing someone liking an object.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_General_Likes_CreateLike extends Temboo_Choreography
{
    /**
     * Creates an action representing someone liking an object.
     *
     * @param Temboo_Session $session The session that owns this CreateLike Choreo.
     * @return Facebook_Actions_General_Likes_CreateLike New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Actions/General/Likes/CreateLike/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this CreateLike Choreo.
     *
     * @param Facebook_Actions_General_Likes_CreateLike_Inputs|array $inputs (optional) Inputs as Facebook_Actions_General_Likes_CreateLike_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_General_Likes_CreateLike_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Actions_General_Likes_CreateLike_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this CreateLike Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_General_Likes_CreateLike_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Actions_General_Likes_CreateLike_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the CreateLike Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_General_Likes_CreateLike_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the CreateLike Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_General_Likes_CreateLike_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this CreateLike input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Actions_General_Likes_CreateLike_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Actions_General_Likes_CreateLike_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this CreateLike Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Actions_General_Likes_CreateLike_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the CreatedTime input for this CreateLike Choreo.
     *
     * @param string $value (optional, date) The time that the action was created (e.g. 2013-06-24T18:53:35+0000).
     * @return Facebook_Actions_General_Likes_CreateLike_Inputs For method chaining.
     */
    public function setCreatedTime($value)
    {
        return $this->set('CreatedTime', $value);
    }

    /**
     * Set the value for the EndTime input for this CreateLike Choreo.
     *
     * @param string $value (optional, date) The time that the user ended the action (e.g. 2013-06-24T18:53:35+0000).
     * @return Facebook_Actions_General_Likes_CreateLike_Inputs For method chaining.
     */
    public function setEndTime($value)
    {
        return $this->set('EndTime', $value);
    }

    /**
     * Set the value for the ExpiresIn input for this CreateLike Choreo.
     *
     * @param int $value (optional, integer) The amount of time (in milleseconds) from the publish_time that the action will expire.
     * @return Facebook_Actions_General_Likes_CreateLike_Inputs For method chaining.
     */
    public function setExpiresIn($value)
    {
        return $this->set('ExpiresIn', $value);
    }

    /**
     * Set the value for the ExplicitlyShared input for this CreateLike Choreo.
     *
     * @param bool $value (optional, boolean) Indicates that the user is explicitly sharing this action. Requires the explicitly_shared capability to be enabled.
     * @return Facebook_Actions_General_Likes_CreateLike_Inputs For method chaining.
     */
    public function setExplicitlyShared($value)
    {
        return $this->set('ExplicitlyShared', $value);
    }

    /**
     * Set the value for the ExplicityShared input for this CreateLike Choreo.
     *
     * @param bool $value (optional, boolean) Deprecated (retained for backward compatibility only).
     * @return Facebook_Actions_General_Likes_CreateLike_Inputs For method chaining.
     */
    public function setExplicityShared($value)
    {
        return $this->set('ExplicityShared', $value);
    }

    /**
     * Set the value for the Message input for this CreateLike Choreo.
     *
     * @param string $value (optional, string) A message attached to this fitness action. Setting this parameter requires enabling of message capabilities.
     * @return Facebook_Actions_General_Likes_CreateLike_Inputs For method chaining.
     */
    public function setMessage($value)
    {
        return $this->set('Message', $value);
    }

    /**
     * Set the value for the NoFeedStory input for this CreateLike Choreo.
     *
     * @param bool $value (optional, boolean) Whether or not this action should be posted to the users feed.
     * @return Facebook_Actions_General_Likes_CreateLike_Inputs For method chaining.
     */
    public function setNoFeedStory($value)
    {
        return $this->set('NoFeedStory', $value);
    }

    /**
     * Set the value for the Object input for this CreateLike Choreo.
     *
     * @param string $value (required, string) The URL or ID for an Open Graph object to be liked.
     * @return Facebook_Actions_General_Likes_CreateLike_Inputs For method chaining.
     */
    public function setObject($value)
    {
        return $this->set('Object', $value);
    }

    /**
     * Set the value for the Place input for this CreateLike Choreo.
     *
     * @param string $value (optional, string) The Facebook Page ID of the location associated with this action.
     * @return Facebook_Actions_General_Likes_CreateLike_Inputs For method chaining.
     */
    public function setPlace($value)
    {
        return $this->set('Place', $value);
    }

    /**
     * Set the value for the ProfileID input for this CreateLike Choreo.
     *
     * @param string $value (optional, string) The id of the profile to retrieve fitness actions for. Defaults to "me" indicating the authenticated user.
     * @return Facebook_Actions_General_Likes_CreateLike_Inputs For method chaining.
     */
    public function setProfileID($value)
    {
        return $this->set('ProfileID', $value);
    }

    /**
     * Set the value for the Reference input for this CreateLike Choreo.
     *
     * @param string $value (optional, string) A string identifier up to 50 characters used for tracking and insights.
     * @return Facebook_Actions_General_Likes_CreateLike_Inputs For method chaining.
     */
    public function setReference($value)
    {
        return $this->set('Reference', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this CreateLike Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Can be set to xml or json. Defaults to json.
     * @return Facebook_Actions_General_Likes_CreateLike_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }

    /**
     * Set the value for the StartTime input for this CreateLike Choreo.
     *
     * @param string $value (optional, date) The time that the user started the action (e.g. 2013-06-24T18:53:35+0000).
     * @return Facebook_Actions_General_Likes_CreateLike_Inputs For method chaining.
     */
    public function setStartTime($value)
    {
        return $this->set('StartTime', $value);
    }

    /**
     * Set the value for the Tags input for this CreateLike Choreo.
     *
     * @param string $value (optional, string) A comma separated list of other profile IDs that also performed this action.
     * @return Facebook_Actions_General_Likes_CreateLike_Inputs For method chaining.
     */
    public function setTags($value)
    {
        return $this->set('Tags', $value);
    }
}


/**
 * Execution object for the CreateLike Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_General_Likes_CreateLike_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the CreateLike Choreo.
     *
     * @param Temboo_Session $session The session that owns this CreateLike execution.
     * @param Facebook_Actions_General_Likes_CreateLike $choreo The choreography object for this execution.
     * @param Facebook_Actions_General_Likes_CreateLike_Inputs|array $inputs (optional) Inputs as Facebook_Actions_General_Likes_CreateLike_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_General_Likes_CreateLike_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Actions_General_Likes_CreateLike $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this CreateLike execution.
     *
     * @return Facebook_Actions_General_Likes_CreateLike_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this CreateLike execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Actions_General_Likes_CreateLike_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Actions_General_Likes_CreateLike_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the CreateLike Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_General_Likes_CreateLike_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the CreateLike Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Actions_General_Likes_CreateLike_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "ActivityURL" output from this CreateLike execution.
     *
     * @return string (string) The URL for the newly created action.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getActivityURL()
    {
        return $this->get('ActivityURL');
    }
    /**
     * Retrieve the value for the "Response" output from this CreateLike execution.
     *
     * @return string The response from Facebook. Corresponds to the ResponseFormat input. Defaults to JSON.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Deletes a given like action.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_General_Likes_DeleteLike extends Temboo_Choreography
{
    /**
     * Deletes a given like action.
     *
     * @param Temboo_Session $session The session that owns this DeleteLike Choreo.
     * @return Facebook_Actions_General_Likes_DeleteLike New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Actions/General/Likes/DeleteLike/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this DeleteLike Choreo.
     *
     * @param Facebook_Actions_General_Likes_DeleteLike_Inputs|array $inputs (optional) Inputs as Facebook_Actions_General_Likes_DeleteLike_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_General_Likes_DeleteLike_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Actions_General_Likes_DeleteLike_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this DeleteLike Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_General_Likes_DeleteLike_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Actions_General_Likes_DeleteLike_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the DeleteLike Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_General_Likes_DeleteLike_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the DeleteLike Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_General_Likes_DeleteLike_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this DeleteLike input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Actions_General_Likes_DeleteLike_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Actions_General_Likes_DeleteLike_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this DeleteLike Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Actions_General_Likes_DeleteLike_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ActionID input for this DeleteLike Choreo.
     *
     * @param string $value (required, string) The id of an action to delete.
     * @return Facebook_Actions_General_Likes_DeleteLike_Inputs For method chaining.
     */
    public function setActionID($value)
    {
        return $this->set('ActionID', $value);
    }
}


/**
 * Execution object for the DeleteLike Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_General_Likes_DeleteLike_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the DeleteLike Choreo.
     *
     * @param Temboo_Session $session The session that owns this DeleteLike execution.
     * @param Facebook_Actions_General_Likes_DeleteLike $choreo The choreography object for this execution.
     * @param Facebook_Actions_General_Likes_DeleteLike_Inputs|array $inputs (optional) Inputs as Facebook_Actions_General_Likes_DeleteLike_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_General_Likes_DeleteLike_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Actions_General_Likes_DeleteLike $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this DeleteLike execution.
     *
     * @return Facebook_Actions_General_Likes_DeleteLike_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this DeleteLike execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Actions_General_Likes_DeleteLike_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Actions_General_Likes_DeleteLike_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the DeleteLike Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_General_Likes_DeleteLike_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the DeleteLike Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Actions_General_Likes_DeleteLike_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this DeleteLike execution.
     *
     * @return bool (boolean) The response from Facebook. Returns "true" on success.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Retrieves one or more like actions.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_General_Likes_ReadLikes extends Temboo_Choreography
{
    /**
     * Retrieves one or more like actions.
     *
     * @param Temboo_Session $session The session that owns this ReadLikes Choreo.
     * @return Facebook_Actions_General_Likes_ReadLikes New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Actions/General/Likes/ReadLikes/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this ReadLikes Choreo.
     *
     * @param Facebook_Actions_General_Likes_ReadLikes_Inputs|array $inputs (optional) Inputs as Facebook_Actions_General_Likes_ReadLikes_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_General_Likes_ReadLikes_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Actions_General_Likes_ReadLikes_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this ReadLikes Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_General_Likes_ReadLikes_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Actions_General_Likes_ReadLikes_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the ReadLikes Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_General_Likes_ReadLikes_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the ReadLikes Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_General_Likes_ReadLikes_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this ReadLikes input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Actions_General_Likes_ReadLikes_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Actions_General_Likes_ReadLikes_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this ReadLikes Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Actions_General_Likes_ReadLikes_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ActionID input for this ReadLikes Choreo.
     *
     * @param string $value (optional, string) The id of an action to retrieve. If an id is not provided, a list of all like actions will be returned.
     * @return Facebook_Actions_General_Likes_ReadLikes_Inputs For method chaining.
     */
    public function setActionID($value)
    {
        return $this->set('ActionID', $value);
    }

    /**
     * Set the value for the Fields input for this ReadLikes Choreo.
     *
     * @param string $value (optional, string) A comma separated list of fields to return (i.e. id,name).
     * @return Facebook_Actions_General_Likes_ReadLikes_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Limit input for this ReadLikes Choreo.
     *
     * @param int $value (optional, integer) Used to page through results. Limits the number of records returned in the response.
     * @return Facebook_Actions_General_Likes_ReadLikes_Inputs For method chaining.
     */
    public function setLimit($value)
    {
        return $this->set('Limit', $value);
    }

    /**
     * Set the value for the Offset input for this ReadLikes Choreo.
     *
     * @param int $value (optional, integer) Used to page through results. Returns results starting from the specified number.
     * @return Facebook_Actions_General_Likes_ReadLikes_Inputs For method chaining.
     */
    public function setOffset($value)
    {
        return $this->set('Offset', $value);
    }

    /**
     * Set the value for the ProfileID input for this ReadLikes Choreo.
     *
     * @param string $value (optional, string) The id of the user's profile. Defaults to "me" indicating the authenticated user.
     * @return Facebook_Actions_General_Likes_ReadLikes_Inputs For method chaining.
     */
    public function setProfileID($value)
    {
        return $this->set('ProfileID', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this ReadLikes Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Can be set to xml or json. Defaults to json.
     * @return Facebook_Actions_General_Likes_ReadLikes_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }
}


/**
 * Execution object for the ReadLikes Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_General_Likes_ReadLikes_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the ReadLikes Choreo.
     *
     * @param Temboo_Session $session The session that owns this ReadLikes execution.
     * @param Facebook_Actions_General_Likes_ReadLikes $choreo The choreography object for this execution.
     * @param Facebook_Actions_General_Likes_ReadLikes_Inputs|array $inputs (optional) Inputs as Facebook_Actions_General_Likes_ReadLikes_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_General_Likes_ReadLikes_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Actions_General_Likes_ReadLikes $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this ReadLikes execution.
     *
     * @return Facebook_Actions_General_Likes_ReadLikes_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this ReadLikes execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Actions_General_Likes_ReadLikes_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Actions_General_Likes_ReadLikes_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the ReadLikes Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_General_Likes_ReadLikes_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the ReadLikes Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Actions_General_Likes_ReadLikes_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "HasNext" output from this ReadLikes execution.
     *
     * @return bool (boolean) A boolean flag indicating that a next page exists.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getHasNext()
    {
        return $this->get('HasNext');
    }
    /**
     * Retrieve the value for the "HasPrevious" output from this ReadLikes execution.
     *
     * @return bool (boolean) A boolean flag indicating that a previous page exists.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getHasPrevious()
    {
        return $this->get('HasPrevious');
    }
    /**
     * Retrieve the value for the "Response" output from this ReadLikes execution.
     *
     * @return string The response from Facebook. Corresponds to the ResponseFormat input. Defaults to JSON.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Creates an action that represents a user liking an object.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_General_Likes_UpdateLike extends Temboo_Choreography
{
    /**
     * Creates an action that represents a user liking an object.
     *
     * @param Temboo_Session $session The session that owns this UpdateLike Choreo.
     * @return Facebook_Actions_General_Likes_UpdateLike New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Actions/General/Likes/UpdateLike/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this UpdateLike Choreo.
     *
     * @param Facebook_Actions_General_Likes_UpdateLike_Inputs|array $inputs (optional) Inputs as Facebook_Actions_General_Likes_UpdateLike_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_General_Likes_UpdateLike_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Actions_General_Likes_UpdateLike_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this UpdateLike Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_General_Likes_UpdateLike_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Actions_General_Likes_UpdateLike_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the UpdateLike Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_General_Likes_UpdateLike_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the UpdateLike Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_General_Likes_UpdateLike_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this UpdateLike input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Actions_General_Likes_UpdateLike_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Actions_General_Likes_UpdateLike_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this UpdateLike Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Actions_General_Likes_UpdateLike_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ActionID input for this UpdateLike Choreo.
     *
     * @param string $value (required, string) The id of the action to update.
     * @return Facebook_Actions_General_Likes_UpdateLike_Inputs For method chaining.
     */
    public function setActionID($value)
    {
        return $this->set('ActionID', $value);
    }

    /**
     * Set the value for the EndTime input for this UpdateLike Choreo.
     *
     * @param string $value (optional, date) The time that the user ended the action (e.g. 2013-06-24T18:53:35+0000).
     * @return Facebook_Actions_General_Likes_UpdateLike_Inputs For method chaining.
     */
    public function setEndTime($value)
    {
        return $this->set('EndTime', $value);
    }

    /**
     * Set the value for the ExpiresIn input for this UpdateLike Choreo.
     *
     * @param int $value (optional, integer) The amount of time (in milliseconds) from the publish_time that the action will expire.
     * @return Facebook_Actions_General_Likes_UpdateLike_Inputs For method chaining.
     */
    public function setExpiresIn($value)
    {
        return $this->set('ExpiresIn', $value);
    }

    /**
     * Set the value for the Message input for this UpdateLike Choreo.
     *
     * @param string $value (optional, string) A message attached to this fitness action. Setting this parameter requires enabling of message capabilities.
     * @return Facebook_Actions_General_Likes_UpdateLike_Inputs For method chaining.
     */
    public function setMessage($value)
    {
        return $this->set('Message', $value);
    }

    /**
     * Set the value for the Object input for this UpdateLike Choreo.
     *
     * @param string $value (optional, string) The URL or ID for an Open Graph object  that was liked.
     * @return Facebook_Actions_General_Likes_UpdateLike_Inputs For method chaining.
     */
    public function setObject($value)
    {
        return $this->set('Object', $value);
    }

    /**
     * Set the value for the Place input for this UpdateLike Choreo.
     *
     * @param string $value (optional, string) The URL or ID for an Open Graph object representing the location associated with this action.
     * @return Facebook_Actions_General_Likes_UpdateLike_Inputs For method chaining.
     */
    public function setPlace($value)
    {
        return $this->set('Place', $value);
    }

    /**
     * Set the value for the Tags input for this UpdateLike Choreo.
     *
     * @param string $value (optional, string) A comma separated list of other profile IDs that also performed this action.
     * @return Facebook_Actions_General_Likes_UpdateLike_Inputs For method chaining.
     */
    public function setTags($value)
    {
        return $this->set('Tags', $value);
    }
}


/**
 * Execution object for the UpdateLike Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_General_Likes_UpdateLike_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the UpdateLike Choreo.
     *
     * @param Temboo_Session $session The session that owns this UpdateLike execution.
     * @param Facebook_Actions_General_Likes_UpdateLike $choreo The choreography object for this execution.
     * @param Facebook_Actions_General_Likes_UpdateLike_Inputs|array $inputs (optional) Inputs as Facebook_Actions_General_Likes_UpdateLike_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_General_Likes_UpdateLike_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Actions_General_Likes_UpdateLike $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this UpdateLike execution.
     *
     * @return Facebook_Actions_General_Likes_UpdateLike_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this UpdateLike execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Actions_General_Likes_UpdateLike_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Actions_General_Likes_UpdateLike_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the UpdateLike Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_General_Likes_UpdateLike_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the UpdateLike Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Actions_General_Likes_UpdateLike_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this UpdateLike execution.
     *
     * @return string The response from Facebook. Corresponds to the ResponseFormat input. Defaults to JSON.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Creates an action that represents a user listening to music.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Music_Listens_CreateListen extends Temboo_Choreography
{
    /**
     * Creates an action that represents a user listening to music.
     *
     * @param Temboo_Session $session The session that owns this CreateListen Choreo.
     * @return Facebook_Actions_Music_Listens_CreateListen New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Actions/Music/Listens/CreateListen/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this CreateListen Choreo.
     *
     * @param Facebook_Actions_Music_Listens_CreateListen_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Music_Listens_CreateListen_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Music_Listens_CreateListen_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Actions_Music_Listens_CreateListen_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this CreateListen Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Music_Listens_CreateListen_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Actions_Music_Listens_CreateListen_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the CreateListen Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Music_Listens_CreateListen_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the CreateListen Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Music_Listens_CreateListen_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this CreateListen input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Actions_Music_Listens_CreateListen_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Actions_Music_Listens_CreateListen_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this CreateListen Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Actions_Music_Listens_CreateListen_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the Album input for this CreateListen Choreo.
     *
     * @param string $value (conditional, string) The URL or ID for an Open Graph object representing  representing an album.
     * @return Facebook_Actions_Music_Listens_CreateListen_Inputs For method chaining.
     */
    public function setAlbum($value)
    {
        return $this->set('Album', $value);
    }

    /**
     * Set the value for the CreatedTime input for this CreateListen Choreo.
     *
     * @param string $value (optional, date) The time that the action was created (e.g. 2013-06-24T18:53:35+0000).
     * @return Facebook_Actions_Music_Listens_CreateListen_Inputs For method chaining.
     */
    public function setCreatedTime($value)
    {
        return $this->set('CreatedTime', $value);
    }

    /**
     * Set the value for the EndTime input for this CreateListen Choreo.
     *
     * @param string $value (optional, date) The time that the user ended the action (e.g. 2013-06-24T18:53:35+0000).
     * @return Facebook_Actions_Music_Listens_CreateListen_Inputs For method chaining.
     */
    public function setEndTime($value)
    {
        return $this->set('EndTime', $value);
    }

    /**
     * Set the value for the ExpiresIn input for this CreateListen Choreo.
     *
     * @param int $value (optional, integer) The amount of time (in milliseconds) from the publish_time that the action will expire.
     * @return Facebook_Actions_Music_Listens_CreateListen_Inputs For method chaining.
     */
    public function setExpiresIn($value)
    {
        return $this->set('ExpiresIn', $value);
    }

    /**
     * Set the value for the ExplicitlyShared input for this CreateListen Choreo.
     *
     * @param bool $value (optional, boolean) Indicates that the user is explicitly sharing this action. Requires the explicitly_shared capability to be enabled.
     * @return Facebook_Actions_Music_Listens_CreateListen_Inputs For method chaining.
     */
    public function setExplicitlyShared($value)
    {
        return $this->set('ExplicitlyShared', $value);
    }

    /**
     * Set the value for the ExplicityShared input for this CreateListen Choreo.
     *
     * @param bool $value (optional, boolean) Deprecated (retained for backward compatibility only).
     * @return Facebook_Actions_Music_Listens_CreateListen_Inputs For method chaining.
     */
    public function setExplicityShared($value)
    {
        return $this->set('ExplicityShared', $value);
    }

    /**
     * Set the value for the Message input for this CreateListen Choreo.
     *
     * @param string $value (optional, string) A message attached to this action. Setting this parameter requires enabling of message capabilities.
     * @return Facebook_Actions_Music_Listens_CreateListen_Inputs For method chaining.
     */
    public function setMessage($value)
    {
        return $this->set('Message', $value);
    }

    /**
     * Set the value for the Musician input for this CreateListen Choreo.
     *
     * @param string $value (conditional, string) The URL or ID for an Open Graph object representing representing a musician.
     * @return Facebook_Actions_Music_Listens_CreateListen_Inputs For method chaining.
     */
    public function setMusician($value)
    {
        return $this->set('Musician', $value);
    }

    /**
     * Set the value for the NoFeedStory input for this CreateListen Choreo.
     *
     * @param bool $value (optional, boolean) Whether or not this action should be posted to the users feed.
     * @return Facebook_Actions_Music_Listens_CreateListen_Inputs For method chaining.
     */
    public function setNoFeedStory($value)
    {
        return $this->set('NoFeedStory', $value);
    }

    /**
     * Set the value for the Paused input for this CreateListen Choreo.
     *
     * @param bool $value (optional, boolean) Whether the audio is paused or not
     * @return Facebook_Actions_Music_Listens_CreateListen_Inputs For method chaining.
     */
    public function setPaused($value)
    {
        return $this->set('Paused', $value);
    }

    /**
     * Set the value for the Place input for this CreateListen Choreo.
     *
     * @param string $value (optional, string) The URL or ID for an Open Graph object representing the location associated with this action.
     * @return Facebook_Actions_Music_Listens_CreateListen_Inputs For method chaining.
     */
    public function setPlace($value)
    {
        return $this->set('Place', $value);
    }

    /**
     * Set the value for the Playlist input for this CreateListen Choreo.
     *
     * @param string $value (conditional, string) The URL or ID for an Open Graph object representing representing a playlist.
     * @return Facebook_Actions_Music_Listens_CreateListen_Inputs For method chaining.
     */
    public function setPlaylist($value)
    {
        return $this->set('Playlist', $value);
    }

    /**
     * Set the value for the ProfileID input for this CreateListen Choreo.
     *
     * @param string $value (optional, string) The id of the user's profile. Defaults to "me" indicating the authenticated user.
     * @return Facebook_Actions_Music_Listens_CreateListen_Inputs For method chaining.
     */
    public function setProfileID($value)
    {
        return $this->set('ProfileID', $value);
    }

    /**
     * Set the value for the RadioStation input for this CreateListen Choreo.
     *
     * @param string $value (conditional, string) The URL or ID for an Open Graph object representing  representing a radio station
     * @return Facebook_Actions_Music_Listens_CreateListen_Inputs For method chaining.
     */
    public function setRadioStation($value)
    {
        return $this->set('RadioStation', $value);
    }

    /**
     * Set the value for the Reference input for this CreateListen Choreo.
     *
     * @param string $value (optional, string) A string identifier up to 50 characters used for tracking and insights.
     * @return Facebook_Actions_Music_Listens_CreateListen_Inputs For method chaining.
     */
    public function setReference($value)
    {
        return $this->set('Reference', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this CreateListen Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Can be set to xml or json. Defaults to json.
     * @return Facebook_Actions_Music_Listens_CreateListen_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }

    /**
     * Set the value for the Song input for this CreateListen Choreo.
     *
     * @param string $value (conditional, string) The URL or ID for an Open Graph object representing  representing a song.
     * @return Facebook_Actions_Music_Listens_CreateListen_Inputs For method chaining.
     */
    public function setSong($value)
    {
        return $this->set('Song', $value);
    }

    /**
     * Set the value for the StartTime input for this CreateListen Choreo.
     *
     * @param string $value (optional, date) The time that the user started the action (e.g. 2013-06-24T18:53:35+0000).
     * @return Facebook_Actions_Music_Listens_CreateListen_Inputs For method chaining.
     */
    public function setStartTime($value)
    {
        return $this->set('StartTime', $value);
    }

    /**
     * Set the value for the Tags input for this CreateListen Choreo.
     *
     * @param string $value (optional, string) A comma separated list of other profile IDs that also performed this action.
     * @return Facebook_Actions_Music_Listens_CreateListen_Inputs For method chaining.
     */
    public function setTags($value)
    {
        return $this->set('Tags', $value);
    }

    /**
     * Set the value for the ViaUser input for this CreateListen Choreo.
     *
     * @param int $value (optional, integer) The ID of anyone whom the user discovered this audio from
     * @return Facebook_Actions_Music_Listens_CreateListen_Inputs For method chaining.
     */
    public function setViaUser($value)
    {
        return $this->set('ViaUser', $value);
    }
}


/**
 * Execution object for the CreateListen Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Music_Listens_CreateListen_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the CreateListen Choreo.
     *
     * @param Temboo_Session $session The session that owns this CreateListen execution.
     * @param Facebook_Actions_Music_Listens_CreateListen $choreo The choreography object for this execution.
     * @param Facebook_Actions_Music_Listens_CreateListen_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Music_Listens_CreateListen_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Music_Listens_CreateListen_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Actions_Music_Listens_CreateListen $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this CreateListen execution.
     *
     * @return Facebook_Actions_Music_Listens_CreateListen_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this CreateListen execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Actions_Music_Listens_CreateListen_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Actions_Music_Listens_CreateListen_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the CreateListen Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Music_Listens_CreateListen_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the CreateListen Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Actions_Music_Listens_CreateListen_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "ActivityURL" output from this CreateListen execution.
     *
     * @return string (string) The URL for the newly created action.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getActivityURL()
    {
        return $this->get('ActivityURL');
    }
    /**
     * Retrieve the value for the "Response" output from this CreateListen execution.
     *
     * @return string The response from Facebook. Corresponds to the ResponseFormat input. Defaults to JSON.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Deletes a given listen action.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Music_Listens_DeleteListen extends Temboo_Choreography
{
    /**
     * Deletes a given listen action.
     *
     * @param Temboo_Session $session The session that owns this DeleteListen Choreo.
     * @return Facebook_Actions_Music_Listens_DeleteListen New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Actions/Music/Listens/DeleteListen/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this DeleteListen Choreo.
     *
     * @param Facebook_Actions_Music_Listens_DeleteListen_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Music_Listens_DeleteListen_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Music_Listens_DeleteListen_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Actions_Music_Listens_DeleteListen_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this DeleteListen Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Music_Listens_DeleteListen_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Actions_Music_Listens_DeleteListen_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the DeleteListen Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Music_Listens_DeleteListen_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the DeleteListen Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Music_Listens_DeleteListen_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this DeleteListen input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Actions_Music_Listens_DeleteListen_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Actions_Music_Listens_DeleteListen_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this DeleteListen Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Actions_Music_Listens_DeleteListen_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ActionID input for this DeleteListen Choreo.
     *
     * @param string $value (required, string) The id of an action to delete.
     * @return Facebook_Actions_Music_Listens_DeleteListen_Inputs For method chaining.
     */
    public function setActionID($value)
    {
        return $this->set('ActionID', $value);
    }
}


/**
 * Execution object for the DeleteListen Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Music_Listens_DeleteListen_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the DeleteListen Choreo.
     *
     * @param Temboo_Session $session The session that owns this DeleteListen execution.
     * @param Facebook_Actions_Music_Listens_DeleteListen $choreo The choreography object for this execution.
     * @param Facebook_Actions_Music_Listens_DeleteListen_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Music_Listens_DeleteListen_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Music_Listens_DeleteListen_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Actions_Music_Listens_DeleteListen $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this DeleteListen execution.
     *
     * @return Facebook_Actions_Music_Listens_DeleteListen_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this DeleteListen execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Actions_Music_Listens_DeleteListen_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Actions_Music_Listens_DeleteListen_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the DeleteListen Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Music_Listens_DeleteListen_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the DeleteListen Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Actions_Music_Listens_DeleteListen_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this DeleteListen execution.
     *
     * @return bool (boolean) The response from Facebook. Returns "true" on success.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Retrieves one or more listen actions.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Music_Listens_ReadListens extends Temboo_Choreography
{
    /**
     * Retrieves one or more listen actions.
     *
     * @param Temboo_Session $session The session that owns this ReadListens Choreo.
     * @return Facebook_Actions_Music_Listens_ReadListens New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Actions/Music/Listens/ReadListens/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this ReadListens Choreo.
     *
     * @param Facebook_Actions_Music_Listens_ReadListens_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Music_Listens_ReadListens_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Music_Listens_ReadListens_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Actions_Music_Listens_ReadListens_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this ReadListens Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Music_Listens_ReadListens_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Actions_Music_Listens_ReadListens_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the ReadListens Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Music_Listens_ReadListens_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the ReadListens Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Music_Listens_ReadListens_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this ReadListens input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Actions_Music_Listens_ReadListens_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Actions_Music_Listens_ReadListens_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this ReadListens Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Actions_Music_Listens_ReadListens_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ActionID input for this ReadListens Choreo.
     *
     * @param string $value (optional, string) The id of an action to retrieve. If an id is not provided, a list of all listen actions will be returned.
     * @return Facebook_Actions_Music_Listens_ReadListens_Inputs For method chaining.
     */
    public function setActionID($value)
    {
        return $this->set('ActionID', $value);
    }

    /**
     * Set the value for the Fields input for this ReadListens Choreo.
     *
     * @param string $value (optional, string) A comma separated list of fields to return (i.e. id,name).
     * @return Facebook_Actions_Music_Listens_ReadListens_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Limit input for this ReadListens Choreo.
     *
     * @param int $value (optional, integer) Used to page through results. Limits the number of records returned in the response.
     * @return Facebook_Actions_Music_Listens_ReadListens_Inputs For method chaining.
     */
    public function setLimit($value)
    {
        return $this->set('Limit', $value);
    }

    /**
     * Set the value for the Offset input for this ReadListens Choreo.
     *
     * @param int $value (optional, integer) Used to page through results. Returns results starting from the specified number.
     * @return Facebook_Actions_Music_Listens_ReadListens_Inputs For method chaining.
     */
    public function setOffset($value)
    {
        return $this->set('Offset', $value);
    }

    /**
     * Set the value for the ProfileID input for this ReadListens Choreo.
     *
     * @param string $value (optional, string) The id of the user's profile. Defaults to "me" indicating the authenticated user.
     * @return Facebook_Actions_Music_Listens_ReadListens_Inputs For method chaining.
     */
    public function setProfileID($value)
    {
        return $this->set('ProfileID', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this ReadListens Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Can be set to xml or json. Defaults to json.
     * @return Facebook_Actions_Music_Listens_ReadListens_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }
}


/**
 * Execution object for the ReadListens Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Music_Listens_ReadListens_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the ReadListens Choreo.
     *
     * @param Temboo_Session $session The session that owns this ReadListens execution.
     * @param Facebook_Actions_Music_Listens_ReadListens $choreo The choreography object for this execution.
     * @param Facebook_Actions_Music_Listens_ReadListens_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Music_Listens_ReadListens_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Music_Listens_ReadListens_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Actions_Music_Listens_ReadListens $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this ReadListens execution.
     *
     * @return Facebook_Actions_Music_Listens_ReadListens_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this ReadListens execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Actions_Music_Listens_ReadListens_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Actions_Music_Listens_ReadListens_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the ReadListens Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Music_Listens_ReadListens_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the ReadListens Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Actions_Music_Listens_ReadListens_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "HasNext" output from this ReadListens execution.
     *
     * @return bool (boolean) A boolean flag indicating that a next page exists.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getHasNext()
    {
        return $this->get('HasNext');
    }
    /**
     * Retrieve the value for the "HasPrevious" output from this ReadListens execution.
     *
     * @return bool (boolean) A boolean flag indicating that a previous page exists.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getHasPrevious()
    {
        return $this->get('HasPrevious');
    }
    /**
     * Retrieve the value for the "Response" output from this ReadListens execution.
     *
     * @return string The response from Facebook. Corresponds to the ResponseFormat input. Defaults to JSON.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Updates and existing listen action.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Music_Listens_UpdateListen extends Temboo_Choreography
{
    /**
     * Updates and existing listen action.
     *
     * @param Temboo_Session $session The session that owns this UpdateListen Choreo.
     * @return Facebook_Actions_Music_Listens_UpdateListen New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Actions/Music/Listens/UpdateListen/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this UpdateListen Choreo.
     *
     * @param Facebook_Actions_Music_Listens_UpdateListen_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Music_Listens_UpdateListen_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Music_Listens_UpdateListen_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Actions_Music_Listens_UpdateListen_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this UpdateListen Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Music_Listens_UpdateListen_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Actions_Music_Listens_UpdateListen_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the UpdateListen Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Music_Listens_UpdateListen_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the UpdateListen Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Music_Listens_UpdateListen_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this UpdateListen input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Actions_Music_Listens_UpdateListen_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Actions_Music_Listens_UpdateListen_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this UpdateListen Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Actions_Music_Listens_UpdateListen_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ActionID input for this UpdateListen Choreo.
     *
     * @param string $value (required, string) The id of the action to update.
     * @return Facebook_Actions_Music_Listens_UpdateListen_Inputs For method chaining.
     */
    public function setActionID($value)
    {
        return $this->set('ActionID', $value);
    }

    /**
     * Set the value for the Album input for this UpdateListen Choreo.
     *
     * @param string $value (optional, string) The URL or ID for an Open Graph object representing  representing an album.
     * @return Facebook_Actions_Music_Listens_UpdateListen_Inputs For method chaining.
     */
    public function setAlbum($value)
    {
        return $this->set('Album', $value);
    }

    /**
     * Set the value for the EndTime input for this UpdateListen Choreo.
     *
     * @param string $value (optional, date) The time that the user ended the action (e.g. 2013-06-24T18:53:35+0000).
     * @return Facebook_Actions_Music_Listens_UpdateListen_Inputs For method chaining.
     */
    public function setEndTime($value)
    {
        return $this->set('EndTime', $value);
    }

    /**
     * Set the value for the ExpiresIn input for this UpdateListen Choreo.
     *
     * @param int $value (optional, integer) The amount of time (in milliseconds) from the publish_time that the action will expire.
     * @return Facebook_Actions_Music_Listens_UpdateListen_Inputs For method chaining.
     */
    public function setExpiresIn($value)
    {
        return $this->set('ExpiresIn', $value);
    }

    /**
     * Set the value for the Message input for this UpdateListen Choreo.
     *
     * @param string $value (optional, string) A message attached to this fitness action. Setting this parameter requires enabling of message capabilities.
     * @return Facebook_Actions_Music_Listens_UpdateListen_Inputs For method chaining.
     */
    public function setMessage($value)
    {
        return $this->set('Message', $value);
    }

    /**
     * Set the value for the Musician input for this UpdateListen Choreo.
     *
     * @param string $value (optional, string) The URL or ID for an Open Graph object representing representing a musician.
     * @return Facebook_Actions_Music_Listens_UpdateListen_Inputs For method chaining.
     */
    public function setMusician($value)
    {
        return $this->set('Musician', $value);
    }

    /**
     * Set the value for the Paused input for this UpdateListen Choreo.
     *
     * @param bool $value (optional, boolean) Whether the audio is paused or not
     * @return Facebook_Actions_Music_Listens_UpdateListen_Inputs For method chaining.
     */
    public function setPaused($value)
    {
        return $this->set('Paused', $value);
    }

    /**
     * Set the value for the Place input for this UpdateListen Choreo.
     *
     * @param string $value (optional, string) The URL or ID for an Open Graph object representing the location associated with this action.
     * @return Facebook_Actions_Music_Listens_UpdateListen_Inputs For method chaining.
     */
    public function setPlace($value)
    {
        return $this->set('Place', $value);
    }

    /**
     * Set the value for the Playlist input for this UpdateListen Choreo.
     *
     * @param string $value (optional, string) The URL or ID for an Open Graph object representing representing a playlist.
     * @return Facebook_Actions_Music_Listens_UpdateListen_Inputs For method chaining.
     */
    public function setPlaylist($value)
    {
        return $this->set('Playlist', $value);
    }

    /**
     * Set the value for the RadioStation input for this UpdateListen Choreo.
     *
     * @param string $value (optional, string) The URL or ID for an Open Graph object representing  representing a radio station.
     * @return Facebook_Actions_Music_Listens_UpdateListen_Inputs For method chaining.
     */
    public function setRadioStation($value)
    {
        return $this->set('RadioStation', $value);
    }

    /**
     * Set the value for the Song input for this UpdateListen Choreo.
     *
     * @param string $value (optional, string) The URL or ID for an Open Graph object representing  representing a song.
     * @return Facebook_Actions_Music_Listens_UpdateListen_Inputs For method chaining.
     */
    public function setSong($value)
    {
        return $this->set('Song', $value);
    }

    /**
     * Set the value for the Tags input for this UpdateListen Choreo.
     *
     * @param string $value (optional, string) A comma separated list of other profile IDs that also performed this action.
     * @return Facebook_Actions_Music_Listens_UpdateListen_Inputs For method chaining.
     */
    public function setTags($value)
    {
        return $this->set('Tags', $value);
    }

    /**
     * Set the value for the ViaUser input for this UpdateListen Choreo.
     *
     * @param int $value (optional, integer) The ID of anyone whom the user discovered this audio from
     * @return Facebook_Actions_Music_Listens_UpdateListen_Inputs For method chaining.
     */
    public function setViaUser($value)
    {
        return $this->set('ViaUser', $value);
    }
}


/**
 * Execution object for the UpdateListen Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Music_Listens_UpdateListen_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the UpdateListen Choreo.
     *
     * @param Temboo_Session $session The session that owns this UpdateListen execution.
     * @param Facebook_Actions_Music_Listens_UpdateListen $choreo The choreography object for this execution.
     * @param Facebook_Actions_Music_Listens_UpdateListen_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Music_Listens_UpdateListen_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Music_Listens_UpdateListen_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Actions_Music_Listens_UpdateListen $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this UpdateListen execution.
     *
     * @return Facebook_Actions_Music_Listens_UpdateListen_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this UpdateListen execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Actions_Music_Listens_UpdateListen_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Actions_Music_Listens_UpdateListen_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the UpdateListen Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Music_Listens_UpdateListen_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the UpdateListen Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Actions_Music_Listens_UpdateListen_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this UpdateListen execution.
     *
     * @return string The response from Facebook. Corresponds to the ResponseFormat input. Defaults to JSON.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Creates an action representing someone creating a playlist.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Music_Playlists_CreatePlaylist extends Temboo_Choreography
{
    /**
     * Creates an action representing someone creating a playlist.
     *
     * @param Temboo_Session $session The session that owns this CreatePlaylist Choreo.
     * @return Facebook_Actions_Music_Playlists_CreatePlaylist New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Actions/Music/Playlists/CreatePlaylist/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this CreatePlaylist Choreo.
     *
     * @param Facebook_Actions_Music_Playlists_CreatePlaylist_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Music_Playlists_CreatePlaylist_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Music_Playlists_CreatePlaylist_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Actions_Music_Playlists_CreatePlaylist_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this CreatePlaylist Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Music_Playlists_CreatePlaylist_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Actions_Music_Playlists_CreatePlaylist_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the CreatePlaylist Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Music_Playlists_CreatePlaylist_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the CreatePlaylist Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Music_Playlists_CreatePlaylist_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this CreatePlaylist input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Actions_Music_Playlists_CreatePlaylist_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Actions_Music_Playlists_CreatePlaylist_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this CreatePlaylist Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Actions_Music_Playlists_CreatePlaylist_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the CreatedTime input for this CreatePlaylist Choreo.
     *
     * @param string $value (optional, date) The time that the action was created (e.g. 2013-06-24T18:53:35+0000).
     * @return Facebook_Actions_Music_Playlists_CreatePlaylist_Inputs For method chaining.
     */
    public function setCreatedTime($value)
    {
        return $this->set('CreatedTime', $value);
    }

    /**
     * Set the value for the EndTime input for this CreatePlaylist Choreo.
     *
     * @param string $value (optional, date) The time that the user ended the action (e.g. 2013-06-24T18:53:35+0000).
     * @return Facebook_Actions_Music_Playlists_CreatePlaylist_Inputs For method chaining.
     */
    public function setEndTime($value)
    {
        return $this->set('EndTime', $value);
    }

    /**
     * Set the value for the ExpiresIn input for this CreatePlaylist Choreo.
     *
     * @param int $value (optional, integer) The amount of time (in milliseconds) from the publish_time that the action will expire.
     * @return Facebook_Actions_Music_Playlists_CreatePlaylist_Inputs For method chaining.
     */
    public function setExpiresIn($value)
    {
        return $this->set('ExpiresIn', $value);
    }

    /**
     * Set the value for the ExplicitlyShared input for this CreatePlaylist Choreo.
     *
     * @param bool $value (optional, boolean) Indicates that the user is explicitly sharing this action. Requires the explicitly_shared capability to be enabled.
     * @return Facebook_Actions_Music_Playlists_CreatePlaylist_Inputs For method chaining.
     */
    public function setExplicitlyShared($value)
    {
        return $this->set('ExplicitlyShared', $value);
    }

    /**
     * Set the value for the ExplicityShared input for this CreatePlaylist Choreo.
     *
     * @param bool $value (optional, boolean) Deprecated (retained for backward compatibility only).
     * @return Facebook_Actions_Music_Playlists_CreatePlaylist_Inputs For method chaining.
     */
    public function setExplicityShared($value)
    {
        return $this->set('ExplicityShared', $value);
    }

    /**
     * Set the value for the Message input for this CreatePlaylist Choreo.
     *
     * @param string $value (optional, string) A message attached to this action. Setting this parameter requires enabling of message capabilities.
     * @return Facebook_Actions_Music_Playlists_CreatePlaylist_Inputs For method chaining.
     */
    public function setMessage($value)
    {
        return $this->set('Message', $value);
    }

    /**
     * Set the value for the NoFeedStory input for this CreatePlaylist Choreo.
     *
     * @param bool $value (optional, boolean) Whether or not this action should be posted to the users feed.
     * @return Facebook_Actions_Music_Playlists_CreatePlaylist_Inputs For method chaining.
     */
    public function setNoFeedStory($value)
    {
        return $this->set('NoFeedStory', $value);
    }

    /**
     * Set the value for the Place input for this CreatePlaylist Choreo.
     *
     * @param string $value (optional, string) The URL or ID for an Open Graph object representing the location associated with this action.
     * @return Facebook_Actions_Music_Playlists_CreatePlaylist_Inputs For method chaining.
     */
    public function setPlace($value)
    {
        return $this->set('Place', $value);
    }

    /**
     * Set the value for the Playlist input for this CreatePlaylist Choreo.
     *
     * @param string $value (required, string) An object representing the playlist
     * @return Facebook_Actions_Music_Playlists_CreatePlaylist_Inputs For method chaining.
     */
    public function setPlaylist($value)
    {
        return $this->set('Playlist', $value);
    }

    /**
     * Set the value for the ProfileID input for this CreatePlaylist Choreo.
     *
     * @param string $value (optional, string) The id of the user's profile. Defaults to "me" indicating the authenticated user.
     * @return Facebook_Actions_Music_Playlists_CreatePlaylist_Inputs For method chaining.
     */
    public function setProfileID($value)
    {
        return $this->set('ProfileID', $value);
    }

    /**
     * Set the value for the Reference input for this CreatePlaylist Choreo.
     *
     * @param string $value (optional, string) A string identifier up to 50 characters used for tracking and insights.
     * @return Facebook_Actions_Music_Playlists_CreatePlaylist_Inputs For method chaining.
     */
    public function setReference($value)
    {
        return $this->set('Reference', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this CreatePlaylist Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Can be set to xml or json. Defaults to json.
     * @return Facebook_Actions_Music_Playlists_CreatePlaylist_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }

    /**
     * Set the value for the StartTime input for this CreatePlaylist Choreo.
     *
     * @param string $value (optional, date) The time that the user started the action (e.g. 2013-06-24T18:53:35+0000).
     * @return Facebook_Actions_Music_Playlists_CreatePlaylist_Inputs For method chaining.
     */
    public function setStartTime($value)
    {
        return $this->set('StartTime', $value);
    }

    /**
     * Set the value for the Tags input for this CreatePlaylist Choreo.
     *
     * @param string $value (optional, string) A comma separated list of other profile IDs that also performed this action.
     * @return Facebook_Actions_Music_Playlists_CreatePlaylist_Inputs For method chaining.
     */
    public function setTags($value)
    {
        return $this->set('Tags', $value);
    }
}


/**
 * Execution object for the CreatePlaylist Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Music_Playlists_CreatePlaylist_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the CreatePlaylist Choreo.
     *
     * @param Temboo_Session $session The session that owns this CreatePlaylist execution.
     * @param Facebook_Actions_Music_Playlists_CreatePlaylist $choreo The choreography object for this execution.
     * @param Facebook_Actions_Music_Playlists_CreatePlaylist_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Music_Playlists_CreatePlaylist_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Music_Playlists_CreatePlaylist_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Actions_Music_Playlists_CreatePlaylist $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this CreatePlaylist execution.
     *
     * @return Facebook_Actions_Music_Playlists_CreatePlaylist_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this CreatePlaylist execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Actions_Music_Playlists_CreatePlaylist_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Actions_Music_Playlists_CreatePlaylist_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the CreatePlaylist Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Music_Playlists_CreatePlaylist_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the CreatePlaylist Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Actions_Music_Playlists_CreatePlaylist_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "ActivityURL" output from this CreatePlaylist execution.
     *
     * @return string (string) The URL for the newly created action.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getActivityURL()
    {
        return $this->get('ActivityURL');
    }
    /**
     * Retrieve the value for the "Response" output from this CreatePlaylist execution.
     *
     * @return string The response from Facebook. Corresponds to the ResponseFormat input. Defaults to JSON.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Deletes a given playlist action.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Music_Playlists_DeletePlaylist extends Temboo_Choreography
{
    /**
     * Deletes a given playlist action.
     *
     * @param Temboo_Session $session The session that owns this DeletePlaylist Choreo.
     * @return Facebook_Actions_Music_Playlists_DeletePlaylist New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Actions/Music/Playlists/DeletePlaylist/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this DeletePlaylist Choreo.
     *
     * @param Facebook_Actions_Music_Playlists_DeletePlaylist_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Music_Playlists_DeletePlaylist_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Music_Playlists_DeletePlaylist_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Actions_Music_Playlists_DeletePlaylist_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this DeletePlaylist Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Music_Playlists_DeletePlaylist_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Actions_Music_Playlists_DeletePlaylist_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the DeletePlaylist Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Music_Playlists_DeletePlaylist_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the DeletePlaylist Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Music_Playlists_DeletePlaylist_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this DeletePlaylist input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Actions_Music_Playlists_DeletePlaylist_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Actions_Music_Playlists_DeletePlaylist_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this DeletePlaylist Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Actions_Music_Playlists_DeletePlaylist_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ActionID input for this DeletePlaylist Choreo.
     *
     * @param string $value (required, string) The id of an action to delete.
     * @return Facebook_Actions_Music_Playlists_DeletePlaylist_Inputs For method chaining.
     */
    public function setActionID($value)
    {
        return $this->set('ActionID', $value);
    }
}


/**
 * Execution object for the DeletePlaylist Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Music_Playlists_DeletePlaylist_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the DeletePlaylist Choreo.
     *
     * @param Temboo_Session $session The session that owns this DeletePlaylist execution.
     * @param Facebook_Actions_Music_Playlists_DeletePlaylist $choreo The choreography object for this execution.
     * @param Facebook_Actions_Music_Playlists_DeletePlaylist_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Music_Playlists_DeletePlaylist_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Music_Playlists_DeletePlaylist_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Actions_Music_Playlists_DeletePlaylist $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this DeletePlaylist execution.
     *
     * @return Facebook_Actions_Music_Playlists_DeletePlaylist_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this DeletePlaylist execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Actions_Music_Playlists_DeletePlaylist_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Actions_Music_Playlists_DeletePlaylist_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the DeletePlaylist Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Music_Playlists_DeletePlaylist_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the DeletePlaylist Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Actions_Music_Playlists_DeletePlaylist_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this DeletePlaylist execution.
     *
     * @return bool (boolean) The response from Facebook. Returns "true" on success.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Retrieves one or more playlist actions.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Music_Playlists_ReadPlaylist extends Temboo_Choreography
{
    /**
     * Retrieves one or more playlist actions.
     *
     * @param Temboo_Session $session The session that owns this ReadPlaylist Choreo.
     * @return Facebook_Actions_Music_Playlists_ReadPlaylist New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Actions/Music/Playlists/ReadPlaylist/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this ReadPlaylist Choreo.
     *
     * @param Facebook_Actions_Music_Playlists_ReadPlaylist_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Music_Playlists_ReadPlaylist_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Music_Playlists_ReadPlaylist_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Actions_Music_Playlists_ReadPlaylist_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this ReadPlaylist Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Music_Playlists_ReadPlaylist_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Actions_Music_Playlists_ReadPlaylist_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the ReadPlaylist Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Music_Playlists_ReadPlaylist_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the ReadPlaylist Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Music_Playlists_ReadPlaylist_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this ReadPlaylist input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Actions_Music_Playlists_ReadPlaylist_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Actions_Music_Playlists_ReadPlaylist_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this ReadPlaylist Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Actions_Music_Playlists_ReadPlaylist_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ActionID input for this ReadPlaylist Choreo.
     *
     * @param string $value (optional, string) The id of an action to retrieve. If an id is not provided, a list of all playlist actions will be returned.
     * @return Facebook_Actions_Music_Playlists_ReadPlaylist_Inputs For method chaining.
     */
    public function setActionID($value)
    {
        return $this->set('ActionID', $value);
    }

    /**
     * Set the value for the Fields input for this ReadPlaylist Choreo.
     *
     * @param string $value (optional, string) A comma separated list of fields to return (i.e. id,name).
     * @return Facebook_Actions_Music_Playlists_ReadPlaylist_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Limit input for this ReadPlaylist Choreo.
     *
     * @param int $value (optional, integer) Used to page through results. Limits the number of records returned in the response.
     * @return Facebook_Actions_Music_Playlists_ReadPlaylist_Inputs For method chaining.
     */
    public function setLimit($value)
    {
        return $this->set('Limit', $value);
    }

    /**
     * Set the value for the Offset input for this ReadPlaylist Choreo.
     *
     * @param int $value (optional, integer) Used to page through results. Returns results starting from the specified number.
     * @return Facebook_Actions_Music_Playlists_ReadPlaylist_Inputs For method chaining.
     */
    public function setOffset($value)
    {
        return $this->set('Offset', $value);
    }

    /**
     * Set the value for the ProfileID input for this ReadPlaylist Choreo.
     *
     * @param string $value (optional, string) The id of the user's profile. Defaults to "me" indicating the authenticated user.
     * @return Facebook_Actions_Music_Playlists_ReadPlaylist_Inputs For method chaining.
     */
    public function setProfileID($value)
    {
        return $this->set('ProfileID', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this ReadPlaylist Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Can be set to xml or json. Defaults to json.
     * @return Facebook_Actions_Music_Playlists_ReadPlaylist_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }
}


/**
 * Execution object for the ReadPlaylist Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Music_Playlists_ReadPlaylist_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the ReadPlaylist Choreo.
     *
     * @param Temboo_Session $session The session that owns this ReadPlaylist execution.
     * @param Facebook_Actions_Music_Playlists_ReadPlaylist $choreo The choreography object for this execution.
     * @param Facebook_Actions_Music_Playlists_ReadPlaylist_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Music_Playlists_ReadPlaylist_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Music_Playlists_ReadPlaylist_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Actions_Music_Playlists_ReadPlaylist $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this ReadPlaylist execution.
     *
     * @return Facebook_Actions_Music_Playlists_ReadPlaylist_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this ReadPlaylist execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Actions_Music_Playlists_ReadPlaylist_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Actions_Music_Playlists_ReadPlaylist_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the ReadPlaylist Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Music_Playlists_ReadPlaylist_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the ReadPlaylist Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Actions_Music_Playlists_ReadPlaylist_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "HasNext" output from this ReadPlaylist execution.
     *
     * @return bool (boolean) A boolean flag indicating that a next page exists.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getHasNext()
    {
        return $this->get('HasNext');
    }
    /**
     * Retrieve the value for the "HasPrevious" output from this ReadPlaylist execution.
     *
     * @return bool (boolean) A boolean flag indicating that a previous page exists.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getHasPrevious()
    {
        return $this->get('HasPrevious');
    }
    /**
     * Retrieve the value for the "Response" output from this ReadPlaylist execution.
     *
     * @return string The response from Facebook. Corresponds to the ResponseFormat input. Defaults to JSON.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Updates an existing playlist action.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Music_Playlists_UpdatePlaylist extends Temboo_Choreography
{
    /**
     * Updates an existing playlist action.
     *
     * @param Temboo_Session $session The session that owns this UpdatePlaylist Choreo.
     * @return Facebook_Actions_Music_Playlists_UpdatePlaylist New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Actions/Music/Playlists/UpdatePlaylist/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this UpdatePlaylist Choreo.
     *
     * @param Facebook_Actions_Music_Playlists_UpdatePlaylist_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Music_Playlists_UpdatePlaylist_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Music_Playlists_UpdatePlaylist_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Actions_Music_Playlists_UpdatePlaylist_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this UpdatePlaylist Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Music_Playlists_UpdatePlaylist_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Actions_Music_Playlists_UpdatePlaylist_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the UpdatePlaylist Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Music_Playlists_UpdatePlaylist_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the UpdatePlaylist Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Music_Playlists_UpdatePlaylist_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this UpdatePlaylist input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Actions_Music_Playlists_UpdatePlaylist_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Actions_Music_Playlists_UpdatePlaylist_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this UpdatePlaylist Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Actions_Music_Playlists_UpdatePlaylist_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ActionID input for this UpdatePlaylist Choreo.
     *
     * @param string $value (required, string) The id of the action to update.
     * @return Facebook_Actions_Music_Playlists_UpdatePlaylist_Inputs For method chaining.
     */
    public function setActionID($value)
    {
        return $this->set('ActionID', $value);
    }

    /**
     * Set the value for the EndTime input for this UpdatePlaylist Choreo.
     *
     * @param string $value (optional, date) The time that the user ended the action (e.g. 2013-06-24T18:53:35+0000).
     * @return Facebook_Actions_Music_Playlists_UpdatePlaylist_Inputs For method chaining.
     */
    public function setEndTime($value)
    {
        return $this->set('EndTime', $value);
    }

    /**
     * Set the value for the ExpiresIn input for this UpdatePlaylist Choreo.
     *
     * @param int $value (optional, integer) The amount of time (in milliseconds) from the publish_time that the action will expire.
     * @return Facebook_Actions_Music_Playlists_UpdatePlaylist_Inputs For method chaining.
     */
    public function setExpiresIn($value)
    {
        return $this->set('ExpiresIn', $value);
    }

    /**
     * Set the value for the Message input for this UpdatePlaylist Choreo.
     *
     * @param string $value (optional, string) A message attached to this fitness action. Setting this parameter requires enabling of message capabilities.
     * @return Facebook_Actions_Music_Playlists_UpdatePlaylist_Inputs For method chaining.
     */
    public function setMessage($value)
    {
        return $this->set('Message', $value);
    }

    /**
     * Set the value for the Place input for this UpdatePlaylist Choreo.
     *
     * @param string $value (optional, string) The URL or ID for an Open Graph object representing the location associated with this action.
     * @return Facebook_Actions_Music_Playlists_UpdatePlaylist_Inputs For method chaining.
     */
    public function setPlace($value)
    {
        return $this->set('Place', $value);
    }

    /**
     * Set the value for the PlayList input for this UpdatePlaylist Choreo.
     *
     * @param string $value (optional, string) An object representing a playlist
     * @return Facebook_Actions_Music_Playlists_UpdatePlaylist_Inputs For method chaining.
     */
    public function setPlayList($value)
    {
        return $this->set('PlayList', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this UpdatePlaylist Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Can be set to xml or json. Defaults to json.
     * @return Facebook_Actions_Music_Playlists_UpdatePlaylist_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }

    /**
     * Set the value for the Tags input for this UpdatePlaylist Choreo.
     *
     * @param string $value (optional, string) A comma separated list of other profile IDs that also performed this action.
     * @return Facebook_Actions_Music_Playlists_UpdatePlaylist_Inputs For method chaining.
     */
    public function setTags($value)
    {
        return $this->set('Tags', $value);
    }
}


/**
 * Execution object for the UpdatePlaylist Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Music_Playlists_UpdatePlaylist_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the UpdatePlaylist Choreo.
     *
     * @param Temboo_Session $session The session that owns this UpdatePlaylist execution.
     * @param Facebook_Actions_Music_Playlists_UpdatePlaylist $choreo The choreography object for this execution.
     * @param Facebook_Actions_Music_Playlists_UpdatePlaylist_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Music_Playlists_UpdatePlaylist_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Music_Playlists_UpdatePlaylist_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Actions_Music_Playlists_UpdatePlaylist $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this UpdatePlaylist execution.
     *
     * @return Facebook_Actions_Music_Playlists_UpdatePlaylist_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this UpdatePlaylist execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Actions_Music_Playlists_UpdatePlaylist_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Actions_Music_Playlists_UpdatePlaylist_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the UpdatePlaylist Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Music_Playlists_UpdatePlaylist_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the UpdatePlaylist Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Actions_Music_Playlists_UpdatePlaylist_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this UpdatePlaylist execution.
     *
     * @return string The response from Facebook. Corresponds to the ResponseFormat input. Defaults to JSON.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Creates an action that represents a user publishing a news article.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_News_Publishes_CreatePublication extends Temboo_Choreography
{
    /**
     * Creates an action that represents a user publishing a news article.
     *
     * @param Temboo_Session $session The session that owns this CreatePublication Choreo.
     * @return Facebook_Actions_News_Publishes_CreatePublication New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Actions/News/Publishes/CreatePublication/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this CreatePublication Choreo.
     *
     * @param Facebook_Actions_News_Publishes_CreatePublication_Inputs|array $inputs (optional) Inputs as Facebook_Actions_News_Publishes_CreatePublication_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_News_Publishes_CreatePublication_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Actions_News_Publishes_CreatePublication_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this CreatePublication Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_News_Publishes_CreatePublication_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Actions_News_Publishes_CreatePublication_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the CreatePublication Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_News_Publishes_CreatePublication_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the CreatePublication Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_News_Publishes_CreatePublication_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this CreatePublication input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Actions_News_Publishes_CreatePublication_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Actions_News_Publishes_CreatePublication_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this CreatePublication Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Actions_News_Publishes_CreatePublication_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the Article input for this CreatePublication Choreo.
     *
     * @param string $value (required, string) The URL or ID for an Open Graph object representing the article.
     * @return Facebook_Actions_News_Publishes_CreatePublication_Inputs For method chaining.
     */
    public function setArticle($value)
    {
        return $this->set('Article', $value);
    }

    /**
     * Set the value for the CreatedTime input for this CreatePublication Choreo.
     *
     * @param string $value (optional, date) The time that the action was created (e.g. 2013-06-24T18:53:35+0000).
     * @return Facebook_Actions_News_Publishes_CreatePublication_Inputs For method chaining.
     */
    public function setCreatedTime($value)
    {
        return $this->set('CreatedTime', $value);
    }

    /**
     * Set the value for the EndTime input for this CreatePublication Choreo.
     *
     * @param string $value (optional, date) The time that the user ended the action (e.g. 2013-06-24T18:53:35+0000).
     * @return Facebook_Actions_News_Publishes_CreatePublication_Inputs For method chaining.
     */
    public function setEndTime($value)
    {
        return $this->set('EndTime', $value);
    }

    /**
     * Set the value for the ExpiresIn input for this CreatePublication Choreo.
     *
     * @param int $value (optional, integer) The amount of time (in milliseconds) from the publish_time that the action will expire.
     * @return Facebook_Actions_News_Publishes_CreatePublication_Inputs For method chaining.
     */
    public function setExpiresIn($value)
    {
        return $this->set('ExpiresIn', $value);
    }

    /**
     * Set the value for the ExplicitlyShared input for this CreatePublication Choreo.
     *
     * @param bool $value (optional, boolean) Indicates that the user is explicitly sharing this action. Requires the explicitly_shared capability to be enabled.
     * @return Facebook_Actions_News_Publishes_CreatePublication_Inputs For method chaining.
     */
    public function setExplicitlyShared($value)
    {
        return $this->set('ExplicitlyShared', $value);
    }

    /**
     * Set the value for the ExplicityShared input for this CreatePublication Choreo.
     *
     * @param bool $value (optional, boolean) Deprecated (retained for backward compatibility only).
     * @return Facebook_Actions_News_Publishes_CreatePublication_Inputs For method chaining.
     */
    public function setExplicityShared($value)
    {
        return $this->set('ExplicityShared', $value);
    }

    /**
     * Set the value for the Message input for this CreatePublication Choreo.
     *
     * @param string $value (optional, string) A message attached to this action. Setting this parameter requires enabling of message capabilities.
     * @return Facebook_Actions_News_Publishes_CreatePublication_Inputs For method chaining.
     */
    public function setMessage($value)
    {
        return $this->set('Message', $value);
    }

    /**
     * Set the value for the NoFeedStory input for this CreatePublication Choreo.
     *
     * @param bool $value (optional, boolean) Whether or not this action should be posted to the users feed.
     * @return Facebook_Actions_News_Publishes_CreatePublication_Inputs For method chaining.
     */
    public function setNoFeedStory($value)
    {
        return $this->set('NoFeedStory', $value);
    }

    /**
     * Set the value for the Place input for this CreatePublication Choreo.
     *
     * @param string $value (optional, string) The URL or ID for an Open Graph object representing the location associated with this action.
     * @return Facebook_Actions_News_Publishes_CreatePublication_Inputs For method chaining.
     */
    public function setPlace($value)
    {
        return $this->set('Place', $value);
    }

    /**
     * Set the value for the ProfileID input for this CreatePublication Choreo.
     *
     * @param string $value (optional, string) The id of the user's profile. Defaults to "me" indicating the authenticated user.
     * @return Facebook_Actions_News_Publishes_CreatePublication_Inputs For method chaining.
     */
    public function setProfileID($value)
    {
        return $this->set('ProfileID', $value);
    }

    /**
     * Set the value for the Reference input for this CreatePublication Choreo.
     *
     * @param string $value (optional, string) A string identifier up to 50 characters used for tracking and insights.
     * @return Facebook_Actions_News_Publishes_CreatePublication_Inputs For method chaining.
     */
    public function setReference($value)
    {
        return $this->set('Reference', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this CreatePublication Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Can be set to xml or json. Defaults to json.
     * @return Facebook_Actions_News_Publishes_CreatePublication_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }

    /**
     * Set the value for the StartTime input for this CreatePublication Choreo.
     *
     * @param string $value (optional, date) The time that the user started the action (e.g. 2013-06-24T18:53:35+0000).
     * @return Facebook_Actions_News_Publishes_CreatePublication_Inputs For method chaining.
     */
    public function setStartTime($value)
    {
        return $this->set('StartTime', $value);
    }

    /**
     * Set the value for the Tags input for this CreatePublication Choreo.
     *
     * @param string $value (optional, string) A comma separated list of other profile IDs that also performed this action.
     * @return Facebook_Actions_News_Publishes_CreatePublication_Inputs For method chaining.
     */
    public function setTags($value)
    {
        return $this->set('Tags', $value);
    }
}


/**
 * Execution object for the CreatePublication Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_News_Publishes_CreatePublication_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the CreatePublication Choreo.
     *
     * @param Temboo_Session $session The session that owns this CreatePublication execution.
     * @param Facebook_Actions_News_Publishes_CreatePublication $choreo The choreography object for this execution.
     * @param Facebook_Actions_News_Publishes_CreatePublication_Inputs|array $inputs (optional) Inputs as Facebook_Actions_News_Publishes_CreatePublication_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_News_Publishes_CreatePublication_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Actions_News_Publishes_CreatePublication $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this CreatePublication execution.
     *
     * @return Facebook_Actions_News_Publishes_CreatePublication_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this CreatePublication execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Actions_News_Publishes_CreatePublication_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Actions_News_Publishes_CreatePublication_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the CreatePublication Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_News_Publishes_CreatePublication_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the CreatePublication Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Actions_News_Publishes_CreatePublication_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "ActivityURL" output from this CreatePublication execution.
     *
     * @return string (string) The URL for the newly created action.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getActivityURL()
    {
        return $this->get('ActivityURL');
    }
    /**
     * Retrieve the value for the "Response" output from this CreatePublication execution.
     *
     * @return string The response from Facebook.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Deletes a given news publishing action.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_News_Publishes_DeletePublication extends Temboo_Choreography
{
    /**
     * Deletes a given news publishing action.
     *
     * @param Temboo_Session $session The session that owns this DeletePublication Choreo.
     * @return Facebook_Actions_News_Publishes_DeletePublication New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Actions/News/Publishes/DeletePublication/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this DeletePublication Choreo.
     *
     * @param Facebook_Actions_News_Publishes_DeletePublication_Inputs|array $inputs (optional) Inputs as Facebook_Actions_News_Publishes_DeletePublication_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_News_Publishes_DeletePublication_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Actions_News_Publishes_DeletePublication_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this DeletePublication Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_News_Publishes_DeletePublication_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Actions_News_Publishes_DeletePublication_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the DeletePublication Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_News_Publishes_DeletePublication_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the DeletePublication Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_News_Publishes_DeletePublication_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this DeletePublication input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Actions_News_Publishes_DeletePublication_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Actions_News_Publishes_DeletePublication_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this DeletePublication Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Actions_News_Publishes_DeletePublication_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ActionID input for this DeletePublication Choreo.
     *
     * @param string $value (required, string) The id of an action to delete.
     * @return Facebook_Actions_News_Publishes_DeletePublication_Inputs For method chaining.
     */
    public function setActionID($value)
    {
        return $this->set('ActionID', $value);
    }
}


/**
 * Execution object for the DeletePublication Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_News_Publishes_DeletePublication_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the DeletePublication Choreo.
     *
     * @param Temboo_Session $session The session that owns this DeletePublication execution.
     * @param Facebook_Actions_News_Publishes_DeletePublication $choreo The choreography object for this execution.
     * @param Facebook_Actions_News_Publishes_DeletePublication_Inputs|array $inputs (optional) Inputs as Facebook_Actions_News_Publishes_DeletePublication_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_News_Publishes_DeletePublication_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Actions_News_Publishes_DeletePublication $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this DeletePublication execution.
     *
     * @return Facebook_Actions_News_Publishes_DeletePublication_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this DeletePublication execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Actions_News_Publishes_DeletePublication_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Actions_News_Publishes_DeletePublication_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the DeletePublication Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_News_Publishes_DeletePublication_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the DeletePublication Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Actions_News_Publishes_DeletePublication_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this DeletePublication execution.
     *
     * @return bool (boolean) The response from Facebook. Returns "true" on success.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Retrieves one or more news publishing actions.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_News_Publishes_ReadPublications extends Temboo_Choreography
{
    /**
     * Retrieves one or more news publishing actions.
     *
     * @param Temboo_Session $session The session that owns this ReadPublications Choreo.
     * @return Facebook_Actions_News_Publishes_ReadPublications New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Actions/News/Publishes/ReadPublications/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this ReadPublications Choreo.
     *
     * @param Facebook_Actions_News_Publishes_ReadPublications_Inputs|array $inputs (optional) Inputs as Facebook_Actions_News_Publishes_ReadPublications_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_News_Publishes_ReadPublications_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Actions_News_Publishes_ReadPublications_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this ReadPublications Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_News_Publishes_ReadPublications_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Actions_News_Publishes_ReadPublications_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the ReadPublications Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_News_Publishes_ReadPublications_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the ReadPublications Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_News_Publishes_ReadPublications_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this ReadPublications input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Actions_News_Publishes_ReadPublications_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Actions_News_Publishes_ReadPublications_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this ReadPublications Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Actions_News_Publishes_ReadPublications_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ActionID input for this ReadPublications Choreo.
     *
     * @param string $value (optional, string) The id of an action to retrieve. If an id is not provided, a list of all publishing actions will be returned.
     * @return Facebook_Actions_News_Publishes_ReadPublications_Inputs For method chaining.
     */
    public function setActionID($value)
    {
        return $this->set('ActionID', $value);
    }

    /**
     * Set the value for the Fields input for this ReadPublications Choreo.
     *
     * @param string $value (optional, string) A comma separated list of fields to return (i.e. id,name).
     * @return Facebook_Actions_News_Publishes_ReadPublications_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Limit input for this ReadPublications Choreo.
     *
     * @param int $value (optional, integer) Used to page through results. Limits the number of records returned in the response.
     * @return Facebook_Actions_News_Publishes_ReadPublications_Inputs For method chaining.
     */
    public function setLimit($value)
    {
        return $this->set('Limit', $value);
    }

    /**
     * Set the value for the Offset input for this ReadPublications Choreo.
     *
     * @param int $value (optional, integer) Used to page through results. Returns results starting from the specified number.
     * @return Facebook_Actions_News_Publishes_ReadPublications_Inputs For method chaining.
     */
    public function setOffset($value)
    {
        return $this->set('Offset', $value);
    }

    /**
     * Set the value for the ProfileID input for this ReadPublications Choreo.
     *
     * @param string $value (optional, string) The id of the user's profile. Defaults to "me" indicating the authenticated user.
     * @return Facebook_Actions_News_Publishes_ReadPublications_Inputs For method chaining.
     */
    public function setProfileID($value)
    {
        return $this->set('ProfileID', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this ReadPublications Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Can be set to xml or json. Defaults to json.
     * @return Facebook_Actions_News_Publishes_ReadPublications_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }
}


/**
 * Execution object for the ReadPublications Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_News_Publishes_ReadPublications_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the ReadPublications Choreo.
     *
     * @param Temboo_Session $session The session that owns this ReadPublications execution.
     * @param Facebook_Actions_News_Publishes_ReadPublications $choreo The choreography object for this execution.
     * @param Facebook_Actions_News_Publishes_ReadPublications_Inputs|array $inputs (optional) Inputs as Facebook_Actions_News_Publishes_ReadPublications_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_News_Publishes_ReadPublications_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Actions_News_Publishes_ReadPublications $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this ReadPublications execution.
     *
     * @return Facebook_Actions_News_Publishes_ReadPublications_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this ReadPublications execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Actions_News_Publishes_ReadPublications_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Actions_News_Publishes_ReadPublications_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the ReadPublications Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_News_Publishes_ReadPublications_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the ReadPublications Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Actions_News_Publishes_ReadPublications_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "HasNext" output from this ReadPublications execution.
     *
     * @return bool (boolean) A boolean flag indicating that a next page exists.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getHasNext()
    {
        return $this->get('HasNext');
    }
    /**
     * Retrieve the value for the "HasPrevious" output from this ReadPublications execution.
     *
     * @return bool (boolean) A boolean flag indicating that a previous page exists.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getHasPrevious()
    {
        return $this->get('HasPrevious');
    }
    /**
     * Retrieve the value for the "Response" output from this ReadPublications execution.
     *
     * @return string The response from Facebook. Corresponds to the ResponseFormat input. Defaults to JSON.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Updates an existing news publishing action.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_News_Publishes_UpdatePublication extends Temboo_Choreography
{
    /**
     * Updates an existing news publishing action.
     *
     * @param Temboo_Session $session The session that owns this UpdatePublication Choreo.
     * @return Facebook_Actions_News_Publishes_UpdatePublication New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Actions/News/Publishes/UpdatePublication/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this UpdatePublication Choreo.
     *
     * @param Facebook_Actions_News_Publishes_UpdatePublication_Inputs|array $inputs (optional) Inputs as Facebook_Actions_News_Publishes_UpdatePublication_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_News_Publishes_UpdatePublication_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Actions_News_Publishes_UpdatePublication_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this UpdatePublication Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_News_Publishes_UpdatePublication_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Actions_News_Publishes_UpdatePublication_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the UpdatePublication Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_News_Publishes_UpdatePublication_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the UpdatePublication Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_News_Publishes_UpdatePublication_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this UpdatePublication input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Actions_News_Publishes_UpdatePublication_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Actions_News_Publishes_UpdatePublication_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this UpdatePublication Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Actions_News_Publishes_UpdatePublication_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ActionID input for this UpdatePublication Choreo.
     *
     * @param string $value (required, string) The id of the action to update.
     * @return Facebook_Actions_News_Publishes_UpdatePublication_Inputs For method chaining.
     */
    public function setActionID($value)
    {
        return $this->set('ActionID', $value);
    }

    /**
     * Set the value for the Article input for this UpdatePublication Choreo.
     *
     * @param string $value (optional, string) The URL or ID for an Open Graph object representing the article.
     * @return Facebook_Actions_News_Publishes_UpdatePublication_Inputs For method chaining.
     */
    public function setArticle($value)
    {
        return $this->set('Article', $value);
    }

    /**
     * Set the value for the EndTime input for this UpdatePublication Choreo.
     *
     * @param string $value (optional, date) The time that the user ended the action (e.g. 2013-06-24T18:53:35+0000).
     * @return Facebook_Actions_News_Publishes_UpdatePublication_Inputs For method chaining.
     */
    public function setEndTime($value)
    {
        return $this->set('EndTime', $value);
    }

    /**
     * Set the value for the ExpiresIn input for this UpdatePublication Choreo.
     *
     * @param int $value (optional, integer) The amount of time (in milliseconds) from the publish_time that the action will expire.
     * @return Facebook_Actions_News_Publishes_UpdatePublication_Inputs For method chaining.
     */
    public function setExpiresIn($value)
    {
        return $this->set('ExpiresIn', $value);
    }

    /**
     * Set the value for the Message input for this UpdatePublication Choreo.
     *
     * @param string $value (optional, string) A message attached to this action. Setting this parameter requires enabling of message capabilities.
     * @return Facebook_Actions_News_Publishes_UpdatePublication_Inputs For method chaining.
     */
    public function setMessage($value)
    {
        return $this->set('Message', $value);
    }

    /**
     * Set the value for the Place input for this UpdatePublication Choreo.
     *
     * @param string $value (optional, string) The URL or ID for an Open Graph object representing the location associated with this action.
     * @return Facebook_Actions_News_Publishes_UpdatePublication_Inputs For method chaining.
     */
    public function setPlace($value)
    {
        return $this->set('Place', $value);
    }

    /**
     * Set the value for the Tags input for this UpdatePublication Choreo.
     *
     * @param string $value (optional, string) A comma separated list of other profile IDs that also performed this action.
     * @return Facebook_Actions_News_Publishes_UpdatePublication_Inputs For method chaining.
     */
    public function setTags($value)
    {
        return $this->set('Tags', $value);
    }
}


/**
 * Execution object for the UpdatePublication Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_News_Publishes_UpdatePublication_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the UpdatePublication Choreo.
     *
     * @param Temboo_Session $session The session that owns this UpdatePublication execution.
     * @param Facebook_Actions_News_Publishes_UpdatePublication $choreo The choreography object for this execution.
     * @param Facebook_Actions_News_Publishes_UpdatePublication_Inputs|array $inputs (optional) Inputs as Facebook_Actions_News_Publishes_UpdatePublication_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_News_Publishes_UpdatePublication_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Actions_News_Publishes_UpdatePublication $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this UpdatePublication execution.
     *
     * @return Facebook_Actions_News_Publishes_UpdatePublication_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this UpdatePublication execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Actions_News_Publishes_UpdatePublication_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Actions_News_Publishes_UpdatePublication_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the UpdatePublication Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_News_Publishes_UpdatePublication_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the UpdatePublication Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Actions_News_Publishes_UpdatePublication_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this UpdatePublication execution.
     *
     * @return string The response from Facebook.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Creates an action that represents a user reading a news article.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_News_Reads_CreateReading extends Temboo_Choreography
{
    /**
     * Creates an action that represents a user reading a news article.
     *
     * @param Temboo_Session $session The session that owns this CreateReading Choreo.
     * @return Facebook_Actions_News_Reads_CreateReading New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Actions/News/Reads/CreateReading/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this CreateReading Choreo.
     *
     * @param Facebook_Actions_News_Reads_CreateReading_Inputs|array $inputs (optional) Inputs as Facebook_Actions_News_Reads_CreateReading_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_News_Reads_CreateReading_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Actions_News_Reads_CreateReading_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this CreateReading Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_News_Reads_CreateReading_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Actions_News_Reads_CreateReading_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the CreateReading Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_News_Reads_CreateReading_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the CreateReading Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_News_Reads_CreateReading_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this CreateReading input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Actions_News_Reads_CreateReading_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Actions_News_Reads_CreateReading_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this CreateReading Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Actions_News_Reads_CreateReading_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the Article input for this CreateReading Choreo.
     *
     * @param string $value (required, string) The URL or ID for an Open Graph object representing the article.
     * @return Facebook_Actions_News_Reads_CreateReading_Inputs For method chaining.
     */
    public function setArticle($value)
    {
        return $this->set('Article', $value);
    }

    /**
     * Set the value for the CreatedTime input for this CreateReading Choreo.
     *
     * @param string $value (optional, date) The time that the action was created (e.g. 2013-06-24T18:53:35+0000).
     * @return Facebook_Actions_News_Reads_CreateReading_Inputs For method chaining.
     */
    public function setCreatedTime($value)
    {
        return $this->set('CreatedTime', $value);
    }

    /**
     * Set the value for the EndTime input for this CreateReading Choreo.
     *
     * @param string $value (optional, date) The time that the user ended the action (e.g. 2013-06-24T18:53:35+0000).
     * @return Facebook_Actions_News_Reads_CreateReading_Inputs For method chaining.
     */
    public function setEndTime($value)
    {
        return $this->set('EndTime', $value);
    }

    /**
     * Set the value for the ExpiresIn input for this CreateReading Choreo.
     *
     * @param int $value (optional, integer) The amount of time (in milliseconds) from the publish_time that the action will expire.
     * @return Facebook_Actions_News_Reads_CreateReading_Inputs For method chaining.
     */
    public function setExpiresIn($value)
    {
        return $this->set('ExpiresIn', $value);
    }

    /**
     * Set the value for the ExplicitlyShared input for this CreateReading Choreo.
     *
     * @param bool $value (optional, boolean) Indicates that the user is explicitly sharing this action. Requires the explicitly_shared capability to be enabled.
     * @return Facebook_Actions_News_Reads_CreateReading_Inputs For method chaining.
     */
    public function setExplicitlyShared($value)
    {
        return $this->set('ExplicitlyShared', $value);
    }

    /**
     * Set the value for the ExplicityShared input for this CreateReading Choreo.
     *
     * @param bool $value (optional, boolean) Deprecated (retained for backward compatibility only).
     * @return Facebook_Actions_News_Reads_CreateReading_Inputs For method chaining.
     */
    public function setExplicityShared($value)
    {
        return $this->set('ExplicityShared', $value);
    }

    /**
     * Set the value for the Message input for this CreateReading Choreo.
     *
     * @param string $value (optional, string) A message attached to this action. Setting this parameter requires enabling of message capabilities.
     * @return Facebook_Actions_News_Reads_CreateReading_Inputs For method chaining.
     */
    public function setMessage($value)
    {
        return $this->set('Message', $value);
    }

    /**
     * Set the value for the NoFeedStory input for this CreateReading Choreo.
     *
     * @param bool $value (optional, boolean) Whether or not this action should be posted to the users feed.
     * @return Facebook_Actions_News_Reads_CreateReading_Inputs For method chaining.
     */
    public function setNoFeedStory($value)
    {
        return $this->set('NoFeedStory', $value);
    }

    /**
     * Set the value for the Place input for this CreateReading Choreo.
     *
     * @param string $value (optional, string) The URL or ID for an Open Graph object representing the location associated with this action.
     * @return Facebook_Actions_News_Reads_CreateReading_Inputs For method chaining.
     */
    public function setPlace($value)
    {
        return $this->set('Place', $value);
    }

    /**
     * Set the value for the ProfileID input for this CreateReading Choreo.
     *
     * @param string $value (optional, string) The id of the user's profile. Defaults to "me" indicating the authenticated user.
     * @return Facebook_Actions_News_Reads_CreateReading_Inputs For method chaining.
     */
    public function setProfileID($value)
    {
        return $this->set('ProfileID', $value);
    }

    /**
     * Set the value for the Reference input for this CreateReading Choreo.
     *
     * @param string $value (optional, string) A string identifier up to 50 characters used for tracking and insights.
     * @return Facebook_Actions_News_Reads_CreateReading_Inputs For method chaining.
     */
    public function setReference($value)
    {
        return $this->set('Reference', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this CreateReading Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Can be set to xml or json. Defaults to json.
     * @return Facebook_Actions_News_Reads_CreateReading_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }

    /**
     * Set the value for the StartTime input for this CreateReading Choreo.
     *
     * @param string $value (optional, date) The time that the user started the action (e.g. 2013-06-24T18:53:35+0000).
     * @return Facebook_Actions_News_Reads_CreateReading_Inputs For method chaining.
     */
    public function setStartTime($value)
    {
        return $this->set('StartTime', $value);
    }

    /**
     * Set the value for the Tags input for this CreateReading Choreo.
     *
     * @param string $value (optional, string) A comma separated list of other profile IDs that also performed this action.
     * @return Facebook_Actions_News_Reads_CreateReading_Inputs For method chaining.
     */
    public function setTags($value)
    {
        return $this->set('Tags', $value);
    }
}


/**
 * Execution object for the CreateReading Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_News_Reads_CreateReading_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the CreateReading Choreo.
     *
     * @param Temboo_Session $session The session that owns this CreateReading execution.
     * @param Facebook_Actions_News_Reads_CreateReading $choreo The choreography object for this execution.
     * @param Facebook_Actions_News_Reads_CreateReading_Inputs|array $inputs (optional) Inputs as Facebook_Actions_News_Reads_CreateReading_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_News_Reads_CreateReading_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Actions_News_Reads_CreateReading $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this CreateReading execution.
     *
     * @return Facebook_Actions_News_Reads_CreateReading_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this CreateReading execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Actions_News_Reads_CreateReading_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Actions_News_Reads_CreateReading_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the CreateReading Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_News_Reads_CreateReading_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the CreateReading Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Actions_News_Reads_CreateReading_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "ActivityURL" output from this CreateReading execution.
     *
     * @return string (string) The URL for the newly created action.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getActivityURL()
    {
        return $this->get('ActivityURL');
    }
    /**
     * Retrieve the value for the "Response" output from this CreateReading execution.
     *
     * @return string The response from Facebook.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Deletes a given news reading action.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_News_Reads_DeleteReading extends Temboo_Choreography
{
    /**
     * Deletes a given news reading action.
     *
     * @param Temboo_Session $session The session that owns this DeleteReading Choreo.
     * @return Facebook_Actions_News_Reads_DeleteReading New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Actions/News/Reads/DeleteReading/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this DeleteReading Choreo.
     *
     * @param Facebook_Actions_News_Reads_DeleteReading_Inputs|array $inputs (optional) Inputs as Facebook_Actions_News_Reads_DeleteReading_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_News_Reads_DeleteReading_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Actions_News_Reads_DeleteReading_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this DeleteReading Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_News_Reads_DeleteReading_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Actions_News_Reads_DeleteReading_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the DeleteReading Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_News_Reads_DeleteReading_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the DeleteReading Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_News_Reads_DeleteReading_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this DeleteReading input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Actions_News_Reads_DeleteReading_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Actions_News_Reads_DeleteReading_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this DeleteReading Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Actions_News_Reads_DeleteReading_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ActionID input for this DeleteReading Choreo.
     *
     * @param string $value (required, string) The id of an action to delete.
     * @return Facebook_Actions_News_Reads_DeleteReading_Inputs For method chaining.
     */
    public function setActionID($value)
    {
        return $this->set('ActionID', $value);
    }
}


/**
 * Execution object for the DeleteReading Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_News_Reads_DeleteReading_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the DeleteReading Choreo.
     *
     * @param Temboo_Session $session The session that owns this DeleteReading execution.
     * @param Facebook_Actions_News_Reads_DeleteReading $choreo The choreography object for this execution.
     * @param Facebook_Actions_News_Reads_DeleteReading_Inputs|array $inputs (optional) Inputs as Facebook_Actions_News_Reads_DeleteReading_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_News_Reads_DeleteReading_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Actions_News_Reads_DeleteReading $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this DeleteReading execution.
     *
     * @return Facebook_Actions_News_Reads_DeleteReading_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this DeleteReading execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Actions_News_Reads_DeleteReading_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Actions_News_Reads_DeleteReading_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the DeleteReading Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_News_Reads_DeleteReading_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the DeleteReading Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Actions_News_Reads_DeleteReading_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this DeleteReading execution.
     *
     * @return bool (boolean) The response from Facebook. Returns "true" on success.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Retrieves one or more news reading actions.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_News_Reads_ReadReadings extends Temboo_Choreography
{
    /**
     * Retrieves one or more news reading actions.
     *
     * @param Temboo_Session $session The session that owns this ReadReadings Choreo.
     * @return Facebook_Actions_News_Reads_ReadReadings New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Actions/News/Reads/ReadReadings/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this ReadReadings Choreo.
     *
     * @param Facebook_Actions_News_Reads_ReadReadings_Inputs|array $inputs (optional) Inputs as Facebook_Actions_News_Reads_ReadReadings_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_News_Reads_ReadReadings_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Actions_News_Reads_ReadReadings_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this ReadReadings Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_News_Reads_ReadReadings_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Actions_News_Reads_ReadReadings_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the ReadReadings Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_News_Reads_ReadReadings_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the ReadReadings Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_News_Reads_ReadReadings_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this ReadReadings input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Actions_News_Reads_ReadReadings_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Actions_News_Reads_ReadReadings_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this ReadReadings Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Actions_News_Reads_ReadReadings_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ActionID input for this ReadReadings Choreo.
     *
     * @param string $value (optional, string) The id of an action to retrieve. If an id is not provided, a list of all reading actions will be returned.
     * @return Facebook_Actions_News_Reads_ReadReadings_Inputs For method chaining.
     */
    public function setActionID($value)
    {
        return $this->set('ActionID', $value);
    }

    /**
     * Set the value for the Fields input for this ReadReadings Choreo.
     *
     * @param string $value (optional, string) A comma separated list of fields to return (i.e. id,name).
     * @return Facebook_Actions_News_Reads_ReadReadings_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Limit input for this ReadReadings Choreo.
     *
     * @param int $value (optional, integer) Used to page through results. Limits the number of records returned in the response.
     * @return Facebook_Actions_News_Reads_ReadReadings_Inputs For method chaining.
     */
    public function setLimit($value)
    {
        return $this->set('Limit', $value);
    }

    /**
     * Set the value for the Offset input for this ReadReadings Choreo.
     *
     * @param int $value (optional, integer) Used to page through results. Returns results starting from the specified number.
     * @return Facebook_Actions_News_Reads_ReadReadings_Inputs For method chaining.
     */
    public function setOffset($value)
    {
        return $this->set('Offset', $value);
    }

    /**
     * Set the value for the ProfileID input for this ReadReadings Choreo.
     *
     * @param string $value (optional, string) The id of the user's profile. Defaults to "me" indicating the authenticated user.
     * @return Facebook_Actions_News_Reads_ReadReadings_Inputs For method chaining.
     */
    public function setProfileID($value)
    {
        return $this->set('ProfileID', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this ReadReadings Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Can be set to xml or json. Defaults to json.
     * @return Facebook_Actions_News_Reads_ReadReadings_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }
}


/**
 * Execution object for the ReadReadings Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_News_Reads_ReadReadings_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the ReadReadings Choreo.
     *
     * @param Temboo_Session $session The session that owns this ReadReadings execution.
     * @param Facebook_Actions_News_Reads_ReadReadings $choreo The choreography object for this execution.
     * @param Facebook_Actions_News_Reads_ReadReadings_Inputs|array $inputs (optional) Inputs as Facebook_Actions_News_Reads_ReadReadings_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_News_Reads_ReadReadings_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Actions_News_Reads_ReadReadings $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this ReadReadings execution.
     *
     * @return Facebook_Actions_News_Reads_ReadReadings_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this ReadReadings execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Actions_News_Reads_ReadReadings_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Actions_News_Reads_ReadReadings_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the ReadReadings Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_News_Reads_ReadReadings_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the ReadReadings Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Actions_News_Reads_ReadReadings_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "HasNext" output from this ReadReadings execution.
     *
     * @return bool (boolean) A boolean flag indicating that a next page exists.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getHasNext()
    {
        return $this->get('HasNext');
    }
    /**
     * Retrieve the value for the "HasPrevious" output from this ReadReadings execution.
     *
     * @return bool (boolean) A boolean flag indicating that a previous page exists.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getHasPrevious()
    {
        return $this->get('HasPrevious');
    }
    /**
     * Retrieve the value for the "Response" output from this ReadReadings execution.
     *
     * @return string The response from Facebook. Corresponds to the ResponseFormat input. Defaults to JSON.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Updates an existing news reading action.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_News_Reads_UpdateReading extends Temboo_Choreography
{
    /**
     * Updates an existing news reading action.
     *
     * @param Temboo_Session $session The session that owns this UpdateReading Choreo.
     * @return Facebook_Actions_News_Reads_UpdateReading New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Actions/News/Reads/UpdateReading/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this UpdateReading Choreo.
     *
     * @param Facebook_Actions_News_Reads_UpdateReading_Inputs|array $inputs (optional) Inputs as Facebook_Actions_News_Reads_UpdateReading_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_News_Reads_UpdateReading_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Actions_News_Reads_UpdateReading_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this UpdateReading Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_News_Reads_UpdateReading_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Actions_News_Reads_UpdateReading_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the UpdateReading Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_News_Reads_UpdateReading_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the UpdateReading Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_News_Reads_UpdateReading_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this UpdateReading input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Actions_News_Reads_UpdateReading_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Actions_News_Reads_UpdateReading_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this UpdateReading Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Actions_News_Reads_UpdateReading_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ActionID input for this UpdateReading Choreo.
     *
     * @param string $value (required, string) The id of the action to update.
     * @return Facebook_Actions_News_Reads_UpdateReading_Inputs For method chaining.
     */
    public function setActionID($value)
    {
        return $this->set('ActionID', $value);
    }

    /**
     * Set the value for the Article input for this UpdateReading Choreo.
     *
     * @param string $value (optional, string) The URL or ID for an Open Graph object representing the article.
     * @return Facebook_Actions_News_Reads_UpdateReading_Inputs For method chaining.
     */
    public function setArticle($value)
    {
        return $this->set('Article', $value);
    }

    /**
     * Set the value for the EndTime input for this UpdateReading Choreo.
     *
     * @param string $value (optional, date) The time that the user ended the action (e.g. 2013-06-24T18:53:35+0000).
     * @return Facebook_Actions_News_Reads_UpdateReading_Inputs For method chaining.
     */
    public function setEndTime($value)
    {
        return $this->set('EndTime', $value);
    }

    /**
     * Set the value for the ExpiresIn input for this UpdateReading Choreo.
     *
     * @param int $value (optional, integer) The amount of time (in milliseconds) from the publish_time that the action will expire.
     * @return Facebook_Actions_News_Reads_UpdateReading_Inputs For method chaining.
     */
    public function setExpiresIn($value)
    {
        return $this->set('ExpiresIn', $value);
    }

    /**
     * Set the value for the Message input for this UpdateReading Choreo.
     *
     * @param string $value (optional, string) A message attached to this action. Setting this parameter requires enabling of message capabilities.
     * @return Facebook_Actions_News_Reads_UpdateReading_Inputs For method chaining.
     */
    public function setMessage($value)
    {
        return $this->set('Message', $value);
    }

    /**
     * Set the value for the Place input for this UpdateReading Choreo.
     *
     * @param string $value (optional, string) The URL or ID for an Open Graph object representing the location associated with this action.
     * @return Facebook_Actions_News_Reads_UpdateReading_Inputs For method chaining.
     */
    public function setPlace($value)
    {
        return $this->set('Place', $value);
    }

    /**
     * Set the value for the Tags input for this UpdateReading Choreo.
     *
     * @param string $value (optional, string) A comma separated list of other profile IDs that also performed this action.
     * @return Facebook_Actions_News_Reads_UpdateReading_Inputs For method chaining.
     */
    public function setTags($value)
    {
        return $this->set('Tags', $value);
    }
}


/**
 * Execution object for the UpdateReading Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_News_Reads_UpdateReading_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the UpdateReading Choreo.
     *
     * @param Temboo_Session $session The session that owns this UpdateReading execution.
     * @param Facebook_Actions_News_Reads_UpdateReading $choreo The choreography object for this execution.
     * @param Facebook_Actions_News_Reads_UpdateReading_Inputs|array $inputs (optional) Inputs as Facebook_Actions_News_Reads_UpdateReading_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_News_Reads_UpdateReading_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Actions_News_Reads_UpdateReading $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this UpdateReading execution.
     *
     * @return Facebook_Actions_News_Reads_UpdateReading_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this UpdateReading execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Actions_News_Reads_UpdateReading_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Actions_News_Reads_UpdateReading_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the UpdateReading Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_News_Reads_UpdateReading_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the UpdateReading Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Actions_News_Reads_UpdateReading_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this UpdateReading execution.
     *
     * @return string The response from Facebook.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Creates an action that represents a user rating a movie, TV show, episode, or other video content.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Video_Rates_CreateRating extends Temboo_Choreography
{
    /**
     * Creates an action that represents a user rating a movie, TV show, episode, or other video content.
     *
     * @param Temboo_Session $session The session that owns this CreateRating Choreo.
     * @return Facebook_Actions_Video_Rates_CreateRating New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Actions/Video/Rates/CreateRating/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this CreateRating Choreo.
     *
     * @param Facebook_Actions_Video_Rates_CreateRating_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Video_Rates_CreateRating_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Video_Rates_CreateRating_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Actions_Video_Rates_CreateRating_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this CreateRating Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Video_Rates_CreateRating_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Actions_Video_Rates_CreateRating_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the CreateRating Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Video_Rates_CreateRating_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the CreateRating Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Video_Rates_CreateRating_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this CreateRating input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Actions_Video_Rates_CreateRating_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Actions_Video_Rates_CreateRating_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this CreateRating Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Actions_Video_Rates_CreateRating_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the CreatedTime input for this CreateRating Choreo.
     *
     * @param string $value (optional, date) The time that the action was created (e.g. 2013-06-24T18:53:35+0000).
     * @return Facebook_Actions_Video_Rates_CreateRating_Inputs For method chaining.
     */
    public function setCreatedTime($value)
    {
        return $this->set('CreatedTime', $value);
    }

    /**
     * Set the value for the EndTime input for this CreateRating Choreo.
     *
     * @param string $value (optional, date) The time that the user ended the action (e.g. 2013-06-24T18:53:35+0000).
     * @return Facebook_Actions_Video_Rates_CreateRating_Inputs For method chaining.
     */
    public function setEndTime($value)
    {
        return $this->set('EndTime', $value);
    }

    /**
     * Set the value for the Episode input for this CreateRating Choreo.
     *
     * @param string $value (conditional, string) The URL or ID for an Open Graph object representing an episode.
     * @return Facebook_Actions_Video_Rates_CreateRating_Inputs For method chaining.
     */
    public function setEpisode($value)
    {
        return $this->set('Episode', $value);
    }

    /**
     * Set the value for the ExpiresIn input for this CreateRating Choreo.
     *
     * @param int $value (optional, integer) The amount of time (in milliseconds) from the publish_time that the action will expire.
     * @return Facebook_Actions_Video_Rates_CreateRating_Inputs For method chaining.
     */
    public function setExpiresIn($value)
    {
        return $this->set('ExpiresIn', $value);
    }

    /**
     * Set the value for the ExplicitlyShared input for this CreateRating Choreo.
     *
     * @param bool $value (optional, boolean) Indicates that the user is explicitly sharing this action. Requires the explicitly_shared capability to be enabled.
     * @return Facebook_Actions_Video_Rates_CreateRating_Inputs For method chaining.
     */
    public function setExplicitlyShared($value)
    {
        return $this->set('ExplicitlyShared', $value);
    }

    /**
     * Set the value for the ExplicityShared input for this CreateRating Choreo.
     *
     * @param bool $value (optional, boolean) Deprecated (retained for backward compatibility only).
     * @return Facebook_Actions_Video_Rates_CreateRating_Inputs For method chaining.
     */
    public function setExplicityShared($value)
    {
        return $this->set('ExplicityShared', $value);
    }

    /**
     * Set the value for the Message input for this CreateRating Choreo.
     *
     * @param string $value (optional, string) A message attached to this action. Setting this parameter requires enabling of message capabilities.
     * @return Facebook_Actions_Video_Rates_CreateRating_Inputs For method chaining.
     */
    public function setMessage($value)
    {
        return $this->set('Message', $value);
    }

    /**
     * Set the value for the Movie input for this CreateRating Choreo.
     *
     * @param string $value (conditional, string) The URL or ID for an Open Graph object representing a movie.
     * @return Facebook_Actions_Video_Rates_CreateRating_Inputs For method chaining.
     */
    public function setMovie($value)
    {
        return $this->set('Movie', $value);
    }

    /**
     * Set the value for the NoFeedStory input for this CreateRating Choreo.
     *
     * @param bool $value (optional, boolean) Whether or not this action should be posted to the users feed.
     * @return Facebook_Actions_Video_Rates_CreateRating_Inputs For method chaining.
     */
    public function setNoFeedStory($value)
    {
        return $this->set('NoFeedStory', $value);
    }

    /**
     * Set the value for the Other input for this CreateRating Choreo.
     *
     * @param string $value (conditional, string) The URL or ID for an Open Graph object representing any general video content.
     * @return Facebook_Actions_Video_Rates_CreateRating_Inputs For method chaining.
     */
    public function setOther($value)
    {
        return $this->set('Other', $value);
    }

    /**
     * Set the value for the Place input for this CreateRating Choreo.
     *
     * @param string $value (optional, string) The URL or ID for an Open Graph object representing the location associated with this action.
     * @return Facebook_Actions_Video_Rates_CreateRating_Inputs For method chaining.
     */
    public function setPlace($value)
    {
        return $this->set('Place', $value);
    }

    /**
     * Set the value for the ProfileID input for this CreateRating Choreo.
     *
     * @param string $value (optional, string) The id of the user's profile. Defaults to "me" indicating the authenticated user.
     * @return Facebook_Actions_Video_Rates_CreateRating_Inputs For method chaining.
     */
    public function setProfileID($value)
    {
        return $this->set('ProfileID', $value);
    }

    /**
     * Set the value for the RatingNormalizedValue input for this CreateRating Choreo.
     *
     * @param float $value (required, decimal) The rating expressed as a decimal value between 0 and 1.0.
     * @return Facebook_Actions_Video_Rates_CreateRating_Inputs For method chaining.
     */
    public function setRatingNormalizedValue($value)
    {
        return $this->set('RatingNormalizedValue', $value);
    }

    /**
     * Set the value for the RatingScale input for this CreateRating Choreo.
     *
     * @param int $value (required, integer) The highest possible value in the rating scale.
     * @return Facebook_Actions_Video_Rates_CreateRating_Inputs For method chaining.
     */
    public function setRatingScale($value)
    {
        return $this->set('RatingScale', $value);
    }

    /**
     * Set the value for the RatingValue input for this CreateRating Choreo.
     *
     * @param float $value (required, decimal) The value of the book rating.
     * @return Facebook_Actions_Video_Rates_CreateRating_Inputs For method chaining.
     */
    public function setRatingValue($value)
    {
        return $this->set('RatingValue', $value);
    }

    /**
     * Set the value for the Reference input for this CreateRating Choreo.
     *
     * @param string $value (optional, string) A string identifier up to 50 characters used for tracking and insights.
     * @return Facebook_Actions_Video_Rates_CreateRating_Inputs For method chaining.
     */
    public function setReference($value)
    {
        return $this->set('Reference', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this CreateRating Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Can be set to xml or json. Defaults to json.
     * @return Facebook_Actions_Video_Rates_CreateRating_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }

    /**
     * Set the value for the Review input for this CreateRating Choreo.
     *
     * @param string $value (optional, string) The URL or ID for an Open Graph object representing a video review.
     * @return Facebook_Actions_Video_Rates_CreateRating_Inputs For method chaining.
     */
    public function setReview($value)
    {
        return $this->set('Review', $value);
    }

    /**
     * Set the value for the ReviewText input for this CreateRating Choreo.
     *
     * @param string $value (conditional, string) The text content of the video review.
     * @return Facebook_Actions_Video_Rates_CreateRating_Inputs For method chaining.
     */
    public function setReviewText($value)
    {
        return $this->set('ReviewText', $value);
    }

    /**
     * Set the value for the StartTime input for this CreateRating Choreo.
     *
     * @param string $value (optional, date) The time that the user started the action (e.g. 2013-06-24T18:53:35+0000).
     * @return Facebook_Actions_Video_Rates_CreateRating_Inputs For method chaining.
     */
    public function setStartTime($value)
    {
        return $this->set('StartTime', $value);
    }

    /**
     * Set the value for the TVShow input for this CreateRating Choreo.
     *
     * @param string $value (conditional, string) The URL or ID for an Open Graph object representing a TV show.
     * @return Facebook_Actions_Video_Rates_CreateRating_Inputs For method chaining.
     */
    public function setTVShow($value)
    {
        return $this->set('TVShow', $value);
    }

    /**
     * Set the value for the Tags input for this CreateRating Choreo.
     *
     * @param string $value (optional, string) A comma separated list of other profile IDs that also performed this action.
     * @return Facebook_Actions_Video_Rates_CreateRating_Inputs For method chaining.
     */
    public function setTags($value)
    {
        return $this->set('Tags', $value);
    }
}


/**
 * Execution object for the CreateRating Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Video_Rates_CreateRating_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the CreateRating Choreo.
     *
     * @param Temboo_Session $session The session that owns this CreateRating execution.
     * @param Facebook_Actions_Video_Rates_CreateRating $choreo The choreography object for this execution.
     * @param Facebook_Actions_Video_Rates_CreateRating_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Video_Rates_CreateRating_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Video_Rates_CreateRating_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Actions_Video_Rates_CreateRating $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this CreateRating execution.
     *
     * @return Facebook_Actions_Video_Rates_CreateRating_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this CreateRating execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Actions_Video_Rates_CreateRating_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Actions_Video_Rates_CreateRating_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the CreateRating Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Video_Rates_CreateRating_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the CreateRating Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Actions_Video_Rates_CreateRating_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "ActivityURL" output from this CreateRating execution.
     *
     * @return string (string) The URL for the newly created action.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getActivityURL()
    {
        return $this->get('ActivityURL');
    }
    /**
     * Retrieve the value for the "Response" output from this CreateRating execution.
     *
     * @return string The response from Facebook.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Deletes a given video rating action.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Video_Rates_DeleteRating extends Temboo_Choreography
{
    /**
     * Deletes a given video rating action.
     *
     * @param Temboo_Session $session The session that owns this DeleteRating Choreo.
     * @return Facebook_Actions_Video_Rates_DeleteRating New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Actions/Video/Rates/DeleteRating/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this DeleteRating Choreo.
     *
     * @param Facebook_Actions_Video_Rates_DeleteRating_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Video_Rates_DeleteRating_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Video_Rates_DeleteRating_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Actions_Video_Rates_DeleteRating_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this DeleteRating Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Video_Rates_DeleteRating_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Actions_Video_Rates_DeleteRating_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the DeleteRating Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Video_Rates_DeleteRating_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the DeleteRating Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Video_Rates_DeleteRating_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this DeleteRating input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Actions_Video_Rates_DeleteRating_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Actions_Video_Rates_DeleteRating_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this DeleteRating Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Actions_Video_Rates_DeleteRating_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ActionID input for this DeleteRating Choreo.
     *
     * @param string $value (required, string) The id of an action to delete.
     * @return Facebook_Actions_Video_Rates_DeleteRating_Inputs For method chaining.
     */
    public function setActionID($value)
    {
        return $this->set('ActionID', $value);
    }
}


/**
 * Execution object for the DeleteRating Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Video_Rates_DeleteRating_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the DeleteRating Choreo.
     *
     * @param Temboo_Session $session The session that owns this DeleteRating execution.
     * @param Facebook_Actions_Video_Rates_DeleteRating $choreo The choreography object for this execution.
     * @param Facebook_Actions_Video_Rates_DeleteRating_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Video_Rates_DeleteRating_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Video_Rates_DeleteRating_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Actions_Video_Rates_DeleteRating $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this DeleteRating execution.
     *
     * @return Facebook_Actions_Video_Rates_DeleteRating_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this DeleteRating execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Actions_Video_Rates_DeleteRating_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Actions_Video_Rates_DeleteRating_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the DeleteRating Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Video_Rates_DeleteRating_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the DeleteRating Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Actions_Video_Rates_DeleteRating_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this DeleteRating execution.
     *
     * @return bool (boolean) The response from Facebook. Returns "true" on success.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Retrieves one or more video rating actions.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Video_Rates_ReadRatings extends Temboo_Choreography
{
    /**
     * Retrieves one or more video rating actions.
     *
     * @param Temboo_Session $session The session that owns this ReadRatings Choreo.
     * @return Facebook_Actions_Video_Rates_ReadRatings New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Actions/Video/Rates/ReadRatings/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this ReadRatings Choreo.
     *
     * @param Facebook_Actions_Video_Rates_ReadRatings_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Video_Rates_ReadRatings_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Video_Rates_ReadRatings_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Actions_Video_Rates_ReadRatings_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this ReadRatings Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Video_Rates_ReadRatings_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Actions_Video_Rates_ReadRatings_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the ReadRatings Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Video_Rates_ReadRatings_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the ReadRatings Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Video_Rates_ReadRatings_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this ReadRatings input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Actions_Video_Rates_ReadRatings_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Actions_Video_Rates_ReadRatings_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this ReadRatings Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Actions_Video_Rates_ReadRatings_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ActionID input for this ReadRatings Choreo.
     *
     * @param string $value (optional, string) The id of an action to retrieve. If an id is not provided, a list of all video rate actions will be returned.
     * @return Facebook_Actions_Video_Rates_ReadRatings_Inputs For method chaining.
     */
    public function setActionID($value)
    {
        return $this->set('ActionID', $value);
    }

    /**
     * Set the value for the Fields input for this ReadRatings Choreo.
     *
     * @param string $value (optional, string) A comma separated list of fields to return (i.e. id,name).
     * @return Facebook_Actions_Video_Rates_ReadRatings_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Limit input for this ReadRatings Choreo.
     *
     * @param int $value (optional, integer) Used to page through results. Limits the number of records returned in the response.
     * @return Facebook_Actions_Video_Rates_ReadRatings_Inputs For method chaining.
     */
    public function setLimit($value)
    {
        return $this->set('Limit', $value);
    }

    /**
     * Set the value for the Offset input for this ReadRatings Choreo.
     *
     * @param int $value (optional, integer) Used to page through results. Returns results starting from the specified number.
     * @return Facebook_Actions_Video_Rates_ReadRatings_Inputs For method chaining.
     */
    public function setOffset($value)
    {
        return $this->set('Offset', $value);
    }

    /**
     * Set the value for the ProfileID input for this ReadRatings Choreo.
     *
     * @param string $value (optional, string) The id of the user's profile. Defaults to "me" indicating the authenticated user.
     * @return Facebook_Actions_Video_Rates_ReadRatings_Inputs For method chaining.
     */
    public function setProfileID($value)
    {
        return $this->set('ProfileID', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this ReadRatings Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Can be set to xml or json. Defaults to json.
     * @return Facebook_Actions_Video_Rates_ReadRatings_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }
}


/**
 * Execution object for the ReadRatings Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Video_Rates_ReadRatings_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the ReadRatings Choreo.
     *
     * @param Temboo_Session $session The session that owns this ReadRatings execution.
     * @param Facebook_Actions_Video_Rates_ReadRatings $choreo The choreography object for this execution.
     * @param Facebook_Actions_Video_Rates_ReadRatings_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Video_Rates_ReadRatings_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Video_Rates_ReadRatings_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Actions_Video_Rates_ReadRatings $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this ReadRatings execution.
     *
     * @return Facebook_Actions_Video_Rates_ReadRatings_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this ReadRatings execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Actions_Video_Rates_ReadRatings_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Actions_Video_Rates_ReadRatings_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the ReadRatings Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Video_Rates_ReadRatings_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the ReadRatings Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Actions_Video_Rates_ReadRatings_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "HasNext" output from this ReadRatings execution.
     *
     * @return bool (boolean) A boolean flag indicating that a next page exists.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getHasNext()
    {
        return $this->get('HasNext');
    }
    /**
     * Retrieve the value for the "HasPrevious" output from this ReadRatings execution.
     *
     * @return bool (boolean) A boolean flag indicating that a previous page exists.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getHasPrevious()
    {
        return $this->get('HasPrevious');
    }
    /**
     * Retrieve the value for the "Response" output from this ReadRatings execution.
     *
     * @return string The response from Facebook. Corresponds to the ResponseFormat input. Defaults to JSON.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Updates an existing video rating action.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Video_Rates_UpdateRating extends Temboo_Choreography
{
    /**
     * Updates an existing video rating action.
     *
     * @param Temboo_Session $session The session that owns this UpdateRating Choreo.
     * @return Facebook_Actions_Video_Rates_UpdateRating New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Actions/Video/Rates/UpdateRating/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this UpdateRating Choreo.
     *
     * @param Facebook_Actions_Video_Rates_UpdateRating_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Video_Rates_UpdateRating_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Video_Rates_UpdateRating_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Actions_Video_Rates_UpdateRating_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this UpdateRating Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Video_Rates_UpdateRating_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Actions_Video_Rates_UpdateRating_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the UpdateRating Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Video_Rates_UpdateRating_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the UpdateRating Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Video_Rates_UpdateRating_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this UpdateRating input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Actions_Video_Rates_UpdateRating_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Actions_Video_Rates_UpdateRating_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this UpdateRating Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Actions_Video_Rates_UpdateRating_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ActionID input for this UpdateRating Choreo.
     *
     * @param string $value (required, string) The id of the action to update.
     * @return Facebook_Actions_Video_Rates_UpdateRating_Inputs For method chaining.
     */
    public function setActionID($value)
    {
        return $this->set('ActionID', $value);
    }

    /**
     * Set the value for the EndTime input for this UpdateRating Choreo.
     *
     * @param string $value (optional, date) The time that the user ended the action (e.g. 2013-06-24T18:53:35+0000).
     * @return Facebook_Actions_Video_Rates_UpdateRating_Inputs For method chaining.
     */
    public function setEndTime($value)
    {
        return $this->set('EndTime', $value);
    }

    /**
     * Set the value for the Episode input for this UpdateRating Choreo.
     *
     * @param string $value (optional, string) The URL or ID for an Open Graph object representing an episode.
     * @return Facebook_Actions_Video_Rates_UpdateRating_Inputs For method chaining.
     */
    public function setEpisode($value)
    {
        return $this->set('Episode', $value);
    }

    /**
     * Set the value for the ExpiresIn input for this UpdateRating Choreo.
     *
     * @param int $value (optional, integer) The amount of time (in milliseconds) from the publish_time that the action will expire.
     * @return Facebook_Actions_Video_Rates_UpdateRating_Inputs For method chaining.
     */
    public function setExpiresIn($value)
    {
        return $this->set('ExpiresIn', $value);
    }

    /**
     * Set the value for the Message input for this UpdateRating Choreo.
     *
     * @param string $value (optional, string) A message attached to this action. Setting this parameter requires enabling of message capabilities.
     * @return Facebook_Actions_Video_Rates_UpdateRating_Inputs For method chaining.
     */
    public function setMessage($value)
    {
        return $this->set('Message', $value);
    }

    /**
     * Set the value for the Movie input for this UpdateRating Choreo.
     *
     * @param string $value (optional, string) The URL or ID for an Open Graph object representing a movie.
     * @return Facebook_Actions_Video_Rates_UpdateRating_Inputs For method chaining.
     */
    public function setMovie($value)
    {
        return $this->set('Movie', $value);
    }

    /**
     * Set the value for the Other input for this UpdateRating Choreo.
     *
     * @param string $value (optional, string) The URL or ID for an Open Graph object representing any general video content.
     * @return Facebook_Actions_Video_Rates_UpdateRating_Inputs For method chaining.
     */
    public function setOther($value)
    {
        return $this->set('Other', $value);
    }

    /**
     * Set the value for the Place input for this UpdateRating Choreo.
     *
     * @param string $value (optional, string) The URL or ID for an Open Graph object representing the location associated with this action.
     * @return Facebook_Actions_Video_Rates_UpdateRating_Inputs For method chaining.
     */
    public function setPlace($value)
    {
        return $this->set('Place', $value);
    }

    /**
     * Set the value for the RatingNormalizedValue input for this UpdateRating Choreo.
     *
     * @param float $value (optional, decimal) The rating expressed as a decimal value between 0 and 1.0.
     * @return Facebook_Actions_Video_Rates_UpdateRating_Inputs For method chaining.
     */
    public function setRatingNormalizedValue($value)
    {
        return $this->set('RatingNormalizedValue', $value);
    }

    /**
     * Set the value for the RatingScale input for this UpdateRating Choreo.
     *
     * @param int $value (optional, integer) The highest possible value in the rating scale.
     * @return Facebook_Actions_Video_Rates_UpdateRating_Inputs For method chaining.
     */
    public function setRatingScale($value)
    {
        return $this->set('RatingScale', $value);
    }

    /**
     * Set the value for the RatingValue input for this UpdateRating Choreo.
     *
     * @param float $value (optional, decimal) The value of the book rating.
     * @return Facebook_Actions_Video_Rates_UpdateRating_Inputs For method chaining.
     */
    public function setRatingValue($value)
    {
        return $this->set('RatingValue', $value);
    }

    /**
     * Set the value for the Review input for this UpdateRating Choreo.
     *
     * @param string $value (optional, string) The URL or ID for an Open Graph object representing a book review.
     * @return Facebook_Actions_Video_Rates_UpdateRating_Inputs For method chaining.
     */
    public function setReview($value)
    {
        return $this->set('Review', $value);
    }

    /**
     * Set the value for the ReviewText input for this UpdateRating Choreo.
     *
     * @param string $value (optional, string) The text content of the book review.
     * @return Facebook_Actions_Video_Rates_UpdateRating_Inputs For method chaining.
     */
    public function setReviewText($value)
    {
        return $this->set('ReviewText', $value);
    }

    /**
     * Set the value for the TVShow input for this UpdateRating Choreo.
     *
     * @param string $value (optional, string) The URL or ID for an Open Graph object representing a TV show.
     * @return Facebook_Actions_Video_Rates_UpdateRating_Inputs For method chaining.
     */
    public function setTVShow($value)
    {
        return $this->set('TVShow', $value);
    }

    /**
     * Set the value for the Tags input for this UpdateRating Choreo.
     *
     * @param string $value (optional, string) A comma separated list of other profile IDs that also performed this action.
     * @return Facebook_Actions_Video_Rates_UpdateRating_Inputs For method chaining.
     */
    public function setTags($value)
    {
        return $this->set('Tags', $value);
    }
}


/**
 * Execution object for the UpdateRating Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Video_Rates_UpdateRating_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the UpdateRating Choreo.
     *
     * @param Temboo_Session $session The session that owns this UpdateRating execution.
     * @param Facebook_Actions_Video_Rates_UpdateRating $choreo The choreography object for this execution.
     * @param Facebook_Actions_Video_Rates_UpdateRating_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Video_Rates_UpdateRating_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Video_Rates_UpdateRating_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Actions_Video_Rates_UpdateRating $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this UpdateRating execution.
     *
     * @return Facebook_Actions_Video_Rates_UpdateRating_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this UpdateRating execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Actions_Video_Rates_UpdateRating_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Actions_Video_Rates_UpdateRating_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the UpdateRating Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Video_Rates_UpdateRating_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the UpdateRating Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Actions_Video_Rates_UpdateRating_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this UpdateRating execution.
     *
     * @return string The response from Facebook.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Creates an action that represents a user wanting to watch video content.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Video_WantsToWatch_CreateWantsToWatch extends Temboo_Choreography
{
    /**
     * Creates an action that represents a user wanting to watch video content.
     *
     * @param Temboo_Session $session The session that owns this CreateWantsToWatch Choreo.
     * @return Facebook_Actions_Video_WantsToWatch_CreateWantsToWatch New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Actions/Video/WantsToWatch/CreateWantsToWatch/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this CreateWantsToWatch Choreo.
     *
     * @param Facebook_Actions_Video_WantsToWatch_CreateWantsToWatch_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Video_WantsToWatch_CreateWantsToWatch_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Video_WantsToWatch_CreateWantsToWatch_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Actions_Video_WantsToWatch_CreateWantsToWatch_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this CreateWantsToWatch Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Video_WantsToWatch_CreateWantsToWatch_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Actions_Video_WantsToWatch_CreateWantsToWatch_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the CreateWantsToWatch Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Video_WantsToWatch_CreateWantsToWatch_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the CreateWantsToWatch Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Video_WantsToWatch_CreateWantsToWatch_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this CreateWantsToWatch input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Actions_Video_WantsToWatch_CreateWantsToWatch_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Actions_Video_WantsToWatch_CreateWantsToWatch_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this CreateWantsToWatch Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Actions_Video_WantsToWatch_CreateWantsToWatch_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the AiringEndTime input for this CreateWantsToWatch Choreo.
     *
     * @param string $value (optional, date) The time that the airing ends.
     * @return Facebook_Actions_Video_WantsToWatch_CreateWantsToWatch_Inputs For method chaining.
     */
    public function setAiringEndTime($value)
    {
        return $this->set('AiringEndTime', $value);
    }

    /**
     * Set the value for the AiringID input for this CreateWantsToWatch Choreo.
     *
     * @param string $value (optional, string) The id of the video airing.
     * @return Facebook_Actions_Video_WantsToWatch_CreateWantsToWatch_Inputs For method chaining.
     */
    public function setAiringID($value)
    {
        return $this->set('AiringID', $value);
    }

    /**
     * Set the value for the AiringStartTime input for this CreateWantsToWatch Choreo.
     *
     * @param string $value (optional, date) The time that the airing begins.
     * @return Facebook_Actions_Video_WantsToWatch_CreateWantsToWatch_Inputs For method chaining.
     */
    public function setAiringStartTime($value)
    {
        return $this->set('AiringStartTime', $value);
    }

    /**
     * Set the value for the CreatedTime input for this CreateWantsToWatch Choreo.
     *
     * @param string $value (optional, date) The time that the action was created (e.g. 2013-06-24T18:53:35+0000).
     * @return Facebook_Actions_Video_WantsToWatch_CreateWantsToWatch_Inputs For method chaining.
     */
    public function setCreatedTime($value)
    {
        return $this->set('CreatedTime', $value);
    }

    /**
     * Set the value for the EndTime input for this CreateWantsToWatch Choreo.
     *
     * @param string $value (optional, date) The time that the user ended the action (e.g. 2013-06-24T18:53:35+0000).
     * @return Facebook_Actions_Video_WantsToWatch_CreateWantsToWatch_Inputs For method chaining.
     */
    public function setEndTime($value)
    {
        return $this->set('EndTime', $value);
    }

    /**
     * Set the value for the Episode input for this CreateWantsToWatch Choreo.
     *
     * @param string $value (conditional, string) The URL or ID for an Open Graph object representing an episode of a show.
     * @return Facebook_Actions_Video_WantsToWatch_CreateWantsToWatch_Inputs For method chaining.
     */
    public function setEpisode($value)
    {
        return $this->set('Episode', $value);
    }

    /**
     * Set the value for the ExpiresIn input for this CreateWantsToWatch Choreo.
     *
     * @param int $value (optional, integer) The amount of time (in milliseconds) from the publish_time that the action will expire.
     * @return Facebook_Actions_Video_WantsToWatch_CreateWantsToWatch_Inputs For method chaining.
     */
    public function setExpiresIn($value)
    {
        return $this->set('ExpiresIn', $value);
    }

    /**
     * Set the value for the ExplicitlyShared input for this CreateWantsToWatch Choreo.
     *
     * @param bool $value (optional, boolean) Indicates that the user is explicitly sharing this action. Requires the explicitly_shared capability to be enabled.
     * @return Facebook_Actions_Video_WantsToWatch_CreateWantsToWatch_Inputs For method chaining.
     */
    public function setExplicitlyShared($value)
    {
        return $this->set('ExplicitlyShared', $value);
    }

    /**
     * Set the value for the ExplicityShared input for this CreateWantsToWatch Choreo.
     *
     * @param bool $value (optional, boolean) Deprecated (retained for backward compatibility only).
     * @return Facebook_Actions_Video_WantsToWatch_CreateWantsToWatch_Inputs For method chaining.
     */
    public function setExplicityShared($value)
    {
        return $this->set('ExplicityShared', $value);
    }

    /**
     * Set the value for the Message input for this CreateWantsToWatch Choreo.
     *
     * @param string $value (optional, string) A message attached to this action. Setting this parameter requires enabling of message capabilities.
     * @return Facebook_Actions_Video_WantsToWatch_CreateWantsToWatch_Inputs For method chaining.
     */
    public function setMessage($value)
    {
        return $this->set('Message', $value);
    }

    /**
     * Set the value for the Movie input for this CreateWantsToWatch Choreo.
     *
     * @param string $value (conditional, string) The URL or ID for an Open Graph object representing a movie.
     * @return Facebook_Actions_Video_WantsToWatch_CreateWantsToWatch_Inputs For method chaining.
     */
    public function setMovie($value)
    {
        return $this->set('Movie', $value);
    }

    /**
     * Set the value for the NoFeedStory input for this CreateWantsToWatch Choreo.
     *
     * @param bool $value (optional, boolean) Whether or not this action should be posted to the users feed.
     * @return Facebook_Actions_Video_WantsToWatch_CreateWantsToWatch_Inputs For method chaining.
     */
    public function setNoFeedStory($value)
    {
        return $this->set('NoFeedStory', $value);
    }

    /**
     * Set the value for the Other input for this CreateWantsToWatch Choreo.
     *
     * @param string $value (conditional, string) The URL or ID for an Open Graph object representing any general video content.
     * @return Facebook_Actions_Video_WantsToWatch_CreateWantsToWatch_Inputs For method chaining.
     */
    public function setOther($value)
    {
        return $this->set('Other', $value);
    }

    /**
     * Set the value for the Place input for this CreateWantsToWatch Choreo.
     *
     * @param string $value (optional, string) The URL or ID for an Open Graph object representing the location associated with this action.
     * @return Facebook_Actions_Video_WantsToWatch_CreateWantsToWatch_Inputs For method chaining.
     */
    public function setPlace($value)
    {
        return $this->set('Place', $value);
    }

    /**
     * Set the value for the ProfileID input for this CreateWantsToWatch Choreo.
     *
     * @param string $value (optional, string) The id of the user's profile. Defaults to "me" indicating the authenticated user.
     * @return Facebook_Actions_Video_WantsToWatch_CreateWantsToWatch_Inputs For method chaining.
     */
    public function setProfileID($value)
    {
        return $this->set('ProfileID', $value);
    }

    /**
     * Set the value for the Reference input for this CreateWantsToWatch Choreo.
     *
     * @param string $value (optional, string) A string identifier up to 50 characters used for tracking and insights.
     * @return Facebook_Actions_Video_WantsToWatch_CreateWantsToWatch_Inputs For method chaining.
     */
    public function setReference($value)
    {
        return $this->set('Reference', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this CreateWantsToWatch Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Can be set to xml or json. Defaults to json.
     * @return Facebook_Actions_Video_WantsToWatch_CreateWantsToWatch_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }

    /**
     * Set the value for the StartTime input for this CreateWantsToWatch Choreo.
     *
     * @param string $value (optional, date) The time that the user started the action (e.g. 2013-06-24T18:53:35+0000).
     * @return Facebook_Actions_Video_WantsToWatch_CreateWantsToWatch_Inputs For method chaining.
     */
    public function setStartTime($value)
    {
        return $this->set('StartTime', $value);
    }

    /**
     * Set the value for the TVShow input for this CreateWantsToWatch Choreo.
     *
     * @param string $value (conditional, string) The URL or ID for an Open Graph object representing a TV show.
     * @return Facebook_Actions_Video_WantsToWatch_CreateWantsToWatch_Inputs For method chaining.
     */
    public function setTVShow($value)
    {
        return $this->set('TVShow', $value);
    }

    /**
     * Set the value for the Tags input for this CreateWantsToWatch Choreo.
     *
     * @param string $value (optional, string) A comma separated list of other profile IDs that also performed this action.
     * @return Facebook_Actions_Video_WantsToWatch_CreateWantsToWatch_Inputs For method chaining.
     */
    public function setTags($value)
    {
        return $this->set('Tags', $value);
    }
}


/**
 * Execution object for the CreateWantsToWatch Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Video_WantsToWatch_CreateWantsToWatch_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the CreateWantsToWatch Choreo.
     *
     * @param Temboo_Session $session The session that owns this CreateWantsToWatch execution.
     * @param Facebook_Actions_Video_WantsToWatch_CreateWantsToWatch $choreo The choreography object for this execution.
     * @param Facebook_Actions_Video_WantsToWatch_CreateWantsToWatch_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Video_WantsToWatch_CreateWantsToWatch_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Video_WantsToWatch_CreateWantsToWatch_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Actions_Video_WantsToWatch_CreateWantsToWatch $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this CreateWantsToWatch execution.
     *
     * @return Facebook_Actions_Video_WantsToWatch_CreateWantsToWatch_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this CreateWantsToWatch execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Actions_Video_WantsToWatch_CreateWantsToWatch_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Actions_Video_WantsToWatch_CreateWantsToWatch_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the CreateWantsToWatch Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Video_WantsToWatch_CreateWantsToWatch_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the CreateWantsToWatch Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Actions_Video_WantsToWatch_CreateWantsToWatch_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "ActivityURL" output from this CreateWantsToWatch execution.
     *
     * @return string (string) The URL for the newly created action.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getActivityURL()
    {
        return $this->get('ActivityURL');
    }
    /**
     * Retrieve the value for the "Response" output from this CreateWantsToWatch execution.
     *
     * @return string The response from Facebook.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Deletes a given wants_to_watch action.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Video_WantsToWatch_DeleteWantsToWatch extends Temboo_Choreography
{
    /**
     * Deletes a given wants_to_watch action.
     *
     * @param Temboo_Session $session The session that owns this DeleteWantsToWatch Choreo.
     * @return Facebook_Actions_Video_WantsToWatch_DeleteWantsToWatch New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Actions/Video/WantsToWatch/DeleteWantsToWatch/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this DeleteWantsToWatch Choreo.
     *
     * @param Facebook_Actions_Video_WantsToWatch_DeleteWantsToWatch_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Video_WantsToWatch_DeleteWantsToWatch_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Video_WantsToWatch_DeleteWantsToWatch_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Actions_Video_WantsToWatch_DeleteWantsToWatch_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this DeleteWantsToWatch Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Video_WantsToWatch_DeleteWantsToWatch_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Actions_Video_WantsToWatch_DeleteWantsToWatch_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the DeleteWantsToWatch Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Video_WantsToWatch_DeleteWantsToWatch_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the DeleteWantsToWatch Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Video_WantsToWatch_DeleteWantsToWatch_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this DeleteWantsToWatch input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Actions_Video_WantsToWatch_DeleteWantsToWatch_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Actions_Video_WantsToWatch_DeleteWantsToWatch_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this DeleteWantsToWatch Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Actions_Video_WantsToWatch_DeleteWantsToWatch_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ActionID input for this DeleteWantsToWatch Choreo.
     *
     * @param string $value (required, string) The id of an action to delete.
     * @return Facebook_Actions_Video_WantsToWatch_DeleteWantsToWatch_Inputs For method chaining.
     */
    public function setActionID($value)
    {
        return $this->set('ActionID', $value);
    }
}


/**
 * Execution object for the DeleteWantsToWatch Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Video_WantsToWatch_DeleteWantsToWatch_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the DeleteWantsToWatch Choreo.
     *
     * @param Temboo_Session $session The session that owns this DeleteWantsToWatch execution.
     * @param Facebook_Actions_Video_WantsToWatch_DeleteWantsToWatch $choreo The choreography object for this execution.
     * @param Facebook_Actions_Video_WantsToWatch_DeleteWantsToWatch_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Video_WantsToWatch_DeleteWantsToWatch_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Video_WantsToWatch_DeleteWantsToWatch_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Actions_Video_WantsToWatch_DeleteWantsToWatch $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this DeleteWantsToWatch execution.
     *
     * @return Facebook_Actions_Video_WantsToWatch_DeleteWantsToWatch_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this DeleteWantsToWatch execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Actions_Video_WantsToWatch_DeleteWantsToWatch_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Actions_Video_WantsToWatch_DeleteWantsToWatch_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the DeleteWantsToWatch Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Video_WantsToWatch_DeleteWantsToWatch_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the DeleteWantsToWatch Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Actions_Video_WantsToWatch_DeleteWantsToWatch_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this DeleteWantsToWatch execution.
     *
     * @return bool (boolean) The response from Facebook. Returns "true" on success.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Retrieves one or more video wants_to_watch actions.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Video_WantsToWatch_ReadWantsToWatch extends Temboo_Choreography
{
    /**
     * Retrieves one or more video wants_to_watch actions.
     *
     * @param Temboo_Session $session The session that owns this ReadWantsToWatch Choreo.
     * @return Facebook_Actions_Video_WantsToWatch_ReadWantsToWatch New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Actions/Video/WantsToWatch/ReadWantsToWatch/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this ReadWantsToWatch Choreo.
     *
     * @param Facebook_Actions_Video_WantsToWatch_ReadWantsToWatch_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Video_WantsToWatch_ReadWantsToWatch_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Video_WantsToWatch_ReadWantsToWatch_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Actions_Video_WantsToWatch_ReadWantsToWatch_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this ReadWantsToWatch Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Video_WantsToWatch_ReadWantsToWatch_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Actions_Video_WantsToWatch_ReadWantsToWatch_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the ReadWantsToWatch Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Video_WantsToWatch_ReadWantsToWatch_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the ReadWantsToWatch Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Video_WantsToWatch_ReadWantsToWatch_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this ReadWantsToWatch input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Actions_Video_WantsToWatch_ReadWantsToWatch_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Actions_Video_WantsToWatch_ReadWantsToWatch_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this ReadWantsToWatch Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Actions_Video_WantsToWatch_ReadWantsToWatch_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ActionID input for this ReadWantsToWatch Choreo.
     *
     * @param string $value (optional, string) The id of an action to retrieve. If an id is not provided, a list of all video wants_to_watch actions will be returned.
     * @return Facebook_Actions_Video_WantsToWatch_ReadWantsToWatch_Inputs For method chaining.
     */
    public function setActionID($value)
    {
        return $this->set('ActionID', $value);
    }

    /**
     * Set the value for the Fields input for this ReadWantsToWatch Choreo.
     *
     * @param string $value (optional, string) A comma separated list of fields to return (i.e. id,name).
     * @return Facebook_Actions_Video_WantsToWatch_ReadWantsToWatch_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Limit input for this ReadWantsToWatch Choreo.
     *
     * @param int $value (optional, integer) Used to page through results. Limits the number of records returned in the response.
     * @return Facebook_Actions_Video_WantsToWatch_ReadWantsToWatch_Inputs For method chaining.
     */
    public function setLimit($value)
    {
        return $this->set('Limit', $value);
    }

    /**
     * Set the value for the Offset input for this ReadWantsToWatch Choreo.
     *
     * @param int $value (optional, integer) Used to page through results. Returns results starting from the specified number.
     * @return Facebook_Actions_Video_WantsToWatch_ReadWantsToWatch_Inputs For method chaining.
     */
    public function setOffset($value)
    {
        return $this->set('Offset', $value);
    }

    /**
     * Set the value for the ProfileID input for this ReadWantsToWatch Choreo.
     *
     * @param string $value (optional, string) The id of the user's profile. Defaults to "me" indicating the authenticated user.
     * @return Facebook_Actions_Video_WantsToWatch_ReadWantsToWatch_Inputs For method chaining.
     */
    public function setProfileID($value)
    {
        return $this->set('ProfileID', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this ReadWantsToWatch Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Can be set to xml or json. Defaults to json.
     * @return Facebook_Actions_Video_WantsToWatch_ReadWantsToWatch_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }
}


/**
 * Execution object for the ReadWantsToWatch Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Video_WantsToWatch_ReadWantsToWatch_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the ReadWantsToWatch Choreo.
     *
     * @param Temboo_Session $session The session that owns this ReadWantsToWatch execution.
     * @param Facebook_Actions_Video_WantsToWatch_ReadWantsToWatch $choreo The choreography object for this execution.
     * @param Facebook_Actions_Video_WantsToWatch_ReadWantsToWatch_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Video_WantsToWatch_ReadWantsToWatch_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Video_WantsToWatch_ReadWantsToWatch_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Actions_Video_WantsToWatch_ReadWantsToWatch $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this ReadWantsToWatch execution.
     *
     * @return Facebook_Actions_Video_WantsToWatch_ReadWantsToWatch_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this ReadWantsToWatch execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Actions_Video_WantsToWatch_ReadWantsToWatch_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Actions_Video_WantsToWatch_ReadWantsToWatch_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the ReadWantsToWatch Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Video_WantsToWatch_ReadWantsToWatch_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the ReadWantsToWatch Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Actions_Video_WantsToWatch_ReadWantsToWatch_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "HasNext" output from this ReadWantsToWatch execution.
     *
     * @return bool (boolean) A boolean flag indicating that a next page exists.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getHasNext()
    {
        return $this->get('HasNext');
    }
    /**
     * Retrieve the value for the "HasPrevious" output from this ReadWantsToWatch execution.
     *
     * @return bool (boolean) A boolean flag indicating that a previous page exists.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getHasPrevious()
    {
        return $this->get('HasPrevious');
    }
    /**
     * Retrieve the value for the "Response" output from this ReadWantsToWatch execution.
     *
     * @return string The response from Facebook. Corresponds to the ResponseFormat input. Defaults to JSON.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Updates an existing wants_to_watch action.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Video_WantsToWatch_UpdateWantsToWatch extends Temboo_Choreography
{
    /**
     * Updates an existing wants_to_watch action.
     *
     * @param Temboo_Session $session The session that owns this UpdateWantsToWatch Choreo.
     * @return Facebook_Actions_Video_WantsToWatch_UpdateWantsToWatch New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Actions/Video/WantsToWatch/UpdateWantsToWatch/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this UpdateWantsToWatch Choreo.
     *
     * @param Facebook_Actions_Video_WantsToWatch_UpdateWantsToWatch_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Video_WantsToWatch_UpdateWantsToWatch_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Video_WantsToWatch_UpdateWantsToWatch_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Actions_Video_WantsToWatch_UpdateWantsToWatch_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this UpdateWantsToWatch Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Video_WantsToWatch_UpdateWantsToWatch_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Actions_Video_WantsToWatch_UpdateWantsToWatch_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the UpdateWantsToWatch Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Video_WantsToWatch_UpdateWantsToWatch_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the UpdateWantsToWatch Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Video_WantsToWatch_UpdateWantsToWatch_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this UpdateWantsToWatch input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Actions_Video_WantsToWatch_UpdateWantsToWatch_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Actions_Video_WantsToWatch_UpdateWantsToWatch_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this UpdateWantsToWatch Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Actions_Video_WantsToWatch_UpdateWantsToWatch_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ActionID input for this UpdateWantsToWatch Choreo.
     *
     * @param string $value (required, string) The id of the action to update.
     * @return Facebook_Actions_Video_WantsToWatch_UpdateWantsToWatch_Inputs For method chaining.
     */
    public function setActionID($value)
    {
        return $this->set('ActionID', $value);
    }

    /**
     * Set the value for the AiringEndTime input for this UpdateWantsToWatch Choreo.
     *
     * @param string $value (optional, date) The time that the airing ends.
     * @return Facebook_Actions_Video_WantsToWatch_UpdateWantsToWatch_Inputs For method chaining.
     */
    public function setAiringEndTime($value)
    {
        return $this->set('AiringEndTime', $value);
    }

    /**
     * Set the value for the AiringID input for this UpdateWantsToWatch Choreo.
     *
     * @param string $value (optional, string) The id of the video airing.
     * @return Facebook_Actions_Video_WantsToWatch_UpdateWantsToWatch_Inputs For method chaining.
     */
    public function setAiringID($value)
    {
        return $this->set('AiringID', $value);
    }

    /**
     * Set the value for the AiringStartTime input for this UpdateWantsToWatch Choreo.
     *
     * @param string $value (optional, date) The time that the airing begins.
     * @return Facebook_Actions_Video_WantsToWatch_UpdateWantsToWatch_Inputs For method chaining.
     */
    public function setAiringStartTime($value)
    {
        return $this->set('AiringStartTime', $value);
    }

    /**
     * Set the value for the EndTime input for this UpdateWantsToWatch Choreo.
     *
     * @param string $value (optional, date) The time that the user ended the action (e.g. 2013-06-24T18:53:35+0000).
     * @return Facebook_Actions_Video_WantsToWatch_UpdateWantsToWatch_Inputs For method chaining.
     */
    public function setEndTime($value)
    {
        return $this->set('EndTime', $value);
    }

    /**
     * Set the value for the Episode input for this UpdateWantsToWatch Choreo.
     *
     * @param string $value (optional, string) The URL or ID for an Open Graph object representing an episode of a show.
     * @return Facebook_Actions_Video_WantsToWatch_UpdateWantsToWatch_Inputs For method chaining.
     */
    public function setEpisode($value)
    {
        return $this->set('Episode', $value);
    }

    /**
     * Set the value for the ExpiresIn input for this UpdateWantsToWatch Choreo.
     *
     * @param int $value (optional, integer) The amount of time (in milliseconds) from the publish_time that the action will expire.
     * @return Facebook_Actions_Video_WantsToWatch_UpdateWantsToWatch_Inputs For method chaining.
     */
    public function setExpiresIn($value)
    {
        return $this->set('ExpiresIn', $value);
    }

    /**
     * Set the value for the Message input for this UpdateWantsToWatch Choreo.
     *
     * @param string $value (optional, string) A message attached to this action. Setting this parameter requires enabling of message capabilities.
     * @return Facebook_Actions_Video_WantsToWatch_UpdateWantsToWatch_Inputs For method chaining.
     */
    public function setMessage($value)
    {
        return $this->set('Message', $value);
    }

    /**
     * Set the value for the Movie input for this UpdateWantsToWatch Choreo.
     *
     * @param string $value (optional, string) The URL or ID for an Open Graph object representing a movie.
     * @return Facebook_Actions_Video_WantsToWatch_UpdateWantsToWatch_Inputs For method chaining.
     */
    public function setMovie($value)
    {
        return $this->set('Movie', $value);
    }

    /**
     * Set the value for the Other input for this UpdateWantsToWatch Choreo.
     *
     * @param string $value (optional, string) The URL or ID for an Open Graph object representing any general video content.
     * @return Facebook_Actions_Video_WantsToWatch_UpdateWantsToWatch_Inputs For method chaining.
     */
    public function setOther($value)
    {
        return $this->set('Other', $value);
    }

    /**
     * Set the value for the Place input for this UpdateWantsToWatch Choreo.
     *
     * @param string $value (optional, string) The URL or ID for an Open Graph object representing the location associated with this action.
     * @return Facebook_Actions_Video_WantsToWatch_UpdateWantsToWatch_Inputs For method chaining.
     */
    public function setPlace($value)
    {
        return $this->set('Place', $value);
    }

    /**
     * Set the value for the TVShow input for this UpdateWantsToWatch Choreo.
     *
     * @param string $value (optional, string) The URL or ID for an Open Graph object representing a TV show.
     * @return Facebook_Actions_Video_WantsToWatch_UpdateWantsToWatch_Inputs For method chaining.
     */
    public function setTVShow($value)
    {
        return $this->set('TVShow', $value);
    }

    /**
     * Set the value for the Tags input for this UpdateWantsToWatch Choreo.
     *
     * @param string $value (optional, string) A comma separated list of other profile IDs that also performed this action.
     * @return Facebook_Actions_Video_WantsToWatch_UpdateWantsToWatch_Inputs For method chaining.
     */
    public function setTags($value)
    {
        return $this->set('Tags', $value);
    }
}


/**
 * Execution object for the UpdateWantsToWatch Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Video_WantsToWatch_UpdateWantsToWatch_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the UpdateWantsToWatch Choreo.
     *
     * @param Temboo_Session $session The session that owns this UpdateWantsToWatch execution.
     * @param Facebook_Actions_Video_WantsToWatch_UpdateWantsToWatch $choreo The choreography object for this execution.
     * @param Facebook_Actions_Video_WantsToWatch_UpdateWantsToWatch_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Video_WantsToWatch_UpdateWantsToWatch_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Video_WantsToWatch_UpdateWantsToWatch_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Actions_Video_WantsToWatch_UpdateWantsToWatch $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this UpdateWantsToWatch execution.
     *
     * @return Facebook_Actions_Video_WantsToWatch_UpdateWantsToWatch_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this UpdateWantsToWatch execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Actions_Video_WantsToWatch_UpdateWantsToWatch_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Actions_Video_WantsToWatch_UpdateWantsToWatch_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the UpdateWantsToWatch Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Video_WantsToWatch_UpdateWantsToWatch_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the UpdateWantsToWatch Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Actions_Video_WantsToWatch_UpdateWantsToWatch_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this UpdateWantsToWatch execution.
     *
     * @return string The response from Facebook.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Creates an action that represents a user watching video content.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Video_Watches_CreateWatch extends Temboo_Choreography
{
    /**
     * Creates an action that represents a user watching video content.
     *
     * @param Temboo_Session $session The session that owns this CreateWatch Choreo.
     * @return Facebook_Actions_Video_Watches_CreateWatch New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Actions/Video/Watches/CreateWatch/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this CreateWatch Choreo.
     *
     * @param Facebook_Actions_Video_Watches_CreateWatch_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Video_Watches_CreateWatch_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Video_Watches_CreateWatch_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Actions_Video_Watches_CreateWatch_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this CreateWatch Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Video_Watches_CreateWatch_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Actions_Video_Watches_CreateWatch_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the CreateWatch Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Video_Watches_CreateWatch_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the CreateWatch Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Video_Watches_CreateWatch_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this CreateWatch input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Actions_Video_Watches_CreateWatch_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Actions_Video_Watches_CreateWatch_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this CreateWatch Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Actions_Video_Watches_CreateWatch_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the CreatedTime input for this CreateWatch Choreo.
     *
     * @param string $value (optional, date) The time that the action was created (e.g. 2013-06-24T18:53:35+0000).
     * @return Facebook_Actions_Video_Watches_CreateWatch_Inputs For method chaining.
     */
    public function setCreatedTime($value)
    {
        return $this->set('CreatedTime', $value);
    }

    /**
     * Set the value for the EndTime input for this CreateWatch Choreo.
     *
     * @param string $value (optional, date) The time that the user ended the action (e.g. 2013-06-24T18:53:35+0000).
     * @return Facebook_Actions_Video_Watches_CreateWatch_Inputs For method chaining.
     */
    public function setEndTime($value)
    {
        return $this->set('EndTime', $value);
    }

    /**
     * Set the value for the Episode input for this CreateWatch Choreo.
     *
     * @param string $value (conditional, string) The URL or ID for an Open Graph object representing an episode of a show.
     * @return Facebook_Actions_Video_Watches_CreateWatch_Inputs For method chaining.
     */
    public function setEpisode($value)
    {
        return $this->set('Episode', $value);
    }

    /**
     * Set the value for the ExpiresIn input for this CreateWatch Choreo.
     *
     * @param int $value (optional, integer) The amount of time (in milliseconds) from the publish_time that the action will expire.
     * @return Facebook_Actions_Video_Watches_CreateWatch_Inputs For method chaining.
     */
    public function setExpiresIn($value)
    {
        return $this->set('ExpiresIn', $value);
    }

    /**
     * Set the value for the ExplicitlyShared input for this CreateWatch Choreo.
     *
     * @param bool $value (optional, boolean) Indicates that the user is explicitly sharing this action. Requires the explicitly_shared capability to be enabled.
     * @return Facebook_Actions_Video_Watches_CreateWatch_Inputs For method chaining.
     */
    public function setExplicitlyShared($value)
    {
        return $this->set('ExplicitlyShared', $value);
    }

    /**
     * Set the value for the ExplicityShared input for this CreateWatch Choreo.
     *
     * @param bool $value (optional, boolean) Deprecated (retained for backward compatibility only).
     * @return Facebook_Actions_Video_Watches_CreateWatch_Inputs For method chaining.
     */
    public function setExplicityShared($value)
    {
        return $this->set('ExplicityShared', $value);
    }

    /**
     * Set the value for the Message input for this CreateWatch Choreo.
     *
     * @param string $value (optional, string) A message attached to this action. Setting this parameter requires enabling of message capabilities.
     * @return Facebook_Actions_Video_Watches_CreateWatch_Inputs For method chaining.
     */
    public function setMessage($value)
    {
        return $this->set('Message', $value);
    }

    /**
     * Set the value for the Movie input for this CreateWatch Choreo.
     *
     * @param string $value (conditional, string) The URL or ID for an Open Graph object representing a movie.
     * @return Facebook_Actions_Video_Watches_CreateWatch_Inputs For method chaining.
     */
    public function setMovie($value)
    {
        return $this->set('Movie', $value);
    }

    /**
     * Set the value for the NoFeedStory input for this CreateWatch Choreo.
     *
     * @param bool $value (optional, boolean) Whether or not this action should be posted to the users feed.
     * @return Facebook_Actions_Video_Watches_CreateWatch_Inputs For method chaining.
     */
    public function setNoFeedStory($value)
    {
        return $this->set('NoFeedStory', $value);
    }

    /**
     * Set the value for the Place input for this CreateWatch Choreo.
     *
     * @param string $value (optional, string) The URL or ID for an Open Graph object representing the location associated with this action.
     * @return Facebook_Actions_Video_Watches_CreateWatch_Inputs For method chaining.
     */
    public function setPlace($value)
    {
        return $this->set('Place', $value);
    }

    /**
     * Set the value for the ProfileID input for this CreateWatch Choreo.
     *
     * @param string $value (optional, string) The id of the user's profile. Defaults to "me" indicating the authenticated user.
     * @return Facebook_Actions_Video_Watches_CreateWatch_Inputs For method chaining.
     */
    public function setProfileID($value)
    {
        return $this->set('ProfileID', $value);
    }

    /**
     * Set the value for the Reference input for this CreateWatch Choreo.
     *
     * @param string $value (optional, string) A string identifier up to 50 characters used for tracking and insights.
     * @return Facebook_Actions_Video_Watches_CreateWatch_Inputs For method chaining.
     */
    public function setReference($value)
    {
        return $this->set('Reference', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this CreateWatch Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Can be set to xml or json. Defaults to json.
     * @return Facebook_Actions_Video_Watches_CreateWatch_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }

    /**
     * Set the value for the StartTime input for this CreateWatch Choreo.
     *
     * @param string $value (optional, date) The time that the user started the action (e.g. 2013-06-24T18:53:35+0000).
     * @return Facebook_Actions_Video_Watches_CreateWatch_Inputs For method chaining.
     */
    public function setStartTime($value)
    {
        return $this->set('StartTime', $value);
    }

    /**
     * Set the value for the TVShow input for this CreateWatch Choreo.
     *
     * @param string $value (conditional, string) The URL or ID for an Open Graph object representing a TV show.
     * @return Facebook_Actions_Video_Watches_CreateWatch_Inputs For method chaining.
     */
    public function setTVShow($value)
    {
        return $this->set('TVShow', $value);
    }

    /**
     * Set the value for the Tags input for this CreateWatch Choreo.
     *
     * @param string $value (optional, string) A comma separated list of other profile IDs that also performed this action.
     * @return Facebook_Actions_Video_Watches_CreateWatch_Inputs For method chaining.
     */
    public function setTags($value)
    {
        return $this->set('Tags', $value);
    }

    /**
     * Set the value for the Video input for this CreateWatch Choreo.
     *
     * @param string $value (conditional, string) The URL or ID for an Open Graph object representing any general video content.
     * @return Facebook_Actions_Video_Watches_CreateWatch_Inputs For method chaining.
     */
    public function setVideo($value)
    {
        return $this->set('Video', $value);
    }
}


/**
 * Execution object for the CreateWatch Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Video_Watches_CreateWatch_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the CreateWatch Choreo.
     *
     * @param Temboo_Session $session The session that owns this CreateWatch execution.
     * @param Facebook_Actions_Video_Watches_CreateWatch $choreo The choreography object for this execution.
     * @param Facebook_Actions_Video_Watches_CreateWatch_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Video_Watches_CreateWatch_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Video_Watches_CreateWatch_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Actions_Video_Watches_CreateWatch $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this CreateWatch execution.
     *
     * @return Facebook_Actions_Video_Watches_CreateWatch_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this CreateWatch execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Actions_Video_Watches_CreateWatch_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Actions_Video_Watches_CreateWatch_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the CreateWatch Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Video_Watches_CreateWatch_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the CreateWatch Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Actions_Video_Watches_CreateWatch_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "ActivityURL" output from this CreateWatch execution.
     *
     * @return string (string) The URL for the newly created action.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getActivityURL()
    {
        return $this->get('ActivityURL');
    }
    /**
     * Retrieve the value for the "Response" output from this CreateWatch execution.
     *
     * @return string The response from Facebook.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Deletes a given watch action.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Video_Watches_DeleteWatch extends Temboo_Choreography
{
    /**
     * Deletes a given watch action.
     *
     * @param Temboo_Session $session The session that owns this DeleteWatch Choreo.
     * @return Facebook_Actions_Video_Watches_DeleteWatch New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Actions/Video/Watches/DeleteWatch/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this DeleteWatch Choreo.
     *
     * @param Facebook_Actions_Video_Watches_DeleteWatch_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Video_Watches_DeleteWatch_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Video_Watches_DeleteWatch_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Actions_Video_Watches_DeleteWatch_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this DeleteWatch Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Video_Watches_DeleteWatch_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Actions_Video_Watches_DeleteWatch_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the DeleteWatch Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Video_Watches_DeleteWatch_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the DeleteWatch Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Video_Watches_DeleteWatch_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this DeleteWatch input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Actions_Video_Watches_DeleteWatch_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Actions_Video_Watches_DeleteWatch_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this DeleteWatch Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Actions_Video_Watches_DeleteWatch_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ActionID input for this DeleteWatch Choreo.
     *
     * @param string $value (required, string) The id of an action to delete.
     * @return Facebook_Actions_Video_Watches_DeleteWatch_Inputs For method chaining.
     */
    public function setActionID($value)
    {
        return $this->set('ActionID', $value);
    }
}


/**
 * Execution object for the DeleteWatch Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Video_Watches_DeleteWatch_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the DeleteWatch Choreo.
     *
     * @param Temboo_Session $session The session that owns this DeleteWatch execution.
     * @param Facebook_Actions_Video_Watches_DeleteWatch $choreo The choreography object for this execution.
     * @param Facebook_Actions_Video_Watches_DeleteWatch_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Video_Watches_DeleteWatch_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Video_Watches_DeleteWatch_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Actions_Video_Watches_DeleteWatch $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this DeleteWatch execution.
     *
     * @return Facebook_Actions_Video_Watches_DeleteWatch_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this DeleteWatch execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Actions_Video_Watches_DeleteWatch_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Actions_Video_Watches_DeleteWatch_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the DeleteWatch Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Video_Watches_DeleteWatch_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the DeleteWatch Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Actions_Video_Watches_DeleteWatch_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this DeleteWatch execution.
     *
     * @return bool (boolean) The response from Facebook. Returns "true" on success.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Retrieves one or more video watch actions.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Video_Watches_ReadWatch extends Temboo_Choreography
{
    /**
     * Retrieves one or more video watch actions.
     *
     * @param Temboo_Session $session The session that owns this ReadWatch Choreo.
     * @return Facebook_Actions_Video_Watches_ReadWatch New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Actions/Video/Watches/ReadWatch/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this ReadWatch Choreo.
     *
     * @param Facebook_Actions_Video_Watches_ReadWatch_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Video_Watches_ReadWatch_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Video_Watches_ReadWatch_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Actions_Video_Watches_ReadWatch_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this ReadWatch Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Video_Watches_ReadWatch_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Actions_Video_Watches_ReadWatch_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the ReadWatch Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Video_Watches_ReadWatch_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the ReadWatch Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Video_Watches_ReadWatch_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this ReadWatch input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Actions_Video_Watches_ReadWatch_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Actions_Video_Watches_ReadWatch_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this ReadWatch Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Actions_Video_Watches_ReadWatch_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ActionID input for this ReadWatch Choreo.
     *
     * @param string $value (optional, string) The id of an action to retrieve. If an id is not provided, a list of all video watch actions will be returned.
     * @return Facebook_Actions_Video_Watches_ReadWatch_Inputs For method chaining.
     */
    public function setActionID($value)
    {
        return $this->set('ActionID', $value);
    }

    /**
     * Set the value for the Fields input for this ReadWatch Choreo.
     *
     * @param string $value (optional, string) A comma separated list of fields to return (i.e. id,name).
     * @return Facebook_Actions_Video_Watches_ReadWatch_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Limit input for this ReadWatch Choreo.
     *
     * @param int $value (optional, integer) Used to page through results. Limits the number of records returned in the response.
     * @return Facebook_Actions_Video_Watches_ReadWatch_Inputs For method chaining.
     */
    public function setLimit($value)
    {
        return $this->set('Limit', $value);
    }

    /**
     * Set the value for the Offset input for this ReadWatch Choreo.
     *
     * @param int $value (optional, integer) Used to page through results. Returns results starting from the specified number.
     * @return Facebook_Actions_Video_Watches_ReadWatch_Inputs For method chaining.
     */
    public function setOffset($value)
    {
        return $this->set('Offset', $value);
    }

    /**
     * Set the value for the ProfileID input for this ReadWatch Choreo.
     *
     * @param string $value (optional, string) The id of the user's profile. Defaults to "me" indicating the authenticated user.
     * @return Facebook_Actions_Video_Watches_ReadWatch_Inputs For method chaining.
     */
    public function setProfileID($value)
    {
        return $this->set('ProfileID', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this ReadWatch Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Can be set to xml or json. Defaults to json.
     * @return Facebook_Actions_Video_Watches_ReadWatch_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }
}


/**
 * Execution object for the ReadWatch Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Video_Watches_ReadWatch_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the ReadWatch Choreo.
     *
     * @param Temboo_Session $session The session that owns this ReadWatch execution.
     * @param Facebook_Actions_Video_Watches_ReadWatch $choreo The choreography object for this execution.
     * @param Facebook_Actions_Video_Watches_ReadWatch_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Video_Watches_ReadWatch_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Video_Watches_ReadWatch_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Actions_Video_Watches_ReadWatch $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this ReadWatch execution.
     *
     * @return Facebook_Actions_Video_Watches_ReadWatch_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this ReadWatch execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Actions_Video_Watches_ReadWatch_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Actions_Video_Watches_ReadWatch_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the ReadWatch Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Video_Watches_ReadWatch_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the ReadWatch Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Actions_Video_Watches_ReadWatch_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "HasNext" output from this ReadWatch execution.
     *
     * @return bool (boolean) A boolean flag indicating that a next page exists.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getHasNext()
    {
        return $this->get('HasNext');
    }
    /**
     * Retrieve the value for the "HasPrevious" output from this ReadWatch execution.
     *
     * @return bool (boolean) A boolean flag indicating that a previous page exists.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getHasPrevious()
    {
        return $this->get('HasPrevious');
    }
    /**
     * Retrieve the value for the "Response" output from this ReadWatch execution.
     *
     * @return string The response from Facebook. Corresponds to the ResponseFormat input. Defaults to JSON.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Updates an existing watch action.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Video_Watches_UpdateWatch extends Temboo_Choreography
{
    /**
     * Updates an existing watch action.
     *
     * @param Temboo_Session $session The session that owns this UpdateWatch Choreo.
     * @return Facebook_Actions_Video_Watches_UpdateWatch New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Actions/Video/Watches/UpdateWatch/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this UpdateWatch Choreo.
     *
     * @param Facebook_Actions_Video_Watches_UpdateWatch_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Video_Watches_UpdateWatch_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Video_Watches_UpdateWatch_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Actions_Video_Watches_UpdateWatch_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this UpdateWatch Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Video_Watches_UpdateWatch_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Actions_Video_Watches_UpdateWatch_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the UpdateWatch Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Video_Watches_UpdateWatch_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the UpdateWatch Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Actions_Video_Watches_UpdateWatch_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this UpdateWatch input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Actions_Video_Watches_UpdateWatch_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Actions_Video_Watches_UpdateWatch_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this UpdateWatch Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Actions_Video_Watches_UpdateWatch_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ActionID input for this UpdateWatch Choreo.
     *
     * @param string $value (required, string) The id of the action to update.
     * @return Facebook_Actions_Video_Watches_UpdateWatch_Inputs For method chaining.
     */
    public function setActionID($value)
    {
        return $this->set('ActionID', $value);
    }

    /**
     * Set the value for the EndTime input for this UpdateWatch Choreo.
     *
     * @param string $value (optional, date) The time that the user ended the action (e.g. 2013-06-24T18:53:35+0000).
     * @return Facebook_Actions_Video_Watches_UpdateWatch_Inputs For method chaining.
     */
    public function setEndTime($value)
    {
        return $this->set('EndTime', $value);
    }

    /**
     * Set the value for the Episode input for this UpdateWatch Choreo.
     *
     * @param string $value (optional, string) The URL or ID for an Open Graph object representing an episode of a show.
     * @return Facebook_Actions_Video_Watches_UpdateWatch_Inputs For method chaining.
     */
    public function setEpisode($value)
    {
        return $this->set('Episode', $value);
    }

    /**
     * Set the value for the ExpiresIn input for this UpdateWatch Choreo.
     *
     * @param int $value (optional, integer) The amount of time (in milliseconds) from the publish_time that the action will expire.
     * @return Facebook_Actions_Video_Watches_UpdateWatch_Inputs For method chaining.
     */
    public function setExpiresIn($value)
    {
        return $this->set('ExpiresIn', $value);
    }

    /**
     * Set the value for the Message input for this UpdateWatch Choreo.
     *
     * @param string $value (optional, string) A message attached to this action. Setting this parameter requires enabling of message capabilities.
     * @return Facebook_Actions_Video_Watches_UpdateWatch_Inputs For method chaining.
     */
    public function setMessage($value)
    {
        return $this->set('Message', $value);
    }

    /**
     * Set the value for the Movie input for this UpdateWatch Choreo.
     *
     * @param string $value (optional, string) The URL or ID for an Open Graph object representing a movie.
     * @return Facebook_Actions_Video_Watches_UpdateWatch_Inputs For method chaining.
     */
    public function setMovie($value)
    {
        return $this->set('Movie', $value);
    }

    /**
     * Set the value for the Place input for this UpdateWatch Choreo.
     *
     * @param string $value (optional, string) The URL or ID for an Open Graph object representing the location associated with this action.
     * @return Facebook_Actions_Video_Watches_UpdateWatch_Inputs For method chaining.
     */
    public function setPlace($value)
    {
        return $this->set('Place', $value);
    }

    /**
     * Set the value for the TVShow input for this UpdateWatch Choreo.
     *
     * @param string $value (optional, string) The URL or ID for an Open Graph object representing a TV show.
     * @return Facebook_Actions_Video_Watches_UpdateWatch_Inputs For method chaining.
     */
    public function setTVShow($value)
    {
        return $this->set('TVShow', $value);
    }

    /**
     * Set the value for the Tags input for this UpdateWatch Choreo.
     *
     * @param string $value (optional, string) A comma separated list of other profile IDs that also performed this action.
     * @return Facebook_Actions_Video_Watches_UpdateWatch_Inputs For method chaining.
     */
    public function setTags($value)
    {
        return $this->set('Tags', $value);
    }

    /**
     * Set the value for the Video input for this UpdateWatch Choreo.
     *
     * @param string $value (optional, string) The URL or ID for an Open Graph object representing any general video content.
     * @return Facebook_Actions_Video_Watches_UpdateWatch_Inputs For method chaining.
     */
    public function setVideo($value)
    {
        return $this->set('Video', $value);
    }
}


/**
 * Execution object for the UpdateWatch Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Video_Watches_UpdateWatch_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the UpdateWatch Choreo.
     *
     * @param Temboo_Session $session The session that owns this UpdateWatch execution.
     * @param Facebook_Actions_Video_Watches_UpdateWatch $choreo The choreography object for this execution.
     * @param Facebook_Actions_Video_Watches_UpdateWatch_Inputs|array $inputs (optional) Inputs as Facebook_Actions_Video_Watches_UpdateWatch_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Actions_Video_Watches_UpdateWatch_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Actions_Video_Watches_UpdateWatch $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this UpdateWatch execution.
     *
     * @return Facebook_Actions_Video_Watches_UpdateWatch_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this UpdateWatch execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Actions_Video_Watches_UpdateWatch_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Actions_Video_Watches_UpdateWatch_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the UpdateWatch Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Actions_Video_Watches_UpdateWatch_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the UpdateWatch Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Actions_Video_Watches_UpdateWatch_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this UpdateWatch execution.
     *
     * @return string The response from Facebook.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Allows you to perform multiple graph operations in one request.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_BatchRequests_Batch extends Temboo_Choreography
{
    /**
     * Allows you to perform multiple graph operations in one request.
     *
     * @param Temboo_Session $session The session that owns this Batch Choreo.
     * @return Facebook_BatchRequests_Batch New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/BatchRequests/Batch/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this Batch Choreo.
     *
     * @param Facebook_BatchRequests_Batch_Inputs|array $inputs (optional) Inputs as Facebook_BatchRequests_Batch_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_BatchRequests_Batch_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_BatchRequests_Batch_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this Batch Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_BatchRequests_Batch_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_BatchRequests_Batch_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the Batch Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_BatchRequests_Batch_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the Batch Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_BatchRequests_Batch_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this Batch input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_BatchRequests_Batch_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_BatchRequests_Batch_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this Batch Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_BatchRequests_Batch_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the Batch input for this Batch Choreo.
     *
     * @param string $value (required, json) A JSON object which describes each individual operation you'd like to perform. See documentation for syntax examples.
     * @return Facebook_BatchRequests_Batch_Inputs For method chaining.
     */
    public function setBatch($value)
    {
        return $this->set('Batch', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this Batch Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Can be set to xml or json. Defaults to json.
     * @return Facebook_BatchRequests_Batch_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }
}


/**
 * Execution object for the Batch Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_BatchRequests_Batch_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the Batch Choreo.
     *
     * @param Temboo_Session $session The session that owns this Batch execution.
     * @param Facebook_BatchRequests_Batch $choreo The choreography object for this execution.
     * @param Facebook_BatchRequests_Batch_Inputs|array $inputs (optional) Inputs as Facebook_BatchRequests_Batch_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_BatchRequests_Batch_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_BatchRequests_Batch $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this Batch execution.
     *
     * @return Facebook_BatchRequests_Batch_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this Batch execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_BatchRequests_Batch_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_BatchRequests_Batch_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the Batch Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_BatchRequests_Batch_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the Batch Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_BatchRequests_Batch_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this Batch execution.
     *
     * @return string (string) Contains the Base64 encoded value of the image retrieved from Facebook.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Deletes a specified comment.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Deleting_DeleteComment extends Temboo_Choreography
{
    /**
     * Deletes a specified comment.
     *
     * @param Temboo_Session $session The session that owns this DeleteComment Choreo.
     * @return Facebook_Deleting_DeleteComment New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Deleting/DeleteComment/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this DeleteComment Choreo.
     *
     * @param Facebook_Deleting_DeleteComment_Inputs|array $inputs (optional) Inputs as Facebook_Deleting_DeleteComment_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Deleting_DeleteComment_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Deleting_DeleteComment_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this DeleteComment Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Deleting_DeleteComment_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Deleting_DeleteComment_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the DeleteComment Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Deleting_DeleteComment_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the DeleteComment Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Deleting_DeleteComment_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this DeleteComment input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Deleting_DeleteComment_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Deleting_DeleteComment_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this DeleteComment Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Deleting_DeleteComment_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the CommentID input for this DeleteComment Choreo.
     *
     * @param string $value (required, string) The id of the comment to delete.
     * @return Facebook_Deleting_DeleteComment_Inputs For method chaining.
     */
    public function setCommentID($value)
    {
        return $this->set('CommentID', $value);
    }
}


/**
 * Execution object for the DeleteComment Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Deleting_DeleteComment_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the DeleteComment Choreo.
     *
     * @param Temboo_Session $session The session that owns this DeleteComment execution.
     * @param Facebook_Deleting_DeleteComment $choreo The choreography object for this execution.
     * @param Facebook_Deleting_DeleteComment_Inputs|array $inputs (optional) Inputs as Facebook_Deleting_DeleteComment_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Deleting_DeleteComment_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Deleting_DeleteComment $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this DeleteComment execution.
     *
     * @return Facebook_Deleting_DeleteComment_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this DeleteComment execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Deleting_DeleteComment_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Deleting_DeleteComment_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the DeleteComment Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Deleting_DeleteComment_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the DeleteComment Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Deleting_DeleteComment_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this DeleteComment execution.
     *
     * @return bool (boolean) The response from Facebook. Returns "true" on success.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Deletes objects in the graph with a given id or path.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Deleting_DeleteObject extends Temboo_Choreography
{
    /**
     * Deletes objects in the graph with a given id or path.
     *
     * @param Temboo_Session $session The session that owns this DeleteObject Choreo.
     * @return Facebook_Deleting_DeleteObject New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Deleting/DeleteObject/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this DeleteObject Choreo.
     *
     * @param Facebook_Deleting_DeleteObject_Inputs|array $inputs (optional) Inputs as Facebook_Deleting_DeleteObject_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Deleting_DeleteObject_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Deleting_DeleteObject_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this DeleteObject Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Deleting_DeleteObject_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Deleting_DeleteObject_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the DeleteObject Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Deleting_DeleteObject_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the DeleteObject Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Deleting_DeleteObject_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this DeleteObject input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Deleting_DeleteObject_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Deleting_DeleteObject_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this DeleteObject Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Deleting_DeleteObject_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ObjectID input for this DeleteObject Choreo.
     *
     * @param string $value (required, string) The id or path to an object to delete.
     * @return Facebook_Deleting_DeleteObject_Inputs For method chaining.
     */
    public function setObjectID($value)
    {
        return $this->set('ObjectID', $value);
    }
}


/**
 * Execution object for the DeleteObject Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Deleting_DeleteObject_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the DeleteObject Choreo.
     *
     * @param Temboo_Session $session The session that owns this DeleteObject execution.
     * @param Facebook_Deleting_DeleteObject $choreo The choreography object for this execution.
     * @param Facebook_Deleting_DeleteObject_Inputs|array $inputs (optional) Inputs as Facebook_Deleting_DeleteObject_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Deleting_DeleteObject_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Deleting_DeleteObject $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this DeleteObject execution.
     *
     * @return Facebook_Deleting_DeleteObject_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this DeleteObject execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Deleting_DeleteObject_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Deleting_DeleteObject_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the DeleteObject Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Deleting_DeleteObject_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the DeleteObject Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Deleting_DeleteObject_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this DeleteObject execution.
     *
     * @return bool (boolean) The response from Facebook. Returns "true" on success.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Deletes a specified status message from the authenticated user's feed.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Deleting_DeleteStatus extends Temboo_Choreography
{
    /**
     * Deletes a specified status message from the authenticated user's feed.
     *
     * @param Temboo_Session $session The session that owns this DeleteStatus Choreo.
     * @return Facebook_Deleting_DeleteStatus New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Deleting/DeleteStatus/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this DeleteStatus Choreo.
     *
     * @param Facebook_Deleting_DeleteStatus_Inputs|array $inputs (optional) Inputs as Facebook_Deleting_DeleteStatus_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Deleting_DeleteStatus_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Deleting_DeleteStatus_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this DeleteStatus Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Deleting_DeleteStatus_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Deleting_DeleteStatus_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the DeleteStatus Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Deleting_DeleteStatus_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the DeleteStatus Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Deleting_DeleteStatus_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this DeleteStatus input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Deleting_DeleteStatus_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Deleting_DeleteStatus_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this DeleteStatus Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Deleting_DeleteStatus_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the StatusID input for this DeleteStatus Choreo.
     *
     * @param string $value (required, string) The ID for the status message you want to delete.
     * @return Facebook_Deleting_DeleteStatus_Inputs For method chaining.
     */
    public function setStatusID($value)
    {
        return $this->set('StatusID', $value);
    }
}


/**
 * Execution object for the DeleteStatus Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Deleting_DeleteStatus_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the DeleteStatus Choreo.
     *
     * @param Temboo_Session $session The session that owns this DeleteStatus execution.
     * @param Facebook_Deleting_DeleteStatus $choreo The choreography object for this execution.
     * @param Facebook_Deleting_DeleteStatus_Inputs|array $inputs (optional) Inputs as Facebook_Deleting_DeleteStatus_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Deleting_DeleteStatus_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Deleting_DeleteStatus $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this DeleteStatus execution.
     *
     * @return Facebook_Deleting_DeleteStatus_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this DeleteStatus execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Deleting_DeleteStatus_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Deleting_DeleteStatus_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the DeleteStatus Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Deleting_DeleteStatus_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the DeleteStatus Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Deleting_DeleteStatus_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this DeleteStatus execution.
     *
     * @return bool (boolean) The response from Facebook. Returns "true" on success.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Allows a user to "unlike" a Graph API object.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Deleting_Unlike extends Temboo_Choreography
{
    /**
     * Allows a user to "unlike" a Graph API object.
     *
     * @param Temboo_Session $session The session that owns this Unlike Choreo.
     * @return Facebook_Deleting_Unlike New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Deleting/Unlike/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this Unlike Choreo.
     *
     * @param Facebook_Deleting_Unlike_Inputs|array $inputs (optional) Inputs as Facebook_Deleting_Unlike_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Deleting_Unlike_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Deleting_Unlike_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this Unlike Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Deleting_Unlike_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Deleting_Unlike_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the Unlike Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Deleting_Unlike_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the Unlike Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Deleting_Unlike_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this Unlike input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Deleting_Unlike_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Deleting_Unlike_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this Unlike Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Deleting_Unlike_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ObjectID input for this Unlike Choreo.
     *
     * @param string $value (required, string) The id of a graph api object to unlike.
     * @return Facebook_Deleting_Unlike_Inputs For method chaining.
     */
    public function setObjectID($value)
    {
        return $this->set('ObjectID', $value);
    }
}


/**
 * Execution object for the Unlike Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Deleting_Unlike_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the Unlike Choreo.
     *
     * @param Temboo_Session $session The session that owns this Unlike execution.
     * @param Facebook_Deleting_Unlike $choreo The choreography object for this execution.
     * @param Facebook_Deleting_Unlike_Inputs|array $inputs (optional) Inputs as Facebook_Deleting_Unlike_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Deleting_Unlike_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Deleting_Unlike $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this Unlike execution.
     *
     * @return Facebook_Deleting_Unlike_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this Unlike execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Deleting_Unlike_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Deleting_Unlike_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the Unlike Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Deleting_Unlike_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the Unlike Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Deleting_Unlike_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this Unlike execution.
     *
     * @return bool (boolean) The response from Facebook. Returns "true" on success.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Completes the OAuth process by retrieving a Facebook access token for a user, after they have visited the authorization URL returned by the InitializeOAuth Choreo and clicked "allow."
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_OAuth_FinalizeOAuth extends Temboo_Choreography
{
    /**
     * Completes the OAuth process by retrieving a Facebook access token for a user, after they have visited the authorization URL returned by the InitializeOAuth Choreo and clicked "allow."
     *
     * @param Temboo_Session $session The session that owns this FinalizeOAuth Choreo.
     * @return Facebook_OAuth_FinalizeOAuth New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/OAuth/FinalizeOAuth/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this FinalizeOAuth Choreo.
     *
     * @param Facebook_OAuth_FinalizeOAuth_Inputs|array $inputs (optional) Inputs as Facebook_OAuth_FinalizeOAuth_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_OAuth_FinalizeOAuth_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_OAuth_FinalizeOAuth_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this FinalizeOAuth Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_OAuth_FinalizeOAuth_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_OAuth_FinalizeOAuth_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the FinalizeOAuth Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_OAuth_FinalizeOAuth_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the FinalizeOAuth Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_OAuth_FinalizeOAuth_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this FinalizeOAuth input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_OAuth_FinalizeOAuth_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_OAuth_FinalizeOAuth_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccountName input for this FinalizeOAuth Choreo.
     *
     * @param string $value (optional, string) Deprecated (retained for backward compatibility only).
     * @return Facebook_OAuth_FinalizeOAuth_Inputs For method chaining.
     */
    public function setAccountName($value)
    {
        return $this->set('AccountName', $value);
    }

    /**
     * Set the value for the AppID input for this FinalizeOAuth Choreo.
     *
     * @param string $value (required, string) The App ID provided by Facebook.
     * @return Facebook_OAuth_FinalizeOAuth_Inputs For method chaining.
     */
    public function setAppID($value)
    {
        return $this->set('AppID', $value);
    }

    /**
     * Set the value for the AppKeyName input for this FinalizeOAuth Choreo.
     *
     * @param string $value (optional, string) Deprecated (retained for backward compatibility only).
     * @return Facebook_OAuth_FinalizeOAuth_Inputs For method chaining.
     */
    public function setAppKeyName($value)
    {
        return $this->set('AppKeyName', $value);
    }

    /**
     * Set the value for the AppKeyValue input for this FinalizeOAuth Choreo.
     *
     * @param string $value (optional, string) Deprecated (retained for backward compatibility only).
     * @return Facebook_OAuth_FinalizeOAuth_Inputs For method chaining.
     */
    public function setAppKeyValue($value)
    {
        return $this->set('AppKeyValue', $value);
    }

    /**
     * Set the value for the AppSecret input for this FinalizeOAuth Choreo.
     *
     * @param string $value (required, string) The App Secret provided by Facebook.
     * @return Facebook_OAuth_FinalizeOAuth_Inputs For method chaining.
     */
    public function setAppSecret($value)
    {
        return $this->set('AppSecret', $value);
    }

    /**
     * Set the value for the CallbackID input for this FinalizeOAuth Choreo.
     *
     * @param string $value (required, string) The callback token returned by the InitializeOAuth Choreo. Used to retrieve the authorization code after the user authorizes.
     * @return Facebook_OAuth_FinalizeOAuth_Inputs For method chaining.
     */
    public function setCallbackID($value)
    {
        return $this->set('CallbackID', $value);
    }

    /**
     * Set the value for the LongLivedToken input for this FinalizeOAuth Choreo.
     *
     * @param bool $value (optional, boolean) Set to 1 to automatically exchange the short-lived access token for a long-lived access token. Defaults to 0 (false).
     * @return Facebook_OAuth_FinalizeOAuth_Inputs For method chaining.
     */
    public function setLongLivedToken($value)
    {
        return $this->set('LongLivedToken', $value);
    }

    /**
     * Set the value for the SuppressErrors input for this FinalizeOAuth Choreo.
     *
     * @param bool $value (optional, boolean) When set to true, errors received during the OAuth redirect process will be suppressed and returned in the ErrorMessage output.
     * @return Facebook_OAuth_FinalizeOAuth_Inputs For method chaining.
     */
    public function setSuppressErrors($value)
    {
        return $this->set('SuppressErrors', $value);
    }

    /**
     * Set the value for the Timeout input for this FinalizeOAuth Choreo.
     *
     * @param int $value (optional, integer) The amount of time (in seconds) to poll your Temboo callback URL to see if your app's user has allowed or denied the request for access. Defaults to 20. Max is 60.
     * @return Facebook_OAuth_FinalizeOAuth_Inputs For method chaining.
     */
    public function setTimeout($value)
    {
        return $this->set('Timeout', $value);
    }
}


/**
 * Execution object for the FinalizeOAuth Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_OAuth_FinalizeOAuth_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the FinalizeOAuth Choreo.
     *
     * @param Temboo_Session $session The session that owns this FinalizeOAuth execution.
     * @param Facebook_OAuth_FinalizeOAuth $choreo The choreography object for this execution.
     * @param Facebook_OAuth_FinalizeOAuth_Inputs|array $inputs (optional) Inputs as Facebook_OAuth_FinalizeOAuth_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_OAuth_FinalizeOAuth_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_OAuth_FinalizeOAuth $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this FinalizeOAuth execution.
     *
     * @return Facebook_OAuth_FinalizeOAuth_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this FinalizeOAuth execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_OAuth_FinalizeOAuth_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_OAuth_FinalizeOAuth_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the FinalizeOAuth Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_OAuth_FinalizeOAuth_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the FinalizeOAuth Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_OAuth_FinalizeOAuth_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "AccessToken" output from this FinalizeOAuth execution.
     *
     * @return string (string) The access token for the user that has granted access to your application.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getAccessToken()
    {
        return $this->get('AccessToken');
    }
    /**
     * Retrieve the value for the "ErrorMessage" output from this FinalizeOAuth execution.
     *
     * @return string (string) Contains an error message if an error occurs during the OAuth redirect process and if SuppressErrors is set to true.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getErrorMessage()
    {
        return $this->get('ErrorMessage');
    }
    /**
     * Retrieve the value for the "Expires" output from this FinalizeOAuth execution.
     *
     * @return int (integer) The expiration time of the access_token retrieved.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getExpires()
    {
        return $this->get('Expires');
    }
}

/**
 * Generates an authorization URL that an application can use to complete the first step in the OAuth process.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_OAuth_InitializeOAuth extends Temboo_Choreography
{
    /**
     * Generates an authorization URL that an application can use to complete the first step in the OAuth process.
     *
     * @param Temboo_Session $session The session that owns this InitializeOAuth Choreo.
     * @return Facebook_OAuth_InitializeOAuth New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/OAuth/InitializeOAuth/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this InitializeOAuth Choreo.
     *
     * @param Facebook_OAuth_InitializeOAuth_Inputs|array $inputs (optional) Inputs as Facebook_OAuth_InitializeOAuth_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_OAuth_InitializeOAuth_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_OAuth_InitializeOAuth_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this InitializeOAuth Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_OAuth_InitializeOAuth_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_OAuth_InitializeOAuth_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the InitializeOAuth Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_OAuth_InitializeOAuth_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the InitializeOAuth Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_OAuth_InitializeOAuth_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this InitializeOAuth input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_OAuth_InitializeOAuth_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_OAuth_InitializeOAuth_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccountName input for this InitializeOAuth Choreo.
     *
     * @param string $value (optional, string) Deprecated (retained for backward compatibility only).
     * @return Facebook_OAuth_InitializeOAuth_Inputs For method chaining.
     */
    public function setAccountName($value)
    {
        return $this->set('AccountName', $value);
    }

    /**
     * Set the value for the AppID input for this InitializeOAuth Choreo.
     *
     * @param string $value (required, string) The App ID provided by Facebook.
     * @return Facebook_OAuth_InitializeOAuth_Inputs For method chaining.
     */
    public function setAppID($value)
    {
        return $this->set('AppID', $value);
    }

    /**
     * Set the value for the AppKeyName input for this InitializeOAuth Choreo.
     *
     * @param string $value (optional, string) Deprecated (retained for backward compatibility only).
     * @return Facebook_OAuth_InitializeOAuth_Inputs For method chaining.
     */
    public function setAppKeyName($value)
    {
        return $this->set('AppKeyName', $value);
    }

    /**
     * Set the value for the AppKeyValue input for this InitializeOAuth Choreo.
     *
     * @param string $value (optional, string) Deprecated (retained for backward compatibility only).
     * @return Facebook_OAuth_InitializeOAuth_Inputs For method chaining.
     */
    public function setAppKeyValue($value)
    {
        return $this->set('AppKeyValue', $value);
    }

    /**
     * Set the value for the AuthType input for this InitializeOAuth Choreo.
     *
     * @param string $value (optional, string) This can be set to "rerequest" when your app needs to re-ask for a permission that was previously declined.
     * @return Facebook_OAuth_InitializeOAuth_Inputs For method chaining.
     */
    public function setAuthType($value)
    {
        return $this->set('AuthType', $value);
    }

    /**
     * Set the value for the CustomCallbackID input for this InitializeOAuth Choreo.
     *
     * @param string $value (optional, string) A unique identifier that you can pass to eliminate the need to wait for a Temboo generated CallbackID. Callback identifiers may only contain numbers, letters, periods, and hyphens.
     * @return Facebook_OAuth_InitializeOAuth_Inputs For method chaining.
     */
    public function setCustomCallbackID($value)
    {
        return $this->set('CustomCallbackID', $value);
    }

    /**
     * Set the value for the ForwardingURL input for this InitializeOAuth Choreo.
     *
     * @param string $value (optional, string) The URL that Temboo will redirect your users to after they grant access to your application. This should include the "https://" or "http://" prefix and be a fully qualified URL.
     * @return Facebook_OAuth_InitializeOAuth_Inputs For method chaining.
     */
    public function setForwardingURL($value)
    {
        return $this->set('ForwardingURL', $value);
    }

    /**
     * Set the value for the Scope input for this InitializeOAuth Choreo.
     *
     * @param string $value (conditional, string) A comma-separated list of permissions to request access for (i.e. "publish_actions,read_mailbox"). For more information see Choreo notes.
     * @return Facebook_OAuth_InitializeOAuth_Inputs For method chaining.
     */
    public function setScope($value)
    {
        return $this->set('Scope', $value);
    }
}


/**
 * Execution object for the InitializeOAuth Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_OAuth_InitializeOAuth_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the InitializeOAuth Choreo.
     *
     * @param Temboo_Session $session The session that owns this InitializeOAuth execution.
     * @param Facebook_OAuth_InitializeOAuth $choreo The choreography object for this execution.
     * @param Facebook_OAuth_InitializeOAuth_Inputs|array $inputs (optional) Inputs as Facebook_OAuth_InitializeOAuth_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_OAuth_InitializeOAuth_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_OAuth_InitializeOAuth $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this InitializeOAuth execution.
     *
     * @return Facebook_OAuth_InitializeOAuth_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this InitializeOAuth execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_OAuth_InitializeOAuth_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_OAuth_InitializeOAuth_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the InitializeOAuth Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_OAuth_InitializeOAuth_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the InitializeOAuth Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_OAuth_InitializeOAuth_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "AuthorizationURL" output from this InitializeOAuth execution.
     *
     * @return string (string) The authorization URL to send your user to in order for them to grant access to your application.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getAuthorizationURL()
    {
        return $this->get('AuthorizationURL');
    }
    /**
     * Retrieve the value for the "CallbackID" output from this InitializeOAuth execution.
     *
     * @return string (string) An ID used to retrieve the callback data that Temboo stores once your application's user authorizes.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getCallbackID()
    {
        return $this->get('CallbackID');
    }
}

/**
 * Creates an album.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Publishing_CreateAlbum extends Temboo_Choreography
{
    /**
     * Creates an album.
     *
     * @param Temboo_Session $session The session that owns this CreateAlbum Choreo.
     * @return Facebook_Publishing_CreateAlbum New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Publishing/CreateAlbum/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this CreateAlbum Choreo.
     *
     * @param Facebook_Publishing_CreateAlbum_Inputs|array $inputs (optional) Inputs as Facebook_Publishing_CreateAlbum_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Publishing_CreateAlbum_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Publishing_CreateAlbum_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this CreateAlbum Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Publishing_CreateAlbum_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Publishing_CreateAlbum_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the CreateAlbum Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Publishing_CreateAlbum_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the CreateAlbum Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Publishing_CreateAlbum_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this CreateAlbum input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Publishing_CreateAlbum_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Publishing_CreateAlbum_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this CreateAlbum Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Publishing_CreateAlbum_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the Message input for this CreateAlbum Choreo.
     *
     * @param string $value (optional, string) A message to attach to the album.
     * @return Facebook_Publishing_CreateAlbum_Inputs For method chaining.
     */
    public function setMessage($value)
    {
        return $this->set('Message', $value);
    }

    /**
     * Set the value for the Name input for this CreateAlbum Choreo.
     *
     * @param string $value (required, string) The name of the album.
     * @return Facebook_Publishing_CreateAlbum_Inputs For method chaining.
     */
    public function setName($value)
    {
        return $this->set('Name', $value);
    }

    /**
     * Set the value for the ProfileID input for this CreateAlbum Choreo.
     *
     * @param string $value (optional, string) The id for the profile that the album will be published to. Defaults to "me" indicating the authenticated user.
     * @return Facebook_Publishing_CreateAlbum_Inputs For method chaining.
     */
    public function setProfileID($value)
    {
        return $this->set('ProfileID', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this CreateAlbum Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Can be set to xml or json. Defaults to json.
     * @return Facebook_Publishing_CreateAlbum_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }
}


/**
 * Execution object for the CreateAlbum Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Publishing_CreateAlbum_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the CreateAlbum Choreo.
     *
     * @param Temboo_Session $session The session that owns this CreateAlbum execution.
     * @param Facebook_Publishing_CreateAlbum $choreo The choreography object for this execution.
     * @param Facebook_Publishing_CreateAlbum_Inputs|array $inputs (optional) Inputs as Facebook_Publishing_CreateAlbum_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Publishing_CreateAlbum_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Publishing_CreateAlbum $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this CreateAlbum execution.
     *
     * @return Facebook_Publishing_CreateAlbum_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this CreateAlbum execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Publishing_CreateAlbum_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Publishing_CreateAlbum_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the CreateAlbum Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Publishing_CreateAlbum_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the CreateAlbum Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Publishing_CreateAlbum_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this CreateAlbum execution.
     *
     * @return string The response from Facebook. Corresponds to the ResponseFormat input. Defaults to JSON.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Creates a status update associated with  a location represented by a Page.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Publishing_CreateCheckin extends Temboo_Choreography
{
    /**
     * Creates a status update associated with  a location represented by a Page.
     *
     * @param Temboo_Session $session The session that owns this CreateCheckin Choreo.
     * @return Facebook_Publishing_CreateCheckin New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Publishing/CreateCheckin/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this CreateCheckin Choreo.
     *
     * @param Facebook_Publishing_CreateCheckin_Inputs|array $inputs (optional) Inputs as Facebook_Publishing_CreateCheckin_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Publishing_CreateCheckin_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Publishing_CreateCheckin_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this CreateCheckin Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Publishing_CreateCheckin_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Publishing_CreateCheckin_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the CreateCheckin Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Publishing_CreateCheckin_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the CreateCheckin Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Publishing_CreateCheckin_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this CreateCheckin input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Publishing_CreateCheckin_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Publishing_CreateCheckin_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this CreateCheckin Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Publishing_CreateCheckin_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the Latitude input for this CreateCheckin Choreo.
     *
     * @param float $value (optional, decimal) Deprecated (retained for backward compatibility only).
     * @return Facebook_Publishing_CreateCheckin_Inputs For method chaining.
     */
    public function setLatitude($value)
    {
        return $this->set('Latitude', $value);
    }

    /**
     * Set the value for the Longitude input for this CreateCheckin Choreo.
     *
     * @param float $value (optional, decimal) Deprecated (retained for backward compatibility only).
     * @return Facebook_Publishing_CreateCheckin_Inputs For method chaining.
     */
    public function setLongitude($value)
    {
        return $this->set('Longitude', $value);
    }

    /**
     * Set the value for the Message input for this CreateCheckin Choreo.
     *
     * @param string $value (optional, string) A message to include with the Checkin.
     * @return Facebook_Publishing_CreateCheckin_Inputs For method chaining.
     */
    public function setMessage($value)
    {
        return $this->set('Message', $value);
    }

    /**
     * Set the value for the PlaceID input for this CreateCheckin Choreo.
     *
     * @param string $value (conditional, string) The ID of the place associated with your Checkin.
     * @return Facebook_Publishing_CreateCheckin_Inputs For method chaining.
     */
    public function setPlaceID($value)
    {
        return $this->set('PlaceID', $value);
    }

    /**
     * Set the value for the ProfileID input for this CreateCheckin Choreo.
     *
     * @param string $value (optional, string) The id of the profile to create a checkin for. Defaults to "me" indicating the authenticated user.
     * @return Facebook_Publishing_CreateCheckin_Inputs For method chaining.
     */
    public function setProfileID($value)
    {
        return $this->set('ProfileID', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this CreateCheckin Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Can be set to xml or json. Defaults to json.
     * @return Facebook_Publishing_CreateCheckin_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }

    /**
     * Set the value for the Tags input for this CreateCheckin Choreo.
     *
     * @param string $value (optional, string) A comma-separated list of user IDs of people tagged in this post.
     * @return Facebook_Publishing_CreateCheckin_Inputs For method chaining.
     */
    public function setTags($value)
    {
        return $this->set('Tags', $value);
    }
}


/**
 * Execution object for the CreateCheckin Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Publishing_CreateCheckin_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the CreateCheckin Choreo.
     *
     * @param Temboo_Session $session The session that owns this CreateCheckin execution.
     * @param Facebook_Publishing_CreateCheckin $choreo The choreography object for this execution.
     * @param Facebook_Publishing_CreateCheckin_Inputs|array $inputs (optional) Inputs as Facebook_Publishing_CreateCheckin_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Publishing_CreateCheckin_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Publishing_CreateCheckin $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this CreateCheckin execution.
     *
     * @return Facebook_Publishing_CreateCheckin_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this CreateCheckin execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Publishing_CreateCheckin_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Publishing_CreateCheckin_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the CreateCheckin Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Publishing_CreateCheckin_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the CreateCheckin Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Publishing_CreateCheckin_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this CreateCheckin execution.
     *
     * @return string The response from Facebook. Corresponds to the ResponseFormat input. Defaults to JSON.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Allows a user to leave a comment on a specified Graph API object.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Publishing_LeaveComment extends Temboo_Choreography
{
    /**
     * Allows a user to leave a comment on a specified Graph API object.
     *
     * @param Temboo_Session $session The session that owns this LeaveComment Choreo.
     * @return Facebook_Publishing_LeaveComment New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Publishing/LeaveComment/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this LeaveComment Choreo.
     *
     * @param Facebook_Publishing_LeaveComment_Inputs|array $inputs (optional) Inputs as Facebook_Publishing_LeaveComment_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Publishing_LeaveComment_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Publishing_LeaveComment_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this LeaveComment Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Publishing_LeaveComment_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Publishing_LeaveComment_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the LeaveComment Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Publishing_LeaveComment_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the LeaveComment Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Publishing_LeaveComment_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this LeaveComment input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Publishing_LeaveComment_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Publishing_LeaveComment_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this LeaveComment Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Publishing_LeaveComment_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the Message input for this LeaveComment Choreo.
     *
     * @param string $value (required, string) The comment text.
     * @return Facebook_Publishing_LeaveComment_Inputs For method chaining.
     */
    public function setMessage($value)
    {
        return $this->set('Message', $value);
    }

    /**
     * Set the value for the ObjectID input for this LeaveComment Choreo.
     *
     * @param string $value (required, string) The id of a graph api object to comment on.
     * @return Facebook_Publishing_LeaveComment_Inputs For method chaining.
     */
    public function setObjectID($value)
    {
        return $this->set('ObjectID', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this LeaveComment Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Can be set to xml or json. Defaults to json.
     * @return Facebook_Publishing_LeaveComment_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }
}


/**
 * Execution object for the LeaveComment Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Publishing_LeaveComment_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the LeaveComment Choreo.
     *
     * @param Temboo_Session $session The session that owns this LeaveComment execution.
     * @param Facebook_Publishing_LeaveComment $choreo The choreography object for this execution.
     * @param Facebook_Publishing_LeaveComment_Inputs|array $inputs (optional) Inputs as Facebook_Publishing_LeaveComment_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Publishing_LeaveComment_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Publishing_LeaveComment $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this LeaveComment execution.
     *
     * @return Facebook_Publishing_LeaveComment_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this LeaveComment execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Publishing_LeaveComment_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Publishing_LeaveComment_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the LeaveComment Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Publishing_LeaveComment_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the LeaveComment Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Publishing_LeaveComment_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this LeaveComment execution.
     *
     * @return string The response from Facebook. Corresponds to the ResponseFormat input. Defaults to JSON.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Allows a user to "like" a Graph API object.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Publishing_Like extends Temboo_Choreography
{
    /**
     * Allows a user to "like" a Graph API object.
     *
     * @param Temboo_Session $session The session that owns this Like Choreo.
     * @return Facebook_Publishing_Like New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Publishing/Like/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this Like Choreo.
     *
     * @param Facebook_Publishing_Like_Inputs|array $inputs (optional) Inputs as Facebook_Publishing_Like_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Publishing_Like_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Publishing_Like_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this Like Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Publishing_Like_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Publishing_Like_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the Like Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Publishing_Like_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the Like Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Publishing_Like_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this Like input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Publishing_Like_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Publishing_Like_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this Like Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Publishing_Like_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ObjectID input for this Like Choreo.
     *
     * @param string $value (required, string) The id of a graph api object to like.
     * @return Facebook_Publishing_Like_Inputs For method chaining.
     */
    public function setObjectID($value)
    {
        return $this->set('ObjectID', $value);
    }
}


/**
 * Execution object for the Like Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Publishing_Like_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the Like Choreo.
     *
     * @param Temboo_Session $session The session that owns this Like execution.
     * @param Facebook_Publishing_Like $choreo The choreography object for this execution.
     * @param Facebook_Publishing_Like_Inputs|array $inputs (optional) Inputs as Facebook_Publishing_Like_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Publishing_Like_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Publishing_Like $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this Like execution.
     *
     * @return Facebook_Publishing_Like_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this Like execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Publishing_Like_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Publishing_Like_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the Like Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Publishing_Like_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the Like Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Publishing_Like_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this Like execution.
     *
     * @return bool (boolean) The response from Facebook. Returns "true" on success.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Adds an entry to a user's profile feed.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Publishing_Post extends Temboo_Choreography
{
    /**
     * Adds an entry to a user's profile feed.
     *
     * @param Temboo_Session $session The session that owns this Post Choreo.
     * @return Facebook_Publishing_Post New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Publishing/Post/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this Post Choreo.
     *
     * @param Facebook_Publishing_Post_Inputs|array $inputs (optional) Inputs as Facebook_Publishing_Post_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Publishing_Post_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Publishing_Post_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this Post Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Publishing_Post_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Publishing_Post_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the Post Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Publishing_Post_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the Post Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Publishing_Post_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this Post input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Publishing_Post_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Publishing_Post_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this Post Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Publishing_Post_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the Caption input for this Post Choreo.
     *
     * @param string $value (optional, string) Caption of the post (only used if link is specified).
     * @return Facebook_Publishing_Post_Inputs For method chaining.
     */
    public function setCaption($value)
    {
        return $this->set('Caption', $value);
    }

    /**
     * Set the value for the Description input for this Post Choreo.
     *
     * @param string $value (optional, string) Description of the post (only used if link is specified).
     * @return Facebook_Publishing_Post_Inputs For method chaining.
     */
    public function setDescription($value)
    {
        return $this->set('Description', $value);
    }

    /**
     * Set the value for the Link input for this Post Choreo.
     *
     * @param string $value (conditional, string) Link to Post. Supply either a message or a link
     * @return Facebook_Publishing_Post_Inputs For method chaining.
     */
    public function setLink($value)
    {
        return $this->set('Link', $value);
    }

    /**
     * Set the value for the Message input for this Post Choreo.
     *
     * @param string $value (required, string) The message to Post. Supply either a message or a link.
     * @return Facebook_Publishing_Post_Inputs For method chaining.
     */
    public function setMessage($value)
    {
        return $this->set('Message', $value);
    }

    /**
     * Set the value for the Name input for this Post Choreo.
     *
     * @param string $value (optional, string) Name of the post (only used if link is specified).
     * @return Facebook_Publishing_Post_Inputs For method chaining.
     */
    public function setName($value)
    {
        return $this->set('Name', $value);
    }

    /**
     * Set the value for the Picture input for this Post Choreo.
     *
     * @param string $value (optional, string) Post thumbnail image (only used if link is specified).
     * @return Facebook_Publishing_Post_Inputs For method chaining.
     */
    public function setPicture($value)
    {
        return $this->set('Picture', $value);
    }

    /**
     * Set the value for the PlaceID input for this Post Choreo.
     *
     * @param string $value (optional, string) Facebook Page ID of the location associated with this post.
     * @return Facebook_Publishing_Post_Inputs For method chaining.
     */
    public function setPlaceID($value)
    {
        return $this->set('PlaceID', $value);
    }

    /**
     * Set the value for the ProfileID input for this Post Choreo.
     *
     * @param string $value (optional, string) The id of the profile that is being updated. Defaults to "me" indicating the authenticated user.
     * @return Facebook_Publishing_Post_Inputs For method chaining.
     */
    public function setProfileID($value)
    {
        return $this->set('ProfileID', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this Post Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Can be set to xml or json. Defaults to json.
     * @return Facebook_Publishing_Post_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }

    /**
     * Set the value for the Tags input for this Post Choreo.
     *
     * @param string $value (optional, string) Comma-separated list of Facebook IDs of people tagged in this Post. NOTE: You cannot specify this field without also specifying a place.
     * @return Facebook_Publishing_Post_Inputs For method chaining.
     */
    public function setTags($value)
    {
        return $this->set('Tags', $value);
    }
}


/**
 * Execution object for the Post Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Publishing_Post_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the Post Choreo.
     *
     * @param Temboo_Session $session The session that owns this Post execution.
     * @param Facebook_Publishing_Post $choreo The choreography object for this execution.
     * @param Facebook_Publishing_Post_Inputs|array $inputs (optional) Inputs as Facebook_Publishing_Post_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Publishing_Post_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Publishing_Post $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this Post execution.
     *
     * @return Facebook_Publishing_Post_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this Post execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Publishing_Post_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Publishing_Post_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the Post Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Publishing_Post_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the Post Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Publishing_Post_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this Post execution.
     *
     * @return string The response from Facebook. Corresponds to the ResponseFormat input. Defaults to JSON.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Publishes a link on a given profile.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Publishing_PublishLink extends Temboo_Choreography
{
    /**
     * Publishes a link on a given profile.
     *
     * @param Temboo_Session $session The session that owns this PublishLink Choreo.
     * @return Facebook_Publishing_PublishLink New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Publishing/PublishLink/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this PublishLink Choreo.
     *
     * @param Facebook_Publishing_PublishLink_Inputs|array $inputs (optional) Inputs as Facebook_Publishing_PublishLink_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Publishing_PublishLink_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Publishing_PublishLink_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this PublishLink Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Publishing_PublishLink_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Publishing_PublishLink_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the PublishLink Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Publishing_PublishLink_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the PublishLink Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Publishing_PublishLink_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this PublishLink input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Publishing_PublishLink_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Publishing_PublishLink_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this PublishLink Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Publishing_PublishLink_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the Caption input for this PublishLink Choreo.
     *
     * @param string $value (optional, string) Deprecated (retained for backward compatibility only).
     * @return Facebook_Publishing_PublishLink_Inputs For method chaining.
     */
    public function setCaption($value)
    {
        return $this->set('Caption', $value);
    }

    /**
     * Set the value for the Description input for this PublishLink Choreo.
     *
     * @param string $value (optional, string) Deprecated (retained for backward compatibility only).
     * @return Facebook_Publishing_PublishLink_Inputs For method chaining.
     */
    public function setDescription($value)
    {
        return $this->set('Description', $value);
    }

    /**
     * Set the value for the Link input for this PublishLink Choreo.
     *
     * @param string $value (required, string) The link to publish.
     * @return Facebook_Publishing_PublishLink_Inputs For method chaining.
     */
    public function setLink($value)
    {
        return $this->set('Link', $value);
    }

    /**
     * Set the value for the Message input for this PublishLink Choreo.
     *
     * @param string $value (optional, string) A message about the link.
     * @return Facebook_Publishing_PublishLink_Inputs For method chaining.
     */
    public function setMessage($value)
    {
        return $this->set('Message', $value);
    }

    /**
     * Set the value for the Name input for this PublishLink Choreo.
     *
     * @param string $value (optional, string) Deprecated (retained for backward compatibility only).
     * @return Facebook_Publishing_PublishLink_Inputs For method chaining.
     */
    public function setName($value)
    {
        return $this->set('Name', $value);
    }

    /**
     * Set the value for the Picture input for this PublishLink Choreo.
     *
     * @param string $value (optional, string) Deprecated (retained for backward compatibility only).
     * @return Facebook_Publishing_PublishLink_Inputs For method chaining.
     */
    public function setPicture($value)
    {
        return $this->set('Picture', $value);
    }

    /**
     * Set the value for the ProfileID input for this PublishLink Choreo.
     *
     * @param string $value (optional, string) The id of the profile that the link will be published to. Defaults to "me" indicating the authenticated user.
     * @return Facebook_Publishing_PublishLink_Inputs For method chaining.
     */
    public function setProfileID($value)
    {
        return $this->set('ProfileID', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this PublishLink Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Can be set to xml or json. Defaults to json.
     * @return Facebook_Publishing_PublishLink_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }
}


/**
 * Execution object for the PublishLink Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Publishing_PublishLink_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the PublishLink Choreo.
     *
     * @param Temboo_Session $session The session that owns this PublishLink execution.
     * @param Facebook_Publishing_PublishLink $choreo The choreography object for this execution.
     * @param Facebook_Publishing_PublishLink_Inputs|array $inputs (optional) Inputs as Facebook_Publishing_PublishLink_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Publishing_PublishLink_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Publishing_PublishLink $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this PublishLink execution.
     *
     * @return Facebook_Publishing_PublishLink_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this PublishLink execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Publishing_PublishLink_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Publishing_PublishLink_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the PublishLink Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Publishing_PublishLink_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the PublishLink Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Publishing_PublishLink_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this PublishLink execution.
     *
     * @return string The response from Facebook. Corresponds to the ResponseFormat input. Defaults to JSON.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * RSVP to an event as "attending", "maybe", or "declined".
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Publishing_RSVPEvent extends Temboo_Choreography
{
    /**
     * RSVP to an event as "attending", "maybe", or "declined".
     *
     * @param Temboo_Session $session The session that owns this RSVPEvent Choreo.
     * @return Facebook_Publishing_RSVPEvent New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Publishing/RSVPEvent/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this RSVPEvent Choreo.
     *
     * @param Facebook_Publishing_RSVPEvent_Inputs|array $inputs (optional) Inputs as Facebook_Publishing_RSVPEvent_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Publishing_RSVPEvent_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Publishing_RSVPEvent_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this RSVPEvent Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Publishing_RSVPEvent_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Publishing_RSVPEvent_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the RSVPEvent Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Publishing_RSVPEvent_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the RSVPEvent Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Publishing_RSVPEvent_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this RSVPEvent input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Publishing_RSVPEvent_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Publishing_RSVPEvent_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this RSVPEvent Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Publishing_RSVPEvent_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the EventID input for this RSVPEvent Choreo.
     *
     * @param string $value (required, string) The id for the event  to rsvp for.
     * @return Facebook_Publishing_RSVPEvent_Inputs For method chaining.
     */
    public function setEventID($value)
    {
        return $this->set('EventID', $value);
    }

    /**
     * Set the value for the RSVP input for this RSVPEvent Choreo.
     *
     * @param string $value (required, string) The RSVP for the event. Valid values are: attending, maybe, or declined.
     * @return Facebook_Publishing_RSVPEvent_Inputs For method chaining.
     */
    public function setRSVP($value)
    {
        return $this->set('RSVP', $value);
    }
}


/**
 * Execution object for the RSVPEvent Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Publishing_RSVPEvent_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the RSVPEvent Choreo.
     *
     * @param Temboo_Session $session The session that owns this RSVPEvent execution.
     * @param Facebook_Publishing_RSVPEvent $choreo The choreography object for this execution.
     * @param Facebook_Publishing_RSVPEvent_Inputs|array $inputs (optional) Inputs as Facebook_Publishing_RSVPEvent_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Publishing_RSVPEvent_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Publishing_RSVPEvent $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this RSVPEvent execution.
     *
     * @return Facebook_Publishing_RSVPEvent_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this RSVPEvent execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Publishing_RSVPEvent_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Publishing_RSVPEvent_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the RSVPEvent Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Publishing_RSVPEvent_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the RSVPEvent Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Publishing_RSVPEvent_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this RSVPEvent execution.
     *
     * @return string The response from Facebook. Corresponds to the ResponseFormat input. Defaults to JSON.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Updates a user's Facebook status.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Publishing_SetStatus extends Temboo_Choreography
{
    /**
     * Updates a user's Facebook status.
     *
     * @param Temboo_Session $session The session that owns this SetStatus Choreo.
     * @return Facebook_Publishing_SetStatus New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Publishing/SetStatus/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this SetStatus Choreo.
     *
     * @param Facebook_Publishing_SetStatus_Inputs|array $inputs (optional) Inputs as Facebook_Publishing_SetStatus_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Publishing_SetStatus_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Publishing_SetStatus_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this SetStatus Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Publishing_SetStatus_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Publishing_SetStatus_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the SetStatus Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Publishing_SetStatus_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the SetStatus Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Publishing_SetStatus_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this SetStatus input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Publishing_SetStatus_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Publishing_SetStatus_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this SetStatus Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Publishing_SetStatus_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the Message input for this SetStatus Choreo.
     *
     * @param string $value (required, string) The status message to set.
     * @return Facebook_Publishing_SetStatus_Inputs For method chaining.
     */
    public function setMessage($value)
    {
        return $this->set('Message', $value);
    }

    /**
     * Set the value for the ProfileID input for this SetStatus Choreo.
     *
     * @param string $value (optional, string) The id of the profile that is being updated. Defaults to "me" indicating the authenticated user.
     * @return Facebook_Publishing_SetStatus_Inputs For method chaining.
     */
    public function setProfileID($value)
    {
        return $this->set('ProfileID', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this SetStatus Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Can be set to xml or json. Defaults to json.
     * @return Facebook_Publishing_SetStatus_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }
}


/**
 * Execution object for the SetStatus Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Publishing_SetStatus_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the SetStatus Choreo.
     *
     * @param Temboo_Session $session The session that owns this SetStatus execution.
     * @param Facebook_Publishing_SetStatus $choreo The choreography object for this execution.
     * @param Facebook_Publishing_SetStatus_Inputs|array $inputs (optional) Inputs as Facebook_Publishing_SetStatus_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Publishing_SetStatus_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Publishing_SetStatus $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this SetStatus execution.
     *
     * @return Facebook_Publishing_SetStatus_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this SetStatus execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Publishing_SetStatus_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Publishing_SetStatus_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the SetStatus Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Publishing_SetStatus_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the SetStatus Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Publishing_SetStatus_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this SetStatus execution.
     *
     * @return string The response from Facebook. Corresponds to the ResponseFormat input. Defaults to JSON.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Uploads a photo to a given album.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Publishing_UploadPhoto extends Temboo_Choreography
{
    /**
     * Uploads a photo to a given album.
     *
     * @param Temboo_Session $session The session that owns this UploadPhoto Choreo.
     * @return Facebook_Publishing_UploadPhoto New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Publishing/UploadPhoto/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this UploadPhoto Choreo.
     *
     * @param Facebook_Publishing_UploadPhoto_Inputs|array $inputs (optional) Inputs as Facebook_Publishing_UploadPhoto_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Publishing_UploadPhoto_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Publishing_UploadPhoto_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this UploadPhoto Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Publishing_UploadPhoto_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Publishing_UploadPhoto_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the UploadPhoto Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Publishing_UploadPhoto_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the UploadPhoto Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Publishing_UploadPhoto_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this UploadPhoto input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Publishing_UploadPhoto_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Publishing_UploadPhoto_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this UploadPhoto Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Publishing_UploadPhoto_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the AlbumID input for this UploadPhoto Choreo.
     *
     * @param string $value (optional, string) The id of the album to upload the photo to.
     * @return Facebook_Publishing_UploadPhoto_Inputs For method chaining.
     */
    public function setAlbumID($value)
    {
        return $this->set('AlbumID', $value);
    }

    /**
     * Set the value for the Message input for this UploadPhoto Choreo.
     *
     * @param string $value (optional, string) A message to attach to the photo.
     * @return Facebook_Publishing_UploadPhoto_Inputs For method chaining.
     */
    public function setMessage($value)
    {
        return $this->set('Message', $value);
    }

    /**
     * Set the value for the Photo input for this UploadPhoto Choreo.
     *
     * @param string $value (conditional, string) The Base64 encoded image to upload. This is required unless using the URL input to publish the photo.
     * @return Facebook_Publishing_UploadPhoto_Inputs For method chaining.
     */
    public function setPhoto($value)
    {
        return $this->set('Photo', $value);
    }

    /**
     * Set the value for the Place input for this UploadPhoto Choreo.
     *
     * @param string $value (optional, string) The ID of a location where the photo was taken.
     * @return Facebook_Publishing_UploadPhoto_Inputs For method chaining.
     */
    public function setPlace($value)
    {
        return $this->set('Place', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this UploadPhoto Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Can be set to xml or json. Defaults to json.
     * @return Facebook_Publishing_UploadPhoto_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }

    /**
     * Set the value for the Source input for this UploadPhoto Choreo.
     *
     * @param string $value (optional, string) Deprecated (retained for backward compatibility only).
     * @return Facebook_Publishing_UploadPhoto_Inputs For method chaining.
     */
    public function setSource($value)
    {
        return $this->set('Source', $value);
    }

    /**
     * Set the value for the URL input for this UploadPhoto Choreo.
     *
     * @param string $value (conditional, string) A URL to a hosted photo that should be uploaded. This is required unless providing a Base64 encoded image for the Photo input.
     * @return Facebook_Publishing_UploadPhoto_Inputs For method chaining.
     */
    public function setURL($value)
    {
        return $this->set('URL', $value);
    }

}


/**
 * Execution object for the UploadPhoto Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Publishing_UploadPhoto_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the UploadPhoto Choreo.
     *
     * @param Temboo_Session $session The session that owns this UploadPhoto execution.
     * @param Facebook_Publishing_UploadPhoto $choreo The choreography object for this execution.
     * @param Facebook_Publishing_UploadPhoto_Inputs|array $inputs (optional) Inputs as Facebook_Publishing_UploadPhoto_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Publishing_UploadPhoto_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Publishing_UploadPhoto $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this UploadPhoto execution.
     *
     * @return Facebook_Publishing_UploadPhoto_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this UploadPhoto execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Publishing_UploadPhoto_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Publishing_UploadPhoto_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the UploadPhoto Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Publishing_UploadPhoto_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the UploadPhoto Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Publishing_UploadPhoto_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this UploadPhoto execution.
     *
     * @return string The response from Facebook. Corresponds to the ResponseFormat input. Defaults to JSON.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Retrieves a list of the Facebook apps and pages owned by the specified user.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Reading_Accounts extends Temboo_Choreography
{
    /**
     * Retrieves a list of the Facebook apps and pages owned by the specified user.
     *
     * @param Temboo_Session $session The session that owns this Accounts Choreo.
     * @return Facebook_Reading_Accounts New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Reading/Accounts/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this Accounts Choreo.
     *
     * @param Facebook_Reading_Accounts_Inputs|array $inputs (optional) Inputs as Facebook_Reading_Accounts_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Reading_Accounts_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Reading_Accounts_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this Accounts Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Reading_Accounts_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Reading_Accounts_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the Accounts Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Reading_Accounts_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the Accounts Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Reading_Accounts_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this Accounts input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Reading_Accounts_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Reading_Accounts_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this Accounts Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Reading_Accounts_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the Fields input for this Accounts Choreo.
     *
     * @param string $value (optional, string) A comma separated list of fields to return (i.e. id,name).
     * @return Facebook_Reading_Accounts_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Limit input for this Accounts Choreo.
     *
     * @param int $value (optional, integer) Used to page through results. Limits the number of records returned in the response.
     * @return Facebook_Reading_Accounts_Inputs For method chaining.
     */
    public function setLimit($value)
    {
        return $this->set('Limit', $value);
    }

    /**
     * Set the value for the Offset input for this Accounts Choreo.
     *
     * @param int $value (optional, integer) Used to page through results. Returns results starting from the specified number.
     * @return Facebook_Reading_Accounts_Inputs For method chaining.
     */
    public function setOffset($value)
    {
        return $this->set('Offset', $value);
    }

    /**
     * Set the value for the ProfileID input for this Accounts Choreo.
     *
     * @param string $value (optional, string) The id of the user to retrieve account info for. Defaults to "me" indicating the authenticated user.
     * @return Facebook_Reading_Accounts_Inputs For method chaining.
     */
    public function setProfileID($value)
    {
        return $this->set('ProfileID', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this Accounts Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Can be set to xml or json. Defaults to json.
     * @return Facebook_Reading_Accounts_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }
}


/**
 * Execution object for the Accounts Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Reading_Accounts_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the Accounts Choreo.
     *
     * @param Temboo_Session $session The session that owns this Accounts execution.
     * @param Facebook_Reading_Accounts $choreo The choreography object for this execution.
     * @param Facebook_Reading_Accounts_Inputs|array $inputs (optional) Inputs as Facebook_Reading_Accounts_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Reading_Accounts_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Reading_Accounts $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this Accounts execution.
     *
     * @return Facebook_Reading_Accounts_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this Accounts execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Reading_Accounts_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Reading_Accounts_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the Accounts Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Reading_Accounts_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the Accounts Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Reading_Accounts_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "HasNext" output from this Accounts execution.
     *
     * @return bool (boolean) A boolean flag indicating that a next page exists.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getHasNext()
    {
        return $this->get('HasNext');
    }
    /**
     * Retrieve the value for the "HasPrevious" output from this Accounts execution.
     *
     * @return bool (boolean) A boolean flag indicating that a previous page exists.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getHasPrevious()
    {
        return $this->get('HasPrevious');
    }
    /**
     * Retrieve the value for the "Response" output from this Accounts execution.
     *
     * @return string The response from Facebook. Corresponds to the ResponseFormat input. Defaults to JSON.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Retrieves a list of books that a given user has liked.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Reading_Books extends Temboo_Choreography
{
    /**
     * Retrieves a list of books that a given user has liked.
     *
     * @param Temboo_Session $session The session that owns this Books Choreo.
     * @return Facebook_Reading_Books New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Reading/Books/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this Books Choreo.
     *
     * @param Facebook_Reading_Books_Inputs|array $inputs (optional) Inputs as Facebook_Reading_Books_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Reading_Books_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Reading_Books_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this Books Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Reading_Books_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Reading_Books_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the Books Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Reading_Books_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the Books Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Reading_Books_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this Books input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Reading_Books_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Reading_Books_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this Books Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Reading_Books_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the Fields input for this Books Choreo.
     *
     * @param string $value (optional, string) A comma separated list of fields to return (i.e. id,name).
     * @return Facebook_Reading_Books_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Limit input for this Books Choreo.
     *
     * @param int $value (optional, integer) Used to page through results. Limits the number of records returned in the response.
     * @return Facebook_Reading_Books_Inputs For method chaining.
     */
    public function setLimit($value)
    {
        return $this->set('Limit', $value);
    }

    /**
     * Set the value for the Offset input for this Books Choreo.
     *
     * @param int $value (optional, integer) Used to page through results. Returns results starting from the specified number.
     * @return Facebook_Reading_Books_Inputs For method chaining.
     */
    public function setOffset($value)
    {
        return $this->set('Offset', $value);
    }

    /**
     * Set the value for the ProfileID input for this Books Choreo.
     *
     * @param string $value (optional, string) The id of the user to retrieve books for. Defaults to "me" indicating the authenticated user.
     * @return Facebook_Reading_Books_Inputs For method chaining.
     */
    public function setProfileID($value)
    {
        return $this->set('ProfileID', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this Books Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Can be set to xml or json. Defaults to json.
     * @return Facebook_Reading_Books_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }

    /**
     * Set the value for the Since input for this Books Choreo.
     *
     * @param string $value (optional, date) Used for time-based pagination. Values can be a unix timestamp or any date accepted by strtotime.
     * @return Facebook_Reading_Books_Inputs For method chaining.
     */
    public function setSince($value)
    {
        return $this->set('Since', $value);
    }

    /**
     * Set the value for the Until input for this Books Choreo.
     *
     * @param string $value (optional, date) Used for time-based pagination. Values can be a unix timestamp or any date accepted by strtotime.
     * @return Facebook_Reading_Books_Inputs For method chaining.
     */
    public function setUntil($value)
    {
        return $this->set('Until', $value);
    }
}


/**
 * Execution object for the Books Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Reading_Books_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the Books Choreo.
     *
     * @param Temboo_Session $session The session that owns this Books execution.
     * @param Facebook_Reading_Books $choreo The choreography object for this execution.
     * @param Facebook_Reading_Books_Inputs|array $inputs (optional) Inputs as Facebook_Reading_Books_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Reading_Books_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Reading_Books $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this Books execution.
     *
     * @return Facebook_Reading_Books_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this Books execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Reading_Books_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Reading_Books_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the Books Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Reading_Books_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the Books Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Reading_Books_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "HasNext" output from this Books execution.
     *
     * @return bool (boolean) A boolean flag indicating that a next page exists.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getHasNext()
    {
        return $this->get('HasNext');
    }
    /**
     * Retrieve the value for the "HasPrevious" output from this Books execution.
     *
     * @return bool (boolean) A boolean flag indicating that a previous page exists.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getHasPrevious()
    {
        return $this->get('HasPrevious');
    }
    /**
     * Retrieve the value for the "Response" output from this Books execution.
     *
     * @return string The response from Facebook. Corresponds to the ResponseFormat input. Defaults to JSON.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Retrieves comments for a specified Graph API object.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Reading_Comments extends Temboo_Choreography
{
    /**
     * Retrieves comments for a specified Graph API object.
     *
     * @param Temboo_Session $session The session that owns this Comments Choreo.
     * @return Facebook_Reading_Comments New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Reading/Comments/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this Comments Choreo.
     *
     * @param Facebook_Reading_Comments_Inputs|array $inputs (optional) Inputs as Facebook_Reading_Comments_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Reading_Comments_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Reading_Comments_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this Comments Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Reading_Comments_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Reading_Comments_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the Comments Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Reading_Comments_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the Comments Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Reading_Comments_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this Comments input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Reading_Comments_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Reading_Comments_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this Comments Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Reading_Comments_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the Fields input for this Comments Choreo.
     *
     * @param string $value (optional, string) A comma separated list of fields to return (i.e. id,name).
     * @return Facebook_Reading_Comments_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Filter input for this Comments Choreo.
     *
     * @param string $value (optional, string) Filters comments. Use "toplevel" to return comments on a post, but not replies to comments. Use "stream" to return comments and replies.
     * @return Facebook_Reading_Comments_Inputs For method chaining.
     */
    public function setFilter($value)
    {
        return $this->set('Filter', $value);
    }

    /**
     * Set the value for the Limt input for this Comments Choreo.
     *
     * @param int $value (optional, integer) Used to page through results. Limits the number of records returned in the response.
     * @return Facebook_Reading_Comments_Inputs For method chaining.
     */
    public function setLimt($value)
    {
        return $this->set('Limt', $value);
    }

    /**
     * Set the value for the ObjectID input for this Comments Choreo.
     *
     * @param string $value (required, string) The id of a graph api object to get comments for.
     * @return Facebook_Reading_Comments_Inputs For method chaining.
     */
    public function setObjectID($value)
    {
        return $this->set('ObjectID', $value);
    }

    /**
     * Set the value for the Offset input for this Comments Choreo.
     *
     * @param int $value (optional, integer) Used to page through results. Returns results starting from the specified number.
     * @return Facebook_Reading_Comments_Inputs For method chaining.
     */
    public function setOffset($value)
    {
        return $this->set('Offset', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this Comments Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Can be set to xml or json. Defaults to json.
     * @return Facebook_Reading_Comments_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }

    /**
     * Set the value for the Since input for this Comments Choreo.
     *
     * @param string $value (optional, date) Used for time-based pagination. Values can be a unix timestamp or any date accepted by strtotime.
     * @return Facebook_Reading_Comments_Inputs For method chaining.
     */
    public function setSince($value)
    {
        return $this->set('Since', $value);
    }

    /**
     * Set the value for the Summary input for this Comments Choreo.
     *
     * @param bool $value (optional, boolean) Shows a summary of metadata about the comments on the object. This metadata includes order which indicates how the comments are being sorted.
     * @return Facebook_Reading_Comments_Inputs For method chaining.
     */
    public function setSummary($value)
    {
        return $this->set('Summary', $value);
    }

    /**
     * Set the value for the Until input for this Comments Choreo.
     *
     * @param string $value (optional, date) Used for time-based pagination. Values can be a unix timestamp or any date accepted by strtotime.
     * @return Facebook_Reading_Comments_Inputs For method chaining.
     */
    public function setUntil($value)
    {
        return $this->set('Until', $value);
    }
}


/**
 * Execution object for the Comments Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Reading_Comments_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the Comments Choreo.
     *
     * @param Temboo_Session $session The session that owns this Comments execution.
     * @param Facebook_Reading_Comments $choreo The choreography object for this execution.
     * @param Facebook_Reading_Comments_Inputs|array $inputs (optional) Inputs as Facebook_Reading_Comments_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Reading_Comments_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Reading_Comments $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this Comments execution.
     *
     * @return Facebook_Reading_Comments_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this Comments execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Reading_Comments_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Reading_Comments_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the Comments Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Reading_Comments_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the Comments Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Reading_Comments_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "HasNext" output from this Comments execution.
     *
     * @return bool (boolean) A boolean flag indicating that a next page exists.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getHasNext()
    {
        return $this->get('HasNext');
    }
    /**
     * Retrieve the value for the "HasPrevious" output from this Comments execution.
     *
     * @return bool (boolean) A boolean flag indicating that a previous page exists.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getHasPrevious()
    {
        return $this->get('HasPrevious');
    }
    /**
     * Retrieve the value for the "Response" output from this Comments execution.
     *
     * @return string The response from Facebook. Corresponds to the ResponseFormat input. Defaults to JSON.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Retrieves a list of events associated with a specified user.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Reading_Events extends Temboo_Choreography
{
    /**
     * Retrieves a list of events associated with a specified user.
     *
     * @param Temboo_Session $session The session that owns this Events Choreo.
     * @return Facebook_Reading_Events New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Reading/Events/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this Events Choreo.
     *
     * @param Facebook_Reading_Events_Inputs|array $inputs (optional) Inputs as Facebook_Reading_Events_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Reading_Events_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Reading_Events_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this Events Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Reading_Events_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Reading_Events_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the Events Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Reading_Events_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the Events Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Reading_Events_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this Events input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Reading_Events_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Reading_Events_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this Events Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final step of the OAuth process.
     * @return Facebook_Reading_Events_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the Fields input for this Events Choreo.
     *
     * @param string $value (optional, string) A comma separated list of fields to return (i.e. id,name).
     * @return Facebook_Reading_Events_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Filter input for this Events Choreo.
     *
     * @param string $value (optional, string) The event sub-category to return. Valid values are: attending, created, maybe, not_replied, or declined.
     * @return Facebook_Reading_Events_Inputs For method chaining.
     */
    public function setFilter($value)
    {
        return $this->set('Filter', $value);
    }

    /**
     * Set the value for the Limit input for this Events Choreo.
     *
     * @param int $value (optional, integer) Used to page through results. Limits the number of records returned in the response.
     * @return Facebook_Reading_Events_Inputs For method chaining.
     */
    public function setLimit($value)
    {
        return $this->set('Limit', $value);
    }

    /**
     * Set the value for the Offset input for this Events Choreo.
     *
     * @param int $value (optional, integer) Used to page through results. Returns results starting from the specified number.
     * @return Facebook_Reading_Events_Inputs For method chaining.
     */
    public function setOffset($value)
    {
        return $this->set('Offset', $value);
    }

    /**
     * Set the value for the ProfileID input for this Events Choreo.
     *
     * @param string $value (optional, string) The id of the profile to retrieve events for. Defaults to "me" indicating authenticated user.
     * @return Facebook_Reading_Events_Inputs For method chaining.
     */
    public function setProfileID($value)
    {
        return $this->set('ProfileID', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this Events Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Can be set to xml or json. Defaults to json.
     * @return Facebook_Reading_Events_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }

    /**
     * Set the value for the Since input for this Events Choreo.
     *
     * @param string $value (optional, date) Used for time-based pagination. Values can be a unix timestamp or any date accepted by strtotime.
     * @return Facebook_Reading_Events_Inputs For method chaining.
     */
    public function setSince($value)
    {
        return $this->set('Since', $value);
    }

    /**
     * Set the value for the Until input for this Events Choreo.
     *
     * @param string $value (optional, date) Used for time-based pagination. Values can be a unix timestamp or any date accepted by strtotime.
     * @return Facebook_Reading_Events_Inputs For method chaining.
     */
    public function setUntil($value)
    {
        return $this->set('Until', $value);
    }
}


/**
 * Execution object for the Events Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Reading_Events_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the Events Choreo.
     *
     * @param Temboo_Session $session The session that owns this Events execution.
     * @param Facebook_Reading_Events $choreo The choreography object for this execution.
     * @param Facebook_Reading_Events_Inputs|array $inputs (optional) Inputs as Facebook_Reading_Events_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Reading_Events_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Reading_Events $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this Events execution.
     *
     * @return Facebook_Reading_Events_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this Events execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Reading_Events_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Reading_Events_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the Events Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Reading_Events_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the Events Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Reading_Events_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "HasNext" output from this Events execution.
     *
     * @return bool (boolean) A boolean flag indicating that a next page exists.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getHasNext()
    {
        return $this->get('HasNext');
    }
    /**
     * Retrieve the value for the "HasPrevious" output from this Events execution.
     *
     * @return bool (boolean) A boolean flag indicating that a previous page exists.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getHasPrevious()
    {
        return $this->get('HasPrevious');
    }
    /**
     * Retrieve the value for the "Response" output from this Events execution.
     *
     * @return string The response from Facebook. Corresponds to the ResponseFormat input. Defaults to JSON.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Retrieves a user's "friend lists".
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Reading_FriendLists extends Temboo_Choreography
{
    /**
     * Retrieves a user's "friend lists".
     *
     * @param Temboo_Session $session The session that owns this FriendLists Choreo.
     * @return Facebook_Reading_FriendLists New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Reading/FriendLists/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this FriendLists Choreo.
     *
     * @param Facebook_Reading_FriendLists_Inputs|array $inputs (optional) Inputs as Facebook_Reading_FriendLists_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Reading_FriendLists_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Reading_FriendLists_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this FriendLists Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Reading_FriendLists_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Reading_FriendLists_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the FriendLists Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Reading_FriendLists_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the FriendLists Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Reading_FriendLists_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this FriendLists input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Reading_FriendLists_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Reading_FriendLists_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this FriendLists Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final OAuth step.
     * @return Facebook_Reading_FriendLists_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the Fields input for this FriendLists Choreo.
     *
     * @param string $value (optional, string) A comma separated list of fields to return (i.e. id,name).
     * @return Facebook_Reading_FriendLists_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Limit input for this FriendLists Choreo.
     *
     * @param int $value (optional, integer) Used to page through results. Limits the number of records returned in the response.
     * @return Facebook_Reading_FriendLists_Inputs For method chaining.
     */
    public function setLimit($value)
    {
        return $this->set('Limit', $value);
    }

    /**
     * Set the value for the Offset input for this FriendLists Choreo.
     *
     * @param int $value (optional, integer) Used to page through results. Returns results starting from the specified number.
     * @return Facebook_Reading_FriendLists_Inputs For method chaining.
     */
    public function setOffset($value)
    {
        return $this->set('Offset', $value);
    }

    /**
     * Set the value for the ProfileID input for this FriendLists Choreo.
     *
     * @param string $value (optional, string) The id of the profile to retrieve friends for. Defaults to "me" indicating the authenticated user.
     * @return Facebook_Reading_FriendLists_Inputs For method chaining.
     */
    public function setProfileID($value)
    {
        return $this->set('ProfileID', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this FriendLists Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Can be set to xml or json. Defaults to json.
     * @return Facebook_Reading_FriendLists_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }
}


/**
 * Execution object for the FriendLists Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Reading_FriendLists_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the FriendLists Choreo.
     *
     * @param Temboo_Session $session The session that owns this FriendLists execution.
     * @param Facebook_Reading_FriendLists $choreo The choreography object for this execution.
     * @param Facebook_Reading_FriendLists_Inputs|array $inputs (optional) Inputs as Facebook_Reading_FriendLists_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Reading_FriendLists_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Reading_FriendLists $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this FriendLists execution.
     *
     * @return Facebook_Reading_FriendLists_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this FriendLists execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Reading_FriendLists_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Reading_FriendLists_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the FriendLists Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Reading_FriendLists_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the FriendLists Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Reading_FriendLists_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "HasNext" output from this FriendLists execution.
     *
     * @return bool (boolean) A boolean flag indicating that a next page exists.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getHasNext()
    {
        return $this->get('HasNext');
    }
    /**
     * Retrieve the value for the "HasPrevious" output from this FriendLists execution.
     *
     * @return bool (boolean) A boolean flag indicating that a previous page exists.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getHasPrevious()
    {
        return $this->get('HasPrevious');
    }
    /**
     * Retrieve the value for the "Response" output from this FriendLists execution.
     *
     * @return string The response from Facebook. Corresponds to the ResponseFormat input. Defaults to JSON.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Retrieves a list of names and profile IDs for Facebook friends associated with a specified user.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Reading_Friends extends Temboo_Choreography
{
    /**
     * Retrieves a list of names and profile IDs for Facebook friends associated with a specified user.
     *
     * @param Temboo_Session $session The session that owns this Friends Choreo.
     * @return Facebook_Reading_Friends New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Reading/Friends/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this Friends Choreo.
     *
     * @param Facebook_Reading_Friends_Inputs|array $inputs (optional) Inputs as Facebook_Reading_Friends_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Reading_Friends_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Reading_Friends_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this Friends Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Reading_Friends_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Facebook_Reading_Friends_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the Friends Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Reading_Friends_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the Friends Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Facebook_Reading_Friends_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this Friends input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Facebook_Reading_Friends_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Facebook_Reading_Friends_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this Friends Choreo.
     *
     * @param string $value (required, string) The access token retrieved from the final OAuth step.
     * @return Facebook_Reading_Friends_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the Fields input for this Friends Choreo.
     *
     * @param string $value (optional, string) A comma separated list of fields to return (i.e. id,name).
     * @return Facebook_Reading_Friends_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Limit input for this Friends Choreo.
     *
     * @param int $value (optional, integer) Used to page through results. Limits the number of records returned in the response.
     * @return Facebook_Reading_Friends_Inputs For method chaining.
     */
    public function setLimit($value)
    {
        return $this->set('Limit', $value);
    }

    /**
     * Set the value for the Offset input for this Friends Choreo.
     *
     * @param int $value (optional, integer) Used to page through results. Returns results starting from the specified number.
     * @return Facebook_Reading_Friends_Inputs For method chaining.
     */
    public function setOffset($value)
    {
        return $this->set('Offset', $value);
    }

    /**
     * Set the value for the ProfileID input for this Friends Choreo.
     *
     * @param string $value (optional, string) The id of the profile to retrieve friends for. Defaults to "me" indicating the authenticated user.
     * @return Facebook_Reading_Friends_Inputs For method chaining.
     */
    public function setProfileID($value)
    {
        return $this->set('ProfileID', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this Friends Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Can be set to xml or json. Defaults to json.
     * @return Facebook_Reading_Friends_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }

    /**
     * Set the value for the Since input for this Friends Choreo.
     *
     * @param string $value (optional, date) Used for time-based pagination. Values can be a unix timestamp or any date accepted by strtotime.
     * @return Facebook_Reading_Friends_Inputs For method chaining.
     */
    public function setSince($value)
    {
        return $this->set('Since', $value);
    }

    /**
     * Set the value for the Until input for this Friends Choreo.
     *
     * @param string $value (optional, date) Used for time-based pagination. Values can be a unix timestamp or any date accepted by strtotime.
     * @return Facebook_Reading_Friends_Inputs For method chaining.
     */
    public function setUntil($value)
    {
        return $this->set('Until', $value);
    }
}


/**
 * Execution object for the Friends Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Reading_Friends_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the Friends Choreo.
     *
     * @param Temboo_Session $session The session that owns this Friends execution.
     * @param Facebook_Reading_Friends $choreo The choreography object for this execution.
     * @param Facebook_Reading_Friends_Inputs|array $inputs (optional) Inputs as Facebook_Reading_Friends_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Reading_Friends_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Facebook_Reading_Friends $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this Friends execution.
     *
     * @return Facebook_Reading_Friends_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this Friends execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Facebook_Reading_Friends_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Facebook_Reading_Friends_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the Friends Choreo.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Reading_Friends_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the Friends Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Facebook_Reading_Friends_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "HasNext" output from this Friends execution.
     *
     * @return bool (boolean) A boolean flag indicating that a next page exists.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getHasNext()
    {
        return $this->get('HasNext');
    }
    /**
     * Retrieve the value for the "HasPrevious" output from this Friends execution.
     *
     * @return bool (boolean) A boolean flag indicating that a previous page exists.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getHasPrevious()
    {
        return $this->get('HasPrevious');
    }
    /**
     * Retrieve the value for the "Response" output from this Friends execution.
     *
     * @return string The response from Facebook. Corresponds to the ResponseFormat input. Defaults to JSON.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Determines whether two people are friends on Facebook.
 *
 * @package Temboo
 * @subpackage Facebook
 */
class Facebook_Reading_FriendshipExists extends Temboo_Choreography
{
    /**
     * Determines whether two people are friends on Facebook.
     *
     * @param Temboo_Session $session The session that owns this FriendshipExists Choreo.
     * @return Facebook_Reading_FriendshipExists New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Facebook/Reading/FriendshipExists/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this FriendshipExists Choreo.
     *
     * @param Facebook_Reading_FriendshipExists_Inputs|array $inputs (optional) Inputs as Facebook_Reading_FriendshipExists_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Facebook_Reading_FriendshipExists_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Facebook_Reading_FriendshipExists_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this FriendshipExists Cho