<?php

/**
 * Temboo PHP SDK Amazon classes
 *
 * Execute Choreographies from the Temboo Amazon bundle.
 *
 * PHP version 5
 *
 * LICENSE: Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   Services
 * @package    Temboo
 * @subpackage Amazon
 * @author     Temboo, Inc.
 * @copyright  2013 Temboo, Inc.
 * @license    http://www.apache.org/licenses/LICENSE-2.0 Apache License 2.0
 * @link       http://www.temboo.com
 */
/**
 * Retrieves account information for the authenticated user.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Account_GetAccountInfo extends Temboo_Choreography
{
    /**
     * Retrieves account information for the authenticated user.
     *
     * @param Temboo_Session $session The session that owns this GetAccountInfo Choreo.
     * @return Amazon_CloudDrive_Account_GetAccountInfo New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/CloudDrive/Account/GetAccountInfo/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this GetAccountInfo Choreo.
     *
     * @param Amazon_CloudDrive_Account_GetAccountInfo_Inputs|array $inputs (optional) Inputs as Amazon_CloudDrive_Account_GetAccountInfo_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_CloudDrive_Account_GetAccountInfo_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_CloudDrive_Account_GetAccountInfo_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this GetAccountInfo Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_CloudDrive_Account_GetAccountInfo_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_CloudDrive_Account_GetAccountInfo_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the GetAccountInfo Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Account_GetAccountInfo_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the GetAccountInfo Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_CloudDrive_Account_GetAccountInfo_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this GetAccountInfo input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_CloudDrive_Account_GetAccountInfo_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_CloudDrive_Account_GetAccountInfo_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this GetAccountInfo Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Amazon_CloudDrive_Account_GetAccountInfo_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this GetAccountInfo Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Amazon. Required unless providing a valid AccessToken.
     * @return Amazon_CloudDrive_Account_GetAccountInfo_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this GetAccountInfo Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Amazon. Required unless providing a valid AccessToken.
     * @return Amazon_CloudDrive_Account_GetAccountInfo_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the RefreshToken input for this GetAccountInfo Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Amazon_CloudDrive_Account_GetAccountInfo_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }
}


/**
 * Execution object for the GetAccountInfo Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Account_GetAccountInfo_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the GetAccountInfo Choreo.
     *
     * @param Temboo_Session $session The session that owns this GetAccountInfo execution.
     * @param Amazon_CloudDrive_Account_GetAccountInfo $choreo The choreography object for this execution.
     * @param Amazon_CloudDrive_Account_GetAccountInfo_Inputs|array $inputs (optional) Inputs as Amazon_CloudDrive_Account_GetAccountInfo_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_CloudDrive_Account_GetAccountInfo_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_CloudDrive_Account_GetAccountInfo $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this GetAccountInfo execution.
     *
     * @return Amazon_CloudDrive_Account_GetAccountInfo_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this GetAccountInfo execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_CloudDrive_Account_GetAccountInfo_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_CloudDrive_Account_GetAccountInfo_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the GetAccountInfo Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Account_GetAccountInfo_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the GetAccountInfo Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_CloudDrive_Account_GetAccountInfo_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this GetAccountInfo execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this GetAccountInfo execution.
     *
     * @return string (json) The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Retrieves the customer end-point against which requests can be executed.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Account_GetEndpoint extends Temboo_Choreography
{
    /**
     * Retrieves the customer end-point against which requests can be executed.
     *
     * @param Temboo_Session $session The session that owns this GetEndpoint Choreo.
     * @return Amazon_CloudDrive_Account_GetEndpoint New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/CloudDrive/Account/GetEndpoint/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this GetEndpoint Choreo.
     *
     * @param Amazon_CloudDrive_Account_GetEndpoint_Inputs|array $inputs (optional) Inputs as Amazon_CloudDrive_Account_GetEndpoint_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_CloudDrive_Account_GetEndpoint_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_CloudDrive_Account_GetEndpoint_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this GetEndpoint Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_CloudDrive_Account_GetEndpoint_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_CloudDrive_Account_GetEndpoint_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the GetEndpoint Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Account_GetEndpoint_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the GetEndpoint Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_CloudDrive_Account_GetEndpoint_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this GetEndpoint input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_CloudDrive_Account_GetEndpoint_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_CloudDrive_Account_GetEndpoint_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this GetEndpoint Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Amazon_CloudDrive_Account_GetEndpoint_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this GetEndpoint Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Amazon. Required unless providing a valid AccessToken.
     * @return Amazon_CloudDrive_Account_GetEndpoint_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this GetEndpoint Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Amazon. Required unless providing a valid AccessToken.
     * @return Amazon_CloudDrive_Account_GetEndpoint_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the HandleRequestThrottling input for this GetEndpoint Choreo.
     *
     * @param bool $value (optional, boolean) Whether or not to perform a retry sequence if a throttling error occurs. Set to true to enable this feature. The request will be retried up-to five times when enabled.
     * @return Amazon_CloudDrive_Account_GetEndpoint_Inputs For method chaining.
     */
    public function setHandleRequestThrottling($value)
    {
        return $this->set('HandleRequestThrottling', $value);
    }

    /**
     * Set the value for the RefreshToken input for this GetEndpoint Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Amazon_CloudDrive_Account_GetEndpoint_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }
}


/**
 * Execution object for the GetEndpoint Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Account_GetEndpoint_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the GetEndpoint Choreo.
     *
     * @param Temboo_Session $session The session that owns this GetEndpoint execution.
     * @param Amazon_CloudDrive_Account_GetEndpoint $choreo The choreography object for this execution.
     * @param Amazon_CloudDrive_Account_GetEndpoint_Inputs|array $inputs (optional) Inputs as Amazon_CloudDrive_Account_GetEndpoint_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_CloudDrive_Account_GetEndpoint_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_CloudDrive_Account_GetEndpoint $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this GetEndpoint execution.
     *
     * @return Amazon_CloudDrive_Account_GetEndpoint_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this GetEndpoint execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_CloudDrive_Account_GetEndpoint_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_CloudDrive_Account_GetEndpoint_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the GetEndpoint Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Account_GetEndpoint_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the GetEndpoint Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_CloudDrive_Account_GetEndpoint_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this GetEndpoint execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this GetEndpoint execution.
     *
     * @return string (json) The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Retrieves account quota and storage availability information.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Account_GetQuota extends Temboo_Choreography
{
    /**
     * Retrieves account quota and storage availability information.
     *
     * @param Temboo_Session $session The session that owns this GetQuota Choreo.
     * @return Amazon_CloudDrive_Account_GetQuota New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/CloudDrive/Account/GetQuota/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this GetQuota Choreo.
     *
     * @param Amazon_CloudDrive_Account_GetQuota_Inputs|array $inputs (optional) Inputs as Amazon_CloudDrive_Account_GetQuota_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_CloudDrive_Account_GetQuota_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_CloudDrive_Account_GetQuota_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this GetQuota Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_CloudDrive_Account_GetQuota_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_CloudDrive_Account_GetQuota_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the GetQuota Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Account_GetQuota_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the GetQuota Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_CloudDrive_Account_GetQuota_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this GetQuota input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_CloudDrive_Account_GetQuota_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_CloudDrive_Account_GetQuota_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this GetQuota Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Amazon_CloudDrive_Account_GetQuota_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this GetQuota Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Amazon. Required unless providing a valid AccessToken.
     * @return Amazon_CloudDrive_Account_GetQuota_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this GetQuota Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Amazon. Required unless providing a valid AccessToken.
     * @return Amazon_CloudDrive_Account_GetQuota_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the HandleRequestThrottling input for this GetQuota Choreo.
     *
     * @param bool $value (optional, boolean) Whether or not to perform a retry sequence if a throttling error occurs. Set to true to enable this feature. The request will be retried up-to five times when enabled.
     * @return Amazon_CloudDrive_Account_GetQuota_Inputs For method chaining.
     */
    public function setHandleRequestThrottling($value)
    {
        return $this->set('HandleRequestThrottling', $value);
    }

    /**
     * Set the value for the RefreshToken input for this GetQuota Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Amazon_CloudDrive_Account_GetQuota_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }
}


/**
 * Execution object for the GetQuota Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Account_GetQuota_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the GetQuota Choreo.
     *
     * @param Temboo_Session $session The session that owns this GetQuota execution.
     * @param Amazon_CloudDrive_Account_GetQuota $choreo The choreography object for this execution.
     * @param Amazon_CloudDrive_Account_GetQuota_Inputs|array $inputs (optional) Inputs as Amazon_CloudDrive_Account_GetQuota_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_CloudDrive_Account_GetQuota_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_CloudDrive_Account_GetQuota $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this GetQuota execution.
     *
     * @return Amazon_CloudDrive_Account_GetQuota_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this GetQuota execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_CloudDrive_Account_GetQuota_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_CloudDrive_Account_GetQuota_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the GetQuota Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Account_GetQuota_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the GetQuota Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_CloudDrive_Account_GetQuota_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this GetQuota execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this GetQuota execution.
     *
     * @return string (json) The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Retrieves account usage information broken down by content category.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Account_GetUsage extends Temboo_Choreography
{
    /**
     * Retrieves account usage information broken down by content category.
     *
     * @param Temboo_Session $session The session that owns this GetUsage Choreo.
     * @return Amazon_CloudDrive_Account_GetUsage New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/CloudDrive/Account/GetUsage/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this GetUsage Choreo.
     *
     * @param Amazon_CloudDrive_Account_GetUsage_Inputs|array $inputs (optional) Inputs as Amazon_CloudDrive_Account_GetUsage_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_CloudDrive_Account_GetUsage_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_CloudDrive_Account_GetUsage_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this GetUsage Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_CloudDrive_Account_GetUsage_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_CloudDrive_Account_GetUsage_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the GetUsage Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Account_GetUsage_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the GetUsage Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_CloudDrive_Account_GetUsage_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this GetUsage input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_CloudDrive_Account_GetUsage_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_CloudDrive_Account_GetUsage_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this GetUsage Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Amazon_CloudDrive_Account_GetUsage_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this GetUsage Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Amazon. Required unless providing a valid AccessToken.
     * @return Amazon_CloudDrive_Account_GetUsage_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this GetUsage Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Amazon. Required unless providing a valid AccessToken.
     * @return Amazon_CloudDrive_Account_GetUsage_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the HandleRequestThrottling input for this GetUsage Choreo.
     *
     * @param bool $value (optional, boolean) Whether or not to perform a retry sequence if a throttling error occurs. Set to true to enable this feature. The request will be retried up-to five times when enabled.
     * @return Amazon_CloudDrive_Account_GetUsage_Inputs For method chaining.
     */
    public function setHandleRequestThrottling($value)
    {
        return $this->set('HandleRequestThrottling', $value);
    }

    /**
     * Set the value for the RefreshToken input for this GetUsage Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Amazon_CloudDrive_Account_GetUsage_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }
}


/**
 * Execution object for the GetUsage Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Account_GetUsage_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the GetUsage Choreo.
     *
     * @param Temboo_Session $session The session that owns this GetUsage execution.
     * @param Amazon_CloudDrive_Account_GetUsage $choreo The choreography object for this execution.
     * @param Amazon_CloudDrive_Account_GetUsage_Inputs|array $inputs (optional) Inputs as Amazon_CloudDrive_Account_GetUsage_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_CloudDrive_Account_GetUsage_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_CloudDrive_Account_GetUsage $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this GetUsage execution.
     *
     * @return Amazon_CloudDrive_Account_GetUsage_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this GetUsage execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_CloudDrive_Account_GetUsage_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_CloudDrive_Account_GetUsage_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the GetUsage Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Account_GetUsage_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the GetUsage Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_CloudDrive_Account_GetUsage_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this GetUsage execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this GetUsage execution.
     *
     * @return string (json) The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Creates an account with a given terms of use parameter.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Account_SetupAccount extends Temboo_Choreography
{
    /**
     * Creates an account with a given terms of use parameter.
     *
     * @param Temboo_Session $session The session that owns this SetupAccount Choreo.
     * @return Amazon_CloudDrive_Account_SetupAccount New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/CloudDrive/Account/SetupAccount/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this SetupAccount Choreo.
     *
     * @param Amazon_CloudDrive_Account_SetupAccount_Inputs|array $inputs (optional) Inputs as Amazon_CloudDrive_Account_SetupAccount_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_CloudDrive_Account_SetupAccount_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_CloudDrive_Account_SetupAccount_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this SetupAccount Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_CloudDrive_Account_SetupAccount_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_CloudDrive_Account_SetupAccount_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the SetupAccount Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Account_SetupAccount_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the SetupAccount Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_CloudDrive_Account_SetupAccount_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this SetupAccount input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_CloudDrive_Account_SetupAccount_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_CloudDrive_Account_SetupAccount_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this SetupAccount Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Amazon_CloudDrive_Account_SetupAccount_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this SetupAccount Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Amazon. Required unless providing a valid AccessToken.
     * @return Amazon_CloudDrive_Account_SetupAccount_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this SetupAccount Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Amazon. Required unless providing a valid AccessToken.
     * @return Amazon_CloudDrive_Account_SetupAccount_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the HandleRequestThrottling input for this SetupAccount Choreo.
     *
     * @param bool $value (optional, boolean) Whether or not to perform a retry sequence if a throttling error occurs. Set to true to enable this feature. The request will be retried up-to five times when enabled.
     * @return Amazon_CloudDrive_Account_SetupAccount_Inputs For method chaining.
     */
    public function setHandleRequestThrottling($value)
    {
        return $this->set('HandleRequestThrottling', $value);
    }

    /**
     * Set the value for the RefreshToken input for this SetupAccount Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Amazon_CloudDrive_Account_SetupAccount_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }

    /**
     * Set the value for the TermsOfUse input for this SetupAccount Choreo.
     *
     * @param float $value (optional, decimal) The terms of use version. Defaults to 1.0.0.
     * @return Amazon_CloudDrive_Account_SetupAccount_Inputs For method chaining.
     */
    public function setTermsOfUse($value)
    {
        return $this->set('TermsOfUse', $value);
    }
}


/**
 * Execution object for the SetupAccount Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Account_SetupAccount_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the SetupAccount Choreo.
     *
     * @param Temboo_Session $session The session that owns this SetupAccount execution.
     * @param Amazon_CloudDrive_Account_SetupAccount $choreo The choreography object for this execution.
     * @param Amazon_CloudDrive_Account_SetupAccount_Inputs|array $inputs (optional) Inputs as Amazon_CloudDrive_Account_SetupAccount_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_CloudDrive_Account_SetupAccount_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_CloudDrive_Account_SetupAccount $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this SetupAccount execution.
     *
     * @return Amazon_CloudDrive_Account_SetupAccount_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this SetupAccount execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_CloudDrive_Account_SetupAccount_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_CloudDrive_Account_SetupAccount_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the SetupAccount Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Account_SetupAccount_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the SetupAccount Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_CloudDrive_Account_SetupAccount_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this SetupAccount execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "ResponseStatusCode" output from this SetupAccount execution.
     *
     * @return int (integer) The response status code returned from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponseStatusCode()
    {
        return $this->get('ResponseStatusCode');
    }
    /**
     * Retrieve the value for the "Response" output from this SetupAccount execution.
     *
     * @return string (json) The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Moves a specified folder into a parent folder.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Children_AddChild extends Temboo_Choreography
{
    /**
     * Moves a specified folder into a parent folder.
     *
     * @param Temboo_Session $session The session that owns this AddChild Choreo.
     * @return Amazon_CloudDrive_Children_AddChild New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/CloudDrive/Children/AddChild/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this AddChild Choreo.
     *
     * @param Amazon_CloudDrive_Children_AddChild_Inputs|array $inputs (optional) Inputs as Amazon_CloudDrive_Children_AddChild_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_CloudDrive_Children_AddChild_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_CloudDrive_Children_AddChild_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this AddChild Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_CloudDrive_Children_AddChild_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_CloudDrive_Children_AddChild_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the AddChild Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Children_AddChild_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the AddChild Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_CloudDrive_Children_AddChild_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this AddChild input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_CloudDrive_Children_AddChild_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_CloudDrive_Children_AddChild_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this AddChild Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Amazon_CloudDrive_Children_AddChild_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ChildID input for this AddChild Choreo.
     *
     * @param string $value (required, string) The ID of the folder that is being moved within a parent folder.
     * @return Amazon_CloudDrive_Children_AddChild_Inputs For method chaining.
     */
    public function setChildID($value)
    {
        return $this->set('ChildID', $value);
    }

    /**
     * Set the value for the ClientID input for this AddChild Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Amazon. Required unless providing a valid AccessToken.
     * @return Amazon_CloudDrive_Children_AddChild_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this AddChild Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Amazon. Required unless providing a valid AccessToken.
     * @return Amazon_CloudDrive_Children_AddChild_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the HandleRequestThrottling input for this AddChild Choreo.
     *
     * @param bool $value (optional, boolean) Whether or not to perform a retry sequence if a throttling error occurs. Set to true to enable this feature. The request will be retried up-to five times when enabled.
     * @return Amazon_CloudDrive_Children_AddChild_Inputs For method chaining.
     */
    public function setHandleRequestThrottling($value)
    {
        return $this->set('HandleRequestThrottling', $value);
    }

    /**
     * Set the value for the MetaDataURL input for this AddChild Choreo.
     *
     * @param string $value (optional, string) The appropriate metadataUrl for your account. When not provided, the Choreo will lookup the URL using the Account.GetEndpoint Choreo.
     * @return Amazon_CloudDrive_Children_AddChild_Inputs For method chaining.
     */
    public function setMetaDataURL($value)
    {
        return $this->set('MetaDataURL', $value);
    }

    /**
     * Set the value for the ParentID input for this AddChild Choreo.
     *
     * @param string $value (required, string) The ID of the parent folder that will contain the child folder that's being moved.
     * @return Amazon_CloudDrive_Children_AddChild_Inputs For method chaining.
     */
    public function setParentID($value)
    {
        return $this->set('ParentID', $value);
    }

    /**
     * Set the value for the RefreshToken input for this AddChild Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Amazon_CloudDrive_Children_AddChild_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }
}


/**
 * Execution object for the AddChild Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Children_AddChild_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the AddChild Choreo.
     *
     * @param Temboo_Session $session The session that owns this AddChild execution.
     * @param Amazon_CloudDrive_Children_AddChild $choreo The choreography object for this execution.
     * @param Amazon_CloudDrive_Children_AddChild_Inputs|array $inputs (optional) Inputs as Amazon_CloudDrive_Children_AddChild_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_CloudDrive_Children_AddChild_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_CloudDrive_Children_AddChild $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this AddChild execution.
     *
     * @return Amazon_CloudDrive_Children_AddChild_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this AddChild execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_CloudDrive_Children_AddChild_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_CloudDrive_Children_AddChild_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the AddChild Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Children_AddChild_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the AddChild Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_CloudDrive_Children_AddChild_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this AddChild execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this AddChild execution.
     *
     * @return string (json) The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Returns the children of a specified parent folder.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Children_ListChildren extends Temboo_Choreography
{
    /**
     * Returns the children of a specified parent folder.
     *
     * @param Temboo_Session $session The session that owns this ListChildren Choreo.
     * @return Amazon_CloudDrive_Children_ListChildren New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/CloudDrive/Children/ListChildren/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this ListChildren Choreo.
     *
     * @param Amazon_CloudDrive_Children_ListChildren_Inputs|array $inputs (optional) Inputs as Amazon_CloudDrive_Children_ListChildren_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_CloudDrive_Children_ListChildren_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_CloudDrive_Children_ListChildren_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this ListChildren Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_CloudDrive_Children_ListChildren_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_CloudDrive_Children_ListChildren_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the ListChildren Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Children_ListChildren_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the ListChildren Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_CloudDrive_Children_ListChildren_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this ListChildren input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_CloudDrive_Children_ListChildren_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_CloudDrive_Children_ListChildren_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this ListChildren Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Amazon_CloudDrive_Children_ListChildren_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this ListChildren Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Amazon. Required unless providing a valid AccessToken.
     * @return Amazon_CloudDrive_Children_ListChildren_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this ListChildren Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Amazon. Required unless providing a valid AccessToken.
     * @return Amazon_CloudDrive_Children_ListChildren_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Fields input for this ListChildren Choreo.
     *
     * @param string $value (optional, string) A comma-separated list of additional fields to include in the response.
     * @return Amazon_CloudDrive_Children_ListChildren_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Filters input for this ListChildren Choreo.
     *
     * @param string $value (optional, string) A filter used to narrow the result set (e.g., name:Documents). The default value is "kind:FOLDER". To a make a request using no filters, you can pass "none".
     * @return Amazon_CloudDrive_Children_ListChildren_Inputs For method chaining.
     */
    public function setFilters($value)
    {
        return $this->set('Filters', $value);
    }

    /**
     * Set the value for the HandleRequestThrottling input for this ListChildren Choreo.
     *
     * @param bool $value (optional, boolean) Whether or not to perform a retry sequence if a throttling error occurs. Set to true to enable this feature. The request will be retried up-to five times when enabled.
     * @return Amazon_CloudDrive_Children_ListChildren_Inputs For method chaining.
     */
    public function setHandleRequestThrottling($value)
    {
        return $this->set('HandleRequestThrottling', $value);
    }

    /**
     * Set the value for the Limit input for this ListChildren Choreo.
     *
     * @param string $value (optional, string) The maximum number of records to be returned.
     * @return Amazon_CloudDrive_Children_ListChildren_Inputs For method chaining.
     */
    public function setLimit($value)
    {
        return $this->set('Limit', $value);
    }

    /**
     * Set the value for the MetaDataURL input for this ListChildren Choreo.
     *
     * @param string $value (optional, string) The appropriate metadataUrl for you account. When not provided, the Choreo will lookup the URL using the Account.GetEndpoint Choreo.
     * @return Amazon_CloudDrive_Children_ListChildren_Inputs For method chaining.
     */
    public function setMetaDataURL($value)
    {
        return $this->set('MetaDataURL', $value);
    }

    /**
     * Set the value for the ParentID input for this ListChildren Choreo.
     *
     * @param string $value (required, string) The ID of the parent that contains the list of children to retrieve.
     * @return Amazon_CloudDrive_Children_ListChildren_Inputs For method chaining.
     */
    public function setParentID($value)
    {
        return $this->set('ParentID', $value);
    }

    /**
     * Set the value for the RefreshToken input for this ListChildren Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Amazon_CloudDrive_Children_ListChildren_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }

    /**
     * Set the value for the Sort input for this ListChildren Choreo.
     *
     * @param string $value (optional, json) A JSON array containing sort properties (e.g., ["name ASC","contentProperties.size" DESC]).
     * @return Amazon_CloudDrive_Children_ListChildren_Inputs For method chaining.
     */
    public function setSort($value)
    {
        return $this->set('Sort', $value);
    }

    /**
     * Set the value for the StartToken input for this ListChildren Choreo.
     *
     * @param string $value (optional, string) The nextToken returned from a previous request. Used to paginate through results.
     * @return Amazon_CloudDrive_Children_ListChildren_Inputs For method chaining.
     */
    public function setStartToken($value)
    {
        return $this->set('StartToken', $value);
    }
}


/**
 * Execution object for the ListChildren Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Children_ListChildren_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the ListChildren Choreo.
     *
     * @param Temboo_Session $session The session that owns this ListChildren execution.
     * @param Amazon_CloudDrive_Children_ListChildren $choreo The choreography object for this execution.
     * @param Amazon_CloudDrive_Children_ListChildren_Inputs|array $inputs (optional) Inputs as Amazon_CloudDrive_Children_ListChildren_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_CloudDrive_Children_ListChildren_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_CloudDrive_Children_ListChildren $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this ListChildren execution.
     *
     * @return Amazon_CloudDrive_Children_ListChildren_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this ListChildren execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_CloudDrive_Children_ListChildren_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_CloudDrive_Children_ListChildren_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the ListChildren Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Children_ListChildren_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the ListChildren Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_CloudDrive_Children_ListChildren_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this ListChildren execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this ListChildren execution.
     *
     * @return string (json) The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Removes a specified folder from a parent folder.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Children_RemoveChild extends Temboo_Choreography
{
    /**
     * Removes a specified folder from a parent folder.
     *
     * @param Temboo_Session $session The session that owns this RemoveChild Choreo.
     * @return Amazon_CloudDrive_Children_RemoveChild New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/CloudDrive/Children/RemoveChild/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this RemoveChild Choreo.
     *
     * @param Amazon_CloudDrive_Children_RemoveChild_Inputs|array $inputs (optional) Inputs as Amazon_CloudDrive_Children_RemoveChild_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_CloudDrive_Children_RemoveChild_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_CloudDrive_Children_RemoveChild_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this RemoveChild Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_CloudDrive_Children_RemoveChild_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_CloudDrive_Children_RemoveChild_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the RemoveChild Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Children_RemoveChild_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the RemoveChild Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_CloudDrive_Children_RemoveChild_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this RemoveChild input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_CloudDrive_Children_RemoveChild_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_CloudDrive_Children_RemoveChild_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this RemoveChild Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Amazon_CloudDrive_Children_RemoveChild_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ChildID input for this RemoveChild Choreo.
     *
     * @param string $value (required, string) The ID of the folder that is being removed from a parent folder.
     * @return Amazon_CloudDrive_Children_RemoveChild_Inputs For method chaining.
     */
    public function setChildID($value)
    {
        return $this->set('ChildID', $value);
    }

    /**
     * Set the value for the ClientID input for this RemoveChild Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Amazon. Required unless providing a valid AccessToken.
     * @return Amazon_CloudDrive_Children_RemoveChild_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this RemoveChild Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Amazon. Required unless providing a valid AccessToken.
     * @return Amazon_CloudDrive_Children_RemoveChild_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the HandleRequestThrottling input for this RemoveChild Choreo.
     *
     * @param bool $value (optional, boolean) Whether or not to perform a retry sequence if a throttling error occurs. Set to true to enable this feature. The request will be retried up-to five times when enabled.
     * @return Amazon_CloudDrive_Children_RemoveChild_Inputs For method chaining.
     */
    public function setHandleRequestThrottling($value)
    {
        return $this->set('HandleRequestThrottling', $value);
    }

    /**
     * Set the value for the MetaDataURL input for this RemoveChild Choreo.
     *
     * @param string $value (optional, string) The appropriate metadataUrl for your account. When not provided, the Choreo will lookup the URL using the Account.GetEndpoint Choreo.
     * @return Amazon_CloudDrive_Children_RemoveChild_Inputs For method chaining.
     */
    public function setMetaDataURL($value)
    {
        return $this->set('MetaDataURL', $value);
    }

    /**
     * Set the value for the ParentID input for this RemoveChild Choreo.
     *
     * @param string $value (required, string) The ID of the parent folder that contains the child folder that's being removed.
     * @return Amazon_CloudDrive_Children_RemoveChild_Inputs For method chaining.
     */
    public function setParentID($value)
    {
        return $this->set('ParentID', $value);
    }

    /**
     * Set the value for the RefreshToken input for this RemoveChild Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Amazon_CloudDrive_Children_RemoveChild_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }
}


/**
 * Execution object for the RemoveChild Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Children_RemoveChild_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the RemoveChild Choreo.
     *
     * @param Temboo_Session $session The session that owns this RemoveChild execution.
     * @param Amazon_CloudDrive_Children_RemoveChild $choreo The choreography object for this execution.
     * @param Amazon_CloudDrive_Children_RemoveChild_Inputs|array $inputs (optional) Inputs as Amazon_CloudDrive_Children_RemoveChild_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_CloudDrive_Children_RemoveChild_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_CloudDrive_Children_RemoveChild $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this RemoveChild execution.
     *
     * @return Amazon_CloudDrive_Children_RemoveChild_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this RemoveChild execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_CloudDrive_Children_RemoveChild_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_CloudDrive_Children_RemoveChild_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the RemoveChild Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Children_RemoveChild_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the RemoveChild Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_CloudDrive_Children_RemoveChild_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this RemoveChild execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this RemoveChild execution.
     *
     * @return string (json) The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Queries the Amazon Cloud Drive API to retrieve the content for a specific file.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Files_DownloadFile extends Temboo_Choreography
{
    /**
     * Queries the Amazon Cloud Drive API to retrieve the content for a specific file.
     *
     * @param Temboo_Session $session The session that owns this DownloadFile Choreo.
     * @return Amazon_CloudDrive_Files_DownloadFile New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/CloudDrive/Files/DownloadFile/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this DownloadFile Choreo.
     *
     * @param Amazon_CloudDrive_Files_DownloadFile_Inputs|array $inputs (optional) Inputs as Amazon_CloudDrive_Files_DownloadFile_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_CloudDrive_Files_DownloadFile_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_CloudDrive_Files_DownloadFile_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this DownloadFile Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_CloudDrive_Files_DownloadFile_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_CloudDrive_Files_DownloadFile_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the DownloadFile Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Files_DownloadFile_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the DownloadFile Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_CloudDrive_Files_DownloadFile_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this DownloadFile input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_CloudDrive_Files_DownloadFile_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_CloudDrive_Files_DownloadFile_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this DownloadFile Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Amazon_CloudDrive_Files_DownloadFile_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this DownloadFile Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Amazon. Required unless providing a valid AccessToken.
     * @return Amazon_CloudDrive_Files_DownloadFile_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this DownloadFile Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Amazon. Required unless providing a valid AccessToken.
     * @return Amazon_CloudDrive_Files_DownloadFile_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the ContentURL input for this DownloadFile Choreo.
     *
     * @param string $value (optional, string) The appropriate contentUrl for your account. When not provided, the Choreo will lookup the URL using the Account.GetEndpoint Choreo.
     * @return Amazon_CloudDrive_Files_DownloadFile_Inputs For method chaining.
     */
    public function setContentURL($value)
    {
        return $this->set('ContentURL', $value);
    }

    /**
     * Set the value for the HandleRequestThrottling input for this DownloadFile Choreo.
     *
     * @param bool $value (optional, boolean) Whether or not to perform a retry sequence if a throttling error occurs. Set to true to enable this feature. The request will be retried up-to five times when enabled.
     * @return Amazon_CloudDrive_Files_DownloadFile_Inputs For method chaining.
     */
    public function setHandleRequestThrottling($value)
    {
        return $this->set('HandleRequestThrottling', $value);
    }

    /**
     * Set the value for the ID input for this DownloadFile Choreo.
     *
     * @param string $value (required, string) The ID of the file to return content for.
     * @return Amazon_CloudDrive_Files_DownloadFile_Inputs For method chaining.
     */
    public function setID($value)
    {
        return $this->set('ID', $value);
    }

    /**
     * Set the value for the RefreshToken input for this DownloadFile Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Amazon_CloudDrive_Files_DownloadFile_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }
}


/**
 * Execution object for the DownloadFile Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Files_DownloadFile_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the DownloadFile Choreo.
     *
     * @param Temboo_Session $session The session that owns this DownloadFile execution.
     * @param Amazon_CloudDrive_Files_DownloadFile $choreo The choreography object for this execution.
     * @param Amazon_CloudDrive_Files_DownloadFile_Inputs|array $inputs (optional) Inputs as Amazon_CloudDrive_Files_DownloadFile_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_CloudDrive_Files_DownloadFile_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_CloudDrive_Files_DownloadFile $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this DownloadFile execution.
     *
     * @return Amazon_CloudDrive_Files_DownloadFile_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this DownloadFile execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_CloudDrive_Files_DownloadFile_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_CloudDrive_Files_DownloadFile_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the DownloadFile Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Files_DownloadFile_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the DownloadFile Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_CloudDrive_Files_DownloadFile_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this DownloadFile execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this DownloadFile execution.
     *
     * @return string (string) The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Queries the Amazon Cloud Drive API to retrieve metadata for a specific file.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Files_GetFileMetadata extends Temboo_Choreography
{
    /**
     * Queries the Amazon Cloud Drive API to retrieve metadata for a specific file.
     *
     * @param Temboo_Session $session The session that owns this GetFileMetadata Choreo.
     * @return Amazon_CloudDrive_Files_GetFileMetadata New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/CloudDrive/Files/GetFileMetadata/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this GetFileMetadata Choreo.
     *
     * @param Amazon_CloudDrive_Files_GetFileMetadata_Inputs|array $inputs (optional) Inputs as Amazon_CloudDrive_Files_GetFileMetadata_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_CloudDrive_Files_GetFileMetadata_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_CloudDrive_Files_GetFileMetadata_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this GetFileMetadata Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_CloudDrive_Files_GetFileMetadata_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_CloudDrive_Files_GetFileMetadata_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the GetFileMetadata Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Files_GetFileMetadata_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the GetFileMetadata Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_CloudDrive_Files_GetFileMetadata_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this GetFileMetadata input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_CloudDrive_Files_GetFileMetadata_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_CloudDrive_Files_GetFileMetadata_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this GetFileMetadata Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Amazon_CloudDrive_Files_GetFileMetadata_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this GetFileMetadata Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Amazon. Required unless providing a valid AccessToken.
     * @return Amazon_CloudDrive_Files_GetFileMetadata_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this GetFileMetadata Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Amazon. Required unless providing a valid AccessToken.
     * @return Amazon_CloudDrive_Files_GetFileMetadata_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Fields input for this GetFileMetadata Choreo.
     *
     * @param string $value (optional, string) A comma-separated list of additional fields to include in the response.
     * @return Amazon_CloudDrive_Files_GetFileMetadata_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the HandleRequestThrottling input for this GetFileMetadata Choreo.
     *
     * @param bool $value (optional, boolean) Whether or not to perform a retry sequence if a throttling error occurs. Set to true to enable this feature. The request will be retried up-to five times when enabled.
     * @return Amazon_CloudDrive_Files_GetFileMetadata_Inputs For method chaining.
     */
    public function setHandleRequestThrottling($value)
    {
        return $this->set('HandleRequestThrottling', $value);
    }

    /**
     * Set the value for the ID input for this GetFileMetadata Choreo.
     *
     * @param string $value (required, string) The ID of the file to return metadata for.
     * @return Amazon_CloudDrive_Files_GetFileMetadata_Inputs For method chaining.
     */
    public function setID($value)
    {
        return $this->set('ID', $value);
    }

    /**
     * Set the value for the MetaDataURL input for this GetFileMetadata Choreo.
     *
     * @param string $value (optional, string) The appropriate metadataUrl for your account. When not provided, the Choreo will lookup the URL using the Account.GetEndpoint Choreo.
     * @return Amazon_CloudDrive_Files_GetFileMetadata_Inputs For method chaining.
     */
    public function setMetaDataURL($value)
    {
        return $this->set('MetaDataURL', $value);
    }

    /**
     * Set the value for the RefreshToken input for this GetFileMetadata Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Amazon_CloudDrive_Files_GetFileMetadata_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }

    /**
     * Set the value for the TempLink input for this GetFileMetadata Choreo.
     *
     * @param bool $value (optional, boolean) Set true to include tempLink in response. Defaults to false.
     * @return Amazon_CloudDrive_Files_GetFileMetadata_Inputs For method chaining.
     */
    public function setTempLink($value)
    {
        return $this->set('TempLink', $value);
    }
}


/**
 * Execution object for the GetFileMetadata Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Files_GetFileMetadata_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the GetFileMetadata Choreo.
     *
     * @param Temboo_Session $session The session that owns this GetFileMetadata execution.
     * @param Amazon_CloudDrive_Files_GetFileMetadata $choreo The choreography object for this execution.
     * @param Amazon_CloudDrive_Files_GetFileMetadata_Inputs|array $inputs (optional) Inputs as Amazon_CloudDrive_Files_GetFileMetadata_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_CloudDrive_Files_GetFileMetadata_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_CloudDrive_Files_GetFileMetadata $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this GetFileMetadata execution.
     *
     * @return Amazon_CloudDrive_Files_GetFileMetadata_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this GetFileMetadata execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_CloudDrive_Files_GetFileMetadata_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_CloudDrive_Files_GetFileMetadata_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the GetFileMetadata Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Files_GetFileMetadata_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the GetFileMetadata Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_CloudDrive_Files_GetFileMetadata_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this GetFileMetadata execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this GetFileMetadata execution.
     *
     * @return string (json) The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Queries the Amazon Cloud Drive API to return a list of files.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Files_ListFiles extends Temboo_Choreography
{
    /**
     * Queries the Amazon Cloud Drive API to return a list of files.
     *
     * @param Temboo_Session $session The session that owns this ListFiles Choreo.
     * @return Amazon_CloudDrive_Files_ListFiles New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/CloudDrive/Files/ListFiles/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this ListFiles Choreo.
     *
     * @param Amazon_CloudDrive_Files_ListFiles_Inputs|array $inputs (optional) Inputs as Amazon_CloudDrive_Files_ListFiles_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_CloudDrive_Files_ListFiles_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_CloudDrive_Files_ListFiles_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this ListFiles Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_CloudDrive_Files_ListFiles_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_CloudDrive_Files_ListFiles_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the ListFiles Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Files_ListFiles_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the ListFiles Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_CloudDrive_Files_ListFiles_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this ListFiles input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_CloudDrive_Files_ListFiles_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_CloudDrive_Files_ListFiles_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this ListFiles Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Amazon_CloudDrive_Files_ListFiles_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this ListFiles Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Amazon. Required unless providing a valid AccessToken.
     * @return Amazon_CloudDrive_Files_ListFiles_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this ListFiles Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Amazon. Required unless providing a valid AccessToken.
     * @return Amazon_CloudDrive_Files_ListFiles_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Fields input for this ListFiles Choreo.
     *
     * @param string $value (optional, string) A comma-separated list of additional fields to include in the response.
     * @return Amazon_CloudDrive_Files_ListFiles_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Filters input for this ListFiles Choreo.
     *
     * @param string $value (optional, string) A filter used to narrow the result set (e.g., name:MyFile.txt). The default value is "kind:FILE". To a make a request using no filters, you can pass "none".
     * @return Amazon_CloudDrive_Files_ListFiles_Inputs For method chaining.
     */
    public function setFilters($value)
    {
        return $this->set('Filters', $value);
    }

    /**
     * Set the value for the HandleRequestThrottling input for this ListFiles Choreo.
     *
     * @param bool $value (optional, boolean) Whether or not to perform a retry sequence if a throttling error occurs. Set to true to enable this feature. The request will be retried up-to five times when enabled.
     * @return Amazon_CloudDrive_Files_ListFiles_Inputs For method chaining.
     */
    public function setHandleRequestThrottling($value)
    {
        return $this->set('HandleRequestThrottling', $value);
    }

    /**
     * Set the value for the Limit input for this ListFiles Choreo.
     *
     * @param string $value (optional, string) The maximum number of records to be returned.
     * @return Amazon_CloudDrive_Files_ListFiles_Inputs For method chaining.
     */
    public function setLimit($value)
    {
        return $this->set('Limit', $value);
    }

    /**
     * Set the value for the MetaDataURL input for this ListFiles Choreo.
     *
     * @param string $value (optional, string) The appropriate metadataUrl for your account. When not provided, the Choreo will lookup the URL using the Account.GetEndpoint Choreo.
     * @return Amazon_CloudDrive_Files_ListFiles_Inputs For method chaining.
     */
    public function setMetaDataURL($value)
    {
        return $this->set('MetaDataURL', $value);
    }

    /**
     * Set the value for the RefreshToken input for this ListFiles Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Amazon_CloudDrive_Files_ListFiles_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }

    /**
     * Set the value for the Sort input for this ListFiles Choreo.
     *
     * @param string $value (optional, json) A JSON array containing sort properties (e.g., ["name ASC","contentProperties.size" DESC]).
     * @return Amazon_CloudDrive_Files_ListFiles_Inputs For method chaining.
     */
    public function setSort($value)
    {
        return $this->set('Sort', $value);
    }

    /**
     * Set the value for the StartToken input for this ListFiles Choreo.
     *
     * @param string $value (optional, string) The nextToken returned from a previous request. Used to paginate through results.
     * @return Amazon_CloudDrive_Files_ListFiles_Inputs For method chaining.
     */
    public function setStartToken($value)
    {
        return $this->set('StartToken', $value);
    }
}


/**
 * Execution object for the ListFiles Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Files_ListFiles_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the ListFiles Choreo.
     *
     * @param Temboo_Session $session The session that owns this ListFiles execution.
     * @param Amazon_CloudDrive_Files_ListFiles $choreo The choreography object for this execution.
     * @param Amazon_CloudDrive_Files_ListFiles_Inputs|array $inputs (optional) Inputs as Amazon_CloudDrive_Files_ListFiles_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_CloudDrive_Files_ListFiles_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_CloudDrive_Files_ListFiles $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this ListFiles execution.
     *
     * @return Amazon_CloudDrive_Files_ListFiles_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this ListFiles execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_CloudDrive_Files_ListFiles_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_CloudDrive_Files_ListFiles_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the ListFiles Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Files_ListFiles_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the ListFiles Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_CloudDrive_Files_ListFiles_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this ListFiles execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this ListFiles execution.
     *
     * @return string (json) The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Queries the Amazon Cloud Drive API to overwrite the content of an existing file.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Files_OverwriteFile extends Temboo_Choreography
{
    /**
     * Queries the Amazon Cloud Drive API to overwrite the content of an existing file.
     *
     * @param Temboo_Session $session The session that owns this OverwriteFile Choreo.
     * @return Amazon_CloudDrive_Files_OverwriteFile New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/CloudDrive/Files/OverwriteFile/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this OverwriteFile Choreo.
     *
     * @param Amazon_CloudDrive_Files_OverwriteFile_Inputs|array $inputs (optional) Inputs as Amazon_CloudDrive_Files_OverwriteFile_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_CloudDrive_Files_OverwriteFile_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_CloudDrive_Files_OverwriteFile_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this OverwriteFile Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_CloudDrive_Files_OverwriteFile_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_CloudDrive_Files_OverwriteFile_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the OverwriteFile Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Files_OverwriteFile_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the OverwriteFile Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_CloudDrive_Files_OverwriteFile_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this OverwriteFile input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_CloudDrive_Files_OverwriteFile_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_CloudDrive_Files_OverwriteFile_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this OverwriteFile Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Amazon_CloudDrive_Files_OverwriteFile_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this OverwriteFile Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Amazon. Required unless providing a valid AccessToken.
     * @return Amazon_CloudDrive_Files_OverwriteFile_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this OverwriteFile Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Amazon. Required unless providing a valid AccessToken.
     * @return Amazon_CloudDrive_Files_OverwriteFile_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the ContentURL input for this OverwriteFile Choreo.
     *
     * @param string $value (optional, string) The appropriate contentUrl for your account. When not provided, the Choreo will lookup the URL using the Account.GetEndpoint Choreo.
     * @return Amazon_CloudDrive_Files_OverwriteFile_Inputs For method chaining.
     */
    public function setContentURL($value)
    {
        return $this->set('ContentURL', $value);
    }

    /**
     * Set the value for the FileContent input for this OverwriteFile Choreo.
     *
     * @param string $value (conditional, string) The Base64 encoded contents of the file to upload.
     * @return Amazon_CloudDrive_Files_OverwriteFile_Inputs For method chaining.
     */
    public function setFileContent($value)
    {
        return $this->set('FileContent', $value);
    }

    /**
     * Set the value for the HandleRequestThrottling input for this OverwriteFile Choreo.
     *
     * @param bool $value (optional, boolean) Whether or not to perform a retry sequence if a throttling error occurs. Set to true to enable this feature. The request will be retried up-to five times when enabled.
     * @return Amazon_CloudDrive_Files_OverwriteFile_Inputs For method chaining.
     */
    public function setHandleRequestThrottling($value)
    {
        return $this->set('HandleRequestThrottling', $value);
    }

    /**
     * Set the value for the ID input for this OverwriteFile Choreo.
     *
     * @param string $value (required, string) The ID of the file to update.
     * @return Amazon_CloudDrive_Files_OverwriteFile_Inputs For method chaining.
     */
    public function setID($value)
    {
        return $this->set('ID', $value);
    }

    /**
     * Set the value for the RefreshToken input for this OverwriteFile Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Amazon_CloudDrive_Files_OverwriteFile_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }

}


/**
 * Execution object for the OverwriteFile Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Files_OverwriteFile_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the OverwriteFile Choreo.
     *
     * @param Temboo_Session $session The session that owns this OverwriteFile execution.
     * @param Amazon_CloudDrive_Files_OverwriteFile $choreo The choreography object for this execution.
     * @param Amazon_CloudDrive_Files_OverwriteFile_Inputs|array $inputs (optional) Inputs as Amazon_CloudDrive_Files_OverwriteFile_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_CloudDrive_Files_OverwriteFile_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_CloudDrive_Files_OverwriteFile $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this OverwriteFile execution.
     *
     * @return Amazon_CloudDrive_Files_OverwriteFile_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this OverwriteFile execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_CloudDrive_Files_OverwriteFile_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_CloudDrive_Files_OverwriteFile_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the OverwriteFile Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Files_OverwriteFile_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the OverwriteFile Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_CloudDrive_Files_OverwriteFile_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this OverwriteFile execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this OverwriteFile execution.
     *
     * @return string (json) The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Calls the Amazon Cloud Drive API to upload a file to Amazon Cloud Drive.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Files_UploadFile extends Temboo_Choreography
{
    /**
     * Calls the Amazon Cloud Drive API to upload a file to Amazon Cloud Drive.
     *
     * @param Temboo_Session $session The session that owns this UploadFile Choreo.
     * @return Amazon_CloudDrive_Files_UploadFile New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/CloudDrive/Files/UploadFile/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this UploadFile Choreo.
     *
     * @param Amazon_CloudDrive_Files_UploadFile_Inputs|array $inputs (optional) Inputs as Amazon_CloudDrive_Files_UploadFile_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_CloudDrive_Files_UploadFile_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_CloudDrive_Files_UploadFile_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this UploadFile Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_CloudDrive_Files_UploadFile_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_CloudDrive_Files_UploadFile_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the UploadFile Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Files_UploadFile_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the UploadFile Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_CloudDrive_Files_UploadFile_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this UploadFile input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_CloudDrive_Files_UploadFile_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_CloudDrive_Files_UploadFile_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this UploadFile Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Amazon_CloudDrive_Files_UploadFile_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this UploadFile Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Amazon. Required unless providing a valid AccessToken.
     * @return Amazon_CloudDrive_Files_UploadFile_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this UploadFile Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Amazon. Required unless providing a valid AccessToken.
     * @return Amazon_CloudDrive_Files_UploadFile_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the ContentType input for this UploadFile Choreo.
     *
     * @param string $value (required, string) The Content-Type of the file that is being uploaded (e.g., image/jpeg, text/plain, etc.) Defaults to application/octet-stream.
     * @return Amazon_CloudDrive_Files_UploadFile_Inputs For method chaining.
     */
    public function setContentType($value)
    {
        return $this->set('ContentType', $value);
    }

    /**
     * Set the value for the ContentURL input for this UploadFile Choreo.
     *
     * @param string $value (optional, string) The appropriate contentUrl for your account. When not provided, the Choreo will lookup the URL using the Account.GetEndpoint Choreo.
     * @return Amazon_CloudDrive_Files_UploadFile_Inputs For method chaining.
     */
    public function setContentURL($value)
    {
        return $this->set('ContentURL', $value);
    }

    /**
     * Set the value for the FileContent input for this UploadFile Choreo.
     *
     * @param string $value (conditional, string) The Base64 encoded contents of the file to upload.
     * @return Amazon_CloudDrive_Files_UploadFile_Inputs For method chaining.
     */
    public function setFileContent($value)
    {
        return $this->set('FileContent', $value);
    }

    /**
     * Set the value for the HandleRequestThrottling input for this UploadFile Choreo.
     *
     * @param bool $value (optional, boolean) Whether or not to perform a retry sequence if a throttling error occurs. Set to true to enable this feature. The request will be retried up-to five times when enabled.
     * @return Amazon_CloudDrive_Files_UploadFile_Inputs For method chaining.
     */
    public function setHandleRequestThrottling($value)
    {
        return $this->set('HandleRequestThrottling', $value);
    }

    /**
     * Set the value for the Labels input for this UploadFile Choreo.
     *
     * @param string $value (optional, json) A JSON array containing labels to apply to the file.
     * @return Amazon_CloudDrive_Files_UploadFile_Inputs For method chaining.
     */
    public function setLabels($value)
    {
        return $this->set('Labels', $value);
    }

    /**
     * Set the value for the LocalID input for this UploadFile Choreo.
     *
     * @param string $value (optional, string) A unique ID within the application. Multiple POSTs with the same localId from the same application will result in the same node-id. If not provided the server will generate a node-id.
     * @return Amazon_CloudDrive_Files_UploadFile_Inputs For method chaining.
     */
    public function setLocalID($value)
    {
        return $this->set('LocalID', $value);
    }

    /**
     * Set the value for the Name input for this UploadFile Choreo.
     *
     * @param string $value (required, string) The name of the file being uploaded.
     * @return Amazon_CloudDrive_Files_UploadFile_Inputs For method chaining.
     */
    public function setName($value)
    {
        return $this->set('Name', $value);
    }

    /**
     * Set the value for the Parents input for this UploadFile Choreo.
     *
     * @param string $value (optional, json) A JSON array containing parent IDs associated with the new folder.
     * @return Amazon_CloudDrive_Files_UploadFile_Inputs For method chaining.
     */
    public function setParents($value)
    {
        return $this->set('Parents', $value);
    }

    /**
     * Set the value for the Properties input for this UploadFile Choreo.
     *
     * @param string $value (optional, json) A JSON object containing properties to be applied to the file.
     * @return Amazon_CloudDrive_Files_UploadFile_Inputs For method chaining.
     */
    public function setProperties($value)
    {
        return $this->set('Properties', $value);
    }

    /**
     * Set the value for the RefreshToken input for this UploadFile Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Amazon_CloudDrive_Files_UploadFile_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }

    /**
     * Set the value for the Supress input for this UploadFile Choreo.
     *
     * @param string $value (optional, string) Valid values are: "deduplication" (disables checking for duplicates when uploading) and "process" (disables any processing Amazon may do on the file).
     * @return Amazon_CloudDrive_Files_UploadFile_Inputs For method chaining.
     */
    public function setSupress($value)
    {
        return $this->set('Supress', $value);
    }

}


/**
 * Execution object for the UploadFile Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Files_UploadFile_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the UploadFile Choreo.
     *
     * @param Temboo_Session $session The session that owns this UploadFile execution.
     * @param Amazon_CloudDrive_Files_UploadFile $choreo The choreography object for this execution.
     * @param Amazon_CloudDrive_Files_UploadFile_Inputs|array $inputs (optional) Inputs as Amazon_CloudDrive_Files_UploadFile_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_CloudDrive_Files_UploadFile_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_CloudDrive_Files_UploadFile $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this UploadFile execution.
     *
     * @return Amazon_CloudDrive_Files_UploadFile_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this UploadFile execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_CloudDrive_Files_UploadFile_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_CloudDrive_Files_UploadFile_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the UploadFile Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Files_UploadFile_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the UploadFile Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_CloudDrive_Files_UploadFile_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this UploadFile execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this UploadFile execution.
     *
     * @return string (json) The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Creates a new folder using the Amazon Cloud Drive API.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Folders_CreateFolder extends Temboo_Choreography
{
    /**
     * Creates a new folder using the Amazon Cloud Drive API.
     *
     * @param Temboo_Session $session The session that owns this CreateFolder Choreo.
     * @return Amazon_CloudDrive_Folders_CreateFolder New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/CloudDrive/Folders/CreateFolder/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this CreateFolder Choreo.
     *
     * @param Amazon_CloudDrive_Folders_CreateFolder_Inputs|array $inputs (optional) Inputs as Amazon_CloudDrive_Folders_CreateFolder_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_CloudDrive_Folders_CreateFolder_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_CloudDrive_Folders_CreateFolder_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this CreateFolder Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_CloudDrive_Folders_CreateFolder_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_CloudDrive_Folders_CreateFolder_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the CreateFolder Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Folders_CreateFolder_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the CreateFolder Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_CloudDrive_Folders_CreateFolder_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this CreateFolder input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_CloudDrive_Folders_CreateFolder_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_CloudDrive_Folders_CreateFolder_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this CreateFolder Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Amazon_CloudDrive_Folders_CreateFolder_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this CreateFolder Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Amazon. Required unless providing a valid AccessToken.
     * @return Amazon_CloudDrive_Folders_CreateFolder_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this CreateFolder Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Amazon. Required unless providing a valid AccessToken.
     * @return Amazon_CloudDrive_Folders_CreateFolder_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the HandleRequestThrottling input for this CreateFolder Choreo.
     *
     * @param bool $value (optional, boolean) Whether or not to perform a retry sequence if a throttling error occurs. Set to true to enable this feature. The request will be retried up-to five times when enabled.
     * @return Amazon_CloudDrive_Folders_CreateFolder_Inputs For method chaining.
     */
    public function setHandleRequestThrottling($value)
    {
        return $this->set('HandleRequestThrottling', $value);
    }

    /**
     * Set the value for the Labels input for this CreateFolder Choreo.
     *
     * @param string $value (optional, json) A JSON array containing labels to apply to the folder.
     * @return Amazon_CloudDrive_Folders_CreateFolder_Inputs For method chaining.
     */
    public function setLabels($value)
    {
        return $this->set('Labels', $value);
    }

    /**
     * Set the value for the LocalID input for this CreateFolder Choreo.
     *
     * @param string $value (optional, string) Globally unique client local Id for the customer.
     * @return Amazon_CloudDrive_Folders_CreateFolder_Inputs For method chaining.
     */
    public function setLocalID($value)
    {
        return $this->set('LocalID', $value);
    }

    /**
     * Set the value for the MetaDataURL input for this CreateFolder Choreo.
     *
     * @param string $value (optional, string) The appropriate metadataUrl for your account. When not provided, the Choreo will lookup the URL using the Account.GetEndpoint Choreo.
     * @return Amazon_CloudDrive_Folders_CreateFolder_Inputs For method chaining.
     */
    public function setMetaDataURL($value)
    {
        return $this->set('MetaDataURL', $value);
    }

    /**
     * Set the value for the Name input for this CreateFolder Choreo.
     *
     * @param string $value (required, string) The name of the new folder.
     * @return Amazon_CloudDrive_Folders_CreateFolder_Inputs For method chaining.
     */
    public function setName($value)
    {
        return $this->set('Name', $value);
    }

    /**
     * Set the value for the Parents input for this CreateFolder Choreo.
     *
     * @param string $value (optional, json) A JSON array containing parent names associated with the new folder.
     * @return Amazon_CloudDrive_Folders_CreateFolder_Inputs For method chaining.
     */
    public function setParents($value)
    {
        return $this->set('Parents', $value);
    }

    /**
     * Set the value for the Properties input for this CreateFolder Choreo.
     *
     * @param string $value (optional, json) A JSON object containing properties to be applied to the folder.
     * @return Amazon_CloudDrive_Folders_CreateFolder_Inputs For method chaining.
     */
    public function setProperties($value)
    {
        return $this->set('Properties', $value);
    }

    /**
     * Set the value for the RefreshToken input for this CreateFolder Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Amazon_CloudDrive_Folders_CreateFolder_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }
}


/**
 * Execution object for the CreateFolder Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Folders_CreateFolder_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the CreateFolder Choreo.
     *
     * @param Temboo_Session $session The session that owns this CreateFolder execution.
     * @param Amazon_CloudDrive_Folders_CreateFolder $choreo The choreography object for this execution.
     * @param Amazon_CloudDrive_Folders_CreateFolder_Inputs|array $inputs (optional) Inputs as Amazon_CloudDrive_Folders_CreateFolder_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_CloudDrive_Folders_CreateFolder_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_CloudDrive_Folders_CreateFolder $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this CreateFolder execution.
     *
     * @return Amazon_CloudDrive_Folders_CreateFolder_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this CreateFolder execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_CloudDrive_Folders_CreateFolder_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_CloudDrive_Folders_CreateFolder_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the CreateFolder Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Folders_CreateFolder_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the CreateFolder Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_CloudDrive_Folders_CreateFolder_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this CreateFolder execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this CreateFolder execution.
     *
     * @return string (json) The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Retrieves metadata for a specific folder using the Amazon Cloud Drive API.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Folders_GetFolderMetadata extends Temboo_Choreography
{
    /**
     * Retrieves metadata for a specific folder using the Amazon Cloud Drive API.
     *
     * @param Temboo_Session $session The session that owns this GetFolderMetadata Choreo.
     * @return Amazon_CloudDrive_Folders_GetFolderMetadata New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/CloudDrive/Folders/GetFolderMetadata/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this GetFolderMetadata Choreo.
     *
     * @param Amazon_CloudDrive_Folders_GetFolderMetadata_Inputs|array $inputs (optional) Inputs as Amazon_CloudDrive_Folders_GetFolderMetadata_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_CloudDrive_Folders_GetFolderMetadata_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_CloudDrive_Folders_GetFolderMetadata_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this GetFolderMetadata Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_CloudDrive_Folders_GetFolderMetadata_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_CloudDrive_Folders_GetFolderMetadata_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the GetFolderMetadata Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Folders_GetFolderMetadata_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the GetFolderMetadata Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_CloudDrive_Folders_GetFolderMetadata_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this GetFolderMetadata input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_CloudDrive_Folders_GetFolderMetadata_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_CloudDrive_Folders_GetFolderMetadata_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this GetFolderMetadata Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Amazon_CloudDrive_Folders_GetFolderMetadata_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this GetFolderMetadata Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Amazon. Required unless providing a valid AccessToken.
     * @return Amazon_CloudDrive_Folders_GetFolderMetadata_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this GetFolderMetadata Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Amazon. Required unless providing a valid AccessToken.
     * @return Amazon_CloudDrive_Folders_GetFolderMetadata_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Fields input for this GetFolderMetadata Choreo.
     *
     * @param string $value (optional, string) A comma-separated list of additional fields to include in the response.
     * @return Amazon_CloudDrive_Folders_GetFolderMetadata_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the HandleRequestThrottling input for this GetFolderMetadata Choreo.
     *
     * @param bool $value (optional, boolean) Whether or not to perform a retry sequence if a throttling error occurs. Set to true to enable this feature. The request will be retried up-to five times when enabled.
     * @return Amazon_CloudDrive_Folders_GetFolderMetadata_Inputs For method chaining.
     */
    public function setHandleRequestThrottling($value)
    {
        return $this->set('HandleRequestThrottling', $value);
    }

    /**
     * Set the value for the ID input for this GetFolderMetadata Choreo.
     *
     * @param string $value (required, string) The ID of the folder to return metadata for.
     * @return Amazon_CloudDrive_Folders_GetFolderMetadata_Inputs For method chaining.
     */
    public function setID($value)
    {
        return $this->set('ID', $value);
    }

    /**
     * Set the value for the MetaDataURL input for this GetFolderMetadata Choreo.
     *
     * @param string $value (optional, string) The appropriate metadataUrl for your account. When not provided, the Choreo will lookup the URL using the Account.GetEndpoint Choreo.
     * @return Amazon_CloudDrive_Folders_GetFolderMetadata_Inputs For method chaining.
     */
    public function setMetaDataURL($value)
    {
        return $this->set('MetaDataURL', $value);
    }

    /**
     * Set the value for the RefreshToken input for this GetFolderMetadata Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Amazon_CloudDrive_Folders_GetFolderMetadata_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }
}


/**
 * Execution object for the GetFolderMetadata Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Folders_GetFolderMetadata_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the GetFolderMetadata Choreo.
     *
     * @param Temboo_Session $session The session that owns this GetFolderMetadata execution.
     * @param Amazon_CloudDrive_Folders_GetFolderMetadata $choreo The choreography object for this execution.
     * @param Amazon_CloudDrive_Folders_GetFolderMetadata_Inputs|array $inputs (optional) Inputs as Amazon_CloudDrive_Folders_GetFolderMetadata_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_CloudDrive_Folders_GetFolderMetadata_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_CloudDrive_Folders_GetFolderMetadata $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this GetFolderMetadata execution.
     *
     * @return Amazon_CloudDrive_Folders_GetFolderMetadata_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this GetFolderMetadata execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_CloudDrive_Folders_GetFolderMetadata_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_CloudDrive_Folders_GetFolderMetadata_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the GetFolderMetadata Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Folders_GetFolderMetadata_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the GetFolderMetadata Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_CloudDrive_Folders_GetFolderMetadata_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this GetFolderMetadata execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this GetFolderMetadata execution.
     *
     * @return string (json) The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Queries the Amazon Cloud Drive API to return a list of folders.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Folders_ListFolders extends Temboo_Choreography
{
    /**
     * Queries the Amazon Cloud Drive API to return a list of folders.
     *
     * @param Temboo_Session $session The session that owns this ListFolders Choreo.
     * @return Amazon_CloudDrive_Folders_ListFolders New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/CloudDrive/Folders/ListFolders/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this ListFolders Choreo.
     *
     * @param Amazon_CloudDrive_Folders_ListFolders_Inputs|array $inputs (optional) Inputs as Amazon_CloudDrive_Folders_ListFolders_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_CloudDrive_Folders_ListFolders_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_CloudDrive_Folders_ListFolders_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this ListFolders Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_CloudDrive_Folders_ListFolders_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_CloudDrive_Folders_ListFolders_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the ListFolders Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Folders_ListFolders_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the ListFolders Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_CloudDrive_Folders_ListFolders_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this ListFolders input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_CloudDrive_Folders_ListFolders_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_CloudDrive_Folders_ListFolders_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this ListFolders Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Amazon_CloudDrive_Folders_ListFolders_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this ListFolders Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Amazon. Required unless providing a valid AccessToken.
     * @return Amazon_CloudDrive_Folders_ListFolders_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this ListFolders Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Amazon. Required unless providing a valid AccessToken.
     * @return Amazon_CloudDrive_Folders_ListFolders_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Fields input for this ListFolders Choreo.
     *
     * @param string $value (optional, string) A comma-separated list of additional fields to include in the response.
     * @return Amazon_CloudDrive_Folders_ListFolders_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Filters input for this ListFolders Choreo.
     *
     * @param string $value (optional, string) A filter used to narrow the result set (e.g., name:Documents). The default value is "kind:FOLDER". To a make a request using no filters, you can pass "none".
     * @return Amazon_CloudDrive_Folders_ListFolders_Inputs For method chaining.
     */
    public function setFilters($value)
    {
        return $this->set('Filters', $value);
    }

    /**
     * Set the value for the HandleRequestThrottling input for this ListFolders Choreo.
     *
     * @param bool $value (optional, boolean) Whether or not to perform a retry sequence if a throttling error occurs. Set to true to enable this feature. The request will be retried up-to five times when enabled.
     * @return Amazon_CloudDrive_Folders_ListFolders_Inputs For method chaining.
     */
    public function setHandleRequestThrottling($value)
    {
        return $this->set('HandleRequestThrottling', $value);
    }

    /**
     * Set the value for the Limit input for this ListFolders Choreo.
     *
     * @param string $value (optional, string) The maximum number of records to be returned.
     * @return Amazon_CloudDrive_Folders_ListFolders_Inputs For method chaining.
     */
    public function setLimit($value)
    {
        return $this->set('Limit', $value);
    }

    /**
     * Set the value for the MetaDataURL input for this ListFolders Choreo.
     *
     * @param string $value (optional, string) The appropriate metadataUrl for you account. When not provided, the Choreo will lookup the URL using the Account.GetEndpoint Choreo.
     * @return Amazon_CloudDrive_Folders_ListFolders_Inputs For method chaining.
     */
    public function setMetaDataURL($value)
    {
        return $this->set('MetaDataURL', $value);
    }

    /**
     * Set the value for the RefreshToken input for this ListFolders Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Amazon_CloudDrive_Folders_ListFolders_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }

    /**
     * Set the value for the Sort input for this ListFolders Choreo.
     *
     * @param string $value (optional, json) A JSON array containing sort properties (e.g., ["name ASC","contentProperties.size" DESC]).
     * @return Amazon_CloudDrive_Folders_ListFolders_Inputs For method chaining.
     */
    public function setSort($value)
    {
        return $this->set('Sort', $value);
    }

    /**
     * Set the value for the StartToken input for this ListFolders Choreo.
     *
     * @param string $value (optional, string) The nextToken returned from a previous request. Used to paginate through results.
     * @return Amazon_CloudDrive_Folders_ListFolders_Inputs For method chaining.
     */
    public function setStartToken($value)
    {
        return $this->set('StartToken', $value);
    }
}


/**
 * Execution object for the ListFolders Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Folders_ListFolders_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the ListFolders Choreo.
     *
     * @param Temboo_Session $session The session that owns this ListFolders execution.
     * @param Amazon_CloudDrive_Folders_ListFolders $choreo The choreography object for this execution.
     * @param Amazon_CloudDrive_Folders_ListFolders_Inputs|array $inputs (optional) Inputs as Amazon_CloudDrive_Folders_ListFolders_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_CloudDrive_Folders_ListFolders_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_CloudDrive_Folders_ListFolders $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this ListFolders execution.
     *
     * @return Amazon_CloudDrive_Folders_ListFolders_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this ListFolders execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_CloudDrive_Folders_ListFolders_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_CloudDrive_Folders_ListFolders_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the ListFolders Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Folders_ListFolders_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the ListFolders Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_CloudDrive_Folders_ListFolders_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this ListFolders execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this ListFolders execution.
     *
     * @return string (json) The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Adds a property to a file or folder using the Amazon Cloud Drive API.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Properties_AddProperty extends Temboo_Choreography
{
    /**
     * Adds a property to a file or folder using the Amazon Cloud Drive API.
     *
     * @param Temboo_Session $session The session that owns this AddProperty Choreo.
     * @return Amazon_CloudDrive_Properties_AddProperty New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/CloudDrive/Properties/AddProperty/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this AddProperty Choreo.
     *
     * @param Amazon_CloudDrive_Properties_AddProperty_Inputs|array $inputs (optional) Inputs as Amazon_CloudDrive_Properties_AddProperty_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_CloudDrive_Properties_AddProperty_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_CloudDrive_Properties_AddProperty_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this AddProperty Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_CloudDrive_Properties_AddProperty_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_CloudDrive_Properties_AddProperty_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the AddProperty Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Properties_AddProperty_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the AddProperty Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_CloudDrive_Properties_AddProperty_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this AddProperty input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_CloudDrive_Properties_AddProperty_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_CloudDrive_Properties_AddProperty_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the Value input for this AddProperty Choreo.
     *
     * @param string $value (required, string) The value of the property. Max length 500 characters.
     * @return Amazon_CloudDrive_Properties_AddProperty_Inputs For method chaining.
     */
    public function setValue($value)
    {
        return $this->set('Value', $value);
    }

    /**
     * Set the value for the AccessToken input for this AddProperty Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Amazon_CloudDrive_Properties_AddProperty_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this AddProperty Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Amazon. Required unless providing a valid AccessToken.
     * @return Amazon_CloudDrive_Properties_AddProperty_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this AddProperty Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Amazon. Required unless providing a valid AccessToken.
     * @return Amazon_CloudDrive_Properties_AddProperty_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the HandleRequestThrottling input for this AddProperty Choreo.
     *
     * @param bool $value (optional, boolean) Whether or not to perform a retry sequence if a throttling error occurs. Set to true to enable this feature. The request will be retried up-to five times when enabled.
     * @return Amazon_CloudDrive_Properties_AddProperty_Inputs For method chaining.
     */
    public function setHandleRequestThrottling($value)
    {
        return $this->set('HandleRequestThrottling', $value);
    }

    /**
     * Set the value for the ID input for this AddProperty Choreo.
     *
     * @param string $value (required, string) The ID of the file or folder to which the properties needs to be added.
     * @return Amazon_CloudDrive_Properties_AddProperty_Inputs For method chaining.
     */
    public function setID($value)
    {
        return $this->set('ID', $value);
    }

    /**
     * Set the value for the Key input for this AddProperty Choreo.
     *
     * @param string $value (required, string) The key of the properties which needs to be added. The key should just contain alphanumeric and "_". Max length is 50 characters.
     * @return Amazon_CloudDrive_Properties_AddProperty_Inputs For method chaining.
     */
    public function setKey($value)
    {
        return $this->set('Key', $value);
    }

    /**
     * Set the value for the MetaDataURL input for this AddProperty Choreo.
     *
     * @param string $value (optional, string) The appropriate metadataUrl for your account. When not provided, the Choreo will lookup the URL using the Account.GetEndpoint Choreo.
     * @return Amazon_CloudDrive_Properties_AddProperty_Inputs For method chaining.
     */
    public function setMetaDataURL($value)
    {
        return $this->set('MetaDataURL', $value);
    }

    /**
     * Set the value for the Owner input for this AddProperty Choreo.
     *
     * @param string $value (required, string) The "owner" of property.
     * @return Amazon_CloudDrive_Properties_AddProperty_Inputs For method chaining.
     */
    public function setOwner($value)
    {
        return $this->set('Owner', $value);
    }

    /**
     * Set the value for the RefreshToken input for this AddProperty Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Amazon_CloudDrive_Properties_AddProperty_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }
}


/**
 * Execution object for the AddProperty Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Properties_AddProperty_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the AddProperty Choreo.
     *
     * @param Temboo_Session $session The session that owns this AddProperty execution.
     * @param Amazon_CloudDrive_Properties_AddProperty $choreo The choreography object for this execution.
     * @param Amazon_CloudDrive_Properties_AddProperty_Inputs|array $inputs (optional) Inputs as Amazon_CloudDrive_Properties_AddProperty_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_CloudDrive_Properties_AddProperty_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_CloudDrive_Properties_AddProperty $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this AddProperty execution.
     *
     * @return Amazon_CloudDrive_Properties_AddProperty_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this AddProperty execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_CloudDrive_Properties_AddProperty_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_CloudDrive_Properties_AddProperty_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the AddProperty Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Properties_AddProperty_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the AddProperty Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_CloudDrive_Properties_AddProperty_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this AddProperty execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this AddProperty execution.
     *
     * @return string (json) The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Uses the Amazon Cloud Drive API to delete a specific property by key.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Properties_DeleteProperty extends Temboo_Choreography
{
    /**
     * Uses the Amazon Cloud Drive API to delete a specific property by key.
     *
     * @param Temboo_Session $session The session that owns this DeleteProperty Choreo.
     * @return Amazon_CloudDrive_Properties_DeleteProperty New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/CloudDrive/Properties/DeleteProperty/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this DeleteProperty Choreo.
     *
     * @param Amazon_CloudDrive_Properties_DeleteProperty_Inputs|array $inputs (optional) Inputs as Amazon_CloudDrive_Properties_DeleteProperty_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_CloudDrive_Properties_DeleteProperty_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_CloudDrive_Properties_DeleteProperty_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this DeleteProperty Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_CloudDrive_Properties_DeleteProperty_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_CloudDrive_Properties_DeleteProperty_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the DeleteProperty Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Properties_DeleteProperty_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the DeleteProperty Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_CloudDrive_Properties_DeleteProperty_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this DeleteProperty input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_CloudDrive_Properties_DeleteProperty_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_CloudDrive_Properties_DeleteProperty_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this DeleteProperty Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Amazon_CloudDrive_Properties_DeleteProperty_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this DeleteProperty Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Amazon. Required unless providing a valid AccessToken.
     * @return Amazon_CloudDrive_Properties_DeleteProperty_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this DeleteProperty Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Amazon. Required unless providing a valid AccessToken.
     * @return Amazon_CloudDrive_Properties_DeleteProperty_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the HandleRequestThrottling input for this DeleteProperty Choreo.
     *
     * @param bool $value (optional, boolean) Whether or not to perform a retry sequence if a throttling error occurs. Set to true to enable this feature. The request will be retried up-to five times when enabled.
     * @return Amazon_CloudDrive_Properties_DeleteProperty_Inputs For method chaining.
     */
    public function setHandleRequestThrottling($value)
    {
        return $this->set('HandleRequestThrottling', $value);
    }

    /**
     * Set the value for the ID input for this DeleteProperty Choreo.
     *
     * @param string $value (required, string) The ID of the file or folder associated with the property being deleted.
     * @return Amazon_CloudDrive_Properties_DeleteProperty_Inputs For method chaining.
     */
    public function setID($value)
    {
        return $this->set('ID', $value);
    }

    /**
     * Set the value for the Key input for this DeleteProperty Choreo.
     *
     * @param string $value (required, string) The key of the properties which needs to be deleted.
     * @return Amazon_CloudDrive_Properties_DeleteProperty_Inputs For method chaining.
     */
    public function setKey($value)
    {
        return $this->set('Key', $value);
    }

    /**
     * Set the value for the MetaDataURL input for this DeleteProperty Choreo.
     *
     * @param string $value (optional, string) The appropriate metadataUrl for your account. When not provided, the Choreo will lookup the URL using the Account.GetEndpoint Choreo.
     * @return Amazon_CloudDrive_Properties_DeleteProperty_Inputs For method chaining.
     */
    public function setMetaDataURL($value)
    {
        return $this->set('MetaDataURL', $value);
    }

    /**
     * Set the value for the Owner input for this DeleteProperty Choreo.
     *
     * @param string $value (required, string) The "owner" of property.
     * @return Amazon_CloudDrive_Properties_DeleteProperty_Inputs For method chaining.
     */
    public function setOwner($value)
    {
        return $this->set('Owner', $value);
    }

    /**
     * Set the value for the RefreshToken input for this DeleteProperty Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Amazon_CloudDrive_Properties_DeleteProperty_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }
}


/**
 * Execution object for the DeleteProperty Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Properties_DeleteProperty_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the DeleteProperty Choreo.
     *
     * @param Temboo_Session $session The session that owns this DeleteProperty execution.
     * @param Amazon_CloudDrive_Properties_DeleteProperty $choreo The choreography object for this execution.
     * @param Amazon_CloudDrive_Properties_DeleteProperty_Inputs|array $inputs (optional) Inputs as Amazon_CloudDrive_Properties_DeleteProperty_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_CloudDrive_Properties_DeleteProperty_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_CloudDrive_Properties_DeleteProperty $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this DeleteProperty execution.
     *
     * @return Amazon_CloudDrive_Properties_DeleteProperty_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this DeleteProperty execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_CloudDrive_Properties_DeleteProperty_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_CloudDrive_Properties_DeleteProperty_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the DeleteProperty Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Properties_DeleteProperty_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the DeleteProperty Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_CloudDrive_Properties_DeleteProperty_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this DeleteProperty execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "ResponseStatusCode" output from this DeleteProperty execution.
     *
     * @return int (integer) The response status code returned from Amazon. A 204 is returned for a successful delete operation.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponseStatusCode()
    {
        return $this->get('ResponseStatusCode');
    }
    /**
     * Retrieve the value for the "Response" output from this DeleteProperty execution.
     *
     * @return string (json) The response from Amazon. An empty result object is returned for a successful delete operation.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Queries the Amazon Cloud Drive API to retrieve a specific property by key.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Properties_GetProperty extends Temboo_Choreography
{
    /**
     * Queries the Amazon Cloud Drive API to retrieve a specific property by key.
     *
     * @param Temboo_Session $session The session that owns this GetProperty Choreo.
     * @return Amazon_CloudDrive_Properties_GetProperty New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/CloudDrive/Properties/GetProperty/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this GetProperty Choreo.
     *
     * @param Amazon_CloudDrive_Properties_GetProperty_Inputs|array $inputs (optional) Inputs as Amazon_CloudDrive_Properties_GetProperty_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_CloudDrive_Properties_GetProperty_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_CloudDrive_Properties_GetProperty_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this GetProperty Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_CloudDrive_Properties_GetProperty_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_CloudDrive_Properties_GetProperty_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the GetProperty Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Properties_GetProperty_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the GetProperty Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_CloudDrive_Properties_GetProperty_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this GetProperty input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_CloudDrive_Properties_GetProperty_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_CloudDrive_Properties_GetProperty_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this GetProperty Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Amazon_CloudDrive_Properties_GetProperty_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this GetProperty Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Amazon. Required unless providing a valid AccessToken.
     * @return Amazon_CloudDrive_Properties_GetProperty_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this GetProperty Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Amazon. Required unless providing a valid AccessToken.
     * @return Amazon_CloudDrive_Properties_GetProperty_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the HandleRequestThrottling input for this GetProperty Choreo.
     *
     * @param bool $value (optional, boolean) Whether or not to perform a retry sequence if a throttling error occurs. Set to true to enable this feature. The request will be retried up-to five times when enabled.
     * @return Amazon_CloudDrive_Properties_GetProperty_Inputs For method chaining.
     */
    public function setHandleRequestThrottling($value)
    {
        return $this->set('HandleRequestThrottling', $value);
    }

    /**
     * Set the value for the ID input for this GetProperty Choreo.
     *
     * @param string $value (required, string) The ID of the file or folder associated with the property being retrieved.
     * @return Amazon_CloudDrive_Properties_GetProperty_Inputs For method chaining.
     */
    public function setID($value)
    {
        return $this->set('ID', $value);
    }

    /**
     * Set the value for the Key input for this GetProperty Choreo.
     *
     * @param string $value (required, string) The key of the properties which needs to be retrieved.
     * @return Amazon_CloudDrive_Properties_GetProperty_Inputs For method chaining.
     */
    public function setKey($value)
    {
        return $this->set('Key', $value);
    }

    /**
     * Set the value for the MetaDataURL input for this GetProperty Choreo.
     *
     * @param string $value (optional, string) The appropriate metadataUrl for your account. When not provided, the Choreo will lookup the URL using the Account.GetEndpoint Choreo.
     * @return Amazon_CloudDrive_Properties_GetProperty_Inputs For method chaining.
     */
    public function setMetaDataURL($value)
    {
        return $this->set('MetaDataURL', $value);
    }

    /**
     * Set the value for the Owner input for this GetProperty Choreo.
     *
     * @param string $value (required, string) The "owner" of property.
     * @return Amazon_CloudDrive_Properties_GetProperty_Inputs For method chaining.
     */
    public function setOwner($value)
    {
        return $this->set('Owner', $value);
    }

    /**
     * Set the value for the RefreshToken input for this GetProperty Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Amazon_CloudDrive_Properties_GetProperty_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }
}


/**
 * Execution object for the GetProperty Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Properties_GetProperty_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the GetProperty Choreo.
     *
     * @param Temboo_Session $session The session that owns this GetProperty execution.
     * @param Amazon_CloudDrive_Properties_GetProperty $choreo The choreography object for this execution.
     * @param Amazon_CloudDrive_Properties_GetProperty_Inputs|array $inputs (optional) Inputs as Amazon_CloudDrive_Properties_GetProperty_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_CloudDrive_Properties_GetProperty_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_CloudDrive_Properties_GetProperty $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this GetProperty execution.
     *
     * @return Amazon_CloudDrive_Properties_GetProperty_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this GetProperty execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_CloudDrive_Properties_GetProperty_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_CloudDrive_Properties_GetProperty_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the GetProperty Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Properties_GetProperty_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the GetProperty Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_CloudDrive_Properties_GetProperty_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this GetProperty execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this GetProperty execution.
     *
     * @return string (json) The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Queries the Amazon Cloud Drive API to return a list of properties for a specified file or folder.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Properties_ListProperties extends Temboo_Choreography
{
    /**
     * Queries the Amazon Cloud Drive API to return a list of properties for a specified file or folder.
     *
     * @param Temboo_Session $session The session that owns this ListProperties Choreo.
     * @return Amazon_CloudDrive_Properties_ListProperties New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/CloudDrive/Properties/ListProperties/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this ListProperties Choreo.
     *
     * @param Amazon_CloudDrive_Properties_ListProperties_Inputs|array $inputs (optional) Inputs as Amazon_CloudDrive_Properties_ListProperties_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_CloudDrive_Properties_ListProperties_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_CloudDrive_Properties_ListProperties_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this ListProperties Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_CloudDrive_Properties_ListProperties_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_CloudDrive_Properties_ListProperties_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the ListProperties Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Properties_ListProperties_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the ListProperties Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_CloudDrive_Properties_ListProperties_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this ListProperties input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_CloudDrive_Properties_ListProperties_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_CloudDrive_Properties_ListProperties_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this ListProperties Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Amazon_CloudDrive_Properties_ListProperties_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this ListProperties Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Amazon. Required unless providing a valid AccessToken.
     * @return Amazon_CloudDrive_Properties_ListProperties_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this ListProperties Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Amazon. Required unless providing a valid AccessToken.
     * @return Amazon_CloudDrive_Properties_ListProperties_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the HandleRequestThrottling input for this ListProperties Choreo.
     *
     * @param int $value (optional, integer) Whether or not to perform a retry sequence if a throttling error occurs. Set to true to enable this feature. The request will be retried up-to five times when enabled.
     * @return Amazon_CloudDrive_Properties_ListProperties_Inputs For method chaining.
     */
    public function setHandleRequestThrottling($value)
    {
        return $this->set('HandleRequestThrottling', $value);
    }

    /**
     * Set the value for the ID input for this ListProperties Choreo.
     *
     * @param string $value (required, string) The ID of the file or folder to list properties for.
     * @return Amazon_CloudDrive_Properties_ListProperties_Inputs For method chaining.
     */
    public function setID($value)
    {
        return $this->set('ID', $value);
    }

    /**
     * Set the value for the MetaDataURL input for this ListProperties Choreo.
     *
     * @param string $value (optional, string) The appropriate metadataUrl for you account. When not provided, the Choreo will lookup the URL using the Account.GetEndpoint Choreo.
     * @return Amazon_CloudDrive_Properties_ListProperties_Inputs For method chaining.
     */
    public function setMetaDataURL($value)
    {
        return $this->set('MetaDataURL', $value);
    }

    /**
     * Set the value for the Owner input for this ListProperties Choreo.
     *
     * @param string $value (required, string) The "owner" of properties to list.
     * @return Amazon_CloudDrive_Properties_ListProperties_Inputs For method chaining.
     */
    public function setOwner($value)
    {
        return $this->set('Owner', $value);
    }

    /**
     * Set the value for the RefreshToken input for this ListProperties Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Amazon_CloudDrive_Properties_ListProperties_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }
}


/**
 * Execution object for the ListProperties Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Properties_ListProperties_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the ListProperties Choreo.
     *
     * @param Temboo_Session $session The session that owns this ListProperties execution.
     * @param Amazon_CloudDrive_Properties_ListProperties $choreo The choreography object for this execution.
     * @param Amazon_CloudDrive_Properties_ListProperties_Inputs|array $inputs (optional) Inputs as Amazon_CloudDrive_Properties_ListProperties_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_CloudDrive_Properties_ListProperties_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_CloudDrive_Properties_ListProperties $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this ListProperties execution.
     *
     * @return Amazon_CloudDrive_Properties_ListProperties_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this ListProperties execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_CloudDrive_Properties_ListProperties_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_CloudDrive_Properties_ListProperties_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the ListProperties Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Properties_ListProperties_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the ListProperties Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_CloudDrive_Properties_ListProperties_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this ListProperties execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this ListProperties execution.
     *
     * @return string (json) The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Uses the Amazon Cloud Drive API to move a specific file or folder to the trash.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Trash_AddToTrash extends Temboo_Choreography
{
    /**
     * Uses the Amazon Cloud Drive API to move a specific file or folder to the trash.
     *
     * @param Temboo_Session $session The session that owns this AddToTrash Choreo.
     * @return Amazon_CloudDrive_Trash_AddToTrash New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/CloudDrive/Trash/AddToTrash/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this AddToTrash Choreo.
     *
     * @param Amazon_CloudDrive_Trash_AddToTrash_Inputs|array $inputs (optional) Inputs as Amazon_CloudDrive_Trash_AddToTrash_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_CloudDrive_Trash_AddToTrash_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_CloudDrive_Trash_AddToTrash_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this AddToTrash Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_CloudDrive_Trash_AddToTrash_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_CloudDrive_Trash_AddToTrash_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the AddToTrash Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Trash_AddToTrash_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the AddToTrash Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_CloudDrive_Trash_AddToTrash_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this AddToTrash input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_CloudDrive_Trash_AddToTrash_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_CloudDrive_Trash_AddToTrash_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this AddToTrash Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Amazon_CloudDrive_Trash_AddToTrash_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this AddToTrash Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Amazon. Required unless providing a valid AccessToken.
     * @return Amazon_CloudDrive_Trash_AddToTrash_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this AddToTrash Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Amazon. Required unless providing a valid AccessToken.
     * @return Amazon_CloudDrive_Trash_AddToTrash_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the HandleRequestThrottling input for this AddToTrash Choreo.
     *
     * @param bool $value (optional, boolean) Whether or not to perform a retry sequence if a throttling error occurs. Set to true to enable this feature. The request will be retried up-to five times when enabled.
     * @return Amazon_CloudDrive_Trash_AddToTrash_Inputs For method chaining.
     */
    public function setHandleRequestThrottling($value)
    {
        return $this->set('HandleRequestThrottling', $value);
    }

    /**
     * Set the value for the ID input for this AddToTrash Choreo.
     *
     * @param string $value (required, string) The ID of the folder to put in the trash.
     * @return Amazon_CloudDrive_Trash_AddToTrash_Inputs For method chaining.
     */
    public function setID($value)
    {
        return $this->set('ID', $value);
    }

    /**
     * Set the value for the MetaDataURL input for this AddToTrash Choreo.
     *
     * @param string $value (optional, string) The appropriate metadataUrl for your account. When not provided, the Choreo will lookup the URL using the Account.GetEndpoint Choreo.
     * @return Amazon_CloudDrive_Trash_AddToTrash_Inputs For method chaining.
     */
    public function setMetaDataURL($value)
    {
        return $this->set('MetaDataURL', $value);
    }

    /**
     * Set the value for the RefreshToken input for this AddToTrash Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Amazon_CloudDrive_Trash_AddToTrash_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }
}


/**
 * Execution object for the AddToTrash Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Trash_AddToTrash_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the AddToTrash Choreo.
     *
     * @param Temboo_Session $session The session that owns this AddToTrash execution.
     * @param Amazon_CloudDrive_Trash_AddToTrash $choreo The choreography object for this execution.
     * @param Amazon_CloudDrive_Trash_AddToTrash_Inputs|array $inputs (optional) Inputs as Amazon_CloudDrive_Trash_AddToTrash_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_CloudDrive_Trash_AddToTrash_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_CloudDrive_Trash_AddToTrash $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this AddToTrash execution.
     *
     * @return Amazon_CloudDrive_Trash_AddToTrash_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this AddToTrash execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_CloudDrive_Trash_AddToTrash_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_CloudDrive_Trash_AddToTrash_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the AddToTrash Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Trash_AddToTrash_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the AddToTrash Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_CloudDrive_Trash_AddToTrash_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this AddToTrash execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this AddToTrash execution.
     *
     * @return string (json) The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Queries the Amazon Cloud Drive API to return metadata for items in the trash.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Trash_ListTrash extends Temboo_Choreography
{
    /**
     * Queries the Amazon Cloud Drive API to return metadata for items in the trash.
     *
     * @param Temboo_Session $session The session that owns this ListTrash Choreo.
     * @return Amazon_CloudDrive_Trash_ListTrash New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/CloudDrive/Trash/ListTrash/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this ListTrash Choreo.
     *
     * @param Amazon_CloudDrive_Trash_ListTrash_Inputs|array $inputs (optional) Inputs as Amazon_CloudDrive_Trash_ListTrash_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_CloudDrive_Trash_ListTrash_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_CloudDrive_Trash_ListTrash_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this ListTrash Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_CloudDrive_Trash_ListTrash_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_CloudDrive_Trash_ListTrash_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the ListTrash Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Trash_ListTrash_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the ListTrash Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_CloudDrive_Trash_ListTrash_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this ListTrash input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_CloudDrive_Trash_ListTrash_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_CloudDrive_Trash_ListTrash_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this ListTrash Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Amazon_CloudDrive_Trash_ListTrash_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this ListTrash Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Amazon. Required unless providing a valid AccessToken.
     * @return Amazon_CloudDrive_Trash_ListTrash_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this ListTrash Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Amazon. Required unless providing a valid AccessToken.
     * @return Amazon_CloudDrive_Trash_ListTrash_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Fields input for this ListTrash Choreo.
     *
     * @param string $value (optional, string) A comma-separated list of additional fields to include in the response.
     * @return Amazon_CloudDrive_Trash_ListTrash_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Filters input for this ListTrash Choreo.
     *
     * @param string $value (optional, string) A filter used to narrow the result set (e.g., name:Documents). The default value is "kind:FOLDER". To a make a request using no filters, you can pass "none".
     * @return Amazon_CloudDrive_Trash_ListTrash_Inputs For method chaining.
     */
    public function setFilters($value)
    {
        return $this->set('Filters', $value);
    }

    /**
     * Set the value for the HandleRequestThrottling input for this ListTrash Choreo.
     *
     * @param bool $value (optional, boolean) Whether or not to perform a retry sequence if a throttling error occurs. Set to true to enable this feature. The request will be retried up-to five times when enabled.
     * @return Amazon_CloudDrive_Trash_ListTrash_Inputs For method chaining.
     */
    public function setHandleRequestThrottling($value)
    {
        return $this->set('HandleRequestThrottling', $value);
    }

    /**
     * Set the value for the Limit input for this ListTrash Choreo.
     *
     * @param string $value (optional, string) The maximum number of records to be returned.
     * @return Amazon_CloudDrive_Trash_ListTrash_Inputs For method chaining.
     */
    public function setLimit($value)
    {
        return $this->set('Limit', $value);
    }

    /**
     * Set the value for the MetaDataURL input for this ListTrash Choreo.
     *
     * @param string $value (optional, string) The appropriate metadataUrl for you account. When not provided, the Choreo will lookup the URL using the Account.GetEndpoint Choreo.
     * @return Amazon_CloudDrive_Trash_ListTrash_Inputs For method chaining.
     */
    public function setMetaDataURL($value)
    {
        return $this->set('MetaDataURL', $value);
    }

    /**
     * Set the value for the RefreshToken input for this ListTrash Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Amazon_CloudDrive_Trash_ListTrash_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }

    /**
     * Set the value for the Sort input for this ListTrash Choreo.
     *
     * @param string $value (optional, json) A JSON array containing sort properties (e.g., ["name ASC","contentProperties.size" DESC]).
     * @return Amazon_CloudDrive_Trash_ListTrash_Inputs For method chaining.
     */
    public function setSort($value)
    {
        return $this->set('Sort', $value);
    }

    /**
     * Set the value for the StartToken input for this ListTrash Choreo.
     *
     * @param string $value (optional, string) The nextToken returned from a previous request. Used to paginate through results.
     * @return Amazon_CloudDrive_Trash_ListTrash_Inputs For method chaining.
     */
    public function setStartToken($value)
    {
        return $this->set('StartToken', $value);
    }
}


/**
 * Execution object for the ListTrash Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Trash_ListTrash_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the ListTrash Choreo.
     *
     * @param Temboo_Session $session The session that owns this ListTrash execution.
     * @param Amazon_CloudDrive_Trash_ListTrash $choreo The choreography object for this execution.
     * @param Amazon_CloudDrive_Trash_ListTrash_Inputs|array $inputs (optional) Inputs as Amazon_CloudDrive_Trash_ListTrash_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_CloudDrive_Trash_ListTrash_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_CloudDrive_Trash_ListTrash $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this ListTrash execution.
     *
     * @return Amazon_CloudDrive_Trash_ListTrash_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this ListTrash execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_CloudDrive_Trash_ListTrash_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_CloudDrive_Trash_ListTrash_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the ListTrash Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Trash_ListTrash_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the ListTrash Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_CloudDrive_Trash_ListTrash_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this ListTrash execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this ListTrash execution.
     *
     * @return string (json) The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Calls the Amazon Cloud Drive API to restore a folder or file that has been moved to the trash.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Trash_Restore extends Temboo_Choreography
{
    /**
     * Calls the Amazon Cloud Drive API to restore a folder or file that has been moved to the trash.
     *
     * @param Temboo_Session $session The session that owns this Restore Choreo.
     * @return Amazon_CloudDrive_Trash_Restore New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/CloudDrive/Trash/Restore/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this Restore Choreo.
     *
     * @param Amazon_CloudDrive_Trash_Restore_Inputs|array $inputs (optional) Inputs as Amazon_CloudDrive_Trash_Restore_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_CloudDrive_Trash_Restore_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_CloudDrive_Trash_Restore_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this Restore Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_CloudDrive_Trash_Restore_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_CloudDrive_Trash_Restore_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the Restore Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Trash_Restore_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the Restore Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_CloudDrive_Trash_Restore_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this Restore input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_CloudDrive_Trash_Restore_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_CloudDrive_Trash_Restore_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this Restore Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Amazon_CloudDrive_Trash_Restore_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this Restore Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Amazon. Required unless providing a valid AccessToken.
     * @return Amazon_CloudDrive_Trash_Restore_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this Restore Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Amazon. Required unless providing a valid AccessToken.
     * @return Amazon_CloudDrive_Trash_Restore_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the HandleRequestThrottling input for this Restore Choreo.
     *
     * @param bool $value (optional, boolean) Whether or not to perform a retry sequence if a throttling error occurs. Set to true to enable this feature. The request will be retried up-to five times when enabled.
     * @return Amazon_CloudDrive_Trash_Restore_Inputs For method chaining.
     */
    public function setHandleRequestThrottling($value)
    {
        return $this->set('HandleRequestThrottling', $value);
    }

    /**
     * Set the value for the ID input for this Restore Choreo.
     *
     * @param string $value (required, string) The ID of the file or folder to restore.
     * @return Amazon_CloudDrive_Trash_Restore_Inputs For method chaining.
     */
    public function setID($value)
    {
        return $this->set('ID', $value);
    }

    /**
     * Set the value for the MetaDataURL input for this Restore Choreo.
     *
     * @param string $value (optional, string) The appropriate metadataUrl for your account. When not provided, the Choreo will lookup the URL using the Account.GetEndpoint Choreo.
     * @return Amazon_CloudDrive_Trash_Restore_Inputs For method chaining.
     */
    public function setMetaDataURL($value)
    {
        return $this->set('MetaDataURL', $value);
    }

    /**
     * Set the value for the RefreshToken input for this Restore Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Amazon_CloudDrive_Trash_Restore_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }
}


/**
 * Execution object for the Restore Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Trash_Restore_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the Restore Choreo.
     *
     * @param Temboo_Session $session The session that owns this Restore execution.
     * @param Amazon_CloudDrive_Trash_Restore $choreo The choreography object for this execution.
     * @param Amazon_CloudDrive_Trash_Restore_Inputs|array $inputs (optional) Inputs as Amazon_CloudDrive_Trash_Restore_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_CloudDrive_Trash_Restore_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_CloudDrive_Trash_Restore $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this Restore execution.
     *
     * @return Amazon_CloudDrive_Trash_Restore_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this Restore execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_CloudDrive_Trash_Restore_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_CloudDrive_Trash_Restore_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the Restore Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_CloudDrive_Trash_Restore_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the Restore Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_CloudDrive_Trash_Restore_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this Restore execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this Restore execution.
     *
     * @return string (json) The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Returns the attributes of one or more items from one or more tables
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_DynamoDB_BatchGetItem extends Temboo_Choreography
{
    /**
     * Returns the attributes of one or more items from one or more tables
     *
     * @param Temboo_Session $session The session that owns this BatchGetItem Choreo.
     * @return Amazon_DynamoDB_BatchGetItem New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/DynamoDB/BatchGetItem/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this BatchGetItem Choreo.
     *
     * @param Amazon_DynamoDB_BatchGetItem_Inputs|array $inputs (optional) Inputs as Amazon_DynamoDB_BatchGetItem_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_DynamoDB_BatchGetItem_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_DynamoDB_BatchGetItem_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this BatchGetItem Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_DynamoDB_BatchGetItem_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_DynamoDB_BatchGetItem_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the BatchGetItem Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_DynamoDB_BatchGetItem_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the BatchGetItem Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_DynamoDB_BatchGetItem_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this BatchGetItem input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_DynamoDB_BatchGetItem_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_DynamoDB_BatchGetItem_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AWSAccessKeyId input for this BatchGetItem Choreo.
     *
     * @param string $value (required, string) The Access Key ID provided by Amazon Web Services.
     * @return Amazon_DynamoDB_BatchGetItem_Inputs For method chaining.
     */
    public function setAWSAccessKeyId($value)
    {
        return $this->set('AWSAccessKeyId', $value);
    }

    /**
     * Set the value for the AWSSecretKeyId input for this BatchGetItem Choreo.
     *
     * @param string $value (required, string) The Secret Key ID provided by Amazon Web Services.
     * @return Amazon_DynamoDB_BatchGetItem_Inputs For method chaining.
     */
    public function setAWSSecretKeyId($value)
    {
        return $this->set('AWSSecretKeyId', $value);
    }

    /**
     * Set the value for the RequestItems input for this BatchGetItem Choreo.
     *
     * @param string $value (required, json) A map of one or more table names and, for each table, a map that describes one or more items to retrieve from that table. See choreo notes for more details.
     * @return Amazon_DynamoDB_BatchGetItem_Inputs For method chaining.
     */
    public function setRequestItems($value)
    {
        return $this->set('RequestItems', $value);
    }

    /**
     * Set the value for the ReturnConsumedCapacity input for this BatchGetItem Choreo.
     *
     * @param string $value (optional, string) Determines the level of detail about provisioned throughput consumption that is returned in the response. Valid values are: INDEXES, TOTAL, NONE.
     * @return Amazon_DynamoDB_BatchGetItem_Inputs For method chaining.
     */
    public function setReturnConsumedCapacity($value)
    {
        return $this->set('ReturnConsumedCapacity', $value);
    }

    /**
     * Set the value for the UserRegion input for this BatchGetItem Choreo.
     *
     * @param string $value (optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".
     * @return Amazon_DynamoDB_BatchGetItem_Inputs For method chaining.
     */
    public function setUserRegion($value)
    {
        return $this->set('UserRegion', $value);
    }
}


/**
 * Execution object for the BatchGetItem Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_DynamoDB_BatchGetItem_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the BatchGetItem Choreo.
     *
     * @param Temboo_Session $session The session that owns this BatchGetItem execution.
     * @param Amazon_DynamoDB_BatchGetItem $choreo The choreography object for this execution.
     * @param Amazon_DynamoDB_BatchGetItem_Inputs|array $inputs (optional) Inputs as Amazon_DynamoDB_BatchGetItem_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_DynamoDB_BatchGetItem_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_DynamoDB_BatchGetItem $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this BatchGetItem execution.
     *
     * @return Amazon_DynamoDB_BatchGetItem_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this BatchGetItem execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_DynamoDB_BatchGetItem_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_DynamoDB_BatchGetItem_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the BatchGetItem Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_DynamoDB_BatchGetItem_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the BatchGetItem Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_DynamoDB_BatchGetItem_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this BatchGetItem execution.
     *
     * @return string (json) The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Puts or deletes multiple items in one or more tables.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_DynamoDB_BatchWriteItem extends Temboo_Choreography
{
    /**
     * Puts or deletes multiple items in one or more tables.
     *
     * @param Temboo_Session $session The session that owns this BatchWriteItem Choreo.
     * @return Amazon_DynamoDB_BatchWriteItem New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/DynamoDB/BatchWriteItem/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this BatchWriteItem Choreo.
     *
     * @param Amazon_DynamoDB_BatchWriteItem_Inputs|array $inputs (optional) Inputs as Amazon_DynamoDB_BatchWriteItem_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_DynamoDB_BatchWriteItem_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_DynamoDB_BatchWriteItem_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this BatchWriteItem Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_DynamoDB_BatchWriteItem_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_DynamoDB_BatchWriteItem_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the BatchWriteItem Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_DynamoDB_BatchWriteItem_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the BatchWriteItem Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_DynamoDB_BatchWriteItem_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this BatchWriteItem input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_DynamoDB_BatchWriteItem_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_DynamoDB_BatchWriteItem_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AWSAccessKeyId input for this BatchWriteItem Choreo.
     *
     * @param string $value (required, string) The Access Key ID provided by Amazon Web Services.
     * @return Amazon_DynamoDB_BatchWriteItem_Inputs For method chaining.
     */
    public function setAWSAccessKeyId($value)
    {
        return $this->set('AWSAccessKeyId', $value);
    }

    /**
     * Set the value for the AWSSecretKeyId input for this BatchWriteItem Choreo.
     *
     * @param string $value (required, string) The Secret Key ID provided by Amazon Web Services.
     * @return Amazon_DynamoDB_BatchWriteItem_Inputs For method chaining.
     */
    public function setAWSSecretKeyId($value)
    {
        return $this->set('AWSSecretKeyId', $value);
    }

    /**
     * Set the value for the RequestItems input for this BatchWriteItem Choreo.
     *
     * @param string $value (required, json) A map of one or more table names and, for each table, a list of operations to be performed (DeleteRequest or PutRequest). See choreo notes for more details.
     * @return Amazon_DynamoDB_BatchWriteItem_Inputs For method chaining.
     */
    public function setRequestItems($value)
    {
        return $this->set('RequestItems', $value);
    }

    /**
     * Set the value for the ReturnConsumedCapacity input for this BatchWriteItem Choreo.
     *
     * @param string $value (optional, string) Determines the level of detail about provisioned throughput consumption that is returned in the response. Valid values are: INDEXES, TOTAL, NONE.
     * @return Amazon_DynamoDB_BatchWriteItem_Inputs For method chaining.
     */
    public function setReturnConsumedCapacity($value)
    {
        return $this->set('ReturnConsumedCapacity', $value);
    }

    /**
     * Set the value for the ReturnItemCollectionMetrics input for this BatchWriteItem Choreo.
     *
     * @param string $value (optional, string) Determines whether item collection metrics are returned. Valid values are: SIZE and NONE.
     * @return Amazon_DynamoDB_BatchWriteItem_Inputs For method chaining.
     */
    public function setReturnItemCollectionMetrics($value)
    {
        return $this->set('ReturnItemCollectionMetrics', $value);
    }

    /**
     * Set the value for the UserRegion input for this BatchWriteItem Choreo.
     *
     * @param string $value (optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".
     * @return Amazon_DynamoDB_BatchWriteItem_Inputs For method chaining.
     */
    public function setUserRegion($value)
    {
        return $this->set('UserRegion', $value);
    }
}


/**
 * Execution object for the BatchWriteItem Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_DynamoDB_BatchWriteItem_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the BatchWriteItem Choreo.
     *
     * @param Temboo_Session $session The session that owns this BatchWriteItem execution.
     * @param Amazon_DynamoDB_BatchWriteItem $choreo The choreography object for this execution.
     * @param Amazon_DynamoDB_BatchWriteItem_Inputs|array $inputs (optional) Inputs as Amazon_DynamoDB_BatchWriteItem_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_DynamoDB_BatchWriteItem_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_DynamoDB_BatchWriteItem $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this BatchWriteItem execution.
     *
     * @return Amazon_DynamoDB_BatchWriteItem_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this BatchWriteItem execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_DynamoDB_BatchWriteItem_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_DynamoDB_BatchWriteItem_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the BatchWriteItem Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_DynamoDB_BatchWriteItem_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the BatchWriteItem Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_DynamoDB_BatchWriteItem_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this BatchWriteItem execution.
     *
     * @return string (json) The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Adds a new table to your account.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_DynamoDB_CreateTable extends Temboo_Choreography
{
    /**
     * Adds a new table to your account.
     *
     * @param Temboo_Session $session The session that owns this CreateTable Choreo.
     * @return Amazon_DynamoDB_CreateTable New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/DynamoDB/CreateTable/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this CreateTable Choreo.
     *
     * @param Amazon_DynamoDB_CreateTable_Inputs|array $inputs (optional) Inputs as Amazon_DynamoDB_CreateTable_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_DynamoDB_CreateTable_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_DynamoDB_CreateTable_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this CreateTable Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_DynamoDB_CreateTable_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_DynamoDB_CreateTable_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the CreateTable Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_DynamoDB_CreateTable_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the CreateTable Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_DynamoDB_CreateTable_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this CreateTable input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_DynamoDB_CreateTable_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_DynamoDB_CreateTable_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AWSAccessKeyId input for this CreateTable Choreo.
     *
     * @param string $value (required, string) The Access Key ID provided by Amazon Web Services.
     * @return Amazon_DynamoDB_CreateTable_Inputs For method chaining.
     */
    public function setAWSAccessKeyId($value)
    {
        return $this->set('AWSAccessKeyId', $value);
    }

    /**
     * Set the value for the AWSSecretKeyId input for this CreateTable Choreo.
     *
     * @param string $value (required, string) The Secret Key ID provided by Amazon Web Services.
     * @return Amazon_DynamoDB_CreateTable_Inputs For method chaining.
     */
    public function setAWSSecretKeyId($value)
    {
        return $this->set('AWSSecretKeyId', $value);
    }

    /**
     * Set the value for the AttributeDefinitions input for this CreateTable Choreo.
     *
     * @param string $value (required, json) An array of attributes that describe the key schema for the table and indexes.
     * @return Amazon_DynamoDB_CreateTable_Inputs For method chaining.
     */
    public function setAttributeDefinitions($value)
    {
        return $this->set('AttributeDefinitions', $value);
    }

    /**
     * Set the value for the GlobalSecondaryIndexes input for this CreateTable Choreo.
     *
     * @param string $value (optional, json) One or more global secondary indexes (the maximum is five) to be created on the table.
     * @return Amazon_DynamoDB_CreateTable_Inputs For method chaining.
     */
    public function setGlobalSecondaryIndexes($value)
    {
        return $this->set('GlobalSecondaryIndexes', $value);
    }

    /**
     * Set the value for the KeySchema input for this CreateTable Choreo.
     *
     * @param string $value (required, json) Specifies the attributes that make up the primary key for a table or an index. This is a JSON array of objects containing properties for AttributeName and KeyType. 
     * @return Amazon_DynamoDB_CreateTable_Inputs For method chaining.
     */
    public function setKeySchema($value)
    {
        return $this->set('KeySchema', $value);
    }

    /**
     * Set the value for the LocalSecondaryIndexes input for this CreateTable Choreo.
     *
     * @param string $value (optional, json) One or more local secondary indexes (the maximum is five) to be created on the table.
     * @return Amazon_DynamoDB_CreateTable_Inputs For method chaining.
     */
    public function setLocalSecondaryIndexes($value)
    {
        return $this->set('LocalSecondaryIndexes', $value);
    }

    /**
     * Set the value for the ProvisionedThroughput input for this CreateTable Choreo.
     *
     * @param string $value (required, json) Represents the provisioned throughput settings for a specified table or index.
     * @return Amazon_DynamoDB_CreateTable_Inputs For method chaining.
     */
    public function setProvisionedThroughput($value)
    {
        return $this->set('ProvisionedThroughput', $value);
    }

    /**
     * Set the value for the StreamSpecification input for this CreateTable Choreo.
     *
     * @param string $value (optional, json) The settings for DynamoDB Streams on the table.
     * @return Amazon_DynamoDB_CreateTable_Inputs For method chaining.
     */
    public function setStreamSpecification($value)
    {
        return $this->set('StreamSpecification', $value);
    }

    /**
     * Set the value for the TableName input for this CreateTable Choreo.
     *
     * @param string $value (required, string) The name of the table to create.
     * @return Amazon_DynamoDB_CreateTable_Inputs For method chaining.
     */
    public function setTableName($value)
    {
        return $this->set('TableName', $value);
    }

    /**
     * Set the value for the UserRegion input for this CreateTable Choreo.
     *
     * @param string $value (optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".
     * @return Amazon_DynamoDB_CreateTable_Inputs For method chaining.
     */
    public function setUserRegion($value)
    {
        return $this->set('UserRegion', $value);
    }
}


/**
 * Execution object for the CreateTable Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_DynamoDB_CreateTable_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the CreateTable Choreo.
     *
     * @param Temboo_Session $session The session that owns this CreateTable execution.
     * @param Amazon_DynamoDB_CreateTable $choreo The choreography object for this execution.
     * @param Amazon_DynamoDB_CreateTable_Inputs|array $inputs (optional) Inputs as Amazon_DynamoDB_CreateTable_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_DynamoDB_CreateTable_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_DynamoDB_CreateTable $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this CreateTable execution.
     *
     * @return Amazon_DynamoDB_CreateTable_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this CreateTable execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_DynamoDB_CreateTable_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_DynamoDB_CreateTable_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the CreateTable Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_DynamoDB_CreateTable_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the CreateTable Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_DynamoDB_CreateTable_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this CreateTable execution.
     *
     * @return string (json) The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Deletes a single item in a table by primary key.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_DynamoDB_DeleteItem extends Temboo_Choreography
{
    /**
     * Deletes a single item in a table by primary key.
     *
     * @param Temboo_Session $session The session that owns this DeleteItem Choreo.
     * @return Amazon_DynamoDB_DeleteItem New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/DynamoDB/DeleteItem/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this DeleteItem Choreo.
     *
     * @param Amazon_DynamoDB_DeleteItem_Inputs|array $inputs (optional) Inputs as Amazon_DynamoDB_DeleteItem_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_DynamoDB_DeleteItem_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_DynamoDB_DeleteItem_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this DeleteItem Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_DynamoDB_DeleteItem_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_DynamoDB_DeleteItem_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the DeleteItem Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_DynamoDB_DeleteItem_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the DeleteItem Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_DynamoDB_DeleteItem_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this DeleteItem input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_DynamoDB_DeleteItem_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_DynamoDB_DeleteItem_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AWSAccessKeyId input for this DeleteItem Choreo.
     *
     * @param string $value (required, string) The Access Key ID provided by Amazon Web Services.
     * @return Amazon_DynamoDB_DeleteItem_Inputs For method chaining.
     */
    public function setAWSAccessKeyId($value)
    {
        return $this->set('AWSAccessKeyId', $value);
    }

    /**
     * Set the value for the AWSSecretKeyId input for this DeleteItem Choreo.
     *
     * @param string $value (required, string) The Secret Key ID provided by Amazon Web Services.
     * @return Amazon_DynamoDB_DeleteItem_Inputs For method chaining.
     */
    public function setAWSSecretKeyId($value)
    {
        return $this->set('AWSSecretKeyId', $value);
    }

    /**
     * Set the value for the ConditionExpression input for this DeleteItem Choreo.
     *
     * @param string $value (optional, string) A condition that must be satisfied in order for a conditional DeleteItem to succeed.
     * @return Amazon_DynamoDB_DeleteItem_Inputs For method chaining.
     */
    public function setConditionExpression($value)
    {
        return $this->set('ConditionExpression', $value);
    }

    /**
     * Set the value for the ExpressionAttributeNames input for this DeleteItem Choreo.
     *
     * @param string $value (optional, json) One or more substitution tokens for attribute names in an expression.
     * @return Amazon_DynamoDB_DeleteItem_Inputs For method chaining.
     */
    public function setExpressionAttributeNames($value)
    {
        return $this->set('ExpressionAttributeNames', $value);
    }

    /**
     * Set the value for the ExpressionAttributeValues input for this DeleteItem Choreo.
     *
     * @param string $value (optional, json) One or more values that can be substituted in an expression.
     * @return Amazon_DynamoDB_DeleteItem_Inputs For method chaining.
     */
    public function setExpressionAttributeValues($value)
    {
        return $this->set('ExpressionAttributeValues', $value);
    }

    /**
     * Set the value for the Key input for this DeleteItem Choreo.
     *
     * @param string $value (required, json) A map of attribute names to AttributeValue objects, representing the primary key of the item to delete.
     * @return Amazon_DynamoDB_DeleteItem_Inputs For method chaining.
     */
    public function setKey($value)
    {
        return $this->set('Key', $value);
    }

    /**
     * Set the value for the ReturnConsumedCapacity input for this DeleteItem Choreo.
     *
     * @param string $value (optional, string) Determines the level of detail about provisioned throughput consumption that is returned in the response. Valid values are: INDEXES, TOTAL, NONE.
     * @return Amazon_DynamoDB_DeleteItem_Inputs For method chaining.
     */
    public function setReturnConsumedCapacity($value)
    {
        return $this->set('ReturnConsumedCapacity', $value);
    }

    /**
     * Set the value for the ReturnItemCollectionMetrics input for this DeleteItem Choreo.
     *
     * @param string $value (optional, string) Determines whether item collection metrics are returned. Valid values are: SIZE and NONE.
     * @return Amazon_DynamoDB_DeleteItem_Inputs For method chaining.
     */
    public function setReturnItemCollectionMetrics($value)
    {
        return $this->set('ReturnItemCollectionMetrics', $value);
    }

    /**
     * Set the value for the ReturnValues input for this DeleteItem Choreo.
     *
     * @param string $value (optional, string) Use ReturnValues if you want to get the item attributes as they appeared before they were deleted. Valid values are NONE and ALL_OLD.
     * @return Amazon_DynamoDB_DeleteItem_Inputs For method chaining.
     */
    public function setReturnValues($value)
    {
        return $this->set('ReturnValues', $value);
    }

    /**
     * Set the value for the TableName input for this DeleteItem Choreo.
     *
     * @param string $value (required, string) The name of the table from which to delete the item.
     * @return Amazon_DynamoDB_DeleteItem_Inputs For method chaining.
     */
    public function setTableName($value)
    {
        return $this->set('TableName', $value);
    }

    /**
     * Set the value for the UserRegion input for this DeleteItem Choreo.
     *
     * @param string $value (optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".
     * @return Amazon_DynamoDB_DeleteItem_Inputs For method chaining.
     */
    public function setUserRegion($value)
    {
        return $this->set('UserRegion', $value);
    }
}


/**
 * Execution object for the DeleteItem Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_DynamoDB_DeleteItem_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the DeleteItem Choreo.
     *
     * @param Temboo_Session $session The session that owns this DeleteItem execution.
     * @param Amazon_DynamoDB_DeleteItem $choreo The choreography object for this execution.
     * @param Amazon_DynamoDB_DeleteItem_Inputs|array $inputs (optional) Inputs as Amazon_DynamoDB_DeleteItem_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_DynamoDB_DeleteItem_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_DynamoDB_DeleteItem $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this DeleteItem execution.
     *
     * @return Amazon_DynamoDB_DeleteItem_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this DeleteItem execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_DynamoDB_DeleteItem_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_DynamoDB_DeleteItem_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the DeleteItem Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_DynamoDB_DeleteItem_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the DeleteItem Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_DynamoDB_DeleteItem_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this DeleteItem execution.
     *
     * @return string (json) The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Deletes a table and all of its items.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_DynamoDB_DeleteTable extends Temboo_Choreography
{
    /**
     * Deletes a table and all of its items.
     *
     * @param Temboo_Session $session The session that owns this DeleteTable Choreo.
     * @return Amazon_DynamoDB_DeleteTable New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/DynamoDB/DeleteTable/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this DeleteTable Choreo.
     *
     * @param Amazon_DynamoDB_DeleteTable_Inputs|array $inputs (optional) Inputs as Amazon_DynamoDB_DeleteTable_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_DynamoDB_DeleteTable_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_DynamoDB_DeleteTable_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this DeleteTable Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_DynamoDB_DeleteTable_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_DynamoDB_DeleteTable_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the DeleteTable Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_DynamoDB_DeleteTable_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the DeleteTable Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_DynamoDB_DeleteTable_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this DeleteTable input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_DynamoDB_DeleteTable_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_DynamoDB_DeleteTable_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AWSAccessKeyId input for this DeleteTable Choreo.
     *
     * @param string $value (required, string) The Access Key ID provided by Amazon Web Services.
     * @return Amazon_DynamoDB_DeleteTable_Inputs For method chaining.
     */
    public function setAWSAccessKeyId($value)
    {
        return $this->set('AWSAccessKeyId', $value);
    }

    /**
     * Set the value for the AWSSecretKeyId input for this DeleteTable Choreo.
     *
     * @param string $value (required, string) The Secret Key ID provided by Amazon Web Services.
     * @return Amazon_DynamoDB_DeleteTable_Inputs For method chaining.
     */
    public function setAWSSecretKeyId($value)
    {
        return $this->set('AWSSecretKeyId', $value);
    }

    /**
     * Set the value for the TableName input for this DeleteTable Choreo.
     *
     * @param string $value (required, string) The name of the table to delete.
     * @return Amazon_DynamoDB_DeleteTable_Inputs For method chaining.
     */
    public function setTableName($value)
    {
        return $this->set('TableName', $value);
    }

    /**
     * Set the value for the UserRegion input for this DeleteTable Choreo.
     *
     * @param string $value (optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".
     * @return Amazon_DynamoDB_DeleteTable_Inputs For method chaining.
     */
    public function setUserRegion($value)
    {
        return $this->set('UserRegion', $value);
    }
}


/**
 * Execution object for the DeleteTable Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_DynamoDB_DeleteTable_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the DeleteTable Choreo.
     *
     * @param Temboo_Session $session The session that owns this DeleteTable execution.
     * @param Amazon_DynamoDB_DeleteTable $choreo The choreography object for this execution.
     * @param Amazon_DynamoDB_DeleteTable_Inputs|array $inputs (optional) Inputs as Amazon_DynamoDB_DeleteTable_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_DynamoDB_DeleteTable_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_DynamoDB_DeleteTable $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this DeleteTable execution.
     *
     * @return Amazon_DynamoDB_DeleteTable_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this DeleteTable execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_DynamoDB_DeleteTable_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_DynamoDB_DeleteTable_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the DeleteTable Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_DynamoDB_DeleteTable_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the DeleteTable Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_DynamoDB_DeleteTable_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this DeleteTable execution.
     *
     * @return string (json) The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Returns the current provisioned-capacity limits for your AWS account in a region, both for the region as a whole and for any one DynamoDB table that you create there.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_DynamoDB_DescribeLimits extends Temboo_Choreography
{
    /**
     * Returns the current provisioned-capacity limits for your AWS account in a region, both for the region as a whole and for any one DynamoDB table that you create there.
     *
     * @param Temboo_Session $session The session that owns this DescribeLimits Choreo.
     * @return Amazon_DynamoDB_DescribeLimits New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/DynamoDB/DescribeLimits/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this DescribeLimits Choreo.
     *
     * @param Amazon_DynamoDB_DescribeLimits_Inputs|array $inputs (optional) Inputs as Amazon_DynamoDB_DescribeLimits_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_DynamoDB_DescribeLimits_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_DynamoDB_DescribeLimits_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this DescribeLimits Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_DynamoDB_DescribeLimits_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_DynamoDB_DescribeLimits_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the DescribeLimits Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_DynamoDB_DescribeLimits_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the DescribeLimits Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_DynamoDB_DescribeLimits_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this DescribeLimits input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_DynamoDB_DescribeLimits_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_DynamoDB_DescribeLimits_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AWSAccessKeyId input for this DescribeLimits Choreo.
     *
     * @param string $value (required, string) The Access Key ID provided by Amazon Web Services.
     * @return Amazon_DynamoDB_DescribeLimits_Inputs For method chaining.
     */
    public function setAWSAccessKeyId($value)
    {
        return $this->set('AWSAccessKeyId', $value);
    }

    /**
     * Set the value for the AWSSecretKeyId input for this DescribeLimits Choreo.
     *
     * @param string $value (required, string) The Secret Key ID provided by Amazon Web Services.
     * @return Amazon_DynamoDB_DescribeLimits_Inputs For method chaining.
     */
    public function setAWSSecretKeyId($value)
    {
        return $this->set('AWSSecretKeyId', $value);
    }

    /**
     * Set the value for the UserRegion input for this DescribeLimits Choreo.
     *
     * @param string $value (optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".
     * @return Amazon_DynamoDB_DescribeLimits_Inputs For method chaining.
     */
    public function setUserRegion($value)
    {
        return $this->set('UserRegion', $value);
    }
}


/**
 * Execution object for the DescribeLimits Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_DynamoDB_DescribeLimits_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the DescribeLimits Choreo.
     *
     * @param Temboo_Session $session The session that owns this DescribeLimits execution.
     * @param Amazon_DynamoDB_DescribeLimits $choreo The choreography object for this execution.
     * @param Amazon_DynamoDB_DescribeLimits_Inputs|array $inputs (optional) Inputs as Amazon_DynamoDB_DescribeLimits_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_DynamoDB_DescribeLimits_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_DynamoDB_DescribeLimits $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this DescribeLimits execution.
     *
     * @return Amazon_DynamoDB_DescribeLimits_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this DescribeLimits execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_DynamoDB_DescribeLimits_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_DynamoDB_DescribeLimits_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the DescribeLimits Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_DynamoDB_DescribeLimits_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the DescribeLimits Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_DynamoDB_DescribeLimits_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this DescribeLimits execution.
     *
     * @return string (json) The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Returns information about the table.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_DynamoDB_DescribeTable extends Temboo_Choreography
{
    /**
     * Returns information about the table.
     *
     * @param Temboo_Session $session The session that owns this DescribeTable Choreo.
     * @return Amazon_DynamoDB_DescribeTable New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/DynamoDB/DescribeTable/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this DescribeTable Choreo.
     *
     * @param Amazon_DynamoDB_DescribeTable_Inputs|array $inputs (optional) Inputs as Amazon_DynamoDB_DescribeTable_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_DynamoDB_DescribeTable_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_DynamoDB_DescribeTable_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this DescribeTable Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_DynamoDB_DescribeTable_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_DynamoDB_DescribeTable_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the DescribeTable Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_DynamoDB_DescribeTable_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the DescribeTable Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_DynamoDB_DescribeTable_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this DescribeTable input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_DynamoDB_DescribeTable_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_DynamoDB_DescribeTable_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AWSAccessKeyId input for this DescribeTable Choreo.
     *
     * @param string $value (required, string) The Access Key ID provided by Amazon Web Services.
     * @return Amazon_DynamoDB_DescribeTable_Inputs For method chaining.
     */
    public function setAWSAccessKeyId($value)
    {
        return $this->set('AWSAccessKeyId', $value);
    }

    /**
     * Set the value for the AWSSecretKeyId input for this DescribeTable Choreo.
     *
     * @param string $value (required, string) The Secret Key ID provided by Amazon Web Services.
     * @return Amazon_DynamoDB_DescribeTable_Inputs For method chaining.
     */
    public function setAWSSecretKeyId($value)
    {
        return $this->set('AWSSecretKeyId', $value);
    }

    /**
     * Set the value for the TableName input for this DescribeTable Choreo.
     *
     * @param string $value (required, string) The name of the table to describe.
     * @return Amazon_DynamoDB_DescribeTable_Inputs For method chaining.
     */
    public function setTableName($value)
    {
        return $this->set('TableName', $value);
    }

    /**
     * Set the value for the UserRegion input for this DescribeTable Choreo.
     *
     * @param string $value (optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".
     * @return Amazon_DynamoDB_DescribeTable_Inputs For method chaining.
     */
    public function setUserRegion($value)
    {
        return $this->set('UserRegion', $value);
    }
}


/**
 * Execution object for the DescribeTable Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_DynamoDB_DescribeTable_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the DescribeTable Choreo.
     *
     * @param Temboo_Session $session The session that owns this DescribeTable execution.
     * @param Amazon_DynamoDB_DescribeTable $choreo The choreography object for this execution.
     * @param Amazon_DynamoDB_DescribeTable_Inputs|array $inputs (optional) Inputs as Amazon_DynamoDB_DescribeTable_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_DynamoDB_DescribeTable_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_DynamoDB_DescribeTable $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this DescribeTable execution.
     *
     * @return Amazon_DynamoDB_DescribeTable_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this DescribeTable execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_DynamoDB_DescribeTable_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_DynamoDB_DescribeTable_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the DescribeTable Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_DynamoDB_DescribeTable_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the DescribeTable Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_DynamoDB_DescribeTable_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this DescribeTable execution.
     *
     * @return string (json) The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Returns a set of attributes for the item with the given primary key.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_DynamoDB_GetItem extends Temboo_Choreography
{
    /**
     * Returns a set of attributes for the item with the given primary key.
     *
     * @param Temboo_Session $session The session that owns this GetItem Choreo.
     * @return Amazon_DynamoDB_GetItem New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/DynamoDB/GetItem/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this GetItem Choreo.
     *
     * @param Amazon_DynamoDB_GetItem_Inputs|array $inputs (optional) Inputs as Amazon_DynamoDB_GetItem_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_DynamoDB_GetItem_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_DynamoDB_GetItem_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this GetItem Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_DynamoDB_GetItem_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_DynamoDB_GetItem_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the GetItem Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_DynamoDB_GetItem_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the GetItem Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_DynamoDB_GetItem_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this GetItem input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_DynamoDB_GetItem_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_DynamoDB_GetItem_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AWSAccessKeyId input for this GetItem Choreo.
     *
     * @param string $value (required, string) The Access Key ID provided by Amazon Web Services.
     * @return Amazon_DynamoDB_GetItem_Inputs For method chaining.
     */
    public function setAWSAccessKeyId($value)
    {
        return $this->set('AWSAccessKeyId', $value);
    }

    /**
     * Set the value for the AWSSecretKeyId input for this GetItem Choreo.
     *
     * @param string $value (required, string) The Secret Key ID provided by Amazon Web Services.
     * @return Amazon_DynamoDB_GetItem_Inputs For method chaining.
     */
    public function setAWSSecretKeyId($value)
    {
        return $this->set('AWSSecretKeyId', $value);
    }

    /**
     * Set the value for the ConsistentRead input for this GetItem Choreo.
     *
     * @param bool $value (optional, boolean) Determines the read consistency model: If set to true, then the operation uses strongly consistent reads; otherwise, the operation uses eventually consistent reads.
     * @return Amazon_DynamoDB_GetItem_Inputs For method chaining.
     */
    public function setConsistentRead($value)
    {
        return $this->set('ConsistentRead', $value);
    }

    /**
     * Set the value for the ExpressionAttributeNames input for this GetItem Choreo.
     *
     * @param string $value (optional, json) One or more substitution tokens for attribute names in an expression.
     * @return Amazon_DynamoDB_GetItem_Inputs For method chaining.
     */
    public function setExpressionAttributeNames($value)
    {
        return $this->set('ExpressionAttributeNames', $value);
    }

    /**
     * Set the value for the Key input for this GetItem Choreo.
     *
     * @param string $value (required, json) A map of attribute names to AttributeValue objects, representing the primary key of the item to retrieve.
     * @return Amazon_DynamoDB_GetItem_Inputs For method chaining.
     */
    public function setKey($value)
    {
        return $this->set('Key', $value);
    }

    /**
     * Set the value for the ProjectionExpression input for this GetItem Choreo.
     *
     * @param string $value (optional, string) A string that identifies one or more attributes to retrieve from the table.
     * @return Amazon_DynamoDB_GetItem_Inputs For method chaining.
     */
    public function setProjectionExpression($value)
    {
        return $this->set('ProjectionExpression', $value);
    }

    /**
     * Set the value for the ReturnConsumedCapacity input for this GetItem Choreo.
     *
     * @param string $value (optional, string) Determines the level of detail about provisioned throughput consumption that is returned in the response. Valid values are: INDEXES, TOTAL, NONE.
     * @return Amazon_DynamoDB_GetItem_Inputs For method chaining.
     */
    public function setReturnConsumedCapacity($value)
    {
        return $this->set('ReturnConsumedCapacity', $value);
    }

    /**
     * Set the value for the TableName input for this GetItem Choreo.
     *
     * @param string $value (required, string) The name of the table containing the requested items.
     * @return Amazon_DynamoDB_GetItem_Inputs For method chaining.
     */
    public function setTableName($value)
    {
        return $this->set('TableName', $value);
    }

    /**
     * Set the value for the UserRegion input for this GetItem Choreo.
     *
     * @param string $value (optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".
     * @return Amazon_DynamoDB_GetItem_Inputs For method chaining.
     */
    public function setUserRegion($value)
    {
        return $this->set('UserRegion', $value);
    }
}


/**
 * Execution object for the GetItem Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_DynamoDB_GetItem_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the GetItem Choreo.
     *
     * @param Temboo_Session $session The session that owns this GetItem execution.
     * @param Amazon_DynamoDB_GetItem $choreo The choreography object for this execution.
     * @param Amazon_DynamoDB_GetItem_Inputs|array $inputs (optional) Inputs as Amazon_DynamoDB_GetItem_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_DynamoDB_GetItem_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_DynamoDB_GetItem $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this GetItem execution.
     *
     * @return Amazon_DynamoDB_GetItem_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this GetItem execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_DynamoDB_GetItem_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_DynamoDB_GetItem_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the GetItem Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_DynamoDB_GetItem_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the GetItem Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_DynamoDB_GetItem_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this GetItem execution.
     *
     * @return string (json) The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Returns an array of table names associated with the current account and endpoint.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_DynamoDB_ListTables extends Temboo_Choreography
{
    /**
     * Returns an array of table names associated with the current account and endpoint.
     *
     * @param Temboo_Session $session The session that owns this ListTables Choreo.
     * @return Amazon_DynamoDB_ListTables New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/DynamoDB/ListTables/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this ListTables Choreo.
     *
     * @param Amazon_DynamoDB_ListTables_Inputs|array $inputs (optional) Inputs as Amazon_DynamoDB_ListTables_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_DynamoDB_ListTables_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_DynamoDB_ListTables_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this ListTables Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_DynamoDB_ListTables_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_DynamoDB_ListTables_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the ListTables Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_DynamoDB_ListTables_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the ListTables Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_DynamoDB_ListTables_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this ListTables input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_DynamoDB_ListTables_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_DynamoDB_ListTables_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AWSAccessKeyId input for this ListTables Choreo.
     *
     * @param string $value (required, string) The Access Key ID provided by Amazon Web Services.
     * @return Amazon_DynamoDB_ListTables_Inputs For method chaining.
     */
    public function setAWSAccessKeyId($value)
    {
        return $this->set('AWSAccessKeyId', $value);
    }

    /**
     * Set the value for the AWSSecretKeyId input for this ListTables Choreo.
     *
     * @param string $value (required, string) The Secret Key ID provided by Amazon Web Services.
     * @return Amazon_DynamoDB_ListTables_Inputs For method chaining.
     */
    public function setAWSSecretKeyId($value)
    {
        return $this->set('AWSSecretKeyId', $value);
    }

    /**
     * Set the value for the ExclusiveStartTableName input for this ListTables Choreo.
     *
     * @param string $value (optional, string) The first table name that this operation will evaluate. Use the value that was returned for LastEvaluatedTableName in a previous request to retrieve the next page of results.
     * @return Amazon_DynamoDB_ListTables_Inputs For method chaining.
     */
    public function setExclusiveStartTableName($value)
    {
        return $this->set('ExclusiveStartTableName', $value);
    }

    /**
     * Set the value for the Limit input for this ListTables Choreo.
     *
     * @param int $value (optional, integer) A maximum number of table names to return. Defaults to 100.
     * @return Amazon_DynamoDB_ListTables_Inputs For method chaining.
     */
    public function setLimit($value)
    {
        return $this->set('Limit', $value);
    }

    /**
     * Set the value for the UserRegion input for this ListTables Choreo.
     *
     * @param string $value (optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".
     * @return Amazon_DynamoDB_ListTables_Inputs For method chaining.
     */
    public function setUserRegion($value)
    {
        return $this->set('UserRegion', $value);
    }
}


/**
 * Execution object for the ListTables Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_DynamoDB_ListTables_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the ListTables Choreo.
     *
     * @param Temboo_Session $session The session that owns this ListTables execution.
     * @param Amazon_DynamoDB_ListTables $choreo The choreography object for this execution.
     * @param Amazon_DynamoDB_ListTables_Inputs|array $inputs (optional) Inputs as Amazon_DynamoDB_ListTables_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_DynamoDB_ListTables_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_DynamoDB_ListTables $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this ListTables execution.
     *
     * @return Amazon_DynamoDB_ListTables_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this ListTables execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_DynamoDB_ListTables_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_DynamoDB_ListTables_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the ListTables Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_DynamoDB_ListTables_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the ListTables Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_DynamoDB_ListTables_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this ListTables execution.
     *
     * @return string (json) The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Creates a new item, or replaces an old item with a new item.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_DynamoDB_PutItem extends Temboo_Choreography
{
    /**
     * Creates a new item, or replaces an old item with a new item.
     *
     * @param Temboo_Session $session The session that owns this PutItem Choreo.
     * @return Amazon_DynamoDB_PutItem New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/DynamoDB/PutItem/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this PutItem Choreo.
     *
     * @param Amazon_DynamoDB_PutItem_Inputs|array $inputs (optional) Inputs as Amazon_DynamoDB_PutItem_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_DynamoDB_PutItem_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_DynamoDB_PutItem_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this PutItem Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_DynamoDB_PutItem_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_DynamoDB_PutItem_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the PutItem Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_DynamoDB_PutItem_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the PutItem Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_DynamoDB_PutItem_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this PutItem input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_DynamoDB_PutItem_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_DynamoDB_PutItem_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AWSAccessKeyId input for this PutItem Choreo.
     *
     * @param string $value (required, string) The Access Key ID provided by Amazon Web Services.
     * @return Amazon_DynamoDB_PutItem_Inputs For method chaining.
     */
    public function setAWSAccessKeyId($value)
    {
        return $this->set('AWSAccessKeyId', $value);
    }

    /**
     * Set the value for the AWSSecretKeyId input for this PutItem Choreo.
     *
     * @param string $value (required, string) The Secret Key ID provided by Amazon Web Services.
     * @return Amazon_DynamoDB_PutItem_Inputs For method chaining.
     */
    public function setAWSSecretKeyId($value)
    {
        return $this->set('AWSSecretKeyId', $value);
    }

    /**
     * Set the value for the ConditionExpression input for this PutItem Choreo.
     *
     * @param string $value (optional, string) A condition that must be satisfied in order for a conditional PutItem operation to succeed.
     * @return Amazon_DynamoDB_PutItem_Inputs For method chaining.
     */
    public function setConditionExpression($value)
    {
        return $this->set('ConditionExpression', $value);
    }

    /**
     * Set the value for the ExpressionAttributeNames input for this PutItem Choreo.
     *
     * @param string $value (optional, json) One or more substitution tokens for attribute names in an expression.
     * @return Amazon_DynamoDB_PutItem_Inputs For method chaining.
     */
    public function setExpressionAttributeNames($value)
    {
        return $this->set('ExpressionAttributeNames', $value);
    }

    /**
     * Set the value for the ExpressionAttributeValues input for this PutItem Choreo.
     *
     * @param string $value (optional, json) One or more values that can be substituted in an expression.
     * @return Amazon_DynamoDB_PutItem_Inputs For method chaining.
     */
    public function setExpressionAttributeValues($value)
    {
        return $this->set('ExpressionAttributeValues', $value);
    }

    /**
     * Set the value for the Item input for this PutItem Choreo.
     *
     * @param string $value (required, json) A map of attribute name/value pairs, one for each attribute. Only the primary key attributes are required.
     * @return Amazon_DynamoDB_PutItem_Inputs For method chaining.
     */
    public function setItem($value)
    {
        return $this->set('Item', $value);
    }

    /**
     * Set the value for the ReturnConsumedCapacity input for this PutItem Choreo.
     *
     * @param string $value (optional, string) Determines the level of detail about provisioned throughput consumption that is returned in the response. Valid values are: INDEXES, TOTAL, NONE.
     * @return Amazon_DynamoDB_PutItem_Inputs For method chaining.
     */
    public function setReturnConsumedCapacity($value)
    {
        return $this->set('ReturnConsumedCapacity', $value);
    }

    /**
     * Set the value for the ReturnItemCollectionMetrics input for this PutItem Choreo.
     *
     * @param string $value (optional, string) Determines whether item collection metrics are returned. Valid values are: SIZE and NONE.
     * @return Amazon_DynamoDB_PutItem_Inputs For method chaining.
     */
    public function setReturnItemCollectionMetrics($value)
    {
        return $this->set('ReturnItemCollectionMetrics', $value);
    }

    /**
     * Set the value for the ReturnValues input for this PutItem Choreo.
     *
     * @param string $value (optional, string) Use ReturnValues if you want to get the item attributes as they appeared before they were updated with the PutItem request. Valid values are NONE and ALL_OLD.
     * @return Amazon_DynamoDB_PutItem_Inputs For method chaining.
     */
    public function setReturnValues($value)
    {
        return $this->set('ReturnValues', $value);
    }

    /**
     * Set the value for the TableName input for this PutItem Choreo.
     *
     * @param string $value (required, string) The name of the table to contain the item.
     * @return Amazon_DynamoDB_PutItem_Inputs For method chaining.
     */
    public function setTableName($value)
    {
        return $this->set('TableName', $value);
    }

    /**
     * Set the value for the UserRegion input for this PutItem Choreo.
     *
     * @param string $value (optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".
     * @return Amazon_DynamoDB_PutItem_Inputs For method chaining.
     */
    public function setUserRegion($value)
    {
        return $this->set('UserRegion', $value);
    }
}


/**
 * Execution object for the PutItem Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_DynamoDB_PutItem_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the PutItem Choreo.
     *
     * @param Temboo_Session $session The session that owns this PutItem execution.
     * @param Amazon_DynamoDB_PutItem $choreo The choreography object for this execution.
     * @param Amazon_DynamoDB_PutItem_Inputs|array $inputs (optional) Inputs as Amazon_DynamoDB_PutItem_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_DynamoDB_PutItem_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_DynamoDB_PutItem $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this PutItem execution.
     *
     * @return Amazon_DynamoDB_PutItem_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this PutItem execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_DynamoDB_PutItem_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_DynamoDB_PutItem_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the PutItem Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_DynamoDB_PutItem_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the PutItem Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_DynamoDB_PutItem_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this PutItem execution.
     *
     * @return string (json) The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Queries a table using the primary key or a secondary index.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_DynamoDB_Query extends Temboo_Choreography
{
    /**
     * Queries a table using the primary key or a secondary index.
     *
     * @param Temboo_Session $session The session that owns this Query Choreo.
     * @return Amazon_DynamoDB_Query New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/DynamoDB/Query/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this Query Choreo.
     *
     * @param Amazon_DynamoDB_Query_Inputs|array $inputs (optional) Inputs as Amazon_DynamoDB_Query_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_DynamoDB_Query_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_DynamoDB_Query_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this Query Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_DynamoDB_Query_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_DynamoDB_Query_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the Query Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_DynamoDB_Query_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the Query Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_DynamoDB_Query_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this Query input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_DynamoDB_Query_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_DynamoDB_Query_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AWSAccessKeyId input for this Query Choreo.
     *
     * @param string $value (required, string) The Access Key ID provided by Amazon Web Services.
     * @return Amazon_DynamoDB_Query_Inputs For method chaining.
     */
    public function setAWSAccessKeyId($value)
    {
        return $this->set('AWSAccessKeyId', $value);
    }

    /**
     * Set the value for the AWSSecretKeyId input for this Query Choreo.
     *
     * @param string $value (required, string) The Secret Key ID provided by Amazon Web Services.
     * @return Amazon_DynamoDB_Query_Inputs For method chaining.
     */
    public function setAWSSecretKeyId($value)
    {
        return $this->set('AWSSecretKeyId', $value);
    }

    /**
     * Set the value for the ConsistentRead input for this Query Choreo.
     *
     * @param bool $value (optional, boolean) Determines the read consistency model: If set to true, then the operation uses strongly consistent reads; otherwise, the operation uses eventually consistent reads.
     * @return Amazon_DynamoDB_Query_Inputs For method chaining.
     */
    public function setConsistentRead($value)
    {
        return $this->set('ConsistentRead', $value);
    }

    /**
     * Set the value for the ExclusiveStartKey input for this Query Choreo.
     *
     * @param string $value (optional, json) The primary key of the first item that this operation will evaluate. Use the value that was returned for LastEvaluatedKey in the previous operation.
     * @return Amazon_DynamoDB_Query_Inputs For method chaining.
     */
    public function setExclusiveStartKey($value)
    {
        return $this->set('ExclusiveStartKey', $value);
    }

    /**
     * Set the value for the ExpressionAttributeNames input for this Query Choreo.
     *
     * @param string $value (optional, json) One or more substitution tokens for attribute names in an expression.
     * @return Amazon_DynamoDB_Query_Inputs For method chaining.
     */
    public function setExpressionAttributeNames($value)
    {
        return $this->set('ExpressionAttributeNames', $value);
    }

    /**
     * Set the value for the ExpressionAttributeValues input for this Query Choreo.
     *
     * @param string $value (conditional, json) One or more values that can be substituted in an expression.
     * @return Amazon_DynamoDB_Query_Inputs For method chaining.
     */
    public function setExpressionAttributeValues($value)
    {
        return $this->set('ExpressionAttributeValues', $value);
    }

    /**
     * Set the value for the FilterExpression input for this Query Choreo.
     *
     * @param string $value (optional, string) A string that contains conditions that DynamoDB applies after the Query operation, but before the data is returned to you.
     * @return Amazon_DynamoDB_Query_Inputs For method chaining.
     */
    public function setFilterExpression($value)
    {
        return $this->set('FilterExpression', $value);
    }

    /**
     * Set the value for the IndexName input for this Query Choreo.
     *
     * @param string $value (optional, string) The name of an index to query. This index can be any local secondary index or global secondary index on the table.
     * @return Amazon_DynamoDB_Query_Inputs For method chaining.
     */
    public function setIndexName($value)
    {
        return $this->set('IndexName', $value);
    }

    /**
     * Set the value for the KeyConditionExpression input for this Query Choreo.
     *
     * @param string $value (conditional, string) The condition that specifies the key value(s) for items to be retrieved by the Query action.
     * @return Amazon_DynamoDB_Query_Inputs For method chaining.
     */
    public function setKeyConditionExpression($value)
    {
        return $this->set('KeyConditionExpression', $value);
    }

    /**
     * Set the value for the Limit input for this Query Choreo.
     *
     * @param int $value (optional, integer) The maximum number of items to evaluate (not necessarily the number of matching items).
     * @return Amazon_DynamoDB_Query_Inputs For method chaining.
     */
    public function setLimit($value)
    {
        return $this->set('Limit', $value);
    }

    /**
     * Set the value for the ProjectionExpression input for this Query Choreo.
     *
     * @param string $value (optional, string) A string that identifies one or more attributes to retrieve from the table.
     * @return Amazon_DynamoDB_Query_Inputs For method chaining.
     */
    public function setProjectionExpression($value)
    {
        return $this->set('ProjectionExpression', $value);
    }

    /**
     * Set the value for the ReturnConsumedCapacity input for this Query Choreo.
     *
     * @param string $value (optional, string) Determines the level of detail about provisioned throughput consumption that is returned in the response. Valid values are: INDEXES, TOTAL, NONE.
     * @return Amazon_DynamoDB_Query_Inputs For method chaining.
     */
    public function setReturnConsumedCapacity($value)
    {
        return $this->set('ReturnConsumedCapacity', $value);
    }

    /**
     * Set the value for the ScanIndexForward input for this Query Choreo.
     *
     * @param bool $value (optional, boolean) Specifies the order for index traversal: If true (default), the traversal is performed in ascending order; if false, the traversal is performed in descending order.
     * @return Amazon_DynamoDB_Query_Inputs For method chaining.
     */
    public function setScanIndexForward($value)
    {
        return $this->set('ScanIndexForward', $value);
    }

    /**
     * Set the value for the Select input for this Query Choreo.
     *
     * @param string $value (optional, string) The attributes to be returned in the result. Valid values are: ALL_ATTRIBUTES, ALL_PROJECTED_ATTRIBUTES, SPECIFIC_ATTRIBUTES, and COUNT.
     * @return Amazon_DynamoDB_Query_Inputs For method chaining.
     */
    public function setSelect($value)
    {
        return $this->set('Select', $value);
    }

    /**
     * Set the value for the TableName input for this Query Choreo.
     *
     * @param string $value (required, string) The name of the table containing the requested items.
     * @return Amazon_DynamoDB_Query_Inputs For method chaining.
     */
    public function setTableName($value)
    {
        return $this->set('TableName', $value);
    }

    /**
     * Set the value for the UserRegion input for this Query Choreo.
     *
     * @param string $value (optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".
     * @return Amazon_DynamoDB_Query_Inputs For method chaining.
     */
    public function setUserRegion($value)
    {
        return $this->set('UserRegion', $value);
    }
}


/**
 * Execution object for the Query Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_DynamoDB_Query_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the Query Choreo.
     *
     * @param Temboo_Session $session The session that owns this Query execution.
     * @param Amazon_DynamoDB_Query $choreo The choreography object for this execution.
     * @param Amazon_DynamoDB_Query_Inputs|array $inputs (optional) Inputs as Amazon_DynamoDB_Query_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_DynamoDB_Query_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_DynamoDB_Query $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this Query execution.
     *
     * @return Amazon_DynamoDB_Query_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this Query execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_DynamoDB_Query_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_DynamoDB_Query_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the Query Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_DynamoDB_Query_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the Query Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_DynamoDB_Query_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this Query execution.
     *
     * @return string (json) The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Returns one or more items and item attributes by accessing every item in a table or a secondary index.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_DynamoDB_Scan extends Temboo_Choreography
{
    /**
     * Returns one or more items and item attributes by accessing every item in a table or a secondary index.
     *
     * @param Temboo_Session $session The session that owns this Scan Choreo.
     * @return Amazon_DynamoDB_Scan New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/DynamoDB/Scan/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this Scan Choreo.
     *
     * @param Amazon_DynamoDB_Scan_Inputs|array $inputs (optional) Inputs as Amazon_DynamoDB_Scan_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_DynamoDB_Scan_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_DynamoDB_Scan_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this Scan Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_DynamoDB_Scan_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_DynamoDB_Scan_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the Scan Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_DynamoDB_Scan_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the Scan Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_DynamoDB_Scan_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this Scan input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_DynamoDB_Scan_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_DynamoDB_Scan_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AWSAccessKeyId input for this Scan Choreo.
     *
     * @param string $value (required, string) The Access Key ID provided by Amazon Web Services.
     * @return Amazon_DynamoDB_Scan_Inputs For method chaining.
     */
    public function setAWSAccessKeyId($value)
    {
        return $this->set('AWSAccessKeyId', $value);
    }

    /**
     * Set the value for the AWSSecretKeyId input for this Scan Choreo.
     *
     * @param string $value (required, string) The Secret Key ID provided by Amazon Web Services.
     * @return Amazon_DynamoDB_Scan_Inputs For method chaining.
     */
    public function setAWSSecretKeyId($value)
    {
        return $this->set('AWSSecretKeyId', $value);
    }

    /**
     * Set the value for the ConsistentRead input for this Scan Choreo.
     *
     * @param bool $value (optional, boolean) A Boolean value that determines the read consistency model during the scan.
     * @return Amazon_DynamoDB_Scan_Inputs For method chaining.
     */
    public function setConsistentRead($value)
    {
        return $this->set('ConsistentRead', $value);
    }

    /**
     * Set the value for the ExclusiveStartKey input for this Scan Choreo.
     *
     * @param string $value (optional, json) The primary key of the first item that this operation will evaluate. Use the value that was returned for LastEvaluatedKey in the previous operation.
     * @return Amazon_DynamoDB_Scan_Inputs For method chaining.
     */
    public function setExclusiveStartKey($value)
    {
        return $this->set('ExclusiveStartKey', $value);
    }

    /**
     * Set the value for the ExpressionAttributeNames input for this Scan Choreo.
     *
     * @param string $value (optional, json) One or more substitution tokens for attribute names in an expression.
     * @return Amazon_DynamoDB_Scan_Inputs For method chaining.
     */
    public function setExpressionAttributeNames($value)
    {
        return $this->set('ExpressionAttributeNames', $value);
    }

    /**
     * Set the value for the ExpressionAttributeValues input for this Scan Choreo.
     *
     * @param string $value (optional, json) One or more values that can be substituted in an expression.
     * @return Amazon_DynamoDB_Scan_Inputs For method chaining.
     */
    public function setExpressionAttributeValues($value)
    {
        return $this->set('ExpressionAttributeValues', $value);
    }

    /**
     * Set the value for the FilterExpression input for this Scan Choreo.
     *
     * @param string $value (optional, string) A string that contains conditions that DynamoDB applies after the Scan operation, but before the data is returned to you.
     * @return Amazon_DynamoDB_Scan_Inputs For method chaining.
     */
    public function setFilterExpression($value)
    {
        return $this->set('FilterExpression', $value);
    }

    /**
     * Set the value for the IndexName input for this Scan Choreo.
     *
     * @param string $value (optional, string) The name of an index to scan. This index can be any local secondary index or global secondary index on the table.
     * @return Amazon_DynamoDB_Scan_Inputs For method chaining.
     */
    public function setIndexName($value)
    {
        return $this->set('IndexName', $value);
    }

    /**
     * Set the value for the Limit input for this Scan Choreo.
     *
     * @param int $value (optional, integer) The maximum number of items to evaluate (not necessarily the number of matching items).
     * @return Amazon_DynamoDB_Scan_Inputs For method chaining.
     */
    public function setLimit($value)
    {
        return $this->set('Limit', $value);
    }

    /**
     * Set the value for the ProjectionExpression input for this Scan Choreo.
     *
     * @param string $value (optional, string) A string that identifies one or more attributes to retrieve from the table.
     * @return Amazon_DynamoDB_Scan_Inputs For method chaining.
     */
    public function setProjectionExpression($value)
    {
        return $this->set('ProjectionExpression', $value);
    }

    /**
     * Set the value for the ReturnConsumedCapacity input for this Scan Choreo.
     *
     * @param string $value (optional, string) Determines the level of detail about provisioned throughput consumption that is returned in the response. Valid values are: INDEXES, TOTAL, NONE.
     * @return Amazon_DynamoDB_Scan_Inputs For method chaining.
     */
    public function setReturnConsumedCapacity($value)
    {
        return $this->set('ReturnConsumedCapacity', $value);
    }

    /**
     * Set the value for the Segment input for this Scan Choreo.
     *
     * @param int $value (optional, integer) For a parallel Scan request, Segment identifies an individual segment to be scanned by an application worker.
     * @return Amazon_DynamoDB_Scan_Inputs For method chaining.
     */
    public function setSegment($value)
    {
        return $this->set('Segment', $value);
    }

    /**
     * Set the value for the Select input for this Scan Choreo.
     *
     * @param string $value (optional, string) The attributes to be returned in the result. Valid values are: ALL_ATTRIBUTES, ALL_PROJECTED_ATTRIBUTES, SPECIFIC_ATTRIBUTES, and COUNT.
     * @return Amazon_DynamoDB_Scan_Inputs For method chaining.
     */
    public function setSelect($value)
    {
        return $this->set('Select', $value);
    }

    /**
     * Set the value for the TableName input for this Scan Choreo.
     *
     * @param string $value (required, string) The name of the table containing the requested items.
     * @return Amazon_DynamoDB_Scan_Inputs For method chaining.
     */
    public function setTableName($value)
    {
        return $this->set('TableName', $value);
    }

    /**
     * Set the value for the TotalSegments input for this Scan Choreo.
     *
     * @param int $value (optional, integer) Specifies the order for index traversal: If true (default), the traversal is performed in ascending order; if false, the traversal is performed in descending order.
     * @return Amazon_DynamoDB_Scan_Inputs For method chaining.
     */
    public function setTotalSegments($value)
    {
        return $this->set('TotalSegments', $value);
    }

    /**
     * Set the value for the UserRegion input for this Scan Choreo.
     *
     * @param string $value (optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".
     * @return Amazon_DynamoDB_Scan_Inputs For method chaining.
     */
    public function setUserRegion($value)
    {
        return $this->set('UserRegion', $value);
    }
}


/**
 * Execution object for the Scan Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_DynamoDB_Scan_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the Scan Choreo.
     *
     * @param Temboo_Session $session The session that owns this Scan execution.
     * @param Amazon_DynamoDB_Scan $choreo The choreography object for this execution.
     * @param Amazon_DynamoDB_Scan_Inputs|array $inputs (optional) Inputs as Amazon_DynamoDB_Scan_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_DynamoDB_Scan_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_DynamoDB_Scan $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this Scan execution.
     *
     * @return Amazon_DynamoDB_Scan_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this Scan execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_DynamoDB_Scan_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_DynamoDB_Scan_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the Scan Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_DynamoDB_Scan_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the Scan Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_DynamoDB_Scan_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this Scan execution.
     *
     * @return string (json) The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Edits an existing item's attributes, or adds a new item to the table if it does not already exist.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_DynamoDB_UpdateItem extends Temboo_Choreography
{
    /**
     * Edits an existing item's attributes, or adds a new item to the table if it does not already exist.
     *
     * @param Temboo_Session $session The session that owns this UpdateItem Choreo.
     * @return Amazon_DynamoDB_UpdateItem New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/DynamoDB/UpdateItem/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this UpdateItem Choreo.
     *
     * @param Amazon_DynamoDB_UpdateItem_Inputs|array $inputs (optional) Inputs as Amazon_DynamoDB_UpdateItem_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_DynamoDB_UpdateItem_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_DynamoDB_UpdateItem_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this UpdateItem Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_DynamoDB_UpdateItem_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_DynamoDB_UpdateItem_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the UpdateItem Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_DynamoDB_UpdateItem_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the UpdateItem Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_DynamoDB_UpdateItem_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this UpdateItem input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_DynamoDB_UpdateItem_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_DynamoDB_UpdateItem_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AWSAccessKeyId input for this UpdateItem Choreo.
     *
     * @param string $value (required, string) The Access Key ID provided by Amazon Web Services.
     * @return Amazon_DynamoDB_UpdateItem_Inputs For method chaining.
     */
    public function setAWSAccessKeyId($value)
    {
        return $this->set('AWSAccessKeyId', $value);
    }

    /**
     * Set the value for the AWSSecretKeyId input for this UpdateItem Choreo.
     *
     * @param string $value (required, string) The Secret Key ID provided by Amazon Web Services.
     * @return Amazon_DynamoDB_UpdateItem_Inputs For method chaining.
     */
    public function setAWSSecretKeyId($value)
    {
        return $this->set('AWSSecretKeyId', $value);
    }

    /**
     * Set the value for the ConditionExpression input for this UpdateItem Choreo.
     *
     * @param string $value (optional, string) A condition that must be satisfied in order for a conditional update to succeed.
     * @return Amazon_DynamoDB_UpdateItem_Inputs For method chaining.
     */
    public function setConditionExpression($value)
    {
        return $this->set('ConditionExpression', $value);
    }

    /**
     * Set the value for the ExpressionAttributeNames input for this UpdateItem Choreo.
     *
     * @param string $value (optional, json) One or more substitution tokens for attribute names in an expression.
     * @return Amazon_DynamoDB_UpdateItem_Inputs For method chaining.
     */
    public function setExpressionAttributeNames($value)
    {
        return $this->set('ExpressionAttributeNames', $value);
    }

    /**
     * Set the value for the ExpressionAttributeValues input for this UpdateItem Choreo.
     *
     * @param string $value (optional, json) One or more values that can be substituted in an expression.
     * @return Amazon_DynamoDB_UpdateItem_Inputs For method chaining.
     */
    public function setExpressionAttributeValues($value)
    {
        return $this->set('ExpressionAttributeValues', $value);
    }

    /**
     * Set the value for the Key input for this UpdateItem Choreo.
     *
     * @param string $value (required, json) The primary key of the item to be updated. Each element consists of an attribute name and a value for that attribute.
     * @return Amazon_DynamoDB_UpdateItem_Inputs For method chaining.
     */
    public function setKey($value)
    {
        return $this->set('Key', $value);
    }

    /**
     * Set the value for the ReturnConsumedCapacity input for this UpdateItem Choreo.
     *
     * @param string $value (optional, string) Determines the level of detail about provisioned throughput consumption that is returned in the response. Valid values are: INDEXES, TOTAL, NONE.
     * @return Amazon_DynamoDB_UpdateItem_Inputs For method chaining.
     */
    public function setReturnConsumedCapacity($value)
    {
        return $this->set('ReturnConsumedCapacity', $value);
    }

    /**
     * Set the value for the ReturnItemCollectionMetrics input for this UpdateItem Choreo.
     *
     * @param string $value (optional, string) Determines whether item collection metrics are returned. Valid values are: SIZE and NONE.
     * @return Amazon_DynamoDB_UpdateItem_Inputs For method chaining.
     */
    public function setReturnItemCollectionMetrics($value)
    {
        return $this->set('ReturnItemCollectionMetrics', $value);
    }

    /**
     * Set the value for the ReturnValues input for this UpdateItem Choreo.
     *
     * @param string $value (optional, string) Use ReturnValues if you want to get the item attributes as they appeared either before or after they were updated. Valid values are NONE and ALL_OLD.
     * @return Amazon_DynamoDB_UpdateItem_Inputs For method chaining.
     */
    public function setReturnValues($value)
    {
        return $this->set('ReturnValues', $value);
    }

    /**
     * Set the value for the TableName input for this UpdateItem Choreo.
     *
     * @param string $value (required, string) The name of the table to contain the item.
     * @return Amazon_DynamoDB_UpdateItem_Inputs For method chaining.
     */
    public function setTableName($value)
    {
        return $this->set('TableName', $value);
    }

    /**
     * Set the value for the UpdateExpression input for this UpdateItem Choreo.
     *
     * @param string $value (optional, string) An expression that defines one or more attributes to be updated, the action to be performed on them, and new value(s) for them.
     * @return Amazon_DynamoDB_UpdateItem_Inputs For method chaining.
     */
    public function setUpdateExpression($value)
    {
        return $this->set('UpdateExpression', $value);
    }

    /**
     * Set the value for the UserRegion input for this UpdateItem Choreo.
     *
     * @param string $value (optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".
     * @return Amazon_DynamoDB_UpdateItem_Inputs For method chaining.
     */
    public function setUserRegion($value)
    {
        return $this->set('UserRegion', $value);
    }
}


/**
 * Execution object for the UpdateItem Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_DynamoDB_UpdateItem_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the UpdateItem Choreo.
     *
     * @param Temboo_Session $session The session that owns this UpdateItem execution.
     * @param Amazon_DynamoDB_UpdateItem $choreo The choreography object for this execution.
     * @param Amazon_DynamoDB_UpdateItem_Inputs|array $inputs (optional) Inputs as Amazon_DynamoDB_UpdateItem_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_DynamoDB_UpdateItem_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_DynamoDB_UpdateItem $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this UpdateItem execution.
     *
     * @return Amazon_DynamoDB_UpdateItem_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this UpdateItem execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_DynamoDB_UpdateItem_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_DynamoDB_UpdateItem_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the UpdateItem Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_DynamoDB_UpdateItem_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the UpdateItem Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_DynamoDB_UpdateItem_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this UpdateItem execution.
     *
     * @return string (json) The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Modifies the provisioned throughput settings, global secondary indexes, or DynamoDB Streams settings for a given table.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_DynamoDB_UpdateTable extends Temboo_Choreography
{
    /**
     * Modifies the provisioned throughput settings, global secondary indexes, or DynamoDB Streams settings for a given table.
     *
     * @param Temboo_Session $session The session that owns this UpdateTable Choreo.
     * @return Amazon_DynamoDB_UpdateTable New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/DynamoDB/UpdateTable/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this UpdateTable Choreo.
     *
     * @param Amazon_DynamoDB_UpdateTable_Inputs|array $inputs (optional) Inputs as Amazon_DynamoDB_UpdateTable_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_DynamoDB_UpdateTable_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_DynamoDB_UpdateTable_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this UpdateTable Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_DynamoDB_UpdateTable_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_DynamoDB_UpdateTable_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the UpdateTable Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_DynamoDB_UpdateTable_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the UpdateTable Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_DynamoDB_UpdateTable_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this UpdateTable input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_DynamoDB_UpdateTable_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_DynamoDB_UpdateTable_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AWSAccessKeyId input for this UpdateTable Choreo.
     *
     * @param string $value (required, string) The Access Key ID provided by Amazon Web Services.
     * @return Amazon_DynamoDB_UpdateTable_Inputs For method chaining.
     */
    public function setAWSAccessKeyId($value)
    {
        return $this->set('AWSAccessKeyId', $value);
    }

    /**
     * Set the value for the AWSSecretKeyId input for this UpdateTable Choreo.
     *
     * @param string $value (required, string) The Secret Key ID provided by Amazon Web Services.
     * @return Amazon_DynamoDB_UpdateTable_Inputs For method chaining.
     */
    public function setAWSSecretKeyId($value)
    {
        return $this->set('AWSSecretKeyId', $value);
    }

    /**
     * Set the value for the AttributeDefinitions input for this UpdateTable Choreo.
     *
     * @param string $value (optional, json) An array of attributes that describe the key schema for the table and indexes.
     * @return Amazon_DynamoDB_UpdateTable_Inputs For method chaining.
     */
    public function setAttributeDefinitions($value)
    {
        return $this->set('AttributeDefinitions', $value);
    }

    /**
     * Set the value for the GlobalSecondaryIndexUpdates input for this UpdateTable Choreo.
     *
     * @param string $value (conditional, json) One or more global secondary indexes (the maximum is five) to be created on the table.
     * @return Amazon_DynamoDB_UpdateTable_Inputs For method chaining.
     */
    public function setGlobalSecondaryIndexUpdates($value)
    {
        return $this->set('GlobalSecondaryIndexUpdates', $value);
    }

    /**
     * Set the value for the ProvisionedThroughput input for this UpdateTable Choreo.
     *
     * @param string $value (conditional, json) Represents the provisioned throughput settings for a specified table or index.
     * @return Amazon_DynamoDB_UpdateTable_Inputs For method chaining.
     */
    public function setProvisionedThroughput($value)
    {
        return $this->set('ProvisionedThroughput', $value);
    }

    /**
     * Set the value for the StreamSpecification input for this UpdateTable Choreo.
     *
     * @param string $value (conditional, json) The settings for DynamoDB Streams on the table.
     * @return Amazon_DynamoDB_UpdateTable_Inputs For method chaining.
     */
    public function setStreamSpecification($value)
    {
        return $this->set('StreamSpecification', $value);
    }

    /**
     * Set the value for the TableName input for this UpdateTable Choreo.
     *
     * @param string $value (required, string) The name of the table to create.
     * @return Amazon_DynamoDB_UpdateTable_Inputs For method chaining.
     */
    public function setTableName($value)
    {
        return $this->set('TableName', $value);
    }

    /**
     * Set the value for the UserRegion input for this UpdateTable Choreo.
     *
     * @param string $value (optional, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".
     * @return Amazon_DynamoDB_UpdateTable_Inputs For method chaining.
     */
    public function setUserRegion($value)
    {
        return $this->set('UserRegion', $value);
    }
}


/**
 * Execution object for the UpdateTable Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_DynamoDB_UpdateTable_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the UpdateTable Choreo.
     *
     * @param Temboo_Session $session The session that owns this UpdateTable execution.
     * @param Amazon_DynamoDB_UpdateTable $choreo The choreography object for this execution.
     * @param Amazon_DynamoDB_UpdateTable_Inputs|array $inputs (optional) Inputs as Amazon_DynamoDB_UpdateTable_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_DynamoDB_UpdateTable_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_DynamoDB_UpdateTable $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this UpdateTable execution.
     *
     * @return Amazon_DynamoDB_UpdateTable_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this UpdateTable execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_DynamoDB_UpdateTable_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_DynamoDB_UpdateTable_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the UpdateTable Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_DynamoDB_UpdateTable_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the UpdateTable Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_DynamoDB_UpdateTable_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this UpdateTable execution.
     *
     * @return string (json) The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Calls the Amazon EC2 API to acquire an Elastic IP address for use with your AWS account.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_AllocateAddress extends Temboo_Choreography
{
    /**
     * Calls the Amazon EC2 API to acquire an Elastic IP address for use with your AWS account.
     *
     * @param Temboo_Session $session The session that owns this AllocateAddress Choreo.
     * @return Amazon_EC2_AllocateAddress New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/EC2/AllocateAddress/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this AllocateAddress Choreo.
     *
     * @param Amazon_EC2_AllocateAddress_Inputs|array $inputs (optional) Inputs as Amazon_EC2_AllocateAddress_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_AllocateAddress_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_EC2_AllocateAddress_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this AllocateAddress Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_AllocateAddress_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_EC2_AllocateAddress_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the AllocateAddress Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_AllocateAddress_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the AllocateAddress Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_AllocateAddress_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this AllocateAddress input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_EC2_AllocateAddress_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_EC2_AllocateAddress_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AWSAccessKeyId input for this AllocateAddress Choreo.
     *
     * @param string $value (required, string) The Access Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_AllocateAddress_Inputs For method chaining.
     */
    public function setAWSAccessKeyId($value)
    {
        return $this->set('AWSAccessKeyId', $value);
    }

    /**
     * Set the value for the AWSSecretKeyId input for this AllocateAddress Choreo.
     *
     * @param string $value (required, string) The Secret Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_AllocateAddress_Inputs For method chaining.
     */
    public function setAWSSecretKeyId($value)
    {
        return $this->set('AWSSecretKeyId', $value);
    }

    /**
     * Set the value for the Domain input for this AllocateAddress Choreo.
     *
     * @param string $value (conditional, string) Set to "vpc" to allocate the address for use with instances in a VPC.
     * @return Amazon_EC2_AllocateAddress_Inputs For method chaining.
     */
    public function setDomain($value)
    {
        return $this->set('Domain', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this AllocateAddress Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
     * @return Amazon_EC2_AllocateAddress_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }

    /**
     * Set the value for the UserRegion input for this AllocateAddress Choreo.
     *
     * @param string $value (optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
     * @return Amazon_EC2_AllocateAddress_Inputs For method chaining.
     */
    public function setUserRegion($value)
    {
        return $this->set('UserRegion', $value);
    }
}


/**
 * Execution object for the AllocateAddress Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_AllocateAddress_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the AllocateAddress Choreo.
     *
     * @param Temboo_Session $session The session that owns this AllocateAddress execution.
     * @param Amazon_EC2_AllocateAddress $choreo The choreography object for this execution.
     * @param Amazon_EC2_AllocateAddress_Inputs|array $inputs (optional) Inputs as Amazon_EC2_AllocateAddress_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_AllocateAddress_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_EC2_AllocateAddress $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this AllocateAddress execution.
     *
     * @return Amazon_EC2_AllocateAddress_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this AllocateAddress execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_EC2_AllocateAddress_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_EC2_AllocateAddress_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the AllocateAddress Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_AllocateAddress_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the AllocateAddress Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_EC2_AllocateAddress_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this AllocateAddress execution.
     *
     * @return string The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Associates an Elastic IP address with an instance or a network interface using the Amazon EC2 API.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_AssociateAddress extends Temboo_Choreography
{
    /**
     * Associates an Elastic IP address with an instance or a network interface using the Amazon EC2 API.
     *
     * @param Temboo_Session $session The session that owns this AssociateAddress Choreo.
     * @return Amazon_EC2_AssociateAddress New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/EC2/AssociateAddress/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this AssociateAddress Choreo.
     *
     * @param Amazon_EC2_AssociateAddress_Inputs|array $inputs (optional) Inputs as Amazon_EC2_AssociateAddress_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_AssociateAddress_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_EC2_AssociateAddress_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this AssociateAddress Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_AssociateAddress_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_EC2_AssociateAddress_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the AssociateAddress Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_AssociateAddress_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the AssociateAddress Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_AssociateAddress_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this AssociateAddress input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_EC2_AssociateAddress_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_EC2_AssociateAddress_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AWSAccessKeyId input for this AssociateAddress Choreo.
     *
     * @param string $value (required, string) The Access Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_AssociateAddress_Inputs For method chaining.
     */
    public function setAWSAccessKeyId($value)
    {
        return $this->set('AWSAccessKeyId', $value);
    }

    /**
     * Set the value for the AWSSecretKeyId input for this AssociateAddress Choreo.
     *
     * @param string $value (required, string) The Secret Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_AssociateAddress_Inputs For method chaining.
     */
    public function setAWSSecretKeyId($value)
    {
        return $this->set('AWSSecretKeyId', $value);
    }

    /**
     * Set the value for the AllocationId input for this AssociateAddress Choreo.
     *
     * @param string $value (optional, string) [EC2-VPC] The allocation ID.  Required for a VPC.
     * @return Amazon_EC2_AssociateAddress_Inputs For method chaining.
     */
    public function setAllocationId($value)
    {
        return $this->set('AllocationId', $value);
    }

    /**
     * Set the value for the AllowReassociation input for this AssociateAddress Choreo.
     *
     * @param string $value (optional, string) [EC2-VPC] Allows an Elastic IP address that is already associated with an instance or network interface to be re-associated with the specified instance or network interface. False if not specified.
     * @return Amazon_EC2_AssociateAddress_Inputs For method chaining.
     */
    public function setAllowReassociation($value)
    {
        return $this->set('AllowReassociation', $value);
    }

    /**
     * Set the value for the InstanceId input for this AssociateAddress Choreo.
     *
     * @param string $value (conditional, string) The ID of the instance.  Required for EC2-Classic. For a VPC, you can specify either an instance ID or a network interface ID, but not both.
     * @return Amazon_EC2_AssociateAddress_Inputs For method chaining.
     */
    public function setInstanceId($value)
    {
        return $this->set('InstanceId', $value);
    }

    /**
     * Set the value for the NetworkInterfaceId input for this AssociateAddress Choreo.
     *
     * @param string $value (optional, string) [EC2-VPC] The ID of the network interface. Association fails when specifying an instance ID unless exactly one interface is attached.
     * @return Amazon_EC2_AssociateAddress_Inputs For method chaining.
     */
    public function setNetworkInterfaceId($value)
    {
        return $this->set('NetworkInterfaceId', $value);
    }

    /**
     * Set the value for the PrivateIpAddress input for this AssociateAddress Choreo.
     *
     * @param string $value (optional, string) [EC2-VPC] The primary or secondary private IP address to associate with the Elastic IP address. If nothing is specified, the Elastic IP address is associated with the primary private IP address.
     * @return Amazon_EC2_AssociateAddress_Inputs For method chaining.
     */
    public function setPrivateIpAddress($value)
    {
        return $this->set('PrivateIpAddress', $value);
    }

    /**
     * Set the value for the PublicIp input for this AssociateAddress Choreo.
     *
     * @param string $value (conditional, string) The Elastic IP address.
     * @return Amazon_EC2_AssociateAddress_Inputs For method chaining.
     */
    public function setPublicIp($value)
    {
        return $this->set('PublicIp', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this AssociateAddress Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
     * @return Amazon_EC2_AssociateAddress_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }

    /**
     * Set the value for the UserRegion input for this AssociateAddress Choreo.
     *
     * @param string $value (optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
     * @return Amazon_EC2_AssociateAddress_Inputs For method chaining.
     */
    public function setUserRegion($value)
    {
        return $this->set('UserRegion', $value);
    }
}


/**
 * Execution object for the AssociateAddress Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_AssociateAddress_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the AssociateAddress Choreo.
     *
     * @param Temboo_Session $session The session that owns this AssociateAddress execution.
     * @param Amazon_EC2_AssociateAddress $choreo The choreography object for this execution.
     * @param Amazon_EC2_AssociateAddress_Inputs|array $inputs (optional) Inputs as Amazon_EC2_AssociateAddress_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_AssociateAddress_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_EC2_AssociateAddress $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this AssociateAddress execution.
     *
     * @return Amazon_EC2_AssociateAddress_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this AssociateAddress execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_EC2_AssociateAddress_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_EC2_AssociateAddress_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the AssociateAddress Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_AssociateAddress_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the AssociateAddress Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_EC2_AssociateAddress_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this AssociateAddress execution.
     *
     * @return string The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Attaches an Amazon EBS volume to a running instance and exposes it as the specified device using the Amazon EC2 API.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_AttachVolume extends Temboo_Choreography
{
    /**
     * Attaches an Amazon EBS volume to a running instance and exposes it as the specified device using the Amazon EC2 API.
     *
     * @param Temboo_Session $session The session that owns this AttachVolume Choreo.
     * @return Amazon_EC2_AttachVolume New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/EC2/AttachVolume/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this AttachVolume Choreo.
     *
     * @param Amazon_EC2_AttachVolume_Inputs|array $inputs (optional) Inputs as Amazon_EC2_AttachVolume_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_AttachVolume_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_EC2_AttachVolume_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this AttachVolume Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_AttachVolume_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_EC2_AttachVolume_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the AttachVolume Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_AttachVolume_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the AttachVolume Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_AttachVolume_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this AttachVolume input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_EC2_AttachVolume_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_EC2_AttachVolume_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AWSAccessKeyId input for this AttachVolume Choreo.
     *
     * @param string $value (required, string) The Access Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_AttachVolume_Inputs For method chaining.
     */
    public function setAWSAccessKeyId($value)
    {
        return $this->set('AWSAccessKeyId', $value);
    }

    /**
     * Set the value for the AWSSecretKeyId input for this AttachVolume Choreo.
     *
     * @param string $value (required, string) The Secret Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_AttachVolume_Inputs For method chaining.
     */
    public function setAWSSecretKeyId($value)
    {
        return $this->set('AWSSecretKeyId', $value);
    }

    /**
     * Set the value for the Device input for this AttachVolume Choreo.
     *
     * @param string $value (required, string) How the device is exposed to the instance (i.e. " /dev/sdh" or "xvdh").
     * @return Amazon_EC2_AttachVolume_Inputs For method chaining.
     */
    public function setDevice($value)
    {
        return $this->set('Device', $value);
    }

    /**
     * Set the value for the InstanceId input for this AttachVolume Choreo.
     *
     * @param string $value (required, string) The ID of the instance to which the volume attaches. The volume and instance must be within the same Availability Zone and the instance must be running.
     * @return Amazon_EC2_AttachVolume_Inputs For method chaining.
     */
    public function setInstanceId($value)
    {
        return $this->set('InstanceId', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this AttachVolume Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
     * @return Amazon_EC2_AttachVolume_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }

    /**
     * Set the value for the UserRegion input for this AttachVolume Choreo.
     *
     * @param string $value (optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
     * @return Amazon_EC2_AttachVolume_Inputs For method chaining.
     */
    public function setUserRegion($value)
    {
        return $this->set('UserRegion', $value);
    }

    /**
     * Set the value for the VolumeId input for this AttachVolume Choreo.
     *
     * @param string $value (required, string) The ID of the Amazon EBS volume. The volume and instance must be within the same Availability Zone and the instance must be running.
     * @return Amazon_EC2_AttachVolume_Inputs For method chaining.
     */
    public function setVolumeId($value)
    {
        return $this->set('VolumeId', $value);
    }
}


/**
 * Execution object for the AttachVolume Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_AttachVolume_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the AttachVolume Choreo.
     *
     * @param Temboo_Session $session The session that owns this AttachVolume execution.
     * @param Amazon_EC2_AttachVolume $choreo The choreography object for this execution.
     * @param Amazon_EC2_AttachVolume_Inputs|array $inputs (optional) Inputs as Amazon_EC2_AttachVolume_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_AttachVolume_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_EC2_AttachVolume $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this AttachVolume execution.
     *
     * @return Amazon_EC2_AttachVolume_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this AttachVolume execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_EC2_AttachVolume_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_EC2_AttachVolume_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the AttachVolume Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_AttachVolume_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the AttachVolume Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_EC2_AttachVolume_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this AttachVolume execution.
     *
     * @return string The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Adds an ingress rule to a security group using the Amazon EC2 API.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_AuthorizeSecurityGroupIngress extends Temboo_Choreography
{
    /**
     * Adds an ingress rule to a security group using the Amazon EC2 API.
     *
     * @param Temboo_Session $session The session that owns this AuthorizeSecurityGroupIngress Choreo.
     * @return Amazon_EC2_AuthorizeSecurityGroupIngress New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/EC2/AuthorizeSecurityGroupIngress/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this AuthorizeSecurityGroupIngress Choreo.
     *
     * @param Amazon_EC2_AuthorizeSecurityGroupIngress_Inputs|array $inputs (optional) Inputs as Amazon_EC2_AuthorizeSecurityGroupIngress_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_AuthorizeSecurityGroupIngress_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_EC2_AuthorizeSecurityGroupIngress_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this AuthorizeSecurityGroupIngress Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_AuthorizeSecurityGroupIngress_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_EC2_AuthorizeSecurityGroupIngress_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the AuthorizeSecurityGroupIngress Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_AuthorizeSecurityGroupIngress_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the AuthorizeSecurityGroupIngress Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_AuthorizeSecurityGroupIngress_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this AuthorizeSecurityGroupIngress input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_EC2_AuthorizeSecurityGroupIngress_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_EC2_AuthorizeSecurityGroupIngress_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AWSAccessKeyId input for this AuthorizeSecurityGroupIngress Choreo.
     *
     * @param string $value (required, string) The Access Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_AuthorizeSecurityGroupIngress_Inputs For method chaining.
     */
    public function setAWSAccessKeyId($value)
    {
        return $this->set('AWSAccessKeyId', $value);
    }

    /**
     * Set the value for the AWSSecretKeyId input for this AuthorizeSecurityGroupIngress Choreo.
     *
     * @param string $value (required, string) The Secret Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_AuthorizeSecurityGroupIngress_Inputs For method chaining.
     */
    public function setAWSSecretKeyId($value)
    {
        return $this->set('AWSSecretKeyId', $value);
    }

    /**
     * Set the value for the GroupId input for this AuthorizeSecurityGroupIngress Choreo.
     *
     * @param string $value (conditional, string) The ID of the security group to modify. Can be used instead of GroupName.
     * @return Amazon_EC2_AuthorizeSecurityGroupIngress_Inputs For method chaining.
     */
    public function setGroupId($value)
    {
        return $this->set('GroupId', $value);
    }

    /**
     * Set the value for the GroupName input for this AuthorizeSecurityGroupIngress Choreo.
     *
     * @param string $value (conditional, string) The name of the security group to modify. Can be used instead of GroupId.
     * @return Amazon_EC2_AuthorizeSecurityGroupIngress_Inputs For method chaining.
     */
    public function setGroupName($value)
    {
        return $this->set('GroupName', $value);
    }

    /**
     * Set the value for the IpPermissionsCidrIp input for this AuthorizeSecurityGroupIngress Choreo.
     *
     * @param string $value (optional, string) The CIDR range. Cannot be used when specifying a source security group.
     * @return Amazon_EC2_AuthorizeSecurityGroupIngress_Inputs For method chaining.
     */
    public function setIpPermissionsCidrIp($value)
    {
        return $this->set('IpPermissionsCidrIp', $value);
    }

    /**
     * Set the value for the IpPermissionsFromPort input for this AuthorizeSecurityGroupIngress Choreo.
     *
     * @param int $value (optional, integer) The start of port range for the TCP and UDP protocols, or an ICMP type number. For the ICMP type number, you can use -1 to specify all ICMP types.
     * @return Amazon_EC2_AuthorizeSecurityGroupIngress_Inputs For method chaining.
     */
    public function setIpPermissionsFromPort($value)
    {
        return $this->set('IpPermissionsFromPort', $value);
    }

    /**
     * Set the value for the IpPermissionsGroupId input for this AuthorizeSecurityGroupIngress Choreo.
     *
     * @param string $value (optional, string) The ID of the source security group. Cannot be used when specifying a CIDR IP address.
     * @return Amazon_EC2_AuthorizeSecurityGroupIngress_Inputs For method chaining.
     */
    public function setIpPermissionsGroupId($value)
    {
        return $this->set('IpPermissionsGroupId', $value);
    }

    /**
     * Set the value for the IpPermissionsGroupName input for this AuthorizeSecurityGroupIngress Choreo.
     *
     * @param string $value (optional, string) The name of the source security group. Cannot be used when specifying a CIDR IP address.
     * @return Amazon_EC2_AuthorizeSecurityGroupIngress_Inputs For method chaining.
     */
    public function setIpPermissionsGroupName($value)
    {
        return $this->set('IpPermissionsGroupName', $value);
    }

    /**
     * Set the value for the IpPermissionsIpProtocol input for this AuthorizeSecurityGroupIngress Choreo.
     *
     * @param string $value (required, string) The IP protocol name or number. Valid values for EC2-Classic: tcp, udp, icmp (or 6, 17, 1). Valid values for EC2-VPC: tcp, udp, icmp, any valid protocol number (0-254), or -1 (to specify all).
     * @return Amazon_EC2_AuthorizeSecurityGroupIngress_Inputs For method chaining.
     */
    public function setIpPermissionsIpProtocol($value)
    {
        return $this->set('IpPermissionsIpProtocol', $value);
    }

    /**
     * Set the value for the IpPermissionsToPort input for this AuthorizeSecurityGroupIngress Choreo.
     *
     * @param int $value (optional, integer) The end of port range for the TCP and UDP protocols, or an ICMP code number. For the ICMP code number, you can use -1 to specify all ICMP codes for the given ICMP type.
     * @return Amazon_EC2_AuthorizeSecurityGroupIngress_Inputs For method chaining.
     */
    public function setIpPermissionsToPort($value)
    {
        return $this->set('IpPermissionsToPort', $value);
    }

    /**
     * Set the value for the IpPermissionsUserId input for this AuthorizeSecurityGroupIngress Choreo.
     *
     * @param string $value (optional, string) The AWS account ID that owns the source security group. Cannot be used when specifying a CIDR IP address.
     * @return Amazon_EC2_AuthorizeSecurityGroupIngress_Inputs For method chaining.
     */
    public function setIpPermissionsUserId($value)
    {
        return $this->set('IpPermissionsUserId', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this AuthorizeSecurityGroupIngress Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
     * @return Amazon_EC2_AuthorizeSecurityGroupIngress_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }

    /**
     * Set the value for the UserRegion input for this AuthorizeSecurityGroupIngress Choreo.
     *
     * @param string $value (optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
     * @return Amazon_EC2_AuthorizeSecurityGroupIngress_Inputs For method chaining.
     */
    public function setUserRegion($value)
    {
        return $this->set('UserRegion', $value);
    }
}


/**
 * Execution object for the AuthorizeSecurityGroupIngress Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_AuthorizeSecurityGroupIngress_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the AuthorizeSecurityGroupIngress Choreo.
     *
     * @param Temboo_Session $session The session that owns this AuthorizeSecurityGroupIngress execution.
     * @param Amazon_EC2_AuthorizeSecurityGroupIngress $choreo The choreography object for this execution.
     * @param Amazon_EC2_AuthorizeSecurityGroupIngress_Inputs|array $inputs (optional) Inputs as Amazon_EC2_AuthorizeSecurityGroupIngress_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_AuthorizeSecurityGroupIngress_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_EC2_AuthorizeSecurityGroupIngress $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this AuthorizeSecurityGroupIngress execution.
     *
     * @return Amazon_EC2_AuthorizeSecurityGroupIngress_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this AuthorizeSecurityGroupIngress execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_EC2_AuthorizeSecurityGroupIngress_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_EC2_AuthorizeSecurityGroupIngress_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the AuthorizeSecurityGroupIngress Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_AuthorizeSecurityGroupIngress_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the AuthorizeSecurityGroupIngress Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_EC2_AuthorizeSecurityGroupIngress_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this AuthorizeSecurityGroupIngress execution.
     *
     * @return string The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Creates an Amazon Machine Image from an Amazon EBS-backed instance using the Amazon EC2 API. The image can be used later to launch other identical servers.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_CreateImage extends Temboo_Choreography
{
    /**
     * Creates an Amazon Machine Image from an Amazon EBS-backed instance using the Amazon EC2 API. The image can be used later to launch other identical servers.
     *
     * @param Temboo_Session $session The session that owns this CreateImage Choreo.
     * @return Amazon_EC2_CreateImage New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/EC2/CreateImage/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this CreateImage Choreo.
     *
     * @param Amazon_EC2_CreateImage_Inputs|array $inputs (optional) Inputs as Amazon_EC2_CreateImage_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_CreateImage_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_EC2_CreateImage_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this CreateImage Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_CreateImage_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_EC2_CreateImage_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the CreateImage Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_CreateImage_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the CreateImage Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_CreateImage_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this CreateImage input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_EC2_CreateImage_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_EC2_CreateImage_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AWSAccessKeyId input for this CreateImage Choreo.
     *
     * @param string $value (required, string) The Access Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_CreateImage_Inputs For method chaining.
     */
    public function setAWSAccessKeyId($value)
    {
        return $this->set('AWSAccessKeyId', $value);
    }

    /**
     * Set the value for the AWSSecretKeyId input for this CreateImage Choreo.
     *
     * @param string $value (required, string) The Secret Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_CreateImage_Inputs For method chaining.
     */
    public function setAWSSecretKeyId($value)
    {
        return $this->set('AWSSecretKeyId', $value);
    }

    /**
     * Set the value for the DeleteOnTermination input for this CreateImage Choreo.
     *
     * @param bool $value (optional, boolean) Whether the volume is deleted on instance termination. Defaults to "true".
     * @return Amazon_EC2_CreateImage_Inputs For method chaining.
     */
    public function setDeleteOnTermination($value)
    {
        return $this->set('DeleteOnTermination', $value);
    }

    /**
     * Set the value for the Description input for this CreateImage Choreo.
     *
     * @param string $value (optional, string) A description for the image you want to create.
     * @return Amazon_EC2_CreateImage_Inputs For method chaining.
     */
    public function setDescription($value)
    {
        return $this->set('Description', $value);
    }

    /**
     * Set the value for the DeviceName input for this CreateImage Choreo.
     *
     * @param string $value (conditional, string) The device name exposed to the instance (i.e. /dev/sdh or xvdh). When registering an AMI from a snapshot, DiviceName is required as well as SnapshotId.
     * @return Amazon_EC2_CreateImage_Inputs For method chaining.
     */
    public function setDeviceName($value)
    {
        return $this->set('DeviceName', $value);
    }

    /**
     * Set the value for the InstanceId input for this CreateImage Choreo.
     *
     * @param string $value (required, string) The ID of the instance to create the image on.
     * @return Amazon_EC2_CreateImage_Inputs For method chaining.
     */
    public function setInstanceId($value)
    {
        return $this->set('InstanceId', $value);
    }

    /**
     * Set the value for the Iops input for this CreateImage Choreo.
     *
     * @param int $value (conditional, integer) The number of I/O operations per second (IOPS) that the volume supports. Valid range is 100 to 2000.
     * @return Amazon_EC2_CreateImage_Inputs For method chaining.
     */
    public function setIops($value)
    {
        return $this->set('Iops', $value);
    }

    /**
     * Set the value for the Name input for this CreateImage Choreo.
     *
     * @param string $value (required, string) The name for the image you are creating.
     * @return Amazon_EC2_CreateImage_Inputs For method chaining.
     */
    public function setName($value)
    {
        return $this->set('Name', $value);
    }

    /**
     * Set the value for the NoDevice input for this CreateImage Choreo.
     *
     * @param bool $value (optional, boolean) Suppresses a device mapping. Defaults to "true".
     * @return Amazon_EC2_CreateImage_Inputs For method chaining.
     */
    public function setNoDevice($value)
    {
        return $this->set('NoDevice', $value);
    }

    /**
     * Set the value for the NoReboot input for this CreateImage Choreo.
     *
     * @param bool $value (optional, boolean) Defaults to "false". Amazon EC2 will attempt to shut down the instance before and after creating the image. Set to "true" for NoReboot.
     * @return Amazon_EC2_CreateImage_Inputs For method chaining.
     */
    public function setNoReboot($value)
    {
        return $this->set('NoReboot', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this CreateImage Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
     * @return Amazon_EC2_CreateImage_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }

    /**
     * Set the value for the SnapshotId input for this CreateImage Choreo.
     *
     * @param string $value (conditional, string) The ID of the snapshot. Required when registering from a snapshot. You must also specify DeviceName with the root device name.
     * @return Amazon_EC2_CreateImage_Inputs For method chaining.
     */
    public function setSnapshotId($value)
    {
        return $this->set('SnapshotId', $value);
    }

    /**
     * Set the value for the UserRegion input for this CreateImage Choreo.
     *
     * @param string $value (optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
     * @return Amazon_EC2_CreateImage_Inputs For method chaining.
     */
    public function setUserRegion($value)
    {
        return $this->set('UserRegion', $value);
    }

    /**
     * Set the value for the VirtualName input for this CreateImage Choreo.
     *
     * @param string $value (optional, string) The name of the virtual device.
     * @return Amazon_EC2_CreateImage_Inputs For method chaining.
     */
    public function setVirtualName($value)
    {
        return $this->set('VirtualName', $value);
    }

    /**
     * Set the value for the VolumeSize input for this CreateImage Choreo.
     *
     * @param string $value (conditional, string) The size of the volume, in GiBs. Required unless you're creating the volume from a snapshot which indicates that the size will be the size of the snapshot.
     * @return Amazon_EC2_CreateImage_Inputs For method chaining.
     */
    public function setVolumeSize($value)
    {
        return $this->set('VolumeSize', $value);
    }

    /**
     * Set the value for the VolumeType input for this CreateImage Choreo.
     *
     * @param string $value (optional, string) The volume type. Valid values are: standard (the default) and io1.
     * @return Amazon_EC2_CreateImage_Inputs For method chaining.
     */
    public function setVolumeType($value)
    {
        return $this->set('VolumeType', $value);
    }
}


/**
 * Execution object for the CreateImage Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_CreateImage_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the CreateImage Choreo.
     *
     * @param Temboo_Session $session The session that owns this CreateImage execution.
     * @param Amazon_EC2_CreateImage $choreo The choreography object for this execution.
     * @param Amazon_EC2_CreateImage_Inputs|array $inputs (optional) Inputs as Amazon_EC2_CreateImage_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_CreateImage_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_EC2_CreateImage $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this CreateImage execution.
     *
     * @return Amazon_EC2_CreateImage_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this CreateImage execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_EC2_CreateImage_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_EC2_CreateImage_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the CreateImage Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_CreateImage_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the CreateImage Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_EC2_CreateImage_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this CreateImage execution.
     *
     * @return string The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Creates a new 2048-bit RSA key pair with the specified name using the Amazon EC2 API.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_CreateKeyPair extends Temboo_Choreography
{
    /**
     * Creates a new 2048-bit RSA key pair with the specified name using the Amazon EC2 API.
     *
     * @param Temboo_Session $session The session that owns this CreateKeyPair Choreo.
     * @return Amazon_EC2_CreateKeyPair New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/EC2/CreateKeyPair/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this CreateKeyPair Choreo.
     *
     * @param Amazon_EC2_CreateKeyPair_Inputs|array $inputs (optional) Inputs as Amazon_EC2_CreateKeyPair_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_CreateKeyPair_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_EC2_CreateKeyPair_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this CreateKeyPair Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_CreateKeyPair_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_EC2_CreateKeyPair_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the CreateKeyPair Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_CreateKeyPair_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the CreateKeyPair Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_CreateKeyPair_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this CreateKeyPair input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_EC2_CreateKeyPair_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_EC2_CreateKeyPair_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AWSAccessKeyId input for this CreateKeyPair Choreo.
     *
     * @param string $value (required, string) The Access Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_CreateKeyPair_Inputs For method chaining.
     */
    public function setAWSAccessKeyId($value)
    {
        return $this->set('AWSAccessKeyId', $value);
    }

    /**
     * Set the value for the AWSSecretKeyId input for this CreateKeyPair Choreo.
     *
     * @param string $value (required, string) The Secret Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_CreateKeyPair_Inputs For method chaining.
     */
    public function setAWSSecretKeyId($value)
    {
        return $this->set('AWSSecretKeyId', $value);
    }

    /**
     * Set the value for the KeyName input for this CreateKeyPair Choreo.
     *
     * @param string $value (required, string) A unique name for the key pair.
     * @return Amazon_EC2_CreateKeyPair_Inputs For method chaining.
     */
    public function setKeyName($value)
    {
        return $this->set('KeyName', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this CreateKeyPair Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
     * @return Amazon_EC2_CreateKeyPair_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }

    /**
     * Set the value for the UserRegion input for this CreateKeyPair Choreo.
     *
     * @param string $value (optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
     * @return Amazon_EC2_CreateKeyPair_Inputs For method chaining.
     */
    public function setUserRegion($value)
    {
        return $this->set('UserRegion', $value);
    }
}


/**
 * Execution object for the CreateKeyPair Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_CreateKeyPair_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the CreateKeyPair Choreo.
     *
     * @param Temboo_Session $session The session that owns this CreateKeyPair execution.
     * @param Amazon_EC2_CreateKeyPair $choreo The choreography object for this execution.
     * @param Amazon_EC2_CreateKeyPair_Inputs|array $inputs (optional) Inputs as Amazon_EC2_CreateKeyPair_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_CreateKeyPair_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_EC2_CreateKeyPair $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this CreateKeyPair execution.
     *
     * @return Amazon_EC2_CreateKeyPair_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this CreateKeyPair execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_EC2_CreateKeyPair_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_EC2_CreateKeyPair_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the CreateKeyPair Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_CreateKeyPair_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the CreateKeyPair Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_EC2_CreateKeyPair_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this CreateKeyPair execution.
     *
     * @return string The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Creates a new EC2 security group using the Amazon EC2 API.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_CreateSecurityGroup extends Temboo_Choreography
{
    /**
     * Creates a new EC2 security group using the Amazon EC2 API.
     *
     * @param Temboo_Session $session The session that owns this CreateSecurityGroup Choreo.
     * @return Amazon_EC2_CreateSecurityGroup New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/EC2/CreateSecurityGroup/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this CreateSecurityGroup Choreo.
     *
     * @param Amazon_EC2_CreateSecurityGroup_Inputs|array $inputs (optional) Inputs as Amazon_EC2_CreateSecurityGroup_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_CreateSecurityGroup_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_EC2_CreateSecurityGroup_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this CreateSecurityGroup Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_CreateSecurityGroup_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_EC2_CreateSecurityGroup_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the CreateSecurityGroup Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_CreateSecurityGroup_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the CreateSecurityGroup Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_CreateSecurityGroup_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this CreateSecurityGroup input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_EC2_CreateSecurityGroup_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_EC2_CreateSecurityGroup_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AWSAccessKeyId input for this CreateSecurityGroup Choreo.
     *
     * @param string $value (required, string) The Access Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_CreateSecurityGroup_Inputs For method chaining.
     */
    public function setAWSAccessKeyId($value)
    {
        return $this->set('AWSAccessKeyId', $value);
    }

    /**
     * Set the value for the AWSSecretKeyId input for this CreateSecurityGroup Choreo.
     *
     * @param string $value (required, string) The Secret Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_CreateSecurityGroup_Inputs For method chaining.
     */
    public function setAWSSecretKeyId($value)
    {
        return $this->set('AWSSecretKeyId', $value);
    }

    /**
     * Set the value for the GroupDescription input for this CreateSecurityGroup Choreo.
     *
     * @param string $value (required, string) A description for the security group that that you want to create.
     * @return Amazon_EC2_CreateSecurityGroup_Inputs For method chaining.
     */
    public function setGroupDescription($value)
    {
        return $this->set('GroupDescription', $value);
    }

    /**
     * Set the value for the GroupName input for this CreateSecurityGroup Choreo.
     *
     * @param string $value (required, string) A name for the security group to create.
     * @return Amazon_EC2_CreateSecurityGroup_Inputs For method chaining.
     */
    public function setGroupName($value)
    {
        return $this->set('GroupName', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this CreateSecurityGroup Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
     * @return Amazon_EC2_CreateSecurityGroup_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }

    /**
     * Set the value for the UserRegion input for this CreateSecurityGroup Choreo.
     *
     * @param string $value (optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
     * @return Amazon_EC2_CreateSecurityGroup_Inputs For method chaining.
     */
    public function setUserRegion($value)
    {
        return $this->set('UserRegion', $value);
    }

    /**
     * Set the value for the VpcId input for this CreateSecurityGroup Choreo.
     *
     * @param string $value (optional, string) The ID of the VPC. Required for EC2-VPC.
     * @return Amazon_EC2_CreateSecurityGroup_Inputs For method chaining.
     */
    public function setVpcId($value)
    {
        return $this->set('VpcId', $value);
    }
}


/**
 * Execution object for the CreateSecurityGroup Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_CreateSecurityGroup_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the CreateSecurityGroup Choreo.
     *
     * @param Temboo_Session $session The session that owns this CreateSecurityGroup execution.
     * @param Amazon_EC2_CreateSecurityGroup $choreo The choreography object for this execution.
     * @param Amazon_EC2_CreateSecurityGroup_Inputs|array $inputs (optional) Inputs as Amazon_EC2_CreateSecurityGroup_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_CreateSecurityGroup_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_EC2_CreateSecurityGroup $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this CreateSecurityGroup execution.
     *
     * @return Amazon_EC2_CreateSecurityGroup_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this CreateSecurityGroup execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_EC2_CreateSecurityGroup_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_EC2_CreateSecurityGroup_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the CreateSecurityGroup Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_CreateSecurityGroup_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the CreateSecurityGroup Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_EC2_CreateSecurityGroup_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this CreateSecurityGroup execution.
     *
     * @return string The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Create a snapshot from a specified EBS volume using the Amazon EC2 API.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_CreateSnapshot extends Temboo_Choreography
{
    /**
     * Create a snapshot from a specified EBS volume using the Amazon EC2 API.
     *
     * @param Temboo_Session $session The session that owns this CreateSnapshot Choreo.
     * @return Amazon_EC2_CreateSnapshot New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/EC2/CreateSnapshot/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this CreateSnapshot Choreo.
     *
     * @param Amazon_EC2_CreateSnapshot_Inputs|array $inputs (optional) Inputs as Amazon_EC2_CreateSnapshot_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_CreateSnapshot_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_EC2_CreateSnapshot_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this CreateSnapshot Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_CreateSnapshot_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_EC2_CreateSnapshot_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the CreateSnapshot Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_CreateSnapshot_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the CreateSnapshot Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_CreateSnapshot_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this CreateSnapshot input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_EC2_CreateSnapshot_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_EC2_CreateSnapshot_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AWSAccessKeyId input for this CreateSnapshot Choreo.
     *
     * @param string $value (required, string) The Access Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_CreateSnapshot_Inputs For method chaining.
     */
    public function setAWSAccessKeyId($value)
    {
        return $this->set('AWSAccessKeyId', $value);
    }

    /**
     * Set the value for the AWSSecretKeyId input for this CreateSnapshot Choreo.
     *
     * @param string $value (required, string) The Secret Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_CreateSnapshot_Inputs For method chaining.
     */
    public function setAWSSecretKeyId($value)
    {
        return $this->set('AWSSecretKeyId', $value);
    }

    /**
     * Set the value for the Description input for this CreateSnapshot Choreo.
     *
     * @param string $value (optional, string) A description for the volume that you want to create.
     * @return Amazon_EC2_CreateSnapshot_Inputs For method chaining.
     */
    public function setDescription($value)
    {
        return $this->set('Description', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this CreateSnapshot Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
     * @return Amazon_EC2_CreateSnapshot_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }

    /**
     * Set the value for the UserRegion input for this CreateSnapshot Choreo.
     *
     * @param string $value (optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
     * @return Amazon_EC2_CreateSnapshot_Inputs For method chaining.
     */
    public function setUserRegion($value)
    {
        return $this->set('UserRegion', $value);
    }

    /**
     * Set the value for the VolumeId input for this CreateSnapshot Choreo.
     *
     * @param string $value (required, string) The id of the EBS volume to snapshot.
     * @return Amazon_EC2_CreateSnapshot_Inputs For method chaining.
     */
    public function setVolumeId($value)
    {
        return $this->set('VolumeId', $value);
    }
}


/**
 * Execution object for the CreateSnapshot Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_CreateSnapshot_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the CreateSnapshot Choreo.
     *
     * @param Temboo_Session $session The session that owns this CreateSnapshot execution.
     * @param Amazon_EC2_CreateSnapshot $choreo The choreography object for this execution.
     * @param Amazon_EC2_CreateSnapshot_Inputs|array $inputs (optional) Inputs as Amazon_EC2_CreateSnapshot_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_CreateSnapshot_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_EC2_CreateSnapshot $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this CreateSnapshot execution.
     *
     * @return Amazon_EC2_CreateSnapshot_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this CreateSnapshot execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_EC2_CreateSnapshot_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_EC2_CreateSnapshot_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the CreateSnapshot Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_CreateSnapshot_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the CreateSnapshot Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_EC2_CreateSnapshot_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this CreateSnapshot execution.
     *
     * @return string The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Adds or overwrites one or more tags for the specified EC2 resource or resources using the Amazon EC2 API.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_CreateTags extends Temboo_Choreography
{
    /**
     * Adds or overwrites one or more tags for the specified EC2 resource or resources using the Amazon EC2 API.
     *
     * @param Temboo_Session $session The session that owns this CreateTags Choreo.
     * @return Amazon_EC2_CreateTags New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/EC2/CreateTags/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this CreateTags Choreo.
     *
     * @param Amazon_EC2_CreateTags_Inputs|array $inputs (optional) Inputs as Amazon_EC2_CreateTags_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_CreateTags_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_EC2_CreateTags_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this CreateTags Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_CreateTags_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_EC2_CreateTags_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the CreateTags Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_CreateTags_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the CreateTags Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_CreateTags_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this CreateTags input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_EC2_CreateTags_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_EC2_CreateTags_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AWSAccessKeyId input for this CreateTags Choreo.
     *
     * @param string $value (required, string) The Access Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_CreateTags_Inputs For method chaining.
     */
    public function setAWSAccessKeyId($value)
    {
        return $this->set('AWSAccessKeyId', $value);
    }

    /**
     * Set the value for the AWSSecretKeyId input for this CreateTags Choreo.
     *
     * @param string $value (required, string) The Secret Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_CreateTags_Inputs For method chaining.
     */
    public function setAWSSecretKeyId($value)
    {
        return $this->set('AWSSecretKeyId', $value);
    }

    /**
     * Set the value for the ResourceId input for this CreateTags Choreo.
     *
     * @param string $value (required, string) The ID of a resource to tag. This can be a comma-separated list of up to 10  Resource IDs.
     * @return Amazon_EC2_CreateTags_Inputs For method chaining.
     */
    public function setResourceId($value)
    {
        return $this->set('ResourceId', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this CreateTags Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
     * @return Amazon_EC2_CreateTags_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }

    /**
     * Set the value for the TagKey input for this CreateTags Choreo.
     *
     * @param string $value (required, string) The key for a tag.
     * @return Amazon_EC2_CreateTags_Inputs For method chaining.
     */
    public function setTagKey($value)
    {
        return $this->set('TagKey', $value);
    }

    /**
     * Set the value for the TagValue input for this CreateTags Choreo.
     *
     * @param string $value (conditional, string) The value for a tag. If empty, the value will be set to be an empty string.
     * @return Amazon_EC2_CreateTags_Inputs For method chaining.
     */
    public function setTagValue($value)
    {
        return $this->set('TagValue', $value);
    }

    /**
     * Set the value for the UserRegion input for this CreateTags Choreo.
     *
     * @param string $value (optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
     * @return Amazon_EC2_CreateTags_Inputs For method chaining.
     */
    public function setUserRegion($value)
    {
        return $this->set('UserRegion', $value);
    }
}


/**
 * Execution object for the CreateTags Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_CreateTags_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the CreateTags Choreo.
     *
     * @param Temboo_Session $session The session that owns this CreateTags execution.
     * @param Amazon_EC2_CreateTags $choreo The choreography object for this execution.
     * @param Amazon_EC2_CreateTags_Inputs|array $inputs (optional) Inputs as Amazon_EC2_CreateTags_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_CreateTags_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_EC2_CreateTags $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this CreateTags execution.
     *
     * @return Amazon_EC2_CreateTags_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this CreateTags execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_EC2_CreateTags_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_EC2_CreateTags_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the CreateTags Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_CreateTags_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the CreateTags Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_EC2_CreateTags_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this CreateTags execution.
     *
     * @return string The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Calls the Amazon EC2 API to create a new EBS volume that your EC2 instance can attach to.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_CreateVolume extends Temboo_Choreography
{
    /**
     * Calls the Amazon EC2 API to create a new EBS volume that your EC2 instance can attach to.
     *
     * @param Temboo_Session $session The session that owns this CreateVolume Choreo.
     * @return Amazon_EC2_CreateVolume New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/EC2/CreateVolume/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this CreateVolume Choreo.
     *
     * @param Amazon_EC2_CreateVolume_Inputs|array $inputs (optional) Inputs as Amazon_EC2_CreateVolume_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_CreateVolume_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_EC2_CreateVolume_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this CreateVolume Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_CreateVolume_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_EC2_CreateVolume_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the CreateVolume Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_CreateVolume_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the CreateVolume Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_CreateVolume_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this CreateVolume input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_EC2_CreateVolume_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_EC2_CreateVolume_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AWSAccessKeyId input for this CreateVolume Choreo.
     *
     * @param string $value (required, string) The Access Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_CreateVolume_Inputs For method chaining.
     */
    public function setAWSAccessKeyId($value)
    {
        return $this->set('AWSAccessKeyId', $value);
    }

    /**
     * Set the value for the AWSSecretKeyId input for this CreateVolume Choreo.
     *
     * @param string $value (required, string) The Secret Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_CreateVolume_Inputs For method chaining.
     */
    public function setAWSSecretKeyId($value)
    {
        return $this->set('AWSSecretKeyId', $value);
    }

    /**
     * Set the value for the AvailabilityZone input for this CreateVolume Choreo.
     *
     * @param string $value (required, string) The Availability Zone to use when creating thew new volume (i.e us-east-1a).
     * @return Amazon_EC2_CreateVolume_Inputs For method chaining.
     */
    public function setAvailabilityZone($value)
    {
        return $this->set('AvailabilityZone', $value);
    }

    /**
     * Set the value for the Iops input for this CreateVolume Choreo.
     *
     * @param int $value (optional, integer) The number of I/O operations per second (IOPS) that the volume supports. Valid range is 100 to 2000. Required when the volume type is io1.
     * @return Amazon_EC2_CreateVolume_Inputs For method chaining.
     */
    public function setIops($value)
    {
        return $this->set('Iops', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this CreateVolume Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
     * @return Amazon_EC2_CreateVolume_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }

    /**
     * Set the value for the Size input for this CreateVolume Choreo.
     *
     * @param int $value (conditional, integer) The size for the volume (in gigabytes) that you are creating. Valid Values are 1-1024. Required if you're not creating a volume from a snapshot. If the volume type is io1, the min size is 10 GiB.
     * @return Amazon_EC2_CreateVolume_Inputs For method chaining.
     */
    public function setSize($value)
    {
        return $this->set('Size', $value);
    }

    /**
     * Set the value for the SnapshotId input for this CreateVolume Choreo.
     *
     * @param string $value (conditional, string) The snapshot from which to create the new volume. Required if you are creating a volume from a snapshot.
     * @return Amazon_EC2_CreateVolume_Inputs For method chaining.
     */
    public function setSnapshotId($value)
    {
        return $this->set('SnapshotId', $value);
    }

    /**
     * Set the value for the UserRegion input for this CreateVolume Choreo.
     *
     * @param string $value (optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
     * @return Amazon_EC2_CreateVolume_Inputs For method chaining.
     */
    public function setUserRegion($value)
    {
        return $this->set('UserRegion', $value);
    }

    /**
     * Set the value for the VolumeType input for this CreateVolume Choreo.
     *
     * @param string $value (optional, string) The volume type.Valid values are: "standard" (the default) and "io1".
     * @return Amazon_EC2_CreateVolume_Inputs For method chaining.
     */
    public function setVolumeType($value)
    {
        return $this->set('VolumeType', $value);
    }
}


/**
 * Execution object for the CreateVolume Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_CreateVolume_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the CreateVolume Choreo.
     *
     * @param Temboo_Session $session The session that owns this CreateVolume execution.
     * @param Amazon_EC2_CreateVolume $choreo The choreography object for this execution.
     * @param Amazon_EC2_CreateVolume_Inputs|array $inputs (optional) Inputs as Amazon_EC2_CreateVolume_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_CreateVolume_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_EC2_CreateVolume $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this CreateVolume execution.
     *
     * @return Amazon_EC2_CreateVolume_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this CreateVolume execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_EC2_CreateVolume_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_EC2_CreateVolume_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the CreateVolume Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_CreateVolume_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the CreateVolume Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_EC2_CreateVolume_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this CreateVolume execution.
     *
     * @return string The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Deletes the specified key pair by removing the public key from Amazon EC2 using the Amazon EC2 API. You must own the key pair.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_DeleteKeyPair extends Temboo_Choreography
{
    /**
     * Deletes the specified key pair by removing the public key from Amazon EC2 using the Amazon EC2 API. You must own the key pair.
     *
     * @param Temboo_Session $session The session that owns this DeleteKeyPair Choreo.
     * @return Amazon_EC2_DeleteKeyPair New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/EC2/DeleteKeyPair/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this DeleteKeyPair Choreo.
     *
     * @param Amazon_EC2_DeleteKeyPair_Inputs|array $inputs (optional) Inputs as Amazon_EC2_DeleteKeyPair_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_DeleteKeyPair_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_EC2_DeleteKeyPair_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this DeleteKeyPair Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_DeleteKeyPair_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_EC2_DeleteKeyPair_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the DeleteKeyPair Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_DeleteKeyPair_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the DeleteKeyPair Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_DeleteKeyPair_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this DeleteKeyPair input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_EC2_DeleteKeyPair_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_EC2_DeleteKeyPair_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AWSAccessKeyId input for this DeleteKeyPair Choreo.
     *
     * @param string $value (required, string) The Access Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_DeleteKeyPair_Inputs For method chaining.
     */
    public function setAWSAccessKeyId($value)
    {
        return $this->set('AWSAccessKeyId', $value);
    }

    /**
     * Set the value for the AWSSecretKeyId input for this DeleteKeyPair Choreo.
     *
     * @param string $value (required, string) The Secret Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_DeleteKeyPair_Inputs For method chaining.
     */
    public function setAWSSecretKeyId($value)
    {
        return $this->set('AWSSecretKeyId', $value);
    }

    /**
     * Set the value for the KeyName input for this DeleteKeyPair Choreo.
     *
     * @param string $value (required, string) A unique name for the key pair.
     * @return Amazon_EC2_DeleteKeyPair_Inputs For method chaining.
     */
    public function setKeyName($value)
    {
        return $this->set('KeyName', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this DeleteKeyPair Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
     * @return Amazon_EC2_DeleteKeyPair_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }

    /**
     * Set the value for the UserRegion input for this DeleteKeyPair Choreo.
     *
     * @param string $value (optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
     * @return Amazon_EC2_DeleteKeyPair_Inputs For method chaining.
     */
    public function setUserRegion($value)
    {
        return $this->set('UserRegion', $value);
    }
}


/**
 * Execution object for the DeleteKeyPair Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_DeleteKeyPair_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the DeleteKeyPair Choreo.
     *
     * @param Temboo_Session $session The session that owns this DeleteKeyPair execution.
     * @param Amazon_EC2_DeleteKeyPair $choreo The choreography object for this execution.
     * @param Amazon_EC2_DeleteKeyPair_Inputs|array $inputs (optional) Inputs as Amazon_EC2_DeleteKeyPair_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_DeleteKeyPair_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_EC2_DeleteKeyPair $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this DeleteKeyPair execution.
     *
     * @return Amazon_EC2_DeleteKeyPair_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this DeleteKeyPair execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_EC2_DeleteKeyPair_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_EC2_DeleteKeyPair_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the DeleteKeyPair Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_DeleteKeyPair_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the DeleteKeyPair Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_EC2_DeleteKeyPair_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this DeleteKeyPair execution.
     *
     * @return string The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Calls the Amazon EC2 API to delete a security group using the group name you specify.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_DeleteSecurityGroup extends Temboo_Choreography
{
    /**
     * Calls the Amazon EC2 API to delete a security group using the group name you specify.
     *
     * @param Temboo_Session $session The session that owns this DeleteSecurityGroup Choreo.
     * @return Amazon_EC2_DeleteSecurityGroup New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/EC2/DeleteSecurityGroup/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this DeleteSecurityGroup Choreo.
     *
     * @param Amazon_EC2_DeleteSecurityGroup_Inputs|array $inputs (optional) Inputs as Amazon_EC2_DeleteSecurityGroup_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_DeleteSecurityGroup_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_EC2_DeleteSecurityGroup_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this DeleteSecurityGroup Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_DeleteSecurityGroup_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_EC2_DeleteSecurityGroup_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the DeleteSecurityGroup Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_DeleteSecurityGroup_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the DeleteSecurityGroup Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_DeleteSecurityGroup_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this DeleteSecurityGroup input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_EC2_DeleteSecurityGroup_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_EC2_DeleteSecurityGroup_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AWSAccessKeyId input for this DeleteSecurityGroup Choreo.
     *
     * @param string $value (required, string) The Access Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_DeleteSecurityGroup_Inputs For method chaining.
     */
    public function setAWSAccessKeyId($value)
    {
        return $this->set('AWSAccessKeyId', $value);
    }

    /**
     * Set the value for the AWSSecretKeyId input for this DeleteSecurityGroup Choreo.
     *
     * @param string $value (required, string) The Secret Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_DeleteSecurityGroup_Inputs For method chaining.
     */
    public function setAWSSecretKeyId($value)
    {
        return $this->set('AWSSecretKeyId', $value);
    }

    /**
     * Set the value for the GroupId input for this DeleteSecurityGroup Choreo.
     *
     * @param string $value (conditional, string) The id of the security group to delete. Required unless providing the GroupName.
     * @return Amazon_EC2_DeleteSecurityGroup_Inputs For method chaining.
     */
    public function setGroupId($value)
    {
        return $this->set('GroupId', $value);
    }

    /**
     * Set the value for the GroupName input for this DeleteSecurityGroup Choreo.
     *
     * @param string $value (conditional, string) The name of the security group to delete.Required unless providing the GroupId.
     * @return Amazon_EC2_DeleteSecurityGroup_Inputs For method chaining.
     */
    public function setGroupName($value)
    {
        return $this->set('GroupName', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this DeleteSecurityGroup Choreo.
     *
     * @param mixed $value (optional, any) The format that the response should be in. Valid values are "xml" (the default) and "json".
     * @return Amazon_EC2_DeleteSecurityGroup_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }

    /**
     * Set the value for the UserRegion input for this DeleteSecurityGroup Choreo.
     *
     * @param string $value (optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
     * @return Amazon_EC2_DeleteSecurityGroup_Inputs For method chaining.
     */
    public function setUserRegion($value)
    {
        return $this->set('UserRegion', $value);
    }
}


/**
 * Execution object for the DeleteSecurityGroup Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_DeleteSecurityGroup_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the DeleteSecurityGroup Choreo.
     *
     * @param Temboo_Session $session The session that owns this DeleteSecurityGroup execution.
     * @param Amazon_EC2_DeleteSecurityGroup $choreo The choreography object for this execution.
     * @param Amazon_EC2_DeleteSecurityGroup_Inputs|array $inputs (optional) Inputs as Amazon_EC2_DeleteSecurityGroup_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_DeleteSecurityGroup_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_EC2_DeleteSecurityGroup $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this DeleteSecurityGroup execution.
     *
     * @return Amazon_EC2_DeleteSecurityGroup_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this DeleteSecurityGroup execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_EC2_DeleteSecurityGroup_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_EC2_DeleteSecurityGroup_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the DeleteSecurityGroup Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_DeleteSecurityGroup_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the DeleteSecurityGroup Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_EC2_DeleteSecurityGroup_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this DeleteSecurityGroup execution.
     *
     * @return string The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Calls the Amazon EC2 API to delete a snapshot using a snapshot id that you specify.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_DeleteSnapshot extends Temboo_Choreography
{
    /**
     * Calls the Amazon EC2 API to delete a snapshot using a snapshot id that you specify.
     *
     * @param Temboo_Session $session The session that owns this DeleteSnapshot Choreo.
     * @return Amazon_EC2_DeleteSnapshot New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/EC2/DeleteSnapshot/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this DeleteSnapshot Choreo.
     *
     * @param Amazon_EC2_DeleteSnapshot_Inputs|array $inputs (optional) Inputs as Amazon_EC2_DeleteSnapshot_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_DeleteSnapshot_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_EC2_DeleteSnapshot_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this DeleteSnapshot Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_DeleteSnapshot_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_EC2_DeleteSnapshot_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the DeleteSnapshot Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_DeleteSnapshot_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the DeleteSnapshot Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_DeleteSnapshot_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this DeleteSnapshot input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_EC2_DeleteSnapshot_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_EC2_DeleteSnapshot_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AWSAccessKeyId input for this DeleteSnapshot Choreo.
     *
     * @param string $value (required, string) The Access Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_DeleteSnapshot_Inputs For method chaining.
     */
    public function setAWSAccessKeyId($value)
    {
        return $this->set('AWSAccessKeyId', $value);
    }

    /**
     * Set the value for the AWSSecretKeyId input for this DeleteSnapshot Choreo.
     *
     * @param string $value (required, string) The Secret Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_DeleteSnapshot_Inputs For method chaining.
     */
    public function setAWSSecretKeyId($value)
    {
        return $this->set('AWSSecretKeyId', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this DeleteSnapshot Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
     * @return Amazon_EC2_DeleteSnapshot_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }

    /**
     * Set the value for the SnapshotId input for this DeleteSnapshot Choreo.
     *
     * @param string $value (required, string) The id of the snapshot to delete.
     * @return Amazon_EC2_DeleteSnapshot_Inputs For method chaining.
     */
    public function setSnapshotId($value)
    {
        return $this->set('SnapshotId', $value);
    }

    /**
     * Set the value for the UserRegion input for this DeleteSnapshot Choreo.
     *
     * @param string $value (optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
     * @return Amazon_EC2_DeleteSnapshot_Inputs For method chaining.
     */
    public function setUserRegion($value)
    {
        return $this->set('UserRegion', $value);
    }
}


/**
 * Execution object for the DeleteSnapshot Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_DeleteSnapshot_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the DeleteSnapshot Choreo.
     *
     * @param Temboo_Session $session The session that owns this DeleteSnapshot execution.
     * @param Amazon_EC2_DeleteSnapshot $choreo The choreography object for this execution.
     * @param Amazon_EC2_DeleteSnapshot_Inputs|array $inputs (optional) Inputs as Amazon_EC2_DeleteSnapshot_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_DeleteSnapshot_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_EC2_DeleteSnapshot $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this DeleteSnapshot execution.
     *
     * @return Amazon_EC2_DeleteSnapshot_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this DeleteSnapshot execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_EC2_DeleteSnapshot_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_EC2_DeleteSnapshot_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the DeleteSnapshot Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_DeleteSnapshot_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the DeleteSnapshot Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_EC2_DeleteSnapshot_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this DeleteSnapshot execution.
     *
     * @return string The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Deletes a specific set of tags from a specific set of resources using the Amazon EC2 API.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_DeleteTags extends Temboo_Choreography
{
    /**
     * Deletes a specific set of tags from a specific set of resources using the Amazon EC2 API.
     *
     * @param Temboo_Session $session The session that owns this DeleteTags Choreo.
     * @return Amazon_EC2_DeleteTags New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/EC2/DeleteTags/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this DeleteTags Choreo.
     *
     * @param Amazon_EC2_DeleteTags_Inputs|array $inputs (optional) Inputs as Amazon_EC2_DeleteTags_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_DeleteTags_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_EC2_DeleteTags_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this DeleteTags Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_DeleteTags_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_EC2_DeleteTags_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the DeleteTags Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_DeleteTags_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the DeleteTags Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_DeleteTags_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this DeleteTags input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_EC2_DeleteTags_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_EC2_DeleteTags_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AWSAccessKeyId input for this DeleteTags Choreo.
     *
     * @param string $value (required, string) The Access Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_DeleteTags_Inputs For method chaining.
     */
    public function setAWSAccessKeyId($value)
    {
        return $this->set('AWSAccessKeyId', $value);
    }

    /**
     * Set the value for the AWSSecretKeyId input for this DeleteTags Choreo.
     *
     * @param string $value (required, string) The Secret Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_DeleteTags_Inputs For method chaining.
     */
    public function setAWSSecretKeyId($value)
    {
        return $this->set('AWSSecretKeyId', $value);
    }

    /**
     * Set the value for the ResourceId input for this DeleteTags Choreo.
     *
     * @param string $value (required, string) The ID of a resource to tag. This can be a comma-separated list of up to 10  Resource IDs.
     * @return Amazon_EC2_DeleteTags_Inputs For method chaining.
     */
    public function setResourceId($value)
    {
        return $this->set('ResourceId', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this DeleteTags Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
     * @return Amazon_EC2_DeleteTags_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }

    /**
     * Set the value for the TagKey input for this DeleteTags Choreo.
     *
     * @param string $value (required, string) The key for a tag.
     * @return Amazon_EC2_DeleteTags_Inputs For method chaining.
     */
    public function setTagKey($value)
    {
        return $this->set('TagKey', $value);
    }

    /**
     * Set the value for the TagValue input for this DeleteTags Choreo.
     *
     * @param string $value (optional, string) Indicates a tag should be deleted only if the value matches.To delete a tag regardless of its value, leave this blank. To delete a tag with an empty string value (""), pass the string value "null".
     * @return Amazon_EC2_DeleteTags_Inputs For method chaining.
     */
    public function setTagValue($value)
    {
        return $this->set('TagValue', $value);
    }

    /**
     * Set the value for the UserRegion input for this DeleteTags Choreo.
     *
     * @param string $value (optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
     * @return Amazon_EC2_DeleteTags_Inputs For method chaining.
     */
    public function setUserRegion($value)
    {
        return $this->set('UserRegion', $value);
    }
}


/**
 * Execution object for the DeleteTags Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_DeleteTags_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the DeleteTags Choreo.
     *
     * @param Temboo_Session $session The session that owns this DeleteTags execution.
     * @param Amazon_EC2_DeleteTags $choreo The choreography object for this execution.
     * @param Amazon_EC2_DeleteTags_Inputs|array $inputs (optional) Inputs as Amazon_EC2_DeleteTags_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_DeleteTags_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_EC2_DeleteTags $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this DeleteTags execution.
     *
     * @return Amazon_EC2_DeleteTags_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this DeleteTags execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_EC2_DeleteTags_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_EC2_DeleteTags_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the DeleteTags Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_DeleteTags_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the DeleteTags Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_EC2_DeleteTags_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this DeleteTags execution.
     *
     * @return string The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Calls the Amazon EC2 API to delete a volume using a volume id that you specify.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_DeleteVolume extends Temboo_Choreography
{
    /**
     * Calls the Amazon EC2 API to delete a volume using a volume id that you specify.
     *
     * @param Temboo_Session $session The session that owns this DeleteVolume Choreo.
     * @return Amazon_EC2_DeleteVolume New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/EC2/DeleteVolume/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this DeleteVolume Choreo.
     *
     * @param Amazon_EC2_DeleteVolume_Inputs|array $inputs (optional) Inputs as Amazon_EC2_DeleteVolume_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_DeleteVolume_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_EC2_DeleteVolume_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this DeleteVolume Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_DeleteVolume_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_EC2_DeleteVolume_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the DeleteVolume Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_DeleteVolume_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the DeleteVolume Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_DeleteVolume_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this DeleteVolume input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_EC2_DeleteVolume_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_EC2_DeleteVolume_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AWSAccessKeyId input for this DeleteVolume Choreo.
     *
     * @param string $value (required, string) The Access Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_DeleteVolume_Inputs For method chaining.
     */
    public function setAWSAccessKeyId($value)
    {
        return $this->set('AWSAccessKeyId', $value);
    }

    /**
     * Set the value for the AWSSecretKeyId input for this DeleteVolume Choreo.
     *
     * @param string $value (required, string) The Secret Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_DeleteVolume_Inputs For method chaining.
     */
    public function setAWSSecretKeyId($value)
    {
        return $this->set('AWSSecretKeyId', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this DeleteVolume Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
     * @return Amazon_EC2_DeleteVolume_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }

    /**
     * Set the value for the UserRegion input for this DeleteVolume Choreo.
     *
     * @param string $value (optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
     * @return Amazon_EC2_DeleteVolume_Inputs For method chaining.
     */
    public function setUserRegion($value)
    {
        return $this->set('UserRegion', $value);
    }

    /**
     * Set the value for the VolumeId input for this DeleteVolume Choreo.
     *
     * @param string $value (required, string) The id of the volume to delete.
     * @return Amazon_EC2_DeleteVolume_Inputs For method chaining.
     */
    public function setVolumeId($value)
    {
        return $this->set('VolumeId', $value);
    }
}


/**
 * Execution object for the DeleteVolume Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_DeleteVolume_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the DeleteVolume Choreo.
     *
     * @param Temboo_Session $session The session that owns this DeleteVolume execution.
     * @param Amazon_EC2_DeleteVolume $choreo The choreography object for this execution.
     * @param Amazon_EC2_DeleteVolume_Inputs|array $inputs (optional) Inputs as Amazon_EC2_DeleteVolume_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_DeleteVolume_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_EC2_DeleteVolume $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this DeleteVolume execution.
     *
     * @return Amazon_EC2_DeleteVolume_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this DeleteVolume execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_EC2_DeleteVolume_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_EC2_DeleteVolume_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the DeleteVolume Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_DeleteVolume_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the DeleteVolume Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_EC2_DeleteVolume_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this DeleteVolume execution.
     *
     * @return string The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Calls the Amazon EC2 API to deregister the specified AMI.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_DeregisterImage extends Temboo_Choreography
{
    /**
     * Calls the Amazon EC2 API to deregister the specified AMI.
     *
     * @param Temboo_Session $session The session that owns this DeregisterImage Choreo.
     * @return Amazon_EC2_DeregisterImage New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/EC2/DeregisterImage/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this DeregisterImage Choreo.
     *
     * @param Amazon_EC2_DeregisterImage_Inputs|array $inputs (optional) Inputs as Amazon_EC2_DeregisterImage_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_DeregisterImage_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_EC2_DeregisterImage_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this DeregisterImage Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_DeregisterImage_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_EC2_DeregisterImage_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the DeregisterImage Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_DeregisterImage_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the DeregisterImage Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_DeregisterImage_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this DeregisterImage input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_EC2_DeregisterImage_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_EC2_DeregisterImage_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AWSAccessKeyId input for this DeregisterImage Choreo.
     *
     * @param string $value (required, string) The Access Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_DeregisterImage_Inputs For method chaining.
     */
    public function setAWSAccessKeyId($value)
    {
        return $this->set('AWSAccessKeyId', $value);
    }

    /**
     * Set the value for the AWSSecretKeyId input for this DeregisterImage Choreo.
     *
     * @param string $value (required, string) The Secret Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_DeregisterImage_Inputs For method chaining.
     */
    public function setAWSSecretKeyId($value)
    {
        return $this->set('AWSSecretKeyId', $value);
    }

    /**
     * Set the value for the ImageId input for this DeregisterImage Choreo.
     *
     * @param string $value (required, string) The AMI ID.
     * @return Amazon_EC2_DeregisterImage_Inputs For method chaining.
     */
    public function setImageId($value)
    {
        return $this->set('ImageId', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this DeregisterImage Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
     * @return Amazon_EC2_DeregisterImage_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }

    /**
     * Set the value for the UserRegion input for this DeregisterImage Choreo.
     *
     * @param string $value (optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
     * @return Amazon_EC2_DeregisterImage_Inputs For method chaining.
     */
    public function setUserRegion($value)
    {
        return $this->set('UserRegion', $value);
    }
}


/**
 * Execution object for the DeregisterImage Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_DeregisterImage_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the DeregisterImage Choreo.
     *
     * @param Temboo_Session $session The session that owns this DeregisterImage execution.
     * @param Amazon_EC2_DeregisterImage $choreo The choreography object for this execution.
     * @param Amazon_EC2_DeregisterImage_Inputs|array $inputs (optional) Inputs as Amazon_EC2_DeregisterImage_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_DeregisterImage_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_EC2_DeregisterImage $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this DeregisterImage execution.
     *
     * @return Amazon_EC2_DeregisterImage_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this DeregisterImage execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_EC2_DeregisterImage_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_EC2_DeregisterImage_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the DeregisterImage Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_DeregisterImage_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the DeregisterImage Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_EC2_DeregisterImage_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this DeregisterImage execution.
     *
     * @return string The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Queries the Amazon EC2 API to describe one or more of your Elastic IP addresses.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_DescribeAddresses extends Temboo_Choreography
{
    /**
     * Queries the Amazon EC2 API to describe one or more of your Elastic IP addresses.
     *
     * @param Temboo_Session $session The session that owns this DescribeAddresses Choreo.
     * @return Amazon_EC2_DescribeAddresses New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/EC2/DescribeAddresses/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this DescribeAddresses Choreo.
     *
     * @param Amazon_EC2_DescribeAddresses_Inputs|array $inputs (optional) Inputs as Amazon_EC2_DescribeAddresses_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_DescribeAddresses_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_EC2_DescribeAddresses_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this DescribeAddresses Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_DescribeAddresses_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_EC2_DescribeAddresses_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the DescribeAddresses Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_DescribeAddresses_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the DescribeAddresses Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_DescribeAddresses_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this DescribeAddresses input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_EC2_DescribeAddresses_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_EC2_DescribeAddresses_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AWSAccessKeyId input for this DescribeAddresses Choreo.
     *
     * @param string $value (required, string) The Access Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_DescribeAddresses_Inputs For method chaining.
     */
    public function setAWSAccessKeyId($value)
    {
        return $this->set('AWSAccessKeyId', $value);
    }

    /**
     * Set the value for the AWSSecretKeyId input for this DescribeAddresses Choreo.
     *
     * @param string $value (required, string) The Secret Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_DescribeAddresses_Inputs For method chaining.
     */
    public function setAWSSecretKeyId($value)
    {
        return $this->set('AWSSecretKeyId', $value);
    }

    /**
     * Set the value for the AllocationId input for this DescribeAddresses Choreo.
     *
     * @param string $value (optional, string) One or more allocation IDs corresponding to the address or addresses to describe (VPC addresses only). This can be a comma-separated list of up to 10 Allocation Ids.
     * @return Amazon_EC2_DescribeAddresses_Inputs For method chaining.
     */
    public function setAllocationId($value)
    {
        return $this->set('AllocationId', $value);
    }

    /**
     * Set the value for the FilterName input for this DescribeAddresses Choreo.
     *
     * @param string $value (optional, string) The name of a supported filter to narrow the results with.
     * @return Amazon_EC2_DescribeAddresses_Inputs For method chaining.
     */
    public function setFilterName($value)
    {
        return $this->set('FilterName', $value);
    }

    /**
     * Set the value for the FilterValue input for this DescribeAddresses Choreo.
     *
     * @param string $value (optional, string) A value for the specified filter.
     * @return Amazon_EC2_DescribeAddresses_Inputs For method chaining.
     */
    public function setFilterValue($value)
    {
        return $this->set('FilterValue', $value);
    }

    /**
     * Set the value for the PublicIp input for this DescribeAddresses Choreo.
     *
     * @param string $value (optional, string) One or more EC2 Elastic IP addresses.  This can be a comma-separated list of up to 10 IP addresses.
     * @return Amazon_EC2_DescribeAddresses_Inputs For method chaining.
     */
    public function setPublicIp($value)
    {
        return $this->set('PublicIp', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this DescribeAddresses Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
     * @return Amazon_EC2_DescribeAddresses_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }

    /**
     * Set the value for the UserRegion input for this DescribeAddresses Choreo.
     *
     * @param string $value (optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
     * @return Amazon_EC2_DescribeAddresses_Inputs For method chaining.
     */
    public function setUserRegion($value)
    {
        return $this->set('UserRegion', $value);
    }
}


/**
 * Execution object for the DescribeAddresses Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_DescribeAddresses_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the DescribeAddresses Choreo.
     *
     * @param Temboo_Session $session The session that owns this DescribeAddresses execution.
     * @param Amazon_EC2_DescribeAddresses $choreo The choreography object for this execution.
     * @param Amazon_EC2_DescribeAddresses_Inputs|array $inputs (optional) Inputs as Amazon_EC2_DescribeAddresses_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_DescribeAddresses_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_EC2_DescribeAddresses $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this DescribeAddresses execution.
     *
     * @return Amazon_EC2_DescribeAddresses_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this DescribeAddresses execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_EC2_DescribeAddresses_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_EC2_DescribeAddresses_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the DescribeAddresses Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_DescribeAddresses_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the DescribeAddresses Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_EC2_DescribeAddresses_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this DescribeAddresses execution.
     *
     * @return string The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Queries the Amazon EC2 API to return Availability Zones that are available for your EC2 account.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_DescribeAvailabilityZones extends Temboo_Choreography
{
    /**
     * Queries the Amazon EC2 API to return Availability Zones that are available for your EC2 account.
     *
     * @param Temboo_Session $session The session that owns this DescribeAvailabilityZones Choreo.
     * @return Amazon_EC2_DescribeAvailabilityZones New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/EC2/DescribeAvailabilityZones/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this DescribeAvailabilityZones Choreo.
     *
     * @param Amazon_EC2_DescribeAvailabilityZones_Inputs|array $inputs (optional) Inputs as Amazon_EC2_DescribeAvailabilityZones_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_DescribeAvailabilityZones_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_EC2_DescribeAvailabilityZones_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this DescribeAvailabilityZones Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_DescribeAvailabilityZones_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_EC2_DescribeAvailabilityZones_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the DescribeAvailabilityZones Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_DescribeAvailabilityZones_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the DescribeAvailabilityZones Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_DescribeAvailabilityZones_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this DescribeAvailabilityZones input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_EC2_DescribeAvailabilityZones_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_EC2_DescribeAvailabilityZones_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AWSAccessKeyId input for this DescribeAvailabilityZones Choreo.
     *
     * @param string $value (required, string) The Access Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_DescribeAvailabilityZones_Inputs For method chaining.
     */
    public function setAWSAccessKeyId($value)
    {
        return $this->set('AWSAccessKeyId', $value);
    }

    /**
     * Set the value for the AWSSecretKeyId input for this DescribeAvailabilityZones Choreo.
     *
     * @param string $value (required, string) The Secret Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_DescribeAvailabilityZones_Inputs For method chaining.
     */
    public function setAWSSecretKeyId($value)
    {
        return $this->set('AWSSecretKeyId', $value);
    }

    /**
     * Set the value for the FilterName input for this DescribeAvailabilityZones Choreo.
     *
     * @param string $value (optional, string) The name of a supported filter to narrow results with.
     * @return Amazon_EC2_DescribeAvailabilityZones_Inputs For method chaining.
     */
    public function setFilterName($value)
    {
        return $this->set('FilterName', $value);
    }

    /**
     * Set the value for the FilterValue input for this DescribeAvailabilityZones Choreo.
     *
     * @param string $value (optional, string) A value for the specified filter.
     * @return Amazon_EC2_DescribeAvailabilityZones_Inputs For method chaining.
     */
    public function setFilterValue($value)
    {
        return $this->set('FilterValue', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this DescribeAvailabilityZones Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
     * @return Amazon_EC2_DescribeAvailabilityZones_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }

    /**
     * Set the value for the UserRegion input for this DescribeAvailabilityZones Choreo.
     *
     * @param string $value (optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
     * @return Amazon_EC2_DescribeAvailabilityZones_Inputs For method chaining.
     */
    public function setUserRegion($value)
    {
        return $this->set('UserRegion', $value);
    }

    /**
     * Set the value for the ZoneName input for this DescribeAvailabilityZones Choreo.
     *
     * @param string $value (optional, string) One or more Availability Zones.  This can be a comma-separated list of up to 10 instance Zones.
     * @return Amazon_EC2_DescribeAvailabilityZones_Inputs For method chaining.
     */
    public function setZoneName($value)
    {
        return $this->set('ZoneName', $value);
    }
}


/**
 * Execution object for the DescribeAvailabilityZones Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_DescribeAvailabilityZones_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the DescribeAvailabilityZones Choreo.
     *
     * @param Temboo_Session $session The session that owns this DescribeAvailabilityZones execution.
     * @param Amazon_EC2_DescribeAvailabilityZones $choreo The choreography object for this execution.
     * @param Amazon_EC2_DescribeAvailabilityZones_Inputs|array $inputs (optional) Inputs as Amazon_EC2_DescribeAvailabilityZones_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_DescribeAvailabilityZones_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_EC2_DescribeAvailabilityZones $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this DescribeAvailabilityZones execution.
     *
     * @return Amazon_EC2_DescribeAvailabilityZones_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this DescribeAvailabilityZones execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_EC2_DescribeAvailabilityZones_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_EC2_DescribeAvailabilityZones_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the DescribeAvailabilityZones Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_DescribeAvailabilityZones_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the DescribeAvailabilityZones Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_EC2_DescribeAvailabilityZones_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this DescribeAvailabilityZones execution.
     *
     * @return string The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Queries the Amazon EC2 API to retrieve information about an attribute of an AMI.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_DescribeImageAttribute extends Temboo_Choreography
{
    /**
     * Queries the Amazon EC2 API to retrieve information about an attribute of an AMI.
     *
     * @param Temboo_Session $session The session that owns this DescribeImageAttribute Choreo.
     * @return Amazon_EC2_DescribeImageAttribute New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/EC2/DescribeImageAttribute/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this DescribeImageAttribute Choreo.
     *
     * @param Amazon_EC2_DescribeImageAttribute_Inputs|array $inputs (optional) Inputs as Amazon_EC2_DescribeImageAttribute_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_DescribeImageAttribute_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_EC2_DescribeImageAttribute_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this DescribeImageAttribute Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_DescribeImageAttribute_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_EC2_DescribeImageAttribute_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the DescribeImageAttribute Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_DescribeImageAttribute_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the DescribeImageAttribute Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_DescribeImageAttribute_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this DescribeImageAttribute input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_EC2_DescribeImageAttribute_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_EC2_DescribeImageAttribute_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AWSAccessKeyId input for this DescribeImageAttribute Choreo.
     *
     * @param string $value (required, string) The Access Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_DescribeImageAttribute_Inputs For method chaining.
     */
    public function setAWSAccessKeyId($value)
    {
        return $this->set('AWSAccessKeyId', $value);
    }

    /**
     * Set the value for the AWSSecretKeyId input for this DescribeImageAttribute Choreo.
     *
     * @param string $value (required, string) The Secret Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_DescribeImageAttribute_Inputs For method chaining.
     */
    public function setAWSSecretKeyId($value)
    {
        return $this->set('AWSSecretKeyId', $value);
    }

    /**
     * Set the value for the Attribute input for this DescribeImageAttribute Choreo.
     *
     * @param string $value (required, string) The AMI attribute to get. Valid Values are: description | kernel | ramdisk | launchPermission | productCodes | blockDeviceMapping.
     * @return Amazon_EC2_DescribeImageAttribute_Inputs For method chaining.
     */
    public function setAttribute($value)
    {
        return $this->set('Attribute', $value);
    }

    /**
     * Set the value for the ImageId input for this DescribeImageAttribute Choreo.
     *
     * @param string $value (required, string) The AMI ID.
     * @return Amazon_EC2_DescribeImageAttribute_Inputs For method chaining.
     */
    public function setImageId($value)
    {
        return $this->set('ImageId', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this DescribeImageAttribute Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
     * @return Amazon_EC2_DescribeImageAttribute_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }

    /**
     * Set the value for the UserRegion input for this DescribeImageAttribute Choreo.
     *
     * @param string $value (optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
     * @return Amazon_EC2_DescribeImageAttribute_Inputs For method chaining.
     */
    public function setUserRegion($value)
    {
        return $this->set('UserRegion', $value);
    }
}


/**
 * Execution object for the DescribeImageAttribute Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_DescribeImageAttribute_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the DescribeImageAttribute Choreo.
     *
     * @param Temboo_Session $session The session that owns this DescribeImageAttribute execution.
     * @param Amazon_EC2_DescribeImageAttribute $choreo The choreography object for this execution.
     * @param Amazon_EC2_DescribeImageAttribute_Inputs|array $inputs (optional) Inputs as Amazon_EC2_DescribeImageAttribute_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_DescribeImageAttribute_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_EC2_DescribeImageAttribute $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this DescribeImageAttribute execution.
     *
     * @return Amazon_EC2_DescribeImageAttribute_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this DescribeImageAttribute execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_EC2_DescribeImageAttribute_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_EC2_DescribeImageAttribute_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the DescribeImageAttribute Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_DescribeImageAttribute_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the DescribeImageAttribute Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_EC2_DescribeImageAttribute_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this DescribeImageAttribute execution.
     *
     * @return string The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Queries the Amazon EC2 API to return information about Amazon Machine Image(s) that are available to you.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_DescribeImages extends Temboo_Choreography
{
    /**
     * Queries the Amazon EC2 API to return information about Amazon Machine Image(s) that are available to you.
     *
     * @param Temboo_Session $session The session that owns this DescribeImages Choreo.
     * @return Amazon_EC2_DescribeImages New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/EC2/DescribeImages/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this DescribeImages Choreo.
     *
     * @param Amazon_EC2_DescribeImages_Inputs|array $inputs (optional) Inputs as Amazon_EC2_DescribeImages_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_DescribeImages_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_EC2_DescribeImages_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this DescribeImages Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_DescribeImages_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_EC2_DescribeImages_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the DescribeImages Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_DescribeImages_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the DescribeImages Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_DescribeImages_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this DescribeImages input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_EC2_DescribeImages_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_EC2_DescribeImages_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AWSAccessKeyId input for this DescribeImages Choreo.
     *
     * @param string $value (required, string) The Access Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_DescribeImages_Inputs For method chaining.
     */
    public function setAWSAccessKeyId($value)
    {
        return $this->set('AWSAccessKeyId', $value);
    }

    /**
     * Set the value for the AWSSecretKeyId input for this DescribeImages Choreo.
     *
     * @param string $value (required, string) The Secret Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_DescribeImages_Inputs For method chaining.
     */
    public function setAWSSecretKeyId($value)
    {
        return $this->set('AWSSecretKeyId', $value);
    }

    /**
     * Set the value for the ExecutableBy input for this DescribeImages Choreo.
     *
     * @param string $value (optional, string) The user ID that has explicit launch permissions. The user ID can be an AWS account ID, "self", or "all" to return AMIs with public launch permissions.
     * @return Amazon_EC2_DescribeImages_Inputs For method chaining.
     */
    public function setExecutableBy($value)
    {
        return $this->set('ExecutableBy', $value);
    }

    /**
     * Set the value for the FilterName input for this DescribeImages Choreo.
     *
     * @param string $value (optional, string) The name of a supported filter to narrow results with.
     * @return Amazon_EC2_DescribeImages_Inputs For method chaining.
     */
    public function setFilterName($value)
    {
        return $this->set('FilterName', $value);
    }

    /**
     * Set the value for the FilterValue input for this DescribeImages Choreo.
     *
     * @param string $value (optional, string) A value for the specified filter.
     * @return Amazon_EC2_DescribeImages_Inputs For method chaining.
     */
    public function setFilterValue($value)
    {
        return $this->set('FilterValue', $value);
    }

    /**
     * Set the value for the ImageId input for this DescribeImages Choreo.
     *
     * @param string $value (conditional, string) The ID of the AMI that you want to return. Returns all AMIs when this parameter is not specified.
     * @return Amazon_EC2_DescribeImages_Inputs For method chaining.
     */
    public function setImageId($value)
    {
        return $this->set('ImageId', $value);
    }

    /**
     * Set the value for the Owner input for this DescribeImages Choreo.
     *
     * @param string $value (conditional, string) The IDs "amazon", "aws-marketplace", and "self" can be used to include AMIs owned by Amazon, AWS Marketplace, or AMIs owned by you, respectively.
     * @return Amazon_EC2_DescribeImages_Inputs For method chaining.
     */
    public function setOwner($value)
    {
        return $this->set('Owner', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this DescribeImages Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
     * @return Amazon_EC2_DescribeImages_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }

    /**
     * Set the value for the UserRegion input for this DescribeImages Choreo.
     *
     * @param string $value (optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
     * @return Amazon_EC2_DescribeImages_Inputs For method chaining.
     */
    public function setUserRegion($value)
    {
        return $this->set('UserRegion', $value);
    }
}


/**
 * Execution object for the DescribeImages Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_DescribeImages_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the DescribeImages Choreo.
     *
     * @param Temboo_Session $session The session that owns this DescribeImages execution.
     * @param Amazon_EC2_DescribeImages $choreo The choreography object for this execution.
     * @param Amazon_EC2_DescribeImages_Inputs|array $inputs (optional) Inputs as Amazon_EC2_DescribeImages_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_DescribeImages_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_EC2_DescribeImages $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this DescribeImages execution.
     *
     * @return Amazon_EC2_DescribeImages_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this DescribeImages execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_EC2_DescribeImages_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_EC2_DescribeImages_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the DescribeImages Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_DescribeImages_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the DescribeImages Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_EC2_DescribeImages_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this DescribeImages execution.
     *
     * @return string The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Queries the Amazon EC2 API to return information on EC2 instances associated with your AWS account.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_DescribeInstances extends Temboo_Choreography
{
    /**
     * Queries the Amazon EC2 API to return information on EC2 instances associated with your AWS account.
     *
     * @param Temboo_Session $session The session that owns this DescribeInstances Choreo.
     * @return Amazon_EC2_DescribeInstances New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/EC2/DescribeInstances/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this DescribeInstances Choreo.
     *
     * @param Amazon_EC2_DescribeInstances_Inputs|array $inputs (optional) Inputs as Amazon_EC2_DescribeInstances_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_DescribeInstances_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_EC2_DescribeInstances_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this DescribeInstances Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_DescribeInstances_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_EC2_DescribeInstances_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the DescribeInstances Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_DescribeInstances_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the DescribeInstances Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_DescribeInstances_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this DescribeInstances input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_EC2_DescribeInstances_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_EC2_DescribeInstances_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AWSAccessKeyId input for this DescribeInstances Choreo.
     *
     * @param string $value (required, string) The Access Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_DescribeInstances_Inputs For method chaining.
     */
    public function setAWSAccessKeyId($value)
    {
        return $this->set('AWSAccessKeyId', $value);
    }

    /**
     * Set the value for the AWSSecretKeyId input for this DescribeInstances Choreo.
     *
     * @param string $value (required, string) The Secret Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_DescribeInstances_Inputs For method chaining.
     */
    public function setAWSSecretKeyId($value)
    {
        return $this->set('AWSSecretKeyId', $value);
    }

    /**
     * Set the value for the FilterName input for this DescribeInstances Choreo.
     *
     * @param string $value (optional, string) The name of a supported filter to narrow results with.
     * @return Amazon_EC2_DescribeInstances_Inputs For method chaining.
     */
    public function setFilterName($value)
    {
        return $this->set('FilterName', $value);
    }

    /**
     * Set the value for the FilterValue input for this DescribeInstances Choreo.
     *
     * @param string $value (optional, string) A value for the specified filter.
     * @return Amazon_EC2_DescribeInstances_Inputs For method chaining.
     */
    public function setFilterValue($value)
    {
        return $this->set('FilterValue', $value);
    }

    /**
     * Set the value for the InstanceId input for this DescribeInstances Choreo.
     *
     * @param string $value (optional, string) The ID(s) of the instance(s) you want to monitor. This can be a comma-separated list of up to 10 instance IDs.  Returns all instances if this parameter is not specified.
     * @return Amazon_EC2_DescribeInstances_Inputs For method chaining.
     */
    public function setInstanceId($value)
    {
        return $this->set('InstanceId', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this DescribeInstances Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
     * @return Amazon_EC2_DescribeInstances_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }

    /**
     * Set the value for the UserRegion input for this DescribeInstances Choreo.
     *
     * @param string $value (optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
     * @return Amazon_EC2_DescribeInstances_Inputs For method chaining.
     */
    public function setUserRegion($value)
    {
        return $this->set('UserRegion', $value);
    }
}


/**
 * Execution object for the DescribeInstances Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_DescribeInstances_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the DescribeInstances Choreo.
     *
     * @param Temboo_Session $session The session that owns this DescribeInstances execution.
     * @param Amazon_EC2_DescribeInstances $choreo The choreography object for this execution.
     * @param Amazon_EC2_DescribeInstances_Inputs|array $inputs (optional) Inputs as Amazon_EC2_DescribeInstances_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_DescribeInstances_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_EC2_DescribeInstances $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this DescribeInstances execution.
     *
     * @return Amazon_EC2_DescribeInstances_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this DescribeInstances execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_EC2_DescribeInstances_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_EC2_DescribeInstances_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the DescribeInstances Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_DescribeInstances_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the DescribeInstances Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_EC2_DescribeInstances_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this DescribeInstances execution.
     *
     * @return string The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Queries the Amazon EC2 API to describe one or more of your key pairs.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_DescribeKeyPairs extends Temboo_Choreography
{
    /**
     * Queries the Amazon EC2 API to describe one or more of your key pairs.
     *
     * @param Temboo_Session $session The session that owns this DescribeKeyPairs Choreo.
     * @return Amazon_EC2_DescribeKeyPairs New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/EC2/DescribeKeyPairs/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this DescribeKeyPairs Choreo.
     *
     * @param Amazon_EC2_DescribeKeyPairs_Inputs|array $inputs (optional) Inputs as Amazon_EC2_DescribeKeyPairs_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_DescribeKeyPairs_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_EC2_DescribeKeyPairs_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this DescribeKeyPairs Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_DescribeKeyPairs_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_EC2_DescribeKeyPairs_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the DescribeKeyPairs Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_DescribeKeyPairs_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the DescribeKeyPairs Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_DescribeKeyPairs_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this DescribeKeyPairs input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_EC2_DescribeKeyPairs_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_EC2_DescribeKeyPairs_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AWSAccessKeyId input for this DescribeKeyPairs Choreo.
     *
     * @param string $value (required, string) The Access Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_DescribeKeyPairs_Inputs For method chaining.
     */
    public function setAWSAccessKeyId($value)
    {
        return $this->set('AWSAccessKeyId', $value);
    }

    /**
     * Set the value for the AWSSecretKeyId input for this DescribeKeyPairs Choreo.
     *
     * @param string $value (required, string) The Secret Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_DescribeKeyPairs_Inputs For method chaining.
     */
    public function setAWSSecretKeyId($value)
    {
        return $this->set('AWSSecretKeyId', $value);
    }

    /**
     * Set the value for the FilterName input for this DescribeKeyPairs Choreo.
     *
     * @param string $value (optional, string) The name of a supported filter to narrow the results with.
     * @return Amazon_EC2_DescribeKeyPairs_Inputs For method chaining.
     */
    public function setFilterName($value)
    {
        return $this->set('FilterName', $value);
    }

    /**
     * Set the value for the FilterValue input for this DescribeKeyPairs Choreo.
     *
     * @param string $value (optional, string) A value for the specified filter.
     * @return Amazon_EC2_DescribeKeyPairs_Inputs For method chaining.
     */
    public function setFilterValue($value)
    {
        return $this->set('FilterValue', $value);
    }

    /**
     * Set the value for the KeyName input for this DescribeKeyPairs Choreo.
     *
     * @param string $value (optional, string) One or more key pair names to return. This can be a comma-separated list of up to 10 key pair namess.
     * @return Amazon_EC2_DescribeKeyPairs_Inputs For method chaining.
     */
    public function setKeyName($value)
    {
        return $this->set('KeyName', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this DescribeKeyPairs Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
     * @return Amazon_EC2_DescribeKeyPairs_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }

    /**
     * Set the value for the UserRegion input for this DescribeKeyPairs Choreo.
     *
     * @param string $value (optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
     * @return Amazon_EC2_DescribeKeyPairs_Inputs For method chaining.
     */
    public function setUserRegion($value)
    {
        return $this->set('UserRegion', $value);
    }
}


/**
 * Execution object for the DescribeKeyPairs Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_DescribeKeyPairs_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the DescribeKeyPairs Choreo.
     *
     * @param Temboo_Session $session The session that owns this DescribeKeyPairs execution.
     * @param Amazon_EC2_DescribeKeyPairs $choreo The choreography object for this execution.
     * @param Amazon_EC2_DescribeKeyPairs_Inputs|array $inputs (optional) Inputs as Amazon_EC2_DescribeKeyPairs_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_DescribeKeyPairs_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_EC2_DescribeKeyPairs $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this DescribeKeyPairs execution.
     *
     * @return Amazon_EC2_DescribeKeyPairs_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this DescribeKeyPairs execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_EC2_DescribeKeyPairs_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_EC2_DescribeKeyPairs_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the DescribeKeyPairs Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_DescribeKeyPairs_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the DescribeKeyPairs Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_EC2_DescribeKeyPairs_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this DescribeKeyPairs execution.
     *
     * @return string The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Queries the Amazon EC2 API to describe one or more regions that are currently available to you.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_DescribeRegions extends Temboo_Choreography
{
    /**
     * Queries the Amazon EC2 API to describe one or more regions that are currently available to you.
     *
     * @param Temboo_Session $session The session that owns this DescribeRegions Choreo.
     * @return Amazon_EC2_DescribeRegions New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/EC2/DescribeRegions/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this DescribeRegions Choreo.
     *
     * @param Amazon_EC2_DescribeRegions_Inputs|array $inputs (optional) Inputs as Amazon_EC2_DescribeRegions_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_DescribeRegions_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_EC2_DescribeRegions_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this DescribeRegions Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_DescribeRegions_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_EC2_DescribeRegions_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the DescribeRegions Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_DescribeRegions_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the DescribeRegions Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_DescribeRegions_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this DescribeRegions input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_EC2_DescribeRegions_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_EC2_DescribeRegions_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AWSAccessKeyId input for this DescribeRegions Choreo.
     *
     * @param string $value (required, string) The Access Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_DescribeRegions_Inputs For method chaining.
     */
    public function setAWSAccessKeyId($value)
    {
        return $this->set('AWSAccessKeyId', $value);
    }

    /**
     * Set the value for the AWSSecretKeyId input for this DescribeRegions Choreo.
     *
     * @param string $value (required, string) The Secret Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_DescribeRegions_Inputs For method chaining.
     */
    public function setAWSSecretKeyId($value)
    {
        return $this->set('AWSSecretKeyId', $value);
    }

    /**
     * Set the value for the FilterName input for this DescribeRegions Choreo.
     *
     * @param string $value (optional, string) The name of a supported filter to narrow results with.
     * @return Amazon_EC2_DescribeRegions_Inputs For method chaining.
     */
    public function setFilterName($value)
    {
        return $this->set('FilterName', $value);
    }

    /**
     * Set the value for the FilterValue input for this DescribeRegions Choreo.
     *
     * @param string $value (optional, string) A value for the specified filter.
     * @return Amazon_EC2_DescribeRegions_Inputs For method chaining.
     */
    public function setFilterValue($value)
    {
        return $this->set('FilterValue', $value);
    }

    /**
     * Set the value for the RegionName input for this DescribeRegions Choreo.
     *
     * @param string $value (optional, string) One or more region names. This can be a comma-separated list of up to 10 region names.
     * @return Amazon_EC2_DescribeRegions_Inputs For method chaining.
     */
    public function setRegionName($value)
    {
        return $this->set('RegionName', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this DescribeRegions Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
     * @return Amazon_EC2_DescribeRegions_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }

    /**
     * Set the value for the UserRegion input for this DescribeRegions Choreo.
     *
     * @param string $value (optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
     * @return Amazon_EC2_DescribeRegions_Inputs For method chaining.
     */
    public function setUserRegion($value)
    {
        return $this->set('UserRegion', $value);
    }
}


/**
 * Execution object for the DescribeRegions Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_DescribeRegions_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the DescribeRegions Choreo.
     *
     * @param Temboo_Session $session The session that owns this DescribeRegions execution.
     * @param Amazon_EC2_DescribeRegions $choreo The choreography object for this execution.
     * @param Amazon_EC2_DescribeRegions_Inputs|array $inputs (optional) Inputs as Amazon_EC2_DescribeRegions_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_DescribeRegions_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_EC2_DescribeRegions $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this DescribeRegions execution.
     *
     * @return Amazon_EC2_DescribeRegions_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this DescribeRegions execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_EC2_DescribeRegions_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_EC2_DescribeRegions_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the DescribeRegions Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_DescribeRegions_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the DescribeRegions Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_EC2_DescribeRegions_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this DescribeRegions execution.
     *
     * @return string The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Queries the Amazon EC2 API to return security group information associated with your AWS Account.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_DescribeSecurityGroups extends Temboo_Choreography
{
    /**
     * Queries the Amazon EC2 API to return security group information associated with your AWS Account.
     *
     * @param Temboo_Session $session The session that owns this DescribeSecurityGroups Choreo.
     * @return Amazon_EC2_DescribeSecurityGroups New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/EC2/DescribeSecurityGroups/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this DescribeSecurityGroups Choreo.
     *
     * @param Amazon_EC2_DescribeSecurityGroups_Inputs|array $inputs (optional) Inputs as Amazon_EC2_DescribeSecurityGroups_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_DescribeSecurityGroups_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_EC2_DescribeSecurityGroups_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this DescribeSecurityGroups Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_DescribeSecurityGroups_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_EC2_DescribeSecurityGroups_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the DescribeSecurityGroups Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_DescribeSecurityGroups_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the DescribeSecurityGroups Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_DescribeSecurityGroups_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this DescribeSecurityGroups input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_EC2_DescribeSecurityGroups_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_EC2_DescribeSecurityGroups_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AWSAccessKeyId input for this DescribeSecurityGroups Choreo.
     *
     * @param string $value (required, string) The Access Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_DescribeSecurityGroups_Inputs For method chaining.
     */
    public function setAWSAccessKeyId($value)
    {
        return $this->set('AWSAccessKeyId', $value);
    }

    /**
     * Set the value for the AWSSecretKeyId input for this DescribeSecurityGroups Choreo.
     *
     * @param string $value (required, string) The Secret Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_DescribeSecurityGroups_Inputs For method chaining.
     */
    public function setAWSSecretKeyId($value)
    {
        return $this->set('AWSSecretKeyId', $value);
    }

    /**
     * Set the value for the FilterName input for this DescribeSecurityGroups Choreo.
     *
     * @param string $value (optional, string) The name of a supported filter to narrow results with.
     * @return Amazon_EC2_DescribeSecurityGroups_Inputs For method chaining.
     */
    public function setFilterName($value)
    {
        return $this->set('FilterName', $value);
    }

    /**
     * Set the value for the FilterValue input for this DescribeSecurityGroups Choreo.
     *
     * @param string $value (optional, string) A value for the specified filter.
     * @return Amazon_EC2_DescribeSecurityGroups_Inputs For method chaining.
     */
    public function setFilterValue($value)
    {
        return $this->set('FilterValue', $value);
    }

    /**
     * Set the value for the GroupId input for this DescribeSecurityGroups Choreo.
     *
     * @param string $value (optional, string) One or more security group IDs.  This can be a comma-separated list of up to 10 GroupIDs.  If no group names nor group IDs supplied, returns all groups.
     * @return Amazon_EC2_DescribeSecurityGroups_Inputs For method chaining.
     */
    public function setGroupId($value)
    {
        return $this->set('GroupId', $value);
    }

    /**
     * Set the value for the GroupName input for this DescribeSecurityGroups Choreo.
     *
     * @param string $value (optional, string) One or more security group names. This can be a comma-separated list of up to 10 group names.  If no group names nor group IDs supplied, returns all groups.
     * @return Amazon_EC2_DescribeSecurityGroups_Inputs For method chaining.
     */
    public function setGroupName($value)
    {
        return $this->set('GroupName', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this DescribeSecurityGroups Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
     * @return Amazon_EC2_DescribeSecurityGroups_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }

    /**
     * Set the value for the UserRegion input for this DescribeSecurityGroups Choreo.
     *
     * @param string $value (optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
     * @return Amazon_EC2_DescribeSecurityGroups_Inputs For method chaining.
     */
    public function setUserRegion($value)
    {
        return $this->set('UserRegion', $value);
    }
}


/**
 * Execution object for the DescribeSecurityGroups Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_DescribeSecurityGroups_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the DescribeSecurityGroups Choreo.
     *
     * @param Temboo_Session $session The session that owns this DescribeSecurityGroups execution.
     * @param Amazon_EC2_DescribeSecurityGroups $choreo The choreography object for this execution.
     * @param Amazon_EC2_DescribeSecurityGroups_Inputs|array $inputs (optional) Inputs as Amazon_EC2_DescribeSecurityGroups_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_DescribeSecurityGroups_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_EC2_DescribeSecurityGroups $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this DescribeSecurityGroups execution.
     *
     * @return Amazon_EC2_DescribeSecurityGroups_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this DescribeSecurityGroups execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_EC2_DescribeSecurityGroups_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_EC2_DescribeSecurityGroups_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the DescribeSecurityGroups Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_DescribeSecurityGroups_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the DescribeSecurityGroups Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_EC2_DescribeSecurityGroups_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this DescribeSecurityGroups execution.
     *
     * @return string The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Queries the Amazon EC2 API to return information on available Amazon EBS snapshots.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_DescribeSnapshots extends Temboo_Choreography
{
    /**
     * Queries the Amazon EC2 API to return information on available Amazon EBS snapshots.
     *
     * @param Temboo_Session $session The session that owns this DescribeSnapshots Choreo.
     * @return Amazon_EC2_DescribeSnapshots New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/EC2/DescribeSnapshots/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this DescribeSnapshots Choreo.
     *
     * @param Amazon_EC2_DescribeSnapshots_Inputs|array $inputs (optional) Inputs as Amazon_EC2_DescribeSnapshots_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_DescribeSnapshots_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_EC2_DescribeSnapshots_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this DescribeSnapshots Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_DescribeSnapshots_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_EC2_DescribeSnapshots_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the DescribeSnapshots Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_DescribeSnapshots_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the DescribeSnapshots Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_DescribeSnapshots_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this DescribeSnapshots input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_EC2_DescribeSnapshots_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_EC2_DescribeSnapshots_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AWSAccessKeyId input for this DescribeSnapshots Choreo.
     *
     * @param string $value (required, string) The Access Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_DescribeSnapshots_Inputs For method chaining.
     */
    public function setAWSAccessKeyId($value)
    {
        return $this->set('AWSAccessKeyId', $value);
    }

    /**
     * Set the value for the AWSSecretKeyId input for this DescribeSnapshots Choreo.
     *
     * @param string $value (required, string) The Secret Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_DescribeSnapshots_Inputs For method chaining.
     */
    public function setAWSSecretKeyId($value)
    {
        return $this->set('AWSSecretKeyId', $value);
    }

    /**
     * Set the value for the FilterName input for this DescribeSnapshots Choreo.
     *
     * @param string $value (optional, string) The name of a supported filter to narrow results with.
     * @return Amazon_EC2_DescribeSnapshots_Inputs For method chaining.
     */
    public function setFilterName($value)
    {
        return $this->set('FilterName', $value);
    }

    /**
     * Set the value for the FilterValue input for this DescribeSnapshots Choreo.
     *
     * @param string $value (optional, string) A value for the specified filter.
     * @return Amazon_EC2_DescribeSnapshots_Inputs For method chaining.
     */
    public function setFilterValue($value)
    {
        return $this->set('FilterValue', $value);
    }

    /**
     * Set the value for the Owner input for this DescribeSnapshots Choreo.
     *
     * @param string $value (conditional, string) Returns the snapshots owned by the specified owner. Valid values are: "self" (the default), "amazon", or an AWS Account ID.
     * @return Amazon_EC2_DescribeSnapshots_Inputs For method chaining.
     */
    public function setOwner($value)
    {
        return $this->set('Owner', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this DescribeSnapshots Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
     * @return Amazon_EC2_DescribeSnapshots_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }

    /**
     * Set the value for the RestorableBy input for this DescribeSnapshots Choreo.
     *
     * @param string $value (optional, string) AWS accounts ID that can create volumes from the snapshot.
     * @return Amazon_EC2_DescribeSnapshots_Inputs For method chaining.
     */
    public function setRestorableBy($value)
    {
        return $this->set('RestorableBy', $value);
    }

    /**
     * Set the value for the SnapshotId input for this DescribeSnapshots Choreo.
     *
     * @param string $value (optional, string) The ID of the snapshot you want to retrieve. Returns all snapshots if not specified.
     * @return Amazon_EC2_DescribeSnapshots_Inputs For method chaining.
     */
    public function setSnapshotId($value)
    {
        return $this->set('SnapshotId', $value);
    }

    /**
     * Set the value for the UserRegion input for this DescribeSnapshots Choreo.
     *
     * @param string $value (optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
     * @return Amazon_EC2_DescribeSnapshots_Inputs For method chaining.
     */
    public function setUserRegion($value)
    {
        return $this->set('UserRegion', $value);
    }
}


/**
 * Execution object for the DescribeSnapshots Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_DescribeSnapshots_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the DescribeSnapshots Choreo.
     *
     * @param Temboo_Session $session The session that owns this DescribeSnapshots execution.
     * @param Amazon_EC2_DescribeSnapshots $choreo The choreography object for this execution.
     * @param Amazon_EC2_DescribeSnapshots_Inputs|array $inputs (optional) Inputs as Amazon_EC2_DescribeSnapshots_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_DescribeSnapshots_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_EC2_DescribeSnapshots $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this DescribeSnapshots execution.
     *
     * @return Amazon_EC2_DescribeSnapshots_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this DescribeSnapshots execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_EC2_DescribeSnapshots_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_EC2_DescribeSnapshots_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the DescribeSnapshots Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_DescribeSnapshots_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the DescribeSnapshots Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_EC2_DescribeSnapshots_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this DescribeSnapshots execution.
     *
     * @return string The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Queries the Amazon EC2 API to describe one or more of the tags for your EC2 resources. 
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_DescribeTags extends Temboo_Choreography
{
    /**
     * Queries the Amazon EC2 API to describe one or more of the tags for your EC2 resources. 
     *
     * @param Temboo_Session $session The session that owns this DescribeTags Choreo.
     * @return Amazon_EC2_DescribeTags New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/EC2/DescribeTags/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this DescribeTags Choreo.
     *
     * @param Amazon_EC2_DescribeTags_Inputs|array $inputs (optional) Inputs as Amazon_EC2_DescribeTags_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_DescribeTags_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_EC2_DescribeTags_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this DescribeTags Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_DescribeTags_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_EC2_DescribeTags_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the DescribeTags Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_DescribeTags_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the DescribeTags Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_DescribeTags_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this DescribeTags input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_EC2_DescribeTags_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_EC2_DescribeTags_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AWSAccessKeyId input for this DescribeTags Choreo.
     *
     * @param string $value (required, string) The Access Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_DescribeTags_Inputs For method chaining.
     */
    public function setAWSAccessKeyId($value)
    {
        return $this->set('AWSAccessKeyId', $value);
    }

    /**
     * Set the value for the AWSSecretKeyId input for this DescribeTags Choreo.
     *
     * @param string $value (required, string) The Secret Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_DescribeTags_Inputs For method chaining.
     */
    public function setAWSSecretKeyId($value)
    {
        return $this->set('AWSSecretKeyId', $value);
    }

    /**
     * Set the value for the FilterName input for this DescribeTags Choreo.
     *
     * @param string $value (optional, string) The name of a supported filter to narrow results with.
     * @return Amazon_EC2_DescribeTags_Inputs For method chaining.
     */
    public function setFilterName($value)
    {
        return $this->set('FilterName', $value);
    }

    /**
     * Set the value for the FilterValue input for this DescribeTags Choreo.
     *
     * @param string $value (optional, string) A value for the specified filter.
     * @return Amazon_EC2_DescribeTags_Inputs For method chaining.
     */
    public function setFilterValue($value)
    {
        return $this->set('FilterValue', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this DescribeTags Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
     * @return Amazon_EC2_DescribeTags_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }

    /**
     * Set the value for the UserRegion input for this DescribeTags Choreo.
     *
     * @param string $value (optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
     * @return Amazon_EC2_DescribeTags_Inputs For method chaining.
     */
    public function setUserRegion($value)
    {
        return $this->set('UserRegion', $value);
    }
}


/**
 * Execution object for the DescribeTags Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_DescribeTags_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the DescribeTags Choreo.
     *
     * @param Temboo_Session $session The session that owns this DescribeTags execution.
     * @param Amazon_EC2_DescribeTags $choreo The choreography object for this execution.
     * @param Amazon_EC2_DescribeTags_Inputs|array $inputs (optional) Inputs as Amazon_EC2_DescribeTags_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_DescribeTags_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_EC2_DescribeTags $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this DescribeTags execution.
     *
     * @return Amazon_EC2_DescribeTags_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this DescribeTags execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_EC2_DescribeTags_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_EC2_DescribeTags_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the DescribeTags Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_DescribeTags_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the DescribeTags Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_EC2_DescribeTags_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this DescribeTags execution.
     *
     * @return string The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Queries the Amazon EC2 API to return information for one or more of your Amazon EBS volumes.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_DescribeVolumes extends Temboo_Choreography
{
    /**
     * Queries the Amazon EC2 API to return information for one or more of your Amazon EBS volumes.
     *
     * @param Temboo_Session $session The session that owns this DescribeVolumes Choreo.
     * @return Amazon_EC2_DescribeVolumes New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/EC2/DescribeVolumes/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this DescribeVolumes Choreo.
     *
     * @param Amazon_EC2_DescribeVolumes_Inputs|array $inputs (optional) Inputs as Amazon_EC2_DescribeVolumes_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_DescribeVolumes_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_EC2_DescribeVolumes_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this DescribeVolumes Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_DescribeVolumes_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_EC2_DescribeVolumes_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the DescribeVolumes Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_DescribeVolumes_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the DescribeVolumes Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_DescribeVolumes_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this DescribeVolumes input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_EC2_DescribeVolumes_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_EC2_DescribeVolumes_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AWSAccessKeyId input for this DescribeVolumes Choreo.
     *
     * @param string $value (required, string) The Access Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_DescribeVolumes_Inputs For method chaining.
     */
    public function setAWSAccessKeyId($value)
    {
        return $this->set('AWSAccessKeyId', $value);
    }

    /**
     * Set the value for the AWSSecretKeyId input for this DescribeVolumes Choreo.
     *
     * @param string $value (required, string) The Secret Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_DescribeVolumes_Inputs For method chaining.
     */
    public function setAWSSecretKeyId($value)
    {
        return $this->set('AWSSecretKeyId', $value);
    }

    /**
     * Set the value for the FilterName input for this DescribeVolumes Choreo.
     *
     * @param string $value (optional, string) The name of a supported filter to narrow results with.
     * @return Amazon_EC2_DescribeVolumes_Inputs For method chaining.
     */
    public function setFilterName($value)
    {
        return $this->set('FilterName', $value);
    }

    /**
     * Set the value for the FilterValue input for this DescribeVolumes Choreo.
     *
     * @param string $value (optional, string) A value for the specified filter.
     * @return Amazon_EC2_DescribeVolumes_Inputs For method chaining.
     */
    public function setFilterValue($value)
    {
        return $this->set('FilterValue', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this DescribeVolumes Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
     * @return Amazon_EC2_DescribeVolumes_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }

    /**
     * Set the value for the UserRegion input for this DescribeVolumes Choreo.
     *
     * @param string $value (optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
     * @return Amazon_EC2_DescribeVolumes_Inputs For method chaining.
     */
    public function setUserRegion($value)
    {
        return $this->set('UserRegion', $value);
    }

    /**
     * Set the value for the VolumeId input for this DescribeVolumes Choreo.
     *
     * @param string $value (conditional, string) The ID of the volume to return. This can be a comma-separated list of up to 10 volume IDs.
     * @return Amazon_EC2_DescribeVolumes_Inputs For method chaining.
     */
    public function setVolumeId($value)
    {
        return $this->set('VolumeId', $value);
    }
}


/**
 * Execution object for the DescribeVolumes Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_DescribeVolumes_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the DescribeVolumes Choreo.
     *
     * @param Temboo_Session $session The session that owns this DescribeVolumes execution.
     * @param Amazon_EC2_DescribeVolumes $choreo The choreography object for this execution.
     * @param Amazon_EC2_DescribeVolumes_Inputs|array $inputs (optional) Inputs as Amazon_EC2_DescribeVolumes_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_DescribeVolumes_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_EC2_DescribeVolumes $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this DescribeVolumes execution.
     *
     * @return Amazon_EC2_DescribeVolumes_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this DescribeVolumes execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_EC2_DescribeVolumes_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_EC2_DescribeVolumes_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the DescribeVolumes Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_DescribeVolumes_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the DescribeVolumes Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_EC2_DescribeVolumes_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this DescribeVolumes execution.
     *
     * @return string The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Detaches an Amazon EBS volume from an instance using the Amazon EC2 API.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_DetachVolume extends Temboo_Choreography
{
    /**
     * Detaches an Amazon EBS volume from an instance using the Amazon EC2 API.
     *
     * @param Temboo_Session $session The session that owns this DetachVolume Choreo.
     * @return Amazon_EC2_DetachVolume New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/EC2/DetachVolume/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this DetachVolume Choreo.
     *
     * @param Amazon_EC2_DetachVolume_Inputs|array $inputs (optional) Inputs as Amazon_EC2_DetachVolume_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_DetachVolume_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_EC2_DetachVolume_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this DetachVolume Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_DetachVolume_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_EC2_DetachVolume_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the DetachVolume Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_DetachVolume_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the DetachVolume Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_DetachVolume_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this DetachVolume input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_EC2_DetachVolume_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_EC2_DetachVolume_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AWSAccessKeyId input for this DetachVolume Choreo.
     *
     * @param string $value (required, string) The Access Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_DetachVolume_Inputs For method chaining.
     */
    public function setAWSAccessKeyId($value)
    {
        return $this->set('AWSAccessKeyId', $value);
    }

    /**
     * Set the value for the AWSSecretKeyId input for this DetachVolume Choreo.
     *
     * @param string $value (required, string) The Secret Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_DetachVolume_Inputs For method chaining.
     */
    public function setAWSSecretKeyId($value)
    {
        return $this->set('AWSSecretKeyId', $value);
    }

    /**
     * Set the value for the Device input for this DetachVolume Choreo.
     *
     * @param string $value (optional, string) The device name.
     * @return Amazon_EC2_DetachVolume_Inputs For method chaining.
     */
    public function setDevice($value)
    {
        return $this->set('Device', $value);
    }

    /**
     * Set the value for the Force input for this DetachVolume Choreo.
     *
     * @param bool $value (required, boolean) Forces detachment if the previous detachment attempt did not occur cleanly. Use this option only as a last resort to detach a volume from a failed instance. Defaults to false.
     * @return Amazon_EC2_DetachVolume_Inputs For method chaining.
     */
    public function setForce($value)
    {
        return $this->set('Force', $value);
    }

    /**
     * Set the value for the InstanceId input for this DetachVolume Choreo.
     *
     * @param string $value (optional, string) The ID of the instance.
     * @return Amazon_EC2_DetachVolume_Inputs For method chaining.
     */
    public function setInstanceId($value)
    {
        return $this->set('InstanceId', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this DetachVolume Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
     * @return Amazon_EC2_DetachVolume_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }

    /**
     * Set the value for the UserRegion input for this DetachVolume Choreo.
     *
     * @param string $value (optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
     * @return Amazon_EC2_DetachVolume_Inputs For method chaining.
     */
    public function setUserRegion($value)
    {
        return $this->set('UserRegion', $value);
    }

    /**
     * Set the value for the VolumeId input for this DetachVolume Choreo.
     *
     * @param string $value (required, string) The ID of the volume.
     * @return Amazon_EC2_DetachVolume_Inputs For method chaining.
     */
    public function setVolumeId($value)
    {
        return $this->set('VolumeId', $value);
    }
}


/**
 * Execution object for the DetachVolume Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_DetachVolume_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the DetachVolume Choreo.
     *
     * @param Temboo_Session $session The session that owns this DetachVolume execution.
     * @param Amazon_EC2_DetachVolume $choreo The choreography object for this execution.
     * @param Amazon_EC2_DetachVolume_Inputs|array $inputs (optional) Inputs as Amazon_EC2_DetachVolume_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_DetachVolume_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_EC2_DetachVolume $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this DetachVolume execution.
     *
     * @return Amazon_EC2_DetachVolume_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this DetachVolume execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_EC2_DetachVolume_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_EC2_DetachVolume_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the DetachVolume Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_DetachVolume_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the DetachVolume Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_EC2_DetachVolume_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this DetachVolume execution.
     *
     * @return string The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Disassociates an Elastic IP address from the instance or network interface it's associated with using the Amazon EC2 API.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_DisassociateAddress extends Temboo_Choreography
{
    /**
     * Disassociates an Elastic IP address from the instance or network interface it's associated with using the Amazon EC2 API.
     *
     * @param Temboo_Session $session The session that owns this DisassociateAddress Choreo.
     * @return Amazon_EC2_DisassociateAddress New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/EC2/DisassociateAddress/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this DisassociateAddress Choreo.
     *
     * @param Amazon_EC2_DisassociateAddress_Inputs|array $inputs (optional) Inputs as Amazon_EC2_DisassociateAddress_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_DisassociateAddress_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_EC2_DisassociateAddress_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this DisassociateAddress Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_DisassociateAddress_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_EC2_DisassociateAddress_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the DisassociateAddress Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_DisassociateAddress_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the DisassociateAddress Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_DisassociateAddress_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this DisassociateAddress input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_EC2_DisassociateAddress_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_EC2_DisassociateAddress_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AWSAccessKeyId input for this DisassociateAddress Choreo.
     *
     * @param string $value (required, string) The Access Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_DisassociateAddress_Inputs For method chaining.
     */
    public function setAWSAccessKeyId($value)
    {
        return $this->set('AWSAccessKeyId', $value);
    }

    /**
     * Set the value for the AWSSecretKeyId input for this DisassociateAddress Choreo.
     *
     * @param string $value (required, string) The Secret Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_DisassociateAddress_Inputs For method chaining.
     */
    public function setAWSSecretKeyId($value)
    {
        return $this->set('AWSSecretKeyId', $value);
    }

    /**
     * Set the value for the AssociationId input for this DisassociateAddress Choreo.
     *
     * @param string $value (conditional, string) [EC2-VPC] The association ID corresponding to the Elastic IP address.
     * @return Amazon_EC2_DisassociateAddress_Inputs For method chaining.
     */
    public function setAssociationId($value)
    {
        return $this->set('AssociationId', $value);
    }

    /**
     * Set the value for the PublicIp input for this DisassociateAddress Choreo.
     *
     * @param string $value (conditional, string) [EC2-Classic] The Elastic IP address.
     * @return Amazon_EC2_DisassociateAddress_Inputs For method chaining.
     */
    public function setPublicIp($value)
    {
        return $this->set('PublicIp', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this DisassociateAddress Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
     * @return Amazon_EC2_DisassociateAddress_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }

    /**
     * Set the value for the UserRegion input for this DisassociateAddress Choreo.
     *
     * @param string $value (optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
     * @return Amazon_EC2_DisassociateAddress_Inputs For method chaining.
     */
    public function setUserRegion($value)
    {
        return $this->set('UserRegion', $value);
    }
}


/**
 * Execution object for the DisassociateAddress Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_DisassociateAddress_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the DisassociateAddress Choreo.
     *
     * @param Temboo_Session $session The session that owns this DisassociateAddress execution.
     * @param Amazon_EC2_DisassociateAddress $choreo The choreography object for this execution.
     * @param Amazon_EC2_DisassociateAddress_Inputs|array $inputs (optional) Inputs as Amazon_EC2_DisassociateAddress_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_DisassociateAddress_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_EC2_DisassociateAddress $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this DisassociateAddress execution.
     *
     * @return Amazon_EC2_DisassociateAddress_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this DisassociateAddress execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_EC2_DisassociateAddress_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_EC2_DisassociateAddress_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the DisassociateAddress Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_DisassociateAddress_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the DisassociateAddress Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_EC2_DisassociateAddress_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this DisassociateAddress execution.
     *
     * @return string The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Calls the Amazon EC2 API to import the public key from an RSA key pair that you created with a third-party tool.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_ImportKeyPair extends Temboo_Choreography
{
    /**
     * Calls the Amazon EC2 API to import the public key from an RSA key pair that you created with a third-party tool.
     *
     * @param Temboo_Session $session The session that owns this ImportKeyPair Choreo.
     * @return Amazon_EC2_ImportKeyPair New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/EC2/ImportKeyPair/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this ImportKeyPair Choreo.
     *
     * @param Amazon_EC2_ImportKeyPair_Inputs|array $inputs (optional) Inputs as Amazon_EC2_ImportKeyPair_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_ImportKeyPair_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_EC2_ImportKeyPair_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this ImportKeyPair Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_ImportKeyPair_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_EC2_ImportKeyPair_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the ImportKeyPair Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_ImportKeyPair_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the ImportKeyPair Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_ImportKeyPair_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this ImportKeyPair input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_EC2_ImportKeyPair_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_EC2_ImportKeyPair_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AWSAccessKeyId input for this ImportKeyPair Choreo.
     *
     * @param string $value (required, string) The Access Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_ImportKeyPair_Inputs For method chaining.
     */
    public function setAWSAccessKeyId($value)
    {
        return $this->set('AWSAccessKeyId', $value);
    }

    /**
     * Set the value for the AWSSecretKeyId input for this ImportKeyPair Choreo.
     *
     * @param string $value (required, string) The Secret Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_ImportKeyPair_Inputs For method chaining.
     */
    public function setAWSSecretKeyId($value)
    {
        return $this->set('AWSSecretKeyId', $value);
    }

    /**
     * Set the value for the KeyName input for this ImportKeyPair Choreo.
     *
     * @param string $value (required, string) A unique name for the key pair.
     * @return Amazon_EC2_ImportKeyPair_Inputs For method chaining.
     */
    public function setKeyName($value)
    {
        return $this->set('KeyName', $value);
    }

    /**
     * Set the value for the PublicKeyMaterial input for this ImportKeyPair Choreo.
     *
     * @param string $value (required, string) The public key. You must Base64-encode the public key material before sending it to AWS.
     * @return Amazon_EC2_ImportKeyPair_Inputs For method chaining.
     */
    public function setPublicKeyMaterial($value)
    {
        return $this->set('PublicKeyMaterial', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this ImportKeyPair Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
     * @return Amazon_EC2_ImportKeyPair_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }

    /**
     * Set the value for the UserRegion input for this ImportKeyPair Choreo.
     *
     * @param string $value (optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
     * @return Amazon_EC2_ImportKeyPair_Inputs For method chaining.
     */
    public function setUserRegion($value)
    {
        return $this->set('UserRegion', $value);
    }
}


/**
 * Execution object for the ImportKeyPair Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_ImportKeyPair_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the ImportKeyPair Choreo.
     *
     * @param Temboo_Session $session The session that owns this ImportKeyPair execution.
     * @param Amazon_EC2_ImportKeyPair $choreo The choreography object for this execution.
     * @param Amazon_EC2_ImportKeyPair_Inputs|array $inputs (optional) Inputs as Amazon_EC2_ImportKeyPair_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_ImportKeyPair_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_EC2_ImportKeyPair $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this ImportKeyPair execution.
     *
     * @return Amazon_EC2_ImportKeyPair_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this ImportKeyPair execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_EC2_ImportKeyPair_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_EC2_ImportKeyPair_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the ImportKeyPair Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_ImportKeyPair_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the ImportKeyPair Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_EC2_ImportKeyPair_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this ImportKeyPair execution.
     *
     * @return string The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Modifies an attribute of an AMI using the Amazon EC2 API.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_ModifyImageAttribute extends Temboo_Choreography
{
    /**
     * Modifies an attribute of an AMI using the Amazon EC2 API.
     *
     * @param Temboo_Session $session The session that owns this ModifyImageAttribute Choreo.
     * @return Amazon_EC2_ModifyImageAttribute New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/EC2/ModifyImageAttribute/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this ModifyImageAttribute Choreo.
     *
     * @param Amazon_EC2_ModifyImageAttribute_Inputs|array $inputs (optional) Inputs as Amazon_EC2_ModifyImageAttribute_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_ModifyImageAttribute_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_EC2_ModifyImageAttribute_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this ModifyImageAttribute Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_ModifyImageAttribute_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_EC2_ModifyImageAttribute_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the ModifyImageAttribute Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_ModifyImageAttribute_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the ModifyImageAttribute Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_ModifyImageAttribute_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this ModifyImageAttribute input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_EC2_ModifyImageAttribute_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_EC2_ModifyImageAttribute_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AWSAccessKeyId input for this ModifyImageAttribute Choreo.
     *
     * @param string $value (required, string) The Access Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_ModifyImageAttribute_Inputs For method chaining.
     */
    public function setAWSAccessKeyId($value)
    {
        return $this->set('AWSAccessKeyId', $value);
    }

    /**
     * Set the value for the AWSSecretKeyId input for this ModifyImageAttribute Choreo.
     *
     * @param string $value (required, string) The Secret Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_ModifyImageAttribute_Inputs For method chaining.
     */
    public function setAWSSecretKeyId($value)
    {
        return $this->set('AWSSecretKeyId', $value);
    }

    /**
     * Set the value for the AddGroup input for this ModifyImageAttribute Choreo.
     *
     * @param string $value (optional, string) Adds the specified group to the image's list of launch permissions. The only valid value is "all".
     * @return Amazon_EC2_ModifyImageAttribute_Inputs For method chaining.
     */
    public function setAddGroup($value)
    {
        return $this->set('AddGroup', $value);
    }

    /**
     * Set the value for the AddUserId input for this ModifyImageAttribute Choreo.
     *
     * @param string $value (optional, string) Adds the specified AWS account ID to the AMI's list of launch permissions.
     * @return Amazon_EC2_ModifyImageAttribute_Inputs For method chaining.
     */
    public function setAddUserId($value)
    {
        return $this->set('AddUserId', $value);
    }

    /**
     * Set the value for the Description input for this ModifyImageAttribute Choreo.
     *
     * @param string $value (optional, string) Changes the AMI's description to the specified value.
     * @return Amazon_EC2_ModifyImageAttribute_Inputs For method chaining.
     */
    public function setDescription($value)
    {
        return $this->set('Description', $value);
    }

    /**
     * Set the value for the ImageId input for this ModifyImageAttribute Choreo.
     *
     * @param string $value (required, string) The AMI ID.
     * @return Amazon_EC2_ModifyImageAttribute_Inputs For method chaining.
     */
    public function setImageId($value)
    {
        return $this->set('ImageId', $value);
    }

    /**
     * Set the value for the ProductCode input for this ModifyImageAttribute Choreo.
     *
     * @param string $value (optional, string) Adds the specified product code to the specified Amazon S3-backed AMI. Once you add a product code to an AMI, it can't be removed.
     * @return Amazon_EC2_ModifyImageAttribute_Inputs For method chaining.
     */
    public function setProductCode($value)
    {
        return $this->set('ProductCode', $value);
    }

    /**
     * Set the value for the RemoveGroup input for this ModifyImageAttribute Choreo.
     *
     * @param string $value (optional, string) Removes the specified group from the image's list of launch permissions. The only valid value is "all".
     * @return Amazon_EC2_ModifyImageAttribute_Inputs For method chaining.
     */
    public function setRemoveGroup($value)
    {
        return $this->set('RemoveGroup', $value);
    }

    /**
     * Set the value for the RemoveUserId input for this ModifyImageAttribute Choreo.
     *
     * @param string $value (optional, string) Removes the specified AWS account ID from the AMI's list of launch permissions.
     * @return Amazon_EC2_ModifyImageAttribute_Inputs For method chaining.
     */
    public function setRemoveUserId($value)
    {
        return $this->set('RemoveUserId', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this ModifyImageAttribute Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
     * @return Amazon_EC2_ModifyImageAttribute_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }

    /**
     * Set the value for the UserRegion input for this ModifyImageAttribute Choreo.
     *
     * @param string $value (optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
     * @return Amazon_EC2_ModifyImageAttribute_Inputs For method chaining.
     */
    public function setUserRegion($value)
    {
        return $this->set('UserRegion', $value);
    }
}


/**
 * Execution object for the ModifyImageAttribute Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_ModifyImageAttribute_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the ModifyImageAttribute Choreo.
     *
     * @param Temboo_Session $session The session that owns this ModifyImageAttribute execution.
     * @param Amazon_EC2_ModifyImageAttribute $choreo The choreography object for this execution.
     * @param Amazon_EC2_ModifyImageAttribute_Inputs|array $inputs (optional) Inputs as Amazon_EC2_ModifyImageAttribute_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_ModifyImageAttribute_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_EC2_ModifyImageAttribute $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this ModifyImageAttribute execution.
     *
     * @return Amazon_EC2_ModifyImageAttribute_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this ModifyImageAttribute execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_EC2_ModifyImageAttribute_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_EC2_ModifyImageAttribute_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the ModifyImageAttribute Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_ModifyImageAttribute_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the ModifyImageAttribute Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_EC2_ModifyImageAttribute_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this ModifyImageAttribute execution.
     *
     * @return string The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Enables monitoring for a specified instance using the Amazon EC2 API.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_MonitorInstances extends Temboo_Choreography
{
    /**
     * Enables monitoring for a specified instance using the Amazon EC2 API.
     *
     * @param Temboo_Session $session The session that owns this MonitorInstances Choreo.
     * @return Amazon_EC2_MonitorInstances New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/EC2/MonitorInstances/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this MonitorInstances Choreo.
     *
     * @param Amazon_EC2_MonitorInstances_Inputs|array $inputs (optional) Inputs as Amazon_EC2_MonitorInstances_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_MonitorInstances_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_EC2_MonitorInstances_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this MonitorInstances Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_MonitorInstances_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_EC2_MonitorInstances_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the MonitorInstances Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_MonitorInstances_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the MonitorInstances Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_MonitorInstances_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this MonitorInstances input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_EC2_MonitorInstances_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_EC2_MonitorInstances_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AWSAccessKeyId input for this MonitorInstances Choreo.
     *
     * @param string $value (required, string) The Access Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_MonitorInstances_Inputs For method chaining.
     */
    public function setAWSAccessKeyId($value)
    {
        return $this->set('AWSAccessKeyId', $value);
    }

    /**
     * Set the value for the AWSSecretKeyId input for this MonitorInstances Choreo.
     *
     * @param string $value (required, string) The Secret Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_MonitorInstances_Inputs For method chaining.
     */
    public function setAWSSecretKeyId($value)
    {
        return $this->set('AWSSecretKeyId', $value);
    }

    /**
     * Set the value for the InstanceId input for this MonitorInstances Choreo.
     *
     * @param string $value (required, string) The ID(s) of the instance(s) you want to monitor. This can be a comma-separated list of up to 10 instance IDs.
     * @return Amazon_EC2_MonitorInstances_Inputs For method chaining.
     */
    public function setInstanceId($value)
    {
        return $this->set('InstanceId', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this MonitorInstances Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
     * @return Amazon_EC2_MonitorInstances_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }

    /**
     * Set the value for the UserRegion input for this MonitorInstances Choreo.
     *
     * @param string $value (optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
     * @return Amazon_EC2_MonitorInstances_Inputs For method chaining.
     */
    public function setUserRegion($value)
    {
        return $this->set('UserRegion', $value);
    }
}


/**
 * Execution object for the MonitorInstances Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_MonitorInstances_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the MonitorInstances Choreo.
     *
     * @param Temboo_Session $session The session that owns this MonitorInstances execution.
     * @param Amazon_EC2_MonitorInstances $choreo The choreography object for this execution.
     * @param Amazon_EC2_MonitorInstances_Inputs|array $inputs (optional) Inputs as Amazon_EC2_MonitorInstances_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_MonitorInstances_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_EC2_MonitorInstances $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this MonitorInstances execution.
     *
     * @return Amazon_EC2_MonitorInstances_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this MonitorInstances execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_EC2_MonitorInstances_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_EC2_MonitorInstances_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the MonitorInstances Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_MonitorInstances_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the MonitorInstances Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_EC2_MonitorInstances_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this MonitorInstances execution.
     *
     * @return string The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Calls the Amazon EC2 API to reboot an instance by specifying the instance ID.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_RebootInstances extends Temboo_Choreography
{
    /**
     * Calls the Amazon EC2 API to reboot an instance by specifying the instance ID.
     *
     * @param Temboo_Session $session The session that owns this RebootInstances Choreo.
     * @return Amazon_EC2_RebootInstances New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/EC2/RebootInstances/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this RebootInstances Choreo.
     *
     * @param Amazon_EC2_RebootInstances_Inputs|array $inputs (optional) Inputs as Amazon_EC2_RebootInstances_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_RebootInstances_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_EC2_RebootInstances_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this RebootInstances Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_RebootInstances_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_EC2_RebootInstances_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the RebootInstances Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_RebootInstances_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the RebootInstances Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_RebootInstances_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this RebootInstances input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_EC2_RebootInstances_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_EC2_RebootInstances_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AWSAccessKeyId input for this RebootInstances Choreo.
     *
     * @param string $value (required, string) The Access Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_RebootInstances_Inputs For method chaining.
     */
    public function setAWSAccessKeyId($value)
    {
        return $this->set('AWSAccessKeyId', $value);
    }

    /**
     * Set the value for the AWSSecretKeyId input for this RebootInstances Choreo.
     *
     * @param string $value (required, string) The Secret Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_RebootInstances_Inputs For method chaining.
     */
    public function setAWSSecretKeyId($value)
    {
        return $this->set('AWSSecretKeyId', $value);
    }

    /**
     * Set the value for the InstanceId input for this RebootInstances Choreo.
     *
     * @param string $value (required, string) The ID of the instance to reboot. This can be a comma-separated list of up to 10 instance IDs.
     * @return Amazon_EC2_RebootInstances_Inputs For method chaining.
     */
    public function setInstanceId($value)
    {
        return $this->set('InstanceId', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this RebootInstances Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
     * @return Amazon_EC2_RebootInstances_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }

    /**
     * Set the value for the UserRegion input for this RebootInstances Choreo.
     *
     * @param string $value (optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
     * @return Amazon_EC2_RebootInstances_Inputs For method chaining.
     */
    public function setUserRegion($value)
    {
        return $this->set('UserRegion', $value);
    }
}


/**
 * Execution object for the RebootInstances Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_RebootInstances_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the RebootInstances Choreo.
     *
     * @param Temboo_Session $session The session that owns this RebootInstances execution.
     * @param Amazon_EC2_RebootInstances $choreo The choreography object for this execution.
     * @param Amazon_EC2_RebootInstances_Inputs|array $inputs (optional) Inputs as Amazon_EC2_RebootInstances_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_RebootInstances_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_EC2_RebootInstances $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this RebootInstances execution.
     *
     * @return Amazon_EC2_RebootInstances_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this RebootInstances execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_EC2_RebootInstances_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_EC2_RebootInstances_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the RebootInstances Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_RebootInstances_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the RebootInstances Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_EC2_RebootInstances_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this RebootInstances execution.
     *
     * @return string The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Registers a new AMI with Amazon EC2 using the Amazon EC2 API.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_RegisterImage extends Temboo_Choreography
{
    /**
     * Registers a new AMI with Amazon EC2 using the Amazon EC2 API.
     *
     * @param Temboo_Session $session The session that owns this RegisterImage Choreo.
     * @return Amazon_EC2_RegisterImage New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/EC2/RegisterImage/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this RegisterImage Choreo.
     *
     * @param Amazon_EC2_RegisterImage_Inputs|array $inputs (optional) Inputs as Amazon_EC2_RegisterImage_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_RegisterImage_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_EC2_RegisterImage_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this RegisterImage Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_RegisterImage_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_EC2_RegisterImage_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the RegisterImage Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_RegisterImage_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the RegisterImage Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_RegisterImage_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this RegisterImage input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_EC2_RegisterImage_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_EC2_RegisterImage_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AWSAccessKeyId input for this RegisterImage Choreo.
     *
     * @param string $value (required, string) The Access Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_RegisterImage_Inputs For method chaining.
     */
    public function setAWSAccessKeyId($value)
    {
        return $this->set('AWSAccessKeyId', $value);
    }

    /**
     * Set the value for the AWSSecretKeyId input for this RegisterImage Choreo.
     *
     * @param string $value (required, string) The Secret Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_RegisterImage_Inputs For method chaining.
     */
    public function setAWSSecretKeyId($value)
    {
        return $this->set('AWSSecretKeyId', $value);
    }

    /**
     * Set the value for the Architecture input for this RegisterImage Choreo.
     *
     * @param string $value (optional, string) The architecture of the image. Valid values are: i386 or x86_64. Defaults to i386.
     * @return Amazon_EC2_RegisterImage_Inputs For method chaining.
     */
    public function setArchitecture($value)
    {
        return $this->set('Architecture', $value);
    }

    /**
     * Set the value for the DeleteOnTermination input for this RegisterImage Choreo.
     *
     * @param bool $value (optional, boolean) Whether the Amazon EBS volume is deleted on instance termination. Defaults to true.
     * @return Amazon_EC2_RegisterImage_Inputs For method chaining.
     */
    public function setDeleteOnTermination($value)
    {
        return $this->set('DeleteOnTermination', $value);
    }

    /**
     * Set the value for the Description input for this RegisterImage Choreo.
     *
     * @param string $value (optional, string) The description of the AMI.
     * @return Amazon_EC2_RegisterImage_Inputs For method chaining.
     */
    public function setDescription($value)
    {
        return $this->set('Description', $value);
    }

    /**
     * Set the value for the DeviceName input for this RegisterImage Choreo.
     *
     * @param string $value (conditional, string) If registering an Amazon EBS-backed AMI from a snapshot, specify this input with the root device name (e.g., /dev/sda1, or xvda), and SnapshotId.
     * @return Amazon_EC2_RegisterImage_Inputs For method chaining.
     */
    public function setDeviceName($value)
    {
        return $this->set('DeviceName', $value);
    }

    /**
     * Set the value for the ImageLocation input for this RegisterImage Choreo.
     *
     * @param string $value (conditional, string) Full path to your AMI manifest in Amazon S3 storage. Required if registering an Amazon-S3 backed AMI.
     * @return Amazon_EC2_RegisterImage_Inputs For method chaining.
     */
    public function setImageLocation($value)
    {
        return $this->set('ImageLocation', $value);
    }

    /**
     * Set the value for the Iops input for this RegisterImage Choreo.
     *
     * @param int $value (conditional, integer) The number of I/O operations per second (IOPS) that the volume supports. A valid range is: 100 to 2000.
     * @return Amazon_EC2_RegisterImage_Inputs For method chaining.
     */
    public function setIops($value)
    {
        return $this->set('Iops', $value);
    }

    /**
     * Set the value for the KernelId input for this RegisterImage Choreo.
     *
     * @param string $value (optional, string) The ID of the kernel to select.
     * @return Amazon_EC2_RegisterImage_Inputs For method chaining.
     */
    public function setKernelId($value)
    {
        return $this->set('KernelId', $value);
    }

    /**
     * Set the value for the Name input for this RegisterImage Choreo.
     *
     * @param string $value (required, string) A name for your AMI.
     * @return Amazon_EC2_RegisterImage_Inputs For method chaining.
     */
    public function setName($value)
    {
        return $this->set('Name', $value);
    }

    /**
     * Set the value for the NoDevice input for this RegisterImage Choreo.
     *
     * @param bool $value (optional, boolean) Specifies that no device should be mapped. Defaults to 1 (true).
     * @return Amazon_EC2_RegisterImage_Inputs For method chaining.
     */
    public function setNoDevice($value)
    {
        return $this->set('NoDevice', $value);
    }

    /**
     * Set the value for the RamdiskId input for this RegisterImage Choreo.
     *
     * @param string $value (optional, string) The ID of the RAM disk to select.
     * @return Amazon_EC2_RegisterImage_Inputs For method chaining.
     */
    public function setRamdiskId($value)
    {
        return $this->set('RamdiskId', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this RegisterImage Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
     * @return Amazon_EC2_RegisterImage_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }

    /**
     * Set the value for the RootDeviceName input for this RegisterImage Choreo.
     *
     * @param string $value (conditional, string) The root device name (e.g., /dev/sda1, or xvda). Required if registering an Amazon EBS-backed AMI.
     * @return Amazon_EC2_RegisterImage_Inputs For method chaining.
     */
    public function setRootDeviceName($value)
    {
        return $this->set('RootDeviceName', $value);
    }

    /**
     * Set the value for the SnapshotId input for this RegisterImage Choreo.
     *
     * @param string $value (conditional, string) If registering an Amazon EBS-backed AMI from a snapshot, you must at least specify this input with the snapshot ID, and DeviceName with the root device name.
     * @return Amazon_EC2_RegisterImage_Inputs For method chaining.
     */
    public function setSnapshotId($value)
    {
        return $this->set('SnapshotId', $value);
    }

    /**
     * Set the value for the UserRegion input for this RegisterImage Choreo.
     *
     * @param string $value (optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
     * @return Amazon_EC2_RegisterImage_Inputs For method chaining.
     */
    public function setUserRegion($value)
    {
        return $this->set('UserRegion', $value);
    }

    /**
     * Set the value for the VirtualName input for this RegisterImage Choreo.
     *
     * @param string $value (optional, string) The virtual device name.
     * @return Amazon_EC2_RegisterImage_Inputs For method chaining.
     */
    public function setVirtualName($value)
    {
        return $this->set('VirtualName', $value);
    }

    /**
     * Set the value for the VolumeSize input for this RegisterImage Choreo.
     *
     * @param int $value (conditional, integer) The size of the volume, in GiBs. Required if you are not creating a volume from a snapshot.
     * @return Amazon_EC2_RegisterImage_Inputs For method chaining.
     */
    public function setVolumeSize($value)
    {
        return $this->set('VolumeSize', $value);
    }

    /**
     * Set the value for the VolumeType input for this RegisterImage Choreo.
     *
     * @param string $value (optional, string) The volume type. Valid values are: standard and io.
     * @return Amazon_EC2_RegisterImage_Inputs For method chaining.
     */
    public function setVolumeType($value)
    {
        return $this->set('VolumeType', $value);
    }
}


/**
 * Execution object for the RegisterImage Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_RegisterImage_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the RegisterImage Choreo.
     *
     * @param Temboo_Session $session The session that owns this RegisterImage execution.
     * @param Amazon_EC2_RegisterImage $choreo The choreography object for this execution.
     * @param Amazon_EC2_RegisterImage_Inputs|array $inputs (optional) Inputs as Amazon_EC2_RegisterImage_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_RegisterImage_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_EC2_RegisterImage $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this RegisterImage execution.
     *
     * @return Amazon_EC2_RegisterImage_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this RegisterImage execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_EC2_RegisterImage_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_EC2_RegisterImage_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the RegisterImage Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_RegisterImage_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the RegisterImage Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_EC2_RegisterImage_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this RegisterImage execution.
     *
     * @return string The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Calls the Amazon EC2 API to release an Elastic IP address allocated to your account.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_ReleaseAddress extends Temboo_Choreography
{
    /**
     * Calls the Amazon EC2 API to release an Elastic IP address allocated to your account.
     *
     * @param Temboo_Session $session The session that owns this ReleaseAddress Choreo.
     * @return Amazon_EC2_ReleaseAddress New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/EC2/ReleaseAddress/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this ReleaseAddress Choreo.
     *
     * @param Amazon_EC2_ReleaseAddress_Inputs|array $inputs (optional) Inputs as Amazon_EC2_ReleaseAddress_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_ReleaseAddress_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_EC2_ReleaseAddress_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this ReleaseAddress Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_ReleaseAddress_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_EC2_ReleaseAddress_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the ReleaseAddress Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_ReleaseAddress_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the ReleaseAddress Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_ReleaseAddress_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this ReleaseAddress input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_EC2_ReleaseAddress_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_EC2_ReleaseAddress_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AWSAccessKeyId input for this ReleaseAddress Choreo.
     *
     * @param string $value (required, string) The Access Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_ReleaseAddress_Inputs For method chaining.
     */
    public function setAWSAccessKeyId($value)
    {
        return $this->set('AWSAccessKeyId', $value);
    }

    /**
     * Set the value for the AWSSecretKeyId input for this ReleaseAddress Choreo.
     *
     * @param string $value (required, string) The Secret Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_ReleaseAddress_Inputs For method chaining.
     */
    public function setAWSSecretKeyId($value)
    {
        return $this->set('AWSSecretKeyId', $value);
    }

    /**
     * Set the value for the AllocationId input for this ReleaseAddress Choreo.
     *
     * @param string $value (conditional, string) [EC2-VPC] The allocation ID that AWS provided when you allocated the address for use with a VPC.
     * @return Amazon_EC2_ReleaseAddress_Inputs For method chaining.
     */
    public function setAllocationId($value)
    {
        return $this->set('AllocationId', $value);
    }

    /**
     * Set the value for the PublicIp input for this ReleaseAddress Choreo.
     *
     * @param string $value (conditional, string) [EC2-Classic] The Elastic IP address.
     * @return Amazon_EC2_ReleaseAddress_Inputs For method chaining.
     */
    public function setPublicIp($value)
    {
        return $this->set('PublicIp', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this ReleaseAddress Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
     * @return Amazon_EC2_ReleaseAddress_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }

    /**
     * Set the value for the UserRegion input for this ReleaseAddress Choreo.
     *
     * @param string $value (optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
     * @return Amazon_EC2_ReleaseAddress_Inputs For method chaining.
     */
    public function setUserRegion($value)
    {
        return $this->set('UserRegion', $value);
    }
}


/**
 * Execution object for the ReleaseAddress Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_ReleaseAddress_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the ReleaseAddress Choreo.
     *
     * @param Temboo_Session $session The session that owns this ReleaseAddress execution.
     * @param Amazon_EC2_ReleaseAddress $choreo The choreography object for this execution.
     * @param Amazon_EC2_ReleaseAddress_Inputs|array $inputs (optional) Inputs as Amazon_EC2_ReleaseAddress_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_ReleaseAddress_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_EC2_ReleaseAddress $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this ReleaseAddress execution.
     *
     * @return Amazon_EC2_ReleaseAddress_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this ReleaseAddress execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_EC2_ReleaseAddress_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_EC2_ReleaseAddress_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the ReleaseAddress Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_ReleaseAddress_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the ReleaseAddress Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_EC2_ReleaseAddress_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this ReleaseAddress execution.
     *
     * @return string The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Removes one or more ingress rules from a security group using the Amazon EC2 API.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_RevokeSecurityGroupIngress extends Temboo_Choreography
{
    /**
     * Removes one or more ingress rules from a security group using the Amazon EC2 API.
     *
     * @param Temboo_Session $session The session that owns this RevokeSecurityGroupIngress Choreo.
     * @return Amazon_EC2_RevokeSecurityGroupIngress New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/EC2/RevokeSecurityGroupIngress/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this RevokeSecurityGroupIngress Choreo.
     *
     * @param Amazon_EC2_RevokeSecurityGroupIngress_Inputs|array $inputs (optional) Inputs as Amazon_EC2_RevokeSecurityGroupIngress_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_RevokeSecurityGroupIngress_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_EC2_RevokeSecurityGroupIngress_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this RevokeSecurityGroupIngress Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_RevokeSecurityGroupIngress_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_EC2_RevokeSecurityGroupIngress_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the RevokeSecurityGroupIngress Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_RevokeSecurityGroupIngress_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the RevokeSecurityGroupIngress Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_RevokeSecurityGroupIngress_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this RevokeSecurityGroupIngress input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_EC2_RevokeSecurityGroupIngress_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_EC2_RevokeSecurityGroupIngress_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AWSAccessKeyId input for this RevokeSecurityGroupIngress Choreo.
     *
     * @param string $value (required, string) The Access Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_RevokeSecurityGroupIngress_Inputs For method chaining.
     */
    public function setAWSAccessKeyId($value)
    {
        return $this->set('AWSAccessKeyId', $value);
    }

    /**
     * Set the value for the AWSSecretKeyId input for this RevokeSecurityGroupIngress Choreo.
     *
     * @param string $value (required, string) The Secret Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_RevokeSecurityGroupIngress_Inputs For method chaining.
     */
    public function setAWSSecretKeyId($value)
    {
        return $this->set('AWSSecretKeyId', $value);
    }

    /**
     * Set the value for the GroupId input for this RevokeSecurityGroupIngress Choreo.
     *
     * @param string $value (conditional, string) The ID of the security group to modify. Can be used instead of GroupName.
     * @return Amazon_EC2_RevokeSecurityGroupIngress_Inputs For method chaining.
     */
    public function setGroupId($value)
    {
        return $this->set('GroupId', $value);
    }

    /**
     * Set the value for the GroupName input for this RevokeSecurityGroupIngress Choreo.
     *
     * @param string $value (conditional, string) The name of the security group to modify. Can be used instead of GroupId.
     * @return Amazon_EC2_RevokeSecurityGroupIngress_Inputs For method chaining.
     */
    public function setGroupName($value)
    {
        return $this->set('GroupName', $value);
    }

    /**
     * Set the value for the IpPermissionsCidrIp input for this RevokeSecurityGroupIngress Choreo.
     *
     * @param string $value (optional, string) The CIDR range. Cannot be used when specifying a source security group.
     * @return Amazon_EC2_RevokeSecurityGroupIngress_Inputs For method chaining.
     */
    public function setIpPermissionsCidrIp($value)
    {
        return $this->set('IpPermissionsCidrIp', $value);
    }

    /**
     * Set the value for the IpPermissionsFromPort input for this RevokeSecurityGroupIngress Choreo.
     *
     * @param int $value (optional, integer) The start of port range for the TCP and UDP protocols, or an ICMP type number. For the ICMP type number, you can use -1 to specify all ICMP types.
     * @return Amazon_EC2_RevokeSecurityGroupIngress_Inputs For method chaining.
     */
    public function setIpPermissionsFromPort($value)
    {
        return $this->set('IpPermissionsFromPort', $value);
    }

    /**
     * Set the value for the IpPermissionsGroupId input for this RevokeSecurityGroupIngress Choreo.
     *
     * @param string $value (optional, string) The ID of the source security group. Cannot be used when specifying a CIDR IP address.
     * @return Amazon_EC2_RevokeSecurityGroupIngress_Inputs For method chaining.
     */
    public function setIpPermissionsGroupId($value)
    {
        return $this->set('IpPermissionsGroupId', $value);
    }

    /**
     * Set the value for the IpPermissionsGroupName input for this RevokeSecurityGroupIngress Choreo.
     *
     * @param string $value (optional, string) The name of the source security group. Cannot be used when specifying a CIDR IP address.
     * @return Amazon_EC2_RevokeSecurityGroupIngress_Inputs For method chaining.
     */
    public function setIpPermissionsGroupName($value)
    {
        return $this->set('IpPermissionsGroupName', $value);
    }

    /**
     * Set the value for the IpPermissionsIpProtocol input for this RevokeSecurityGroupIngress Choreo.
     *
     * @param string $value (required, string) The IP protocol name or number. Valid values for EC2-Classic: tcp, udp, icmp (or 6, 17, 1). Valid values for EC2-VPC: tcp, udp, icmp, any valid protocol number (0-254), or -1 (to specify all).
     * @return Amazon_EC2_RevokeSecurityGroupIngress_Inputs For method chaining.
     */
    public function setIpPermissionsIpProtocol($value)
    {
        return $this->set('IpPermissionsIpProtocol', $value);
    }

    /**
     * Set the value for the IpPermissionsToPort input for this RevokeSecurityGroupIngress Choreo.
     *
     * @param int $value (optional, integer) The end of port range for the TCP and UDP protocols, or an ICMP code number. For the ICMP code number, you can use -1 to specify all ICMP codes for the given ICMP type.
     * @return Amazon_EC2_RevokeSecurityGroupIngress_Inputs For method chaining.
     */
    public function setIpPermissionsToPort($value)
    {
        return $this->set('IpPermissionsToPort', $value);
    }

    /**
     * Set the value for the IpPermissionsUserId input for this RevokeSecurityGroupIngress Choreo.
     *
     * @param string $value (optional, string) The AWS account ID that owns the source security group. Cannot be used when specifying a CIDR IP address.
     * @return Amazon_EC2_RevokeSecurityGroupIngress_Inputs For method chaining.
     */
    public function setIpPermissionsUserId($value)
    {
        return $this->set('IpPermissionsUserId', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this RevokeSecurityGroupIngress Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
     * @return Amazon_EC2_RevokeSecurityGroupIngress_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }

    /**
     * Set the value for the UserRegion input for this RevokeSecurityGroupIngress Choreo.
     *
     * @param string $value (optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
     * @return Amazon_EC2_RevokeSecurityGroupIngress_Inputs For method chaining.
     */
    public function setUserRegion($value)
    {
        return $this->set('UserRegion', $value);
    }
}


/**
 * Execution object for the RevokeSecurityGroupIngress Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_RevokeSecurityGroupIngress_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the RevokeSecurityGroupIngress Choreo.
     *
     * @param Temboo_Session $session The session that owns this RevokeSecurityGroupIngress execution.
     * @param Amazon_EC2_RevokeSecurityGroupIngress $choreo The choreography object for this execution.
     * @param Amazon_EC2_RevokeSecurityGroupIngress_Inputs|array $inputs (optional) Inputs as Amazon_EC2_RevokeSecurityGroupIngress_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_RevokeSecurityGroupIngress_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_EC2_RevokeSecurityGroupIngress $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this RevokeSecurityGroupIngress execution.
     *
     * @return Amazon_EC2_RevokeSecurityGroupIngress_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this RevokeSecurityGroupIngress execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_EC2_RevokeSecurityGroupIngress_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_EC2_RevokeSecurityGroupIngress_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the RevokeSecurityGroupIngress Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_RevokeSecurityGroupIngress_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the RevokeSecurityGroupIngress Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_EC2_RevokeSecurityGroupIngress_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this RevokeSecurityGroupIngress execution.
     *
     * @return string The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Calls the Amazon EC2 API to launch the specified number of instances of an AMI for which you have permissions.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_RunInstances extends Temboo_Choreography
{
    /**
     * Calls the Amazon EC2 API to launch the specified number of instances of an AMI for which you have permissions.
     *
     * @param Temboo_Session $session The session that owns this RunInstances Choreo.
     * @return Amazon_EC2_RunInstances New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/EC2/RunInstances/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this RunInstances Choreo.
     *
     * @param Amazon_EC2_RunInstances_Inputs|array $inputs (optional) Inputs as Amazon_EC2_RunInstances_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_RunInstances_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_EC2_RunInstances_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this RunInstances Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_RunInstances_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_EC2_RunInstances_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the RunInstances Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_RunInstances_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the RunInstances Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_RunInstances_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this RunInstances input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_EC2_RunInstances_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_EC2_RunInstances_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AWSAccessKeyId input for this RunInstances Choreo.
     *
     * @param string $value (required, string) The Access Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_RunInstances_Inputs For method chaining.
     */
    public function setAWSAccessKeyId($value)
    {
        return $this->set('AWSAccessKeyId', $value);
    }

    /**
     * Set the value for the AWSSecretKeyId input for this RunInstances Choreo.
     *
     * @param string $value (required, string) The Secret Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_RunInstances_Inputs For method chaining.
     */
    public function setAWSSecretKeyId($value)
    {
        return $this->set('AWSSecretKeyId', $value);
    }

    /**
     * Set the value for the DeleteOnTermination input for this RunInstances Choreo.
     *
     * @param bool $value (optional, boolean) Sets whether the volume is deleted on instance termination. Defaults to "true". This is a Block Device Mapping parameter.
     * @return Amazon_EC2_RunInstances_Inputs For method chaining.
     */
    public function setDeleteOnTermination($value)
    {
        return $this->set('DeleteOnTermination', $value);
    }

    /**
     * Set the value for the DeviceName input for this RunInstances Choreo.
     *
     * @param string $value (optional, string) The device name exposed to the instance (i.e. /dev/sdh or xvdh). This is a Block Device Mapping parameter.
     * @return Amazon_EC2_RunInstances_Inputs For method chaining.
     */
    public function setDeviceName($value)
    {
        return $this->set('DeviceName', $value);
    }

    /**
     * Set the value for the ImageId input for this RunInstances Choreo.
     *
     * @param string $value (required, string) The ID of the AMI.
     * @return Amazon_EC2_RunInstances_Inputs For method chaining.
     */
    public function setImageId($value)
    {
        return $this->set('ImageId', $value);
    }

    /**
     * Set the value for the InstanceType input for this RunInstances Choreo.
     *
     * @param string $value (optional, string) The instance type (i.e. t1.micro, m1.small, m1.medium, m1.large, m1.xlarge). Default is m1.small.
     * @return Amazon_EC2_RunInstances_Inputs For method chaining.
     */
    public function setInstanceType($value)
    {
        return $this->set('InstanceType', $value);
    }

    /**
     * Set the value for the Iops input for this RunInstances Choreo.
     *
     * @param int $value (optional, integer) The number of I/O operations per second (IOPS) that the volume supports. Valid range is 100 to 2000. This is a Block Device Mapping parameter.
     * @return Amazon_EC2_RunInstances_Inputs For method chaining.
     */
    public function setIops($value)
    {
        return $this->set('Iops', $value);
    }

    /**
     * Set the value for the KernelId input for this RunInstances Choreo.
     *
     * @param string $value (optional, string) The ID of the kernel with which to launch the instance.
     * @return Amazon_EC2_RunInstances_Inputs For method chaining.
     */
    public function setKernelId($value)
    {
        return $this->set('KernelId', $value);
    }

    /**
     * Set the value for the KeyName input for this RunInstances Choreo.
     *
     * @param string $value (optional, string) The name of the key pair to use.
     * @return Amazon_EC2_RunInstances_Inputs For method chaining.
     */
    public function setKeyName($value)
    {
        return $this->set('KeyName', $value);
    }

    /**
     * Set the value for the MaxCount input for this RunInstances Choreo.
     *
     * @param int $value (required, integer) The maximum number of instances to launch. If the value is more than Amazon EC2 can launch, the largest possible number above MinCount will be launched instead.
     * @return Amazon_EC2_RunInstances_Inputs For method chaining.
     */
    public function setMaxCount($value)
    {
        return $this->set('MaxCount', $value);
    }

    /**
     * Set the value for the MinCount input for this RunInstances Choreo.
     *
     * @param int $value (required, integer) The minimum number of instances to launch. If the value is more than Amazon EC2 can launch, no instances are launched at all.
     * @return Amazon_EC2_RunInstances_Inputs For method chaining.
     */
    public function setMinCount($value)
    {
        return $this->set('MinCount', $value);
    }

    /**
     * Set the value for the MonitoringEnabled input for this RunInstances Choreo.
     *
     * @param bool $value (optional, boolean) Enables monitoring for the instance. Defaults to false.
     * @return Amazon_EC2_RunInstances_Inputs For method chaining.
     */
    public function setMonitoringEnabled($value)
    {
        return $this->set('MonitoringEnabled', $value);
    }

    /**
     * Set the value for the NoDevice input for this RunInstances Choreo.
     *
     * @param bool $value (optional, boolean) Suppresses a device mapping. This is a Block Device Mapping parameter.
     * @return Amazon_EC2_RunInstances_Inputs For method chaining.
     */
    public function setNoDevice($value)
    {
        return $this->set('NoDevice', $value);
    }

    /**
     * Set the value for the PlacementAvailabilityZone input for this RunInstances Choreo.
     *
     * @param string $value (optional, string) The Availability Zone to launch the instance into.
     * @return Amazon_EC2_RunInstances_Inputs For method chaining.
     */
    public function setPlacementAvailabilityZone($value)
    {
        return $this->set('PlacementAvailabilityZone', $value);
    }

    /**
     * Set the value for the PlacementGroupName input for this RunInstances Choreo.
     *
     * @param string $value (optional, string) The name of an existing placement group you want to launch the instance into (for cluster instances).
     * @return Amazon_EC2_RunInstances_Inputs For method chaining.
     */
    public function setPlacementGroupName($value)
    {
        return $this->set('PlacementGroupName', $value);
    }

    /**
     * Set the value for the PlacementTenancy input for this RunInstances Choreo.
     *
     * @param string $value (optional, string) The tenancy of the instance. When set to "dedicated", the instance will run on single-tenant hardware and can only be launched into a VPC.
     * @return Amazon_EC2_RunInstances_Inputs For method chaining.
     */
    public function setPlacementTenancy($value)
    {
        return $this->set('PlacementTenancy', $value);
    }

    /**
     * Set the value for the RamdiskId input for this RunInstances Choreo.
     *
     * @param string $value (optional, string) The ID of the RAM disk.
     * @return Amazon_EC2_RunInstances_Inputs For method chaining.
     */
    public function setRamdiskId($value)
    {
        return $this->set('RamdiskId', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this RunInstances Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
     * @return Amazon_EC2_RunInstances_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }

    /**
     * Set the value for the SecurityGroup input for this RunInstances Choreo.
     *
     * @param string $value (optional, string) One or more security group names. This can be a comma-separated list of up to 10 security group names.
     * @return Amazon_EC2_RunInstances_Inputs For method chaining.
     */
    public function setSecurityGroup($value)
    {
        return $this->set('SecurityGroup', $value);
    }

    /**
     * Set the value for the SecurityGroupId input for this RunInstances Choreo.
     *
     * @param string $value (optional, string) One or more security group IDs. This can be a comma-separated list of up to 10 security group ids.
     * @return Amazon_EC2_RunInstances_Inputs For method chaining.
     */
    public function setSecurityGroupId($value)
    {
        return $this->set('SecurityGroupId', $value);
    }

    /**
     * Set the value for the ShutdownBehavior input for this RunInstances Choreo.
     *
     * @param string $value (optional, string) Whether the instance stops or terminates on instance-initiated shutdown. Valid values are: stop and terminate.
     * @return Amazon_EC2_RunInstances_Inputs For method chaining.
     */
    public function setShutdownBehavior($value)
    {
        return $this->set('ShutdownBehavior', $value);
    }

    /**
     * Set the value for the SnapshotId input for this RunInstances Choreo.
     *
     * @param string $value (optional, string) The ID of the snapshot. This is a Block Device Mapping parameter.
     * @return Amazon_EC2_RunInstances_Inputs For method chaining.
     */
    public function setSnapshotId($value)
    {
        return $this->set('SnapshotId', $value);
    }

    /**
     * Set the value for the SubnetId input for this RunInstances Choreo.
     *
     * @param string $value (optional, string) The ID of the subnet to launch the instance into (i.e. subnet-dea63cb7).
     * @return Amazon_EC2_RunInstances_Inputs For method chaining.
     */
    public function setSubnetId($value)
    {
        return $this->set('SubnetId', $value);
    }

    /**
     * Set the value for the UserData input for this RunInstances Choreo.
     *
     * @param string $value (optional, string) The Base64-encoded MIME user data to be made available to the instance(s).
     * @return Amazon_EC2_RunInstances_Inputs For method chaining.
     */
    public function setUserData($value)
    {
        return $this->set('UserData', $value);
    }

    /**
     * Set the value for the UserRegion input for this RunInstances Choreo.
     *
     * @param string $value (optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
     * @return Amazon_EC2_RunInstances_Inputs For method chaining.
     */
    public function setUserRegion($value)
    {
        return $this->set('UserRegion', $value);
    }

    /**
     * Set the value for the VirtualName input for this RunInstances Choreo.
     *
     * @param string $value (optional, string) The name of the virtual device. This is a Block Device Mapping parameter.
     * @return Amazon_EC2_RunInstances_Inputs For method chaining.
     */
    public function setVirtualName($value)
    {
        return $this->set('VirtualName', $value);
    }

    /**
     * Set the value for the VolumeSize input for this RunInstances Choreo.
     *
     * @param string $value (optional, string) The size of the volume, in GiBs. Required unless you're creating the volume from a snapshot which indicates that the size will be the size of the snapshot. This is a Block Device Mapping parameter.
     * @return Amazon_EC2_RunInstances_Inputs For method chaining.
     */
    public function setVolumeSize($value)
    {
        return $this->set('VolumeSize', $value);
    }

    /**
     * Set the value for the VolumeType input for this RunInstances Choreo.
     *
     * @param string $value (optional, string) The volume type. Valid values are: standard (the default) and io1. This is a Block Device Mapping parameter.
     * @return Amazon_EC2_RunInstances_Inputs For method chaining.
     */
    public function setVolumeType($value)
    {
        return $this->set('VolumeType', $value);
    }
}


/**
 * Execution object for the RunInstances Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_RunInstances_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the RunInstances Choreo.
     *
     * @param Temboo_Session $session The session that owns this RunInstances execution.
     * @param Amazon_EC2_RunInstances $choreo The choreography object for this execution.
     * @param Amazon_EC2_RunInstances_Inputs|array $inputs (optional) Inputs as Amazon_EC2_RunInstances_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_RunInstances_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_EC2_RunInstances $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this RunInstances execution.
     *
     * @return Amazon_EC2_RunInstances_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this RunInstances execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_EC2_RunInstances_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_EC2_RunInstances_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the RunInstances Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_RunInstances_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the RunInstances Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_EC2_RunInstances_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this RunInstances execution.
     *
     * @return string The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Allows you to start an Amazon Machine Image by specifying its instance ID using the Amazon EC2 API.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_StartInstances extends Temboo_Choreography
{
    /**
     * Allows you to start an Amazon Machine Image by specifying its instance ID using the Amazon EC2 API.
     *
     * @param Temboo_Session $session The session that owns this StartInstances Choreo.
     * @return Amazon_EC2_StartInstances New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/EC2/StartInstances/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this StartInstances Choreo.
     *
     * @param Amazon_EC2_StartInstances_Inputs|array $inputs (optional) Inputs as Amazon_EC2_StartInstances_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_StartInstances_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_EC2_StartInstances_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this StartInstances Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_StartInstances_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_EC2_StartInstances_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the StartInstances Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_StartInstances_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the StartInstances Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_StartInstances_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this StartInstances input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_EC2_StartInstances_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_EC2_StartInstances_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AWSAccessKeyId input for this StartInstances Choreo.
     *
     * @param string $value (required, string) The Access Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_StartInstances_Inputs For method chaining.
     */
    public function setAWSAccessKeyId($value)
    {
        return $this->set('AWSAccessKeyId', $value);
    }

    /**
     * Set the value for the AWSSecretKeyId input for this StartInstances Choreo.
     *
     * @param string $value (required, string) The Secret Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_StartInstances_Inputs For method chaining.
     */
    public function setAWSSecretKeyId($value)
    {
        return $this->set('AWSSecretKeyId', $value);
    }

    /**
     * Set the value for the InstanceId input for this StartInstances Choreo.
     *
     * @param string $value (required, string) The instance ID to start. This can be a comma-separated list of up to 10 instance IDs.
     * @return Amazon_EC2_StartInstances_Inputs For method chaining.
     */
    public function setInstanceId($value)
    {
        return $this->set('InstanceId', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this StartInstances Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
     * @return Amazon_EC2_StartInstances_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }

    /**
     * Set the value for the UserRegion input for this StartInstances Choreo.
     *
     * @param string $value (optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
     * @return Amazon_EC2_StartInstances_Inputs For method chaining.
     */
    public function setUserRegion($value)
    {
        return $this->set('UserRegion', $value);
    }
}


/**
 * Execution object for the StartInstances Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_StartInstances_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the StartInstances Choreo.
     *
     * @param Temboo_Session $session The session that owns this StartInstances execution.
     * @param Amazon_EC2_StartInstances $choreo The choreography object for this execution.
     * @param Amazon_EC2_StartInstances_Inputs|array $inputs (optional) Inputs as Amazon_EC2_StartInstances_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_StartInstances_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_EC2_StartInstances $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this StartInstances execution.
     *
     * @return Amazon_EC2_StartInstances_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this StartInstances execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_EC2_StartInstances_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_EC2_StartInstances_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the StartInstances Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_StartInstances_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the StartInstances Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_EC2_StartInstances_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this StartInstances execution.
     *
     * @return string The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Calls the Amazon EC2 API to stop an Amazon EBS-backed instance.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_StopInstances extends Temboo_Choreography
{
    /**
     * Calls the Amazon EC2 API to stop an Amazon EBS-backed instance.
     *
     * @param Temboo_Session $session The session that owns this StopInstances Choreo.
     * @return Amazon_EC2_StopInstances New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/EC2/StopInstances/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this StopInstances Choreo.
     *
     * @param Amazon_EC2_StopInstances_Inputs|array $inputs (optional) Inputs as Amazon_EC2_StopInstances_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_StopInstances_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_EC2_StopInstances_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this StopInstances Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_StopInstances_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_EC2_StopInstances_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the StopInstances Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_StopInstances_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the StopInstances Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_StopInstances_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this StopInstances input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_EC2_StopInstances_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_EC2_StopInstances_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AWSAccessKeyId input for this StopInstances Choreo.
     *
     * @param string $value (required, string) The Access Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_StopInstances_Inputs For method chaining.
     */
    public function setAWSAccessKeyId($value)
    {
        return $this->set('AWSAccessKeyId', $value);
    }

    /**
     * Set the value for the AWSSecretKeyId input for this StopInstances Choreo.
     *
     * @param string $value (required, string) The Secret Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_StopInstances_Inputs For method chaining.
     */
    public function setAWSSecretKeyId($value)
    {
        return $this->set('AWSSecretKeyId', $value);
    }

    /**
     * Set the value for the InstanceId input for this StopInstances Choreo.
     *
     * @param string $value (required, string) The instance ID to stop. This can be a comma-separated list of up to 10 instance IDs.
     * @return Amazon_EC2_StopInstances_Inputs For method chaining.
     */
    public function setInstanceId($value)
    {
        return $this->set('InstanceId', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this StopInstances Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
     * @return Amazon_EC2_StopInstances_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }

    /**
     * Set the value for the UserRegion input for this StopInstances Choreo.
     *
     * @param string $value (optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
     * @return Amazon_EC2_StopInstances_Inputs For method chaining.
     */
    public function setUserRegion($value)
    {
        return $this->set('UserRegion', $value);
    }
}


/**
 * Execution object for the StopInstances Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_StopInstances_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the StopInstances Choreo.
     *
     * @param Temboo_Session $session The session that owns this StopInstances execution.
     * @param Amazon_EC2_StopInstances $choreo The choreography object for this execution.
     * @param Amazon_EC2_StopInstances_Inputs|array $inputs (optional) Inputs as Amazon_EC2_StopInstances_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_StopInstances_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_EC2_StopInstances $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this StopInstances execution.
     *
     * @return Amazon_EC2_StopInstances_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this StopInstances execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_EC2_StopInstances_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_EC2_StopInstances_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the StopInstances Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_StopInstances_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the StopInstances Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_EC2_StopInstances_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this StopInstances execution.
     *
     * @return string The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Shuts down one or more instances using the Amazon EC2 API.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_TerminateInstances extends Temboo_Choreography
{
    /**
     * Shuts down one or more instances using the Amazon EC2 API.
     *
     * @param Temboo_Session $session The session that owns this TerminateInstances Choreo.
     * @return Amazon_EC2_TerminateInstances New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/EC2/TerminateInstances/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this TerminateInstances Choreo.
     *
     * @param Amazon_EC2_TerminateInstances_Inputs|array $inputs (optional) Inputs as Amazon_EC2_TerminateInstances_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_TerminateInstances_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_EC2_TerminateInstances_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this TerminateInstances Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_TerminateInstances_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_EC2_TerminateInstances_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the TerminateInstances Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_TerminateInstances_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the TerminateInstances Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_TerminateInstances_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this TerminateInstances input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_EC2_TerminateInstances_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_EC2_TerminateInstances_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AWSAccessKeyId input for this TerminateInstances Choreo.
     *
     * @param string $value (required, string) The Access Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_TerminateInstances_Inputs For method chaining.
     */
    public function setAWSAccessKeyId($value)
    {
        return $this->set('AWSAccessKeyId', $value);
    }

    /**
     * Set the value for the AWSSecretKeyId input for this TerminateInstances Choreo.
     *
     * @param string $value (required, string) The Secret Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_TerminateInstances_Inputs For method chaining.
     */
    public function setAWSSecretKeyId($value)
    {
        return $this->set('AWSSecretKeyId', $value);
    }

    /**
     * Set the value for the InstanceId input for this TerminateInstances Choreo.
     *
     * @param string $value (required, string) The instance ID to terminate. This can be a comma-separated list of up to 10 instance IDs.
     * @return Amazon_EC2_TerminateInstances_Inputs For method chaining.
     */
    public function setInstanceId($value)
    {
        return $this->set('InstanceId', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this TerminateInstances Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
     * @return Amazon_EC2_TerminateInstances_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }

    /**
     * Set the value for the UserRegion input for this TerminateInstances Choreo.
     *
     * @param string $value (optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
     * @return Amazon_EC2_TerminateInstances_Inputs For method chaining.
     */
    public function setUserRegion($value)
    {
        return $this->set('UserRegion', $value);
    }
}


/**
 * Execution object for the TerminateInstances Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_TerminateInstances_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the TerminateInstances Choreo.
     *
     * @param Temboo_Session $session The session that owns this TerminateInstances execution.
     * @param Amazon_EC2_TerminateInstances $choreo The choreography object for this execution.
     * @param Amazon_EC2_TerminateInstances_Inputs|array $inputs (optional) Inputs as Amazon_EC2_TerminateInstances_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_TerminateInstances_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_EC2_TerminateInstances $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this TerminateInstances execution.
     *
     * @return Amazon_EC2_TerminateInstances_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this TerminateInstances execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_EC2_TerminateInstances_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_EC2_TerminateInstances_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the TerminateInstances Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_TerminateInstances_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the TerminateInstances Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_EC2_TerminateInstances_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this TerminateInstances execution.
     *
     * @return string The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Calls the Amazon EC2 API to disable monitoring for a specified instance.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_UnmonitorInstances extends Temboo_Choreography
{
    /**
     * Calls the Amazon EC2 API to disable monitoring for a specified instance.
     *
     * @param Temboo_Session $session The session that owns this UnmonitorInstances Choreo.
     * @return Amazon_EC2_UnmonitorInstances New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/EC2/UnmonitorInstances/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this UnmonitorInstances Choreo.
     *
     * @param Amazon_EC2_UnmonitorInstances_Inputs|array $inputs (optional) Inputs as Amazon_EC2_UnmonitorInstances_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_UnmonitorInstances_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_EC2_UnmonitorInstances_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this UnmonitorInstances Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_UnmonitorInstances_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_EC2_UnmonitorInstances_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the UnmonitorInstances Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_UnmonitorInstances_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the UnmonitorInstances Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_EC2_UnmonitorInstances_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this UnmonitorInstances input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_EC2_UnmonitorInstances_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_EC2_UnmonitorInstances_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AWSAccessKeyId input for this UnmonitorInstances Choreo.
     *
     * @param string $value (required, string) The Access Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_UnmonitorInstances_Inputs For method chaining.
     */
    public function setAWSAccessKeyId($value)
    {
        return $this->set('AWSAccessKeyId', $value);
    }

    /**
     * Set the value for the AWSSecretKeyId input for this UnmonitorInstances Choreo.
     *
     * @param string $value (required, string) The Secret Key ID provided by Amazon Web Services.
     * @return Amazon_EC2_UnmonitorInstances_Inputs For method chaining.
     */
    public function setAWSSecretKeyId($value)
    {
        return $this->set('AWSSecretKeyId', $value);
    }

    /**
     * Set the value for the InstanceId input for this UnmonitorInstances Choreo.
     *
     * @param string $value (required, string) The ID(s) of the instance(s) you want to stop monitoring. This can be a comma-separated list of up to 10 instance IDs.
     * @return Amazon_EC2_UnmonitorInstances_Inputs For method chaining.
     */
    public function setInstanceId($value)
    {
        return $this->set('InstanceId', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this UnmonitorInstances Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
     * @return Amazon_EC2_UnmonitorInstances_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }

    /**
     * Set the value for the UserRegion input for this UnmonitorInstances Choreo.
     *
     * @param string $value (optional, string) The AWS region that corresponds to the EC2 endpoint you wish to access. The default region is "us-east-1". See description below for valid values.
     * @return Amazon_EC2_UnmonitorInstances_Inputs For method chaining.
     */
    public function setUserRegion($value)
    {
        return $this->set('UserRegion', $value);
    }
}


/**
 * Execution object for the UnmonitorInstances Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_UnmonitorInstances_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the UnmonitorInstances Choreo.
     *
     * @param Temboo_Session $session The session that owns this UnmonitorInstances execution.
     * @param Amazon_EC2_UnmonitorInstances $choreo The choreography object for this execution.
     * @param Amazon_EC2_UnmonitorInstances_Inputs|array $inputs (optional) Inputs as Amazon_EC2_UnmonitorInstances_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_EC2_UnmonitorInstances_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_EC2_UnmonitorInstances $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this UnmonitorInstances execution.
     *
     * @return Amazon_EC2_UnmonitorInstances_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this UnmonitorInstances execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_EC2_UnmonitorInstances_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_EC2_UnmonitorInstances_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the UnmonitorInstances Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_EC2_UnmonitorInstances_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the UnmonitorInstances Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_EC2_UnmonitorInstances_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this UnmonitorInstances execution.
     *
     * @return string The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Adds the specified role to the specified instance profile.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_IAM_AddRoleToInstanceProfile extends Temboo_Choreography
{
    /**
     * Adds the specified role to the specified instance profile.
     *
     * @param Temboo_Session $session The session that owns this AddRoleToInstanceProfile Choreo.
     * @return Amazon_IAM_AddRoleToInstanceProfile New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/IAM/AddRoleToInstanceProfile/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this AddRoleToInstanceProfile Choreo.
     *
     * @param Amazon_IAM_AddRoleToInstanceProfile_Inputs|array $inputs (optional) Inputs as Amazon_IAM_AddRoleToInstanceProfile_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_IAM_AddRoleToInstanceProfile_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_IAM_AddRoleToInstanceProfile_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this AddRoleToInstanceProfile Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_IAM_AddRoleToInstanceProfile_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_IAM_AddRoleToInstanceProfile_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the AddRoleToInstanceProfile Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_IAM_AddRoleToInstanceProfile_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the AddRoleToInstanceProfile Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_IAM_AddRoleToInstanceProfile_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this AddRoleToInstanceProfile input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_IAM_AddRoleToInstanceProfile_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_IAM_AddRoleToInstanceProfile_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AWSAccessKeyId input for this AddRoleToInstanceProfile Choreo.
     *
     * @param string $value (required, string) The Access Key ID provided by Amazon Web Services.
     * @return Amazon_IAM_AddRoleToInstanceProfile_Inputs For method chaining.
     */
    public function setAWSAccessKeyId($value)
    {
        return $this->set('AWSAccessKeyId', $value);
    }

    /**
     * Set the value for the AWSSecretKeyId input for this AddRoleToInstanceProfile Choreo.
     *
     * @param string $value (required, string) The Secret Key ID provided by Amazon Web Services.
     * @return Amazon_IAM_AddRoleToInstanceProfile_Inputs For method chaining.
     */
    public function setAWSSecretKeyId($value)
    {
        return $this->set('AWSSecretKeyId', $value);
    }

    /**
     * Set the value for the InstanceProfileName input for this AddRoleToInstanceProfile Choreo.
     *
     * @param string $value (required, string) Name of the instance profile to update.
     * @return Amazon_IAM_AddRoleToInstanceProfile_Inputs For method chaining.
     */
    public function setInstanceProfileName($value)
    {
        return $this->set('InstanceProfileName', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this AddRoleToInstanceProfile Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
     * @return Amazon_IAM_AddRoleToInstanceProfile_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }

    /**
     * Set the value for the RoleName input for this AddRoleToInstanceProfile Choreo.
     *
     * @param string $value (required, string) Name of the role to add.
     * @return Amazon_IAM_AddRoleToInstanceProfile_Inputs For method chaining.
     */
    public function setRoleName($value)
    {
        return $this->set('RoleName', $value);
    }
}


/**
 * Execution object for the AddRoleToInstanceProfile Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_IAM_AddRoleToInstanceProfile_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the AddRoleToInstanceProfile Choreo.
     *
     * @param Temboo_Session $session The session that owns this AddRoleToInstanceProfile execution.
     * @param Amazon_IAM_AddRoleToInstanceProfile $choreo The choreography object for this execution.
     * @param Amazon_IAM_AddRoleToInstanceProfile_Inputs|array $inputs (optional) Inputs as Amazon_IAM_AddRoleToInstanceProfile_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_IAM_AddRoleToInstanceProfile_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_IAM_AddRoleToInstanceProfile $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this AddRoleToInstanceProfile execution.
     *
     * @return Amazon_IAM_AddRoleToInstanceProfile_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this AddRoleToInstanceProfile execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_IAM_AddRoleToInstanceProfile_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_IAM_AddRoleToInstanceProfile_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the AddRoleToInstanceProfile Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_IAM_AddRoleToInstanceProfile_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the AddRoleToInstanceProfile Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_IAM_AddRoleToInstanceProfile_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this AddRoleToInstanceProfile execution.
     *
     * @return string The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Adds a specified user to a specified group.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_IAM_AddUserToGroup extends Temboo_Choreography
{
    /**
     * Adds a specified user to a specified group.
     *
     * @param Temboo_Session $session The session that owns this AddUserToGroup Choreo.
     * @return Amazon_IAM_AddUserToGroup New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/IAM/AddUserToGroup/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this AddUserToGroup Choreo.
     *
     * @param Amazon_IAM_AddUserToGroup_Inputs|array $inputs (optional) Inputs as Amazon_IAM_AddUserToGroup_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_IAM_AddUserToGroup_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_IAM_AddUserToGroup_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this AddUserToGroup Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_IAM_AddUserToGroup_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_IAM_AddUserToGroup_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the AddUserToGroup Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_IAM_AddUserToGroup_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the AddUserToGroup Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_IAM_AddUserToGroup_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this AddUserToGroup input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_IAM_AddUserToGroup_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_IAM_AddUserToGroup_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AWSAccessKeyId input for this AddUserToGroup Choreo.
     *
     * @param string $value (required, string) The Access Key ID provided by Amazon Web Services.
     * @return Amazon_IAM_AddUserToGroup_Inputs For method chaining.
     */
    public function setAWSAccessKeyId($value)
    {
        return $this->set('AWSAccessKeyId', $value);
    }

    /**
     * Set the value for the AWSSecretKeyId input for this AddUserToGroup Choreo.
     *
     * @param string $value (required, string) The Secret Key ID provided by Amazon Web Services.
     * @return Amazon_IAM_AddUserToGroup_Inputs For method chaining.
     */
    public function setAWSSecretKeyId($value)
    {
        return $this->set('AWSSecretKeyId', $value);
    }

    /**
     * Set the value for the GroupName input for this AddUserToGroup Choreo.
     *
     * @param string $value (required, string) The name of the group that the user will be added to.
     * @return Amazon_IAM_AddUserToGroup_Inputs For method chaining.
     */
    public function setGroupName($value)
    {
        return $this->set('GroupName', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this AddUserToGroup Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
     * @return Amazon_IAM_AddUserToGroup_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }

    /**
     * Set the value for the UserName input for this AddUserToGroup Choreo.
     *
     * @param string $value (required, string) The name of the user to add.
     * @return Amazon_IAM_AddUserToGroup_Inputs For method chaining.
     */
    public function setUserName($value)
    {
        return $this->set('UserName', $value);
    }
}


/**
 * Execution object for the AddUserToGroup Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_IAM_AddUserToGroup_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the AddUserToGroup Choreo.
     *
     * @param Temboo_Session $session The session that owns this AddUserToGroup execution.
     * @param Amazon_IAM_AddUserToGroup $choreo The choreography object for this execution.
     * @param Amazon_IAM_AddUserToGroup_Inputs|array $inputs (optional) Inputs as Amazon_IAM_AddUserToGroup_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_IAM_AddUserToGroup_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_IAM_AddUserToGroup $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this AddUserToGroup execution.
     *
     * @return Amazon_IAM_AddUserToGroup_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this AddUserToGroup execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_IAM_AddUserToGroup_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_IAM_AddUserToGroup_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the AddUserToGroup Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_IAM_AddUserToGroup_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the AddUserToGroup Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_IAM_AddUserToGroup_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this AddUserToGroup execution.
     *
     * @return string The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Allows the authenticating user to change their password.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_IAM_ChangePassword extends Temboo_Choreography
{
    /**
     * Allows the authenticating user to change their password.
     *
     * @param Temboo_Session $session The session that owns this ChangePassword Choreo.
     * @return Amazon_IAM_ChangePassword New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/IAM/ChangePassword/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this ChangePassword Choreo.
     *
     * @param Amazon_IAM_ChangePassword_Inputs|array $inputs (optional) Inputs as Amazon_IAM_ChangePassword_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_IAM_ChangePassword_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_IAM_ChangePassword_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this ChangePassword Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_IAM_ChangePassword_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_IAM_ChangePassword_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the ChangePassword Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_IAM_ChangePassword_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the ChangePassword Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_IAM_ChangePassword_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this ChangePassword input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_IAM_ChangePassword_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_IAM_ChangePassword_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AWSAccessKeyId input for this ChangePassword Choreo.
     *
     * @param string $value (required, string) The user's Access Key ID.
     * @return Amazon_IAM_ChangePassword_Inputs For method chaining.
     */
    public function setAWSAccessKeyId($value)
    {
        return $this->set('AWSAccessKeyId', $value);
    }

    /**
     * Set the value for the AWSSecretKeyId input for this ChangePassword Choreo.
     *
     * @param string $value (required, string) The user's Secret Key ID.
     * @return Amazon_IAM_ChangePassword_Inputs For method chaining.
     */
    public function setAWSSecretKeyId($value)
    {
        return $this->set('AWSSecretKeyId', $value);
    }

    /**
     * Set the value for the NewPassword input for this ChangePassword Choreo.
     *
     * @param string $value (required, string) The new password.
     * @return Amazon_IAM_ChangePassword_Inputs For method chaining.
     */
    public function setNewPassword($value)
    {
        return $this->set('NewPassword', $value);
    }

    /**
     * Set the value for the OldPassword input for this ChangePassword Choreo.
     *
     * @param string $value (required, string) The old password.
     * @return Amazon_IAM_ChangePassword_Inputs For method chaining.
     */
    public function setOldPassword($value)
    {
        return $this->set('OldPassword', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this ChangePassword Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
     * @return Amazon_IAM_ChangePassword_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }
}


/**
 * Execution object for the ChangePassword Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_IAM_ChangePassword_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the ChangePassword Choreo.
     *
     * @param Temboo_Session $session The session that owns this ChangePassword execution.
     * @param Amazon_IAM_ChangePassword $choreo The choreography object for this execution.
     * @param Amazon_IAM_ChangePassword_Inputs|array $inputs (optional) Inputs as Amazon_IAM_ChangePassword_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_IAM_ChangePassword_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_IAM_ChangePassword $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this ChangePassword execution.
     *
     * @return Amazon_IAM_ChangePassword_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this ChangePassword execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_IAM_ChangePassword_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_IAM_ChangePassword_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the ChangePassword Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_IAM_ChangePassword_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the ChangePassword Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_IAM_ChangePassword_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this ChangePassword execution.
     *
     * @return string The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Creates a new AWS Secret Access Key and corresponding AWS Access Key ID for a specified user.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_IAM_CreateAccessKey extends Temboo_Choreography
{
    /**
     * Creates a new AWS Secret Access Key and corresponding AWS Access Key ID for a specified user.
     *
     * @param Temboo_Session $session The session that owns this CreateAccessKey Choreo.
     * @return Amazon_IAM_CreateAccessKey New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/IAM/CreateAccessKey/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this CreateAccessKey Choreo.
     *
     * @param Amazon_IAM_CreateAccessKey_Inputs|array $inputs (optional) Inputs as Amazon_IAM_CreateAccessKey_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_IAM_CreateAccessKey_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_IAM_CreateAccessKey_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this CreateAccessKey Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_IAM_CreateAccessKey_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_IAM_CreateAccessKey_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the CreateAccessKey Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_IAM_CreateAccessKey_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the CreateAccessKey Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_IAM_CreateAccessKey_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this CreateAccessKey input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_IAM_CreateAccessKey_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_IAM_CreateAccessKey_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AWSAccessKeyId input for this CreateAccessKey Choreo.
     *
     * @param string $value (required, string) The Access Key ID provided by Amazon Web Services.
     * @return Amazon_IAM_CreateAccessKey_Inputs For method chaining.
     */
    public function setAWSAccessKeyId($value)
    {
        return $this->set('AWSAccessKeyId', $value);
    }

    /**
     * Set the value for the AWSSecretKeyId input for this CreateAccessKey Choreo.
     *
     * @param string $value (required, string) The Secret Key ID provided by Amazon Web Services.
     * @return Amazon_IAM_CreateAccessKey_Inputs For method chaining.
     */
    public function setAWSSecretKeyId($value)
    {
        return $this->set('AWSSecretKeyId', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this CreateAccessKey Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
     * @return Amazon_IAM_CreateAccessKey_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }

    /**
     * Set the value for the UserName input for this CreateAccessKey Choreo.
     *
     * @param string $value (conditional, string) The user name that the new key will belong to.  If you do not specify a user name, IAM determines the user name implicitly based on the AWS Access Key ID signing the request. 
     * @return Amazon_IAM_CreateAccessKey_Inputs For method chaining.
     */
    public function setUserName($value)
    {
        return $this->set('UserName', $value);
    }
}


/**
 * Execution object for the CreateAccessKey Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_IAM_CreateAccessKey_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the CreateAccessKey Choreo.
     *
     * @param Temboo_Session $session The session that owns this CreateAccessKey execution.
     * @param Amazon_IAM_CreateAccessKey $choreo The choreography object for this execution.
     * @param Amazon_IAM_CreateAccessKey_Inputs|array $inputs (optional) Inputs as Amazon_IAM_CreateAccessKey_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_IAM_CreateAccessKey_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_IAM_CreateAccessKey $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this CreateAccessKey execution.
     *
     * @return Amazon_IAM_CreateAccessKey_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this CreateAccessKey execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_IAM_CreateAccessKey_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_IAM_CreateAccessKey_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the CreateAccessKey Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_IAM_CreateAccessKey_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the CreateAccessKey Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_IAM_CreateAccessKey_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this CreateAccessKey execution.
     *
     * @return string The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Creates an alias for your AWS account.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_IAM_CreateAccountAlias extends Temboo_Choreography
{
    /**
     * Creates an alias for your AWS account.
     *
     * @param Temboo_Session $session The session that owns this CreateAccountAlias Choreo.
     * @return Amazon_IAM_CreateAccountAlias New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/IAM/CreateAccountAlias/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this CreateAccountAlias Choreo.
     *
     * @param Amazon_IAM_CreateAccountAlias_Inputs|array $inputs (optional) Inputs as Amazon_IAM_CreateAccountAlias_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_IAM_CreateAccountAlias_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_IAM_CreateAccountAlias_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this CreateAccountAlias Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_IAM_CreateAccountAlias_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_IAM_CreateAccountAlias_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the CreateAccountAlias Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_IAM_CreateAccountAlias_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the CreateAccountAlias Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_IAM_CreateAccountAlias_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this CreateAccountAlias input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_IAM_CreateAccountAlias_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_IAM_CreateAccountAlias_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AWSAccessKeyId input for this CreateAccountAlias Choreo.
     *
     * @param string $value (required, string) The Access Key ID provided by Amazon Web Services.
     * @return Amazon_IAM_CreateAccountAlias_Inputs For method chaining.
     */
    public function setAWSAccessKeyId($value)
    {
        return $this->set('AWSAccessKeyId', $value);
    }

    /**
     * Set the value for the AWSSecretKeyId input for this CreateAccountAlias Choreo.
     *
     * @param string $value (required, string) The Secret Key ID provided by Amazon Web Services.
     * @return Amazon_IAM_CreateAccountAlias_Inputs For method chaining.
     */
    public function setAWSSecretKeyId($value)
    {
        return $this->set('AWSSecretKeyId', $value);
    }

    /**
     * Set the value for the AccountAlias input for this CreateAccountAlias Choreo.
     *
     * @param string $value (required, string) Name of the account alias to create. Must contain only digits, lowercase letters, and hyphens (-), but cannot begin or end with a hyphen. Ex.: alias-account-name.
     * @return Amazon_IAM_CreateAccountAlias_Inputs For method chaining.
     */
    public function setAccountAlias($value)
    {
        return $this->set('AccountAlias', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this CreateAccountAlias Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
     * @return Amazon_IAM_CreateAccountAlias_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }
}


/**
 * Execution object for the CreateAccountAlias Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_IAM_CreateAccountAlias_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the CreateAccountAlias Choreo.
     *
     * @param Temboo_Session $session The session that owns this CreateAccountAlias execution.
     * @param Amazon_IAM_CreateAccountAlias $choreo The choreography object for this execution.
     * @param Amazon_IAM_CreateAccountAlias_Inputs|array $inputs (optional) Inputs as Amazon_IAM_CreateAccountAlias_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_IAM_CreateAccountAlias_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_IAM_CreateAccountAlias $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this CreateAccountAlias execution.
     *
     * @return Amazon_IAM_CreateAccountAlias_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this CreateAccountAlias execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_IAM_CreateAccountAlias_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_IAM_CreateAccountAlias_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the CreateAccountAlias Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_IAM_CreateAccountAlias_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the CreateAccountAlias Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_IAM_CreateAccountAlias_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this CreateAccountAlias execution.
     *
     * @return string The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Creates a new group in your AWS account.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_IAM_CreateGroup extends Temboo_Choreography
{
    /**
     * Creates a new group in your AWS account.
     *
     * @param Temboo_Session $session The session that owns this CreateGroup Choreo.
     * @return Amazon_IAM_CreateGroup New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/IAM/CreateGroup/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this CreateGroup Choreo.
     *
     * @param Amazon_IAM_CreateGroup_Inputs|array $inputs (optional) Inputs as Amazon_IAM_CreateGroup_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_IAM_CreateGroup_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_IAM_CreateGroup_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this CreateGroup Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_IAM_CreateGroup_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_IAM_CreateGroup_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the CreateGroup Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_IAM_CreateGroup_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the CreateGroup Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_IAM_CreateGroup_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this CreateGroup input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_IAM_CreateGroup_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_IAM_CreateGroup_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AWSAccessKeyId input for this CreateGroup Choreo.
     *
     * @param string $value (required, string) The Access Key ID provided by Amazon Web Services.
     * @return Amazon_IAM_CreateGroup_Inputs For method chaining.
     */
    public function setAWSAccessKeyId($value)
    {
        return $this->set('AWSAccessKeyId', $value);
    }

    /**
     * Set the value for the AWSSecretKeyId input for this CreateGroup Choreo.
     *
     * @param string $value (required, string) The Secret Key ID provided by Amazon Web Services.
     * @return Amazon_IAM_CreateGroup_Inputs For method chaining.
     */
    public function setAWSSecretKeyId($value)
    {
        return $this->set('AWSSecretKeyId', $value);
    }

    /**
     * Set the value for the GroupName input for this CreateGroup Choreo.
     *
     * @param string $value (required, string) The name of the group to create.
     * @return Amazon_IAM_CreateGroup_Inputs For method chaining.
     */
    public function setGroupName($value)
    {
        return $this->set('GroupName', $value);
    }

    /**
     * Set the value for the Path input for this CreateGroup Choreo.
     *
     * @param string $value (optional, string) The path to the group. If it is not included, it defaults to a slash (/).
     * @return Amazon_IAM_CreateGroup_Inputs For method chaining.
     */
    public function setPath($value)
    {
        return $this->set('Path', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this CreateGroup Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
     * @return Amazon_IAM_CreateGroup_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }
}


/**
 * Execution object for the CreateGroup Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_IAM_CreateGroup_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the CreateGroup Choreo.
     *
     * @param Temboo_Session $session The session that owns this CreateGroup execution.
     * @param Amazon_IAM_CreateGroup $choreo The choreography object for this execution.
     * @param Amazon_IAM_CreateGroup_Inputs|array $inputs (optional) Inputs as Amazon_IAM_CreateGroup_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_IAM_CreateGroup_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_IAM_CreateGroup $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this CreateGroup execution.
     *
     * @return Amazon_IAM_CreateGroup_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this CreateGroup execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_IAM_CreateGroup_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_IAM_CreateGroup_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the CreateGroup Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_IAM_CreateGroup_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the CreateGroup Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_IAM_CreateGroup_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this CreateGroup execution.
     *
     * @return string The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Creates a new instance profile.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_IAM_CreateInstanceProfile extends Temboo_Choreography
{
    /**
     * Creates a new instance profile.
     *
     * @param Temboo_Session $session The session that owns this CreateInstanceProfile Choreo.
     * @return Amazon_IAM_CreateInstanceProfile New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/IAM/CreateInstanceProfile/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this CreateInstanceProfile Choreo.
     *
     * @param Amazon_IAM_CreateInstanceProfile_Inputs|array $inputs (optional) Inputs as Amazon_IAM_CreateInstanceProfile_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_IAM_CreateInstanceProfile_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_IAM_CreateInstanceProfile_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this CreateInstanceProfile Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_IAM_CreateInstanceProfile_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_IAM_CreateInstanceProfile_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the CreateInstanceProfile Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_IAM_CreateInstanceProfile_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the CreateInstanceProfile Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_IAM_CreateInstanceProfile_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this CreateInstanceProfile input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_IAM_CreateInstanceProfile_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_IAM_CreateInstanceProfile_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AWSAccessKeyId input for this CreateInstanceProfile Choreo.
     *
     * @param string $value (required, string) The Access Key ID provided by Amazon Web Services.
     * @return Amazon_IAM_CreateInstanceProfile_Inputs For method chaining.
     */
    public function setAWSAccessKeyId($value)
    {
        return $this->set('AWSAccessKeyId', $value);
    }

    /**
     * Set the value for the AWSSecretKeyId input for this CreateInstanceProfile Choreo.
     *
     * @param string $value (required, string) The Secret Key ID provided by Amazon Web Services.
     * @return Amazon_IAM_CreateInstanceProfile_Inputs For method chaining.
     */
    public function setAWSSecretKeyId($value)
    {
        return $this->set('AWSSecretKeyId', $value);
    }

    /**
     * Set the value for the InstanceProfileName input for this CreateInstanceProfile Choreo.
     *
     * @param string $value (required, string) Name of the instance profile to create.
     * @return Amazon_IAM_CreateInstanceProfile_Inputs For method chaining.
     */
    public function setInstanceProfileName($value)
    {
        return $this->set('InstanceProfileName', $value);
    }

    /**
     * Set the value for the Path input for this CreateInstanceProfile Choreo.
     *
     * @param string $value (optional, string) The path for the user name. If it is not included, it defaults to a slash (/).
     * @return Amazon_IAM_CreateInstanceProfile_Inputs For method chaining.
     */
    public function setPath($value)
    {
        return $this->set('Path', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this CreateInstanceProfile Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
     * @return Amazon_IAM_CreateInstanceProfile_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }
}


/**
 * Execution object for the CreateInstanceProfile Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_IAM_CreateInstanceProfile_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the CreateInstanceProfile Choreo.
     *
     * @param Temboo_Session $session The session that owns this CreateInstanceProfile execution.
     * @param Amazon_IAM_CreateInstanceProfile $choreo The choreography object for this execution.
     * @param Amazon_IAM_CreateInstanceProfile_Inputs|array $inputs (optional) Inputs as Amazon_IAM_CreateInstanceProfile_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_IAM_CreateInstanceProfile_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_IAM_CreateInstanceProfile $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this CreateInstanceProfile execution.
     *
     * @return Amazon_IAM_CreateInstanceProfile_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this CreateInstanceProfile execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_IAM_CreateInstanceProfile_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_IAM_CreateInstanceProfile_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the CreateInstanceProfile Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_IAM_CreateInstanceProfile_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the CreateInstanceProfile Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_IAM_CreateInstanceProfile_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this CreateInstanceProfile execution.
     *
     * @return string The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Creates a password for the specified user, which gives the user the ability to access AWS services through the AWS Management Console.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_IAM_CreateLoginProfile extends Temboo_Choreography
{
    /**
     * Creates a password for the specified user, which gives the user the ability to access AWS services through the AWS Management Console.
     *
     * @param Temboo_Session $session The session that owns this CreateLoginProfile Choreo.
     * @return Amazon_IAM_CreateLoginProfile New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/IAM/CreateLoginProfile/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this CreateLoginProfile Choreo.
     *
     * @param Amazon_IAM_CreateLoginProfile_Inputs|array $inputs (optional) Inputs as Amazon_IAM_CreateLoginProfile_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_IAM_CreateLoginProfile_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_IAM_CreateLoginProfile_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this CreateLoginProfile Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_IAM_CreateLoginProfile_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_IAM_CreateLoginProfile_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the CreateLoginProfile Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_IAM_CreateLoginProfile_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the CreateLoginProfile Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_IAM_CreateLoginProfile_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this CreateLoginProfile input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_IAM_CreateLoginProfile_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_IAM_CreateLoginProfile_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AWSAccessKeyId input for this CreateLoginProfile Choreo.
     *
     * @param string $value (required, string) The Access Key ID provided by Amazon Web Services.
     * @return Amazon_IAM_CreateLoginProfile_Inputs For method chaining.
     */
    public function setAWSAccessKeyId($value)
    {
        return $this->set('AWSAccessKeyId', $value);
    }

    /**
     * Set the value for the AWSSecretKeyId input for this CreateLoginProfile Choreo.
     *
     * @param string $value (required, string) The Secret Key ID provided by Amazon Web Services.
     * @return Amazon_IAM_CreateLoginProfile_Inputs For method chaining.
     */
    public function setAWSSecretKeyId($value)
    {
        return $this->set('AWSSecretKeyId', $value);
    }

    /**
     * Set the value for the MustChangePassword input for this CreateLoginProfile Choreo.
     *
     * @param bool $value (optional, boolean) Whether or not the user is required to change their password immediately.  Valid values are true/false or 1/0.
     * @return Amazon_IAM_CreateLoginProfile_Inputs For method chaining.
     */
    public function setMustChangePassword($value)
    {
        return $this->set('MustChangePassword', $value);
    }

    /**
     * Set the value for the Password input for this CreateLoginProfile Choreo.
     *
     * @param string $value (required, string) The new password for the user.
     * @return Amazon_IAM_CreateLoginProfile_Inputs For method chaining.
     */
    public function setPassword($value)
    {
        return $this->set('Password', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this CreateLoginProfile Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
     * @return Amazon_IAM_CreateLoginProfile_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }

    /**
     * Set the value for the UserName input for this CreateLoginProfile Choreo.
     *
     * @param string $value (required, string) The name of the user to create a password for.
     * @return Amazon_IAM_CreateLoginProfile_Inputs For method chaining.
     */
    public function setUserName($value)
    {
        return $this->set('UserName', $value);
    }
}


/**
 * Execution object for the CreateLoginProfile Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_IAM_CreateLoginProfile_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the CreateLoginProfile Choreo.
     *
     * @param Temboo_Session $session The session that owns this CreateLoginProfile execution.
     * @param Amazon_IAM_CreateLoginProfile $choreo The choreography object for this execution.
     * @param Amazon_IAM_CreateLoginProfile_Inputs|array $inputs (optional) Inputs as Amazon_IAM_CreateLoginProfile_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_IAM_CreateLoginProfile_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_IAM_CreateLoginProfile $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this CreateLoginProfile execution.
     *
     * @return Amazon_IAM_CreateLoginProfile_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this CreateLoginProfile execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_IAM_CreateLoginProfile_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_IAM_CreateLoginProfile_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the CreateLoginProfile Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_IAM_CreateLoginProfile_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the CreateLoginProfile Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_IAM_CreateLoginProfile_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this CreateLoginProfile execution.
     *
     * @return string The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Creates a new user for your AWS account.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_IAM_CreateUser extends Temboo_Choreography
{
    /**
     * Creates a new user for your AWS account.
     *
     * @param Temboo_Session $session The session that owns this CreateUser Choreo.
     * @return Amazon_IAM_CreateUser New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/IAM/CreateUser/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this CreateUser Choreo.
     *
     * @param Amazon_IAM_CreateUser_Inputs|array $inputs (optional) Inputs as Amazon_IAM_CreateUser_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_IAM_CreateUser_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_IAM_CreateUser_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this CreateUser Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_IAM_CreateUser_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_IAM_CreateUser_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the CreateUser Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_IAM_CreateUser_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the CreateUser Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_IAM_CreateUser_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this CreateUser input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_IAM_CreateUser_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_IAM_CreateUser_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AWSAccessKeyId input for this CreateUser Choreo.
     *
     * @param string $value (required, string) The Access Key ID provided by Amazon Web Services.
     * @return Amazon_IAM_CreateUser_Inputs For method chaining.
     */
    public function setAWSAccessKeyId($value)
    {
        return $this->set('AWSAccessKeyId', $value);
    }

    /**
     * Set the value for the AWSSecretKeyId input for this CreateUser Choreo.
     *
     * @param string $value (required, string) The Secret Key ID provided by Amazon Web Services.
     * @return Amazon_IAM_CreateUser_Inputs For method chaining.
     */
    public function setAWSSecretKeyId($value)
    {
        return $this->set('AWSSecretKeyId', $value);
    }

    /**
     * Set the value for the Path input for this CreateUser Choreo.
     *
     * @param string $value (optional, string) The path for the user name. If it is not included, it defaults to a slash (/).
     * @return Amazon_IAM_CreateUser_Inputs For method chaining.
     */
    public function setPath($value)
    {
        return $this->set('Path', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this CreateUser Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
     * @return Amazon_IAM_CreateUser_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }

    /**
     * Set the value for the UserName input for this CreateUser Choreo.
     *
     * @param string $value (required, string) The name of the user to create.
     * @return Amazon_IAM_CreateUser_Inputs For method chaining.
     */
    public function setUserName($value)
    {
        return $this->set('UserName', $value);
    }
}


/**
 * Execution object for the CreateUser Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_IAM_CreateUser_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the CreateUser Choreo.
     *
     * @param Temboo_Session $session The session that owns this CreateUser execution.
     * @param Amazon_IAM_CreateUser $choreo The choreography object for this execution.
     * @param Amazon_IAM_CreateUser_Inputs|array $inputs (optional) Inputs as Amazon_IAM_CreateUser_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_IAM_CreateUser_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_IAM_CreateUser $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this CreateUser execution.
     *
     * @return Amazon_IAM_CreateUser_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this CreateUser execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_IAM_CreateUser_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_IAM_CreateUser_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the CreateUser Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_IAM_CreateUser_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the CreateUser Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_IAM_CreateUser_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this CreateUser execution.
     *
     * @return string The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Creates a new virtual MFA device for the AWS account.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_IAM_CreateVirtualMFADevice extends Temboo_Choreography
{
    /**
     * Creates a new virtual MFA device for the AWS account.
     *
     * @param Temboo_Session $session The session that owns this CreateVirtualMFADevice Choreo.
     * @return Amazon_IAM_CreateVirtualMFADevice New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/IAM/CreateVirtualMFADevice/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this CreateVirtualMFADevice Choreo.
     *
     * @param Amazon_IAM_CreateVirtualMFADevice_Inputs|array $inputs (optional) Inputs as Amazon_IAM_CreateVirtualMFADevice_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_IAM_CreateVirtualMFADevice_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_IAM_CreateVirtualMFADevice_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this CreateVirtualMFADevice Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_IAM_CreateVirtualMFADevice_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_IAM_CreateVirtualMFADevice_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the CreateVirtualMFADevice Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_IAM_CreateVirtualMFADevice_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the CreateVirtualMFADevice Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_IAM_CreateVirtualMFADevice_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this CreateVirtualMFADevice input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_IAM_CreateVirtualMFADevice_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_IAM_CreateVirtualMFADevice_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AWSAccessKeyId input for this CreateVirtualMFADevice Choreo.
     *
     * @param string $value (required, string) The Access Key ID provided by Amazon Web Services.
     * @return Amazon_IAM_CreateVirtualMFADevice_Inputs For method chaining.
     */
    public function setAWSAccessKeyId($value)
    {
        return $this->set('AWSAccessKeyId', $value);
    }

    /**
     * Set the value for the AWSSecretKeyId input for this CreateVirtualMFADevice Choreo.
     *
     * @param string $value (required, string) The Secret Key ID provided by Amazon Web Services.
     * @return Amazon_IAM_CreateVirtualMFADevice_Inputs For method chaining.
     */
    public function setAWSSecretKeyId($value)
    {
        return $this->set('AWSSecretKeyId', $value);
    }

    /**
     * Set the value for the Path input for this CreateVirtualMFADevice Choreo.
     *
     * @param string $value (optional, string) The path for the virtual MFA device. If it is not included, it defaults to a slash (/).
     * @return Amazon_IAM_CreateVirtualMFADevice_Inputs For method chaining.
     */
    public function setPath($value)
    {
        return $this->set('Path', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this CreateVirtualMFADevice Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
     * @return Amazon_IAM_CreateVirtualMFADevice_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }

    /**
     * Set the value for the VirtualMFADeviceName input for this CreateVirtualMFADevice Choreo.
     *
     * @param string $value (required, string) The name of the virtual MFA device. Use with path to uniquely identify a virtual MFA device.
     * @return Amazon_IAM_CreateVirtualMFADevice_Inputs For method chaining.
     */
    public function setVirtualMFADeviceName($value)
    {
        return $this->set('VirtualMFADeviceName', $value);
    }
}


/**
 * Execution object for the CreateVirtualMFADevice Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_IAM_CreateVirtualMFADevice_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the CreateVirtualMFADevice Choreo.
     *
     * @param Temboo_Session $session The session that owns this CreateVirtualMFADevice execution.
     * @param Amazon_IAM_CreateVirtualMFADevice $choreo The choreography object for this execution.
     * @param Amazon_IAM_CreateVirtualMFADevice_Inputs|array $inputs (optional) Inputs as Amazon_IAM_CreateVirtualMFADevice_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_IAM_CreateVirtualMFADevice_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_IAM_CreateVirtualMFADevice $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this CreateVirtualMFADevice execution.
     *
     * @return Amazon_IAM_CreateVirtualMFADevice_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this CreateVirtualMFADevice execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_IAM_CreateVirtualMFADevice_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_IAM_CreateVirtualMFADevice_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the CreateVirtualMFADevice Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_IAM_CreateVirtualMFADevice_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the CreateVirtualMFADevice Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_IAM_CreateVirtualMFADevice_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this CreateVirtualMFADevice execution.
     *
     * @return string The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Deactivates the specified MFA device and removes it from association with the user name for which it was originally enabled.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_IAM_DeactivateMFADevice extends Temboo_Choreography
{
    /**
     * Deactivates the specified MFA device and removes it from association with the user name for which it was originally enabled.
     *
     * @param Temboo_Session $session The session that owns this DeactivateMFADevice Choreo.
     * @return Amazon_IAM_DeactivateMFADevice New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/IAM/DeactivateMFADevice/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this DeactivateMFADevice Choreo.
     *
     * @param Amazon_IAM_DeactivateMFADevice_Inputs|array $inputs (optional) Inputs as Amazon_IAM_DeactivateMFADevice_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_IAM_DeactivateMFADevice_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_IAM_DeactivateMFADevice_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this DeactivateMFADevice Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_IAM_DeactivateMFADevice_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_IAM_DeactivateMFADevice_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the DeactivateMFADevice Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_IAM_DeactivateMFADevice_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the DeactivateMFADevice Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_IAM_DeactivateMFADevice_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this DeactivateMFADevice input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_IAM_DeactivateMFADevice_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_IAM_DeactivateMFADevice_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AWSAccessKeyId input for this DeactivateMFADevice Choreo.
     *
     * @param string $value (required, string) The Access Key ID provided by Amazon Web Services.
     * @return Amazon_IAM_DeactivateMFADevice_Inputs For method chaining.
     */
    public function setAWSAccessKeyId($value)
    {
        return $this->set('AWSAccessKeyId', $value);
    }

    /**
     * Set the value for the AWSSecretKeyId input for this DeactivateMFADevice Choreo.
     *
     * @param string $value (required, string) The Secret Key ID provided by Amazon Web Services.
     * @return Amazon_IAM_DeactivateMFADevice_Inputs For method chaining.
     */
    public function setAWSSecretKeyId($value)
    {
        return $this->set('AWSSecretKeyId', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this DeactivateMFADevice Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
     * @return Amazon_IAM_DeactivateMFADevice_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }

    /**
     * Set the value for the SerialNumber input for this DeactivateMFADevice Choreo.
     *
     * @param string $value (required, string) The serial number that uniquely identifies the MFA device. For virtual MFA devices, the serial number is the device ARN.
     * @return Amazon_IAM_DeactivateMFADevice_Inputs For method chaining.
     */
    public function setSerialNumber($value)
    {
        return $this->set('SerialNumber', $value);
    }

    /**
     * Set the value for the UserName input for this DeactivateMFADevice Choreo.
     *
     * @param string $value (required, string) Name of the user whose MFA device you want to deactivate.
     * @return Amazon_IAM_DeactivateMFADevice_Inputs For method chaining.
     */
    public function setUserName($value)
    {
        return $this->set('UserName', $value);
    }
}


/**
 * Execution object for the DeactivateMFADevice Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_IAM_DeactivateMFADevice_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the DeactivateMFADevice Choreo.
     *
     * @param Temboo_Session $session The session that owns this DeactivateMFADevice execution.
     * @param Amazon_IAM_DeactivateMFADevice $choreo The choreography object for this execution.
     * @param Amazon_IAM_DeactivateMFADevice_Inputs|array $inputs (optional) Inputs as Amazon_IAM_DeactivateMFADevice_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_IAM_DeactivateMFADevice_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_IAM_DeactivateMFADevice $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this DeactivateMFADevice execution.
     *
     * @return Amazon_IAM_DeactivateMFADevice_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this DeactivateMFADevice execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_IAM_DeactivateMFADevice_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_IAM_DeactivateMFADevice_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the DeactivateMFADevice Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_IAM_DeactivateMFADevice_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the DeactivateMFADevice Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_IAM_DeactivateMFADevice_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this DeactivateMFADevice execution.
     *
     * @return string The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Deletes the access key associated with the specified user.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_IAM_DeleteAccessKey extends Temboo_Choreography
{
    /**
     * Deletes the access key associated with the specified user.
     *
     * @param Temboo_Session $session The session that owns this DeleteAccessKey Choreo.
     * @return Amazon_IAM_DeleteAccessKey New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/IAM/DeleteAccessKey/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this DeleteAccessKey Choreo.
     *
     * @param Amazon_IAM_DeleteAccessKey_Inputs|array $inputs (optional) Inputs as Amazon_IAM_DeleteAccessKey_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_IAM_DeleteAccessKey_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_IAM_DeleteAccessKey_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this DeleteAccessKey Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_IAM_DeleteAccessKey_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_IAM_DeleteAccessKey_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the DeleteAccessKey Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_IAM_DeleteAccessKey_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the DeleteAccessKey Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_IAM_DeleteAccessKey_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this DeleteAccessKey input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_IAM_DeleteAccessKey_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_IAM_DeleteAccessKey_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AWSAccessKeyId input for this DeleteAccessKey Choreo.
     *
     * @param string $value (required, string) An AWS Access Key ID with sufficient permissions to delete the specified AccessKeyId.
     * @return Amazon_IAM_DeleteAccessKey_Inputs For method chaining.
     */
    public function setAWSAccessKeyId($value)
    {
        return $this->set('AWSAccessKeyId', $value);
    }

    /**
     * Set the value for the AWSSecretKeyId input for this DeleteAccessKey Choreo.
     *
     * @param string $value (required, string) The Secret Key ID associated with the AWS AccessKey ID with sufficient permissions to delete the AccessKeyId.
     * @return Amazon_IAM_DeleteAccessKey_Inputs For method chaining.
     */
    public function setAWSSecretKeyId($value)
    {
        return $this->set('AWSSecretKeyId', $value);
    }

    /**
     * Set the value for the AccessKeyId input for this DeleteAccessKey Choreo.
     *
     * @param string $value (conditional, string) The Access Key ID for the Access Key ID and Secret Access Key you want to delete.
     * @return Amazon_IAM_DeleteAccessKey_Inputs For method chaining.
     */
    public function setAccessKeyId($value)
    {
        return $this->set('AccessKeyId', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this DeleteAccessKey Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
     * @return Amazon_IAM_DeleteAccessKey_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }

    /**
     * Set the value for the UserName input for this DeleteAccessKey Choreo.
     *
     * @param string $value (conditional, string) Name of the user whose key you want to delete.  If you do not specify a user name, IAM determines the user name implicitly based on the AWS Access Key ID signing the request.
     * @return Amazon_IAM_DeleteAccessKey_Inputs For method chaining.
     */
    public function setUserName($value)
    {
        return $this->set('UserName', $value);
    }
}


/**
 * Execution object for the DeleteAccessKey Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_IAM_DeleteAccessKey_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the DeleteAccessKey Choreo.
     *
     * @param Temboo_Session $session The session that owns this DeleteAccessKey execution.
     * @param Amazon_IAM_DeleteAccessKey $choreo The choreography object for this execution.
     * @param Amazon_IAM_DeleteAccessKey_Inputs|array $inputs (optional) Inputs as Amazon_IAM_DeleteAccessKey_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_IAM_DeleteAccessKey_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_IAM_DeleteAccessKey $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this DeleteAccessKey execution.
     *
     * @return Amazon_IAM_DeleteAccessKey_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this DeleteAccessKey execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_IAM_DeleteAccessKey_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_IAM_DeleteAccessKey_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the DeleteAccessKey Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_IAM_DeleteAccessKey_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the DeleteAccessKey Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_IAM_DeleteAccessKey_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this DeleteAccessKey execution.
     *
     * @return string The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Deletes the specified AWS account alias.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_IAM_DeleteAccountAlias extends Temboo_Choreography
{
    /**
     * Deletes the specified AWS account alias.
     *
     * @param Temboo_Session $session The session that owns this DeleteAccountAlias Choreo.
     * @return Amazon_IAM_DeleteAccountAlias New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/IAM/DeleteAccountAlias/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this DeleteAccountAlias Choreo.
     *
     * @param Amazon_IAM_DeleteAccountAlias_Inputs|array $inputs (optional) Inputs as Amazon_IAM_DeleteAccountAlias_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_IAM_DeleteAccountAlias_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_IAM_DeleteAccountAlias_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this DeleteAccountAlias Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_IAM_DeleteAccountAlias_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_IAM_DeleteAccountAlias_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the DeleteAccountAlias Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_IAM_DeleteAccountAlias_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the DeleteAccountAlias Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_IAM_DeleteAccountAlias_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this DeleteAccountAlias input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_IAM_DeleteAccountAlias_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_IAM_DeleteAccountAlias_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AWSAccessKeyId input for this DeleteAccountAlias Choreo.
     *
     * @param string $value (required, string) The Access Key ID provided by Amazon Web Services.
     * @return Amazon_IAM_DeleteAccountAlias_Inputs For method chaining.
     */
    public function setAWSAccessKeyId($value)
    {
        return $this->set('AWSAccessKeyId', $value);
    }

    /**
     * Set the value for the AWSSecretKeyId input for this DeleteAccountAlias Choreo.
     *
     * @param string $value (required, string) The Secret Key ID provided by Amazon Web Services.
     * @return Amazon_IAM_DeleteAccountAlias_Inputs For method chaining.
     */
    public function setAWSSecretKeyId($value)
    {
        return $this->set('AWSSecretKeyId', $value);
    }

    /**
     * Set the value for the AccountAlias input for this DeleteAccountAlias Choreo.
     *
     * @param string $value (required, string) Name of the account alias to delete.
     * @return Amazon_IAM_DeleteAccountAlias_Inputs For method chaining.
     */
    public function setAccountAlias($value)
    {
        return $this->set('AccountAlias', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this DeleteAccountAlias Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
     * @return Amazon_IAM_DeleteAccountAlias_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }
}


/**
 * Execution object for the DeleteAccountAlias Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_IAM_DeleteAccountAlias_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the DeleteAccountAlias Choreo.
     *
     * @param Temboo_Session $session The session that owns this DeleteAccountAlias execution.
     * @param Amazon_IAM_DeleteAccountAlias $choreo The choreography object for this execution.
     * @param Amazon_IAM_DeleteAccountAlias_Inputs|array $inputs (optional) Inputs as Amazon_IAM_DeleteAccountAlias_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_IAM_DeleteAccountAlias_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_IAM_DeleteAccountAlias $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this DeleteAccountAlias execution.
     *
     * @return Amazon_IAM_DeleteAccountAlias_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this DeleteAccountAlias execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_IAM_DeleteAccountAlias_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_IAM_DeleteAccountAlias_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the DeleteAccountAlias Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_IAM_DeleteAccountAlias_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the DeleteAccountAlias Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_IAM_DeleteAccountAlias_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this DeleteAccountAlias execution.
     *
     * @return string The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Deletes the password policy for the AWS account.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_IAM_DeleteAccountPasswordPolicy extends Temboo_Choreography
{
    /**
     * Deletes the password policy for the AWS account.
     *
     * @param Temboo_Session $session The session that owns this DeleteAccountPasswordPolicy Choreo.
     * @return Amazon_IAM_DeleteAccountPasswordPolicy New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/IAM/DeleteAccountPasswordPolicy/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this DeleteAccountPasswordPolicy Choreo.
     *
     * @param Amazon_IAM_DeleteAccountPasswordPolicy_Inputs|array $inputs (optional) Inputs as Amazon_IAM_DeleteAccountPasswordPolicy_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_IAM_DeleteAccountPasswordPolicy_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_IAM_DeleteAccountPasswordPolicy_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this DeleteAccountPasswordPolicy Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_IAM_DeleteAccountPasswordPolicy_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_IAM_DeleteAccountPasswordPolicy_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the DeleteAccountPasswordPolicy Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_IAM_DeleteAccountPasswordPolicy_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the DeleteAccountPasswordPolicy Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_IAM_DeleteAccountPasswordPolicy_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this DeleteAccountPasswordPolicy input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_IAM_DeleteAccountPasswordPolicy_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_IAM_DeleteAccountPasswordPolicy_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AWSAccessKeyId input for this DeleteAccountPasswordPolicy Choreo.
     *
     * @param string $value (required, string) The Access Key ID provided by Amazon Web Services.
     * @return Amazon_IAM_DeleteAccountPasswordPolicy_Inputs For method chaining.
     */
    public function setAWSAccessKeyId($value)
    {
        return $this->set('AWSAccessKeyId', $value);
    }

    /**
     * Set the value for the AWSSecretKeyId input for this DeleteAccountPasswordPolicy Choreo.
     *
     * @param string $value (required, string) The Secret Key ID provided by Amazon Web Services.
     * @return Amazon_IAM_DeleteAccountPasswordPolicy_Inputs For method chaining.
     */
    public function setAWSSecretKeyId($value)
    {
        return $this->set('AWSSecretKeyId', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this DeleteAccountPasswordPolicy Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
     * @return Amazon_IAM_DeleteAccountPasswordPolicy_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }
}


/**
 * Execution object for the DeleteAccountPasswordPolicy Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_IAM_DeleteAccountPasswordPolicy_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the DeleteAccountPasswordPolicy Choreo.
     *
     * @param Temboo_Session $session The session that owns this DeleteAccountPasswordPolicy execution.
     * @param Amazon_IAM_DeleteAccountPasswordPolicy $choreo The choreography object for this execution.
     * @param Amazon_IAM_DeleteAccountPasswordPolicy_Inputs|array $inputs (optional) Inputs as Amazon_IAM_DeleteAccountPasswordPolicy_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_IAM_DeleteAccountPasswordPolicy_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_IAM_DeleteAccountPasswordPolicy $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this DeleteAccountPasswordPolicy execution.
     *
     * @return Amazon_IAM_DeleteAccountPasswordPolicy_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this DeleteAccountPasswordPolicy execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_IAM_DeleteAccountPasswordPolicy_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_IAM_DeleteAccountPasswordPolicy_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the DeleteAccountPasswordPolicy Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_IAM_DeleteAccountPasswordPolicy_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the DeleteAccountPasswordPolicy Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_IAM_DeleteAccountPasswordPolicy_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this DeleteAccountPasswordPolicy execution.
     *
     * @return string The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Deletes a specified group.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_IAM_DeleteGroup extends Temboo_Choreography
{
    /**
     * Deletes a specified group.
     *
     * @param Temboo_Session $session The session that owns this DeleteGroup Choreo.
     * @return Amazon_IAM_DeleteGroup New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/IAM/DeleteGroup/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this DeleteGroup Choreo.
     *
     * @param Amazon_IAM_DeleteGroup_Inputs|array $inputs (optional) Inputs as Amazon_IAM_DeleteGroup_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_IAM_DeleteGroup_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_IAM_DeleteGroup_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this DeleteGroup Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_IAM_DeleteGroup_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_IAM_DeleteGroup_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the DeleteGroup Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_IAM_DeleteGroup_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the DeleteGroup Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_IAM_DeleteGroup_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this DeleteGroup input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_IAM_DeleteGroup_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_IAM_DeleteGroup_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AWSAccessKeyId input for this DeleteGroup Choreo.
     *
     * @param string $value (required, string) The Access Key ID provided by Amazon Web Services.
     * @return Amazon_IAM_DeleteGroup_Inputs For method chaining.
     */
    public function setAWSAccessKeyId($value)
    {
        return $this->set('AWSAccessKeyId', $value);
    }

    /**
     * Set the value for the AWSSecretKeyId input for this DeleteGroup Choreo.
     *
     * @param string $value (required, string) The Secret Key ID provided by Amazon Web Services.
     * @return Amazon_IAM_DeleteGroup_Inputs For method chaining.
     */
    public function setAWSSecretKeyId($value)
    {
        return $this->set('AWSSecretKeyId', $value);
    }

    /**
     * Set the value for the GroupName input for this DeleteGroup Choreo.
     *
     * @param string $value (required, string) The name of the group to delete.
     * @return Amazon_IAM_DeleteGroup_Inputs For method chaining.
     */
    public function setGroupName($value)
    {
        return $this->set('GroupName', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this DeleteGroup Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
     * @return Amazon_IAM_DeleteGroup_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }
}


/**
 * Execution object for the DeleteGroup Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_IAM_DeleteGroup_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the DeleteGroup Choreo.
     *
     * @param Temboo_Session $session The session that owns this DeleteGroup execution.
     * @param Amazon_IAM_DeleteGroup $choreo The choreography object for this execution.
     * @param Amazon_IAM_DeleteGroup_Inputs|array $inputs (optional) Inputs as Amazon_IAM_DeleteGroup_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_IAM_DeleteGroup_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_IAM_DeleteGroup $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this DeleteGroup execution.
     *
     * @return Amazon_IAM_DeleteGroup_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this DeleteGroup execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_IAM_DeleteGroup_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_IAM_DeleteGroup_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the DeleteGroup Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_IAM_DeleteGroup_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the DeleteGroup Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_IAM_DeleteGroup_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this DeleteGroup execution.
     *
     * @return string The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Deletes the specified policy that is associated with the specified group.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_IAM_DeleteGroupPolicy extends Temboo_Choreography
{
    /**
     * Deletes the specified policy that is associated with the specified group.
     *
     * @param Temboo_Session $session The session that owns this DeleteGroupPolicy Choreo.
     * @return Amazon_IAM_DeleteGroupPolicy New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/IAM/DeleteGroupPolicy/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this DeleteGroupPolicy Choreo.
     *
     * @param Amazon_IAM_DeleteGroupPolicy_Inputs|array $inputs (optional) Inputs as Amazon_IAM_DeleteGroupPolicy_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_IAM_DeleteGroupPolicy_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_IAM_DeleteGroupPolicy_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this DeleteGroupPolicy Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_IAM_DeleteGroupPolicy_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_IAM_DeleteGroupPolicy_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the DeleteGroupPolicy Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_IAM_DeleteGroupPolicy_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the DeleteGroupPolicy Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_IAM_DeleteGroupPolicy_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this DeleteGroupPolicy input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_IAM_DeleteGroupPolicy_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_IAM_DeleteGroupPolicy_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AWSAccessKeyId input for this DeleteGroupPolicy Choreo.
     *
     * @param string $value (required, string) The Access Key ID provided by Amazon Web Services.
     * @return Amazon_IAM_DeleteGroupPolicy_Inputs For method chaining.
     */
    public function setAWSAccessKeyId($value)
    {
        return $this->set('AWSAccessKeyId', $value);
    }

    /**
     * Set the value for the AWSSecretKeyId input for this DeleteGroupPolicy Choreo.
     *
     * @param string $value (required, string) The Secret Key ID provided by Amazon Web Services.
     * @return Amazon_IAM_DeleteGroupPolicy_Inputs For method chaining.
     */
    public function setAWSSecretKeyId($value)
    {
        return $this->set('AWSSecretKeyId', $value);
    }

    /**
     * Set the value for the GroupName input for this DeleteGroupPolicy Choreo.
     *
     * @param string $value (required, string) Name of the group the policy is associated with.
     * @return Amazon_IAM_DeleteGroupPolicy_Inputs For method chaining.
     */
    public function setGroupName($value)
    {
        return $this->set('GroupName', $value);
    }

    /**
     * Set the value for the PolicyName input for this DeleteGroupPolicy Choreo.
     *
     * @param string $value (required, string) Name of the policy document.
     * @return Amazon_IAM_DeleteGroupPolicy_Inputs For method chaining.
     */
    public function setPolicyName($value)
    {
        return $this->set('PolicyName', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this DeleteGroupPolicy Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
     * @return Amazon_IAM_DeleteGroupPolicy_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }
}


/**
 * Execution object for the DeleteGroupPolicy Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_IAM_DeleteGroupPolicy_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the DeleteGroupPolicy Choreo.
     *
     * @param Temboo_Session $session The session that owns this DeleteGroupPolicy execution.
     * @param Amazon_IAM_DeleteGroupPolicy $choreo The choreography object for this execution.
     * @param Amazon_IAM_DeleteGroupPolicy_Inputs|array $inputs (optional) Inputs as Amazon_IAM_DeleteGroupPolicy_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_IAM_DeleteGroupPolicy_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Amazon_IAM_DeleteGroupPolicy $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this DeleteGroupPolicy execution.
     *
     * @return Amazon_IAM_DeleteGroupPolicy_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this DeleteGroupPolicy execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Amazon_IAM_DeleteGroupPolicy_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Amazon_IAM_DeleteGroupPolicy_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the DeleteGroupPolicy Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_IAM_DeleteGroupPolicy_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the DeleteGroupPolicy Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Amazon_IAM_DeleteGroupPolicy_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Response" output from this DeleteGroupPolicy execution.
     *
     * @return string The response from Amazon.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Deletes the specified instance profile. 
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_IAM_DeleteInstanceProfile extends Temboo_Choreography
{
    /**
     * Deletes the specified instance profile. 
     *
     * @param Temboo_Session $session The session that owns this DeleteInstanceProfile Choreo.
     * @return Amazon_IAM_DeleteInstanceProfile New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Amazon/IAM/DeleteInstanceProfile/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this DeleteInstanceProfile Choreo.
     *
     * @param Amazon_IAM_DeleteInstanceProfile_Inputs|array $inputs (optional) Inputs as Amazon_IAM_DeleteInstanceProfile_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Amazon_IAM_DeleteInstanceProfile_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Amazon_IAM_DeleteInstanceProfile_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this DeleteInstanceProfile Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_IAM_DeleteInstanceProfile_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Amazon_IAM_DeleteInstanceProfile_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the DeleteInstanceProfile Choreo.
 *
 * @package Temboo
 * @subpackage Amazon
 */
class Amazon_IAM_DeleteInstanceProfile_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the DeleteInstanceProfile Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Amazon_IAM_DeleteInstanceProfile_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this DeleteInstanceProfile input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Amazon_IAM_DeleteInstanceProfile_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Amazon_IAM_DeleteInstanceProfile_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AWSAccessKeyId input for this DeleteInstanceProfile Choreo.
     *
     * @param string $value (required, string) The Access Key ID provided by Amazon Web Services.
     * @return Amazon_IAM_DeleteInstanceProfile_Inputs For method chaining.
     */
    public function setAWSAccessKeyId($value)
    {
        return $this->set('AWSAccessKeyId', $value);
    }

    /**
     * Set the value for the AWSSecretKeyId input for this DeleteInstanceProfile Choreo.
     *
     * @param string $value (required, string) The Secret Key ID provided by Amazon Web Services.
     * @return Amazon_IAM_DeleteInstanceProfile_Inputs For method chaining.
     */
    public function setAWSSecretKeyId($value)
    {
        return $this->set('AWSSecretKeyId', $value);
    }

    /**
     * Set the value for the InstanceProfileName input for this DeleteInstanceProfile Choreo.
     *
     * @param string $value (required, string) Name of the instance profile to delete.
     * @return Amazon_IAM_DeleteInstanceProfile_Inputs For method chaining.
     */
    public function setInstanceProfileN