<?php

/**
 * Temboo PHP SDK YouTube classes
 *
 * Execute Choreographies from the Temboo YouTube bundle.
 *
 * PHP version 5
 *
 * LICENSE: Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   Services
 * @package    Temboo
 * @subpackage YouTube
 * @author     Temboo, Inc.
 * @copyright  2013 Temboo, Inc.
 * @license    http://www.apache.org/licenses/LICENSE-2.0 Apache License 2.0
 * @link       http://www.temboo.com
 */
/**
 * Posts a bulletin for a specific channel.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Activities_InsertActivity extends Temboo_Choreography
{
    /**
     * Posts a bulletin for a specific channel.
     *
     * @param Temboo_Session $session The session that owns this InsertActivity Choreo.
     * @return YouTube_Activities_InsertActivity New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/YouTube/Activities/InsertActivity/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this InsertActivity Choreo.
     *
     * @param YouTube_Activities_InsertActivity_Inputs|array $inputs (optional) Inputs as YouTube_Activities_InsertActivity_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return YouTube_Activities_InsertActivity_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new YouTube_Activities_InsertActivity_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this InsertActivity Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return YouTube_Activities_InsertActivity_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new YouTube_Activities_InsertActivity_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the InsertActivity Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Activities_InsertActivity_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the InsertActivity Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return YouTube_Activities_InsertActivity_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this InsertActivity input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return YouTube_Activities_InsertActivity_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return YouTube_Activities_InsertActivity_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the ActivityMetadata input for this InsertActivity Choreo.
     *
     * @param string $value (required, json) A JSON representation of the activity resource to create. See documentation for examples.
     * @return YouTube_Activities_InsertActivity_Inputs For method chaining.
     */
    public function setActivityMetadata($value)
    {
        return $this->set('ActivityMetadata', $value);
    }

    /**
     * Set the value for the AccessToken input for this InsertActivity Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required for OAuth authentication unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return YouTube_Activities_InsertActivity_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this InsertActivity Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_Activities_InsertActivity_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this InsertActivity Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_Activities_InsertActivity_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Fields input for this InsertActivity Choreo.
     *
     * @param string $value (optional, string) Allows you to specify a subset of fields to include in the response using an xpath-like syntax (i.e. items/snippet/title).
     * @return YouTube_Activities_InsertActivity_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Part input for this InsertActivity Choreo.
     *
     * @param string $value (optional, string) A comma-separated list of fields that are being set and that will be returned in the response. Part names that can be passed are: snippet and contentDetails.
     * @return YouTube_Activities_InsertActivity_Inputs For method chaining.
     */
    public function setPart($value)
    {
        return $this->set('Part', $value);
    }

    /**
     * Set the value for the RefreshToken input for this InsertActivity Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_Activities_InsertActivity_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }
}


/**
 * Execution object for the InsertActivity Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Activities_InsertActivity_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the InsertActivity Choreo.
     *
     * @param Temboo_Session $session The session that owns this InsertActivity execution.
     * @param YouTube_Activities_InsertActivity $choreo The choreography object for this execution.
     * @param YouTube_Activities_InsertActivity_Inputs|array $inputs (optional) Inputs as YouTube_Activities_InsertActivity_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return YouTube_Activities_InsertActivity_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, YouTube_Activities_InsertActivity $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this InsertActivity execution.
     *
     * @return YouTube_Activities_InsertActivity_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this InsertActivity execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return YouTube_Activities_InsertActivity_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new YouTube_Activities_InsertActivity_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the InsertActivity Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Activities_InsertActivity_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the InsertActivity Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return YouTube_Activities_InsertActivity_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this InsertActivity execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this InsertActivity execution.
     *
     * @return string (json) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Returns a list of activities for a specified channel.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Activities_ListActivitiesByChannel extends Temboo_Choreography
{
    /**
     * Returns a list of activities for a specified channel.
     *
     * @param Temboo_Session $session The session that owns this ListActivitiesByChannel Choreo.
     * @return YouTube_Activities_ListActivitiesByChannel New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/YouTube/Activities/ListActivitiesByChannel/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this ListActivitiesByChannel Choreo.
     *
     * @param YouTube_Activities_ListActivitiesByChannel_Inputs|array $inputs (optional) Inputs as YouTube_Activities_ListActivitiesByChannel_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return YouTube_Activities_ListActivitiesByChannel_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new YouTube_Activities_ListActivitiesByChannel_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this ListActivitiesByChannel Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return YouTube_Activities_ListActivitiesByChannel_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new YouTube_Activities_ListActivitiesByChannel_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the ListActivitiesByChannel Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Activities_ListActivitiesByChannel_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the ListActivitiesByChannel Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return YouTube_Activities_ListActivitiesByChannel_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this ListActivitiesByChannel input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return YouTube_Activities_ListActivitiesByChannel_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return YouTube_Activities_ListActivitiesByChannel_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the APIKey input for this ListActivitiesByChannel Choreo.
     *
     * @param string $value (optional, string) The API Key provided by Google for simple API access when you do not need to access user data.
     * @return YouTube_Activities_ListActivitiesByChannel_Inputs For method chaining.
     */
    public function setAPIKey($value)
    {
        return $this->set('APIKey', $value);
    }

    /**
     * Set the value for the AccessToken input for this ListActivitiesByChannel Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required for OAuth authentication unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return YouTube_Activities_ListActivitiesByChannel_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ChannelID input for this ListActivitiesByChannel Choreo.
     *
     * @param string $value (required, string) The id of the channel to list activities for.
     * @return YouTube_Activities_ListActivitiesByChannel_Inputs For method chaining.
     */
    public function setChannelID($value)
    {
        return $this->set('ChannelID', $value);
    }

    /**
     * Set the value for the ClientID input for this ListActivitiesByChannel Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_Activities_ListActivitiesByChannel_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this ListActivitiesByChannel Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_Activities_ListActivitiesByChannel_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Fields input for this ListActivitiesByChannel Choreo.
     *
     * @param string $value (optional, string) Allows you to specify a subset of fields to include in the response using an xpath-like syntax (i.e. items/snippet/title).
     * @return YouTube_Activities_ListActivitiesByChannel_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the MaxResults input for this ListActivitiesByChannel Choreo.
     *
     * @param int $value (optional, integer) The maximum number of results to return.
     * @return YouTube_Activities_ListActivitiesByChannel_Inputs For method chaining.
     */
    public function setMaxResults($value)
    {
        return $this->set('MaxResults', $value);
    }

    /**
     * Set the value for the PageToken input for this ListActivitiesByChannel Choreo.
     *
     * @param string $value (optional, string) The "nextPageToken" found in the response which is used to page through results.
     * @return YouTube_Activities_ListActivitiesByChannel_Inputs For method chaining.
     */
    public function setPageToken($value)
    {
        return $this->set('PageToken', $value);
    }

    /**
     * Set the value for the Part input for this ListActivitiesByChannel Choreo.
     *
     * @param string $value (optional, string) Specifies a comma-separated list of one or more activity resource properties that the API response will include. Part names that you can pass are id, snippet, and contentDetails.
     * @return YouTube_Activities_ListActivitiesByChannel_Inputs For method chaining.
     */
    public function setPart($value)
    {
        return $this->set('Part', $value);
    }

    /**
     * Set the value for the PublishedAfter input for this ListActivitiesByChannel Choreo.
     *
     * @param string $value (optional, date) Returns only results created after the specified time (formatted as a RFC 3339 date-time i.e. 1970-01-01T00:00:00Z).
     * @return YouTube_Activities_ListActivitiesByChannel_Inputs For method chaining.
     */
    public function setPublishedAfter($value)
    {
        return $this->set('PublishedAfter', $value);
    }

    /**
     * Set the value for the PublishedBefore input for this ListActivitiesByChannel Choreo.
     *
     * @param string $value (optional, date) Returns only results created before the specified time (formatted as a RFC 3339 date-time i.e. 1970-01-01T00:00:00Z).
     * @return YouTube_Activities_ListActivitiesByChannel_Inputs For method chaining.
     */
    public function setPublishedBefore($value)
    {
        return $this->set('PublishedBefore', $value);
    }

    /**
     * Set the value for the RefreshToken input for this ListActivitiesByChannel Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_Activities_ListActivitiesByChannel_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }
}


/**
 * Execution object for the ListActivitiesByChannel Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Activities_ListActivitiesByChannel_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the ListActivitiesByChannel Choreo.
     *
     * @param Temboo_Session $session The session that owns this ListActivitiesByChannel execution.
     * @param YouTube_Activities_ListActivitiesByChannel $choreo The choreography object for this execution.
     * @param YouTube_Activities_ListActivitiesByChannel_Inputs|array $inputs (optional) Inputs as YouTube_Activities_ListActivitiesByChannel_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return YouTube_Activities_ListActivitiesByChannel_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, YouTube_Activities_ListActivitiesByChannel $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this ListActivitiesByChannel execution.
     *
     * @return YouTube_Activities_ListActivitiesByChannel_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this ListActivitiesByChannel execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return YouTube_Activities_ListActivitiesByChannel_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new YouTube_Activities_ListActivitiesByChannel_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the ListActivitiesByChannel Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Activities_ListActivitiesByChannel_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the ListActivitiesByChannel Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return YouTube_Activities_ListActivitiesByChannel_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this ListActivitiesByChannel execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this ListActivitiesByChannel execution.
     *
     * @return string (json) The response from YouTube.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Returns an activity feed that displays on the YouTube home page for the currently authenticated user.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Activities_ListHomePageActivities extends Temboo_Choreography
{
    /**
     * Returns an activity feed that displays on the YouTube home page for the currently authenticated user.
     *
     * @param Temboo_Session $session The session that owns this ListHomePageActivities Choreo.
     * @return YouTube_Activities_ListHomePageActivities New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/YouTube/Activities/ListHomePageActivities/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this ListHomePageActivities Choreo.
     *
     * @param YouTube_Activities_ListHomePageActivities_Inputs|array $inputs (optional) Inputs as YouTube_Activities_ListHomePageActivities_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return YouTube_Activities_ListHomePageActivities_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new YouTube_Activities_ListHomePageActivities_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this ListHomePageActivities Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return YouTube_Activities_ListHomePageActivities_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new YouTube_Activities_ListHomePageActivities_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the ListHomePageActivities Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Activities_ListHomePageActivities_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the ListHomePageActivities Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return YouTube_Activities_ListHomePageActivities_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this ListHomePageActivities input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return YouTube_Activities_ListHomePageActivities_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return YouTube_Activities_ListHomePageActivities_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this ListHomePageActivities Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required for OAuth authentication unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return YouTube_Activities_ListHomePageActivities_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this ListHomePageActivities Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_Activities_ListHomePageActivities_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this ListHomePageActivities Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_Activities_ListHomePageActivities_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Fields input for this ListHomePageActivities Choreo.
     *
     * @param string $value (optional, string) Allows you to specify a subset of fields to include in the response using an xpath-like syntax (i.e. items/snippet/title).
     * @return YouTube_Activities_ListHomePageActivities_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the MaxResults input for this ListHomePageActivities Choreo.
     *
     * @param int $value (optional, integer) The maximum number of results to return.
     * @return YouTube_Activities_ListHomePageActivities_Inputs For method chaining.
     */
    public function setMaxResults($value)
    {
        return $this->set('MaxResults', $value);
    }

    /**
     * Set the value for the PageToken input for this ListHomePageActivities Choreo.
     *
     * @param string $value (optional, string) The "nextPageToken" found in the response which is used to page through results.
     * @return YouTube_Activities_ListHomePageActivities_Inputs For method chaining.
     */
    public function setPageToken($value)
    {
        return $this->set('PageToken', $value);
    }

    /**
     * Set the value for the Part input for this ListHomePageActivities Choreo.
     *
     * @param string $value (optional, string) Specifies a comma-separated list of one or more activity resource properties that the API response will include. Part names that you can pass are id, snippet, and contentDetails.
     * @return YouTube_Activities_ListHomePageActivities_Inputs For method chaining.
     */
    public function setPart($value)
    {
        return $this->set('Part', $value);
    }

    /**
     * Set the value for the PublishedAfter input for this ListHomePageActivities Choreo.
     *
     * @param string $value (optional, date) Returns only results created after the specified time (formatted as a RFC 3339 date-time i.e. 1970-01-01T00:00:00Z).
     * @return YouTube_Activities_ListHomePageActivities_Inputs For method chaining.
     */
    public function setPublishedAfter($value)
    {
        return $this->set('PublishedAfter', $value);
    }

    /**
     * Set the value for the PublishedBefore input for this ListHomePageActivities Choreo.
     *
     * @param string $value (optional, date) Returns only results created before the specified time (formatted as a RFC 3339 date-time i.e. 1970-01-01T00:00:00Z).
     * @return YouTube_Activities_ListHomePageActivities_Inputs For method chaining.
     */
    public function setPublishedBefore($value)
    {
        return $this->set('PublishedBefore', $value);
    }

    /**
     * Set the value for the RefreshToken input for this ListHomePageActivities Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_Activities_ListHomePageActivities_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }
}


/**
 * Execution object for the ListHomePageActivities Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Activities_ListHomePageActivities_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the ListHomePageActivities Choreo.
     *
     * @param Temboo_Session $session The session that owns this ListHomePageActivities execution.
     * @param YouTube_Activities_ListHomePageActivities $choreo The choreography object for this execution.
     * @param YouTube_Activities_ListHomePageActivities_Inputs|array $inputs (optional) Inputs as YouTube_Activities_ListHomePageActivities_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return YouTube_Activities_ListHomePageActivities_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, YouTube_Activities_ListHomePageActivities $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this ListHomePageActivities execution.
     *
     * @return YouTube_Activities_ListHomePageActivities_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this ListHomePageActivities execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return YouTube_Activities_ListHomePageActivities_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new YouTube_Activities_ListHomePageActivities_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the ListHomePageActivities Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Activities_ListHomePageActivities_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the ListHomePageActivities Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return YouTube_Activities_ListHomePageActivities_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this ListHomePageActivities execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this ListHomePageActivities execution.
     *
     * @return string (json) The response from YouTube.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Returns a list of activity events for the authenticated user.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Activities_ListMyActivities extends Temboo_Choreography
{
    /**
     * Returns a list of activity events for the authenticated user.
     *
     * @param Temboo_Session $session The session that owns this ListMyActivities Choreo.
     * @return YouTube_Activities_ListMyActivities New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/YouTube/Activities/ListMyActivities/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this ListMyActivities Choreo.
     *
     * @param YouTube_Activities_ListMyActivities_Inputs|array $inputs (optional) Inputs as YouTube_Activities_ListMyActivities_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return YouTube_Activities_ListMyActivities_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new YouTube_Activities_ListMyActivities_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this ListMyActivities Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return YouTube_Activities_ListMyActivities_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new YouTube_Activities_ListMyActivities_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the ListMyActivities Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Activities_ListMyActivities_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the ListMyActivities Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return YouTube_Activities_ListMyActivities_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this ListMyActivities input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return YouTube_Activities_ListMyActivities_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return YouTube_Activities_ListMyActivities_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this ListMyActivities Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required for OAuth authentication unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return YouTube_Activities_ListMyActivities_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this ListMyActivities Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_Activities_ListMyActivities_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this ListMyActivities Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_Activities_ListMyActivities_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Fields input for this ListMyActivities Choreo.
     *
     * @param string $value (optional, string) Allows you to specify a subset of fields to include in the response using an xpath-like syntax (i.e. items/snippet/title).
     * @return YouTube_Activities_ListMyActivities_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the MaxResults input for this ListMyActivities Choreo.
     *
     * @param int $value (optional, integer) The maximum number of results to return.
     * @return YouTube_Activities_ListMyActivities_Inputs For method chaining.
     */
    public function setMaxResults($value)
    {
        return $this->set('MaxResults', $value);
    }

    /**
     * Set the value for the PageToken input for this ListMyActivities Choreo.
     *
     * @param string $value (optional, string) The "nextPageToken" found in the response which is used to page through results.
     * @return YouTube_Activities_ListMyActivities_Inputs For method chaining.
     */
    public function setPageToken($value)
    {
        return $this->set('PageToken', $value);
    }

    /**
     * Set the value for the Part input for this ListMyActivities Choreo.
     *
     * @param string $value (optional, string) Specifies a comma-separated list of one or more activity resource properties that the API response will include. Part names that you can pass are id, snippet, and contentDetails.
     * @return YouTube_Activities_ListMyActivities_Inputs For method chaining.
     */
    public function setPart($value)
    {
        return $this->set('Part', $value);
    }

    /**
     * Set the value for the PublishedAfter input for this ListMyActivities Choreo.
     *
     * @param string $value (optional, date) Returns only results created after the specified time (formatted as a RFC 3339 date-time i.e. 1970-01-01T00:00:00Z).
     * @return YouTube_Activities_ListMyActivities_Inputs For method chaining.
     */
    public function setPublishedAfter($value)
    {
        return $this->set('PublishedAfter', $value);
    }

    /**
     * Set the value for the PublishedBefore input for this ListMyActivities Choreo.
     *
     * @param string $value (optional, date) Returns only results created before the specified time (formatted as a RFC 3339 date-time i.e. 1970-01-01T00:00:00Z).
     * @return YouTube_Activities_ListMyActivities_Inputs For method chaining.
     */
    public function setPublishedBefore($value)
    {
        return $this->set('PublishedBefore', $value);
    }

    /**
     * Set the value for the RefreshToken input for this ListMyActivities Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_Activities_ListMyActivities_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }
}


/**
 * Execution object for the ListMyActivities Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Activities_ListMyActivities_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the ListMyActivities Choreo.
     *
     * @param Temboo_Session $session The session that owns this ListMyActivities execution.
     * @param YouTube_Activities_ListMyActivities $choreo The choreography object for this execution.
     * @param YouTube_Activities_ListMyActivities_Inputs|array $inputs (optional) Inputs as YouTube_Activities_ListMyActivities_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return YouTube_Activities_ListMyActivities_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, YouTube_Activities_ListMyActivities $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this ListMyActivities execution.
     *
     * @return YouTube_Activities_ListMyActivities_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this ListMyActivities execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return YouTube_Activities_ListMyActivities_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new YouTube_Activities_ListMyActivities_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the ListMyActivities Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Activities_ListMyActivities_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the ListMyActivities Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return YouTube_Activities_ListMyActivities_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this ListMyActivities execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this ListMyActivities execution.
     *
     * @return string (json) The response from YouTube.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Returns a list of channels associated with a particular category.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Channels_ListChannelsByCategory extends Temboo_Choreography
{
    /**
     * Returns a list of channels associated with a particular category.
     *
     * @param Temboo_Session $session The session that owns this ListChannelsByCategory Choreo.
     * @return YouTube_Channels_ListChannelsByCategory New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/YouTube/Channels/ListChannelsByCategory/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this ListChannelsByCategory Choreo.
     *
     * @param YouTube_Channels_ListChannelsByCategory_Inputs|array $inputs (optional) Inputs as YouTube_Channels_ListChannelsByCategory_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return YouTube_Channels_ListChannelsByCategory_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new YouTube_Channels_ListChannelsByCategory_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this ListChannelsByCategory Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return YouTube_Channels_ListChannelsByCategory_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new YouTube_Channels_ListChannelsByCategory_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the ListChannelsByCategory Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Channels_ListChannelsByCategory_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the ListChannelsByCategory Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return YouTube_Channels_ListChannelsByCategory_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this ListChannelsByCategory input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return YouTube_Channels_ListChannelsByCategory_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return YouTube_Channels_ListChannelsByCategory_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the APIKey input for this ListChannelsByCategory Choreo.
     *
     * @param string $value (optional, string) The API Key provided by Google for simple API access when you do not need to access user data.
     * @return YouTube_Channels_ListChannelsByCategory_Inputs For method chaining.
     */
    public function setAPIKey($value)
    {
        return $this->set('APIKey', $value);
    }

    /**
     * Set the value for the AccessToken input for this ListChannelsByCategory Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required for OAuth authentication unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return YouTube_Channels_ListChannelsByCategory_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the CategoryID input for this ListChannelsByCategory Choreo.
     *
     * @param string $value (required, string) The id of a category. Indicates that only channels associated with a particular category should be returned.
     * @return YouTube_Channels_ListChannelsByCategory_Inputs For method chaining.
     */
    public function setCategoryID($value)
    {
        return $this->set('CategoryID', $value);
    }

    /**
     * Set the value for the ClientID input for this ListChannelsByCategory Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_Channels_ListChannelsByCategory_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this ListChannelsByCategory Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_Channels_ListChannelsByCategory_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Fields input for this ListChannelsByCategory Choreo.
     *
     * @param string $value (optional, string) Allows you to specify a subset of fields to include in the response using an xpath-like syntax (i.e. items/snippet/title).
     * @return YouTube_Channels_ListChannelsByCategory_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the MaxResults input for this ListChannelsByCategory Choreo.
     *
     * @param int $value (optional, integer) The maximum number of results to return.
     * @return YouTube_Channels_ListChannelsByCategory_Inputs For method chaining.
     */
    public function setMaxResults($value)
    {
        return $this->set('MaxResults', $value);
    }

    /**
     * Set the value for the PageToken input for this ListChannelsByCategory Choreo.
     *
     * @param string $value (optional, string) The "nextPageToken" found in the response which is used to page through results.
     * @return YouTube_Channels_ListChannelsByCategory_Inputs For method chaining.
     */
    public function setPageToken($value)
    {
        return $this->set('PageToken', $value);
    }

    /**
     * Set the value for the Part input for this ListChannelsByCategory Choreo.
     *
     * @param string $value (optional, string) Specifies a comma-separated list of channels resource properties that the API response will include. Part names that you can pass are: id, snippet, contentDetails, statistics, and topicDetails.
     * @return YouTube_Channels_ListChannelsByCategory_Inputs For method chaining.
     */
    public function setPart($value)
    {
        return $this->set('Part', $value);
    }

    /**
     * Set the value for the RefreshToken input for this ListChannelsByCategory Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_Channels_ListChannelsByCategory_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }
}


/**
 * Execution object for the ListChannelsByCategory Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Channels_ListChannelsByCategory_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the ListChannelsByCategory Choreo.
     *
     * @param Temboo_Session $session The session that owns this ListChannelsByCategory execution.
     * @param YouTube_Channels_ListChannelsByCategory $choreo The choreography object for this execution.
     * @param YouTube_Channels_ListChannelsByCategory_Inputs|array $inputs (optional) Inputs as YouTube_Channels_ListChannelsByCategory_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return YouTube_Channels_ListChannelsByCategory_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, YouTube_Channels_ListChannelsByCategory $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this ListChannelsByCategory execution.
     *
     * @return YouTube_Channels_ListChannelsByCategory_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this ListChannelsByCategory execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return YouTube_Channels_ListChannelsByCategory_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new YouTube_Channels_ListChannelsByCategory_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the ListChannelsByCategory Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Channels_ListChannelsByCategory_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the ListChannelsByCategory Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return YouTube_Channels_ListChannelsByCategory_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this ListChannelsByCategory execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this ListChannelsByCategory execution.
     *
     * @return string (json) The response from YouTube.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Returns a list of channels that match the list of IDs provided.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Channels_ListChannelsByID extends Temboo_Choreography
{
    /**
     * Returns a list of channels that match the list of IDs provided.
     *
     * @param Temboo_Session $session The session that owns this ListChannelsByID Choreo.
     * @return YouTube_Channels_ListChannelsByID New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/YouTube/Channels/ListChannelsByID/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this ListChannelsByID Choreo.
     *
     * @param YouTube_Channels_ListChannelsByID_Inputs|array $inputs (optional) Inputs as YouTube_Channels_ListChannelsByID_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return YouTube_Channels_ListChannelsByID_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new YouTube_Channels_ListChannelsByID_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this ListChannelsByID Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return YouTube_Channels_ListChannelsByID_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new YouTube_Channels_ListChannelsByID_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the ListChannelsByID Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Channels_ListChannelsByID_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the ListChannelsByID Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return YouTube_Channels_ListChannelsByID_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this ListChannelsByID input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return YouTube_Channels_ListChannelsByID_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return YouTube_Channels_ListChannelsByID_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the APIKey input for this ListChannelsByID Choreo.
     *
     * @param string $value (optional, string) The API Key provided by Google for simple API access when you do not need to access user data.
     * @return YouTube_Channels_ListChannelsByID_Inputs For method chaining.
     */
    public function setAPIKey($value)
    {
        return $this->set('APIKey', $value);
    }

    /**
     * Set the value for the AccessToken input for this ListChannelsByID Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required for OAuth authentication unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return YouTube_Channels_ListChannelsByID_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ChannelID input for this ListChannelsByID Choreo.
     *
     * @param string $value (required, string) A comma-separated list of the YouTube channel ID(s) for the resource(s) that are being retrieved.
     * @return YouTube_Channels_ListChannelsByID_Inputs For method chaining.
     */
    public function setChannelID($value)
    {
        return $this->set('ChannelID', $value);
    }

    /**
     * Set the value for the ClientID input for this ListChannelsByID Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_Channels_ListChannelsByID_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this ListChannelsByID Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_Channels_ListChannelsByID_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Fields input for this ListChannelsByID Choreo.
     *
     * @param string $value (optional, string) Allows you to specify a subset of fields to include in the response using an xpath-like syntax (i.e. items/snippet/title).
     * @return YouTube_Channels_ListChannelsByID_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the MaxResults input for this ListChannelsByID Choreo.
     *
     * @param int $value (optional, integer) The maximum number of results to return.
     * @return YouTube_Channels_ListChannelsByID_Inputs For method chaining.
     */
    public function setMaxResults($value)
    {
        return $this->set('MaxResults', $value);
    }

    /**
     * Set the value for the PageToken input for this ListChannelsByID Choreo.
     *
     * @param string $value (optional, string) The "nextPageToken" found in the response which is used to page through results.
     * @return YouTube_Channels_ListChannelsByID_Inputs For method chaining.
     */
    public function setPageToken($value)
    {
        return $this->set('PageToken', $value);
    }

    /**
     * Set the value for the Part input for this ListChannelsByID Choreo.
     *
     * @param string $value (optional, string) Specifies a comma-separated list of channels resource properties that the API response will include. Part names that you can pass are: id, snippet, contentDetails, statistics, and topicDetails.
     * @return YouTube_Channels_ListChannelsByID_Inputs For method chaining.
     */
    public function setPart($value)
    {
        return $this->set('Part', $value);
    }

    /**
     * Set the value for the RefreshToken input for this ListChannelsByID Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_Channels_ListChannelsByID_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }
}


/**
 * Execution object for the ListChannelsByID Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Channels_ListChannelsByID_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the ListChannelsByID Choreo.
     *
     * @param Temboo_Session $session The session that owns this ListChannelsByID execution.
     * @param YouTube_Channels_ListChannelsByID $choreo The choreography object for this execution.
     * @param YouTube_Channels_ListChannelsByID_Inputs|array $inputs (optional) Inputs as YouTube_Channels_ListChannelsByID_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return YouTube_Channels_ListChannelsByID_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, YouTube_Channels_ListChannelsByID $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this ListChannelsByID execution.
     *
     * @return YouTube_Channels_ListChannelsByID_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this ListChannelsByID execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return YouTube_Channels_ListChannelsByID_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new YouTube_Channels_ListChannelsByID_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the ListChannelsByID Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Channels_ListChannelsByID_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the ListChannelsByID Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return YouTube_Channels_ListChannelsByID_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this ListChannelsByID execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this ListChannelsByID execution.
     *
     * @return string (json) The response from YouTube.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Returns a list of channels owned by the authenticated user.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Channels_ListMyChannels extends Temboo_Choreography
{
    /**
     * Returns a list of channels owned by the authenticated user.
     *
     * @param Temboo_Session $session The session that owns this ListMyChannels Choreo.
     * @return YouTube_Channels_ListMyChannels New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/YouTube/Channels/ListMyChannels/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this ListMyChannels Choreo.
     *
     * @param YouTube_Channels_ListMyChannels_Inputs|array $inputs (optional) Inputs as YouTube_Channels_ListMyChannels_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return YouTube_Channels_ListMyChannels_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new YouTube_Channels_ListMyChannels_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this ListMyChannels Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return YouTube_Channels_ListMyChannels_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new YouTube_Channels_ListMyChannels_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the ListMyChannels Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Channels_ListMyChannels_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the ListMyChannels Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return YouTube_Channels_ListMyChannels_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this ListMyChannels input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return YouTube_Channels_ListMyChannels_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return YouTube_Channels_ListMyChannels_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this ListMyChannels Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required for OAuth authentication unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return YouTube_Channels_ListMyChannels_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this ListMyChannels Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_Channels_ListMyChannels_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this ListMyChannels Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_Channels_ListMyChannels_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Fields input for this ListMyChannels Choreo.
     *
     * @param string $value (optional, string) Allows you to specify a subset of fields to include in the response using an xpath-like syntax (i.e. items/snippet/title).
     * @return YouTube_Channels_ListMyChannels_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the MaxResults input for this ListMyChannels Choreo.
     *
     * @param int $value (optional, integer) The maximum number of results to return.
     * @return YouTube_Channels_ListMyChannels_Inputs For method chaining.
     */
    public function setMaxResults($value)
    {
        return $this->set('MaxResults', $value);
    }

    /**
     * Set the value for the PageToken input for this ListMyChannels Choreo.
     *
     * @param string $value (optional, string) The "nextPageToken" found in the response which is used to page through results.
     * @return YouTube_Channels_ListMyChannels_Inputs For method chaining.
     */
    public function setPageToken($value)
    {
        return $this->set('PageToken', $value);
    }

    /**
     * Set the value for the Part input for this ListMyChannels Choreo.
     *
     * @param string $value (optional, string) Specifies a comma-separated list of channels resource properties that the API response will include. Part names that you can pass are: id, snippet, contentDetails, statistics, and topicDetails.
     * @return YouTube_Channels_ListMyChannels_Inputs For method chaining.
     */
    public function setPart($value)
    {
        return $this->set('Part', $value);
    }

    /**
     * Set the value for the RefreshToken input for this ListMyChannels Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_Channels_ListMyChannels_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }
}


/**
 * Execution object for the ListMyChannels Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Channels_ListMyChannels_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the ListMyChannels Choreo.
     *
     * @param Temboo_Session $session The session that owns this ListMyChannels execution.
     * @param YouTube_Channels_ListMyChannels $choreo The choreography object for this execution.
     * @param YouTube_Channels_ListMyChannels_Inputs|array $inputs (optional) Inputs as YouTube_Channels_ListMyChannels_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return YouTube_Channels_ListMyChannels_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, YouTube_Channels_ListMyChannels $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this ListMyChannels execution.
     *
     * @return YouTube_Channels_ListMyChannels_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this ListMyChannels execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return YouTube_Channels_ListMyChannels_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new YouTube_Channels_ListMyChannels_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the ListMyChannels Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Channels_ListMyChannels_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the ListMyChannels Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return YouTube_Channels_ListMyChannels_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this ListMyChannels execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this ListMyChannels execution.
     *
     * @return string (json) The response from YouTube.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Returns a list of channels that have subscribed to the authenticated user's channel.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Channels_ListMySubscribers extends Temboo_Choreography
{
    /**
     * Returns a list of channels that have subscribed to the authenticated user's channel.
     *
     * @param Temboo_Session $session The session that owns this ListMySubscribers Choreo.
     * @return YouTube_Channels_ListMySubscribers New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/YouTube/Channels/ListMySubscribers/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this ListMySubscribers Choreo.
     *
     * @param YouTube_Channels_ListMySubscribers_Inputs|array $inputs (optional) Inputs as YouTube_Channels_ListMySubscribers_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return YouTube_Channels_ListMySubscribers_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new YouTube_Channels_ListMySubscribers_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this ListMySubscribers Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return YouTube_Channels_ListMySubscribers_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new YouTube_Channels_ListMySubscribers_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the ListMySubscribers Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Channels_ListMySubscribers_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the ListMySubscribers Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return YouTube_Channels_ListMySubscribers_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this ListMySubscribers input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return YouTube_Channels_ListMySubscribers_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return YouTube_Channels_ListMySubscribers_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this ListMySubscribers Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required for OAuth authentication unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return YouTube_Channels_ListMySubscribers_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this ListMySubscribers Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_Channels_ListMySubscribers_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this ListMySubscribers Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_Channels_ListMySubscribers_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Fields input for this ListMySubscribers Choreo.
     *
     * @param string $value (optional, string) Allows you to specify a subset of fields to include in the response using an xpath-like syntax (i.e. items/snippet/title).
     * @return YouTube_Channels_ListMySubscribers_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the MaxResults input for this ListMySubscribers Choreo.
     *
     * @param int $value (optional, integer) The maximum number of results to return.
     * @return YouTube_Channels_ListMySubscribers_Inputs For method chaining.
     */
    public function setMaxResults($value)
    {
        return $this->set('MaxResults', $value);
    }

    /**
     * Set the value for the PageToken input for this ListMySubscribers Choreo.
     *
     * @param string $value (optional, string) The "nextPageToken" found in the response which is used to page through results.
     * @return YouTube_Channels_ListMySubscribers_Inputs For method chaining.
     */
    public function setPageToken($value)
    {
        return $this->set('PageToken', $value);
    }

    /**
     * Set the value for the Part input for this ListMySubscribers Choreo.
     *
     * @param string $value (optional, string) Specifies a comma-separated list of channels resource properties that the API response will include. Part names that you can pass are: id, snippet, contentDetails, statistics, and topicDetails.
     * @return YouTube_Channels_ListMySubscribers_Inputs For method chaining.
     */
    public function setPart($value)
    {
        return $this->set('Part', $value);
    }

    /**
     * Set the value for the RefreshToken input for this ListMySubscribers Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_Channels_ListMySubscribers_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }
}


/**
 * Execution object for the ListMySubscribers Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Channels_ListMySubscribers_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the ListMySubscribers Choreo.
     *
     * @param Temboo_Session $session The session that owns this ListMySubscribers execution.
     * @param YouTube_Channels_ListMySubscribers $choreo The choreography object for this execution.
     * @param YouTube_Channels_ListMySubscribers_Inputs|array $inputs (optional) Inputs as YouTube_Channels_ListMySubscribers_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return YouTube_Channels_ListMySubscribers_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, YouTube_Channels_ListMySubscribers $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this ListMySubscribers execution.
     *
     * @return YouTube_Channels_ListMySubscribers_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this ListMySubscribers execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return YouTube_Channels_ListMySubscribers_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new YouTube_Channels_ListMySubscribers_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the ListMySubscribers Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Channels_ListMySubscribers_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the ListMySubscribers Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return YouTube_Channels_ListMySubscribers_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this ListMySubscribers execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this ListMySubscribers execution.
     *
     * @return string (json) The response from YouTube.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Returns a list of categories that match the IDs provided.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_GuideCategories_ListGuideCategoriesByID extends Temboo_Choreography
{
    /**
     * Returns a list of categories that match the IDs provided.
     *
     * @param Temboo_Session $session The session that owns this ListGuideCategoriesByID Choreo.
     * @return YouTube_GuideCategories_ListGuideCategoriesByID New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/YouTube/GuideCategories/ListGuideCategoriesByID/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this ListGuideCategoriesByID Choreo.
     *
     * @param YouTube_GuideCategories_ListGuideCategoriesByID_Inputs|array $inputs (optional) Inputs as YouTube_GuideCategories_ListGuideCategoriesByID_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return YouTube_GuideCategories_ListGuideCategoriesByID_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new YouTube_GuideCategories_ListGuideCategoriesByID_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this ListGuideCategoriesByID Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return YouTube_GuideCategories_ListGuideCategoriesByID_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new YouTube_GuideCategories_ListGuideCategoriesByID_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the ListGuideCategoriesByID Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_GuideCategories_ListGuideCategoriesByID_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the ListGuideCategoriesByID Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return YouTube_GuideCategories_ListGuideCategoriesByID_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this ListGuideCategoriesByID input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return YouTube_GuideCategories_ListGuideCategoriesByID_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return YouTube_GuideCategories_ListGuideCategoriesByID_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the APIKey input for this ListGuideCategoriesByID Choreo.
     *
     * @param string $value (optional, string) The API Key provided by Google for simple API access when you do not need to access user data.
     * @return YouTube_GuideCategories_ListGuideCategoriesByID_Inputs For method chaining.
     */
    public function setAPIKey($value)
    {
        return $this->set('APIKey', $value);
    }

    /**
     * Set the value for the AccessToken input for this ListGuideCategoriesByID Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required for OAuth authentication unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return YouTube_GuideCategories_ListGuideCategoriesByID_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this ListGuideCategoriesByID Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_GuideCategories_ListGuideCategoriesByID_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this ListGuideCategoriesByID Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_GuideCategories_ListGuideCategoriesByID_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Fields input for this ListGuideCategoriesByID Choreo.
     *
     * @param string $value (optional, string) Allows you to specify a subset of fields to include in the response using an xpath-like syntax (i.e. items/snippet/title).
     * @return YouTube_GuideCategories_ListGuideCategoriesByID_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the GuideCategoryID input for this ListGuideCategoriesByID Choreo.
     *
     * @param string $value (conditional, string) A comma-separated list of the YouTube channel category ID(s) for the resource(s) that are being retrieved.
     * @return YouTube_GuideCategories_ListGuideCategoriesByID_Inputs For method chaining.
     */
    public function setGuideCategoryID($value)
    {
        return $this->set('GuideCategoryID', $value);
    }

    /**
     * Set the value for the H1 input for this ListGuideCategoriesByID Choreo.
     *
     * @param string $value (optional, string) The hl parameter specifies the language that should be used for text values in the API response. The default value is en_US.
     * @return YouTube_GuideCategories_ListGuideCategoriesByID_Inputs For method chaining.
     */
    public function setH1($value)
    {
        return $this->set('H1', $value);
    }

    /**
     * Set the value for the Part input for this ListGuideCategoriesByID Choreo.
     *
     * @param string $value (optional, string) A comma-separated list of one or more guideCategory resource properties that the API response will include. Valid values are: id and snippet.
     * @return YouTube_GuideCategories_ListGuideCategoriesByID_Inputs For method chaining.
     */
    public function setPart($value)
    {
        return $this->set('Part', $value);
    }

    /**
     * Set the value for the RefreshToken input for this ListGuideCategoriesByID Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_GuideCategories_ListGuideCategoriesByID_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }
}


/**
 * Execution object for the ListGuideCategoriesByID Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_GuideCategories_ListGuideCategoriesByID_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the ListGuideCategoriesByID Choreo.
     *
     * @param Temboo_Session $session The session that owns this ListGuideCategoriesByID execution.
     * @param YouTube_GuideCategories_ListGuideCategoriesByID $choreo The choreography object for this execution.
     * @param YouTube_GuideCategories_ListGuideCategoriesByID_Inputs|array $inputs (optional) Inputs as YouTube_GuideCategories_ListGuideCategoriesByID_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return YouTube_GuideCategories_ListGuideCategoriesByID_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, YouTube_GuideCategories_ListGuideCategoriesByID $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this ListGuideCategoriesByID execution.
     *
     * @return YouTube_GuideCategories_ListGuideCategoriesByID_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this ListGuideCategoriesByID execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return YouTube_GuideCategories_ListGuideCategoriesByID_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new YouTube_GuideCategories_ListGuideCategoriesByID_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the ListGuideCategoriesByID Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_GuideCategories_ListGuideCategoriesByID_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the ListGuideCategoriesByID Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return YouTube_GuideCategories_ListGuideCategoriesByID_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this ListGuideCategoriesByID execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this ListGuideCategoriesByID execution.
     *
     * @return string (json) The response from YouTube.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Returns a list of guide categories available in the specified country.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_GuideCategories_ListGuideCategoriesByRegion extends Temboo_Choreography
{
    /**
     * Returns a list of guide categories available in the specified country.
     *
     * @param Temboo_Session $session The session that owns this ListGuideCategoriesByRegion Choreo.
     * @return YouTube_GuideCategories_ListGuideCategoriesByRegion New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/YouTube/GuideCategories/ListGuideCategoriesByRegion/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this ListGuideCategoriesByRegion Choreo.
     *
     * @param YouTube_GuideCategories_ListGuideCategoriesByRegion_Inputs|array $inputs (optional) Inputs as YouTube_GuideCategories_ListGuideCategoriesByRegion_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return YouTube_GuideCategories_ListGuideCategoriesByRegion_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new YouTube_GuideCategories_ListGuideCategoriesByRegion_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this ListGuideCategoriesByRegion Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return YouTube_GuideCategories_ListGuideCategoriesByRegion_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new YouTube_GuideCategories_ListGuideCategoriesByRegion_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the ListGuideCategoriesByRegion Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_GuideCategories_ListGuideCategoriesByRegion_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the ListGuideCategoriesByRegion Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return YouTube_GuideCategories_ListGuideCategoriesByRegion_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this ListGuideCategoriesByRegion input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return YouTube_GuideCategories_ListGuideCategoriesByRegion_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return YouTube_GuideCategories_ListGuideCategoriesByRegion_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the APIKey input for this ListGuideCategoriesByRegion Choreo.
     *
     * @param string $value (optional, string) The API Key provided by Google for simple API access when you do not need to access user data.
     * @return YouTube_GuideCategories_ListGuideCategoriesByRegion_Inputs For method chaining.
     */
    public function setAPIKey($value)
    {
        return $this->set('APIKey', $value);
    }

    /**
     * Set the value for the AccessToken input for this ListGuideCategoriesByRegion Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required for OAuth authentication unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return YouTube_GuideCategories_ListGuideCategoriesByRegion_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this ListGuideCategoriesByRegion Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_GuideCategories_ListGuideCategoriesByRegion_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this ListGuideCategoriesByRegion Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_GuideCategories_ListGuideCategoriesByRegion_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Fields input for this ListGuideCategoriesByRegion Choreo.
     *
     * @param string $value (optional, string) Allows you to specify a subset of fields to include in the response using an xpath-like syntax (i.e. items/snippet/title).
     * @return YouTube_GuideCategories_ListGuideCategoriesByRegion_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the H1 input for this ListGuideCategoriesByRegion Choreo.
     *
     * @param string $value (optional, string) The hl parameter specifies the language that should be used for text values in the API response. The default value is en_US.
     * @return YouTube_GuideCategories_ListGuideCategoriesByRegion_Inputs For method chaining.
     */
    public function setH1($value)
    {
        return $this->set('H1', $value);
    }

    /**
     * Set the value for the Part input for this ListGuideCategoriesByRegion Choreo.
     *
     * @param string $value (optional, string) A comma-separated list of one or more guideCategory resource properties that the API response will include. Valid values are: id and snippet.
     * @return YouTube_GuideCategories_ListGuideCategoriesByRegion_Inputs For method chaining.
     */
    public function setPart($value)
    {
        return $this->set('Part', $value);
    }

    /**
     * Set the value for the RefreshToken input for this ListGuideCategoriesByRegion Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_GuideCategories_ListGuideCategoriesByRegion_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }

    /**
     * Set the value for the RegionCode input for this ListGuideCategoriesByRegion Choreo.
     *
     * @param string $value (optional, string) Indicates to return the list of guide categories available in the specified country. The parameter value is an ISO 3166-1 alpha-2 country code. Defaults to US.
     * @return YouTube_GuideCategories_ListGuideCategoriesByRegion_Inputs For method chaining.
     */
    public function setRegionCode($value)
    {
        return $this->set('RegionCode', $value);
    }
}


/**
 * Execution object for the ListGuideCategoriesByRegion Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_GuideCategories_ListGuideCategoriesByRegion_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the ListGuideCategoriesByRegion Choreo.
     *
     * @param Temboo_Session $session The session that owns this ListGuideCategoriesByRegion execution.
     * @param YouTube_GuideCategories_ListGuideCategoriesByRegion $choreo The choreography object for this execution.
     * @param YouTube_GuideCategories_ListGuideCategoriesByRegion_Inputs|array $inputs (optional) Inputs as YouTube_GuideCategories_ListGuideCategoriesByRegion_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return YouTube_GuideCategories_ListGuideCategoriesByRegion_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, YouTube_GuideCategories_ListGuideCategoriesByRegion $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this ListGuideCategoriesByRegion execution.
     *
     * @return YouTube_GuideCategories_ListGuideCategoriesByRegion_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this ListGuideCategoriesByRegion execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return YouTube_GuideCategories_ListGuideCategoriesByRegion_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new YouTube_GuideCategories_ListGuideCategoriesByRegion_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the ListGuideCategoriesByRegion Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_GuideCategories_ListGuideCategoriesByRegion_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the ListGuideCategoriesByRegion Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return YouTube_GuideCategories_ListGuideCategoriesByRegion_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this ListGuideCategoriesByRegion execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this ListGuideCategoriesByRegion execution.
     *
     * @return string (json) The response from YouTube.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Creates a new item within a playlist.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_PlaylistItems_InsertItem extends Temboo_Choreography
{
    /**
     * Creates a new item within a playlist.
     *
     * @param Temboo_Session $session The session that owns this InsertItem Choreo.
     * @return YouTube_PlaylistItems_InsertItem New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/YouTube/PlaylistItems/InsertItem/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this InsertItem Choreo.
     *
     * @param YouTube_PlaylistItems_InsertItem_Inputs|array $inputs (optional) Inputs as YouTube_PlaylistItems_InsertItem_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return YouTube_PlaylistItems_InsertItem_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new YouTube_PlaylistItems_InsertItem_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this InsertItem Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return YouTube_PlaylistItems_InsertItem_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new YouTube_PlaylistItems_InsertItem_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the InsertItem Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_PlaylistItems_InsertItem_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the InsertItem Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return YouTube_PlaylistItems_InsertItem_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this InsertItem input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return YouTube_PlaylistItems_InsertItem_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return YouTube_PlaylistItems_InsertItem_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this InsertItem Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required for OAuth authentication unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return YouTube_PlaylistItems_InsertItem_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this InsertItem Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_PlaylistItems_InsertItem_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this InsertItem Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_PlaylistItems_InsertItem_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Fields input for this InsertItem Choreo.
     *
     * @param string $value (optional, string) Allows you to specify a subset of fields to include in the response using an xpath-like syntax (i.e. items/snippet/title).
     * @return YouTube_PlaylistItems_InsertItem_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Part input for this InsertItem Choreo.
     *
     * @param string $value (optional, string) A comma-separated list of fields that are being set and that will be returned in the response. Part names that can be passed are: snippet and contentDetails.
     * @return YouTube_PlaylistItems_InsertItem_Inputs For method chaining.
     */
    public function setPart($value)
    {
        return $this->set('Part', $value);
    }

    /**
     * Set the value for the PlaylistID input for this InsertItem Choreo.
     *
     * @param string $value (required, string) The id of the playlist to add an item to.
     * @return YouTube_PlaylistItems_InsertItem_Inputs For method chaining.
     */
    public function setPlaylistID($value)
    {
        return $this->set('PlaylistID', $value);
    }

    /**
     * Set the value for the RefreshToken input for this InsertItem Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_PlaylistItems_InsertItem_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }

    /**
     * Set the value for the VideoID input for this InsertItem Choreo.
     *
     * @param string $value (required, string) The id of the video to add to the playlist.
     * @return YouTube_PlaylistItems_InsertItem_Inputs For method chaining.
     */
    public function setVideoID($value)
    {
        return $this->set('VideoID', $value);
    }
}


/**
 * Execution object for the InsertItem Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_PlaylistItems_InsertItem_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the InsertItem Choreo.
     *
     * @param Temboo_Session $session The session that owns this InsertItem execution.
     * @param YouTube_PlaylistItems_InsertItem $choreo The choreography object for this execution.
     * @param YouTube_PlaylistItems_InsertItem_Inputs|array $inputs (optional) Inputs as YouTube_PlaylistItems_InsertItem_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return YouTube_PlaylistItems_InsertItem_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, YouTube_PlaylistItems_InsertItem $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this InsertItem execution.
     *
     * @return YouTube_PlaylistItems_InsertItem_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this InsertItem execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return YouTube_PlaylistItems_InsertItem_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new YouTube_PlaylistItems_InsertItem_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the InsertItem Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_PlaylistItems_InsertItem_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the InsertItem Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return YouTube_PlaylistItems_InsertItem_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this InsertItem execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this InsertItem execution.
     *
     * @return string (json) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Returns a collection of playlist items that match the list of IDs provided.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_PlaylistItems_ListItemsByID extends Temboo_Choreography
{
    /**
     * Returns a collection of playlist items that match the list of IDs provided.
     *
     * @param Temboo_Session $session The session that owns this ListItemsByID Choreo.
     * @return YouTube_PlaylistItems_ListItemsByID New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/YouTube/PlaylistItems/ListItemsByID/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this ListItemsByID Choreo.
     *
     * @param YouTube_PlaylistItems_ListItemsByID_Inputs|array $inputs (optional) Inputs as YouTube_PlaylistItems_ListItemsByID_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return YouTube_PlaylistItems_ListItemsByID_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new YouTube_PlaylistItems_ListItemsByID_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this ListItemsByID Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return YouTube_PlaylistItems_ListItemsByID_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new YouTube_PlaylistItems_ListItemsByID_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the ListItemsByID Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_PlaylistItems_ListItemsByID_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the ListItemsByID Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return YouTube_PlaylistItems_ListItemsByID_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this ListItemsByID input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return YouTube_PlaylistItems_ListItemsByID_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return YouTube_PlaylistItems_ListItemsByID_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the APIKey input for this ListItemsByID Choreo.
     *
     * @param string $value (optional, string) The API Key provided by Google for simple API access when you do not need to access user data.
     * @return YouTube_PlaylistItems_ListItemsByID_Inputs For method chaining.
     */
    public function setAPIKey($value)
    {
        return $this->set('APIKey', $value);
    }

    /**
     * Set the value for the AccessToken input for this ListItemsByID Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required for OAuth authentication unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return YouTube_PlaylistItems_ListItemsByID_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this ListItemsByID Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_PlaylistItems_ListItemsByID_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this ListItemsByID Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_PlaylistItems_ListItemsByID_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Fields input for this ListItemsByID Choreo.
     *
     * @param string $value (optional, string) Allows you to specify a subset of fields to include in the response using an xpath-like syntax (i.e. items/snippet/title).
     * @return YouTube_PlaylistItems_ListItemsByID_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the ItemID input for this ListItemsByID Choreo.
     *
     * @param string $value (conditional, string) A comma-separated list of IDs for playlist items to retrieve.
     * @return YouTube_PlaylistItems_ListItemsByID_Inputs For method chaining.
     */
    public function setItemID($value)
    {
        return $this->set('ItemID', $value);
    }

    /**
     * Set the value for the MaxResults input for this ListItemsByID Choreo.
     *
     * @param int $value (optional, integer) The maximum number of results to return.
     * @return YouTube_PlaylistItems_ListItemsByID_Inputs For method chaining.
     */
    public function setMaxResults($value)
    {
        return $this->set('MaxResults', $value);
    }

    /**
     * Set the value for the PageToken input for this ListItemsByID Choreo.
     *
     * @param string $value (optional, string) The "nextPageToken" found in the response which is used to page through results.
     * @return YouTube_PlaylistItems_ListItemsByID_Inputs For method chaining.
     */
    public function setPageToken($value)
    {
        return $this->set('PageToken', $value);
    }

    /**
     * Set the value for the Part input for this ListItemsByID Choreo.
     *
     * @param string $value (optional, string) Specifies a comma-separated list of playlistItem resource properties that the API response will include. Part names that you can pass are: id, snippet, and contentDetails.
     * @return YouTube_PlaylistItems_ListItemsByID_Inputs For method chaining.
     */
    public function setPart($value)
    {
        return $this->set('Part', $value);
    }

    /**
     * Set the value for the RefreshToken input for this ListItemsByID Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_PlaylistItems_ListItemsByID_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }

    /**
     * Set the value for the VideoID input for this ListItemsByID Choreo.
     *
     * @param string $value (optional, string) Indicates that only the playlist items that contain the specified video should be returned.
     * @return YouTube_PlaylistItems_ListItemsByID_Inputs For method chaining.
     */
    public function setVideoID($value)
    {
        return $this->set('VideoID', $value);
    }
}


/**
 * Execution object for the ListItemsByID Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_PlaylistItems_ListItemsByID_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the ListItemsByID Choreo.
     *
     * @param Temboo_Session $session The session that owns this ListItemsByID execution.
     * @param YouTube_PlaylistItems_ListItemsByID $choreo The choreography object for this execution.
     * @param YouTube_PlaylistItems_ListItemsByID_Inputs|array $inputs (optional) Inputs as YouTube_PlaylistItems_ListItemsByID_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return YouTube_PlaylistItems_ListItemsByID_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, YouTube_PlaylistItems_ListItemsByID $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this ListItemsByID execution.
     *
     * @return YouTube_PlaylistItems_ListItemsByID_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this ListItemsByID execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return YouTube_PlaylistItems_ListItemsByID_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new YouTube_PlaylistItems_ListItemsByID_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the ListItemsByID Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_PlaylistItems_ListItemsByID_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the ListItemsByID Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return YouTube_PlaylistItems_ListItemsByID_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this ListItemsByID execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this ListItemsByID execution.
     *
     * @return string (json) The response from YouTube.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Returns a collection of playlist items within a specific playlist.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_PlaylistItems_ListItemsByPlaylist extends Temboo_Choreography
{
    /**
     * Returns a collection of playlist items within a specific playlist.
     *
     * @param Temboo_Session $session The session that owns this ListItemsByPlaylist Choreo.
     * @return YouTube_PlaylistItems_ListItemsByPlaylist New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/YouTube/PlaylistItems/ListItemsByPlaylist/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this ListItemsByPlaylist Choreo.
     *
     * @param YouTube_PlaylistItems_ListItemsByPlaylist_Inputs|array $inputs (optional) Inputs as YouTube_PlaylistItems_ListItemsByPlaylist_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return YouTube_PlaylistItems_ListItemsByPlaylist_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new YouTube_PlaylistItems_ListItemsByPlaylist_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this ListItemsByPlaylist Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return YouTube_PlaylistItems_ListItemsByPlaylist_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new YouTube_PlaylistItems_ListItemsByPlaylist_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the ListItemsByPlaylist Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_PlaylistItems_ListItemsByPlaylist_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the ListItemsByPlaylist Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return YouTube_PlaylistItems_ListItemsByPlaylist_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this ListItemsByPlaylist input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return YouTube_PlaylistItems_ListItemsByPlaylist_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return YouTube_PlaylistItems_ListItemsByPlaylist_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the APIKey input for this ListItemsByPlaylist Choreo.
     *
     * @param string $value (optional, string) The API Key provided by Google for simple API access when you do not need to access user data.
     * @return YouTube_PlaylistItems_ListItemsByPlaylist_Inputs For method chaining.
     */
    public function setAPIKey($value)
    {
        return $this->set('APIKey', $value);
    }

    /**
     * Set the value for the AccessToken input for this ListItemsByPlaylist Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required for OAuth authentication unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return YouTube_PlaylistItems_ListItemsByPlaylist_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this ListItemsByPlaylist Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_PlaylistItems_ListItemsByPlaylist_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this ListItemsByPlaylist Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_PlaylistItems_ListItemsByPlaylist_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Fields input for this ListItemsByPlaylist Choreo.
     *
     * @param string $value (optional, string) Allows you to specify a subset of fields to include in the response using an xpath-like syntax (i.e. items/snippet/title).
     * @return YouTube_PlaylistItems_ListItemsByPlaylist_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the MaxResults input for this ListItemsByPlaylist Choreo.
     *
     * @param int $value (optional, integer) The maximum number of results to return.
     * @return YouTube_PlaylistItems_ListItemsByPlaylist_Inputs For method chaining.
     */
    public function setMaxResults($value)
    {
        return $this->set('MaxResults', $value);
    }

    /**
     * Set the value for the PageToken input for this ListItemsByPlaylist Choreo.
     *
     * @param string $value (optional, string) The "nextPageToken" found in the response which is used to page through results.
     * @return YouTube_PlaylistItems_ListItemsByPlaylist_Inputs For method chaining.
     */
    public function setPageToken($value)
    {
        return $this->set('PageToken', $value);
    }

    /**
     * Set the value for the Part input for this ListItemsByPlaylist Choreo.
     *
     * @param string $value (optional, string) Specifies a comma-separated list of playlistItem resource properties that the API response will include. Part names that you can pass are: id, snippet, and contentDetails.
     * @return YouTube_PlaylistItems_ListItemsByPlaylist_Inputs For method chaining.
     */
    public function setPart($value)
    {
        return $this->set('Part', $value);
    }

    /**
     * Set the value for the PlaylistID input for this ListItemsByPlaylist Choreo.
     *
     * @param string $value (conditional, string) A unique ID of the playlist for which you want to retrieve playlist items.
     * @return YouTube_PlaylistItems_ListItemsByPlaylist_Inputs For method chaining.
     */
    public function setPlaylistID($value)
    {
        return $this->set('PlaylistID', $value);
    }

    /**
     * Set the value for the RefreshToken input for this ListItemsByPlaylist Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_PlaylistItems_ListItemsByPlaylist_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }

    /**
     * Set the value for the VideoID input for this ListItemsByPlaylist Choreo.
     *
     * @param string $value (optional, string) Indicates that only the playlist items that contain the specified video should be returned.
     * @return YouTube_PlaylistItems_ListItemsByPlaylist_Inputs For method chaining.
     */
    public function setVideoID($value)
    {
        return $this->set('VideoID', $value);
    }
}


/**
 * Execution object for the ListItemsByPlaylist Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_PlaylistItems_ListItemsByPlaylist_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the ListItemsByPlaylist Choreo.
     *
     * @param Temboo_Session $session The session that owns this ListItemsByPlaylist execution.
     * @param YouTube_PlaylistItems_ListItemsByPlaylist $choreo The choreography object for this execution.
     * @param YouTube_PlaylistItems_ListItemsByPlaylist_Inputs|array $inputs (optional) Inputs as YouTube_PlaylistItems_ListItemsByPlaylist_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return YouTube_PlaylistItems_ListItemsByPlaylist_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, YouTube_PlaylistItems_ListItemsByPlaylist $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this ListItemsByPlaylist execution.
     *
     * @return YouTube_PlaylistItems_ListItemsByPlaylist_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this ListItemsByPlaylist execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return YouTube_PlaylistItems_ListItemsByPlaylist_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new YouTube_PlaylistItems_ListItemsByPlaylist_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the ListItemsByPlaylist Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_PlaylistItems_ListItemsByPlaylist_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the ListItemsByPlaylist Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return YouTube_PlaylistItems_ListItemsByPlaylist_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this ListItemsByPlaylist execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this ListItemsByPlaylist execution.
     *
     * @return string (json) The response from YouTube.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Deletes a YouTube playlist.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Playlists_DeletePlaylist extends Temboo_Choreography
{
    /**
     * Deletes a YouTube playlist.
     *
     * @param Temboo_Session $session The session that owns this DeletePlaylist Choreo.
     * @return YouTube_Playlists_DeletePlaylist New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/YouTube/Playlists/DeletePlaylist/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this DeletePlaylist Choreo.
     *
     * @param YouTube_Playlists_DeletePlaylist_Inputs|array $inputs (optional) Inputs as YouTube_Playlists_DeletePlaylist_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return YouTube_Playlists_DeletePlaylist_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new YouTube_Playlists_DeletePlaylist_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this DeletePlaylist Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return YouTube_Playlists_DeletePlaylist_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new YouTube_Playlists_DeletePlaylist_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the DeletePlaylist Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Playlists_DeletePlaylist_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the DeletePlaylist Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return YouTube_Playlists_DeletePlaylist_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this DeletePlaylist input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return YouTube_Playlists_DeletePlaylist_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return YouTube_Playlists_DeletePlaylist_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this DeletePlaylist Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required for OAuth authentication unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return YouTube_Playlists_DeletePlaylist_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this DeletePlaylist Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_Playlists_DeletePlaylist_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this DeletePlaylist Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_Playlists_DeletePlaylist_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the PlaylistID input for this DeletePlaylist Choreo.
     *
     * @param string $value (required, string) The id of the playlist to delete.
     * @return YouTube_Playlists_DeletePlaylist_Inputs For method chaining.
     */
    public function setPlaylistID($value)
    {
        return $this->set('PlaylistID', $value);
    }

    /**
     * Set the value for the RefreshToken input for this DeletePlaylist Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_Playlists_DeletePlaylist_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }
}


/**
 * Execution object for the DeletePlaylist Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Playlists_DeletePlaylist_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the DeletePlaylist Choreo.
     *
     * @param Temboo_Session $session The session that owns this DeletePlaylist execution.
     * @param YouTube_Playlists_DeletePlaylist $choreo The choreography object for this execution.
     * @param YouTube_Playlists_DeletePlaylist_Inputs|array $inputs (optional) Inputs as YouTube_Playlists_DeletePlaylist_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return YouTube_Playlists_DeletePlaylist_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, YouTube_Playlists_DeletePlaylist $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this DeletePlaylist execution.
     *
     * @return YouTube_Playlists_DeletePlaylist_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this DeletePlaylist execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return YouTube_Playlists_DeletePlaylist_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new YouTube_Playlists_DeletePlaylist_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the DeletePlaylist Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Playlists_DeletePlaylist_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the DeletePlaylist Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return YouTube_Playlists_DeletePlaylist_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this DeletePlaylist execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this DeletePlaylist execution.
     *
     * @return string (json) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Creates a playlist.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Playlists_InsertPlaylist extends Temboo_Choreography
{
    /**
     * Creates a playlist.
     *
     * @param Temboo_Session $session The session that owns this InsertPlaylist Choreo.
     * @return YouTube_Playlists_InsertPlaylist New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/YouTube/Playlists/InsertPlaylist/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this InsertPlaylist Choreo.
     *
     * @param YouTube_Playlists_InsertPlaylist_Inputs|array $inputs (optional) Inputs as YouTube_Playlists_InsertPlaylist_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return YouTube_Playlists_InsertPlaylist_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new YouTube_Playlists_InsertPlaylist_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this InsertPlaylist Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return YouTube_Playlists_InsertPlaylist_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new YouTube_Playlists_InsertPlaylist_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the InsertPlaylist Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Playlists_InsertPlaylist_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the InsertPlaylist Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return YouTube_Playlists_InsertPlaylist_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this InsertPlaylist input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return YouTube_Playlists_InsertPlaylist_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return YouTube_Playlists_InsertPlaylist_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this InsertPlaylist Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required for OAuth authentication unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return YouTube_Playlists_InsertPlaylist_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this InsertPlaylist Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_Playlists_InsertPlaylist_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this InsertPlaylist Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_Playlists_InsertPlaylist_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Description input for this InsertPlaylist Choreo.
     *
     * @param string $value (optional, string) The playlist's description.
     * @return YouTube_Playlists_InsertPlaylist_Inputs For method chaining.
     */
    public function setDescription($value)
    {
        return $this->set('Description', $value);
    }

    /**
     * Set the value for the Fields input for this InsertPlaylist Choreo.
     *
     * @param string $value (optional, string) Allows you to specify a subset of fields to include in the response using an xpath-like syntax (i.e. items/snippet/title).
     * @return YouTube_Playlists_InsertPlaylist_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Part input for this InsertPlaylist Choreo.
     *
     * @param string $value (optional, string) A comma-separated list of fields that are being set and that will be returned in the response (i.e. snippet,status).
     * @return YouTube_Playlists_InsertPlaylist_Inputs For method chaining.
     */
    public function setPart($value)
    {
        return $this->set('Part', $value);
    }

    /**
     * Set the value for the PrivacyStatus input for this InsertPlaylist Choreo.
     *
     * @param string $value (optional, string) The playlist's privacy status. Valid values are: private or public.
     * @return YouTube_Playlists_InsertPlaylist_Inputs For method chaining.
     */
    public function setPrivacyStatus($value)
    {
        return $this->set('PrivacyStatus', $value);
    }

    /**
     * Set the value for the RefreshToken input for this InsertPlaylist Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_Playlists_InsertPlaylist_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }

    /**
     * Set the value for the Title input for this InsertPlaylist Choreo.
     *
     * @param string $value (required, string) The title of the playlist.
     * @return YouTube_Playlists_InsertPlaylist_Inputs For method chaining.
     */
    public function setTitle($value)
    {
        return $this->set('Title', $value);
    }
}


/**
 * Execution object for the InsertPlaylist Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Playlists_InsertPlaylist_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the InsertPlaylist Choreo.
     *
     * @param Temboo_Session $session The session that owns this InsertPlaylist execution.
     * @param YouTube_Playlists_InsertPlaylist $choreo The choreography object for this execution.
     * @param YouTube_Playlists_InsertPlaylist_Inputs|array $inputs (optional) Inputs as YouTube_Playlists_InsertPlaylist_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return YouTube_Playlists_InsertPlaylist_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, YouTube_Playlists_InsertPlaylist $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this InsertPlaylist execution.
     *
     * @return YouTube_Playlists_InsertPlaylist_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this InsertPlaylist execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return YouTube_Playlists_InsertPlaylist_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new YouTube_Playlists_InsertPlaylist_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the InsertPlaylist Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Playlists_InsertPlaylist_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the InsertPlaylist Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return YouTube_Playlists_InsertPlaylist_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this InsertPlaylist execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this InsertPlaylist execution.
     *
     * @return string (json) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Returns a collection of playlists owned by the authenticated user.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Playlists_ListMyPlaylists extends Temboo_Choreography
{
    /**
     * Returns a collection of playlists owned by the authenticated user.
     *
     * @param Temboo_Session $session The session that owns this ListMyPlaylists Choreo.
     * @return YouTube_Playlists_ListMyPlaylists New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/YouTube/Playlists/ListMyPlaylists/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this ListMyPlaylists Choreo.
     *
     * @param YouTube_Playlists_ListMyPlaylists_Inputs|array $inputs (optional) Inputs as YouTube_Playlists_ListMyPlaylists_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return YouTube_Playlists_ListMyPlaylists_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new YouTube_Playlists_ListMyPlaylists_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this ListMyPlaylists Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return YouTube_Playlists_ListMyPlaylists_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new YouTube_Playlists_ListMyPlaylists_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the ListMyPlaylists Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Playlists_ListMyPlaylists_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the ListMyPlaylists Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return YouTube_Playlists_ListMyPlaylists_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this ListMyPlaylists input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return YouTube_Playlists_ListMyPlaylists_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return YouTube_Playlists_ListMyPlaylists_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this ListMyPlaylists Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required for OAuth authentication unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return YouTube_Playlists_ListMyPlaylists_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this ListMyPlaylists Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_Playlists_ListMyPlaylists_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this ListMyPlaylists Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_Playlists_ListMyPlaylists_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Fields input for this ListMyPlaylists Choreo.
     *
     * @param string $value (optional, string) Allows you to specify a subset of fields to include in the response using an xpath-like syntax (i.e. items/snippet/title).
     * @return YouTube_Playlists_ListMyPlaylists_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the MaxResults input for this ListMyPlaylists Choreo.
     *
     * @param int $value (optional, integer) The maximum number of results to return.
     * @return YouTube_Playlists_ListMyPlaylists_Inputs For method chaining.
     */
    public function setMaxResults($value)
    {
        return $this->set('MaxResults', $value);
    }

    /**
     * Set the value for the PageToken input for this ListMyPlaylists Choreo.
     *
     * @param string $value (optional, string) The "nextPageToken" found in the response which is used to page through results.
     * @return YouTube_Playlists_ListMyPlaylists_Inputs For method chaining.
     */
    public function setPageToken($value)
    {
        return $this->set('PageToken', $value);
    }

    /**
     * Set the value for the Part input for this ListMyPlaylists Choreo.
     *
     * @param string $value (optional, string) Specifies a comma-separated list of playlist resource properties that the API response will include. Part names that you can pass are: id, snippet, and status.
     * @return YouTube_Playlists_ListMyPlaylists_Inputs For method chaining.
     */
    public function setPart($value)
    {
        return $this->set('Part', $value);
    }

    /**
     * Set the value for the RefreshToken input for this ListMyPlaylists Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_Playlists_ListMyPlaylists_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }
}


/**
 * Execution object for the ListMyPlaylists Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Playlists_ListMyPlaylists_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the ListMyPlaylists Choreo.
     *
     * @param Temboo_Session $session The session that owns this ListMyPlaylists execution.
     * @param YouTube_Playlists_ListMyPlaylists $choreo The choreography object for this execution.
     * @param YouTube_Playlists_ListMyPlaylists_Inputs|array $inputs (optional) Inputs as YouTube_Playlists_ListMyPlaylists_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return YouTube_Playlists_ListMyPlaylists_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, YouTube_Playlists_ListMyPlaylists $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this ListMyPlaylists execution.
     *
     * @return YouTube_Playlists_ListMyPlaylists_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this ListMyPlaylists execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return YouTube_Playlists_ListMyPlaylists_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new YouTube_Playlists_ListMyPlaylists_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the ListMyPlaylists Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Playlists_ListMyPlaylists_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the ListMyPlaylists Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return YouTube_Playlists_ListMyPlaylists_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this ListMyPlaylists execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this ListMyPlaylists execution.
     *
     * @return string (json) The response from YouTube.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Returns a collection of playlists associated with a specified channel.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Playlists_ListPlaylistsByChannel extends Temboo_Choreography
{
    /**
     * Returns a collection of playlists associated with a specified channel.
     *
     * @param Temboo_Session $session The session that owns this ListPlaylistsByChannel Choreo.
     * @return YouTube_Playlists_ListPlaylistsByChannel New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/YouTube/Playlists/ListPlaylistsByChannel/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this ListPlaylistsByChannel Choreo.
     *
     * @param YouTube_Playlists_ListPlaylistsByChannel_Inputs|array $inputs (optional) Inputs as YouTube_Playlists_ListPlaylistsByChannel_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return YouTube_Playlists_ListPlaylistsByChannel_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new YouTube_Playlists_ListPlaylistsByChannel_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this ListPlaylistsByChannel Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return YouTube_Playlists_ListPlaylistsByChannel_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new YouTube_Playlists_ListPlaylistsByChannel_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the ListPlaylistsByChannel Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Playlists_ListPlaylistsByChannel_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the ListPlaylistsByChannel Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return YouTube_Playlists_ListPlaylistsByChannel_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this ListPlaylistsByChannel input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return YouTube_Playlists_ListPlaylistsByChannel_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return YouTube_Playlists_ListPlaylistsByChannel_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the APIKey input for this ListPlaylistsByChannel Choreo.
     *
     * @param string $value (optional, string) The API Key provided by Google for simple API access when you do not need to access user data.
     * @return YouTube_Playlists_ListPlaylistsByChannel_Inputs For method chaining.
     */
    public function setAPIKey($value)
    {
        return $this->set('APIKey', $value);
    }

    /**
     * Set the value for the AccessToken input for this ListPlaylistsByChannel Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth2 process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return YouTube_Playlists_ListPlaylistsByChannel_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ChannelID input for this ListPlaylistsByChannel Choreo.
     *
     * @param string $value (required, string) Indicates that only the specified channel's playlists should be returned.
     * @return YouTube_Playlists_ListPlaylistsByChannel_Inputs For method chaining.
     */
    public function setChannelID($value)
    {
        return $this->set('ChannelID', $value);
    }

    /**
     * Set the value for the ClientID input for this ListPlaylistsByChannel Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return YouTube_Playlists_ListPlaylistsByChannel_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this ListPlaylistsByChannel Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return YouTube_Playlists_ListPlaylistsByChannel_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Fields input for this ListPlaylistsByChannel Choreo.
     *
     * @param string $value (optional, string) Allows you to specify a subset of fields to include in the response using an xpath-like syntax (i.e. items/snippet/title).
     * @return YouTube_Playlists_ListPlaylistsByChannel_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the MaxResults input for this ListPlaylistsByChannel Choreo.
     *
     * @param int $value (optional, integer) The maximum number of results to return.
     * @return YouTube_Playlists_ListPlaylistsByChannel_Inputs For method chaining.
     */
    public function setMaxResults($value)
    {
        return $this->set('MaxResults', $value);
    }

    /**
     * Set the value for the PageToken input for this ListPlaylistsByChannel Choreo.
     *
     * @param string $value (optional, string) The "nextPageToken" found in the response which is used to page through results.
     * @return YouTube_Playlists_ListPlaylistsByChannel_Inputs For method chaining.
     */
    public function setPageToken($value)
    {
        return $this->set('PageToken', $value);
    }

    /**
     * Set the value for the Part input for this ListPlaylistsByChannel Choreo.
     *
     * @param string $value (optional, string) Specifies a comma-separated list of playlist resource properties that the API response will include. Part names that you can pass are: id, snippet, and status.
     * @return YouTube_Playlists_ListPlaylistsByChannel_Inputs For method chaining.
     */
    public function setPart($value)
    {
        return $this->set('Part', $value);
    }

    /**
     * Set the value for the RefreshToken input for this ListPlaylistsByChannel Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return YouTube_Playlists_ListPlaylistsByChannel_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }
}


/**
 * Execution object for the ListPlaylistsByChannel Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Playlists_ListPlaylistsByChannel_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the ListPlaylistsByChannel Choreo.
     *
     * @param Temboo_Session $session The session that owns this ListPlaylistsByChannel execution.
     * @param YouTube_Playlists_ListPlaylistsByChannel $choreo The choreography object for this execution.
     * @param YouTube_Playlists_ListPlaylistsByChannel_Inputs|array $inputs (optional) Inputs as YouTube_Playlists_ListPlaylistsByChannel_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return YouTube_Playlists_ListPlaylistsByChannel_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, YouTube_Playlists_ListPlaylistsByChannel $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this ListPlaylistsByChannel execution.
     *
     * @return YouTube_Playlists_ListPlaylistsByChannel_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this ListPlaylistsByChannel execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return YouTube_Playlists_ListPlaylistsByChannel_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new YouTube_Playlists_ListPlaylistsByChannel_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the ListPlaylistsByChannel Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Playlists_ListPlaylistsByChannel_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the ListPlaylistsByChannel Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return YouTube_Playlists_ListPlaylistsByChannel_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this ListPlaylistsByChannel execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this ListPlaylistsByChannel execution.
     *
     * @return string (json) The response from YouTube.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Returns a collection of playlists that match the provided IDs.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Playlists_ListPlaylistsByID extends Temboo_Choreography
{
    /**
     * Returns a collection of playlists that match the provided IDs.
     *
     * @param Temboo_Session $session The session that owns this ListPlaylistsByID Choreo.
     * @return YouTube_Playlists_ListPlaylistsByID New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/YouTube/Playlists/ListPlaylistsByID/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this ListPlaylistsByID Choreo.
     *
     * @param YouTube_Playlists_ListPlaylistsByID_Inputs|array $inputs (optional) Inputs as YouTube_Playlists_ListPlaylistsByID_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return YouTube_Playlists_ListPlaylistsByID_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new YouTube_Playlists_ListPlaylistsByID_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this ListPlaylistsByID Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return YouTube_Playlists_ListPlaylistsByID_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new YouTube_Playlists_ListPlaylistsByID_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the ListPlaylistsByID Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Playlists_ListPlaylistsByID_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the ListPlaylistsByID Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return YouTube_Playlists_ListPlaylistsByID_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this ListPlaylistsByID input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return YouTube_Playlists_ListPlaylistsByID_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return YouTube_Playlists_ListPlaylistsByID_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the APIKey input for this ListPlaylistsByID Choreo.
     *
     * @param string $value (optional, string) The API Key provided by Google for simple API access when you do not need to access user data.
     * @return YouTube_Playlists_ListPlaylistsByID_Inputs For method chaining.
     */
    public function setAPIKey($value)
    {
        return $this->set('APIKey', $value);
    }

    /**
     * Set the value for the AccessToken input for this ListPlaylistsByID Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required for OAuth authentication unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return YouTube_Playlists_ListPlaylistsByID_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this ListPlaylistsByID Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_Playlists_ListPlaylistsByID_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this ListPlaylistsByID Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_Playlists_ListPlaylistsByID_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Fields input for this ListPlaylistsByID Choreo.
     *
     * @param string $value (optional, string) Allows you to specify a subset of fields to include in the response using an xpath-like syntax (i.e. items/snippet/title).
     * @return YouTube_Playlists_ListPlaylistsByID_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the MaxResults input for this ListPlaylistsByID Choreo.
     *
     * @param int $value (optional, integer) The maximum number of results to return.
     * @return YouTube_Playlists_ListPlaylistsByID_Inputs For method chaining.
     */
    public function setMaxResults($value)
    {
        return $this->set('MaxResults', $value);
    }

    /**
     * Set the value for the PageToken input for this ListPlaylistsByID Choreo.
     *
     * @param string $value (optional, string) The "nextPageToken" found in the response which is used to page through results.
     * @return YouTube_Playlists_ListPlaylistsByID_Inputs For method chaining.
     */
    public function setPageToken($value)
    {
        return $this->set('PageToken', $value);
    }

    /**
     * Set the value for the Part input for this ListPlaylistsByID Choreo.
     *
     * @param string $value (optional, string) Specifies a comma-separated list of playlist resource properties that the API response will include. Part names that you can pass are: id, snippet, and status.
     * @return YouTube_Playlists_ListPlaylistsByID_Inputs For method chaining.
     */
    public function setPart($value)
    {
        return $this->set('Part', $value);
    }

    /**
     * Set the value for the PlaylistID input for this ListPlaylistsByID Choreo.
     *
     * @param string $value (required, string) A comma-separated list of the YouTube playlist ID(s) for the resource(s) that are being retrieved.
     * @return YouTube_Playlists_ListPlaylistsByID_Inputs For method chaining.
     */
    public function setPlaylistID($value)
    {
        return $this->set('PlaylistID', $value);
    }

    /**
     * Set the value for the RefreshToken input for this ListPlaylistsByID Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_Playlists_ListPlaylistsByID_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }
}


/**
 * Execution object for the ListPlaylistsByID Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Playlists_ListPlaylistsByID_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the ListPlaylistsByID Choreo.
     *
     * @param Temboo_Session $session The session that owns this ListPlaylistsByID execution.
     * @param YouTube_Playlists_ListPlaylistsByID $choreo The choreography object for this execution.
     * @param YouTube_Playlists_ListPlaylistsByID_Inputs|array $inputs (optional) Inputs as YouTube_Playlists_ListPlaylistsByID_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return YouTube_Playlists_ListPlaylistsByID_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, YouTube_Playlists_ListPlaylistsByID $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this ListPlaylistsByID execution.
     *
     * @return YouTube_Playlists_ListPlaylistsByID_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this ListPlaylistsByID execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return YouTube_Playlists_ListPlaylistsByID_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new YouTube_Playlists_ListPlaylistsByID_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the ListPlaylistsByID Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Playlists_ListPlaylistsByID_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the ListPlaylistsByID Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return YouTube_Playlists_ListPlaylistsByID_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this ListPlaylistsByID execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this ListPlaylistsByID execution.
     *
     * @return string (json) The response from YouTube.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Updates a playlist.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Playlists_UpdatePlaylist extends Temboo_Choreography
{
    /**
     * Updates a playlist.
     *
     * @param Temboo_Session $session The session that owns this UpdatePlaylist Choreo.
     * @return YouTube_Playlists_UpdatePlaylist New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/YouTube/Playlists/UpdatePlaylist/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this UpdatePlaylist Choreo.
     *
     * @param YouTube_Playlists_UpdatePlaylist_Inputs|array $inputs (optional) Inputs as YouTube_Playlists_UpdatePlaylist_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return YouTube_Playlists_UpdatePlaylist_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new YouTube_Playlists_UpdatePlaylist_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this UpdatePlaylist Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return YouTube_Playlists_UpdatePlaylist_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new YouTube_Playlists_UpdatePlaylist_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the UpdatePlaylist Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Playlists_UpdatePlaylist_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the UpdatePlaylist Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return YouTube_Playlists_UpdatePlaylist_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this UpdatePlaylist input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return YouTube_Playlists_UpdatePlaylist_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return YouTube_Playlists_UpdatePlaylist_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this UpdatePlaylist Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required for OAuth authentication unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return YouTube_Playlists_UpdatePlaylist_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this UpdatePlaylist Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_Playlists_UpdatePlaylist_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this UpdatePlaylist Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_Playlists_UpdatePlaylist_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Description input for this UpdatePlaylist Choreo.
     *
     * @param string $value (optional, string) The playlist's description.
     * @return YouTube_Playlists_UpdatePlaylist_Inputs For method chaining.
     */
    public function setDescription($value)
    {
        return $this->set('Description', $value);
    }

    /**
     * Set the value for the Fields input for this UpdatePlaylist Choreo.
     *
     * @param string $value (optional, string) Allows you to specify a subset of fields to include in the response using an xpath-like syntax (i.e. items/snippet/title).
     * @return YouTube_Playlists_UpdatePlaylist_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Part input for this UpdatePlaylist Choreo.
     *
     * @param string $value (optional, string) A comma-separated list of fields that are being set and that will be returned in the response (i.e. snippet,status).
     * @return YouTube_Playlists_UpdatePlaylist_Inputs For method chaining.
     */
    public function setPart($value)
    {
        return $this->set('Part', $value);
    }

    /**
     * Set the value for the PlaylistID input for this UpdatePlaylist Choreo.
     *
     * @param string $value (required, string) The id of the playlist to update.
     * @return YouTube_Playlists_UpdatePlaylist_Inputs For method chaining.
     */
    public function setPlaylistID($value)
    {
        return $this->set('PlaylistID', $value);
    }

    /**
     * Set the value for the PrivacyStatus input for this UpdatePlaylist Choreo.
     *
     * @param string $value (optional, string) The playlist's privacy status. Valid values are: private or public.
     * @return YouTube_Playlists_UpdatePlaylist_Inputs For method chaining.
     */
    public function setPrivacyStatus($value)
    {
        return $this->set('PrivacyStatus', $value);
    }

    /**
     * Set the value for the RefreshToken input for this UpdatePlaylist Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_Playlists_UpdatePlaylist_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }

    /**
     * Set the value for the Title input for this UpdatePlaylist Choreo.
     *
     * @param string $value (required, string) The title of the playlist.
     * @return YouTube_Playlists_UpdatePlaylist_Inputs For method chaining.
     */
    public function setTitle($value)
    {
        return $this->set('Title', $value);
    }
}


/**
 * Execution object for the UpdatePlaylist Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Playlists_UpdatePlaylist_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the UpdatePlaylist Choreo.
     *
     * @param Temboo_Session $session The session that owns this UpdatePlaylist execution.
     * @param YouTube_Playlists_UpdatePlaylist $choreo The choreography object for this execution.
     * @param YouTube_Playlists_UpdatePlaylist_Inputs|array $inputs (optional) Inputs as YouTube_Playlists_UpdatePlaylist_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return YouTube_Playlists_UpdatePlaylist_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, YouTube_Playlists_UpdatePlaylist $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this UpdatePlaylist execution.
     *
     * @return YouTube_Playlists_UpdatePlaylist_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this UpdatePlaylist execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return YouTube_Playlists_UpdatePlaylist_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new YouTube_Playlists_UpdatePlaylist_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the UpdatePlaylist Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Playlists_UpdatePlaylist_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the UpdatePlaylist Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return YouTube_Playlists_UpdatePlaylist_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this UpdatePlaylist execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this UpdatePlaylist execution.
     *
     * @return string (json) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Returns a list of search results that match the specified query parameters.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Search_ListSearchResults extends Temboo_Choreography
{
    /**
     * Returns a list of search results that match the specified query parameters.
     *
     * @param Temboo_Session $session The session that owns this ListSearchResults Choreo.
     * @return YouTube_Search_ListSearchResults New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/YouTube/Search/ListSearchResults/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this ListSearchResults Choreo.
     *
     * @param YouTube_Search_ListSearchResults_Inputs|array $inputs (optional) Inputs as YouTube_Search_ListSearchResults_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return YouTube_Search_ListSearchResults_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new YouTube_Search_ListSearchResults_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this ListSearchResults Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return YouTube_Search_ListSearchResults_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new YouTube_Search_ListSearchResults_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the ListSearchResults Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Search_ListSearchResults_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the ListSearchResults Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return YouTube_Search_ListSearchResults_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this ListSearchResults input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return YouTube_Search_ListSearchResults_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return YouTube_Search_ListSearchResults_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the APIKey input for this ListSearchResults Choreo.
     *
     * @param string $value (optional, string) The API Key provided by Google for simple API access when you do not need to access user data.
     * @return YouTube_Search_ListSearchResults_Inputs For method chaining.
     */
    public function setAPIKey($value)
    {
        return $this->set('APIKey', $value);
    }

    /**
     * Set the value for the AccessToken input for this ListSearchResults Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required for OAuth authentication unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return YouTube_Search_ListSearchResults_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ChannelID input for this ListSearchResults Choreo.
     *
     * @param string $value (optional, string) Indicates that the response should only contain resources created by this channel.
     * @return YouTube_Search_ListSearchResults_Inputs For method chaining.
     */
    public function setChannelID($value)
    {
        return $this->set('ChannelID', $value);
    }

    /**
     * Set the value for the ChannelType input for this ListSearchResults Choreo.
     *
     * @param string $value (optional, string) Restricts a search to a particular type of channel. Valid values are: "any" (returns all channels) and "show" (only retrieves shows).
     * @return YouTube_Search_ListSearchResults_Inputs For method chaining.
     */
    public function setChannelType($value)
    {
        return $this->set('ChannelType', $value);
    }

    /**
     * Set the value for the ClientID input for this ListSearchResults Choreo.
     *
     * @param string $value (optional, string) The Client ID provided by Google. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_Search_ListSearchResults_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this ListSearchResults Choreo.
     *
     * @param string $value (optional, string) The Client Secret provided by Google. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_Search_ListSearchResults_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Fields input for this ListSearchResults Choreo.
     *
     * @param string $value (optional, string) Allows you to specify a subset of fields to include in the response using an xpath-like syntax (i.e. items/snippet/title).
     * @return YouTube_Search_ListSearchResults_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the MaxResults input for this ListSearchResults Choreo.
     *
     * @param int $value (optional, integer) The maximum number of results to return.
     * @return YouTube_Search_ListSearchResults_Inputs For method chaining.
     */
    public function setMaxResults($value)
    {
        return $this->set('MaxResults', $value);
    }

    /**
     * Set the value for the Order input for this ListSearchResults Choreo.
     *
     * @param string $value (optional, string) Indicates how the results are sorted. Valid values are: date, rating, relevance, and viewCount.
     * @return YouTube_Search_ListSearchResults_Inputs For method chaining.
     */
    public function setOrder($value)
    {
        return $this->set('Order', $value);
    }

    /**
     * Set the value for the PageToken input for this ListSearchResults Choreo.
     *
     * @param string $value (optional, string) The "nextPageToken" found in the response which is used to page through results.
     * @return YouTube_Search_ListSearchResults_Inputs For method chaining.
     */
    public function setPageToken($value)
    {
        return $this->set('PageToken', $value);
    }

    /**
     * Set the value for the Part input for this ListSearchResults Choreo.
     *
     * @param string $value (optional, string) Specifies a comma-separated list of one or more search resource properties that the API response will include. Part names that you can pass are 'id' and 'snippet' (the default).
     * @return YouTube_Search_ListSearchResults_Inputs For method chaining.
     */
    public function setPart($value)
    {
        return $this->set('Part', $value);
    }

    /**
     * Set the value for the PublishedAfter input for this ListSearchResults Choreo.
     *
     * @param string $value (optional, date) Returns only results created after the specified time (formatted as a RFC 3339 date-time i.e. 1970-01-01T00:00:00Z).
     * @return YouTube_Search_ListSearchResults_Inputs For method chaining.
     */
    public function setPublishedAfter($value)
    {
        return $this->set('PublishedAfter', $value);
    }

    /**
     * Set the value for the PublishedBefore input for this ListSearchResults Choreo.
     *
     * @param string $value (optional, date) Returns only results created before the specified time (formatted as a RFC 3339 date-time i.e. 1970-01-01T00:00:00Z).
     * @return YouTube_Search_ListSearchResults_Inputs For method chaining.
     */
    public function setPublishedBefore($value)
    {
        return $this->set('PublishedBefore', $value);
    }

    /**
     * Set the value for the Query input for this ListSearchResults Choreo.
     *
     * @param string $value (conditional, string) A query string for searching videos.
     * @return YouTube_Search_ListSearchResults_Inputs For method chaining.
     */
    public function setQuery($value)
    {
        return $this->set('Query', $value);
    }

    /**
     * Set the value for the RefreshToken input for this ListSearchResults Choreo.
     *
     * @param string $value (optional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_Search_ListSearchResults_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }

    /**
     * Set the value for the RegionCode input for this ListSearchResults Choreo.
     *
     * @param string $value (optional, string) Returns results for the specified country. The parameter value is an ISO 3166-1 alpha-2 country code.
     * @return YouTube_Search_ListSearchResults_Inputs For method chaining.
     */
    public function setRegionCode($value)
    {
        return $this->set('RegionCode', $value);
    }

    /**
     * Set the value for the RelatedToVideoID input for this ListSearchResults Choreo.
     *
     * @param string $value (optional, string) Retrieves a list of videos that are related to this video id. When using this parameter, the Type parameter must be set to video.
     * @return YouTube_Search_ListSearchResults_Inputs For method chaining.
     */
    public function setRelatedToVideoID($value)
    {
        return $this->set('RelatedToVideoID', $value);
    }

    /**
     * Set the value for the TopicID input for this ListSearchResults Choreo.
     *
     * @param string $value (optional, string) Returns only results associated with the specified topic.
     * @return YouTube_Search_ListSearchResults_Inputs For method chaining.
     */
    public function setTopicID($value)
    {
        return $this->set('TopicID', $value);
    }

    /**
     * Set the value for the Type input for this ListSearchResults Choreo.
     *
     * @param string $value (optional, string) Restricts a search query to only retrieve a particular type of resource. The default value is: video,channel,playlist.
     * @return YouTube_Search_ListSearchResults_Inputs For method chaining.
     */
    public function setType($value)
    {
        return $this->set('Type', $value);
    }

    /**
     * Set the value for the VideoCaption input for this ListSearchResults Choreo.
     *
     * @param string $value (optional, string) Returns filtered results based on whether videos have captions. Valid values are: any (the default), closedCaption (only returns videos with captions), or none (only returns videos without captions).
     * @return YouTube_Search_ListSearchResults_Inputs For method chaining.
     */
    public function setVideoCaption($value)
    {
        return $this->set('VideoCaption', $value);
    }

    /**
     * Set the value for the VideoCategoryID input for this ListSearchResults Choreo.
     *
     * @param string $value (optional, string) Filters video search results based on their category.
     * @return YouTube_Search_ListSearchResults_Inputs For method chaining.
     */
    public function setVideoCategoryID($value)
    {
        return $this->set('VideoCategoryID', $value);
    }

    /**
     * Set the value for the VideoDefinition input for this ListSearchResults Choreo.
     *
     * @param string $value (optional, string) Filters video results based high or standard definition. Valid values are: any, high, or standard.
     * @return YouTube_Search_ListSearchResults_Inputs For method chaining.
     */
    public function setVideoDefinition($value)
    {
        return $this->set('VideoDefinition', $value);
    }

    /**
     * Set the value for the VideoDimension input for this ListSearchResults Choreo.
     *
     * @param string $value (optional, string) Restrict a search to only retrieve 2D or 3D videos. Valid values are: 2d, 3d, or any.
     * @return YouTube_Search_ListSearchResults_Inputs For method chaining.
     */
    public function setVideoDimension($value)
    {
        return $this->set('VideoDimension', $value);
    }

    /**
     * Set the value for the VideoDuration input for this ListSearchResults Choreo.
     *
     * @param string $value (optional, string) Filters search results based on the video duration. Valid values are: any, long, medium, and short.
     * @return YouTube_Search_ListSearchResults_Inputs For method chaining.
     */
    public function setVideoDuration($value)
    {
        return $this->set('VideoDuration', $value);
    }

    /**
     * Set the value for the VideoEmbeddable input for this ListSearchResults Choreo.
     *
     * @param string $value (optional, string) Filters search results to include only videos that can be embedded into a webpage. Valid values are: any (the default) or true (which will enable this filter).
     * @return YouTube_Search_ListSearchResults_Inputs For method chaining.
     */
    public function setVideoEmbeddable($value)
    {
        return $this->set('VideoEmbeddable', $value);
    }

    /**
     * Set the value for the VideoLicense input for this ListSearchResults Choreo.
     *
     * @param string $value (optional, string) Filters search results to only include videos with a particular license. Valid values are: any, creativeCommon, and youtube.
     * @return YouTube_Search_ListSearchResults_Inputs For method chaining.
     */
    public function setVideoLicense($value)
    {
        return $this->set('VideoLicense', $value);
    }

    /**
     * Set the value for the VideoSyndicated input for this ListSearchResults Choreo.
     *
     * @param string $value (optional, string) Filters search results for videos that can be played outside of youtube.com. Valid values are: any (the default) or true (which will enable this filter).
     * @return YouTube_Search_ListSearchResults_Inputs For method chaining.
     */
    public function setVideoSyndicated($value)
    {
        return $this->set('VideoSyndicated', $value);
    }

    /**
     * Set the value for the VideoType input for this ListSearchResults Choreo.
     *
     * @param string $value (optional, string) Filters search results to a particular type of videos. Valid values are: any, episode, and movie.
     * @return YouTube_Search_ListSearchResults_Inputs For method chaining.
     */
    public function setVideoType($value)
    {
        return $this->set('VideoType', $value);
    }
}


/**
 * Execution object for the ListSearchResults Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Search_ListSearchResults_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the ListSearchResults Choreo.
     *
     * @param Temboo_Session $session The session that owns this ListSearchResults execution.
     * @param YouTube_Search_ListSearchResults $choreo The choreography object for this execution.
     * @param YouTube_Search_ListSearchResults_Inputs|array $inputs (optional) Inputs as YouTube_Search_ListSearchResults_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return YouTube_Search_ListSearchResults_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, YouTube_Search_ListSearchResults $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this ListSearchResults execution.
     *
     * @return YouTube_Search_ListSearchResults_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this ListSearchResults execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return YouTube_Search_ListSearchResults_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new YouTube_Search_ListSearchResults_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the ListSearchResults Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Search_ListSearchResults_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the ListSearchResults Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return YouTube_Search_ListSearchResults_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this ListSearchResults execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this ListSearchResults execution.
     *
     * @return string (json) The response from YouTube.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Deletes a YouTube subscription.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Subscriptions_DeleteSubscription extends Temboo_Choreography
{
    /**
     * Deletes a YouTube subscription.
     *
     * @param Temboo_Session $session The session that owns this DeleteSubscription Choreo.
     * @return YouTube_Subscriptions_DeleteSubscription New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/YouTube/Subscriptions/DeleteSubscription/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this DeleteSubscription Choreo.
     *
     * @param YouTube_Subscriptions_DeleteSubscription_Inputs|array $inputs (optional) Inputs as YouTube_Subscriptions_DeleteSubscription_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return YouTube_Subscriptions_DeleteSubscription_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new YouTube_Subscriptions_DeleteSubscription_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this DeleteSubscription Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return YouTube_Subscriptions_DeleteSubscription_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new YouTube_Subscriptions_DeleteSubscription_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the DeleteSubscription Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Subscriptions_DeleteSubscription_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the DeleteSubscription Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return YouTube_Subscriptions_DeleteSubscription_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this DeleteSubscription input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return YouTube_Subscriptions_DeleteSubscription_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return YouTube_Subscriptions_DeleteSubscription_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this DeleteSubscription Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required for OAuth authentication unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return YouTube_Subscriptions_DeleteSubscription_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this DeleteSubscription Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_Subscriptions_DeleteSubscription_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this DeleteSubscription Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_Subscriptions_DeleteSubscription_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the RefreshToken input for this DeleteSubscription Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_Subscriptions_DeleteSubscription_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }

    /**
     * Set the value for the SubscriptionID input for this DeleteSubscription Choreo.
     *
     * @param string $value (required, string) The id of the subscription to delete.
     * @return YouTube_Subscriptions_DeleteSubscription_Inputs For method chaining.
     */
    public function setSubscriptionID($value)
    {
        return $this->set('SubscriptionID', $value);
    }
}


/**
 * Execution object for the DeleteSubscription Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Subscriptions_DeleteSubscription_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the DeleteSubscription Choreo.
     *
     * @param Temboo_Session $session The session that owns this DeleteSubscription execution.
     * @param YouTube_Subscriptions_DeleteSubscription $choreo The choreography object for this execution.
     * @param YouTube_Subscriptions_DeleteSubscription_Inputs|array $inputs (optional) Inputs as YouTube_Subscriptions_DeleteSubscription_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return YouTube_Subscriptions_DeleteSubscription_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, YouTube_Subscriptions_DeleteSubscription $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this DeleteSubscription execution.
     *
     * @return YouTube_Subscriptions_DeleteSubscription_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this DeleteSubscription execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return YouTube_Subscriptions_DeleteSubscription_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new YouTube_Subscriptions_DeleteSubscription_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the DeleteSubscription Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Subscriptions_DeleteSubscription_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the DeleteSubscription Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return YouTube_Subscriptions_DeleteSubscription_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this DeleteSubscription execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this DeleteSubscription execution.
     *
     * @return string (json) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Returns a list of the authenticated user's subscriptions.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Subscriptions_ListMySubscriptions extends Temboo_Choreography
{
    /**
     * Returns a list of the authenticated user's subscriptions.
     *
     * @param Temboo_Session $session The session that owns this ListMySubscriptions Choreo.
     * @return YouTube_Subscriptions_ListMySubscriptions New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/YouTube/Subscriptions/ListMySubscriptions/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this ListMySubscriptions Choreo.
     *
     * @param YouTube_Subscriptions_ListMySubscriptions_Inputs|array $inputs (optional) Inputs as YouTube_Subscriptions_ListMySubscriptions_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return YouTube_Subscriptions_ListMySubscriptions_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new YouTube_Subscriptions_ListMySubscriptions_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this ListMySubscriptions Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return YouTube_Subscriptions_ListMySubscriptions_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new YouTube_Subscriptions_ListMySubscriptions_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the ListMySubscriptions Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Subscriptions_ListMySubscriptions_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the ListMySubscriptions Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return YouTube_Subscriptions_ListMySubscriptions_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this ListMySubscriptions input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return YouTube_Subscriptions_ListMySubscriptions_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return YouTube_Subscriptions_ListMySubscriptions_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this ListMySubscriptions Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required for OAuth authentication unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return YouTube_Subscriptions_ListMySubscriptions_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this ListMySubscriptions Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_Subscriptions_ListMySubscriptions_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this ListMySubscriptions Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_Subscriptions_ListMySubscriptions_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Fields input for this ListMySubscriptions Choreo.
     *
     * @param string $value (optional, string) Allows you to specify a subset of fields to include in the response using an xpath-like syntax (i.e. items/snippet/title).
     * @return YouTube_Subscriptions_ListMySubscriptions_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the ForChannelId input for this ListMySubscriptions Choreo.
     *
     * @param string $value (optional, string) A comma-separated list of channel IDs. The response will include only subscription matching these channels.
     * @return YouTube_Subscriptions_ListMySubscriptions_Inputs For method chaining.
     */
    public function setForChannelId($value)
    {
        return $this->set('ForChannelId', $value);
    }

    /**
     * Set the value for the MaxResults input for this ListMySubscriptions Choreo.
     *
     * @param int $value (optional, integer) The maximum number of results to return.
     * @return YouTube_Subscriptions_ListMySubscriptions_Inputs For method chaining.
     */
    public function setMaxResults($value)
    {
        return $this->set('MaxResults', $value);
    }

    /**
     * Set the value for the Order input for this ListMySubscriptions Choreo.
     *
     * @param string $value (optional, string) Indicates how the results are sorted. Valid values are: alphabetical, relevance, or unread.
     * @return YouTube_Subscriptions_ListMySubscriptions_Inputs For method chaining.
     */
    public function setOrder($value)
    {
        return $this->set('Order', $value);
    }

    /**
     * Set the value for the PageToken input for this ListMySubscriptions Choreo.
     *
     * @param string $value (optional, string) The "nextPageToken" found in the response which is used to page through results.
     * @return YouTube_Subscriptions_ListMySubscriptions_Inputs For method chaining.
     */
    public function setPageToken($value)
    {
        return $this->set('PageToken', $value);
    }

    /**
     * Set the value for the Part input for this ListMySubscriptions Choreo.
     *
     * @param string $value (optional, string) A comma-separated list of fields to include. Valid values are: id, snippet, and contentDetails.
     * @return YouTube_Subscriptions_ListMySubscriptions_Inputs For method chaining.
     */
    public function setPart($value)
    {
        return $this->set('Part', $value);
    }

    /**
     * Set the value for the RefreshToken input for this ListMySubscriptions Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_Subscriptions_ListMySubscriptions_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }
}


/**
 * Execution object for the ListMySubscriptions Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Subscriptions_ListMySubscriptions_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the ListMySubscriptions Choreo.
     *
     * @param Temboo_Session $session The session that owns this ListMySubscriptions execution.
     * @param YouTube_Subscriptions_ListMySubscriptions $choreo The choreography object for this execution.
     * @param YouTube_Subscriptions_ListMySubscriptions_Inputs|array $inputs (optional) Inputs as YouTube_Subscriptions_ListMySubscriptions_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return YouTube_Subscriptions_ListMySubscriptions_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, YouTube_Subscriptions_ListMySubscriptions $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this ListMySubscriptions execution.
     *
     * @return YouTube_Subscriptions_ListMySubscriptions_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this ListMySubscriptions execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return YouTube_Subscriptions_ListMySubscriptions_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new YouTube_Subscriptions_ListMySubscriptions_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the ListMySubscriptions Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Subscriptions_ListMySubscriptions_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the ListMySubscriptions Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return YouTube_Subscriptions_ListMySubscriptions_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this ListMySubscriptions execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this ListMySubscriptions execution.
     *
     * @return string (json) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Returns a list of subscription for a specified channel.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Subscriptions_ListSubscriptionsByChannel extends Temboo_Choreography
{
    /**
     * Returns a list of subscription for a specified channel.
     *
     * @param Temboo_Session $session The session that owns this ListSubscriptionsByChannel Choreo.
     * @return YouTube_Subscriptions_ListSubscriptionsByChannel New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/YouTube/Subscriptions/ListSubscriptionsByChannel/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this ListSubscriptionsByChannel Choreo.
     *
     * @param YouTube_Subscriptions_ListSubscriptionsByChannel_Inputs|array $inputs (optional) Inputs as YouTube_Subscriptions_ListSubscriptionsByChannel_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return YouTube_Subscriptions_ListSubscriptionsByChannel_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new YouTube_Subscriptions_ListSubscriptionsByChannel_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this ListSubscriptionsByChannel Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return YouTube_Subscriptions_ListSubscriptionsByChannel_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new YouTube_Subscriptions_ListSubscriptionsByChannel_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the ListSubscriptionsByChannel Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Subscriptions_ListSubscriptionsByChannel_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the ListSubscriptionsByChannel Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return YouTube_Subscriptions_ListSubscriptionsByChannel_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this ListSubscriptionsByChannel input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return YouTube_Subscriptions_ListSubscriptionsByChannel_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return YouTube_Subscriptions_ListSubscriptionsByChannel_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the APIKey input for this ListSubscriptionsByChannel Choreo.
     *
     * @param string $value (optional, string) The API Key provided by Google for simple API access when you do not need to access user data.
     * @return YouTube_Subscriptions_ListSubscriptionsByChannel_Inputs For method chaining.
     */
    public function setAPIKey($value)
    {
        return $this->set('APIKey', $value);
    }

    /**
     * Set the value for the AccessToken input for this ListSubscriptionsByChannel Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required for OAuth authentication unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return YouTube_Subscriptions_ListSubscriptionsByChannel_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ChannelID input for this ListSubscriptionsByChannel Choreo.
     *
     * @param string $value (required, string) Indicates that the API only return this channel's subscriptions.
     * @return YouTube_Subscriptions_ListSubscriptionsByChannel_Inputs For method chaining.
     */
    public function setChannelID($value)
    {
        return $this->set('ChannelID', $value);
    }

    /**
     * Set the value for the ClientID input for this ListSubscriptionsByChannel Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_Subscriptions_ListSubscriptionsByChannel_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this ListSubscriptionsByChannel Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_Subscriptions_ListSubscriptionsByChannel_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Fields input for this ListSubscriptionsByChannel Choreo.
     *
     * @param string $value (optional, string) Allows you to specify a subset of fields to include in the response using an xpath-like syntax (i.e. items/snippet/title).
     * @return YouTube_Subscriptions_ListSubscriptionsByChannel_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the ForChannelId input for this ListSubscriptionsByChannel Choreo.
     *
     * @param string $value (optional, string) A comma-separated list of channel IDs. The response will include only subscription matching these channels.
     * @return YouTube_Subscriptions_ListSubscriptionsByChannel_Inputs For method chaining.
     */
    public function setForChannelId($value)
    {
        return $this->set('ForChannelId', $value);
    }

    /**
     * Set the value for the MaxResults input for this ListSubscriptionsByChannel Choreo.
     *
     * @param int $value (optional, integer) The maximum number of results to return.
     * @return YouTube_Subscriptions_ListSubscriptionsByChannel_Inputs For method chaining.
     */
    public function setMaxResults($value)
    {
        return $this->set('MaxResults', $value);
    }

    /**
     * Set the value for the Order input for this ListSubscriptionsByChannel Choreo.
     *
     * @param string $value (optional, string) Indicates how the results are sorted. Valid values are: alphabetical, relevance, or unread.
     * @return YouTube_Subscriptions_ListSubscriptionsByChannel_Inputs For method chaining.
     */
    public function setOrder($value)
    {
        return $this->set('Order', $value);
    }

    /**
     * Set the value for the PageToken input for this ListSubscriptionsByChannel Choreo.
     *
     * @param string $value (optional, string) The "nextPageToken" found in the response which is used to page through results.
     * @return YouTube_Subscriptions_ListSubscriptionsByChannel_Inputs For method chaining.
     */
    public function setPageToken($value)
    {
        return $this->set('PageToken', $value);
    }

    /**
     * Set the value for the Part input for this ListSubscriptionsByChannel Choreo.
     *
     * @param string $value (optional, string) A comma-separated list of fields to include. Valid values are: id, snippet, and contentDetails.
     * @return YouTube_Subscriptions_ListSubscriptionsByChannel_Inputs For method chaining.
     */
    public function setPart($value)
    {
        return $this->set('Part', $value);
    }

    /**
     * Set the value for the RefreshToken input for this ListSubscriptionsByChannel Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_Subscriptions_ListSubscriptionsByChannel_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }
}


/**
 * Execution object for the ListSubscriptionsByChannel Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Subscriptions_ListSubscriptionsByChannel_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the ListSubscriptionsByChannel Choreo.
     *
     * @param Temboo_Session $session The session that owns this ListSubscriptionsByChannel execution.
     * @param YouTube_Subscriptions_ListSubscriptionsByChannel $choreo The choreography object for this execution.
     * @param YouTube_Subscriptions_ListSubscriptionsByChannel_Inputs|array $inputs (optional) Inputs as YouTube_Subscriptions_ListSubscriptionsByChannel_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return YouTube_Subscriptions_ListSubscriptionsByChannel_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, YouTube_Subscriptions_ListSubscriptionsByChannel $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this ListSubscriptionsByChannel execution.
     *
     * @return YouTube_Subscriptions_ListSubscriptionsByChannel_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this ListSubscriptionsByChannel execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return YouTube_Subscriptions_ListSubscriptionsByChannel_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new YouTube_Subscriptions_ListSubscriptionsByChannel_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the ListSubscriptionsByChannel Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Subscriptions_ListSubscriptionsByChannel_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the ListSubscriptionsByChannel Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return YouTube_Subscriptions_ListSubscriptionsByChannel_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this ListSubscriptionsByChannel execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this ListSubscriptionsByChannel execution.
     *
     * @return string (json) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Returns a list of subscription that match the provided IDs.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Subscriptions_ListSubscriptionsByID extends Temboo_Choreography
{
    /**
     * Returns a list of subscription that match the provided IDs.
     *
     * @param Temboo_Session $session The session that owns this ListSubscriptionsByID Choreo.
     * @return YouTube_Subscriptions_ListSubscriptionsByID New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/YouTube/Subscriptions/ListSubscriptionsByID/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this ListSubscriptionsByID Choreo.
     *
     * @param YouTube_Subscriptions_ListSubscriptionsByID_Inputs|array $inputs (optional) Inputs as YouTube_Subscriptions_ListSubscriptionsByID_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return YouTube_Subscriptions_ListSubscriptionsByID_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new YouTube_Subscriptions_ListSubscriptionsByID_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this ListSubscriptionsByID Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return YouTube_Subscriptions_ListSubscriptionsByID_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new YouTube_Subscriptions_ListSubscriptionsByID_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the ListSubscriptionsByID Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Subscriptions_ListSubscriptionsByID_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the ListSubscriptionsByID Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return YouTube_Subscriptions_ListSubscriptionsByID_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this ListSubscriptionsByID input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return YouTube_Subscriptions_ListSubscriptionsByID_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return YouTube_Subscriptions_ListSubscriptionsByID_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the APIKey input for this ListSubscriptionsByID Choreo.
     *
     * @param string $value (optional, string) The API Key provided by Google for simple API access when you do not need to access user data.
     * @return YouTube_Subscriptions_ListSubscriptionsByID_Inputs For method chaining.
     */
    public function setAPIKey($value)
    {
        return $this->set('APIKey', $value);
    }

    /**
     * Set the value for the AccessToken input for this ListSubscriptionsByID Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required for OAuth authentication unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return YouTube_Subscriptions_ListSubscriptionsByID_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this ListSubscriptionsByID Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_Subscriptions_ListSubscriptionsByID_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this ListSubscriptionsByID Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_Subscriptions_ListSubscriptionsByID_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Fields input for this ListSubscriptionsByID Choreo.
     *
     * @param string $value (optional, string) Allows you to specify a subset of fields to include in the response using an xpath-like syntax (i.e. items/snippet/title).
     * @return YouTube_Subscriptions_ListSubscriptionsByID_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the ForChannelId input for this ListSubscriptionsByID Choreo.
     *
     * @param string $value (optional, string) A comma-separated list of channel IDs. The response will include only subscription matching these channels.
     * @return YouTube_Subscriptions_ListSubscriptionsByID_Inputs For method chaining.
     */
    public function setForChannelId($value)
    {
        return $this->set('ForChannelId', $value);
    }

    /**
     * Set the value for the MaxResults input for this ListSubscriptionsByID Choreo.
     *
     * @param int $value (optional, integer) The maximum number of results to return.
     * @return YouTube_Subscriptions_ListSubscriptionsByID_Inputs For method chaining.
     */
    public function setMaxResults($value)
    {
        return $this->set('MaxResults', $value);
    }

    /**
     * Set the value for the Order input for this ListSubscriptionsByID Choreo.
     *
     * @param string $value (optional, string) Indicates how the results are sorted. Valid values are: alphabetical, relevance, or unread.
     * @return YouTube_Subscriptions_ListSubscriptionsByID_Inputs For method chaining.
     */
    public function setOrder($value)
    {
        return $this->set('Order', $value);
    }

    /**
     * Set the value for the PageToken input for this ListSubscriptionsByID Choreo.
     *
     * @param string $value (optional, string) The "nextPageToken" found in the response which is used to page through results.
     * @return YouTube_Subscriptions_ListSubscriptionsByID_Inputs For method chaining.
     */
    public function setPageToken($value)
    {
        return $this->set('PageToken', $value);
    }

    /**
     * Set the value for the Part input for this ListSubscriptionsByID Choreo.
     *
     * @param string $value (optional, string) A comma-separated list of fields to include. Valid values are: id, snippet, and contentDetails.
     * @return YouTube_Subscriptions_ListSubscriptionsByID_Inputs For method chaining.
     */
    public function setPart($value)
    {
        return $this->set('Part', $value);
    }

    /**
     * Set the value for the RefreshToken input for this ListSubscriptionsByID Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_Subscriptions_ListSubscriptionsByID_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }

    /**
     * Set the value for the SubscriptionID input for this ListSubscriptionsByID Choreo.
     *
     * @param string $value (required, string) A comma-separated list of the YouTube subscription ID(s) for the resource(s) that are being retrieved.
     * @return YouTube_Subscriptions_ListSubscriptionsByID_Inputs For method chaining.
     */
    public function setSubscriptionID($value)
    {
        return $this->set('SubscriptionID', $value);
    }
}


/**
 * Execution object for the ListSubscriptionsByID Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Subscriptions_ListSubscriptionsByID_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the ListSubscriptionsByID Choreo.
     *
     * @param Temboo_Session $session The session that owns this ListSubscriptionsByID execution.
     * @param YouTube_Subscriptions_ListSubscriptionsByID $choreo The choreography object for this execution.
     * @param YouTube_Subscriptions_ListSubscriptionsByID_Inputs|array $inputs (optional) Inputs as YouTube_Subscriptions_ListSubscriptionsByID_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return YouTube_Subscriptions_ListSubscriptionsByID_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, YouTube_Subscriptions_ListSubscriptionsByID $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this ListSubscriptionsByID execution.
     *
     * @return YouTube_Subscriptions_ListSubscriptionsByID_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this ListSubscriptionsByID execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return YouTube_Subscriptions_ListSubscriptionsByID_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new YouTube_Subscriptions_ListSubscriptionsByID_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the ListSubscriptionsByID Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Subscriptions_ListSubscriptionsByID_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the ListSubscriptionsByID Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return YouTube_Subscriptions_ListSubscriptionsByID_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this ListSubscriptionsByID execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this ListSubscriptionsByID execution.
     *
     * @return string (json) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Adds a specified channel to the authenticated user's subscriptions.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Subscriptions_SubscribeToChannel extends Temboo_Choreography
{
    /**
     * Adds a specified channel to the authenticated user's subscriptions.
     *
     * @param Temboo_Session $session The session that owns this SubscribeToChannel Choreo.
     * @return YouTube_Subscriptions_SubscribeToChannel New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/YouTube/Subscriptions/SubscribeToChannel/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this SubscribeToChannel Choreo.
     *
     * @param YouTube_Subscriptions_SubscribeToChannel_Inputs|array $inputs (optional) Inputs as YouTube_Subscriptions_SubscribeToChannel_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return YouTube_Subscriptions_SubscribeToChannel_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new YouTube_Subscriptions_SubscribeToChannel_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this SubscribeToChannel Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return YouTube_Subscriptions_SubscribeToChannel_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new YouTube_Subscriptions_SubscribeToChannel_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the SubscribeToChannel Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Subscriptions_SubscribeToChannel_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the SubscribeToChannel Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return YouTube_Subscriptions_SubscribeToChannel_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this SubscribeToChannel input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return YouTube_Subscriptions_SubscribeToChannel_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return YouTube_Subscriptions_SubscribeToChannel_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this SubscribeToChannel Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required for OAuth authentication unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return YouTube_Subscriptions_SubscribeToChannel_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ChannelID input for this SubscribeToChannel Choreo.
     *
     * @param string $value (required, string) The id of the channel to subscribe to.
     * @return YouTube_Subscriptions_SubscribeToChannel_Inputs For method chaining.
     */
    public function setChannelID($value)
    {
        return $this->set('ChannelID', $value);
    }

    /**
     * Set the value for the ClientID input for this SubscribeToChannel Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_Subscriptions_SubscribeToChannel_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this SubscribeToChannel Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_Subscriptions_SubscribeToChannel_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Fields input for this SubscribeToChannel Choreo.
     *
     * @param string $value (optional, string) Allows you to specify a subset of fields to include in the response using an xpath-like syntax (i.e. items/snippet/title).
     * @return YouTube_Subscriptions_SubscribeToChannel_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Part input for this SubscribeToChannel Choreo.
     *
     * @param string $value (optional, string) A comma-separated list of fields that are being set and that will be returned in the response (i.e. snippet,contentDetails).
     * @return YouTube_Subscriptions_SubscribeToChannel_Inputs For method chaining.
     */
    public function setPart($value)
    {
        return $this->set('Part', $value);
    }

    /**
     * Set the value for the RefreshToken input for this SubscribeToChannel Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_Subscriptions_SubscribeToChannel_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }
}


/**
 * Execution object for the SubscribeToChannel Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Subscriptions_SubscribeToChannel_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the SubscribeToChannel Choreo.
     *
     * @param Temboo_Session $session The session that owns this SubscribeToChannel execution.
     * @param YouTube_Subscriptions_SubscribeToChannel $choreo The choreography object for this execution.
     * @param YouTube_Subscriptions_SubscribeToChannel_Inputs|array $inputs (optional) Inputs as YouTube_Subscriptions_SubscribeToChannel_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return YouTube_Subscriptions_SubscribeToChannel_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, YouTube_Subscriptions_SubscribeToChannel $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this SubscribeToChannel execution.
     *
     * @return YouTube_Subscriptions_SubscribeToChannel_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this SubscribeToChannel execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return YouTube_Subscriptions_SubscribeToChannel_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new YouTube_Subscriptions_SubscribeToChannel_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the SubscribeToChannel Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Subscriptions_SubscribeToChannel_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the SubscribeToChannel Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return YouTube_Subscriptions_SubscribeToChannel_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this SubscribeToChannel execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this SubscribeToChannel execution.
     *
     * @return string (json) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Returns a list of categories that match the provided IDs.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_VideoCategories_ListCategoriesByID extends Temboo_Choreography
{
    /**
     * Returns a list of categories that match the provided IDs.
     *
     * @param Temboo_Session $session The session that owns this ListCategoriesByID Choreo.
     * @return YouTube_VideoCategories_ListCategoriesByID New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/YouTube/VideoCategories/ListCategoriesByID/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this ListCategoriesByID Choreo.
     *
     * @param YouTube_VideoCategories_ListCategoriesByID_Inputs|array $inputs (optional) Inputs as YouTube_VideoCategories_ListCategoriesByID_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return YouTube_VideoCategories_ListCategoriesByID_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new YouTube_VideoCategories_ListCategoriesByID_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this ListCategoriesByID Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return YouTube_VideoCategories_ListCategoriesByID_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new YouTube_VideoCategories_ListCategoriesByID_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the ListCategoriesByID Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_VideoCategories_ListCategoriesByID_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the ListCategoriesByID Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return YouTube_VideoCategories_ListCategoriesByID_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this ListCategoriesByID input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return YouTube_VideoCategories_ListCategoriesByID_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return YouTube_VideoCategories_ListCategoriesByID_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the APIKey input for this ListCategoriesByID Choreo.
     *
     * @param string $value (optional, string) The API Key provided by Google for simple API access when you do not need to access user data.
     * @return YouTube_VideoCategories_ListCategoriesByID_Inputs For method chaining.
     */
    public function setAPIKey($value)
    {
        return $this->set('APIKey', $value);
    }

    /**
     * Set the value for the AccessToken input for this ListCategoriesByID Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required for OAuth authentication unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return YouTube_VideoCategories_ListCategoriesByID_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the CategoryID input for this ListCategoriesByID Choreo.
     *
     * @param string $value (conditional, string) A comma-separated list of the YouTube video category ID(s) that are being retrieved.
     * @return YouTube_VideoCategories_ListCategoriesByID_Inputs For method chaining.
     */
    public function setCategoryID($value)
    {
        return $this->set('CategoryID', $value);
    }

    /**
     * Set the value for the ClientID input for this ListCategoriesByID Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_VideoCategories_ListCategoriesByID_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this ListCategoriesByID Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_VideoCategories_ListCategoriesByID_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Fields input for this ListCategoriesByID Choreo.
     *
     * @param string $value (optional, string) Allows you to specify a subset of fields to include in the response using an xpath-like syntax (i.e. items/snippet/title).
     * @return YouTube_VideoCategories_ListCategoriesByID_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the H1 input for this ListCategoriesByID Choreo.
     *
     * @param string $value (optional, string) The hl parameter specifies the language that should be used for text values in the API response. The default value is en_US.
     * @return YouTube_VideoCategories_ListCategoriesByID_Inputs For method chaining.
     */
    public function setH1($value)
    {
        return $this->set('H1', $value);
    }

    /**
     * Set the value for the Part input for this ListCategoriesByID Choreo.
     *
     * @param string $value (optional, string) Specifies the videoCategory resource parts that the API response will include. Valid values are: id and snippet.
     * @return YouTube_VideoCategories_ListCategoriesByID_Inputs For method chaining.
     */
    public function setPart($value)
    {
        return $this->set('Part', $value);
    }

    /**
     * Set the value for the RefreshToken input for this ListCategoriesByID Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_VideoCategories_ListCategoriesByID_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }
}


/**
 * Execution object for the ListCategoriesByID Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_VideoCategories_ListCategoriesByID_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the ListCategoriesByID Choreo.
     *
     * @param Temboo_Session $session The session that owns this ListCategoriesByID execution.
     * @param YouTube_VideoCategories_ListCategoriesByID $choreo The choreography object for this execution.
     * @param YouTube_VideoCategories_ListCategoriesByID_Inputs|array $inputs (optional) Inputs as YouTube_VideoCategories_ListCategoriesByID_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return YouTube_VideoCategories_ListCategoriesByID_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, YouTube_VideoCategories_ListCategoriesByID $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this ListCategoriesByID execution.
     *
     * @return YouTube_VideoCategories_ListCategoriesByID_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this ListCategoriesByID execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return YouTube_VideoCategories_ListCategoriesByID_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new YouTube_VideoCategories_ListCategoriesByID_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the ListCategoriesByID Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_VideoCategories_ListCategoriesByID_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the ListCategoriesByID Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return YouTube_VideoCategories_ListCategoriesByID_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this ListCategoriesByID execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this ListCategoriesByID execution.
     *
     * @return string (json) The response from YouTube.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Returns a list of categories available in the specified country.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_VideoCategories_ListCategoriesByRegion extends Temboo_Choreography
{
    /**
     * Returns a list of categories available in the specified country.
     *
     * @param Temboo_Session $session The session that owns this ListCategoriesByRegion Choreo.
     * @return YouTube_VideoCategories_ListCategoriesByRegion New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/YouTube/VideoCategories/ListCategoriesByRegion/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this ListCategoriesByRegion Choreo.
     *
     * @param YouTube_VideoCategories_ListCategoriesByRegion_Inputs|array $inputs (optional) Inputs as YouTube_VideoCategories_ListCategoriesByRegion_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return YouTube_VideoCategories_ListCategoriesByRegion_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new YouTube_VideoCategories_ListCategoriesByRegion_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this ListCategoriesByRegion Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return YouTube_VideoCategories_ListCategoriesByRegion_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new YouTube_VideoCategories_ListCategoriesByRegion_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the ListCategoriesByRegion Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_VideoCategories_ListCategoriesByRegion_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the ListCategoriesByRegion Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return YouTube_VideoCategories_ListCategoriesByRegion_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this ListCategoriesByRegion input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return YouTube_VideoCategories_ListCategoriesByRegion_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return YouTube_VideoCategories_ListCategoriesByRegion_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the APIKey input for this ListCategoriesByRegion Choreo.
     *
     * @param string $value (optional, string) The API Key provided by Google for simple API access when you do not need to access user data.
     * @return YouTube_VideoCategories_ListCategoriesByRegion_Inputs For method chaining.
     */
    public function setAPIKey($value)
    {
        return $this->set('APIKey', $value);
    }

    /**
     * Set the value for the AccessToken input for this ListCategoriesByRegion Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required for OAuth authentication unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return YouTube_VideoCategories_ListCategoriesByRegion_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this ListCategoriesByRegion Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_VideoCategories_ListCategoriesByRegion_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this ListCategoriesByRegion Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_VideoCategories_ListCategoriesByRegion_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Fields input for this ListCategoriesByRegion Choreo.
     *
     * @param string $value (optional, string) Allows you to specify a subset of fields to include in the response using an xpath-like syntax (i.e. items/snippet/title).
     * @return YouTube_VideoCategories_ListCategoriesByRegion_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the H1 input for this ListCategoriesByRegion Choreo.
     *
     * @param string $value (optional, string) The hl parameter specifies the language that should be used for text values in the API response. The default value is en_US.
     * @return YouTube_VideoCategories_ListCategoriesByRegion_Inputs For method chaining.
     */
    public function setH1($value)
    {
        return $this->set('H1', $value);
    }

    /**
     * Set the value for the Part input for this ListCategoriesByRegion Choreo.
     *
     * @param string $value (optional, string) Specifies the videoCategory resource parts that the API response will include. Valid values are: id and snippet.
     * @return YouTube_VideoCategories_ListCategoriesByRegion_Inputs For method chaining.
     */
    public function setPart($value)
    {
        return $this->set('Part', $value);
    }

    /**
     * Set the value for the RefreshToken input for this ListCategoriesByRegion Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_VideoCategories_ListCategoriesByRegion_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }

    /**
     * Set the value for the RegionCode input for this ListCategoriesByRegion Choreo.
     *
     * @param string $value (conditional, string) Indicates to return the list of video categories available in the specified country. The parameter value is an ISO 3166-1 alpha-2 country code.
     * @return YouTube_VideoCategories_ListCategoriesByRegion_Inputs For method chaining.
     */
    public function setRegionCode($value)
    {
        return $this->set('RegionCode', $value);
    }
}


/**
 * Execution object for the ListCategoriesByRegion Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_VideoCategories_ListCategoriesByRegion_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the ListCategoriesByRegion Choreo.
     *
     * @param Temboo_Session $session The session that owns this ListCategoriesByRegion execution.
     * @param YouTube_VideoCategories_ListCategoriesByRegion $choreo The choreography object for this execution.
     * @param YouTube_VideoCategories_ListCategoriesByRegion_Inputs|array $inputs (optional) Inputs as YouTube_VideoCategories_ListCategoriesByRegion_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return YouTube_VideoCategories_ListCategoriesByRegion_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, YouTube_VideoCategories_ListCategoriesByRegion $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this ListCategoriesByRegion execution.
     *
     * @return YouTube_VideoCategories_ListCategoriesByRegion_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this ListCategoriesByRegion execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return YouTube_VideoCategories_ListCategoriesByRegion_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new YouTube_VideoCategories_ListCategoriesByRegion_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the ListCategoriesByRegion Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_VideoCategories_ListCategoriesByRegion_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the ListCategoriesByRegion Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return YouTube_VideoCategories_ListCategoriesByRegion_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this ListCategoriesByRegion execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this ListCategoriesByRegion execution.
     *
     * @return string (json) The response from YouTube.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Deletes a YouTube video.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Videos_DeleteVideo extends Temboo_Choreography
{
    /**
     * Deletes a YouTube video.
     *
     * @param Temboo_Session $session The session that owns this DeleteVideo Choreo.
     * @return YouTube_Videos_DeleteVideo New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/YouTube/Videos/DeleteVideo/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this DeleteVideo Choreo.
     *
     * @param YouTube_Videos_DeleteVideo_Inputs|array $inputs (optional) Inputs as YouTube_Videos_DeleteVideo_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return YouTube_Videos_DeleteVideo_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new YouTube_Videos_DeleteVideo_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this DeleteVideo Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return YouTube_Videos_DeleteVideo_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new YouTube_Videos_DeleteVideo_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the DeleteVideo Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Videos_DeleteVideo_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the DeleteVideo Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return YouTube_Videos_DeleteVideo_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this DeleteVideo input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return YouTube_Videos_DeleteVideo_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return YouTube_Videos_DeleteVideo_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this DeleteVideo Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required for OAuth authentication unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return YouTube_Videos_DeleteVideo_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this DeleteVideo Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_Videos_DeleteVideo_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this DeleteVideo Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_Videos_DeleteVideo_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the RefreshToken input for this DeleteVideo Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_Videos_DeleteVideo_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }

    /**
     * Set the value for the VideoID input for this DeleteVideo Choreo.
     *
     * @param string $value (required, string) The id of the video to delete.
     * @return YouTube_Videos_DeleteVideo_Inputs For method chaining.
     */
    public function setVideoID($value)
    {
        return $this->set('VideoID', $value);
    }
}


/**
 * Execution object for the DeleteVideo Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Videos_DeleteVideo_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the DeleteVideo Choreo.
     *
     * @param Temboo_Session $session The session that owns this DeleteVideo execution.
     * @param YouTube_Videos_DeleteVideo $choreo The choreography object for this execution.
     * @param YouTube_Videos_DeleteVideo_Inputs|array $inputs (optional) Inputs as YouTube_Videos_DeleteVideo_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return YouTube_Videos_DeleteVideo_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, YouTube_Videos_DeleteVideo $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this DeleteVideo execution.
     *
     * @return YouTube_Videos_DeleteVideo_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this DeleteVideo execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return YouTube_Videos_DeleteVideo_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new YouTube_Videos_DeleteVideo_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the DeleteVideo Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Videos_DeleteVideo_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the DeleteVideo Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return YouTube_Videos_DeleteVideo_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this DeleteVideo execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this DeleteVideo execution.
     *
     * @return string (json) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Returns a list of YouTube videos that match the IDs provided.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Videos_ListVideosByID extends Temboo_Choreography
{
    /**
     * Returns a list of YouTube videos that match the IDs provided.
     *
     * @param Temboo_Session $session The session that owns this ListVideosByID Choreo.
     * @return YouTube_Videos_ListVideosByID New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/YouTube/Videos/ListVideosByID/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this ListVideosByID Choreo.
     *
     * @param YouTube_Videos_ListVideosByID_Inputs|array $inputs (optional) Inputs as YouTube_Videos_ListVideosByID_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return YouTube_Videos_ListVideosByID_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new YouTube_Videos_ListVideosByID_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this ListVideosByID Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return YouTube_Videos_ListVideosByID_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new YouTube_Videos_ListVideosByID_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the ListVideosByID Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Videos_ListVideosByID_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the ListVideosByID Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return YouTube_Videos_ListVideosByID_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this ListVideosByID input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return YouTube_Videos_ListVideosByID_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return YouTube_Videos_ListVideosByID_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the APIKey input for this ListVideosByID Choreo.
     *
     * @param string $value (optional, string) The API Key provided by Google for simple API access when you do not need to access user data.
     * @return YouTube_Videos_ListVideosByID_Inputs For method chaining.
     */
    public function setAPIKey($value)
    {
        return $this->set('APIKey', $value);
    }

    /**
     * Set the value for the AccessToken input for this ListVideosByID Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required for OAuth authentication unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return YouTube_Videos_ListVideosByID_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this ListVideosByID Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_Videos_ListVideosByID_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this ListVideosByID Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_Videos_ListVideosByID_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Fields input for this ListVideosByID Choreo.
     *
     * @param string $value (optional, string) Allows you to specify a subset of fields to include in the response using an xpath-like syntax (i.e. items/snippet/title).
     * @return YouTube_Videos_ListVideosByID_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Part input for this ListVideosByID Choreo.
     *
     * @param string $value (optional, string) A comma-separated list of fields to include. Valid values are: id, snippet, contentDetails, fileDetails, player, processingDetails, recordingDetails, statistics, status, suggestions, and topicDetails.
     * @return YouTube_Videos_ListVideosByID_Inputs For method chaining.
     */
    public function setPart($value)
    {
        return $this->set('Part', $value);
    }

    /**
     * Set the value for the RefreshToken input for this ListVideosByID Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_Videos_ListVideosByID_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }

    /**
     * Set the value for the VideoID input for this ListVideosByID Choreo.
     *
     * @param string $value (required, string) A comma-separated list of the YouTube video ID(s) that are being retrieved.
     * @return YouTube_Videos_ListVideosByID_Inputs For method chaining.
     */
    public function setVideoID($value)
    {
        return $this->set('VideoID', $value);
    }
}


/**
 * Execution object for the ListVideosByID Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Videos_ListVideosByID_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the ListVideosByID Choreo.
     *
     * @param Temboo_Session $session The session that owns this ListVideosByID execution.
     * @param YouTube_Videos_ListVideosByID $choreo The choreography object for this execution.
     * @param YouTube_Videos_ListVideosByID_Inputs|array $inputs (optional) Inputs as YouTube_Videos_ListVideosByID_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return YouTube_Videos_ListVideosByID_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, YouTube_Videos_ListVideosByID $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this ListVideosByID execution.
     *
     * @return YouTube_Videos_ListVideosByID_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this ListVideosByID execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return YouTube_Videos_ListVideosByID_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new YouTube_Videos_ListVideosByID_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the ListVideosByID Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Videos_ListVideosByID_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the ListVideosByID Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return YouTube_Videos_ListVideosByID_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this ListVideosByID execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this ListVideosByID execution.
     *
     * @return string (json) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Inserts a new file.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Videos_ResumeUpload extends Temboo_Choreography
{
    /**
     * Inserts a new file.
     *
     * @param Temboo_Session $session The session that owns this ResumeUpload Choreo.
     * @return YouTube_Videos_ResumeUpload New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/YouTube/Videos/ResumeUpload/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this ResumeUpload Choreo.
     *
     * @param YouTube_Videos_ResumeUpload_Inputs|array $inputs (optional) Inputs as YouTube_Videos_ResumeUpload_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return YouTube_Videos_ResumeUpload_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new YouTube_Videos_ResumeUpload_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this ResumeUpload Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return YouTube_Videos_ResumeUpload_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new YouTube_Videos_ResumeUpload_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the ResumeUpload Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Videos_ResumeUpload_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the ResumeUpload Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return YouTube_Videos_ResumeUpload_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this ResumeUpload input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return YouTube_Videos_ResumeUpload_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return YouTube_Videos_ResumeUpload_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the RequestBody input for this ResumeUpload Choreo.
     *
     * @param string $value (conditional, json) A JSON representation of fields in a file resource. File metadata information (such as the title) can be inserted using this input. See documentation for formatting examples.
     * @return YouTube_Videos_ResumeUpload_Inputs For method chaining.
     */
    public function setRequestBody($value)
    {
        return $this->set('RequestBody', $value);
    }

    /**
     * Set the value for the AccessToken input for this ResumeUpload Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth2 process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return YouTube_Videos_ResumeUpload_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this ResumeUpload Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return YouTube_Videos_ResumeUpload_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this ResumeUpload Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return YouTube_Videos_ResumeUpload_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the ContentType input for this ResumeUpload Choreo.
     *
     * @param string $value (optional, string) The Content-Type of the file that is being uploaded. Defaults to application/octet-stream.
     * @return YouTube_Videos_ResumeUpload_Inputs For method chaining.
     */
    public function setContentType($value)
    {
        return $this->set('ContentType', $value);
    }

    /**
     * Set the value for the Fields input for this ResumeUpload Choreo.
     *
     * @param string $value (optional, string) Selector specifying a subset of fields to include in the response.
     * @return YouTube_Videos_ResumeUpload_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the FileContent input for this ResumeUpload Choreo.
     *
     * @param string $value (conditional, string) The Base64 encoded contents of the file to upload.
     * @return YouTube_Videos_ResumeUpload_Inputs For method chaining.
     */
    public function setFileContent($value)
    {
        return $this->set('FileContent', $value);
    }

    /**
     * Set the value for the Index input for this ResumeUpload Choreo.
     *
     * @param mixed $value (conditional, any) 
     * @return YouTube_Videos_ResumeUpload_Inputs For method chaining.
     */
    public function setIndex($value)
    {
        return $this->set('Index', $value);
    }

    /**
     * Set the value for the LastByte input for this ResumeUpload Choreo.
     *
     * @param int $value (conditional, integer) 
     * @return YouTube_Videos_ResumeUpload_Inputs For method chaining.
     */
    public function setLastByte($value)
    {
        return $this->set('LastByte', $value);
    }

    /**
     * Set the value for the Offset input for this ResumeUpload Choreo.
     *
     * @param mixed $value (conditional, any) 
     * @return YouTube_Videos_ResumeUpload_Inputs For method chaining.
     */
    public function setOffset($value)
    {
        return $this->set('Offset', $value);
    }

    /**
     * Set the value for the Part input for this ResumeUpload Choreo.
     *
     * @param string $value (required, string) This parameter identifies the properties that the write operation will set as well as the properties that the API response will include (e.g. snippet).
     * @return YouTube_Videos_ResumeUpload_Inputs For method chaining.
     */
    public function setPart($value)
    {
        return $this->set('Part', $value);
    }

    /**
     * Set the value for the RefreshToken input for this ResumeUpload Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return YouTube_Videos_ResumeUpload_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }

    /**
     * Set the value for the ResumeUploadID input for this ResumeUpload Choreo.
     *
     * @param string $value (optional, string) The UploadID used to resume a partially uploaded file.
     * @return YouTube_Videos_ResumeUpload_Inputs For method chaining.
     */
    public function setResumeUploadID($value)
    {
        return $this->set('ResumeUploadID', $value);
    }

    /**
     * Set the value for the Size input for this ResumeUpload Choreo.
     *
     * @param int $value (required, integer) 
     * @return YouTube_Videos_ResumeUpload_Inputs For method chaining.
     */
    public function setSize($value)
    {
        return $this->set('Size', $value);
    }

}


/**
 * Execution object for the ResumeUpload Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Videos_ResumeUpload_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the ResumeUpload Choreo.
     *
     * @param Temboo_Session $session The session that owns this ResumeUpload execution.
     * @param YouTube_Videos_ResumeUpload $choreo The choreography object for this execution.
     * @param YouTube_Videos_ResumeUpload_Inputs|array $inputs (optional) Inputs as YouTube_Videos_ResumeUpload_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return YouTube_Videos_ResumeUpload_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, YouTube_Videos_ResumeUpload $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this ResumeUpload execution.
     *
     * @return YouTube_Videos_ResumeUpload_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this ResumeUpload execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return YouTube_Videos_ResumeUpload_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new YouTube_Videos_ResumeUpload_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the ResumeUpload Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Videos_ResumeUpload_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the ResumeUpload Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return YouTube_Videos_ResumeUpload_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this ResumeUpload execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "ResponseCode" output from this ResumeUpload execution.
     *
     * @return int (integer) The response status code. A successful upload returns 201. An incomplete upload returns 308.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponseCode()
    {
        return $this->get('ResponseCode');
    }
    /**
     * Retrieve the value for the "UploadID" output from this ResumeUpload execution.
     *
     * @return string (string) 
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getUploadID()
    {
        return $this->get('UploadID');
    }
    /**
     * Retrieve the value for the "Response" output from this ResumeUpload execution.
     *
     * @return string (json) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Updates a video's metadata.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Videos_UpdateVideo extends Temboo_Choreography
{
    /**
     * Updates a video's metadata.
     *
     * @param Temboo_Session $session The session that owns this UpdateVideo Choreo.
     * @return YouTube_Videos_UpdateVideo New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/YouTube/Videos/UpdateVideo/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this UpdateVideo Choreo.
     *
     * @param YouTube_Videos_UpdateVideo_Inputs|array $inputs (optional) Inputs as YouTube_Videos_UpdateVideo_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return YouTube_Videos_UpdateVideo_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new YouTube_Videos_UpdateVideo_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this UpdateVideo Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return YouTube_Videos_UpdateVideo_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new YouTube_Videos_UpdateVideo_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the UpdateVideo Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Videos_UpdateVideo_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the UpdateVideo Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return YouTube_Videos_UpdateVideo_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this UpdateVideo input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return YouTube_Videos_UpdateVideo_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return YouTube_Videos_UpdateVideo_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the VideoMetadata input for this UpdateVideo Choreo.
     *
     * @param string $value (required, json) A JSON representation of the video resource containing fields to update. The id key for the video is required for updates. See documentation for examples.
     * @return YouTube_Videos_UpdateVideo_Inputs For method chaining.
     */
    public function setVideoMetadata($value)
    {
        return $this->set('VideoMetadata', $value);
    }

    /**
     * Set the value for the AccessToken input for this UpdateVideo Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required for OAuth authentication unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return YouTube_Videos_UpdateVideo_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this UpdateVideo Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_Videos_UpdateVideo_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this UpdateVideo Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_Videos_UpdateVideo_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Fields input for this UpdateVideo Choreo.
     *
     * @param string $value (optional, string) Allows you to specify a subset of fields to include in the response using an xpath-like syntax (i.e. items/snippet/title).
     * @return YouTube_Videos_UpdateVideo_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Part input for this UpdateVideo Choreo.
     *
     * @param string $value (optional, string) A comma-separated list of fields that are being set and that will be returned in the response (i.e. snippet,status).
     * @return YouTube_Videos_UpdateVideo_Inputs For method chaining.
     */
    public function setPart($value)
    {
        return $this->set('Part', $value);
    }

    /**
     * Set the value for the RefreshToken input for this UpdateVideo Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required for OAuth authentication unless providing a valid AccessToken.
     * @return YouTube_Videos_UpdateVideo_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }
}


/**
 * Execution object for the UpdateVideo Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Videos_UpdateVideo_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the UpdateVideo Choreo.
     *
     * @param Temboo_Session $session The session that owns this UpdateVideo execution.
     * @param YouTube_Videos_UpdateVideo $choreo The choreography object for this execution.
     * @param YouTube_Videos_UpdateVideo_Inputs|array $inputs (optional) Inputs as YouTube_Videos_UpdateVideo_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return YouTube_Videos_UpdateVideo_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, YouTube_Videos_UpdateVideo $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this UpdateVideo execution.
     *
     * @return YouTube_Videos_UpdateVideo_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this UpdateVideo execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return YouTube_Videos_UpdateVideo_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new YouTube_Videos_UpdateVideo_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the UpdateVideo Choreo.
 *
 * @package Temboo
 * @subpackage YouTube
 */
class YouTube_Videos_UpdateVideo_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the UpdateVideo Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return YouTube_Videos_UpdateVideo_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this UpdateVideo execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this UpdateVideo execution.
     *
     * @return string (json) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

?>