<?php

/**
 * Temboo PHP SDK Google classes
 *
 * Execute Choreographies from the Temboo Google bundle.
 *
 * PHP version 5
 *
 * LICENSE: Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @category   Services
 * @package    Temboo
 * @subpackage Google
 * @author     Temboo, Inc.
 * @copyright  2013 Temboo, Inc.
 * @license    http://www.apache.org/licenses/LICENSE-2.0 Apache License 2.0
 * @link       http://www.temboo.com
 */
/**
 * Retrieves metrics such as visits, page views, bounces within a specified time frame.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_Analytics_GetMetrics extends Temboo_Choreography
{
    /**
     * Retrieves metrics such as visits, page views, bounces within a specified time frame.
     *
     * @param Temboo_Session $session The session that owns this GetMetrics Choreo.
     * @return Google_Analytics_GetMetrics New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/Analytics/GetMetrics/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this GetMetrics Choreo.
     *
     * @param Google_Analytics_GetMetrics_Inputs|array $inputs (optional) Inputs as Google_Analytics_GetMetrics_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_Analytics_GetMetrics_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_Analytics_GetMetrics_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this GetMetrics Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_Analytics_GetMetrics_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_Analytics_GetMetrics_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the GetMetrics Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_Analytics_GetMetrics_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the GetMetrics Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_Analytics_GetMetrics_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this GetMetrics input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_Analytics_GetMetrics_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_Analytics_GetMetrics_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this GetMetrics Choreo.
     *
     * @param string $value (optional, string) A valid Access Token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new Access Token.
     * @return Google_Analytics_GetMetrics_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this GetMetrics Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_Analytics_GetMetrics_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this GetMetrics Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_Analytics_GetMetrics_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Dimensions input for this GetMetrics Choreo.
     *
     * @param string $value (optional, string) Defines the primary data keys for your Analytics report. Use dimensions to segment your web property metrics (e.g.  ga:browser or ga:city).
     * @return Google_Analytics_GetMetrics_Inputs For method chaining.
     */
    public function setDimensions($value)
    {
        return $this->set('Dimensions', $value);
    }

    /**
     * Set the value for the EndDate input for this GetMetrics Choreo.
     *
     * @param string $value (required, date) The end date for the range of data you want to retrieve. Epoch timestamp in milliseconds or formatted as yyyy-MM-dd.
     * @return Google_Analytics_GetMetrics_Inputs For method chaining.
     */
    public function setEndDate($value)
    {
        return $this->set('EndDate', $value);
    }

    /**
     * Set the value for the Filters input for this GetMetrics Choreo.
     *
     * @param string $value (optional, string) Restricts the data returned by a dimension or metric you want to filter by using an expression (i.e. ga:timeOnPage==10).
     * @return Google_Analytics_GetMetrics_Inputs For method chaining.
     */
    public function setFilters($value)
    {
        return $this->set('Filters', $value);
    }

    /**
     * Set the value for the MaxResults input for this GetMetrics Choreo.
     *
     * @param int $value (optional, integer) The max results to be returned in the feed. Defaults to 50.
     * @return Google_Analytics_GetMetrics_Inputs For method chaining.
     */
    public function setMaxResults($value)
    {
        return $this->set('MaxResults', $value);
    }

    /**
     * Set the value for the Metrics input for this GetMetrics Choreo.
     *
     * @param string $value (optional, string) This is a comma separated list of metrics you want to retrieve. Defaults to: ga:visits,ga:bounces,ga:pageviews.
     * @return Google_Analytics_GetMetrics_Inputs For method chaining.
     */
    public function setMetrics($value)
    {
        return $this->set('Metrics', $value);
    }

    /**
     * Set the value for the Password input for this GetMetrics Choreo.
     *
     * @param string $value (required, password) Deprecated (retained for backward compatibility only).
     * @return Google_Analytics_GetMetrics_Inputs For method chaining.
     */
    public function setPassword($value)
    {
        return $this->set('Password', $value);
    }

    /**
     * Set the value for the ProfileId input for this GetMetrics Choreo.
     *
     * @param int $value (required, integer) The Google Analytics Profile ID to access. This is also known as the View ID. It can be found in the Admin > View Settings section of a particular profile.
     * @return Google_Analytics_GetMetrics_Inputs For method chaining.
     */
    public function setProfileId($value)
    {
        return $this->set('ProfileId', $value);
    }

    /**
     * Set the value for the RefreshToken input for this GetMetrics Choreo.
     *
     * @param string $value (conditional, string) An OAuth Refresh Token used to generate a new Access Token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_Analytics_GetMetrics_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this GetMetrics Choreo.
     *
     * @param string $value (optional, string) The format that the response should be in. Valid values are: XML (the default) and JSON.
     * @return Google_Analytics_GetMetrics_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }

    /**
     * Set the value for the Segment input for this GetMetrics Choreo.
     *
     * @param string $value (optional, string) Used to segment your data by dimensions and/or metrics. You can use expressions for segments just as you would for the Filters parameter.
     * @return Google_Analytics_GetMetrics_Inputs For method chaining.
     */
    public function setSegment($value)
    {
        return $this->set('Segment', $value);
    }

    /**
     * Set the value for the Sort input for this GetMetrics Choreo.
     *
     * @param string $value (optional, string) Indicates the sorting order and direction for the returned data. Values can be separated by commas (i.e. ga:browser,ga:pageviews).
     * @return Google_Analytics_GetMetrics_Inputs For method chaining.
     */
    public function setSort($value)
    {
        return $this->set('Sort', $value);
    }

    /**
     * Set the value for the StartDate input for this GetMetrics Choreo.
     *
     * @param string $value (required, date) The start date for the range of data to retrieve. Use epoch timestamp in milliseconds or formatted as yyyy-MM-dd.
     * @return Google_Analytics_GetMetrics_Inputs For method chaining.
     */
    public function setStartDate($value)
    {
        return $this->set('StartDate', $value);
    }

    /**
     * Set the value for the StartIndex input for this GetMetrics Choreo.
     *
     * @param int $value (optional, integer) The starting entry for the feed. Defaults to 1.
     * @return Google_Analytics_GetMetrics_Inputs For method chaining.
     */
    public function setStartIndex($value)
    {
        return $this->set('StartIndex', $value);
    }

    /**
     * Set the value for the Username input for this GetMetrics Choreo.
     *
     * @param string $value (required, string) Deprecated (retained for backward compatibility only).
     * @return Google_Analytics_GetMetrics_Inputs For method chaining.
     */
    public function setUsername($value)
    {
        return $this->set('Username', $value);
    }
}


/**
 * Execution object for the GetMetrics Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_Analytics_GetMetrics_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the GetMetrics Choreo.
     *
     * @param Temboo_Session $session The session that owns this GetMetrics execution.
     * @param Google_Analytics_GetMetrics $choreo The choreography object for this execution.
     * @param Google_Analytics_GetMetrics_Inputs|array $inputs (optional) Inputs as Google_Analytics_GetMetrics_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_Analytics_GetMetrics_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_Analytics_GetMetrics $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this GetMetrics execution.
     *
     * @return Google_Analytics_GetMetrics_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this GetMetrics execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_Analytics_GetMetrics_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_Analytics_GetMetrics_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the GetMetrics Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_Analytics_GetMetrics_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the GetMetrics Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_Analytics_GetMetrics_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "Bounces" output from this GetMetrics execution.
     *
     * @return int (integer) The bounces metrics parsed from the Google Analytics response
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getBounces()
    {
        return $this->get('Bounces');
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this GetMetrics execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "PageViews" output from this GetMetrics execution.
     *
     * @return int (integer) The page views parsed from the Google Analytics response
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getPageViews()
    {
        return $this->get('PageViews');
    }
    /**
     * Retrieve the value for the "Visits" output from this GetMetrics execution.
     *
     * @return int (integer) The visits metrics parsed from the Google Analytics response.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getVisits()
    {
        return $this->get('Visits');
    }
    /**
     * Retrieve the value for the "Response" output from this GetMetrics execution.
     *
     * @return string The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Retrieves the results of a query with a given JobID when a query request times out and returns before the results are available.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_BigQuery_Jobs_GetQueryResults extends Temboo_Choreography
{
    /**
     * Retrieves the results of a query with a given JobID when a query request times out and returns before the results are available.
     *
     * @param Temboo_Session $session The session that owns this GetQueryResults Choreo.
     * @return Google_BigQuery_Jobs_GetQueryResults New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/BigQuery/Jobs/GetQueryResults/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this GetQueryResults Choreo.
     *
     * @param Google_BigQuery_Jobs_GetQueryResults_Inputs|array $inputs (optional) Inputs as Google_BigQuery_Jobs_GetQueryResults_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_BigQuery_Jobs_GetQueryResults_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_BigQuery_Jobs_GetQueryResults_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this GetQueryResults Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_BigQuery_Jobs_GetQueryResults_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_BigQuery_Jobs_GetQueryResults_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the GetQueryResults Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_BigQuery_Jobs_GetQueryResults_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the GetQueryResults Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_BigQuery_Jobs_GetQueryResults_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this GetQueryResults input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_BigQuery_Jobs_GetQueryResults_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_BigQuery_Jobs_GetQueryResults_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this GetQueryResults Choreo.
     *
     * @param string $value (optional, string) A valid Access Token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new Access Token.
     * @return Google_BigQuery_Jobs_GetQueryResults_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this GetQueryResults Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_BigQuery_Jobs_GetQueryResults_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this GetQueryResults Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_BigQuery_Jobs_GetQueryResults_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Fields input for this GetQueryResults Choreo.
     *
     * @param string $value (optional, string) Selector specifying which fields to include in a partial response.
     * @return Google_BigQuery_Jobs_GetQueryResults_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the JobID input for this GetQueryResults Choreo.
     *
     * @param string $value (required, string) Job ID of the query job.
     * @return Google_BigQuery_Jobs_GetQueryResults_Inputs For method chaining.
     */
    public function setJobID($value)
    {
        return $this->set('JobID', $value);
    }

    /**
     * Set the value for the MaxResults input for this GetQueryResults Choreo.
     *
     * @param int $value (optional, integer) Maximum number of results to return. Defaults to 100. Max is 1000.
     * @return Google_BigQuery_Jobs_GetQueryResults_Inputs For method chaining.
     */
    public function setMaxResults($value)
    {
        return $this->set('MaxResults', $value);
    }

    /**
     * Set the value for the PageToken input for this GetQueryResults Choreo.
     *
     * @param string $value (optional, string) Page token, returned by a previous call, identifying the result set.
     * @return Google_BigQuery_Jobs_GetQueryResults_Inputs For method chaining.
     */
    public function setPageToken($value)
    {
        return $this->set('PageToken', $value);
    }

    /**
     * Set the value for the ProjectID input for this GetQueryResults Choreo.
     *
     * @param string $value (required, string) The ID of your Google API project.
     * @return Google_BigQuery_Jobs_GetQueryResults_Inputs For method chaining.
     */
    public function setProjectID($value)
    {
        return $this->set('ProjectID', $value);
    }

    /**
     * Set the value for the RefreshToken input for this GetQueryResults Choreo.
     *
     * @param string $value (conditional, string) An OAuth Refresh Token used to generate a new Access Token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_BigQuery_Jobs_GetQueryResults_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }

    /**
     * Set the value for the StartIndex input for this GetQueryResults Choreo.
     *
     * @param int $value (optional, integer) Zero-based index of the starting row to read.
     * @return Google_BigQuery_Jobs_GetQueryResults_Inputs For method chaining.
     */
    public function setStartIndex($value)
    {
        return $this->set('StartIndex', $value);
    }

    /**
     * Set the value for the TimeoutMs input for this GetQueryResults Choreo.
     *
     * @param int $value (optional, integer) How long to wait for the query to complete, in milliseconds, before returning. Default is 10000. If the timeout passes before the job completes, the 'jobComplete' field in the response will be false.
     * @return Google_BigQuery_Jobs_GetQueryResults_Inputs For method chaining.
     */
    public function setTimeoutMs($value)
    {
        return $this->set('TimeoutMs', $value);
    }
}


/**
 * Execution object for the GetQueryResults Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_BigQuery_Jobs_GetQueryResults_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the GetQueryResults Choreo.
     *
     * @param Temboo_Session $session The session that owns this GetQueryResults execution.
     * @param Google_BigQuery_Jobs_GetQueryResults $choreo The choreography object for this execution.
     * @param Google_BigQuery_Jobs_GetQueryResults_Inputs|array $inputs (optional) Inputs as Google_BigQuery_Jobs_GetQueryResults_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_BigQuery_Jobs_GetQueryResults_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_BigQuery_Jobs_GetQueryResults $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this GetQueryResults execution.
     *
     * @return Google_BigQuery_Jobs_GetQueryResults_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this GetQueryResults execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_BigQuery_Jobs_GetQueryResults_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_BigQuery_Jobs_GetQueryResults_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the GetQueryResults Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_BigQuery_Jobs_GetQueryResults_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the GetQueryResults Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_BigQuery_Jobs_GetQueryResults_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this GetQueryResults execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this GetQueryResults execution.
     *
     * @return string (json) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Runs a BigQuery SQL query and returns results if the query completes within a specified timeout. When a query timeout occurs, results can be retrieved using the Job ID returned in the response.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_BigQuery_Jobs_Query extends Temboo_Choreography
{
    /**
     * Runs a BigQuery SQL query and returns results if the query completes within a specified timeout. When a query timeout occurs, results can be retrieved using the Job ID returned in the response.
     *
     * @param Temboo_Session $session The session that owns this Query Choreo.
     * @return Google_BigQuery_Jobs_Query New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/BigQuery/Jobs/Query/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this Query Choreo.
     *
     * @param Google_BigQuery_Jobs_Query_Inputs|array $inputs (optional) Inputs as Google_BigQuery_Jobs_Query_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_BigQuery_Jobs_Query_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_BigQuery_Jobs_Query_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this Query Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_BigQuery_Jobs_Query_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_BigQuery_Jobs_Query_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the Query Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_BigQuery_Jobs_Query_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the Query Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_BigQuery_Jobs_Query_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this Query input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_BigQuery_Jobs_Query_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_BigQuery_Jobs_Query_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this Query Choreo.
     *
     * @param string $value (optional, string) A valid Access Token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new Access Token.
     * @return Google_BigQuery_Jobs_Query_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this Query Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_BigQuery_Jobs_Query_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this Query Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_BigQuery_Jobs_Query_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the DatasetID input for this Query Choreo.
     *
     * @param string $value (optional, string) The ID of the dataset that your table belongs to.
     * @return Google_BigQuery_Jobs_Query_Inputs For method chaining.
     */
    public function setDatasetID($value)
    {
        return $this->set('DatasetID', $value);
    }

    /**
     * Set the value for the DryRun input for this Query Choreo.
     *
     * @param bool $value (optional, boolean) If set to true, BigQuery doesn't run the job. Instead, if the query is valid, BigQuery returns statistics about the job such as how many bytes would be processed. Defaults to false.
     * @return Google_BigQuery_Jobs_Query_Inputs For method chaining.
     */
    public function setDryRun($value)
    {
        return $this->set('DryRun', $value);
    }

    /**
     * Set the value for the Fields input for this Query Choreo.
     *
     * @param string $value (optional, string) Selector specifying which fields to include in a partial response.
     * @return Google_BigQuery_Jobs_Query_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the MaxResults input for this Query Choreo.
     *
     * @param int $value (optional, integer) Maximum number of results to return. Defaults to 100. Max is 1000.
     * @return Google_BigQuery_Jobs_Query_Inputs For method chaining.
     */
    public function setMaxResults($value)
    {
        return $this->set('MaxResults', $value);
    }

    /**
     * Set the value for the PageToken input for this Query Choreo.
     *
     * @param string $value (optional, string) Page token, returned by a previous call, identifying the result set.
     * @return Google_BigQuery_Jobs_Query_Inputs For method chaining.
     */
    public function setPageToken($value)
    {
        return $this->set('PageToken', $value);
    }

    /**
     * Set the value for the ProjectID input for this Query Choreo.
     *
     * @param string $value (required, string) The ID of your Google API project.
     * @return Google_BigQuery_Jobs_Query_Inputs For method chaining.
     */
    public function setProjectID($value)
    {
        return $this->set('ProjectID', $value);
    }

    /**
     * Set the value for the Query input for this Query Choreo.
     *
     * @param string $value (required, string) A query to execute. Example: SELECT count(f1) FROM [myProjectId:myDatasetId.myTableId].
     * @return Google_BigQuery_Jobs_Query_Inputs For method chaining.
     */
    public function setQuery($value)
    {
        return $this->set('Query', $value);
    }

    /**
     * Set the value for the RefreshToken input for this Query Choreo.
     *
     * @param string $value (conditional, string) An OAuth Refresh Token used to generate a new Access Token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_BigQuery_Jobs_Query_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }

    /**
     * Set the value for the TimeoutMs input for this Query Choreo.
     *
     * @param int $value (optional, integer) How long to wait for the query to complete, in milliseconds, before the request times out and returns. Defaults to 10000.
     * @return Google_BigQuery_Jobs_Query_Inputs For method chaining.
     */
    public function setTimeoutMs($value)
    {
        return $this->set('TimeoutMs', $value);
    }

    /**
     * Set the value for the UseQueryCache input for this Query Choreo.
     *
     * @param bool $value (optional, boolean) Whether to look for the result in the query cache. Defaults to true.
     * @return Google_BigQuery_Jobs_Query_Inputs For method chaining.
     */
    public function setUseQueryCache($value)
    {
        return $this->set('UseQueryCache', $value);
    }
}


/**
 * Execution object for the Query Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_BigQuery_Jobs_Query_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the Query Choreo.
     *
     * @param Temboo_Session $session The session that owns this Query execution.
     * @param Google_BigQuery_Jobs_Query $choreo The choreography object for this execution.
     * @param Google_BigQuery_Jobs_Query_Inputs|array $inputs (optional) Inputs as Google_BigQuery_Jobs_Query_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_BigQuery_Jobs_Query_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_BigQuery_Jobs_Query $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this Query execution.
     *
     * @return Google_BigQuery_Jobs_Query_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this Query execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_BigQuery_Jobs_Query_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_BigQuery_Jobs_Query_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the Query Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_BigQuery_Jobs_Query_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the Query Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_BigQuery_Jobs_Query_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this Query execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this Query execution.
     *
     * @return string (json) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Streams data into BigQuery one record at a time.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_BigQuery_TableData_InsertAll extends Temboo_Choreography
{
    /**
     * Streams data into BigQuery one record at a time.
     *
     * @param Temboo_Session $session The session that owns this InsertAll Choreo.
     * @return Google_BigQuery_TableData_InsertAll New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/BigQuery/TableData/InsertAll/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this InsertAll Choreo.
     *
     * @param Google_BigQuery_TableData_InsertAll_Inputs|array $inputs (optional) Inputs as Google_BigQuery_TableData_InsertAll_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_BigQuery_TableData_InsertAll_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_BigQuery_TableData_InsertAll_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this InsertAll Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_BigQuery_TableData_InsertAll_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_BigQuery_TableData_InsertAll_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the InsertAll Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_BigQuery_TableData_InsertAll_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the InsertAll Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_BigQuery_TableData_InsertAll_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this InsertAll input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_BigQuery_TableData_InsertAll_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_BigQuery_TableData_InsertAll_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this InsertAll Choreo.
     *
     * @param string $value (optional, string) A valid Access Token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new Access Token.
     * @return Google_BigQuery_TableData_InsertAll_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this InsertAll Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_BigQuery_TableData_InsertAll_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this InsertAll Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_BigQuery_TableData_InsertAll_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the DatasetID input for this InsertAll Choreo.
     *
     * @param string $value (required, string) The ID of the dataset that your table belongs to.
     * @return Google_BigQuery_TableData_InsertAll_Inputs For method chaining.
     */
    public function setDatasetID($value)
    {
        return $this->set('DatasetID', $value);
    }

    /**
     * Set the value for the Fields input for this InsertAll Choreo.
     *
     * @param string $value (optional, string) Selector specifying which fields to include in a partial response.
     * @return Google_BigQuery_TableData_InsertAll_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the IgnoreUnknownValues input for this InsertAll Choreo.
     *
     * @param bool $value (optional, boolean) Accept rows that contain values that do not match the schema. The unknown values are ignored. Default is false, which treats unknown values as errors.
     * @return Google_BigQuery_TableData_InsertAll_Inputs For method chaining.
     */
    public function setIgnoreUnknownValues($value)
    {
        return $this->set('IgnoreUnknownValues', $value);
    }

    /**
     * Set the value for the ProjectID input for this InsertAll Choreo.
     *
     * @param string $value (required, string) The ID of your Google API project.
     * @return Google_BigQuery_TableData_InsertAll_Inputs For method chaining.
     */
    public function setProjectID($value)
    {
        return $this->set('ProjectID', $value);
    }

    /**
     * Set the value for the RefreshToken input for this InsertAll Choreo.
     *
     * @param string $value (conditional, string) An OAuth Refresh Token used to generate a new Access Token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_BigQuery_TableData_InsertAll_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }

    /**
     * Set the value for the Rows input for this InsertAll Choreo.
     *
     * @param string $value (conditional, json) The rows to insert. This should be a JSON array containing at least one object representing a row. See Choreo notes for formatting details.
     * @return Google_BigQuery_TableData_InsertAll_Inputs For method chaining.
     */
    public function setRows($value)
    {
        return $this->set('Rows', $value);
    }

    /**
     * Set the value for the TableID input for this InsertAll Choreo.
     *
     * @param string $value (required, string) The ID of the BigQuery table to insert a row into.
     * @return Google_BigQuery_TableData_InsertAll_Inputs For method chaining.
     */
    public function setTableID($value)
    {
        return $this->set('TableID', $value);
    }
}


/**
 * Execution object for the InsertAll Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_BigQuery_TableData_InsertAll_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the InsertAll Choreo.
     *
     * @param Temboo_Session $session The session that owns this InsertAll execution.
     * @param Google_BigQuery_TableData_InsertAll $choreo The choreography object for this execution.
     * @param Google_BigQuery_TableData_InsertAll_Inputs|array $inputs (optional) Inputs as Google_BigQuery_TableData_InsertAll_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_BigQuery_TableData_InsertAll_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_BigQuery_TableData_InsertAll $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this InsertAll execution.
     *
     * @return Google_BigQuery_TableData_InsertAll_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this InsertAll execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_BigQuery_TableData_InsertAll_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_BigQuery_TableData_InsertAll_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the InsertAll Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_BigQuery_TableData_InsertAll_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the InsertAll Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_BigQuery_TableData_InsertAll_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this InsertAll execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this InsertAll execution.
     *
     * @return string (json) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Retrieves table data from a specified set of rows.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_BigQuery_TableData_List extends Temboo_Choreography
{
    /**
     * Retrieves table data from a specified set of rows.
     *
     * @param Temboo_Session $session The session that owns this List Choreo.
     * @return Google_BigQuery_TableData_List New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/BigQuery/TableData/List/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this List Choreo.
     *
     * @param Google_BigQuery_TableData_List_Inputs|array $inputs (optional) Inputs as Google_BigQuery_TableData_List_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_BigQuery_TableData_List_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_BigQuery_TableData_List_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this List Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_BigQuery_TableData_List_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_BigQuery_TableData_List_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the List Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_BigQuery_TableData_List_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the List Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_BigQuery_TableData_List_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this List input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_BigQuery_TableData_List_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_BigQuery_TableData_List_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this List Choreo.
     *
     * @param string $value (optional, string) A valid Access Token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new Access Token.
     * @return Google_BigQuery_TableData_List_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this List Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_BigQuery_TableData_List_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this List Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_BigQuery_TableData_List_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the DatasetID input for this List Choreo.
     *
     * @param string $value (required, string) The ID of the dataset that your table belongs to.
     * @return Google_BigQuery_TableData_List_Inputs For method chaining.
     */
    public function setDatasetID($value)
    {
        return $this->set('DatasetID', $value);
    }

    /**
     * Set the value for the Fields input for this List Choreo.
     *
     * @param string $value (optional, string) Selector specifying which fields to include in a partial response.
     * @return Google_BigQuery_TableData_List_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the MaxResults input for this List Choreo.
     *
     * @param int $value (optional, integer) Maximum number of results to return. Defaults to 100. Max is 1000.
     * @return Google_BigQuery_TableData_List_Inputs For method chaining.
     */
    public function setMaxResults($value)
    {
        return $this->set('MaxResults', $value);
    }

    /**
     * Set the value for the PageToken input for this List Choreo.
     *
     * @param string $value (optional, string) Page token, returned by a previous call, identifying the result set.
     * @return Google_BigQuery_TableData_List_Inputs For method chaining.
     */
    public function setPageToken($value)
    {
        return $this->set('PageToken', $value);
    }

    /**
     * Set the value for the ProjectID input for this List Choreo.
     *
     * @param string $value (required, string) The ID of your Google API project.
     * @return Google_BigQuery_TableData_List_Inputs For method chaining.
     */
    public function setProjectID($value)
    {
        return $this->set('ProjectID', $value);
    }

    /**
     * Set the value for the RefreshToken input for this List Choreo.
     *
     * @param string $value (conditional, string) An OAuth Refresh Token used to generate a new Access Token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_BigQuery_TableData_List_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }

    /**
     * Set the value for the StartIndex input for this List Choreo.
     *
     * @param int $value (optional, integer) Zero-based index of the starting row to read.
     * @return Google_BigQuery_TableData_List_Inputs For method chaining.
     */
    public function setStartIndex($value)
    {
        return $this->set('StartIndex', $value);
    }

    /**
     * Set the value for the TableID input for this List Choreo.
     *
     * @param string $value (required, string) The ID of the BigQuery table to insert a row into.
     * @return Google_BigQuery_TableData_List_Inputs For method chaining.
     */
    public function setTableID($value)
    {
        return $this->set('TableID', $value);
    }
}


/**
 * Execution object for the List Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_BigQuery_TableData_List_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the List Choreo.
     *
     * @param Temboo_Session $session The session that owns this List execution.
     * @param Google_BigQuery_TableData_List $choreo The choreography object for this execution.
     * @param Google_BigQuery_TableData_List_Inputs|array $inputs (optional) Inputs as Google_BigQuery_TableData_List_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_BigQuery_TableData_List_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_BigQuery_TableData_List $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this List execution.
     *
     * @return Google_BigQuery_TableData_List_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this List execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_BigQuery_TableData_List_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_BigQuery_TableData_List_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the List Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_BigQuery_TableData_List_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the List Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_BigQuery_TableData_List_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this List execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this List execution.
     *
     * @return string (json) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Create a new secondary calendar.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_Calendar_CreateCalendar extends Temboo_Choreography
{
    /**
     * Create a new secondary calendar.
     *
     * @param Temboo_Session $session The session that owns this CreateCalendar Choreo.
     * @return Google_Calendar_CreateCalendar New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/Calendar/CreateCalendar/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this CreateCalendar Choreo.
     *
     * @param Google_Calendar_CreateCalendar_Inputs|array $inputs (optional) Inputs as Google_Calendar_CreateCalendar_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_Calendar_CreateCalendar_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_Calendar_CreateCalendar_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this CreateCalendar Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_Calendar_CreateCalendar_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_Calendar_CreateCalendar_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the CreateCalendar Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_Calendar_CreateCalendar_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the CreateCalendar Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_Calendar_CreateCalendar_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this CreateCalendar input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_Calendar_CreateCalendar_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_Calendar_CreateCalendar_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this CreateCalendar Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Google_Calendar_CreateCalendar_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this CreateCalendar Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_Calendar_CreateCalendar_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this CreateCalendar Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_Calendar_CreateCalendar_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Description input for this CreateCalendar Choreo.
     *
     * @param string $value (optional, string) A description of the calendar.
     * @return Google_Calendar_CreateCalendar_Inputs For method chaining.
     */
    public function setDescription($value)
    {
        return $this->set('Description', $value);
    }

    /**
     * Set the value for the Location input for this CreateCalendar Choreo.
     *
     * @param string $value (optional, string) Geographic location of the calendar such as "Los Angeles" or "New York".
     * @return Google_Calendar_CreateCalendar_Inputs For method chaining.
     */
    public function setLocation($value)
    {
        return $this->set('Location', $value);
    }

    /**
     * Set the value for the RefreshToken input for this CreateCalendar Choreo.
     *
     * @param string $value (conditional, string) An OAuth Refresh Token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_Calendar_CreateCalendar_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this CreateCalendar Choreo.
     *
     * @param string $value (optional, string) The format that response should be in. Can be set to xml or json. Defaults to json.
     * @return Google_Calendar_CreateCalendar_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }

    /**
     * Set the value for the Timezone input for this CreateCalendar Choreo.
     *
     * @param string $value (optional, string) The timezone for the new calendar, such as "America/Los_Angeles". Defaults to UTC if left blank.
     * @return Google_Calendar_CreateCalendar_Inputs For method chaining.
     */
    public function setTimezone($value)
    {
        return $this->set('Timezone', $value);
    }

    /**
     * Set the value for the Title input for this CreateCalendar Choreo.
     *
     * @param string $value (required, string) The name for the new calendar.
     * @return Google_Calendar_CreateCalendar_Inputs For method chaining.
     */
    public function setTitle($value)
    {
        return $this->set('Title', $value);
    }
}


/**
 * Execution object for the CreateCalendar Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_Calendar_CreateCalendar_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the CreateCalendar Choreo.
     *
     * @param Temboo_Session $session The session that owns this CreateCalendar execution.
     * @param Google_Calendar_CreateCalendar $choreo The choreography object for this execution.
     * @param Google_Calendar_CreateCalendar_Inputs|array $inputs (optional) Inputs as Google_Calendar_CreateCalendar_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_Calendar_CreateCalendar_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_Calendar_CreateCalendar $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this CreateCalendar execution.
     *
     * @return Google_Calendar_CreateCalendar_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this CreateCalendar execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_Calendar_CreateCalendar_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_Calendar_CreateCalendar_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the CreateCalendar Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_Calendar_CreateCalendar_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the CreateCalendar Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_Calendar_CreateCalendar_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this CreateCalendar execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this CreateCalendar execution.
     *
     * @return string The response from Google. Corresponds to the ResponseFormat input. Defaults to JSON.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Create a new event in a specified calendar.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_Calendar_CreateEvent extends Temboo_Choreography
{
    /**
     * Create a new event in a specified calendar.
     *
     * @param Temboo_Session $session The session that owns this CreateEvent Choreo.
     * @return Google_Calendar_CreateEvent New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/Calendar/CreateEvent/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this CreateEvent Choreo.
     *
     * @param Google_Calendar_CreateEvent_Inputs|array $inputs (optional) Inputs as Google_Calendar_CreateEvent_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_Calendar_CreateEvent_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_Calendar_CreateEvent_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this CreateEvent Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_Calendar_CreateEvent_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_Calendar_CreateEvent_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the CreateEvent Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_Calendar_CreateEvent_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the CreateEvent Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_Calendar_CreateEvent_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this CreateEvent input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_Calendar_CreateEvent_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_Calendar_CreateEvent_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this CreateEvent Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Google_Calendar_CreateEvent_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the CalendarID input for this CreateEvent Choreo.
     *
     * @param string $value (required, string) The unique ID for the calendar in which to add the event.  Note that calendar IDs can be retrieved by running GetAllCalendars or SearchCalendarsByName.
     * @return Google_Calendar_CreateEvent_Inputs For method chaining.
     */
    public function setCalendarID($value)
    {
        return $this->set('CalendarID', $value);
    }

    /**
     * Set the value for the ClientID input for this CreateEvent Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_Calendar_CreateEvent_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this CreateEvent Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_Calendar_CreateEvent_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the EndDate input for this CreateEvent Choreo.
     *
     * @param string $value (required, string) The end date of the event, in the format "2012-04-10".
     * @return Google_Calendar_CreateEvent_Inputs For method chaining.
     */
    public function setEndDate($value)
    {
        return $this->set('EndDate', $value);
    }

    /**
     * Set the value for the EndTime input for this CreateEvent Choreo.
     *
     * @param string $value (required, string) The end time for the event, in the format "10:30:00".
     * @return Google_Calendar_CreateEvent_Inputs For method chaining.
     */
    public function setEndTime($value)
    {
        return $this->set('EndTime', $value);
    }

    /**
     * Set the value for the EventDescription input for this CreateEvent Choreo.
     *
     * @param string $value (optional, string) A short description of the event.
     * @return Google_Calendar_CreateEvent_Inputs For method chaining.
     */
    public function setEventDescription($value)
    {
        return $this->set('EventDescription', $value);
    }

    /**
     * Set the value for the EventLocation input for this CreateEvent Choreo.
     *
     * @param string $value (optional, string) The location for the new event.
     * @return Google_Calendar_CreateEvent_Inputs For method chaining.
     */
    public function setEventLocation($value)
    {
        return $this->set('EventLocation', $value);
    }

    /**
     * Set the value for the EventTitle input for this CreateEvent Choreo.
     *
     * @param string $value (required, string) The title for the new event.
     * @return Google_Calendar_CreateEvent_Inputs For method chaining.
     */
    public function setEventTitle($value)
    {
        return $this->set('EventTitle', $value);
    }

    /**
     * Set the value for the RefreshToken input for this CreateEvent Choreo.
     *
     * @param string $value (conditional, string) An OAuth Refresh Token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_Calendar_CreateEvent_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this CreateEvent Choreo.
     *
     * @param string $value (optional, string) The format that response should be in. Can be set to xml or json. Defaults to json.
     * @return Google_Calendar_CreateEvent_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }

    /**
     * Set the value for the StartDate input for this CreateEvent Choreo.
     *
     * @param string $value (required, string) The start date of the event, in the format "2012-11-03".
     * @return Google_Calendar_CreateEvent_Inputs For method chaining.
     */
    public function setStartDate($value)
    {
        return $this->set('StartDate', $value);
    }

    /**
     * Set the value for the StartTime input for this CreateEvent Choreo.
     *
     * @param string $value (required, string) The start time for the event, in the format "10:00:00".
     * @return Google_Calendar_CreateEvent_Inputs For method chaining.
     */
    public function setStartTime($value)
    {
        return $this->set('StartTime', $value);
    }
}


/**
 * Execution object for the CreateEvent Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_Calendar_CreateEvent_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the CreateEvent Choreo.
     *
     * @param Temboo_Session $session The session that owns this CreateEvent execution.
     * @param Google_Calendar_CreateEvent $choreo The choreography object for this execution.
     * @param Google_Calendar_CreateEvent_Inputs|array $inputs (optional) Inputs as Google_Calendar_CreateEvent_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_Calendar_CreateEvent_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_Calendar_CreateEvent $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this CreateEvent execution.
     *
     * @return Google_Calendar_CreateEvent_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this CreateEvent execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_Calendar_CreateEvent_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_Calendar_CreateEvent_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the CreateEvent Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_Calendar_CreateEvent_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the CreateEvent Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_Calendar_CreateEvent_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "TimezoneSetting" output from this CreateEvent execution.
     *
     * @return string (string) The timezone setting retrieved from the specified calendar.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getTimezoneSetting()
    {
        return $this->get('TimezoneSetting');
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this CreateEvent execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this CreateEvent execution.
     *
     * @return string The response from Google. Corresponds to the ResponseFormat input. Defaults to JSON.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Delete all events from a primary calendar of an account. Note that this operation can't be undone.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_Calendar_DeleteAllEvents extends Temboo_Choreography
{
    /**
     * Delete all events from a primary calendar of an account. Note that this operation can't be undone.
     *
     * @param Temboo_Session $session The session that owns this DeleteAllEvents Choreo.
     * @return Google_Calendar_DeleteAllEvents New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/Calendar/DeleteAllEvents/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this DeleteAllEvents Choreo.
     *
     * @param Google_Calendar_DeleteAllEvents_Inputs|array $inputs (optional) Inputs as Google_Calendar_DeleteAllEvents_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_Calendar_DeleteAllEvents_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_Calendar_DeleteAllEvents_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this DeleteAllEvents Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_Calendar_DeleteAllEvents_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_Calendar_DeleteAllEvents_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the DeleteAllEvents Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_Calendar_DeleteAllEvents_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the DeleteAllEvents Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_Calendar_DeleteAllEvents_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this DeleteAllEvents input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_Calendar_DeleteAllEvents_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_Calendar_DeleteAllEvents_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this DeleteAllEvents Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Google_Calendar_DeleteAllEvents_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this DeleteAllEvents Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_Calendar_DeleteAllEvents_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this DeleteAllEvents Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_Calendar_DeleteAllEvents_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the RefreshToken input for this DeleteAllEvents Choreo.
     *
     * @param string $value (conditional, string) An OAuth Refresh Token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_Calendar_DeleteAllEvents_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }
}


/**
 * Execution object for the DeleteAllEvents Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_Calendar_DeleteAllEvents_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the DeleteAllEvents Choreo.
     *
     * @param Temboo_Session $session The session that owns this DeleteAllEvents execution.
     * @param Google_Calendar_DeleteAllEvents $choreo The choreography object for this execution.
     * @param Google_Calendar_DeleteAllEvents_Inputs|array $inputs (optional) Inputs as Google_Calendar_DeleteAllEvents_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_Calendar_DeleteAllEvents_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_Calendar_DeleteAllEvents $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this DeleteAllEvents execution.
     *
     * @return Google_Calendar_DeleteAllEvents_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this DeleteAllEvents execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_Calendar_DeleteAllEvents_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_Calendar_DeleteAllEvents_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the DeleteAllEvents Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_Calendar_DeleteAllEvents_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the DeleteAllEvents Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_Calendar_DeleteAllEvents_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this DeleteAllEvents execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this DeleteAllEvents execution.
     *
     * @return string No content is returned for delete calendar operations.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Delete a secondary calendar.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_Calendar_DeleteCalendar extends Temboo_Choreography
{
    /**
     * Delete a secondary calendar.
     *
     * @param Temboo_Session $session The session that owns this DeleteCalendar Choreo.
     * @return Google_Calendar_DeleteCalendar New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/Calendar/DeleteCalendar/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this DeleteCalendar Choreo.
     *
     * @param Google_Calendar_DeleteCalendar_Inputs|array $inputs (optional) Inputs as Google_Calendar_DeleteCalendar_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_Calendar_DeleteCalendar_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_Calendar_DeleteCalendar_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this DeleteCalendar Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_Calendar_DeleteCalendar_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_Calendar_DeleteCalendar_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the DeleteCalendar Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_Calendar_DeleteCalendar_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the DeleteCalendar Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_Calendar_DeleteCalendar_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this DeleteCalendar input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_Calendar_DeleteCalendar_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_Calendar_DeleteCalendar_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this DeleteCalendar Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Google_Calendar_DeleteCalendar_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the CalendarID input for this DeleteCalendar Choreo.
     *
     * @param string $value (required, string) The unique ID for the calendar to delete. Note that calendar IDs can be retrieved by running GetAllCalendars or SearchCalendarsByName.
     * @return Google_Calendar_DeleteCalendar_Inputs For method chaining.
     */
    public function setCalendarID($value)
    {
        return $this->set('CalendarID', $value);
    }

    /**
     * Set the value for the ClientID input for this DeleteCalendar Choreo.
     *
     * @param string $value (required, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_Calendar_DeleteCalendar_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this DeleteCalendar Choreo.
     *
     * @param string $value (required, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_Calendar_DeleteCalendar_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the RefreshToken input for this DeleteCalendar Choreo.
     *
     * @param string $value (required, string) An OAuth Refresh Token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_Calendar_DeleteCalendar_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }
}


/**
 * Execution object for the DeleteCalendar Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_Calendar_DeleteCalendar_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the DeleteCalendar Choreo.
     *
     * @param Temboo_Session $session The session that owns this DeleteCalendar execution.
     * @param Google_Calendar_DeleteCalendar $choreo The choreography object for this execution.
     * @param Google_Calendar_DeleteCalendar_Inputs|array $inputs (optional) Inputs as Google_Calendar_DeleteCalendar_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_Calendar_DeleteCalendar_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_Calendar_DeleteCalendar $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this DeleteCalendar execution.
     *
     * @return Google_Calendar_DeleteCalendar_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this DeleteCalendar execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_Calendar_DeleteCalendar_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_Calendar_DeleteCalendar_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the DeleteCalendar Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_Calendar_DeleteCalendar_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the DeleteCalendar Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_Calendar_DeleteCalendar_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this DeleteCalendar execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this DeleteCalendar execution.
     *
     * @return string No content is returned for delete calendar operations.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Delete a specific event from a specified calendar.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_Calendar_DeleteEvent extends Temboo_Choreography
{
    /**
     * Delete a specific event from a specified calendar.
     *
     * @param Temboo_Session $session The session that owns this DeleteEvent Choreo.
     * @return Google_Calendar_DeleteEvent New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/Calendar/DeleteEvent/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this DeleteEvent Choreo.
     *
     * @param Google_Calendar_DeleteEvent_Inputs|array $inputs (optional) Inputs as Google_Calendar_DeleteEvent_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_Calendar_DeleteEvent_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_Calendar_DeleteEvent_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this DeleteEvent Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_Calendar_DeleteEvent_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_Calendar_DeleteEvent_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the DeleteEvent Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_Calendar_DeleteEvent_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the DeleteEvent Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_Calendar_DeleteEvent_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this DeleteEvent input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_Calendar_DeleteEvent_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_Calendar_DeleteEvent_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this DeleteEvent Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Google_Calendar_DeleteEvent_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the CalendarID input for this DeleteEvent Choreo.
     *
     * @param string $value (required, string) The unique ID for the calendar to delete. Note that calendar IDs can be retrieved by running GetAllCalendars or SearchCalendarsByName.
     * @return Google_Calendar_DeleteEvent_Inputs For method chaining.
     */
    public function setCalendarID($value)
    {
        return $this->set('CalendarID', $value);
    }

    /**
     * Set the value for the ClientID input for this DeleteEvent Choreo.
     *
     * @param string $value (conditional, string) The name of the calendar that you want to retrieve information for. Note that if there are multiple calendars with the same name, only the first one will be returned.
     * @return Google_Calendar_DeleteEvent_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this DeleteEvent Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_Calendar_DeleteEvent_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the EventID input for this DeleteEvent Choreo.
     *
     * @param string $value (required, string) The unique ID for the event to delete.
     * @return Google_Calendar_DeleteEvent_Inputs For method chaining.
     */
    public function setEventID($value)
    {
        return $this->set('EventID', $value);
    }

    /**
     * Set the value for the RefreshToken input for this DeleteEvent Choreo.
     *
     * @param string $value (conditional, string) An OAuth Refresh Token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_Calendar_DeleteEvent_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }
}


/**
 * Execution object for the DeleteEvent Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_Calendar_DeleteEvent_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the DeleteEvent Choreo.
     *
     * @param Temboo_Session $session The session that owns this DeleteEvent execution.
     * @param Google_Calendar_DeleteEvent $choreo The choreography object for this execution.
     * @param Google_Calendar_DeleteEvent_Inputs|array $inputs (optional) Inputs as Google_Calendar_DeleteEvent_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_Calendar_DeleteEvent_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_Calendar_DeleteEvent $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this DeleteEvent execution.
     *
     * @return Google_Calendar_DeleteEvent_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this DeleteEvent execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_Calendar_DeleteEvent_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_Calendar_DeleteEvent_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the DeleteEvent Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_Calendar_DeleteEvent_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the DeleteEvent Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_Calendar_DeleteEvent_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "AccessToken" output from this DeleteEvent execution.
     *
     * @return string (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getAccessToken()
    {
        return $this->get('AccessToken');
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this DeleteEvent execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this DeleteEvent execution.
     *
     * @return string No content is returned for delete calendar operations.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Retrieve data for all calendars.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_Calendar_GetAllCalendars extends Temboo_Choreography
{
    /**
     * Retrieve data for all calendars.
     *
     * @param Temboo_Session $session The session that owns this GetAllCalendars Choreo.
     * @return Google_Calendar_GetAllCalendars New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/Calendar/GetAllCalendars/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this GetAllCalendars Choreo.
     *
     * @param Google_Calendar_GetAllCalendars_Inputs|array $inputs (optional) Inputs as Google_Calendar_GetAllCalendars_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_Calendar_GetAllCalendars_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_Calendar_GetAllCalendars_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this GetAllCalendars Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_Calendar_GetAllCalendars_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_Calendar_GetAllCalendars_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the GetAllCalendars Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_Calendar_GetAllCalendars_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the GetAllCalendars Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_Calendar_GetAllCalendars_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this GetAllCalendars input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_Calendar_GetAllCalendars_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_Calendar_GetAllCalendars_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this GetAllCalendars Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Google_Calendar_GetAllCalendars_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this GetAllCalendars Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_Calendar_GetAllCalendars_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this GetAllCalendars Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_Calendar_GetAllCalendars_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Count input for this GetAllCalendars Choreo.
     *
     * @param int $value (optional, integer) The maximum number of calendars to return. The default is 15.
     * @return Google_Calendar_GetAllCalendars_Inputs For method chaining.
     */
    public function setCount($value)
    {
        return $this->set('Count', $value);
    }

    /**
     * Set the value for the Fields input for this GetAllCalendars Choreo.
     *
     * @param string $value (optional, string) The calendar fields to return. Accepted values are "etag", "items", "kind", and "nextPageToken". All calendar items are returned by default.
     * @return Google_Calendar_GetAllCalendars_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Hidden input for this GetAllCalendars Choreo.
     *
     * @param bool $value (optional, boolean) Enter "1" to return hidden calendars in the results, or "0" (the default) to not return them.
     * @return Google_Calendar_GetAllCalendars_Inputs For method chaining.
     */
    public function setHidden($value)
    {
        return $this->set('Hidden', $value);
    }

    /**
     * Set the value for the RefreshToken input for this GetAllCalendars Choreo.
     *
     * @param string $value (conditional, string) An OAuth Refresh Token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_Calendar_GetAllCalendars_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this GetAllCalendars Choreo.
     *
     * @param string $value (optional, string) The format that response should be in. Can be set to xml or json. Defaults to json.
     * @return Google_Calendar_GetAllCalendars_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }
}


/**
 * Execution object for the GetAllCalendars Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_Calendar_GetAllCalendars_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the GetAllCalendars Choreo.
     *
     * @param Temboo_Session $session The session that owns this GetAllCalendars execution.
     * @param Google_Calendar_GetAllCalendars $choreo The choreography object for this execution.
     * @param Google_Calendar_GetAllCalendars_Inputs|array $inputs (optional) Inputs as Google_Calendar_GetAllCalendars_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_Calendar_GetAllCalendars_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_Calendar_GetAllCalendars $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this GetAllCalendars execution.
     *
     * @return Google_Calendar_GetAllCalendars_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this GetAllCalendars execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_Calendar_GetAllCalendars_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_Calendar_GetAllCalendars_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the GetAllCalendars Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_Calendar_GetAllCalendars_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the GetAllCalendars Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_Calendar_GetAllCalendars_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this GetAllCalendars execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this GetAllCalendars execution.
     *
     * @return string The response from Google. Corresponds to the ResponseFormat input. Defaults to JSON.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Retrieve data for all events in a specified calendar.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_Calendar_GetAllEvents extends Temboo_Choreography
{
    /**
     * Retrieve data for all events in a specified calendar.
     *
     * @param Temboo_Session $session The session that owns this GetAllEvents Choreo.
     * @return Google_Calendar_GetAllEvents New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/Calendar/GetAllEvents/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this GetAllEvents Choreo.
     *
     * @param Google_Calendar_GetAllEvents_Inputs|array $inputs (optional) Inputs as Google_Calendar_GetAllEvents_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_Calendar_GetAllEvents_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_Calendar_GetAllEvents_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this GetAllEvents Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_Calendar_GetAllEvents_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_Calendar_GetAllEvents_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the GetAllEvents Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_Calendar_GetAllEvents_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the GetAllEvents Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_Calendar_GetAllEvents_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this GetAllEvents input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_Calendar_GetAllEvents_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_Calendar_GetAllEvents_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this GetAllEvents Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Google_Calendar_GetAllEvents_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the CalendarID input for this GetAllEvents Choreo.
     *
     * @param string $value (required, string) The unique ID for the calendar with the events to retrieve. Note that calendar IDs can be retrieved by running GetAllCalendars or SearchCalendarsByName.
     * @return Google_Calendar_GetAllEvents_Inputs For method chaining.
     */
    public function setCalendarID($value)
    {
        return $this->set('CalendarID', $value);
    }

    /**
     * Set the value for the ClientID input for this GetAllEvents Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_Calendar_GetAllEvents_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this GetAllEvents Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_Calendar_GetAllEvents_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the RefreshToken input for this GetAllEvents Choreo.
     *
     * @param string $value (conditional, string) An OAuth Refresh Token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_Calendar_GetAllEvents_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this GetAllEvents Choreo.
     *
     * @param string $value (optional, string) The format that response should be in. Can be set to xml or json. Defaults to json.
     * @return Google_Calendar_GetAllEvents_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }
}


/**
 * Execution object for the GetAllEvents Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_Calendar_GetAllEvents_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the GetAllEvents Choreo.
     *
     * @param Temboo_Session $session The session that owns this GetAllEvents execution.
     * @param Google_Calendar_GetAllEvents $choreo The choreography object for this execution.
     * @param Google_Calendar_GetAllEvents_Inputs|array $inputs (optional) Inputs as Google_Calendar_GetAllEvents_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_Calendar_GetAllEvents_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_Calendar_GetAllEvents $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this GetAllEvents execution.
     *
     * @return Google_Calendar_GetAllEvents_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this GetAllEvents execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_Calendar_GetAllEvents_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_Calendar_GetAllEvents_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the GetAllEvents Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_Calendar_GetAllEvents_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the GetAllEvents Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_Calendar_GetAllEvents_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this GetAllEvents execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this GetAllEvents execution.
     *
     * @return string The response from Google. Corresponds to the ResponseFormat input. Defaults to JSON.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Retrieves all settings for a Google Calendar account.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_Calendar_GetAllSettings extends Temboo_Choreography
{
    /**
     * Retrieves all settings for a Google Calendar account.
     *
     * @param Temboo_Session $session The session that owns this GetAllSettings Choreo.
     * @return Google_Calendar_GetAllSettings New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/Calendar/GetAllSettings/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this GetAllSettings Choreo.
     *
     * @param Google_Calendar_GetAllSettings_Inputs|array $inputs (optional) Inputs as Google_Calendar_GetAllSettings_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_Calendar_GetAllSettings_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_Calendar_GetAllSettings_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this GetAllSettings Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_Calendar_GetAllSettings_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_Calendar_GetAllSettings_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the GetAllSettings Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_Calendar_GetAllSettings_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the GetAllSettings Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_Calendar_GetAllSettings_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this GetAllSettings input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_Calendar_GetAllSettings_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_Calendar_GetAllSettings_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this GetAllSettings Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Google_Calendar_GetAllSettings_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this GetAllSettings Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_Calendar_GetAllSettings_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this GetAllSettings Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_Calendar_GetAllSettings_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Fields input for this GetAllSettings Choreo.
     *
     * @param string $value (optional, string) The settings fields to return. Returns etag, item IDs, and item values by default.
     * @return Google_Calendar_GetAllSettings_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the RefreshToken input for this GetAllSettings Choreo.
     *
     * @param string $value (conditional, string) An OAuth Refresh Token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_Calendar_GetAllSettings_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this GetAllSettings Choreo.
     *
     * @param string $value (optional, string) The format that response should be in. Can be set to xml or json. Defaults to json.
     * @return Google_Calendar_GetAllSettings_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }
}


/**
 * Execution object for the GetAllSettings Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_Calendar_GetAllSettings_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the GetAllSettings Choreo.
     *
     * @param Temboo_Session $session The session that owns this GetAllSettings execution.
     * @param Google_Calendar_GetAllSettings $choreo The choreography object for this execution.
     * @param Google_Calendar_GetAllSettings_Inputs|array $inputs (optional) Inputs as Google_Calendar_GetAllSettings_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_Calendar_GetAllSettings_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_Calendar_GetAllSettings $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this GetAllSettings execution.
     *
     * @return Google_Calendar_GetAllSettings_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this GetAllSettings execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_Calendar_GetAllSettings_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_Calendar_GetAllSettings_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the GetAllSettings Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_Calendar_GetAllSettings_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the GetAllSettings Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_Calendar_GetAllSettings_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this GetAllSettings execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this GetAllSettings execution.
     *
     * @return string The response from Google. Corresponds to the ResponseFormat input. Defaults to JSON.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Retrieve data for a specific calendar in a Google account.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_Calendar_GetCalendar extends Temboo_Choreography
{
    /**
     * Retrieve data for a specific calendar in a Google account.
     *
     * @param Temboo_Session $session The session that owns this GetCalendar Choreo.
     * @return Google_Calendar_GetCalendar New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/Calendar/GetCalendar/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this GetCalendar Choreo.
     *
     * @param Google_Calendar_GetCalendar_Inputs|array $inputs (optional) Inputs as Google_Calendar_GetCalendar_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_Calendar_GetCalendar_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_Calendar_GetCalendar_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this GetCalendar Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_Calendar_GetCalendar_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_Calendar_GetCalendar_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the GetCalendar Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_Calendar_GetCalendar_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the GetCalendar Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_Calendar_GetCalendar_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this GetCalendar input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_Calendar_GetCalendar_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_Calendar_GetCalendar_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this GetCalendar Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Google_Calendar_GetCalendar_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the CalendarID input for this GetCalendar Choreo.
     *
     * @param string $value (required, string) The unique ID for the calendar  to retrieve. Note that calendar IDs can be retrieved by running GetAllCalendars or SearchCalendarsByName.
     * @return Google_Calendar_GetCalendar_Inputs For method chaining.
     */
    public function setCalendarID($value)
    {
        return $this->set('CalendarID', $value);
    }

    /**
     * Set the value for the ClientID input for this GetCalendar Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_Calendar_GetCalendar_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this GetCalendar Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_Calendar_GetCalendar_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the RefreshToken input for this GetCalendar Choreo.
     *
     * @param string $value (conditional, string) An OAuth Refresh Token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_Calendar_GetCalendar_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this GetCalendar Choreo.
     *
     * @param string $value (optional, string) The format that response should be in. Can be set to xml or json. Defaults to json.
     * @return Google_Calendar_GetCalendar_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }
}


/**
 * Execution object for the GetCalendar Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_Calendar_GetCalendar_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the GetCalendar Choreo.
     *
     * @param Temboo_Session $session The session that owns this GetCalendar execution.
     * @param Google_Calendar_GetCalendar $choreo The choreography object for this execution.
     * @param Google_Calendar_GetCalendar_Inputs|array $inputs (optional) Inputs as Google_Calendar_GetCalendar_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_Calendar_GetCalendar_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_Calendar_GetCalendar $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this GetCalendar execution.
     *
     * @return Google_Calendar_GetCalendar_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this GetCalendar execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_Calendar_GetCalendar_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_Calendar_GetCalendar_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the GetCalendar Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_Calendar_GetCalendar_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the GetCalendar Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_Calendar_GetCalendar_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this GetCalendar execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this GetCalendar execution.
     *
     * @return string The response from Google. Corresponds to the ResponseFormat input. Defaults to JSON.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Retrieve data for all calendars in an account.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_Calendar_GetEvent extends Temboo_Choreography
{
    /**
     * Retrieve data for all calendars in an account.
     *
     * @param Temboo_Session $session The session that owns this GetEvent Choreo.
     * @return Google_Calendar_GetEvent New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/Calendar/GetEvent/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this GetEvent Choreo.
     *
     * @param Google_Calendar_GetEvent_Inputs|array $inputs (optional) Inputs as Google_Calendar_GetEvent_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_Calendar_GetEvent_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_Calendar_GetEvent_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this GetEvent Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_Calendar_GetEvent_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_Calendar_GetEvent_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the GetEvent Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_Calendar_GetEvent_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the GetEvent Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_Calendar_GetEvent_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this GetEvent input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_Calendar_GetEvent_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_Calendar_GetEvent_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this GetEvent Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Google_Calendar_GetEvent_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the CalendarID input for this GetEvent Choreo.
     *
     * @param string $value (required, string) The unique ID for the calendar with the event to retrieve. Note that calendar IDs can be retrieved by running GetAllCalendars or SearchCalendarsByName.
     * @return Google_Calendar_GetEvent_Inputs For method chaining.
     */
    public function setCalendarID($value)
    {
        return $this->set('CalendarID', $value);
    }

    /**
     * Set the value for the ClientID input for this GetEvent Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_Calendar_GetEvent_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this GetEvent Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_Calendar_GetEvent_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the EventID input for this GetEvent Choreo.
     *
     * @param string $value (required, string) The unique ID for the event to retrieve.
     * @return Google_Calendar_GetEvent_Inputs For method chaining.
     */
    public function setEventID($value)
    {
        return $this->set('EventID', $value);
    }

    /**
     * Set the value for the RefreshToken input for this GetEvent Choreo.
     *
     * @param string $value (conditional, string) An OAuth Refresh Token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_Calendar_GetEvent_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this GetEvent Choreo.
     *
     * @param string $value (optional, string) The format that response should be in. Can be set to xml or json. Defaults to json.
     * @return Google_Calendar_GetEvent_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }
}


/**
 * Execution object for the GetEvent Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_Calendar_GetEvent_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the GetEvent Choreo.
     *
     * @param Temboo_Session $session The session that owns this GetEvent execution.
     * @param Google_Calendar_GetEvent $choreo The choreography object for this execution.
     * @param Google_Calendar_GetEvent_Inputs|array $inputs (optional) Inputs as Google_Calendar_GetEvent_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_Calendar_GetEvent_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_Calendar_GetEvent $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this GetEvent execution.
     *
     * @return Google_Calendar_GetEvent_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this GetEvent execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_Calendar_GetEvent_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_Calendar_GetEvent_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the GetEvent Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_Calendar_GetEvent_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the GetEvent Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_Calendar_GetEvent_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this GetEvent execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this GetEvent execution.
     *
     * @return string The response from Google. Corresponds to the ResponseFormat input. Defaults to JSON.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Retrieves the next upcoming event in a Google calendar based on the current timestamp and the specified calendar's timezone setting.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_Calendar_GetNextEvent extends Temboo_Choreography
{
    /**
     * Retrieves the next upcoming event in a Google calendar based on the current timestamp and the specified calendar's timezone setting.
     *
     * @param Temboo_Session $session The session that owns this GetNextEvent Choreo.
     * @return Google_Calendar_GetNextEvent New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/Calendar/GetNextEvent/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this GetNextEvent Choreo.
     *
     * @param Google_Calendar_GetNextEvent_Inputs|array $inputs (optional) Inputs as Google_Calendar_GetNextEvent_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_Calendar_GetNextEvent_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_Calendar_GetNextEvent_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this GetNextEvent Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_Calendar_GetNextEvent_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_Calendar_GetNextEvent_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the GetNextEvent Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_Calendar_GetNextEvent_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the GetNextEvent Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_Calendar_GetNextEvent_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this GetNextEvent input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_Calendar_GetNextEvent_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_Calendar_GetNextEvent_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this GetNextEvent Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Google_Calendar_GetNextEvent_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the CalendarID input for this GetNextEvent Choreo.
     *
     * @param string $value (required, string) The unique ID for the calendar with the next event to retrieve. Note that calendar IDs can be retrieved by running GetAllCalendars or SearchCalendarsByName.
     * @return Google_Calendar_GetNextEvent_Inputs For method chaining.
     */
    public function setCalendarID($value)
    {
        return $this->set('CalendarID', $value);
    }

    /**
     * Set the value for the ClientID input for this GetNextEvent Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_Calendar_GetNextEvent_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this GetNextEvent Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_Calendar_GetNextEvent_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the RefreshToken input for this GetNextEvent Choreo.
     *
     * @param string $value (conditional, string) An OAuth Refresh Token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_Calendar_GetNextEvent_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this GetNextEvent Choreo.
     *
     * @param string $value (optional, string) The format that response should be in. Can be set to xml or json. Defaults to json.
     * @return Google_Calendar_GetNextEvent_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }

    /**
     * Set the value for the Timezone input for this GetNextEvent Choreo.
     *
     * @param string $value (optional, string) The time zone used in the response (i.e. America/Los_Angeles). The default is the time zone of the calendar.
     * @return Google_Calendar_GetNextEvent_Inputs For method chaining.
     */
    public function setTimezone($value)
    {
        return $this->set('Timezone', $value);
    }
}


/**
 * Execution object for the GetNextEvent Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_Calendar_GetNextEvent_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the GetNextEvent Choreo.
     *
     * @param Temboo_Session $session The session that owns this GetNextEvent execution.
     * @param Google_Calendar_GetNextEvent $choreo The choreography object for this execution.
     * @param Google_Calendar_GetNextEvent_Inputs|array $inputs (optional) Inputs as Google_Calendar_GetNextEvent_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_Calendar_GetNextEvent_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_Calendar_GetNextEvent $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this GetNextEvent execution.
     *
     * @return Google_Calendar_GetNextEvent_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this GetNextEvent execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_Calendar_GetNextEvent_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_Calendar_GetNextEvent_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the GetNextEvent Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_Calendar_GetNextEvent_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the GetNextEvent Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_Calendar_GetNextEvent_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "BeginTime" output from this GetNextEvent execution.
     *
     * @return string (date) The start time of the event.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getBeginTime()
    {
        return $this->get('BeginTime');
    }
    /**
     * Retrieve the value for the "EndTime" output from this GetNextEvent execution.
     *
     * @return string (date) The end time of the event.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getEndTime()
    {
        return $this->get('EndTime');
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this GetNextEvent execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Summary" output from this GetNextEvent execution.
     *
     * @return string (string) The event summary.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getSummary()
    {
        return $this->get('Summary');
    }
    /**
     * Retrieve the value for the "Response" output from this GetNextEvent execution.
     *
     * @return string The response from Google. Corresponds to the ResponseFormat input. Defaults to JSON.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Retrieves a specifed setting for a Google Calendar account.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_Calendar_GetSetting extends Temboo_Choreography
{
    /**
     * Retrieves a specifed setting for a Google Calendar account.
     *
     * @param Temboo_Session $session The session that owns this GetSetting Choreo.
     * @return Google_Calendar_GetSetting New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/Calendar/GetSetting/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this GetSetting Choreo.
     *
     * @param Google_Calendar_GetSetting_Inputs|array $inputs (optional) Inputs as Google_Calendar_GetSetting_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_Calendar_GetSetting_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_Calendar_GetSetting_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this GetSetting Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_Calendar_GetSetting_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_Calendar_GetSetting_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the GetSetting Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_Calendar_GetSetting_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the GetSetting Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_Calendar_GetSetting_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this GetSetting input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_Calendar_GetSetting_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_Calendar_GetSetting_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this GetSetting Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Google_Calendar_GetSetting_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this GetSetting Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_Calendar_GetSetting_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this GetSetting Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_Calendar_GetSetting_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the RefreshToken input for this GetSetting Choreo.
     *
     * @param string $value (conditional, string) An OAuth Refresh Token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_Calendar_GetSetting_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this GetSetting Choreo.
     *
     * @param string $value (optional, string) The format that response should be in. Can be set to xml or json. Defaults to json.
     * @return Google_Calendar_GetSetting_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }

    /**
     * Set the value for the SettingID input for this GetSetting Choreo.
     *
     * @param string $value (required, string) The unique ID for the setting to retrieve. Use the GetAllSettings Choreo to retrieve settings IDs.
     * @return Google_Calendar_GetSetting_Inputs For method chaining.
     */
    public function setSettingID($value)
    {
        return $this->set('SettingID', $value);
    }
}


/**
 * Execution object for the GetSetting Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_Calendar_GetSetting_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the GetSetting Choreo.
     *
     * @param Temboo_Session $session The session that owns this GetSetting execution.
     * @param Google_Calendar_GetSetting $choreo The choreography object for this execution.
     * @param Google_Calendar_GetSetting_Inputs|array $inputs (optional) Inputs as Google_Calendar_GetSetting_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_Calendar_GetSetting_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_Calendar_GetSetting $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this GetSetting execution.
     *
     * @return Google_Calendar_GetSetting_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this GetSetting execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_Calendar_GetSetting_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_Calendar_GetSetting_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the GetSetting Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_Calendar_GetSetting_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the GetSetting Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_Calendar_GetSetting_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this GetSetting execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this GetSetting execution.
     *
     * @return string The response from Google. Corresponds to the ResponseFormat input. Defaults to JSON.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Retrieves information about a calendar including the id with a given calendar name.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_Calendar_SearchCalendarsByName extends Temboo_Choreography
{
    /**
     * Retrieves information about a calendar including the id with a given calendar name.
     *
     * @param Temboo_Session $session The session that owns this SearchCalendarsByName Choreo.
     * @return Google_Calendar_SearchCalendarsByName New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/Calendar/SearchCalendarsByName/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this SearchCalendarsByName Choreo.
     *
     * @param Google_Calendar_SearchCalendarsByName_Inputs|array $inputs (optional) Inputs as Google_Calendar_SearchCalendarsByName_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_Calendar_SearchCalendarsByName_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_Calendar_SearchCalendarsByName_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this SearchCalendarsByName Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_Calendar_SearchCalendarsByName_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_Calendar_SearchCalendarsByName_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the SearchCalendarsByName Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_Calendar_SearchCalendarsByName_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the SearchCalendarsByName Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_Calendar_SearchCalendarsByName_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this SearchCalendarsByName input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_Calendar_SearchCalendarsByName_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_Calendar_SearchCalendarsByName_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this SearchCalendarsByName Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Google_Calendar_SearchCalendarsByName_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the CalendarName input for this SearchCalendarsByName Choreo.
     *
     * @param string $value (required, string) The name of the calendar that you want to retrieve information for. Note that if there are multiple calendars with the same name, only the first one will be returned.
     * @return Google_Calendar_SearchCalendarsByName_Inputs For method chaining.
     */
    public function setCalendarName($value)
    {
        return $this->set('CalendarName', $value);
    }

    /**
     * Set the value for the ClientID input for this SearchCalendarsByName Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_Calendar_SearchCalendarsByName_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this SearchCalendarsByName Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_Calendar_SearchCalendarsByName_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Count input for this SearchCalendarsByName Choreo.
     *
     * @param int $value (optional, integer) The maximum number of calendars to search by name. The default is 15.
     * @return Google_Calendar_SearchCalendarsByName_Inputs For method chaining.
     */
    public function setCount($value)
    {
        return $this->set('Count', $value);
    }

    /**
     * Set the value for the RefreshToken input for this SearchCalendarsByName Choreo.
     *
     * @param string $value (conditional, string) An OAuth Refresh Token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_Calendar_SearchCalendarsByName_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }
}


/**
 * Execution object for the SearchCalendarsByName Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_Calendar_SearchCalendarsByName_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the SearchCalendarsByName Choreo.
     *
     * @param Temboo_Session $session The session that owns this SearchCalendarsByName execution.
     * @param Google_Calendar_SearchCalendarsByName $choreo The choreography object for this execution.
     * @param Google_Calendar_SearchCalendarsByName_Inputs|array $inputs (optional) Inputs as Google_Calendar_SearchCalendarsByName_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_Calendar_SearchCalendarsByName_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_Calendar_SearchCalendarsByName $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this SearchCalendarsByName execution.
     *
     * @return Google_Calendar_SearchCalendarsByName_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this SearchCalendarsByName execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_Calendar_SearchCalendarsByName_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_Calendar_SearchCalendarsByName_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the SearchCalendarsByName Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_Calendar_SearchCalendarsByName_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the SearchCalendarsByName Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_Calendar_SearchCalendarsByName_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "CalendarDescription" output from this SearchCalendarsByName execution.
     *
     * @return string (string) The calendar description parsed from the Google response.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getCalendarDescription()
    {
        return $this->get('CalendarDescription');
    }
    /**
     * Retrieve the value for the "CalendarId" output from this SearchCalendarsByName execution.
     *
     * @return string (string) The calendar id parsed from the Google response.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getCalendarId()
    {
        return $this->get('CalendarId');
    }
    /**
     * Retrieve the value for the "CalendarSummary" output from this SearchCalendarsByName execution.
     *
     * @return string (string) The summary or calendar name parsed from the Google response.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getCalendarSummary()
    {
        return $this->get('CalendarSummary');
    }
    /**
     * Retrieve the value for the "CalendarTimezone" output from this SearchCalendarsByName execution.
     *
     * @return string (string) The calendar timezone parsed from the Google response.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getCalendarTimezone()
    {
        return $this->get('CalendarTimezone');
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this SearchCalendarsByName execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
}

/**
 * Allows you to search for events using a variety of search parameters.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_Calendar_SearchEvents extends Temboo_Choreography
{
    /**
     * Allows you to search for events using a variety of search parameters.
     *
     * @param Temboo_Session $session The session that owns this SearchEvents Choreo.
     * @return Google_Calendar_SearchEvents New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/Calendar/SearchEvents/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this SearchEvents Choreo.
     *
     * @param Google_Calendar_SearchEvents_Inputs|array $inputs (optional) Inputs as Google_Calendar_SearchEvents_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_Calendar_SearchEvents_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_Calendar_SearchEvents_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this SearchEvents Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_Calendar_SearchEvents_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_Calendar_SearchEvents_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the SearchEvents Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_Calendar_SearchEvents_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the SearchEvents Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_Calendar_SearchEvents_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this SearchEvents input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_Calendar_SearchEvents_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_Calendar_SearchEvents_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this SearchEvents Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Google_Calendar_SearchEvents_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the CalendarID input for this SearchEvents Choreo.
     *
     * @param string $value (required, string) The unique ID for the calendar with the events to search. Note that calendar IDs can be retrieved by running GetAllCalendars or SearchCalendarsByName.
     * @return Google_Calendar_SearchEvents_Inputs For method chaining.
     */
    public function setCalendarID($value)
    {
        return $this->set('CalendarID', $value);
    }

    /**
     * Set the value for the ClientID input for this SearchEvents Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_Calendar_SearchEvents_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this SearchEvents Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_Calendar_SearchEvents_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the LastModified input for this SearchEvents Choreo.
     *
     * @param string $value (optional, date) An event's last modification time (as a RFC 3339 timestamp) to filter by.
     * @return Google_Calendar_SearchEvents_Inputs For method chaining.
     */
    public function setLastModified($value)
    {
        return $this->set('LastModified', $value);
    }

    /**
     * Set the value for the MaxAttendees input for this SearchEvents Choreo.
     *
     * @param int $value (optional, integer) The maximum number of attendees to include in the response. If there are more than the specified number of attendees, only the participant is returned.
     * @return Google_Calendar_SearchEvents_Inputs For method chaining.
     */
    public function setMaxAttendees($value)
    {
        return $this->set('MaxAttendees', $value);
    }

    /**
     * Set the value for the MaxResults input for this SearchEvents Choreo.
     *
     * @param int $value (optional, integer) The maximum number of events to return on one result page.
     * @return Google_Calendar_SearchEvents_Inputs For method chaining.
     */
    public function setMaxResults($value)
    {
        return $this->set('MaxResults', $value);
    }

    /**
     * Set the value for the MaxTime input for this SearchEvents Choreo.
     *
     * @param string $value (optional, date) The max start time to filter by (formatted like 2012-05-22T00:47:43.000Z).
     * @return Google_Calendar_SearchEvents_Inputs For method chaining.
     */
    public function setMaxTime($value)
    {
        return $this->set('MaxTime', $value);
    }

    /**
     * Set the value for the MinTime input for this SearchEvents Choreo.
     *
     * @param string $value (optional, date) The minimum start time to filter by (formatted like 2012-05-22T00:47:43.000Z).
     * @return Google_Calendar_SearchEvents_Inputs For method chaining.
     */
    public function setMinTime($value)
    {
        return $this->set('MinTime', $value);
    }

    /**
     * Set the value for the OrderBy input for this SearchEvents Choreo.
     *
     * @param string $value (optional, string) The order of the events returned in the result. Accepted values are: "startTime" (ordered by start date/time. Must set SingleEvents to 1 to use this) or "updated" (ordered by modification date/time).
     * @return Google_Calendar_SearchEvents_Inputs For method chaining.
     */
    public function setOrderBy($value)
    {
        return $this->set('OrderBy', $value);
    }

    /**
     * Set the value for the PageToken input for this SearchEvents Choreo.
     *
     * @param int $value (optional, integer) Indicates which result page to return. Used for paging through results.
     * @return Google_Calendar_SearchEvents_Inputs For method chaining.
     */
    public function setPageToken($value)
    {
        return $this->set('PageToken', $value);
    }

    /**
     * Set the value for the Query input for this SearchEvents Choreo.
     *
     * @param string $value (optional, string) A keyword search to find events.
     * @return Google_Calendar_SearchEvents_Inputs For method chaining.
     */
    public function setQuery($value)
    {
        return $this->set('Query', $value);
    }

    /**
     * Set the value for the RefreshToken input for this SearchEvents Choreo.
     *
     * @param string $value (conditional, string) An OAuth Refresh Token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_Calendar_SearchEvents_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this SearchEvents Choreo.
     *
     * @param string $value (optional, string) The format that response should be in. Can be set to xml or json. Defaults to json.
     * @return Google_Calendar_SearchEvents_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }

    /**
     * Set the value for the ShowDeleted input for this SearchEvents Choreo.
     *
     * @param bool $value (optional, boolean) Whether to include deleted events. Set to 1 (true) to include deleted events. Defaults to 0 (false).
     * @return Google_Calendar_SearchEvents_Inputs For method chaining.
     */
    public function setShowDeleted($value)
    {
        return $this->set('ShowDeleted', $value);
    }

    /**
     * Set the value for the ShowHiddenInvitations input for this SearchEvents Choreo.
     *
     * @param bool $value (optional, boolean) Whether to include hidden invitations in the result. Set to 1 (true) to enable. The default is 0 (false).
     * @return Google_Calendar_SearchEvents_Inputs For method chaining.
     */
    public function setShowHiddenInvitations($value)
    {
        return $this->set('ShowHiddenInvitations', $value);
    }

    /**
     * Set the value for the SingleEvent input for this SearchEvents Choreo.
     *
     * @param bool $value (optional, boolean) Whether to expand recurring events into instances and only return single one-off events and instances of recurring events. Defaults to 0 (false).
     * @return Google_Calendar_SearchEvents_Inputs For method chaining.
     */
    public function setSingleEvent($value)
    {
        return $this->set('SingleEvent', $value);
    }

    /**
     * Set the value for the Timezone input for this SearchEvents Choreo.
     *
     * @param string $value (optional, string) The time zone used in the response (i.e. America/Los_Angeles). The default is the time zone of the calendar.
     * @return Google_Calendar_SearchEvents_Inputs For method chaining.
     */
    public function setTimezone($value)
    {
        return $this->set('Timezone', $value);
    }
}


/**
 * Execution object for the SearchEvents Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_Calendar_SearchEvents_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the SearchEvents Choreo.
     *
     * @param Temboo_Session $session The session that owns this SearchEvents execution.
     * @param Google_Calendar_SearchEvents $choreo The choreography object for this execution.
     * @param Google_Calendar_SearchEvents_Inputs|array $inputs (optional) Inputs as Google_Calendar_SearchEvents_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_Calendar_SearchEvents_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_Calendar_SearchEvents $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this SearchEvents execution.
     *
     * @return Google_Calendar_SearchEvents_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this SearchEvents execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_Calendar_SearchEvents_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_Calendar_SearchEvents_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the SearchEvents Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_Calendar_SearchEvents_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the SearchEvents Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_Calendar_SearchEvents_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this SearchEvents execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this SearchEvents execution.
     *
     * @return string The response from Google. Corresponds to the ResponseFormat input. Defaults to JSON.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Updates the metadata for a calendar.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_Calendar_UpdateCalendar extends Temboo_Choreography
{
    /**
     * Updates the metadata for a calendar.
     *
     * @param Temboo_Session $session The session that owns this UpdateCalendar Choreo.
     * @return Google_Calendar_UpdateCalendar New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/Calendar/UpdateCalendar/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this UpdateCalendar Choreo.
     *
     * @param Google_Calendar_UpdateCalendar_Inputs|array $inputs (optional) Inputs as Google_Calendar_UpdateCalendar_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_Calendar_UpdateCalendar_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_Calendar_UpdateCalendar_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this UpdateCalendar Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_Calendar_UpdateCalendar_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_Calendar_UpdateCalendar_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the UpdateCalendar Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_Calendar_UpdateCalendar_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the UpdateCalendar Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_Calendar_UpdateCalendar_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this UpdateCalendar input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_Calendar_UpdateCalendar_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_Calendar_UpdateCalendar_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this UpdateCalendar Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Google_Calendar_UpdateCalendar_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the CalendarID input for this UpdateCalendar Choreo.
     *
     * @param string $value (required, string) The unique ID for the calendar to update. Note that calendar IDs can be retrieved by running GetAllCalendars or SearchCalendarsByName.
     * @return Google_Calendar_UpdateCalendar_Inputs For method chaining.
     */
    public function setCalendarID($value)
    {
        return $this->set('CalendarID', $value);
    }

    /**
     * Set the value for the ClientID input for this UpdateCalendar Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_Calendar_UpdateCalendar_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this UpdateCalendar Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_Calendar_UpdateCalendar_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the NewDescription input for this UpdateCalendar Choreo.
     *
     * @param string $value (optional, string) The new description for the calendar to update.
     * @return Google_Calendar_UpdateCalendar_Inputs For method chaining.
     */
    public function setNewDescription($value)
    {
        return $this->set('NewDescription', $value);
    }

    /**
     * Set the value for the NewLocation input for this UpdateCalendar Choreo.
     *
     * @param string $value (optional, string) The new location for the calendar to update.
     * @return Google_Calendar_UpdateCalendar_Inputs For method chaining.
     */
    public function setNewLocation($value)
    {
        return $this->set('NewLocation', $value);
    }

    /**
     * Set the value for the NewSummary input for this UpdateCalendar Choreo.
     *
     * @param string $value (required, string) The new summary for the calendar to update.
     * @return Google_Calendar_UpdateCalendar_Inputs For method chaining.
     */
    public function setNewSummary($value)
    {
        return $this->set('NewSummary', $value);
    }

    /**
     * Set the value for the NewTimezone input for this UpdateCalendar Choreo.
     *
     * @param string $value (optional, string) The new timezone for the calendar to update.
     * @return Google_Calendar_UpdateCalendar_Inputs For method chaining.
     */
    public function setNewTimezone($value)
    {
        return $this->set('NewTimezone', $value);
    }

    /**
     * Set the value for the RefreshToken input for this UpdateCalendar Choreo.
     *
     * @param string $value (conditional, string) An OAuth Refresh Token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_Calendar_UpdateCalendar_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }

    /**
     * Set the value for the ResponseFormat input for this UpdateCalendar Choreo.
     *
     * @param string $value (optional, string) The format that response should be in. Can be set to xml or json. Defaults to json.
     * @return Google_Calendar_UpdateCalendar_Inputs For method chaining.
     */
    public function setResponseFormat($value)
    {
        return $this->set('ResponseFormat', $value);
    }
}


/**
 * Execution object for the UpdateCalendar Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_Calendar_UpdateCalendar_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the UpdateCalendar Choreo.
     *
     * @param Temboo_Session $session The session that owns this UpdateCalendar execution.
     * @param Google_Calendar_UpdateCalendar $choreo The choreography object for this execution.
     * @param Google_Calendar_UpdateCalendar_Inputs|array $inputs (optional) Inputs as Google_Calendar_UpdateCalendar_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_Calendar_UpdateCalendar_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_Calendar_UpdateCalendar $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this UpdateCalendar execution.
     *
     * @return Google_Calendar_UpdateCalendar_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this UpdateCalendar execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_Calendar_UpdateCalendar_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_Calendar_UpdateCalendar_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the UpdateCalendar Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_Calendar_UpdateCalendar_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the UpdateCalendar Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_Calendar_UpdateCalendar_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this UpdateCalendar execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this UpdateCalendar execution.
     *
     * @return string The response from Google. Corresponds to the ResponseFormat input. Defaults to JSON.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Retrieves a list of Address resources across all available regions.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Addresses_AggregatedList extends Temboo_Choreography
{
    /**
     * Retrieves a list of Address resources across all available regions.
     *
     * @param Temboo_Session $session The session that owns this AggregatedList Choreo.
     * @return Google_ComputeEngine_Addresses_AggregatedList New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/ComputeEngine/Addresses/AggregatedList/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this AggregatedList Choreo.
     *
     * @param Google_ComputeEngine_Addresses_AggregatedList_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Addresses_AggregatedList_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Addresses_AggregatedList_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_ComputeEngine_Addresses_AggregatedList_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this AggregatedList Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Addresses_AggregatedList_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_ComputeEngine_Addresses_AggregatedList_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the AggregatedList Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Addresses_AggregatedList_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the AggregatedList Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Addresses_AggregatedList_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this AggregatedList input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_ComputeEngine_Addresses_AggregatedList_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_ComputeEngine_Addresses_AggregatedList_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this AggregatedList Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Google_ComputeEngine_Addresses_AggregatedList_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this AggregatedList Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Addresses_AggregatedList_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this AggregatedList Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Addresses_AggregatedList_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Fields input for this AggregatedList Choreo.
     *
     * @param string $value (optional, string) Comma-seperated list of fields you want to include in the response.
     * @return Google_ComputeEngine_Addresses_AggregatedList_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Filter input for this AggregatedList Choreo.
     *
     * @param string $value (optional, string) A filter expression for narrowing results in the form: {field_name} {comparison_string} {literal_string} (e.g. name eq your-address-name). Comparison strings can be eq (equals) or ne (not equals).
     * @return Google_ComputeEngine_Addresses_AggregatedList_Inputs For method chaining.
     */
    public function setFilter($value)
    {
        return $this->set('Filter', $value);
    }

    /**
     * Set the value for the MaxResults input for this AggregatedList Choreo.
     *
     * @param int $value (optional, integer) The maximum number of results to return.
     * @return Google_ComputeEngine_Addresses_AggregatedList_Inputs For method chaining.
     */
    public function setMaxResults($value)
    {
        return $this->set('MaxResults', $value);
    }

    /**
     * Set the value for the PageToken input for this AggregatedList Choreo.
     *
     * @param string $value (optional, string) The "nextPageToken" found in the response which is used to page through results.
     * @return Google_ComputeEngine_Addresses_AggregatedList_Inputs For method chaining.
     */
    public function setPageToken($value)
    {
        return $this->set('PageToken', $value);
    }

    /**
     * Set the value for the Project input for this AggregatedList Choreo.
     *
     * @param string $value (required, string) The ID of a Google Compute project.
     * @return Google_ComputeEngine_Addresses_AggregatedList_Inputs For method chaining.
     */
    public function setProject($value)
    {
        return $this->set('Project', $value);
    }

    /**
     * Set the value for the RefreshToken input for this AggregatedList Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Addresses_AggregatedList_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }
}


/**
 * Execution object for the AggregatedList Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Addresses_AggregatedList_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the AggregatedList Choreo.
     *
     * @param Temboo_Session $session The session that owns this AggregatedList execution.
     * @param Google_ComputeEngine_Addresses_AggregatedList $choreo The choreography object for this execution.
     * @param Google_ComputeEngine_Addresses_AggregatedList_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Addresses_AggregatedList_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Addresses_AggregatedList_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_ComputeEngine_Addresses_AggregatedList $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this AggregatedList execution.
     *
     * @return Google_ComputeEngine_Addresses_AggregatedList_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this AggregatedList execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_ComputeEngine_Addresses_AggregatedList_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_ComputeEngine_Addresses_AggregatedList_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the AggregatedList Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Addresses_AggregatedList_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the AggregatedList Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_ComputeEngine_Addresses_AggregatedList_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this AggregatedList execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this AggregatedList execution.
     *
     * @return string (json) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Deletes a specified address resource.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Addresses_DeleteAddress extends Temboo_Choreography
{
    /**
     * Deletes a specified address resource.
     *
     * @param Temboo_Session $session The session that owns this DeleteAddress Choreo.
     * @return Google_ComputeEngine_Addresses_DeleteAddress New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/ComputeEngine/Addresses/DeleteAddress/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this DeleteAddress Choreo.
     *
     * @param Google_ComputeEngine_Addresses_DeleteAddress_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Addresses_DeleteAddress_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Addresses_DeleteAddress_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_ComputeEngine_Addresses_DeleteAddress_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this DeleteAddress Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Addresses_DeleteAddress_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_ComputeEngine_Addresses_DeleteAddress_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the DeleteAddress Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Addresses_DeleteAddress_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the DeleteAddress Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Addresses_DeleteAddress_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this DeleteAddress input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_ComputeEngine_Addresses_DeleteAddress_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_ComputeEngine_Addresses_DeleteAddress_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this DeleteAddress Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Google_ComputeEngine_Addresses_DeleteAddress_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the Address input for this DeleteAddress Choreo.
     *
     * @param string $value (required, string) The name of the address to delete.
     * @return Google_ComputeEngine_Addresses_DeleteAddress_Inputs For method chaining.
     */
    public function setAddress($value)
    {
        return $this->set('Address', $value);
    }

    /**
     * Set the value for the ClientID input for this DeleteAddress Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Addresses_DeleteAddress_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this DeleteAddress Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Addresses_DeleteAddress_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Fields input for this DeleteAddress Choreo.
     *
     * @param string $value (optional, string) Comma-seperated list of fields you want to include in the response.
     * @return Google_ComputeEngine_Addresses_DeleteAddress_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Project input for this DeleteAddress Choreo.
     *
     * @param string $value (required, string) The ID of a Google Compute project.
     * @return Google_ComputeEngine_Addresses_DeleteAddress_Inputs For method chaining.
     */
    public function setProject($value)
    {
        return $this->set('Project', $value);
    }

    /**
     * Set the value for the RefreshToken input for this DeleteAddress Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Addresses_DeleteAddress_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }

    /**
     * Set the value for the Region input for this DeleteAddress Choreo.
     *
     * @param string $value (required, string) The name of the region associated with this request.
     * @return Google_ComputeEngine_Addresses_DeleteAddress_Inputs For method chaining.
     */
    public function setRegion($value)
    {
        return $this->set('Region', $value);
    }
}


/**
 * Execution object for the DeleteAddress Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Addresses_DeleteAddress_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the DeleteAddress Choreo.
     *
     * @param Temboo_Session $session The session that owns this DeleteAddress execution.
     * @param Google_ComputeEngine_Addresses_DeleteAddress $choreo The choreography object for this execution.
     * @param Google_ComputeEngine_Addresses_DeleteAddress_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Addresses_DeleteAddress_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Addresses_DeleteAddress_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_ComputeEngine_Addresses_DeleteAddress $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this DeleteAddress execution.
     *
     * @return Google_ComputeEngine_Addresses_DeleteAddress_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this DeleteAddress execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_ComputeEngine_Addresses_DeleteAddress_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_ComputeEngine_Addresses_DeleteAddress_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the DeleteAddress Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Addresses_DeleteAddress_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the DeleteAddress Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_ComputeEngine_Addresses_DeleteAddress_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this DeleteAddress execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this DeleteAddress execution.
     *
     * @return string (json) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Retrieves information about the specified Address.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Addresses_GetAddress extends Temboo_Choreography
{
    /**
     * Retrieves information about the specified Address.
     *
     * @param Temboo_Session $session The session that owns this GetAddress Choreo.
     * @return Google_ComputeEngine_Addresses_GetAddress New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/ComputeEngine/Addresses/GetAddress/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this GetAddress Choreo.
     *
     * @param Google_ComputeEngine_Addresses_GetAddress_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Addresses_GetAddress_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Addresses_GetAddress_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_ComputeEngine_Addresses_GetAddress_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this GetAddress Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Addresses_GetAddress_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_ComputeEngine_Addresses_GetAddress_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the GetAddress Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Addresses_GetAddress_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the GetAddress Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Addresses_GetAddress_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this GetAddress input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_ComputeEngine_Addresses_GetAddress_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_ComputeEngine_Addresses_GetAddress_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this GetAddress Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Google_ComputeEngine_Addresses_GetAddress_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the Address input for this GetAddress Choreo.
     *
     * @param string $value (required, string) The name of the address to retrieve.
     * @return Google_ComputeEngine_Addresses_GetAddress_Inputs For method chaining.
     */
    public function setAddress($value)
    {
        return $this->set('Address', $value);
    }

    /**
     * Set the value for the ClientID input for this GetAddress Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Addresses_GetAddress_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this GetAddress Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Addresses_GetAddress_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Fields input for this GetAddress Choreo.
     *
     * @param string $value (optional, string) Comma-seperated list of fields you want to include in the response.
     * @return Google_ComputeEngine_Addresses_GetAddress_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Project input for this GetAddress Choreo.
     *
     * @param string $value (required, string) The ID of a Google Compute project.
     * @return Google_ComputeEngine_Addresses_GetAddress_Inputs For method chaining.
     */
    public function setProject($value)
    {
        return $this->set('Project', $value);
    }

    /**
     * Set the value for the RefreshToken input for this GetAddress Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Addresses_GetAddress_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }

    /**
     * Set the value for the Region input for this GetAddress Choreo.
     *
     * @param string $value (required, string) The name of the region associated with this request.
     * @return Google_ComputeEngine_Addresses_GetAddress_Inputs For method chaining.
     */
    public function setRegion($value)
    {
        return $this->set('Region', $value);
    }
}


/**
 * Execution object for the GetAddress Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Addresses_GetAddress_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the GetAddress Choreo.
     *
     * @param Temboo_Session $session The session that owns this GetAddress execution.
     * @param Google_ComputeEngine_Addresses_GetAddress $choreo The choreography object for this execution.
     * @param Google_ComputeEngine_Addresses_GetAddress_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Addresses_GetAddress_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Addresses_GetAddress_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_ComputeEngine_Addresses_GetAddress $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this GetAddress execution.
     *
     * @return Google_ComputeEngine_Addresses_GetAddress_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this GetAddress execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_ComputeEngine_Addresses_GetAddress_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_ComputeEngine_Addresses_GetAddress_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the GetAddress Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Addresses_GetAddress_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the GetAddress Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_ComputeEngine_Addresses_GetAddress_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this GetAddress execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this GetAddress execution.
     *
     * @return string (json) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Creates an Address resource in the specified project.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Addresses_InsertAddress extends Temboo_Choreography
{
    /**
     * Creates an Address resource in the specified project.
     *
     * @param Temboo_Session $session The session that owns this InsertAddress Choreo.
     * @return Google_ComputeEngine_Addresses_InsertAddress New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/ComputeEngine/Addresses/InsertAddress/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this InsertAddress Choreo.
     *
     * @param Google_ComputeEngine_Addresses_InsertAddress_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Addresses_InsertAddress_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Addresses_InsertAddress_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_ComputeEngine_Addresses_InsertAddress_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this InsertAddress Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Addresses_InsertAddress_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_ComputeEngine_Addresses_InsertAddress_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the InsertAddress Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Addresses_InsertAddress_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the InsertAddress Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Addresses_InsertAddress_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this InsertAddress input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_ComputeEngine_Addresses_InsertAddress_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_ComputeEngine_Addresses_InsertAddress_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AddressResource input for this InsertAddress Choreo.
     *
     * @param string $value (optional, json) A JSON string containing the address resource properties you wish to set. This can be used as an alternative to individual inputs that represent address resource properties.
     * @return Google_ComputeEngine_Addresses_InsertAddress_Inputs For method chaining.
     */
    public function setAddressResource($value)
    {
        return $this->set('AddressResource', $value);
    }

    /**
     * Set the value for the AccessToken input for this InsertAddress Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Google_ComputeEngine_Addresses_InsertAddress_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the Address input for this InsertAddress Choreo.
     *
     * @param string $value (optional, string) The IP address represented by this resource.
     * @return Google_ComputeEngine_Addresses_InsertAddress_Inputs For method chaining.
     */
    public function setAddress($value)
    {
        return $this->set('Address', $value);
    }

    /**
     * Set the value for the ClientID input for this InsertAddress Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Addresses_InsertAddress_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this InsertAddress Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Addresses_InsertAddress_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Description input for this InsertAddress Choreo.
     *
     * @param string $value (optional, string) A description of the address.
     * @return Google_ComputeEngine_Addresses_InsertAddress_Inputs For method chaining.
     */
    public function setDescription($value)
    {
        return $this->set('Description', $value);
    }

    /**
     * Set the value for the Name input for this InsertAddress Choreo.
     *
     * @param string $value (conditional, string) The name of the address resource.
     * @return Google_ComputeEngine_Addresses_InsertAddress_Inputs For method chaining.
     */
    public function setName($value)
    {
        return $this->set('Name', $value);
    }

    /**
     * Set the value for the Project input for this InsertAddress Choreo.
     *
     * @param string $value (required, string) The ID of a Google Compute project.
     * @return Google_ComputeEngine_Addresses_InsertAddress_Inputs For method chaining.
     */
    public function setProject($value)
    {
        return $this->set('Project', $value);
    }

    /**
     * Set the value for the RefreshToken input for this InsertAddress Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Addresses_InsertAddress_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }

    /**
     * Set the value for the Region input for this InsertAddress Choreo.
     *
     * @param string $value (required, string) Name of the region associated with the request.
     * @return Google_ComputeEngine_Addresses_InsertAddress_Inputs For method chaining.
     */
    public function setRegion($value)
    {
        return $this->set('Region', $value);
    }
}


/**
 * Execution object for the InsertAddress Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Addresses_InsertAddress_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the InsertAddress Choreo.
     *
     * @param Temboo_Session $session The session that owns this InsertAddress execution.
     * @param Google_ComputeEngine_Addresses_InsertAddress $choreo The choreography object for this execution.
     * @param Google_ComputeEngine_Addresses_InsertAddress_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Addresses_InsertAddress_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Addresses_InsertAddress_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_ComputeEngine_Addresses_InsertAddress $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this InsertAddress execution.
     *
     * @return Google_ComputeEngine_Addresses_InsertAddress_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this InsertAddress execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_ComputeEngine_Addresses_InsertAddress_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_ComputeEngine_Addresses_InsertAddress_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the InsertAddress Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Addresses_InsertAddress_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the InsertAddress Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_ComputeEngine_Addresses_InsertAddress_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this InsertAddress execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this InsertAddress execution.
     *
     * @return string (json) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Retrieves a list of Address resources contained within the specified region
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Addresses_ListAddresses extends Temboo_Choreography
{
    /**
     * Retrieves a list of Address resources contained within the specified region
     *
     * @param Temboo_Session $session The session that owns this ListAddresses Choreo.
     * @return Google_ComputeEngine_Addresses_ListAddresses New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/ComputeEngine/Addresses/ListAddresses/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this ListAddresses Choreo.
     *
     * @param Google_ComputeEngine_Addresses_ListAddresses_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Addresses_ListAddresses_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Addresses_ListAddresses_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_ComputeEngine_Addresses_ListAddresses_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this ListAddresses Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Addresses_ListAddresses_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_ComputeEngine_Addresses_ListAddresses_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the ListAddresses Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Addresses_ListAddresses_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the ListAddresses Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Addresses_ListAddresses_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this ListAddresses input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_ComputeEngine_Addresses_ListAddresses_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_ComputeEngine_Addresses_ListAddresses_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this ListAddresses Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Google_ComputeEngine_Addresses_ListAddresses_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this ListAddresses Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Addresses_ListAddresses_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this ListAddresses Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Addresses_ListAddresses_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Fields input for this ListAddresses Choreo.
     *
     * @param string $value (optional, string) Comma-seperated list of fields you want to include in the response.
     * @return Google_ComputeEngine_Addresses_ListAddresses_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Filter input for this ListAddresses Choreo.
     *
     * @param string $value (optional, string) A filter expression for narrowing results in the form: {field_name} {comparison_string} {literal_string} (e.g. name eq your-address-name). Comparison strings can be eq (equals) or ne (not equals).
     * @return Google_ComputeEngine_Addresses_ListAddresses_Inputs For method chaining.
     */
    public function setFilter($value)
    {
        return $this->set('Filter', $value);
    }

    /**
     * Set the value for the MaxResults input for this ListAddresses Choreo.
     *
     * @param int $value (optional, integer) The maximum number of results to return.
     * @return Google_ComputeEngine_Addresses_ListAddresses_Inputs For method chaining.
     */
    public function setMaxResults($value)
    {
        return $this->set('MaxResults', $value);
    }

    /**
     * Set the value for the PageToken input for this ListAddresses Choreo.
     *
     * @param string $value (optional, string) The "nextPageToken" found in the response which is used to page through results.
     * @return Google_ComputeEngine_Addresses_ListAddresses_Inputs For method chaining.
     */
    public function setPageToken($value)
    {
        return $this->set('PageToken', $value);
    }

    /**
     * Set the value for the Project input for this ListAddresses Choreo.
     *
     * @param string $value (required, string) The ID of a Google Compute project.
     * @return Google_ComputeEngine_Addresses_ListAddresses_Inputs For method chaining.
     */
    public function setProject($value)
    {
        return $this->set('Project', $value);
    }

    /**
     * Set the value for the RefreshToken input for this ListAddresses Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Addresses_ListAddresses_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }

    /**
     * Set the value for the Region input for this ListAddresses Choreo.
     *
     * @param string $value (required, string) The name of the region associated with this request.
     * @return Google_ComputeEngine_Addresses_ListAddresses_Inputs For method chaining.
     */
    public function setRegion($value)
    {
        return $this->set('Region', $value);
    }
}


/**
 * Execution object for the ListAddresses Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Addresses_ListAddresses_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the ListAddresses Choreo.
     *
     * @param Temboo_Session $session The session that owns this ListAddresses execution.
     * @param Google_ComputeEngine_Addresses_ListAddresses $choreo The choreography object for this execution.
     * @param Google_ComputeEngine_Addresses_ListAddresses_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Addresses_ListAddresses_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Addresses_ListAddresses_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_ComputeEngine_Addresses_ListAddresses $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this ListAddresses execution.
     *
     * @return Google_ComputeEngine_Addresses_ListAddresses_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this ListAddresses execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_ComputeEngine_Addresses_ListAddresses_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_ComputeEngine_Addresses_ListAddresses_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the ListAddresses Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Addresses_ListAddresses_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the ListAddresses Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_ComputeEngine_Addresses_ListAddresses_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this ListAddresses execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this ListAddresses execution.
     *
     * @return string (json) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Retrieves an aggregated list of Disk resources across all zones.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Disks_AggregatedList extends Temboo_Choreography
{
    /**
     * Retrieves an aggregated list of Disk resources across all zones.
     *
     * @param Temboo_Session $session The session that owns this AggregatedList Choreo.
     * @return Google_ComputeEngine_Disks_AggregatedList New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/ComputeEngine/Disks/AggregatedList/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this AggregatedList Choreo.
     *
     * @param Google_ComputeEngine_Disks_AggregatedList_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Disks_AggregatedList_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Disks_AggregatedList_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_ComputeEngine_Disks_AggregatedList_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this AggregatedList Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Disks_AggregatedList_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_ComputeEngine_Disks_AggregatedList_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the AggregatedList Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Disks_AggregatedList_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the AggregatedList Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Disks_AggregatedList_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this AggregatedList input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_ComputeEngine_Disks_AggregatedList_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_ComputeEngine_Disks_AggregatedList_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this AggregatedList Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Google_ComputeEngine_Disks_AggregatedList_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this AggregatedList Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Disks_AggregatedList_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this AggregatedList Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Disks_AggregatedList_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Fields input for this AggregatedList Choreo.
     *
     * @param string $value (optional, string) Comma-seperated list of fields you want to include in the response.
     * @return Google_ComputeEngine_Disks_AggregatedList_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Filter input for this AggregatedList Choreo.
     *
     * @param string $value (optional, string) A filter expression for narrowing results in the form: {field_name} {comparison_string} {literal_string} (e.g. name eq your-disk-name). Comparison strings can be eq (equals) or ne (not equals).
     * @return Google_ComputeEngine_Disks_AggregatedList_Inputs For method chaining.
     */
    public function setFilter($value)
    {
        return $this->set('Filter', $value);
    }

    /**
     * Set the value for the MaxResults input for this AggregatedList Choreo.
     *
     * @param int $value (optional, integer) The maximum number of results to return.
     * @return Google_ComputeEngine_Disks_AggregatedList_Inputs For method chaining.
     */
    public function setMaxResults($value)
    {
        return $this->set('MaxResults', $value);
    }

    /**
     * Set the value for the PageToken input for this AggregatedList Choreo.
     *
     * @param string $value (optional, string) The "nextPageToken" found in the response which is used to page through results.
     * @return Google_ComputeEngine_Disks_AggregatedList_Inputs For method chaining.
     */
    public function setPageToken($value)
    {
        return $this->set('PageToken', $value);
    }

    /**
     * Set the value for the Project input for this AggregatedList Choreo.
     *
     * @param string $value (required, string) The ID of a Google Compute project.
     * @return Google_ComputeEngine_Disks_AggregatedList_Inputs For method chaining.
     */
    public function setProject($value)
    {
        return $this->set('Project', $value);
    }

    /**
     * Set the value for the RefreshToken input for this AggregatedList Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Disks_AggregatedList_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }
}


/**
 * Execution object for the AggregatedList Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Disks_AggregatedList_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the AggregatedList Choreo.
     *
     * @param Temboo_Session $session The session that owns this AggregatedList execution.
     * @param Google_ComputeEngine_Disks_AggregatedList $choreo The choreography object for this execution.
     * @param Google_ComputeEngine_Disks_AggregatedList_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Disks_AggregatedList_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Disks_AggregatedList_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_ComputeEngine_Disks_AggregatedList $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this AggregatedList execution.
     *
     * @return Google_ComputeEngine_Disks_AggregatedList_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this AggregatedList execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_ComputeEngine_Disks_AggregatedList_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_ComputeEngine_Disks_AggregatedList_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the AggregatedList Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Disks_AggregatedList_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the AggregatedList Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_ComputeEngine_Disks_AggregatedList_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this AggregatedList execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this AggregatedList execution.
     *
     * @return string (json) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Creates a snapshot of a specified disk.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Disks_CreateSnapshot extends Temboo_Choreography
{
    /**
     * Creates a snapshot of a specified disk.
     *
     * @param Temboo_Session $session The session that owns this CreateSnapshot Choreo.
     * @return Google_ComputeEngine_Disks_CreateSnapshot New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/ComputeEngine/Disks/CreateSnapshot/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this CreateSnapshot Choreo.
     *
     * @param Google_ComputeEngine_Disks_CreateSnapshot_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Disks_CreateSnapshot_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Disks_CreateSnapshot_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_ComputeEngine_Disks_CreateSnapshot_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this CreateSnapshot Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Disks_CreateSnapshot_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_ComputeEngine_Disks_CreateSnapshot_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the CreateSnapshot Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Disks_CreateSnapshot_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the CreateSnapshot Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Disks_CreateSnapshot_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this CreateSnapshot input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_ComputeEngine_Disks_CreateSnapshot_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_ComputeEngine_Disks_CreateSnapshot_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this CreateSnapshot Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Google_ComputeEngine_Disks_CreateSnapshot_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this CreateSnapshot Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Disks_CreateSnapshot_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this CreateSnapshot Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Disks_CreateSnapshot_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Description input for this CreateSnapshot Choreo.
     *
     * @param string $value (optional, string) A description for the snapshot resource.
     * @return Google_ComputeEngine_Disks_CreateSnapshot_Inputs For method chaining.
     */
    public function setDescription($value)
    {
        return $this->set('Description', $value);
    }

    /**
     * Set the value for the Disk input for this CreateSnapshot Choreo.
     *
     * @param string $value (required, string) The name of the persistent disk resource to use to create this snapshot.
     * @return Google_ComputeEngine_Disks_CreateSnapshot_Inputs For method chaining.
     */
    public function setDisk($value)
    {
        return $this->set('Disk', $value);
    }

    /**
     * Set the value for the Name input for this CreateSnapshot Choreo.
     *
     * @param string $value (required, string) The name of the snapshot resource being created.
     * @return Google_ComputeEngine_Disks_CreateSnapshot_Inputs For method chaining.
     */
    public function setName($value)
    {
        return $this->set('Name', $value);
    }

    /**
     * Set the value for the Project input for this CreateSnapshot Choreo.
     *
     * @param string $value (required, string) The ID of a Google Compute project.
     * @return Google_ComputeEngine_Disks_CreateSnapshot_Inputs For method chaining.
     */
    public function setProject($value)
    {
        return $this->set('Project', $value);
    }

    /**
     * Set the value for the RefreshToken input for this CreateSnapshot Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Disks_CreateSnapshot_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }

    /**
     * Set the value for the SourceDiskID input for this CreateSnapshot Choreo.
     *
     * @param string $value (required, string) The ID of the disk being used to create the snapshot.
     * @return Google_ComputeEngine_Disks_CreateSnapshot_Inputs For method chaining.
     */
    public function setSourceDiskID($value)
    {
        return $this->set('SourceDiskID', $value);
    }

    /**
     * Set the value for the StorageBytes input for this CreateSnapshot Choreo.
     *
     * @param int $value (optional, integer) The size of the storage used by the snapshot.
     * @return Google_ComputeEngine_Disks_CreateSnapshot_Inputs For method chaining.
     */
    public function setStorageBytes($value)
    {
        return $this->set('StorageBytes', $value);
    }

    /**
     * Set the value for the StorageBytesStatus input for this CreateSnapshot Choreo.
     *
     * @param string $value (optional, string) Indicates whether storageBytes is in a stable state, or it is being adjusted as a result of shared storage reallocation. Valid values: are "UPDATING" AND "UP_TO_DATE".
     * @return Google_ComputeEngine_Disks_CreateSnapshot_Inputs For method chaining.
     */
    public function setStorageBytesStatus($value)
    {
        return $this->set('StorageBytesStatus', $value);
    }

    /**
     * Set the value for the Zone input for this CreateSnapshot Choreo.
     *
     * @param string $value (required, string) The name of the zone associated with this request.
     * @return Google_ComputeEngine_Disks_CreateSnapshot_Inputs For method chaining.
     */
    public function setZone($value)
    {
        return $this->set('Zone', $value);
    }
}


/**
 * Execution object for the CreateSnapshot Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Disks_CreateSnapshot_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the CreateSnapshot Choreo.
     *
     * @param Temboo_Session $session The session that owns this CreateSnapshot execution.
     * @param Google_ComputeEngine_Disks_CreateSnapshot $choreo The choreography object for this execution.
     * @param Google_ComputeEngine_Disks_CreateSnapshot_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Disks_CreateSnapshot_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Disks_CreateSnapshot_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_ComputeEngine_Disks_CreateSnapshot $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this CreateSnapshot execution.
     *
     * @return Google_ComputeEngine_Disks_CreateSnapshot_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this CreateSnapshot execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_ComputeEngine_Disks_CreateSnapshot_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_ComputeEngine_Disks_CreateSnapshot_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the CreateSnapshot Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Disks_CreateSnapshot_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the CreateSnapshot Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_ComputeEngine_Disks_CreateSnapshot_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this CreateSnapshot execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this CreateSnapshot execution.
     *
     * @return string (json) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Deletes the specified Persistent Disk resource.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Disks_DeleteDisk extends Temboo_Choreography
{
    /**
     * Deletes the specified Persistent Disk resource.
     *
     * @param Temboo_Session $session The session that owns this DeleteDisk Choreo.
     * @return Google_ComputeEngine_Disks_DeleteDisk New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/ComputeEngine/Disks/DeleteDisk/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this DeleteDisk Choreo.
     *
     * @param Google_ComputeEngine_Disks_DeleteDisk_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Disks_DeleteDisk_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Disks_DeleteDisk_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_ComputeEngine_Disks_DeleteDisk_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this DeleteDisk Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Disks_DeleteDisk_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_ComputeEngine_Disks_DeleteDisk_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the DeleteDisk Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Disks_DeleteDisk_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the DeleteDisk Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Disks_DeleteDisk_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this DeleteDisk input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_ComputeEngine_Disks_DeleteDisk_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_ComputeEngine_Disks_DeleteDisk_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this DeleteDisk Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Google_ComputeEngine_Disks_DeleteDisk_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this DeleteDisk Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Disks_DeleteDisk_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this DeleteDisk Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Disks_DeleteDisk_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Disk input for this DeleteDisk Choreo.
     *
     * @param string $value (required, string) The name of the persistent disk resource to delete.
     * @return Google_ComputeEngine_Disks_DeleteDisk_Inputs For method chaining.
     */
    public function setDisk($value)
    {
        return $this->set('Disk', $value);
    }

    /**
     * Set the value for the Fields input for this DeleteDisk Choreo.
     *
     * @param string $value (optional, string) Comma-seperated list of fields you want to include in the response.
     * @return Google_ComputeEngine_Disks_DeleteDisk_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Project input for this DeleteDisk Choreo.
     *
     * @param string $value (required, string) The ID of a Google Compute project.
     * @return Google_ComputeEngine_Disks_DeleteDisk_Inputs For method chaining.
     */
    public function setProject($value)
    {
        return $this->set('Project', $value);
    }

    /**
     * Set the value for the RefreshToken input for this DeleteDisk Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Disks_DeleteDisk_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }

    /**
     * Set the value for the Zone input for this DeleteDisk Choreo.
     *
     * @param string $value (required, string) The name of the zone associated with this request.
     * @return Google_ComputeEngine_Disks_DeleteDisk_Inputs For method chaining.
     */
    public function setZone($value)
    {
        return $this->set('Zone', $value);
    }
}


/**
 * Execution object for the DeleteDisk Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Disks_DeleteDisk_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the DeleteDisk Choreo.
     *
     * @param Temboo_Session $session The session that owns this DeleteDisk execution.
     * @param Google_ComputeEngine_Disks_DeleteDisk $choreo The choreography object for this execution.
     * @param Google_ComputeEngine_Disks_DeleteDisk_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Disks_DeleteDisk_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Disks_DeleteDisk_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_ComputeEngine_Disks_DeleteDisk $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this DeleteDisk execution.
     *
     * @return Google_ComputeEngine_Disks_DeleteDisk_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this DeleteDisk execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_ComputeEngine_Disks_DeleteDisk_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_ComputeEngine_Disks_DeleteDisk_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the DeleteDisk Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Disks_DeleteDisk_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the DeleteDisk Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_ComputeEngine_Disks_DeleteDisk_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this DeleteDisk execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this DeleteDisk execution.
     *
     * @return string (json) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Retrieves information about the specified Persistent Disk.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Disks_GetDisk extends Temboo_Choreography
{
    /**
     * Retrieves information about the specified Persistent Disk.
     *
     * @param Temboo_Session $session The session that owns this GetDisk Choreo.
     * @return Google_ComputeEngine_Disks_GetDisk New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/ComputeEngine/Disks/GetDisk/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this GetDisk Choreo.
     *
     * @param Google_ComputeEngine_Disks_GetDisk_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Disks_GetDisk_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Disks_GetDisk_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_ComputeEngine_Disks_GetDisk_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this GetDisk Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Disks_GetDisk_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_ComputeEngine_Disks_GetDisk_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the GetDisk Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Disks_GetDisk_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the GetDisk Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Disks_GetDisk_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this GetDisk input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_ComputeEngine_Disks_GetDisk_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_ComputeEngine_Disks_GetDisk_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this GetDisk Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Google_ComputeEngine_Disks_GetDisk_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this GetDisk Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Disks_GetDisk_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this GetDisk Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Disks_GetDisk_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Disk input for this GetDisk Choreo.
     *
     * @param string $value (required, string) The name of the persistent disk resource to retrieve.
     * @return Google_ComputeEngine_Disks_GetDisk_Inputs For method chaining.
     */
    public function setDisk($value)
    {
        return $this->set('Disk', $value);
    }

    /**
     * Set the value for the Fields input for this GetDisk Choreo.
     *
     * @param string $value (optional, string) Comma-seperated list of fields you want to include in the response.
     * @return Google_ComputeEngine_Disks_GetDisk_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Project input for this GetDisk Choreo.
     *
     * @param string $value (required, string) The ID of a Google Compute project.
     * @return Google_ComputeEngine_Disks_GetDisk_Inputs For method chaining.
     */
    public function setProject($value)
    {
        return $this->set('Project', $value);
    }

    /**
     * Set the value for the RefreshToken input for this GetDisk Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Disks_GetDisk_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }

    /**
     * Set the value for the Zone input for this GetDisk Choreo.
     *
     * @param string $value (required, string) The name of the zone associated with this request.
     * @return Google_ComputeEngine_Disks_GetDisk_Inputs For method chaining.
     */
    public function setZone($value)
    {
        return $this->set('Zone', $value);
    }
}


/**
 * Execution object for the GetDisk Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Disks_GetDisk_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the GetDisk Choreo.
     *
     * @param Temboo_Session $session The session that owns this GetDisk execution.
     * @param Google_ComputeEngine_Disks_GetDisk $choreo The choreography object for this execution.
     * @param Google_ComputeEngine_Disks_GetDisk_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Disks_GetDisk_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Disks_GetDisk_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_ComputeEngine_Disks_GetDisk $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this GetDisk execution.
     *
     * @return Google_ComputeEngine_Disks_GetDisk_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this GetDisk execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_ComputeEngine_Disks_GetDisk_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_ComputeEngine_Disks_GetDisk_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the GetDisk Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Disks_GetDisk_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the GetDisk Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_ComputeEngine_Disks_GetDisk_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this GetDisk execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this GetDisk execution.
     *
     * @return string (json) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Creates a Persistent Disk resource in the specified project.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Disks_InsertDisk extends Temboo_Choreography
{
    /**
     * Creates a Persistent Disk resource in the specified project.
     *
     * @param Temboo_Session $session The session that owns this InsertDisk Choreo.
     * @return Google_ComputeEngine_Disks_InsertDisk New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/ComputeEngine/Disks/InsertDisk/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this InsertDisk Choreo.
     *
     * @param Google_ComputeEngine_Disks_InsertDisk_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Disks_InsertDisk_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Disks_InsertDisk_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_ComputeEngine_Disks_InsertDisk_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this InsertDisk Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Disks_InsertDisk_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_ComputeEngine_Disks_InsertDisk_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the InsertDisk Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Disks_InsertDisk_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the InsertDisk Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Disks_InsertDisk_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this InsertDisk input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_ComputeEngine_Disks_InsertDisk_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_ComputeEngine_Disks_InsertDisk_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the DiskResource input for this InsertDisk Choreo.
     *
     * @param string $value (optional, json) A JSON string containing the disk resource properties you wish to set. This can be used as an alternative to individual inputs that represent disk properties.
     * @return Google_ComputeEngine_Disks_InsertDisk_Inputs For method chaining.
     */
    public function setDiskResource($value)
    {
        return $this->set('DiskResource', $value);
    }

    /**
     * Set the value for the AccessToken input for this InsertDisk Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Google_ComputeEngine_Disks_InsertDisk_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this InsertDisk Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Disks_InsertDisk_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this InsertDisk Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Disks_InsertDisk_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Name input for this InsertDisk Choreo.
     *
     * @param string $value (required, string) The name of the persistent disk resource being created.
     * @return Google_ComputeEngine_Disks_InsertDisk_Inputs For method chaining.
     */
    public function setName($value)
    {
        return $this->set('Name', $value);
    }

    /**
     * Set the value for the Project input for this InsertDisk Choreo.
     *
     * @param string $value (required, string) The ID of a Google Compute project.
     * @return Google_ComputeEngine_Disks_InsertDisk_Inputs For method chaining.
     */
    public function setProject($value)
    {
        return $this->set('Project', $value);
    }

    /**
     * Set the value for the RefreshToken input for this InsertDisk Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Disks_InsertDisk_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }

    /**
     * Set the value for the SizeGB input for this InsertDisk Choreo.
     *
     * @param string $value (conditional, string) Size of the persistent disk, specified in GB. This is optional when using a SourceSnapshot or SourceImage, otherwise it is required.
     * @return Google_ComputeEngine_Disks_InsertDisk_Inputs For method chaining.
     */
    public function setSizeGB($value)
    {
        return $this->set('SizeGB', $value);
    }

    /**
     * Set the value for the SourceImage input for this InsertDisk Choreo.
     *
     * @param string $value (conditional, string) The URL for the source image to apply to the disk. This is required if SizeGB or SourceSnapshot is not provided.
     * @return Google_ComputeEngine_Disks_InsertDisk_Inputs For method chaining.
     */
    public function setSourceImage($value)
    {
        return $this->set('SourceImage', $value);
    }

    /**
     * Set the value for the SourceSnapshot input for this InsertDisk Choreo.
     *
     * @param string $value (conditional, string) The source snapshot used to create this disk. This is required if SizeGB and SourceImage are not specified.
     * @return Google_ComputeEngine_Disks_InsertDisk_Inputs For method chaining.
     */
    public function setSourceSnapshot($value)
    {
        return $this->set('SourceSnapshot', $value);
    }

    /**
     * Set the value for the Zone input for this InsertDisk Choreo.
     *
     * @param string $value (required, string) The name of the zone associated with this request.
     * @return Google_ComputeEngine_Disks_InsertDisk_Inputs For method chaining.
     */
    public function setZone($value)
    {
        return $this->set('Zone', $value);
    }
}


/**
 * Execution object for the InsertDisk Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Disks_InsertDisk_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the InsertDisk Choreo.
     *
     * @param Temboo_Session $session The session that owns this InsertDisk execution.
     * @param Google_ComputeEngine_Disks_InsertDisk $choreo The choreography object for this execution.
     * @param Google_ComputeEngine_Disks_InsertDisk_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Disks_InsertDisk_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Disks_InsertDisk_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_ComputeEngine_Disks_InsertDisk $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this InsertDisk execution.
     *
     * @return Google_ComputeEngine_Disks_InsertDisk_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this InsertDisk execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_ComputeEngine_Disks_InsertDisk_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_ComputeEngine_Disks_InsertDisk_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the InsertDisk Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Disks_InsertDisk_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the InsertDisk Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_ComputeEngine_Disks_InsertDisk_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this InsertDisk execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this InsertDisk execution.
     *
     * @return string (json) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Retrieves the list of Disk resources available to the specified project.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Disks_ListDisks extends Temboo_Choreography
{
    /**
     * Retrieves the list of Disk resources available to the specified project.
     *
     * @param Temboo_Session $session The session that owns this ListDisks Choreo.
     * @return Google_ComputeEngine_Disks_ListDisks New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/ComputeEngine/Disks/ListDisks/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this ListDisks Choreo.
     *
     * @param Google_ComputeEngine_Disks_ListDisks_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Disks_ListDisks_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Disks_ListDisks_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_ComputeEngine_Disks_ListDisks_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this ListDisks Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Disks_ListDisks_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_ComputeEngine_Disks_ListDisks_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the ListDisks Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Disks_ListDisks_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the ListDisks Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Disks_ListDisks_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this ListDisks input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_ComputeEngine_Disks_ListDisks_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_ComputeEngine_Disks_ListDisks_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this ListDisks Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Google_ComputeEngine_Disks_ListDisks_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this ListDisks Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Disks_ListDisks_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this ListDisks Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Disks_ListDisks_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Fields input for this ListDisks Choreo.
     *
     * @param string $value (optional, string) Comma-seperated list of fields you want to include in the response.
     * @return Google_ComputeEngine_Disks_ListDisks_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Filter input for this ListDisks Choreo.
     *
     * @param string $value (optional, string) A filter expression for narrowing results in the form: {field_name} {comparison_string} {literal_string} (e.g. name eq europe-west1). Comparison strings can be eq (equals) or ne (not equals).
     * @return Google_ComputeEngine_Disks_ListDisks_Inputs For method chaining.
     */
    public function setFilter($value)
    {
        return $this->set('Filter', $value);
    }

    /**
     * Set the value for the MaxResults input for this ListDisks Choreo.
     *
     * @param int $value (optional, integer) The maximum number of results to return.
     * @return Google_ComputeEngine_Disks_ListDisks_Inputs For method chaining.
     */
    public function setMaxResults($value)
    {
        return $this->set('MaxResults', $value);
    }

    /**
     * Set the value for the PageToken input for this ListDisks Choreo.
     *
     * @param string $value (optional, string) The "nextPageToken" found in the response which is used to page through results.
     * @return Google_ComputeEngine_Disks_ListDisks_Inputs For method chaining.
     */
    public function setPageToken($value)
    {
        return $this->set('PageToken', $value);
    }

    /**
     * Set the value for the Project input for this ListDisks Choreo.
     *
     * @param string $value (required, string) The ID of a Google Compute project.
     * @return Google_ComputeEngine_Disks_ListDisks_Inputs For method chaining.
     */
    public function setProject($value)
    {
        return $this->set('Project', $value);
    }

    /**
     * Set the value for the RefreshToken input for this ListDisks Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Disks_ListDisks_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }

    /**
     * Set the value for the Zone input for this ListDisks Choreo.
     *
     * @param string $value (required, string) The name of the zone associated with this request.
     * @return Google_ComputeEngine_Disks_ListDisks_Inputs For method chaining.
     */
    public function setZone($value)
    {
        return $this->set('Zone', $value);
    }
}


/**
 * Execution object for the ListDisks Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Disks_ListDisks_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the ListDisks Choreo.
     *
     * @param Temboo_Session $session The session that owns this ListDisks execution.
     * @param Google_ComputeEngine_Disks_ListDisks $choreo The choreography object for this execution.
     * @param Google_ComputeEngine_Disks_ListDisks_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Disks_ListDisks_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Disks_ListDisks_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_ComputeEngine_Disks_ListDisks $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this ListDisks execution.
     *
     * @return Google_ComputeEngine_Disks_ListDisks_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this ListDisks execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_ComputeEngine_Disks_ListDisks_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_ComputeEngine_Disks_ListDisks_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the ListDisks Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Disks_ListDisks_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the ListDisks Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_ComputeEngine_Disks_ListDisks_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this ListDisks execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this ListDisks execution.
     *
     * @return string (json) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Deletes the specified Firewall resource.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Firewalls_DeleteFirewall extends Temboo_Choreography
{
    /**
     * Deletes the specified Firewall resource.
     *
     * @param Temboo_Session $session The session that owns this DeleteFirewall Choreo.
     * @return Google_ComputeEngine_Firewalls_DeleteFirewall New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/ComputeEngine/Firewalls/DeleteFirewall/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this DeleteFirewall Choreo.
     *
     * @param Google_ComputeEngine_Firewalls_DeleteFirewall_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Firewalls_DeleteFirewall_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Firewalls_DeleteFirewall_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_ComputeEngine_Firewalls_DeleteFirewall_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this DeleteFirewall Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Firewalls_DeleteFirewall_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_ComputeEngine_Firewalls_DeleteFirewall_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the DeleteFirewall Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Firewalls_DeleteFirewall_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the DeleteFirewall Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Firewalls_DeleteFirewall_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this DeleteFirewall input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_ComputeEngine_Firewalls_DeleteFirewall_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_ComputeEngine_Firewalls_DeleteFirewall_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this DeleteFirewall Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Google_ComputeEngine_Firewalls_DeleteFirewall_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this DeleteFirewall Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Firewalls_DeleteFirewall_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this DeleteFirewall Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Firewalls_DeleteFirewall_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Fields input for this DeleteFirewall Choreo.
     *
     * @param string $value (optional, string) Comma-seperated list of fields you want to include in the response.
     * @return Google_ComputeEngine_Firewalls_DeleteFirewall_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Firewall input for this DeleteFirewall Choreo.
     *
     * @param string $value (required, string) The name of the firewall to delete.
     * @return Google_ComputeEngine_Firewalls_DeleteFirewall_Inputs For method chaining.
     */
    public function setFirewall($value)
    {
        return $this->set('Firewall', $value);
    }

    /**
     * Set the value for the Project input for this DeleteFirewall Choreo.
     *
     * @param string $value (required, string) The ID of a Google Compute project.
     * @return Google_ComputeEngine_Firewalls_DeleteFirewall_Inputs For method chaining.
     */
    public function setProject($value)
    {
        return $this->set('Project', $value);
    }

    /**
     * Set the value for the RefreshToken input for this DeleteFirewall Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Firewalls_DeleteFirewall_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }
}


/**
 * Execution object for the DeleteFirewall Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Firewalls_DeleteFirewall_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the DeleteFirewall Choreo.
     *
     * @param Temboo_Session $session The session that owns this DeleteFirewall execution.
     * @param Google_ComputeEngine_Firewalls_DeleteFirewall $choreo The choreography object for this execution.
     * @param Google_ComputeEngine_Firewalls_DeleteFirewall_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Firewalls_DeleteFirewall_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Firewalls_DeleteFirewall_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_ComputeEngine_Firewalls_DeleteFirewall $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this DeleteFirewall execution.
     *
     * @return Google_ComputeEngine_Firewalls_DeleteFirewall_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this DeleteFirewall execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_ComputeEngine_Firewalls_DeleteFirewall_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_ComputeEngine_Firewalls_DeleteFirewall_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the DeleteFirewall Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Firewalls_DeleteFirewall_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the DeleteFirewall Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_ComputeEngine_Firewalls_DeleteFirewall_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this DeleteFirewall execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this DeleteFirewall execution.
     *
     * @return string (json) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Retrieves information about the specified Firewall.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Firewalls_GetFirewall extends Temboo_Choreography
{
    /**
     * Retrieves information about the specified Firewall.
     *
     * @param Temboo_Session $session The session that owns this GetFirewall Choreo.
     * @return Google_ComputeEngine_Firewalls_GetFirewall New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/ComputeEngine/Firewalls/GetFirewall/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this GetFirewall Choreo.
     *
     * @param Google_ComputeEngine_Firewalls_GetFirewall_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Firewalls_GetFirewall_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Firewalls_GetFirewall_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_ComputeEngine_Firewalls_GetFirewall_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this GetFirewall Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Firewalls_GetFirewall_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_ComputeEngine_Firewalls_GetFirewall_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the GetFirewall Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Firewalls_GetFirewall_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the GetFirewall Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Firewalls_GetFirewall_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this GetFirewall input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_ComputeEngine_Firewalls_GetFirewall_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_ComputeEngine_Firewalls_GetFirewall_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this GetFirewall Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Google_ComputeEngine_Firewalls_GetFirewall_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this GetFirewall Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Firewalls_GetFirewall_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this GetFirewall Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Firewalls_GetFirewall_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Fields input for this GetFirewall Choreo.
     *
     * @param string $value (optional, string) Comma-seperated list of fields you want to include in the response.
     * @return Google_ComputeEngine_Firewalls_GetFirewall_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Firewall input for this GetFirewall Choreo.
     *
     * @param string $value (required, string) The name of the firewall to retrieve.
     * @return Google_ComputeEngine_Firewalls_GetFirewall_Inputs For method chaining.
     */
    public function setFirewall($value)
    {
        return $this->set('Firewall', $value);
    }

    /**
     * Set the value for the Project input for this GetFirewall Choreo.
     *
     * @param string $value (required, string) The ID of a Google Compute project.
     * @return Google_ComputeEngine_Firewalls_GetFirewall_Inputs For method chaining.
     */
    public function setProject($value)
    {
        return $this->set('Project', $value);
    }

    /**
     * Set the value for the RefreshToken input for this GetFirewall Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Firewalls_GetFirewall_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }
}


/**
 * Execution object for the GetFirewall Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Firewalls_GetFirewall_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the GetFirewall Choreo.
     *
     * @param Temboo_Session $session The session that owns this GetFirewall execution.
     * @param Google_ComputeEngine_Firewalls_GetFirewall $choreo The choreography object for this execution.
     * @param Google_ComputeEngine_Firewalls_GetFirewall_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Firewalls_GetFirewall_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Firewalls_GetFirewall_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_ComputeEngine_Firewalls_GetFirewall $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this GetFirewall execution.
     *
     * @return Google_ComputeEngine_Firewalls_GetFirewall_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this GetFirewall execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_ComputeEngine_Firewalls_GetFirewall_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_ComputeEngine_Firewalls_GetFirewall_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the GetFirewall Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Firewalls_GetFirewall_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the GetFirewall Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_ComputeEngine_Firewalls_GetFirewall_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this GetFirewall execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this GetFirewall execution.
     *
     * @return string (json) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Creates a Firewall resource in the specified project.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Firewalls_InsertFirewall extends Temboo_Choreography
{
    /**
     * Creates a Firewall resource in the specified project.
     *
     * @param Temboo_Session $session The session that owns this InsertFirewall Choreo.
     * @return Google_ComputeEngine_Firewalls_InsertFirewall New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/ComputeEngine/Firewalls/InsertFirewall/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this InsertFirewall Choreo.
     *
     * @param Google_ComputeEngine_Firewalls_InsertFirewall_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Firewalls_InsertFirewall_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Firewalls_InsertFirewall_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_ComputeEngine_Firewalls_InsertFirewall_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this InsertFirewall Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Firewalls_InsertFirewall_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_ComputeEngine_Firewalls_InsertFirewall_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the InsertFirewall Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Firewalls_InsertFirewall_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the InsertFirewall Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Firewalls_InsertFirewall_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this InsertFirewall input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_ComputeEngine_Firewalls_InsertFirewall_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_ComputeEngine_Firewalls_InsertFirewall_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the FirewallResource input for this InsertFirewall Choreo.
     *
     * @param string $value (optional, json) A JSON string containing the firewall resource properties to set. This can be used as an alternative to individual inputs representing firewall properties.
     * @return Google_ComputeEngine_Firewalls_InsertFirewall_Inputs For method chaining.
     */
    public function setFirewallResource($value)
    {
        return $this->set('FirewallResource', $value);
    }

    /**
     * Set the value for the AccessToken input for this InsertFirewall Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Google_ComputeEngine_Firewalls_InsertFirewall_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the AllowedIPProtocol input for this InsertFirewall Choreo.
     *
     * @param string $value (conditional, json) The IP protocol that is allowed for this rule. This is an array and can have the following properties: IPProtocol (valid values are: tcp, udp, or icmp) and ports[].
     * @return Google_ComputeEngine_Firewalls_InsertFirewall_Inputs For method chaining.
     */
    public function setAllowedIPProtocol($value)
    {
        return $this->set('AllowedIPProtocol', $value);
    }

    /**
     * Set the value for the ClientID input for this InsertFirewall Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Firewalls_InsertFirewall_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this InsertFirewall Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Firewalls_InsertFirewall_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Description input for this InsertFirewall Choreo.
     *
     * @param string $value (optional, string) A description of the firewall.
     * @return Google_ComputeEngine_Firewalls_InsertFirewall_Inputs For method chaining.
     */
    public function setDescription($value)
    {
        return $this->set('Description', $value);
    }

    /**
     * Set the value for the Name input for this InsertFirewall Choreo.
     *
     * @param string $value (conditional, string) The name of the firewall resource being created.
     * @return Google_ComputeEngine_Firewalls_InsertFirewall_Inputs For method chaining.
     */
    public function setName($value)
    {
        return $this->set('Name', $value);
    }

    /**
     * Set the value for the Network input for this InsertFirewall Choreo.
     *
     * @param string $value (conditional, string) The fully-qualified URL of the network to which this firewall is applied.
     * @return Google_ComputeEngine_Firewalls_InsertFirewall_Inputs For method chaining.
     */
    public function setNetwork($value)
    {
        return $this->set('Network', $value);
    }

    /**
     * Set the value for the Project input for this InsertFirewall Choreo.
     *
     * @param string $value (required, string) The ID of a Google Compute project.
     * @return Google_ComputeEngine_Firewalls_InsertFirewall_Inputs For method chaining.
     */
    public function setProject($value)
    {
        return $this->set('Project', $value);
    }

    /**
     * Set the value for the RefreshToken input for this InsertFirewall Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Firewalls_InsertFirewall_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }

    /**
     * Set the value for the SourceRanges input for this InsertFirewall Choreo.
     *
     * @param string $value (conditional, json) An array of address blocks that this rule applies to. This is required if the SourceTags input is not provided.
     * @return Google_ComputeEngine_Firewalls_InsertFirewall_Inputs For method chaining.
     */
    public function setSourceRanges($value)
    {
        return $this->set('SourceRanges', $value);
    }

    /**
     * Set the value for the SourceTags input for this InsertFirewall Choreo.
     *
     * @param string $value (conditional, json) An array of instance tags which this rule applies to. This is required unless the SourceRanges input is provided.
     * @return Google_ComputeEngine_Firewalls_InsertFirewall_Inputs For method chaining.
     */
    public function setSourceTags($value)
    {
        return $this->set('SourceTags', $value);
    }
}


/**
 * Execution object for the InsertFirewall Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Firewalls_InsertFirewall_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the InsertFirewall Choreo.
     *
     * @param Temboo_Session $session The session that owns this InsertFirewall execution.
     * @param Google_ComputeEngine_Firewalls_InsertFirewall $choreo The choreography object for this execution.
     * @param Google_ComputeEngine_Firewalls_InsertFirewall_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Firewalls_InsertFirewall_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Firewalls_InsertFirewall_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_ComputeEngine_Firewalls_InsertFirewall $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this InsertFirewall execution.
     *
     * @return Google_ComputeEngine_Firewalls_InsertFirewall_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this InsertFirewall execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_ComputeEngine_Firewalls_InsertFirewall_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_ComputeEngine_Firewalls_InsertFirewall_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the InsertFirewall Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Firewalls_InsertFirewall_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the InsertFirewall Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_ComputeEngine_Firewalls_InsertFirewall_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this InsertFirewall execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this InsertFirewall execution.
     *
     * @return string (json) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Retrieves the list of Firewall resources for the specified project.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Firewalls_ListFirewalls extends Temboo_Choreography
{
    /**
     * Retrieves the list of Firewall resources for the specified project.
     *
     * @param Temboo_Session $session The session that owns this ListFirewalls Choreo.
     * @return Google_ComputeEngine_Firewalls_ListFirewalls New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/ComputeEngine/Firewalls/ListFirewalls/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this ListFirewalls Choreo.
     *
     * @param Google_ComputeEngine_Firewalls_ListFirewalls_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Firewalls_ListFirewalls_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Firewalls_ListFirewalls_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_ComputeEngine_Firewalls_ListFirewalls_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this ListFirewalls Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Firewalls_ListFirewalls_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_ComputeEngine_Firewalls_ListFirewalls_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the ListFirewalls Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Firewalls_ListFirewalls_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the ListFirewalls Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Firewalls_ListFirewalls_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this ListFirewalls input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_ComputeEngine_Firewalls_ListFirewalls_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_ComputeEngine_Firewalls_ListFirewalls_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this ListFirewalls Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Google_ComputeEngine_Firewalls_ListFirewalls_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this ListFirewalls Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Firewalls_ListFirewalls_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this ListFirewalls Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Firewalls_ListFirewalls_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Fields input for this ListFirewalls Choreo.
     *
     * @param string $value (optional, string) Comma-seperated list of fields you want to include in the response.
     * @return Google_ComputeEngine_Firewalls_ListFirewalls_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Filter input for this ListFirewalls Choreo.
     *
     * @param string $value (optional, string) A filter expression for narrowing results in the form: {field_name} {comparison_string} {literal_string} (e.g. name eq default-ssh). Comparison strings can be eq (equals) or ne (not equals).
     * @return Google_ComputeEngine_Firewalls_ListFirewalls_Inputs For method chaining.
     */
    public function setFilter($value)
    {
        return $this->set('Filter', $value);
    }

    /**
     * Set the value for the MaxResults input for this ListFirewalls Choreo.
     *
     * @param int $value (optional, integer) The maximum number of results to return.
     * @return Google_ComputeEngine_Firewalls_ListFirewalls_Inputs For method chaining.
     */
    public function setMaxResults($value)
    {
        return $this->set('MaxResults', $value);
    }

    /**
     * Set the value for the PageToken input for this ListFirewalls Choreo.
     *
     * @param string $value (optional, string) The "nextPageToken" found in the response which is used to page through results.
     * @return Google_ComputeEngine_Firewalls_ListFirewalls_Inputs For method chaining.
     */
    public function setPageToken($value)
    {
        return $this->set('PageToken', $value);
    }

    /**
     * Set the value for the Project input for this ListFirewalls Choreo.
     *
     * @param string $value (required, string) The ID of a Google Compute project.
     * @return Google_ComputeEngine_Firewalls_ListFirewalls_Inputs For method chaining.
     */
    public function setProject($value)
    {
        return $this->set('Project', $value);
    }

    /**
     * Set the value for the RefreshToken input for this ListFirewalls Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Firewalls_ListFirewalls_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }
}


/**
 * Execution object for the ListFirewalls Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Firewalls_ListFirewalls_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the ListFirewalls Choreo.
     *
     * @param Temboo_Session $session The session that owns this ListFirewalls execution.
     * @param Google_ComputeEngine_Firewalls_ListFirewalls $choreo The choreography object for this execution.
     * @param Google_ComputeEngine_Firewalls_ListFirewalls_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Firewalls_ListFirewalls_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Firewalls_ListFirewalls_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_ComputeEngine_Firewalls_ListFirewalls $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this ListFirewalls execution.
     *
     * @return Google_ComputeEngine_Firewalls_ListFirewalls_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this ListFirewalls execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_ComputeEngine_Firewalls_ListFirewalls_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_ComputeEngine_Firewalls_ListFirewalls_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the ListFirewalls Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Firewalls_ListFirewalls_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the ListFirewalls Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_ComputeEngine_Firewalls_ListFirewalls_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this ListFirewalls execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this ListFirewalls execution.
     *
     * @return string (json) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Updates an existing Firewall resource.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Firewalls_UpdateFirewall extends Temboo_Choreography
{
    /**
     * Updates an existing Firewall resource.
     *
     * @param Temboo_Session $session The session that owns this UpdateFirewall Choreo.
     * @return Google_ComputeEngine_Firewalls_UpdateFirewall New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/ComputeEngine/Firewalls/UpdateFirewall/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this UpdateFirewall Choreo.
     *
     * @param Google_ComputeEngine_Firewalls_UpdateFirewall_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Firewalls_UpdateFirewall_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Firewalls_UpdateFirewall_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_ComputeEngine_Firewalls_UpdateFirewall_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this UpdateFirewall Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Firewalls_UpdateFirewall_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_ComputeEngine_Firewalls_UpdateFirewall_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the UpdateFirewall Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Firewalls_UpdateFirewall_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the UpdateFirewall Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Firewalls_UpdateFirewall_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this UpdateFirewall input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_ComputeEngine_Firewalls_UpdateFirewall_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_ComputeEngine_Firewalls_UpdateFirewall_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the FirewallResource input for this UpdateFirewall Choreo.
     *
     * @param string $value (required, json) A JSON string containing the firewall resource fields to set. Required properties include: allowed, name, network, and either sourceRanges or sourceTags.
     * @return Google_ComputeEngine_Firewalls_UpdateFirewall_Inputs For method chaining.
     */
    public function setFirewallResource($value)
    {
        return $this->set('FirewallResource', $value);
    }

    /**
     * Set the value for the AccessToken input for this UpdateFirewall Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Google_ComputeEngine_Firewalls_UpdateFirewall_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this UpdateFirewall Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Firewalls_UpdateFirewall_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this UpdateFirewall Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Firewalls_UpdateFirewall_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Firewall input for this UpdateFirewall Choreo.
     *
     * @param string $value (required, string) The name of the firewall to update.
     * @return Google_ComputeEngine_Firewalls_UpdateFirewall_Inputs For method chaining.
     */
    public function setFirewall($value)
    {
        return $this->set('Firewall', $value);
    }

    /**
     * Set the value for the Project input for this UpdateFirewall Choreo.
     *
     * @param string $value (required, string) The ID of a Google Compute project.
     * @return Google_ComputeEngine_Firewalls_UpdateFirewall_Inputs For method chaining.
     */
    public function setProject($value)
    {
        return $this->set('Project', $value);
    }

    /**
     * Set the value for the RefreshToken input for this UpdateFirewall Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Firewalls_UpdateFirewall_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }
}


/**
 * Execution object for the UpdateFirewall Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Firewalls_UpdateFirewall_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the UpdateFirewall Choreo.
     *
     * @param Temboo_Session $session The session that owns this UpdateFirewall execution.
     * @param Google_ComputeEngine_Firewalls_UpdateFirewall $choreo The choreography object for this execution.
     * @param Google_ComputeEngine_Firewalls_UpdateFirewall_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Firewalls_UpdateFirewall_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Firewalls_UpdateFirewall_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_ComputeEngine_Firewalls_UpdateFirewall $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this UpdateFirewall execution.
     *
     * @return Google_ComputeEngine_Firewalls_UpdateFirewall_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this UpdateFirewall execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_ComputeEngine_Firewalls_UpdateFirewall_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_ComputeEngine_Firewalls_UpdateFirewall_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the UpdateFirewall Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Firewalls_UpdateFirewall_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the UpdateFirewall Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_ComputeEngine_Firewalls_UpdateFirewall_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this UpdateFirewall execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this UpdateFirewall execution.
     *
     * @return string (json) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Retrieves a list of all Global Operation resources grouped by scope.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_GlobalOperations_AggregatedList extends Temboo_Choreography
{
    /**
     * Retrieves a list of all Global Operation resources grouped by scope.
     *
     * @param Temboo_Session $session The session that owns this AggregatedList Choreo.
     * @return Google_ComputeEngine_GlobalOperations_AggregatedList New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/ComputeEngine/GlobalOperations/AggregatedList/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this AggregatedList Choreo.
     *
     * @param Google_ComputeEngine_GlobalOperations_AggregatedList_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_GlobalOperations_AggregatedList_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_GlobalOperations_AggregatedList_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_ComputeEngine_GlobalOperations_AggregatedList_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this AggregatedList Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_GlobalOperations_AggregatedList_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_ComputeEngine_GlobalOperations_AggregatedList_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the AggregatedList Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_GlobalOperations_AggregatedList_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the AggregatedList Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_GlobalOperations_AggregatedList_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this AggregatedList input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_ComputeEngine_GlobalOperations_AggregatedList_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_ComputeEngine_GlobalOperations_AggregatedList_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this AggregatedList Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Google_ComputeEngine_GlobalOperations_AggregatedList_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this AggregatedList Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_GlobalOperations_AggregatedList_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this AggregatedList Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_GlobalOperations_AggregatedList_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Fields input for this AggregatedList Choreo.
     *
     * @param string $value (optional, string) Comma-seperated list of fields you want to include in the response.
     * @return Google_ComputeEngine_GlobalOperations_AggregatedList_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Filter input for this AggregatedList Choreo.
     *
     * @param string $value (optional, string) A filter expression for narrowing results in the form: {field_name} {comparison_string} {literal_string} (e.g. name eq operation-1234). Comparison strings can be eq (equals) or ne (not equals).
     * @return Google_ComputeEngine_GlobalOperations_AggregatedList_Inputs For method chaining.
     */
    public function setFilter($value)
    {
        return $this->set('Filter', $value);
    }

    /**
     * Set the value for the MaxResults input for this AggregatedList Choreo.
     *
     * @param int $value (optional, integer) The maximum number of results to return.
     * @return Google_ComputeEngine_GlobalOperations_AggregatedList_Inputs For method chaining.
     */
    public function setMaxResults($value)
    {
        return $this->set('MaxResults', $value);
    }

    /**
     * Set the value for the PageToken input for this AggregatedList Choreo.
     *
     * @param string $value (optional, string) The "nextPageToken" found in the response which is used to page through results.
     * @return Google_ComputeEngine_GlobalOperations_AggregatedList_Inputs For method chaining.
     */
    public function setPageToken($value)
    {
        return $this->set('PageToken', $value);
    }

    /**
     * Set the value for the Project input for this AggregatedList Choreo.
     *
     * @param string $value (required, string) The ID of a Google Compute project.
     * @return Google_ComputeEngine_GlobalOperations_AggregatedList_Inputs For method chaining.
     */
    public function setProject($value)
    {
        return $this->set('Project', $value);
    }

    /**
     * Set the value for the RefreshToken input for this AggregatedList Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_GlobalOperations_AggregatedList_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }
}


/**
 * Execution object for the AggregatedList Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_GlobalOperations_AggregatedList_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the AggregatedList Choreo.
     *
     * @param Temboo_Session $session The session that owns this AggregatedList execution.
     * @param Google_ComputeEngine_GlobalOperations_AggregatedList $choreo The choreography object for this execution.
     * @param Google_ComputeEngine_GlobalOperations_AggregatedList_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_GlobalOperations_AggregatedList_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_GlobalOperations_AggregatedList_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_ComputeEngine_GlobalOperations_AggregatedList $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this AggregatedList execution.
     *
     * @return Google_ComputeEngine_GlobalOperations_AggregatedList_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this AggregatedList execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_ComputeEngine_GlobalOperations_AggregatedList_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_ComputeEngine_GlobalOperations_AggregatedList_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the AggregatedList Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_GlobalOperations_AggregatedList_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the AggregatedList Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_ComputeEngine_GlobalOperations_AggregatedList_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this AggregatedList execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this AggregatedList execution.
     *
     * @return string (json) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Deletes the specified Global Operation.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_GlobalOperations_DeleteGlobalOperation extends Temboo_Choreography
{
    /**
     * Deletes the specified Global Operation.
     *
     * @param Temboo_Session $session The session that owns this DeleteGlobalOperation Choreo.
     * @return Google_ComputeEngine_GlobalOperations_DeleteGlobalOperation New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/ComputeEngine/GlobalOperations/DeleteGlobalOperation/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this DeleteGlobalOperation Choreo.
     *
     * @param Google_ComputeEngine_GlobalOperations_DeleteGlobalOperation_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_GlobalOperations_DeleteGlobalOperation_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_GlobalOperations_DeleteGlobalOperation_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_ComputeEngine_GlobalOperations_DeleteGlobalOperation_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this DeleteGlobalOperation Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_GlobalOperations_DeleteGlobalOperation_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_ComputeEngine_GlobalOperations_DeleteGlobalOperation_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the DeleteGlobalOperation Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_GlobalOperations_DeleteGlobalOperation_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the DeleteGlobalOperation Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_GlobalOperations_DeleteGlobalOperation_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this DeleteGlobalOperation input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_ComputeEngine_GlobalOperations_DeleteGlobalOperation_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_ComputeEngine_GlobalOperations_DeleteGlobalOperation_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this DeleteGlobalOperation Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Google_ComputeEngine_GlobalOperations_DeleteGlobalOperation_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this DeleteGlobalOperation Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_GlobalOperations_DeleteGlobalOperation_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this DeleteGlobalOperation Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_GlobalOperations_DeleteGlobalOperation_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Operation input for this DeleteGlobalOperation Choreo.
     *
     * @param string $value (required, string) The name of the operation to delete.
     * @return Google_ComputeEngine_GlobalOperations_DeleteGlobalOperation_Inputs For method chaining.
     */
    public function setOperation($value)
    {
        return $this->set('Operation', $value);
    }

    /**
     * Set the value for the Project input for this DeleteGlobalOperation Choreo.
     *
     * @param string $value (required, string) The ID of a Google Compute project.
     * @return Google_ComputeEngine_GlobalOperations_DeleteGlobalOperation_Inputs For method chaining.
     */
    public function setProject($value)
    {
        return $this->set('Project', $value);
    }

    /**
     * Set the value for the RefreshToken input for this DeleteGlobalOperation Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_GlobalOperations_DeleteGlobalOperation_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }
}


/**
 * Execution object for the DeleteGlobalOperation Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_GlobalOperations_DeleteGlobalOperation_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the DeleteGlobalOperation Choreo.
     *
     * @param Temboo_Session $session The session that owns this DeleteGlobalOperation execution.
     * @param Google_ComputeEngine_GlobalOperations_DeleteGlobalOperation $choreo The choreography object for this execution.
     * @param Google_ComputeEngine_GlobalOperations_DeleteGlobalOperation_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_GlobalOperations_DeleteGlobalOperation_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_GlobalOperations_DeleteGlobalOperation_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_ComputeEngine_GlobalOperations_DeleteGlobalOperation $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this DeleteGlobalOperation execution.
     *
     * @return Google_ComputeEngine_GlobalOperations_DeleteGlobalOperation_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this DeleteGlobalOperation execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_ComputeEngine_GlobalOperations_DeleteGlobalOperation_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_ComputeEngine_GlobalOperations_DeleteGlobalOperation_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the DeleteGlobalOperation Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_GlobalOperations_DeleteGlobalOperation_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the DeleteGlobalOperation Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_ComputeEngine_GlobalOperations_DeleteGlobalOperation_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this DeleteGlobalOperation execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "ResponseStatusCode" output from this DeleteGlobalOperation execution.
     *
     * @return int (integer) The response status code returned from Google. A 204 is expected for a successful delete operation.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponseStatusCode()
    {
        return $this->get('ResponseStatusCode');
    }
    /**
     * Retrieve the value for the "Response" output from this DeleteGlobalOperation execution.
     *
     * @return string (json) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Retrieves information about the specified Global Operation.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_GlobalOperations_GetGlobalOperation extends Temboo_Choreography
{
    /**
     * Retrieves information about the specified Global Operation.
     *
     * @param Temboo_Session $session The session that owns this GetGlobalOperation Choreo.
     * @return Google_ComputeEngine_GlobalOperations_GetGlobalOperation New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/ComputeEngine/GlobalOperations/GetGlobalOperation/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this GetGlobalOperation Choreo.
     *
     * @param Google_ComputeEngine_GlobalOperations_GetGlobalOperation_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_GlobalOperations_GetGlobalOperation_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_GlobalOperations_GetGlobalOperation_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_ComputeEngine_GlobalOperations_GetGlobalOperation_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this GetGlobalOperation Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_GlobalOperations_GetGlobalOperation_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_ComputeEngine_GlobalOperations_GetGlobalOperation_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the GetGlobalOperation Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_GlobalOperations_GetGlobalOperation_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the GetGlobalOperation Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_GlobalOperations_GetGlobalOperation_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this GetGlobalOperation input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_ComputeEngine_GlobalOperations_GetGlobalOperation_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_ComputeEngine_GlobalOperations_GetGlobalOperation_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this GetGlobalOperation Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Google_ComputeEngine_GlobalOperations_GetGlobalOperation_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this GetGlobalOperation Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_GlobalOperations_GetGlobalOperation_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this GetGlobalOperation Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_GlobalOperations_GetGlobalOperation_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Fields input for this GetGlobalOperation Choreo.
     *
     * @param string $value (optional, string) Comma-seperated list of fields you want to include in the response.
     * @return Google_ComputeEngine_GlobalOperations_GetGlobalOperation_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Operation input for this GetGlobalOperation Choreo.
     *
     * @param string $value (required, string) The name of the operation to retrieve.
     * @return Google_ComputeEngine_GlobalOperations_GetGlobalOperation_Inputs For method chaining.
     */
    public function setOperation($value)
    {
        return $this->set('Operation', $value);
    }

    /**
     * Set the value for the Project input for this GetGlobalOperation Choreo.
     *
     * @param string $value (required, string) The ID of a Google Compute project.
     * @return Google_ComputeEngine_GlobalOperations_GetGlobalOperation_Inputs For method chaining.
     */
    public function setProject($value)
    {
        return $this->set('Project', $value);
    }

    /**
     * Set the value for the RefreshToken input for this GetGlobalOperation Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_GlobalOperations_GetGlobalOperation_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }
}


/**
 * Execution object for the GetGlobalOperation Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_GlobalOperations_GetGlobalOperation_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the GetGlobalOperation Choreo.
     *
     * @param Temboo_Session $session The session that owns this GetGlobalOperation execution.
     * @param Google_ComputeEngine_GlobalOperations_GetGlobalOperation $choreo The choreography object for this execution.
     * @param Google_ComputeEngine_GlobalOperations_GetGlobalOperation_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_GlobalOperations_GetGlobalOperation_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_GlobalOperations_GetGlobalOperation_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_ComputeEngine_GlobalOperations_GetGlobalOperation $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this GetGlobalOperation execution.
     *
     * @return Google_ComputeEngine_GlobalOperations_GetGlobalOperation_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this GetGlobalOperation execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_ComputeEngine_GlobalOperations_GetGlobalOperation_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_ComputeEngine_GlobalOperations_GetGlobalOperation_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the GetGlobalOperation Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_GlobalOperations_GetGlobalOperation_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the GetGlobalOperation Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_ComputeEngine_GlobalOperations_GetGlobalOperation_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this GetGlobalOperation execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this GetGlobalOperation execution.
     *
     * @return string (json) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Retrieves a list of GlobalOperations resources contained within the specified project.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_GlobalOperations_ListGlobalOperations extends Temboo_Choreography
{
    /**
     * Retrieves a list of GlobalOperations resources contained within the specified project.
     *
     * @param Temboo_Session $session The session that owns this ListGlobalOperations Choreo.
     * @return Google_ComputeEngine_GlobalOperations_ListGlobalOperations New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/ComputeEngine/GlobalOperations/ListGlobalOperations/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this ListGlobalOperations Choreo.
     *
     * @param Google_ComputeEngine_GlobalOperations_ListGlobalOperations_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_GlobalOperations_ListGlobalOperations_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_GlobalOperations_ListGlobalOperations_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_ComputeEngine_GlobalOperations_ListGlobalOperations_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this ListGlobalOperations Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_GlobalOperations_ListGlobalOperations_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_ComputeEngine_GlobalOperations_ListGlobalOperations_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the ListGlobalOperations Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_GlobalOperations_ListGlobalOperations_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the ListGlobalOperations Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_GlobalOperations_ListGlobalOperations_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this ListGlobalOperations input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_ComputeEngine_GlobalOperations_ListGlobalOperations_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_ComputeEngine_GlobalOperations_ListGlobalOperations_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this ListGlobalOperations Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Google_ComputeEngine_GlobalOperations_ListGlobalOperations_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this ListGlobalOperations Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_GlobalOperations_ListGlobalOperations_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this ListGlobalOperations Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_GlobalOperations_ListGlobalOperations_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Fields input for this ListGlobalOperations Choreo.
     *
     * @param string $value (optional, string) Comma-seperated list of fields you want to include in the response.
     * @return Google_ComputeEngine_GlobalOperations_ListGlobalOperations_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Filter input for this ListGlobalOperations Choreo.
     *
     * @param string $value (optional, string) A filter expression for narrowing results in the form: {field_name} {comparison_string} {literal_string} (e.g. name eq operation-1234). Comparison strings can be eq (equals) or ne (not equals).
     * @return Google_ComputeEngine_GlobalOperations_ListGlobalOperations_Inputs For method chaining.
     */
    public function setFilter($value)
    {
        return $this->set('Filter', $value);
    }

    /**
     * Set the value for the MaxResults input for this ListGlobalOperations Choreo.
     *
     * @param int $value (optional, integer) The maximum number of results to return.
     * @return Google_ComputeEngine_GlobalOperations_ListGlobalOperations_Inputs For method chaining.
     */
    public function setMaxResults($value)
    {
        return $this->set('MaxResults', $value);
    }

    /**
     * Set the value for the PageToken input for this ListGlobalOperations Choreo.
     *
     * @param string $value (optional, string) The "nextPageToken" found in the response which is used to page through results.
     * @return Google_ComputeEngine_GlobalOperations_ListGlobalOperations_Inputs For method chaining.
     */
    public function setPageToken($value)
    {
        return $this->set('PageToken', $value);
    }

    /**
     * Set the value for the Project input for this ListGlobalOperations Choreo.
     *
     * @param string $value (required, string) The ID of a Google Compute project.
     * @return Google_ComputeEngine_GlobalOperations_ListGlobalOperations_Inputs For method chaining.
     */
    public function setProject($value)
    {
        return $this->set('Project', $value);
    }

    /**
     * Set the value for the RefreshToken input for this ListGlobalOperations Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_GlobalOperations_ListGlobalOperations_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }
}


/**
 * Execution object for the ListGlobalOperations Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_GlobalOperations_ListGlobalOperations_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the ListGlobalOperations Choreo.
     *
     * @param Temboo_Session $session The session that owns this ListGlobalOperations execution.
     * @param Google_ComputeEngine_GlobalOperations_ListGlobalOperations $choreo The choreography object for this execution.
     * @param Google_ComputeEngine_GlobalOperations_ListGlobalOperations_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_GlobalOperations_ListGlobalOperations_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_GlobalOperations_ListGlobalOperations_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_ComputeEngine_GlobalOperations_ListGlobalOperations $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this ListGlobalOperations execution.
     *
     * @return Google_ComputeEngine_GlobalOperations_ListGlobalOperations_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this ListGlobalOperations execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_ComputeEngine_GlobalOperations_ListGlobalOperations_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_ComputeEngine_GlobalOperations_ListGlobalOperations_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the ListGlobalOperations Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_GlobalOperations_ListGlobalOperations_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the ListGlobalOperations Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_ComputeEngine_GlobalOperations_ListGlobalOperations_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this ListGlobalOperations execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this ListGlobalOperations execution.
     *
     * @return string (json) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Deletes the specified Image resource.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Images_DeleteImage extends Temboo_Choreography
{
    /**
     * Deletes the specified Image resource.
     *
     * @param Temboo_Session $session The session that owns this DeleteImage Choreo.
     * @return Google_ComputeEngine_Images_DeleteImage New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/ComputeEngine/Images/DeleteImage/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this DeleteImage Choreo.
     *
     * @param Google_ComputeEngine_Images_DeleteImage_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Images_DeleteImage_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Images_DeleteImage_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_ComputeEngine_Images_DeleteImage_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this DeleteImage Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Images_DeleteImage_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_ComputeEngine_Images_DeleteImage_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the DeleteImage Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Images_DeleteImage_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the DeleteImage Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Images_DeleteImage_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this DeleteImage input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_ComputeEngine_Images_DeleteImage_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_ComputeEngine_Images_DeleteImage_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this DeleteImage Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Google_ComputeEngine_Images_DeleteImage_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this DeleteImage Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Images_DeleteImage_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this DeleteImage Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Images_DeleteImage_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Fields input for this DeleteImage Choreo.
     *
     * @param string $value (optional, string) Comma-seperated list of fields you want to include in the response.
     * @return Google_ComputeEngine_Images_DeleteImage_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Image input for this DeleteImage Choreo.
     *
     * @param string $value (required, string) The name of the Image to delete.
     * @return Google_ComputeEngine_Images_DeleteImage_Inputs For method chaining.
     */
    public function setImage($value)
    {
        return $this->set('Image', $value);
    }

    /**
     * Set the value for the Project input for this DeleteImage Choreo.
     *
     * @param string $value (required, string) The ID of a Google Compute project.
     * @return Google_ComputeEngine_Images_DeleteImage_Inputs For method chaining.
     */
    public function setProject($value)
    {
        return $this->set('Project', $value);
    }

    /**
     * Set the value for the RefreshToken input for this DeleteImage Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Images_DeleteImage_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }
}


/**
 * Execution object for the DeleteImage Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Images_DeleteImage_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the DeleteImage Choreo.
     *
     * @param Temboo_Session $session The session that owns this DeleteImage execution.
     * @param Google_ComputeEngine_Images_DeleteImage $choreo The choreography object for this execution.
     * @param Google_ComputeEngine_Images_DeleteImage_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Images_DeleteImage_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Images_DeleteImage_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_ComputeEngine_Images_DeleteImage $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this DeleteImage execution.
     *
     * @return Google_ComputeEngine_Images_DeleteImage_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this DeleteImage execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_ComputeEngine_Images_DeleteImage_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_ComputeEngine_Images_DeleteImage_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the DeleteImage Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Images_DeleteImage_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the DeleteImage Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_ComputeEngine_Images_DeleteImage_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this DeleteImage execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this DeleteImage execution.
     *
     * @return string (json) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Retrieves information about the specified Image.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Images_GetImage extends Temboo_Choreography
{
    /**
     * Retrieves information about the specified Image.
     *
     * @param Temboo_Session $session The session that owns this GetImage Choreo.
     * @return Google_ComputeEngine_Images_GetImage New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/ComputeEngine/Images/GetImage/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this GetImage Choreo.
     *
     * @param Google_ComputeEngine_Images_GetImage_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Images_GetImage_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Images_GetImage_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_ComputeEngine_Images_GetImage_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this GetImage Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Images_GetImage_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_ComputeEngine_Images_GetImage_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the GetImage Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Images_GetImage_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the GetImage Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Images_GetImage_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this GetImage input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_ComputeEngine_Images_GetImage_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_ComputeEngine_Images_GetImage_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this GetImage Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Google_ComputeEngine_Images_GetImage_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this GetImage Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Images_GetImage_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this GetImage Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Images_GetImage_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Fields input for this GetImage Choreo.
     *
     * @param string $value (optional, string) Comma-seperated list of fields you want to include in the response.
     * @return Google_ComputeEngine_Images_GetImage_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Image input for this GetImage Choreo.
     *
     * @param string $value (required, string) The name of the Image to retrieve.
     * @return Google_ComputeEngine_Images_GetImage_Inputs For method chaining.
     */
    public function setImage($value)
    {
        return $this->set('Image', $value);
    }

    /**
     * Set the value for the Project input for this GetImage Choreo.
     *
     * @param string $value (required, string) The ID of a Google Compute project.
     * @return Google_ComputeEngine_Images_GetImage_Inputs For method chaining.
     */
    public function setProject($value)
    {
        return $this->set('Project', $value);
    }

    /**
     * Set the value for the RefreshToken input for this GetImage Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Images_GetImage_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }
}


/**
 * Execution object for the GetImage Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Images_GetImage_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the GetImage Choreo.
     *
     * @param Temboo_Session $session The session that owns this GetImage execution.
     * @param Google_ComputeEngine_Images_GetImage $choreo The choreography object for this execution.
     * @param Google_ComputeEngine_Images_GetImage_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Images_GetImage_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Images_GetImage_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_ComputeEngine_Images_GetImage $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this GetImage execution.
     *
     * @return Google_ComputeEngine_Images_GetImage_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this GetImage execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_ComputeEngine_Images_GetImage_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_ComputeEngine_Images_GetImage_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the GetImage Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Images_GetImage_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the GetImage Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_ComputeEngine_Images_GetImage_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this GetImage execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this GetImage execution.
     *
     * @return string (json) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Creates a new custom Image resource in the specified project.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Images_InsertImage extends Temboo_Choreography
{
    /**
     * Creates a new custom Image resource in the specified project.
     *
     * @param Temboo_Session $session The session that owns this InsertImage Choreo.
     * @return Google_ComputeEngine_Images_InsertImage New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/ComputeEngine/Images/InsertImage/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this InsertImage Choreo.
     *
     * @param Google_ComputeEngine_Images_InsertImage_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Images_InsertImage_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Images_InsertImage_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_ComputeEngine_Images_InsertImage_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this InsertImage Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Images_InsertImage_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_ComputeEngine_Images_InsertImage_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the InsertImage Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Images_InsertImage_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the InsertImage Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Images_InsertImage_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this InsertImage input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_ComputeEngine_Images_InsertImage_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_ComputeEngine_Images_InsertImage_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the ImageResource input for this InsertImage Choreo.
     *
     * @param string $value (optional, json) A JSON string containing the image resource properties to set. This can used as an alternative to individual inputs representing image properties.
     * @return Google_ComputeEngine_Images_InsertImage_Inputs For method chaining.
     */
    public function setImageResource($value)
    {
        return $this->set('ImageResource', $value);
    }

    /**
     * Set the value for the AccessToken input for this InsertImage Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Google_ComputeEngine_Images_InsertImage_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this InsertImage Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Images_InsertImage_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this InsertImage Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Images_InsertImage_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Description input for this InsertImage Choreo.
     *
     * @param string $value (optional, string) A description of the image.
     * @return Google_ComputeEngine_Images_InsertImage_Inputs For method chaining.
     */
    public function setDescription($value)
    {
        return $this->set('Description', $value);
    }

    /**
     * Set the value for the Name input for this InsertImage Choreo.
     *
     * @param string $value (conditional, string) The name of the image.
     * @return Google_ComputeEngine_Images_InsertImage_Inputs For method chaining.
     */
    public function setName($value)
    {
        return $this->set('Name', $value);
    }

    /**
     * Set the value for the Project input for this InsertImage Choreo.
     *
     * @param string $value (required, string) The ID of a Google Compute project.
     * @return Google_ComputeEngine_Images_InsertImage_Inputs For method chaining.
     */
    public function setProject($value)
    {
        return $this->set('Project', $value);
    }

    /**
     * Set the value for the RawDiskSource input for this InsertImage Choreo.
     *
     * @param string $value (conditional, string) The full Google Cloud Storage URL where the disk image is stored.
     * @return Google_ComputeEngine_Images_InsertImage_Inputs For method chaining.
     */
    public function setRawDiskSource($value)
    {
        return $this->set('RawDiskSource', $value);
    }

    /**
     * Set the value for the RefreshToken input for this InsertImage Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Images_InsertImage_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }
}


/**
 * Execution object for the InsertImage Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Images_InsertImage_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the InsertImage Choreo.
     *
     * @param Temboo_Session $session The session that owns this InsertImage execution.
     * @param Google_ComputeEngine_Images_InsertImage $choreo The choreography object for this execution.
     * @param Google_ComputeEngine_Images_InsertImage_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Images_InsertImage_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Images_InsertImage_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_ComputeEngine_Images_InsertImage $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this InsertImage execution.
     *
     * @return Google_ComputeEngine_Images_InsertImage_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this InsertImage execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_ComputeEngine_Images_InsertImage_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_ComputeEngine_Images_InsertImage_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the InsertImage Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Images_InsertImage_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the InsertImage Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_ComputeEngine_Images_InsertImage_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this InsertImage execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this InsertImage execution.
     *
     * @return string (json) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Retrieves a list of Image resources for the specified project.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Images_ListImages extends Temboo_Choreography
{
    /**
     * Retrieves a list of Image resources for the specified project.
     *
     * @param Temboo_Session $session The session that owns this ListImages Choreo.
     * @return Google_ComputeEngine_Images_ListImages New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/ComputeEngine/Images/ListImages/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this ListImages Choreo.
     *
     * @param Google_ComputeEngine_Images_ListImages_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Images_ListImages_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Images_ListImages_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_ComputeEngine_Images_ListImages_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this ListImages Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Images_ListImages_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_ComputeEngine_Images_ListImages_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the ListImages Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Images_ListImages_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the ListImages Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Images_ListImages_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this ListImages input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_ComputeEngine_Images_ListImages_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_ComputeEngine_Images_ListImages_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this ListImages Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Google_ComputeEngine_Images_ListImages_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this ListImages Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Images_ListImages_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this ListImages Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Images_ListImages_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Fields input for this ListImages Choreo.
     *
     * @param string $value (optional, string) Comma-seperated list of fields you want to include in the response.
     * @return Google_ComputeEngine_Images_ListImages_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Filter input for this ListImages Choreo.
     *
     * @param string $value (optional, string) A filter expression for narrowing results in the form: {field_name} {comparison_string} {literal_string} (e.g. name eq testimage). Comparison strings can be eq (equals) or ne (not equals).
     * @return Google_ComputeEngine_Images_ListImages_Inputs For method chaining.
     */
    public function setFilter($value)
    {
        return $this->set('Filter', $value);
    }

    /**
     * Set the value for the MaxResults input for this ListImages Choreo.
     *
     * @param int $value (optional, integer) The maximum number of results to return.
     * @return Google_ComputeEngine_Images_ListImages_Inputs For method chaining.
     */
    public function setMaxResults($value)
    {
        return $this->set('MaxResults', $value);
    }

    /**
     * Set the value for the PageToken input for this ListImages Choreo.
     *
     * @param string $value (optional, string) The "nextPageToken" found in the response which is used to page through results.
     * @return Google_ComputeEngine_Images_ListImages_Inputs For method chaining.
     */
    public function setPageToken($value)
    {
        return $this->set('PageToken', $value);
    }

    /**
     * Set the value for the Project input for this ListImages Choreo.
     *
     * @param string $value (required, string) The ID of a Google Compute project.
     * @return Google_ComputeEngine_Images_ListImages_Inputs For method chaining.
     */
    public function setProject($value)
    {
        return $this->set('Project', $value);
    }

    /**
     * Set the value for the RefreshToken input for this ListImages Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Images_ListImages_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }
}


/**
 * Execution object for the ListImages Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Images_ListImages_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the ListImages Choreo.
     *
     * @param Temboo_Session $session The session that owns this ListImages execution.
     * @param Google_ComputeEngine_Images_ListImages $choreo The choreography object for this execution.
     * @param Google_ComputeEngine_Images_ListImages_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Images_ListImages_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Images_ListImages_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_ComputeEngine_Images_ListImages $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this ListImages execution.
     *
     * @return Google_ComputeEngine_Images_ListImages_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this ListImages execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_ComputeEngine_Images_ListImages_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_ComputeEngine_Images_ListImages_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the ListImages Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Images_ListImages_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the ListImages Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_ComputeEngine_Images_ListImages_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this ListImages execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this ListImages execution.
     *
     * @return string (json) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Adds an access config to an instance's network interface.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Instances_AddAccessConfig extends Temboo_Choreography
{
    /**
     * Adds an access config to an instance's network interface.
     *
     * @param Temboo_Session $session The session that owns this AddAccessConfig Choreo.
     * @return Google_ComputeEngine_Instances_AddAccessConfig New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/ComputeEngine/Instances/AddAccessConfig/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this AddAccessConfig Choreo.
     *
     * @param Google_ComputeEngine_Instances_AddAccessConfig_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Instances_AddAccessConfig_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Instances_AddAccessConfig_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_ComputeEngine_Instances_AddAccessConfig_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this AddAccessConfig Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Instances_AddAccessConfig_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_ComputeEngine_Instances_AddAccessConfig_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the AddAccessConfig Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Instances_AddAccessConfig_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the AddAccessConfig Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Instances_AddAccessConfig_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this AddAccessConfig input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_ComputeEngine_Instances_AddAccessConfig_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_ComputeEngine_Instances_AddAccessConfig_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessConfiguration input for this AddAccessConfig Choreo.
     *
     * @param string $value (optional, json) A JSON string containing the access configuration properties you wish to set. This can be used as an alternative to individual inputs that represent access configuration properties.
     * @return Google_ComputeEngine_Instances_AddAccessConfig_Inputs For method chaining.
     */
    public function setAccessConfiguration($value)
    {
        return $this->set('AccessConfiguration', $value);
    }

    /**
     * Set the value for the AccessToken input for this AddAccessConfig Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Google_ComputeEngine_Instances_AddAccessConfig_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this AddAccessConfig Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Instances_AddAccessConfig_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this AddAccessConfig Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Instances_AddAccessConfig_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Instance input for this AddAccessConfig Choreo.
     *
     * @param string $value (required, string) Name of the instance for which to add an access configuration.
     * @return Google_ComputeEngine_Instances_AddAccessConfig_Inputs For method chaining.
     */
    public function setInstance($value)
    {
        return $this->set('Instance', $value);
    }

    /**
     * Set the value for the Name input for this AddAccessConfig Choreo.
     *
     * @param string $value (optional, string) The name of this access configuration. Defaults to "External NAT" if not specified.
     * @return Google_ComputeEngine_Instances_AddAccessConfig_Inputs For method chaining.
     */
    public function setName($value)
    {
        return $this->set('Name', $value);
    }

    /**
     * Set the value for the NatIP input for this AddAccessConfig Choreo.
     *
     * @param string $value (optional, string) An external IP address associated with this instance. Specify an unused static IP address available to the project. An external IP will be drawn from a shared ephemeral pool when not specified.
     * @return Google_ComputeEngine_Instances_AddAccessConfig_Inputs For method chaining.
     */
    public function setNatIP($value)
    {
        return $this->set('NatIP', $value);
    }

    /**
     * Set the value for the NetworkInterface input for this AddAccessConfig Choreo.
     *
     * @param string $value (required, string) The name of the network interface to add the access config (e.g. nic0, nic1, etc).
     * @return Google_ComputeEngine_Instances_AddAccessConfig_Inputs For method chaining.
     */
    public function setNetworkInterface($value)
    {
        return $this->set('NetworkInterface', $value);
    }

    /**
     * Set the value for the Project input for this AddAccessConfig Choreo.
     *
     * @param string $value (required, string) The ID of a Google Compute project.
     * @return Google_ComputeEngine_Instances_AddAccessConfig_Inputs For method chaining.
     */
    public function setProject($value)
    {
        return $this->set('Project', $value);
    }

    /**
     * Set the value for the RefreshToken input for this AddAccessConfig Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Instances_AddAccessConfig_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }

    /**
     * Set the value for the Type input for this AddAccessConfig Choreo.
     *
     * @param string $value (required, string) Type of configuration. Must be set to ONE_TO_ONE_NAT.
     * @return Google_ComputeEngine_Instances_AddAccessConfig_Inputs For method chaining.
     */
    public function setType($value)
    {
        return $this->set('Type', $value);
    }

    /**
     * Set the value for the Zone input for this AddAccessConfig Choreo.
     *
     * @param string $value (required, string) The name of the zone associated with this request.
     * @return Google_ComputeEngine_Instances_AddAccessConfig_Inputs For method chaining.
     */
    public function setZone($value)
    {
        return $this->set('Zone', $value);
    }
}


/**
 * Execution object for the AddAccessConfig Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Instances_AddAccessConfig_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the AddAccessConfig Choreo.
     *
     * @param Temboo_Session $session The session that owns this AddAccessConfig execution.
     * @param Google_ComputeEngine_Instances_AddAccessConfig $choreo The choreography object for this execution.
     * @param Google_ComputeEngine_Instances_AddAccessConfig_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Instances_AddAccessConfig_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Instances_AddAccessConfig_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_ComputeEngine_Instances_AddAccessConfig $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this AddAccessConfig execution.
     *
     * @return Google_ComputeEngine_Instances_AddAccessConfig_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this AddAccessConfig execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_ComputeEngine_Instances_AddAccessConfig_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_ComputeEngine_Instances_AddAccessConfig_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the AddAccessConfig Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Instances_AddAccessConfig_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the AddAccessConfig Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_ComputeEngine_Instances_AddAccessConfig_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this AddAccessConfig execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this AddAccessConfig execution.
     *
     * @return string (json) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Retrieves a list of Instance resources across all available zones.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Instances_AggregatedList extends Temboo_Choreography
{
    /**
     * Retrieves a list of Instance resources across all available zones.
     *
     * @param Temboo_Session $session The session that owns this AggregatedList Choreo.
     * @return Google_ComputeEngine_Instances_AggregatedList New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/ComputeEngine/Instances/AggregatedList/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this AggregatedList Choreo.
     *
     * @param Google_ComputeEngine_Instances_AggregatedList_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Instances_AggregatedList_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Instances_AggregatedList_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_ComputeEngine_Instances_AggregatedList_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this AggregatedList Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Instances_AggregatedList_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_ComputeEngine_Instances_AggregatedList_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the AggregatedList Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Instances_AggregatedList_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the AggregatedList Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Instances_AggregatedList_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this AggregatedList input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_ComputeEngine_Instances_AggregatedList_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_ComputeEngine_Instances_AggregatedList_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this AggregatedList Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Google_ComputeEngine_Instances_AggregatedList_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this AggregatedList Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Instances_AggregatedList_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this AggregatedList Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Instances_AggregatedList_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Fields input for this AggregatedList Choreo.
     *
     * @param string $value (optional, string) Comma-seperated list of fields you want to include in the response.
     * @return Google_ComputeEngine_Instances_AggregatedList_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Filter input for this AggregatedList Choreo.
     *
     * @param string $value (optional, string) A filter expression for narrowing results in the form: {field_name} {comparison_string} {literal_string} (e.g. name eq my_instance). Comparison strings can be eq (equals) or ne (not equals).
     * @return Google_ComputeEngine_Instances_AggregatedList_Inputs For method chaining.
     */
    public function setFilter($value)
    {
        return $this->set('Filter', $value);
    }

    /**
     * Set the value for the MaxResults input for this AggregatedList Choreo.
     *
     * @param int $value (optional, integer) The maximum number of results to return.
     * @return Google_ComputeEngine_Instances_AggregatedList_Inputs For method chaining.
     */
    public function setMaxResults($value)
    {
        return $this->set('MaxResults', $value);
    }

    /**
     * Set the value for the PageToken input for this AggregatedList Choreo.
     *
     * @param string $value (optional, string) The "nextPageToken" found in the response which is used to page through results.
     * @return Google_ComputeEngine_Instances_AggregatedList_Inputs For method chaining.
     */
    public function setPageToken($value)
    {
        return $this->set('PageToken', $value);
    }

    /**
     * Set the value for the Project input for this AggregatedList Choreo.
     *
     * @param string $value (required, string) The ID of a Google Compute project.
     * @return Google_ComputeEngine_Instances_AggregatedList_Inputs For method chaining.
     */
    public function setProject($value)
    {
        return $this->set('Project', $value);
    }

    /**
     * Set the value for the RefreshToken input for this AggregatedList Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Instances_AggregatedList_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }
}


/**
 * Execution object for the AggregatedList Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Instances_AggregatedList_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the AggregatedList Choreo.
     *
     * @param Temboo_Session $session The session that owns this AggregatedList execution.
     * @param Google_ComputeEngine_Instances_AggregatedList $choreo The choreography object for this execution.
     * @param Google_ComputeEngine_Instances_AggregatedList_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Instances_AggregatedList_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Instances_AggregatedList_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_ComputeEngine_Instances_AggregatedList $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this AggregatedList execution.
     *
     * @return Google_ComputeEngine_Instances_AggregatedList_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this AggregatedList execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_ComputeEngine_Instances_AggregatedList_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_ComputeEngine_Instances_AggregatedList_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the AggregatedList Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Instances_AggregatedList_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the AggregatedList Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_ComputeEngine_Instances_AggregatedList_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this AggregatedList execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this AggregatedList execution.
     *
     * @return string (json) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Attaches a Disk resource to an instance.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Instances_AttachDisk extends Temboo_Choreography
{
    /**
     * Attaches a Disk resource to an instance.
     *
     * @param Temboo_Session $session The session that owns this AttachDisk Choreo.
     * @return Google_ComputeEngine_Instances_AttachDisk New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/ComputeEngine/Instances/AttachDisk/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this AttachDisk Choreo.
     *
     * @param Google_ComputeEngine_Instances_AttachDisk_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Instances_AttachDisk_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Instances_AttachDisk_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_ComputeEngine_Instances_AttachDisk_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this AttachDisk Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Instances_AttachDisk_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_ComputeEngine_Instances_AttachDisk_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the AttachDisk Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Instances_AttachDisk_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the AttachDisk Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Instances_AttachDisk_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this AttachDisk input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_ComputeEngine_Instances_AttachDisk_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_ComputeEngine_Instances_AttachDisk_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AttachedDisk input for this AttachDisk Choreo.
     *
     * @param string $value (optional, json) A JSON string containing the attached disk properties to set. This can be used as an alternative to the individual inputs representing the attached disk properties.
     * @return Google_ComputeEngine_Instances_AttachDisk_Inputs For method chaining.
     */
    public function setAttachedDisk($value)
    {
        return $this->set('AttachedDisk', $value);
    }

    /**
     * Set the value for the AccessToken input for this AttachDisk Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Google_ComputeEngine_Instances_AttachDisk_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the Boot input for this AttachDisk Choreo.
     *
     * @param bool $value (conditional, boolean) Whether or not this is a boot disk. Valid values are: true or false.
     * @return Google_ComputeEngine_Instances_AttachDisk_Inputs For method chaining.
     */
    public function setBoot($value)
    {
        return $this->set('Boot', $value);
    }

    /**
     * Set the value for the ClientID input for this AttachDisk Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Instances_AttachDisk_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this AttachDisk Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Instances_AttachDisk_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the DeviceName input for this AttachDisk Choreo.
     *
     * @param string $value (conditional, string) The name of the disk to attach.
     * @return Google_ComputeEngine_Instances_AttachDisk_Inputs For method chaining.
     */
    public function setDeviceName($value)
    {
        return $this->set('DeviceName', $value);
    }

    /**
     * Set the value for the Fields input for this AttachDisk Choreo.
     *
     * @param string $value (optional, string) Comma-seperated list of fields you want to include in the response.
     * @return Google_ComputeEngine_Instances_AttachDisk_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Instance input for this AttachDisk Choreo.
     *
     * @param string $value (required, string) The name of the instance to attach a disk resource to.
     * @return Google_ComputeEngine_Instances_AttachDisk_Inputs For method chaining.
     */
    public function setInstance($value)
    {
        return $this->set('Instance', $value);
    }

    /**
     * Set the value for the Mode input for this AttachDisk Choreo.
     *
     * @param string $value (conditional, string) The mode in which to attach the disk. Valid values are: READ_WRITE or READ_ONLY.
     * @return Google_ComputeEngine_Instances_AttachDisk_Inputs For method chaining.
     */
    public function setMode($value)
    {
        return $this->set('Mode', $value);
    }

    /**
     * Set the value for the Project input for this AttachDisk Choreo.
     *
     * @param string $value (required, string) The ID of a Google Compute project.
     * @return Google_ComputeEngine_Instances_AttachDisk_Inputs For method chaining.
     */
    public function setProject($value)
    {
        return $this->set('Project', $value);
    }

    /**
     * Set the value for the RefreshToken input for this AttachDisk Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Instances_AttachDisk_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }

    /**
     * Set the value for the Source input for this AttachDisk Choreo.
     *
     * @param string $value (conditional, string) The URL to the Disk resource.
     * @return Google_ComputeEngine_Instances_AttachDisk_Inputs For method chaining.
     */
    public function setSource($value)
    {
        return $this->set('Source', $value);
    }

    /**
     * Set the value for the Type input for this AttachDisk Choreo.
     *
     * @param string $value (conditional, string) The type of disk. Valid values are: SCRATCH or PERSISTENT. Persistent disks must already exist before you can attach them.
     * @return Google_ComputeEngine_Instances_AttachDisk_Inputs For method chaining.
     */
    public function setType($value)
    {
        return $this->set('Type', $value);
    }

    /**
     * Set the value for the Zone input for this AttachDisk Choreo.
     *
     * @param string $value (required, string) The name of the zone associated with this request.
     * @return Google_ComputeEngine_Instances_AttachDisk_Inputs For method chaining.
     */
    public function setZone($value)
    {
        return $this->set('Zone', $value);
    }
}


/**
 * Execution object for the AttachDisk Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Instances_AttachDisk_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the AttachDisk Choreo.
     *
     * @param Temboo_Session $session The session that owns this AttachDisk execution.
     * @param Google_ComputeEngine_Instances_AttachDisk $choreo The choreography object for this execution.
     * @param Google_ComputeEngine_Instances_AttachDisk_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Instances_AttachDisk_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Instances_AttachDisk_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_ComputeEngine_Instances_AttachDisk $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this AttachDisk execution.
     *
     * @return Google_ComputeEngine_Instances_AttachDisk_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this AttachDisk execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_ComputeEngine_Instances_AttachDisk_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_ComputeEngine_Instances_AttachDisk_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the AttachDisk Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Instances_AttachDisk_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the AttachDisk Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_ComputeEngine_Instances_AttachDisk_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this AttachDisk execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this AttachDisk execution.
     *
     * @return string (json) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Deletes an access configuation from an instance's network interface.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Instances_DeleteAccessConfig extends Temboo_Choreography
{
    /**
     * Deletes an access configuation from an instance's network interface.
     *
     * @param Temboo_Session $session The session that owns this DeleteAccessConfig Choreo.
     * @return Google_ComputeEngine_Instances_DeleteAccessConfig New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/ComputeEngine/Instances/DeleteAccessConfig/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this DeleteAccessConfig Choreo.
     *
     * @param Google_ComputeEngine_Instances_DeleteAccessConfig_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Instances_DeleteAccessConfig_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Instances_DeleteAccessConfig_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_ComputeEngine_Instances_DeleteAccessConfig_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this DeleteAccessConfig Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Instances_DeleteAccessConfig_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_ComputeEngine_Instances_DeleteAccessConfig_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the DeleteAccessConfig Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Instances_DeleteAccessConfig_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the DeleteAccessConfig Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Instances_DeleteAccessConfig_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this DeleteAccessConfig input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_ComputeEngine_Instances_DeleteAccessConfig_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_ComputeEngine_Instances_DeleteAccessConfig_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessConfig input for this DeleteAccessConfig Choreo.
     *
     * @param string $value (required, string) The name of the access configuration to delete.
     * @return Google_ComputeEngine_Instances_DeleteAccessConfig_Inputs For method chaining.
     */
    public function setAccessConfig($value)
    {
        return $this->set('AccessConfig', $value);
    }

    /**
     * Set the value for the AccessToken input for this DeleteAccessConfig Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Google_ComputeEngine_Instances_DeleteAccessConfig_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this DeleteAccessConfig Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Instances_DeleteAccessConfig_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this DeleteAccessConfig Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Instances_DeleteAccessConfig_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Fields input for this DeleteAccessConfig Choreo.
     *
     * @param string $value (optional, string) Comma-seperated list of fields you want to include in the response.
     * @return Google_ComputeEngine_Instances_DeleteAccessConfig_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Instance input for this DeleteAccessConfig Choreo.
     *
     * @param string $value (required, string) The name of the instance that this access configuration applies to.
     * @return Google_ComputeEngine_Instances_DeleteAccessConfig_Inputs For method chaining.
     */
    public function setInstance($value)
    {
        return $this->set('Instance', $value);
    }

    /**
     * Set the value for the NetworkInterface input for this DeleteAccessConfig Choreo.
     *
     * @param string $value (required, string) The name of the network interface associated with the access config that is being deleted.
     * @return Google_ComputeEngine_Instances_DeleteAccessConfig_Inputs For method chaining.
     */
    public function setNetworkInterface($value)
    {
        return $this->set('NetworkInterface', $value);
    }

    /**
     * Set the value for the Project input for this DeleteAccessConfig Choreo.
     *
     * @param string $value (required, string) The ID of a Google Compute project.
     * @return Google_ComputeEngine_Instances_DeleteAccessConfig_Inputs For method chaining.
     */
    public function setProject($value)
    {
        return $this->set('Project', $value);
    }

    /**
     * Set the value for the RefreshToken input for this DeleteAccessConfig Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Instances_DeleteAccessConfig_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }

    /**
     * Set the value for the Zone input for this DeleteAccessConfig Choreo.
     *
     * @param string $value (required, string) The name of the zone associated with this request.
     * @return Google_ComputeEngine_Instances_DeleteAccessConfig_Inputs For method chaining.
     */
    public function setZone($value)
    {
        return $this->set('Zone', $value);
    }
}


/**
 * Execution object for the DeleteAccessConfig Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Instances_DeleteAccessConfig_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the DeleteAccessConfig Choreo.
     *
     * @param Temboo_Session $session The session that owns this DeleteAccessConfig execution.
     * @param Google_ComputeEngine_Instances_DeleteAccessConfig $choreo The choreography object for this execution.
     * @param Google_ComputeEngine_Instances_DeleteAccessConfig_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Instances_DeleteAccessConfig_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Instances_DeleteAccessConfig_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_ComputeEngine_Instances_DeleteAccessConfig $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this DeleteAccessConfig execution.
     *
     * @return Google_ComputeEngine_Instances_DeleteAccessConfig_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this DeleteAccessConfig execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_ComputeEngine_Instances_DeleteAccessConfig_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_ComputeEngine_Instances_DeleteAccessConfig_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the DeleteAccessConfig Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Instances_DeleteAccessConfig_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the DeleteAccessConfig Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_ComputeEngine_Instances_DeleteAccessConfig_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this DeleteAccessConfig execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this DeleteAccessConfig execution.
     *
     * @return string (json) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Deletes the specified Instance resource.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Instances_DeleteInstance extends Temboo_Choreography
{
    /**
     * Deletes the specified Instance resource.
     *
     * @param Temboo_Session $session The session that owns this DeleteInstance Choreo.
     * @return Google_ComputeEngine_Instances_DeleteInstance New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/ComputeEngine/Instances/DeleteInstance/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this DeleteInstance Choreo.
     *
     * @param Google_ComputeEngine_Instances_DeleteInstance_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Instances_DeleteInstance_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Instances_DeleteInstance_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_ComputeEngine_Instances_DeleteInstance_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this DeleteInstance Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Instances_DeleteInstance_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_ComputeEngine_Instances_DeleteInstance_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the DeleteInstance Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Instances_DeleteInstance_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the DeleteInstance Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Instances_DeleteInstance_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this DeleteInstance input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_ComputeEngine_Instances_DeleteInstance_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_ComputeEngine_Instances_DeleteInstance_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this DeleteInstance Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Google_ComputeEngine_Instances_DeleteInstance_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this DeleteInstance Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Instances_DeleteInstance_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this DeleteInstance Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Instances_DeleteInstance_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Fields input for this DeleteInstance Choreo.
     *
     * @param string $value (optional, string) Comma-seperated list of fields you want to include in the response.
     * @return Google_ComputeEngine_Instances_DeleteInstance_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Instance input for this DeleteInstance Choreo.
     *
     * @param string $value (required, string) The name of the instance to delete.
     * @return Google_ComputeEngine_Instances_DeleteInstance_Inputs For method chaining.
     */
    public function setInstance($value)
    {
        return $this->set('Instance', $value);
    }

    /**
     * Set the value for the Project input for this DeleteInstance Choreo.
     *
     * @param string $value (required, string) The ID of a Google Compute project.
     * @return Google_ComputeEngine_Instances_DeleteInstance_Inputs For method chaining.
     */
    public function setProject($value)
    {
        return $this->set('Project', $value);
    }

    /**
     * Set the value for the RefreshToken input for this DeleteInstance Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Instances_DeleteInstance_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }

    /**
     * Set the value for the Zone input for this DeleteInstance Choreo.
     *
     * @param string $value (required, string) The name of the zone associated with this request. 
     * @return Google_ComputeEngine_Instances_DeleteInstance_Inputs For method chaining.
     */
    public function setZone($value)
    {
        return $this->set('Zone', $value);
    }
}


/**
 * Execution object for the DeleteInstance Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Instances_DeleteInstance_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the DeleteInstance Choreo.
     *
     * @param Temboo_Session $session The session that owns this DeleteInstance execution.
     * @param Google_ComputeEngine_Instances_DeleteInstance $choreo The choreography object for this execution.
     * @param Google_ComputeEngine_Instances_DeleteInstance_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Instances_DeleteInstance_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Instances_DeleteInstance_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_ComputeEngine_Instances_DeleteInstance $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this DeleteInstance execution.
     *
     * @return Google_ComputeEngine_Instances_DeleteInstance_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this DeleteInstance execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_ComputeEngine_Instances_DeleteInstance_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_ComputeEngine_Instances_DeleteInstance_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the DeleteInstance Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Instances_DeleteInstance_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the DeleteInstance Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_ComputeEngine_Instances_DeleteInstance_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this DeleteInstance execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this DeleteInstance execution.
     *
     * @return string (json) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Detaches a Disk resource from an instance.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Instances_DetachDisk extends Temboo_Choreography
{
    /**
     * Detaches a Disk resource from an instance.
     *
     * @param Temboo_Session $session The session that owns this DetachDisk Choreo.
     * @return Google_ComputeEngine_Instances_DetachDisk New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/ComputeEngine/Instances/DetachDisk/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this DetachDisk Choreo.
     *
     * @param Google_ComputeEngine_Instances_DetachDisk_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Instances_DetachDisk_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Instances_DetachDisk_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_ComputeEngine_Instances_DetachDisk_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this DetachDisk Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Instances_DetachDisk_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_ComputeEngine_Instances_DetachDisk_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the DetachDisk Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Instances_DetachDisk_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the DetachDisk Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Instances_DetachDisk_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this DetachDisk input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_ComputeEngine_Instances_DetachDisk_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_ComputeEngine_Instances_DetachDisk_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this DetachDisk Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Google_ComputeEngine_Instances_DetachDisk_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this DetachDisk Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Instances_DetachDisk_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this DetachDisk Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Instances_DetachDisk_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the DeviceName input for this DetachDisk Choreo.
     *
     * @param string $value (required, string) The name of the disk to detach.
     * @return Google_ComputeEngine_Instances_DetachDisk_Inputs For method chaining.
     */
    public function setDeviceName($value)
    {
        return $this->set('DeviceName', $value);
    }

    /**
     * Set the value for the Fields input for this DetachDisk Choreo.
     *
     * @param string $value (optional, string) Comma-seperated list of fields you want to include in the response.
     * @return Google_ComputeEngine_Instances_DetachDisk_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Instance input for this DetachDisk Choreo.
     *
     * @param string $value (required, string) The name of the instance that is associated with the disk to detach.
     * @return Google_ComputeEngine_Instances_DetachDisk_Inputs For method chaining.
     */
    public function setInstance($value)
    {
        return $this->set('Instance', $value);
    }

    /**
     * Set the value for the Project input for this DetachDisk Choreo.
     *
     * @param string $value (required, string) The ID of a Google Compute project.
     * @return Google_ComputeEngine_Instances_DetachDisk_Inputs For method chaining.
     */
    public function setProject($value)
    {
        return $this->set('Project', $value);
    }

    /**
     * Set the value for the RefreshToken input for this DetachDisk Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Instances_DetachDisk_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }

    /**
     * Set the value for the Zone input for this DetachDisk Choreo.
     *
     * @param string $value (required, string) The name of the zone associated with this request.
     * @return Google_ComputeEngine_Instances_DetachDisk_Inputs For method chaining.
     */
    public function setZone($value)
    {
        return $this->set('Zone', $value);
    }
}


/**
 * Execution object for the DetachDisk Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Instances_DetachDisk_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the DetachDisk Choreo.
     *
     * @param Temboo_Session $session The session that owns this DetachDisk execution.
     * @param Google_ComputeEngine_Instances_DetachDisk $choreo The choreography object for this execution.
     * @param Google_ComputeEngine_Instances_DetachDisk_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Instances_DetachDisk_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Instances_DetachDisk_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_ComputeEngine_Instances_DetachDisk $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this DetachDisk execution.
     *
     * @return Google_ComputeEngine_Instances_DetachDisk_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this DetachDisk execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_ComputeEngine_Instances_DetachDisk_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_ComputeEngine_Instances_DetachDisk_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the DetachDisk Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Instances_DetachDisk_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the DetachDisk Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_ComputeEngine_Instances_DetachDisk_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this DetachDisk execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this DetachDisk execution.
     *
     * @return string (json) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Retrieves information about the specified Instance.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Instances_GetInstance extends Temboo_Choreography
{
    /**
     * Retrieves information about the specified Instance.
     *
     * @param Temboo_Session $session The session that owns this GetInstance Choreo.
     * @return Google_ComputeEngine_Instances_GetInstance New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/ComputeEngine/Instances/GetInstance/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this GetInstance Choreo.
     *
     * @param Google_ComputeEngine_Instances_GetInstance_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Instances_GetInstance_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Instances_GetInstance_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_ComputeEngine_Instances_GetInstance_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this GetInstance Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Instances_GetInstance_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_ComputeEngine_Instances_GetInstance_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the GetInstance Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Instances_GetInstance_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the GetInstance Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Instances_GetInstance_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this GetInstance input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_ComputeEngine_Instances_GetInstance_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_ComputeEngine_Instances_GetInstance_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this GetInstance Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Google_ComputeEngine_Instances_GetInstance_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this GetInstance Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Instances_GetInstance_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this GetInstance Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Instances_GetInstance_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Fields input for this GetInstance Choreo.
     *
     * @param string $value (optional, string) Comma-seperated list of fields you want to include in the response.
     * @return Google_ComputeEngine_Instances_GetInstance_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Instance input for this GetInstance Choreo.
     *
     * @param string $value (required, string) The name of the instance to retrieve.
     * @return Google_ComputeEngine_Instances_GetInstance_Inputs For method chaining.
     */
    public function setInstance($value)
    {
        return $this->set('Instance', $value);
    }

    /**
     * Set the value for the Project input for this GetInstance Choreo.
     *
     * @param string $value (required, string) The ID of a Google Compute project.
     * @return Google_ComputeEngine_Instances_GetInstance_Inputs For method chaining.
     */
    public function setProject($value)
    {
        return $this->set('Project', $value);
    }

    /**
     * Set the value for the RefreshToken input for this GetInstance Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Instances_GetInstance_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }

    /**
     * Set the value for the Zone input for this GetInstance Choreo.
     *
     * @param string $value (required, string) The name of the zone associated with this request.
     * @return Google_ComputeEngine_Instances_GetInstance_Inputs For method chaining.
     */
    public function setZone($value)
    {
        return $this->set('Zone', $value);
    }
}


/**
 * Execution object for the GetInstance Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Instances_GetInstance_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the GetInstance Choreo.
     *
     * @param Temboo_Session $session The session that owns this GetInstance execution.
     * @param Google_ComputeEngine_Instances_GetInstance $choreo The choreography object for this execution.
     * @param Google_ComputeEngine_Instances_GetInstance_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Instances_GetInstance_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Instances_GetInstance_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_ComputeEngine_Instances_GetInstance $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this GetInstance execution.
     *
     * @return Google_ComputeEngine_Instances_GetInstance_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this GetInstance execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_ComputeEngine_Instances_GetInstance_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_ComputeEngine_Instances_GetInstance_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the GetInstance Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Instances_GetInstance_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the GetInstance Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_ComputeEngine_Instances_GetInstance_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this GetInstance execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this GetInstance execution.
     *
     * @return string (json) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Returns the specified instance's serial port output.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Instances_GetSerialPortOutput extends Temboo_Choreography
{
    /**
     * Returns the specified instance's serial port output.
     *
     * @param Temboo_Session $session The session that owns this GetSerialPortOutput Choreo.
     * @return Google_ComputeEngine_Instances_GetSerialPortOutput New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/ComputeEngine/Instances/GetSerialPortOutput/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this GetSerialPortOutput Choreo.
     *
     * @param Google_ComputeEngine_Instances_GetSerialPortOutput_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Instances_GetSerialPortOutput_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Instances_GetSerialPortOutput_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_ComputeEngine_Instances_GetSerialPortOutput_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this GetSerialPortOutput Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Instances_GetSerialPortOutput_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_ComputeEngine_Instances_GetSerialPortOutput_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the GetSerialPortOutput Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Instances_GetSerialPortOutput_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the GetSerialPortOutput Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Instances_GetSerialPortOutput_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this GetSerialPortOutput input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_ComputeEngine_Instances_GetSerialPortOutput_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_ComputeEngine_Instances_GetSerialPortOutput_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this GetSerialPortOutput Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Google_ComputeEngine_Instances_GetSerialPortOutput_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this GetSerialPortOutput Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Instances_GetSerialPortOutput_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this GetSerialPortOutput Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Instances_GetSerialPortOutput_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Fields input for this GetSerialPortOutput Choreo.
     *
     * @param string $value (optional, string) Comma-seperated list of fields you want to include in the response.
     * @return Google_ComputeEngine_Instances_GetSerialPortOutput_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Instance input for this GetSerialPortOutput Choreo.
     *
     * @param string $value (required, string) The name of the instance associated with the serial port output to retrieve.
     * @return Google_ComputeEngine_Instances_GetSerialPortOutput_Inputs For method chaining.
     */
    public function setInstance($value)
    {
        return $this->set('Instance', $value);
    }

    /**
     * Set the value for the Project input for this GetSerialPortOutput Choreo.
     *
     * @param string $value (required, string) The ID of a Google Compute project.
     * @return Google_ComputeEngine_Instances_GetSerialPortOutput_Inputs For method chaining.
     */
    public function setProject($value)
    {
        return $this->set('Project', $value);
    }

    /**
     * Set the value for the RefreshToken input for this GetSerialPortOutput Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Instances_GetSerialPortOutput_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }

    /**
     * Set the value for the Zone input for this GetSerialPortOutput Choreo.
     *
     * @param string $value (required, string) The name of the zone associated with this request.
     * @return Google_ComputeEngine_Instances_GetSerialPortOutput_Inputs For method chaining.
     */
    public function setZone($value)
    {
        return $this->set('Zone', $value);
    }
}


/**
 * Execution object for the GetSerialPortOutput Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Instances_GetSerialPortOutput_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the GetSerialPortOutput Choreo.
     *
     * @param Temboo_Session $session The session that owns this GetSerialPortOutput execution.
     * @param Google_ComputeEngine_Instances_GetSerialPortOutput $choreo The choreography object for this execution.
     * @param Google_ComputeEngine_Instances_GetSerialPortOutput_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Instances_GetSerialPortOutput_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Instances_GetSerialPortOutput_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_ComputeEngine_Instances_GetSerialPortOutput $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this GetSerialPortOutput execution.
     *
     * @return Google_ComputeEngine_Instances_GetSerialPortOutput_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this GetSerialPortOutput execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_ComputeEngine_Instances_GetSerialPortOutput_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_ComputeEngine_Instances_GetSerialPortOutput_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the GetSerialPortOutput Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Instances_GetSerialPortOutput_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the GetSerialPortOutput Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_ComputeEngine_Instances_GetSerialPortOutput_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this GetSerialPortOutput execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this GetSerialPortOutput execution.
     *
     * @return string (json) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Creates an Instance resource in the specified project.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Instances_InsertInstance extends Temboo_Choreography
{
    /**
     * Creates an Instance resource in the specified project.
     *
     * @param Temboo_Session $session The session that owns this InsertInstance Choreo.
     * @return Google_ComputeEngine_Instances_InsertInstance New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/ComputeEngine/Instances/InsertInstance/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this InsertInstance Choreo.
     *
     * @param Google_ComputeEngine_Instances_InsertInstance_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Instances_InsertInstance_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Instances_InsertInstance_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_ComputeEngine_Instances_InsertInstance_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this InsertInstance Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Instances_InsertInstance_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_ComputeEngine_Instances_InsertInstance_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the InsertInstance Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Instances_InsertInstance_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the InsertInstance Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Instances_InsertInstance_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this InsertInstance input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_ComputeEngine_Instances_InsertInstance_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_ComputeEngine_Instances_InsertInstance_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the InstanceResource input for this InsertInstance Choreo.
     *
     * @param string $value (optional, json) A JSON string containing the instance resource properties to set. This an be used as an alternative to individual inputs representing instance properties.
     * @return Google_ComputeEngine_Instances_InsertInstance_Inputs For method chaining.
     */
    public function setInstanceResource($value)
    {
        return $this->set('InstanceResource', $value);
    }

    /**
     * Set the value for the AccessToken input for this InsertInstance Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Google_ComputeEngine_Instances_InsertInstance_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this InsertInstance Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Instances_InsertInstance_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this InsertInstance Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Instances_InsertInstance_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Description input for this InsertInstance Choreo.
     *
     * @param string $value (optional, string) The description of the instance.
     * @return Google_ComputeEngine_Instances_InsertInstance_Inputs For method chaining.
     */
    public function setDescription($value)
    {
        return $this->set('Description', $value);
    }

    /**
     * Set the value for the Disks input for this InsertInstance Choreo.
     *
     * @param string $value (conditional, json) An array of persistent disks. This array contains the following properties: source, type, and boot.
     * @return Google_ComputeEngine_Instances_InsertInstance_Inputs For method chaining.
     */
    public function setDisks($value)
    {
        return $this->set('Disks', $value);
    }

    /**
     * Set the value for the MachineType input for this InsertInstance Choreo.
     *
     * @param string $value (conditional, string) The fully-qualified URL of the machine type resource to use for this instance.
     * @return Google_ComputeEngine_Instances_InsertInstance_Inputs For method chaining.
     */
    public function setMachineType($value)
    {
        return $this->set('MachineType', $value);
    }

    /**
     * Set the value for the Name input for this InsertInstance Choreo.
     *
     * @param string $value (conditional, string) The name of the instance being created.
     * @return Google_ComputeEngine_Instances_InsertInstance_Inputs For method chaining.
     */
    public function setName($value)
    {
        return $this->set('Name', $value);
    }

    /**
     * Set the value for the NetworkInterfaces input for this InsertInstance Choreo.
     *
     * @param string $value (conditional, json) An array of network configurations for this instance. This array contains the following properties: network, accessConfigs[], accessConfigs[].name, and accessConfigs[].type.
     * @return Google_ComputeEngine_Instances_InsertInstance_Inputs For method chaining.
     */
    public function setNetworkInterfaces($value)
    {
        return $this->set('NetworkInterfaces', $value);
    }

    /**
     * Set the value for the Project input for this InsertInstance Choreo.
     *
     * @param string $value (required, string) The ID of a Google Compute project.
     * @return Google_ComputeEngine_Instances_InsertInstance_Inputs For method chaining.
     */
    public function setProject($value)
    {
        return $this->set('Project', $value);
    }

    /**
     * Set the value for the RefreshToken input for this InsertInstance Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Instances_InsertInstance_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }

    /**
     * Set the value for the Zone input for this InsertInstance Choreo.
     *
     * @param string $value (required, string) The name of the zone associated with this request.
     * @return Google_ComputeEngine_Instances_InsertInstance_Inputs For method chaining.
     */
    public function setZone($value)
    {
        return $this->set('Zone', $value);
    }
}


/**
 * Execution object for the InsertInstance Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Instances_InsertInstance_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the InsertInstance Choreo.
     *
     * @param Temboo_Session $session The session that owns this InsertInstance execution.
     * @param Google_ComputeEngine_Instances_InsertInstance $choreo The choreography object for this execution.
     * @param Google_ComputeEngine_Instances_InsertInstance_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Instances_InsertInstance_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Instances_InsertInstance_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_ComputeEngine_Instances_InsertInstance $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this InsertInstance execution.
     *
     * @return Google_ComputeEngine_Instances_InsertInstance_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this InsertInstance execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_ComputeEngine_Instances_InsertInstance_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_ComputeEngine_Instances_InsertInstance_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the InsertInstance Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Instances_InsertInstance_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the InsertInstance Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_ComputeEngine_Instances_InsertInstance_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this InsertInstance execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this InsertInstance execution.
     *
     * @return string (json) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Retrieves the list of Instance resources contained within the specified Zone.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Instances_ListInstances extends Temboo_Choreography
{
    /**
     * Retrieves the list of Instance resources contained within the specified Zone.
     *
     * @param Temboo_Session $session The session that owns this ListInstances Choreo.
     * @return Google_ComputeEngine_Instances_ListInstances New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/ComputeEngine/Instances/ListInstances/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this ListInstances Choreo.
     *
     * @param Google_ComputeEngine_Instances_ListInstances_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Instances_ListInstances_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Instances_ListInstances_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_ComputeEngine_Instances_ListInstances_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this ListInstances Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Instances_ListInstances_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_ComputeEngine_Instances_ListInstances_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the ListInstances Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Instances_ListInstances_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the ListInstances Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Instances_ListInstances_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this ListInstances input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_ComputeEngine_Instances_ListInstances_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_ComputeEngine_Instances_ListInstances_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this ListInstances Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Google_ComputeEngine_Instances_ListInstances_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this ListInstances Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Instances_ListInstances_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this ListInstances Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Instances_ListInstances_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Fields input for this ListInstances Choreo.
     *
     * @param string $value (optional, string) Comma-seperated list of fields you want to include in the response.
     * @return Google_ComputeEngine_Instances_ListInstances_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Filter input for this ListInstances Choreo.
     *
     * @param string $value (optional, string) A filter expression for narrowing results in the form: {field_name} {comparison_string} {literal_string} (e.g. name eq testinstance). Comparison strings can be eq (equals) or ne (not equals).
     * @return Google_ComputeEngine_Instances_ListInstances_Inputs For method chaining.
     */
    public function setFilter($value)
    {
        return $this->set('Filter', $value);
    }

    /**
     * Set the value for the MaxResults input for this ListInstances Choreo.
     *
     * @param int $value (optional, integer) The maximum number of results to return.
     * @return Google_ComputeEngine_Instances_ListInstances_Inputs For method chaining.
     */
    public function setMaxResults($value)
    {
        return $this->set('MaxResults', $value);
    }

    /**
     * Set the value for the PageToken input for this ListInstances Choreo.
     *
     * @param string $value (optional, string) The "nextPageToken" found in the response which is used to page through results.
     * @return Google_ComputeEngine_Instances_ListInstances_Inputs For method chaining.
     */
    public function setPageToken($value)
    {
        return $this->set('PageToken', $value);
    }

    /**
     * Set the value for the Project input for this ListInstances Choreo.
     *
     * @param string $value (required, string) The ID of a Google Compute project.
     * @return Google_ComputeEngine_Instances_ListInstances_Inputs For method chaining.
     */
    public function setProject($value)
    {
        return $this->set('Project', $value);
    }

    /**
     * Set the value for the RefreshToken input for this ListInstances Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Instances_ListInstances_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }

    /**
     * Set the value for the Zone input for this ListInstances Choreo.
     *
     * @param string $value (required, string) The name of the zone associated with this request.
     * @return Google_ComputeEngine_Instances_ListInstances_Inputs For method chaining.
     */
    public function setZone($value)
    {
        return $this->set('Zone', $value);
    }
}


/**
 * Execution object for the ListInstances Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Instances_ListInstances_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the ListInstances Choreo.
     *
     * @param Temboo_Session $session The session that owns this ListInstances execution.
     * @param Google_ComputeEngine_Instances_ListInstances $choreo The choreography object for this execution.
     * @param Google_ComputeEngine_Instances_ListInstances_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Instances_ListInstances_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Instances_ListInstances_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_ComputeEngine_Instances_ListInstances $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this ListInstances execution.
     *
     * @return Google_ComputeEngine_Instances_ListInstances_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this ListInstances execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_ComputeEngine_Instances_ListInstances_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_ComputeEngine_Instances_ListInstances_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the ListInstances Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Instances_ListInstances_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the ListInstances Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_ComputeEngine_Instances_ListInstances_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this ListInstances execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this ListInstances execution.
     *
     * @return string (json) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Sets the metadata for the specified instance.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Instances_SetMetadata extends Temboo_Choreography
{
    /**
     * Sets the metadata for the specified instance.
     *
     * @param Temboo_Session $session The session that owns this SetMetadata Choreo.
     * @return Google_ComputeEngine_Instances_SetMetadata New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/ComputeEngine/Instances/SetMetadata/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this SetMetadata Choreo.
     *
     * @param Google_ComputeEngine_Instances_SetMetadata_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Instances_SetMetadata_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Instances_SetMetadata_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_ComputeEngine_Instances_SetMetadata_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this SetMetadata Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Instances_SetMetadata_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_ComputeEngine_Instances_SetMetadata_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the SetMetadata Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Instances_SetMetadata_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the SetMetadata Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Instances_SetMetadata_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this SetMetadata input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_ComputeEngine_Instances_SetMetadata_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_ComputeEngine_Instances_SetMetadata_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this SetMetadata Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Google_ComputeEngine_Instances_SetMetadata_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this SetMetadata Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Instances_SetMetadata_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this SetMetadata Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Instances_SetMetadata_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Fingerprint input for this SetMetadata Choreo.
     *
     * @param string $value (required, string) The current fingerprint of this resource. You must provide the current version of the fingerprint to successfully update any metadata.
     * @return Google_ComputeEngine_Instances_SetMetadata_Inputs For method chaining.
     */
    public function setFingerprint($value)
    {
        return $this->set('Fingerprint', $value);
    }

    /**
     * Set the value for the Instance input for this SetMetadata Choreo.
     *
     * @param string $value (required, string) The name of the instance that you're setting metadata for.
     * @return Google_ComputeEngine_Instances_SetMetadata_Inputs For method chaining.
     */
    public function setInstance($value)
    {
        return $this->set('Instance', $value);
    }

    /**
     * Set the value for the Items input for this SetMetadata Choreo.
     *
     * @param string $value (required, json) An array of key/value pairs. The total size of the keys and values should not exceed 512 KB.
     * @return Google_ComputeEngine_Instances_SetMetadata_Inputs For method chaining.
     */
    public function setItems($value)
    {
        return $this->set('Items', $value);
    }

    /**
     * Set the value for the Project input for this SetMetadata Choreo.
     *
     * @param string $value (required, string) The ID of a Google Compute project.
     * @return Google_ComputeEngine_Instances_SetMetadata_Inputs For method chaining.
     */
    public function setProject($value)
    {
        return $this->set('Project', $value);
    }

    /**
     * Set the value for the RefreshToken input for this SetMetadata Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Instances_SetMetadata_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }

    /**
     * Set the value for the Zone input for this SetMetadata Choreo.
     *
     * @param string $value (required, string) The name of the zone associated with this request.
     * @return Google_ComputeEngine_Instances_SetMetadata_Inputs For method chaining.
     */
    public function setZone($value)
    {
        return $this->set('Zone', $value);
    }
}


/**
 * Execution object for the SetMetadata Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Instances_SetMetadata_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the SetMetadata Choreo.
     *
     * @param Temboo_Session $session The session that owns this SetMetadata execution.
     * @param Google_ComputeEngine_Instances_SetMetadata $choreo The choreography object for this execution.
     * @param Google_ComputeEngine_Instances_SetMetadata_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Instances_SetMetadata_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Instances_SetMetadata_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_ComputeEngine_Instances_SetMetadata $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this SetMetadata execution.
     *
     * @return Google_ComputeEngine_Instances_SetMetadata_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this SetMetadata execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_ComputeEngine_Instances_SetMetadata_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_ComputeEngine_Instances_SetMetadata_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the SetMetadata Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Instances_SetMetadata_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the SetMetadata Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_ComputeEngine_Instances_SetMetadata_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this SetMetadata execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this SetMetadata execution.
     *
     * @return string (json) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Sets tags for the specified instance.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Instances_SetTags extends Temboo_Choreography
{
    /**
     * Sets tags for the specified instance.
     *
     * @param Temboo_Session $session The session that owns this SetTags Choreo.
     * @return Google_ComputeEngine_Instances_SetTags New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/ComputeEngine/Instances/SetTags/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this SetTags Choreo.
     *
     * @param Google_ComputeEngine_Instances_SetTags_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Instances_SetTags_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Instances_SetTags_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_ComputeEngine_Instances_SetTags_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this SetTags Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Instances_SetTags_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_ComputeEngine_Instances_SetTags_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the SetTags Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Instances_SetTags_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the SetTags Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Instances_SetTags_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this SetTags input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_ComputeEngine_Instances_SetTags_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_ComputeEngine_Instances_SetTags_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this SetTags Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Google_ComputeEngine_Instances_SetTags_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this SetTags Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Instances_SetTags_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this SetTags Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Instances_SetTags_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Fingerprint input for this SetTags Choreo.
     *
     * @param string $value (required, string) The current fingerprint of this resource. You must provide the current version of the fingerprint to successfully update tags.
     * @return Google_ComputeEngine_Instances_SetTags_Inputs For method chaining.
     */
    public function setFingerprint($value)
    {
        return $this->set('Fingerprint', $value);
    }

    /**
     * Set the value for the Instance input for this SetTags Choreo.
     *
     * @param string $value (required, string) The name of the instance that you're setting tags for.
     * @return Google_ComputeEngine_Instances_SetTags_Inputs For method chaining.
     */
    public function setInstance($value)
    {
        return $this->set('Instance', $value);
    }

    /**
     * Set the value for the Items input for this SetTags Choreo.
     *
     * @param string $value (required, json) An array of tags. The max length of a tag is 63 characters.
     * @return Google_ComputeEngine_Instances_SetTags_Inputs For method chaining.
     */
    public function setItems($value)
    {
        return $this->set('Items', $value);
    }

    /**
     * Set the value for the Project input for this SetTags Choreo.
     *
     * @param string $value (required, string) The ID of a Google Compute project.
     * @return Google_ComputeEngine_Instances_SetTags_Inputs For method chaining.
     */
    public function setProject($value)
    {
        return $this->set('Project', $value);
    }

    /**
     * Set the value for the RefreshToken input for this SetTags Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Instances_SetTags_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }

    /**
     * Set the value for the Zone input for this SetTags Choreo.
     *
     * @param string $value (required, string) The name of the zone associated with this request.
     * @return Google_ComputeEngine_Instances_SetTags_Inputs For method chaining.
     */
    public function setZone($value)
    {
        return $this->set('Zone', $value);
    }
}


/**
 * Execution object for the SetTags Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Instances_SetTags_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the SetTags Choreo.
     *
     * @param Temboo_Session $session The session that owns this SetTags execution.
     * @param Google_ComputeEngine_Instances_SetTags $choreo The choreography object for this execution.
     * @param Google_ComputeEngine_Instances_SetTags_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Instances_SetTags_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Instances_SetTags_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_ComputeEngine_Instances_SetTags $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this SetTags execution.
     *
     * @return Google_ComputeEngine_Instances_SetTags_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this SetTags execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_ComputeEngine_Instances_SetTags_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_ComputeEngine_Instances_SetTags_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the SetTags Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Instances_SetTags_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the SetTags Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_ComputeEngine_Instances_SetTags_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this SetTags execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this SetTags execution.
     *
     * @return string (json) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Retrieves a list of Machine Type resources across all available zones.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_MachineTypes_AggregatedList extends Temboo_Choreography
{
    /**
     * Retrieves a list of Machine Type resources across all available zones.
     *
     * @param Temboo_Session $session The session that owns this AggregatedList Choreo.
     * @return Google_ComputeEngine_MachineTypes_AggregatedList New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/ComputeEngine/MachineTypes/AggregatedList/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this AggregatedList Choreo.
     *
     * @param Google_ComputeEngine_MachineTypes_AggregatedList_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_MachineTypes_AggregatedList_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_MachineTypes_AggregatedList_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_ComputeEngine_MachineTypes_AggregatedList_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this AggregatedList Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_MachineTypes_AggregatedList_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_ComputeEngine_MachineTypes_AggregatedList_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the AggregatedList Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_MachineTypes_AggregatedList_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the AggregatedList Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_MachineTypes_AggregatedList_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this AggregatedList input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_ComputeEngine_MachineTypes_AggregatedList_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_ComputeEngine_MachineTypes_AggregatedList_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this AggregatedList Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Google_ComputeEngine_MachineTypes_AggregatedList_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this AggregatedList Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_MachineTypes_AggregatedList_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this AggregatedList Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_MachineTypes_AggregatedList_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Fields input for this AggregatedList Choreo.
     *
     * @param string $value (optional, string) Comma-seperated list of fields you want to include in the response.
     * @return Google_ComputeEngine_MachineTypes_AggregatedList_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Filter input for this AggregatedList Choreo.
     *
     * @param string $value (optional, string) A filter expression for narrowing results in the form: {field_name} {comparison_string} {literal_string} (e.g. name eq eq f1-micro). Comparison strings can be eq (equals) or ne (not equals).
     * @return Google_ComputeEngine_MachineTypes_AggregatedList_Inputs For method chaining.
     */
    public function setFilter($value)
    {
        return $this->set('Filter', $value);
    }

    /**
     * Set the value for the MaxResults input for this AggregatedList Choreo.
     *
     * @param int $value (optional, integer) The maximum number of results to return.
     * @return Google_ComputeEngine_MachineTypes_AggregatedList_Inputs For method chaining.
     */
    public function setMaxResults($value)
    {
        return $this->set('MaxResults', $value);
    }

    /**
     * Set the value for the PageToken input for this AggregatedList Choreo.
     *
     * @param string $value (optional, string) The "nextPageToken" found in the response which is used to page through results.
     * @return Google_ComputeEngine_MachineTypes_AggregatedList_Inputs For method chaining.
     */
    public function setPageToken($value)
    {
        return $this->set('PageToken', $value);
    }

    /**
     * Set the value for the Project input for this AggregatedList Choreo.
     *
     * @param string $value (required, string) The ID of a Google Compute project.
     * @return Google_ComputeEngine_MachineTypes_AggregatedList_Inputs For method chaining.
     */
    public function setProject($value)
    {
        return $this->set('Project', $value);
    }

    /**
     * Set the value for the RefreshToken input for this AggregatedList Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_MachineTypes_AggregatedList_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }
}


/**
 * Execution object for the AggregatedList Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_MachineTypes_AggregatedList_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the AggregatedList Choreo.
     *
     * @param Temboo_Session $session The session that owns this AggregatedList execution.
     * @param Google_ComputeEngine_MachineTypes_AggregatedList $choreo The choreography object for this execution.
     * @param Google_ComputeEngine_MachineTypes_AggregatedList_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_MachineTypes_AggregatedList_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_MachineTypes_AggregatedList_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_ComputeEngine_MachineTypes_AggregatedList $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this AggregatedList execution.
     *
     * @return Google_ComputeEngine_MachineTypes_AggregatedList_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this AggregatedList execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_ComputeEngine_MachineTypes_AggregatedList_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_ComputeEngine_MachineTypes_AggregatedList_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the AggregatedList Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_MachineTypes_AggregatedList_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the AggregatedList Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_ComputeEngine_MachineTypes_AggregatedList_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this AggregatedList execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this AggregatedList execution.
     *
     * @return string (json) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Retrieves information about the specified Machine Type.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_MachineTypes_GetMachineType extends Temboo_Choreography
{
    /**
     * Retrieves information about the specified Machine Type.
     *
     * @param Temboo_Session $session The session that owns this GetMachineType Choreo.
     * @return Google_ComputeEngine_MachineTypes_GetMachineType New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/ComputeEngine/MachineTypes/GetMachineType/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this GetMachineType Choreo.
     *
     * @param Google_ComputeEngine_MachineTypes_GetMachineType_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_MachineTypes_GetMachineType_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_MachineTypes_GetMachineType_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_ComputeEngine_MachineTypes_GetMachineType_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this GetMachineType Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_MachineTypes_GetMachineType_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_ComputeEngine_MachineTypes_GetMachineType_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the GetMachineType Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_MachineTypes_GetMachineType_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the GetMachineType Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_MachineTypes_GetMachineType_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this GetMachineType input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_ComputeEngine_MachineTypes_GetMachineType_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_ComputeEngine_MachineTypes_GetMachineType_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this GetMachineType Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Google_ComputeEngine_MachineTypes_GetMachineType_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this GetMachineType Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_MachineTypes_GetMachineType_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this GetMachineType Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_MachineTypes_GetMachineType_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Fields input for this GetMachineType Choreo.
     *
     * @param string $value (optional, string) Comma-seperated list of fields you want to include in the response.
     * @return Google_ComputeEngine_MachineTypes_GetMachineType_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the MachineType input for this GetMachineType Choreo.
     *
     * @param string $value (required, string) The name of the machine type to retrieve.
     * @return Google_ComputeEngine_MachineTypes_GetMachineType_Inputs For method chaining.
     */
    public function setMachineType($value)
    {
        return $this->set('MachineType', $value);
    }

    /**
     * Set the value for the Project input for this GetMachineType Choreo.
     *
     * @param string $value (required, string) The ID of a Google Compute project.
     * @return Google_ComputeEngine_MachineTypes_GetMachineType_Inputs For method chaining.
     */
    public function setProject($value)
    {
        return $this->set('Project', $value);
    }

    /**
     * Set the value for the RefreshToken input for this GetMachineType Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_MachineTypes_GetMachineType_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }

    /**
     * Set the value for the Zone input for this GetMachineType Choreo.
     *
     * @param string $value (required, string) The name of the zone that contains the machine type to retrieve.
     * @return Google_ComputeEngine_MachineTypes_GetMachineType_Inputs For method chaining.
     */
    public function setZone($value)
    {
        return $this->set('Zone', $value);
    }
}


/**
 * Execution object for the GetMachineType Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_MachineTypes_GetMachineType_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the GetMachineType Choreo.
     *
     * @param Temboo_Session $session The session that owns this GetMachineType execution.
     * @param Google_ComputeEngine_MachineTypes_GetMachineType $choreo The choreography object for this execution.
     * @param Google_ComputeEngine_MachineTypes_GetMachineType_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_MachineTypes_GetMachineType_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_MachineTypes_GetMachineType_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_ComputeEngine_MachineTypes_GetMachineType $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this GetMachineType execution.
     *
     * @return Google_ComputeEngine_MachineTypes_GetMachineType_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this GetMachineType execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_ComputeEngine_MachineTypes_GetMachineType_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_ComputeEngine_MachineTypes_GetMachineType_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the GetMachineType Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_MachineTypes_GetMachineType_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the GetMachineType Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_ComputeEngine_MachineTypes_GetMachineType_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this GetMachineType execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this GetMachineType execution.
     *
     * @return string (json) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Retrieves the list of Machine Type resources for the specified project.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_MachineTypes_ListMachineTypes extends Temboo_Choreography
{
    /**
     * Retrieves the list of Machine Type resources for the specified project.
     *
     * @param Temboo_Session $session The session that owns this ListMachineTypes Choreo.
     * @return Google_ComputeEngine_MachineTypes_ListMachineTypes New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/ComputeEngine/MachineTypes/ListMachineTypes/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this ListMachineTypes Choreo.
     *
     * @param Google_ComputeEngine_MachineTypes_ListMachineTypes_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_MachineTypes_ListMachineTypes_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_MachineTypes_ListMachineTypes_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_ComputeEngine_MachineTypes_ListMachineTypes_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this ListMachineTypes Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_MachineTypes_ListMachineTypes_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_ComputeEngine_MachineTypes_ListMachineTypes_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the ListMachineTypes Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_MachineTypes_ListMachineTypes_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the ListMachineTypes Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_MachineTypes_ListMachineTypes_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this ListMachineTypes input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_ComputeEngine_MachineTypes_ListMachineTypes_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_ComputeEngine_MachineTypes_ListMachineTypes_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this ListMachineTypes Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Google_ComputeEngine_MachineTypes_ListMachineTypes_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this ListMachineTypes Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_MachineTypes_ListMachineTypes_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this ListMachineTypes Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_MachineTypes_ListMachineTypes_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Fields input for this ListMachineTypes Choreo.
     *
     * @param string $value (optional, string) Comma-seperated list of fields you want to include in the response.
     * @return Google_ComputeEngine_MachineTypes_ListMachineTypes_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Filter input for this ListMachineTypes Choreo.
     *
     * @param string $value (optional, string) A filter expression for narrowing results in the form: {field_name} {comparison_string} {literal_string} (e.g. name eq f1-micro). Comparison strings can be eq (equals) or ne (not equals).
     * @return Google_ComputeEngine_MachineTypes_ListMachineTypes_Inputs For method chaining.
     */
    public function setFilter($value)
    {
        return $this->set('Filter', $value);
    }

    /**
     * Set the value for the MaxResults input for this ListMachineTypes Choreo.
     *
     * @param int $value (optional, integer) The maximum number of results to return.
     * @return Google_ComputeEngine_MachineTypes_ListMachineTypes_Inputs For method chaining.
     */
    public function setMaxResults($value)
    {
        return $this->set('MaxResults', $value);
    }

    /**
     * Set the value for the PageToken input for this ListMachineTypes Choreo.
     *
     * @param string $value (optional, string) The "nextPageToken" found in the response which is used to page through results.
     * @return Google_ComputeEngine_MachineTypes_ListMachineTypes_Inputs For method chaining.
     */
    public function setPageToken($value)
    {
        return $this->set('PageToken', $value);
    }

    /**
     * Set the value for the Project input for this ListMachineTypes Choreo.
     *
     * @param string $value (required, string) The ID of a Google Compute project.
     * @return Google_ComputeEngine_MachineTypes_ListMachineTypes_Inputs For method chaining.
     */
    public function setProject($value)
    {
        return $this->set('Project', $value);
    }

    /**
     * Set the value for the RefreshToken input for this ListMachineTypes Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_MachineTypes_ListMachineTypes_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }

    /**
     * Set the value for the Zone input for this ListMachineTypes Choreo.
     *
     * @param string $value (required, string) The name of the zone that contains the machine type resources to retrieve.
     * @return Google_ComputeEngine_MachineTypes_ListMachineTypes_Inputs For method chaining.
     */
    public function setZone($value)
    {
        return $this->set('Zone', $value);
    }
}


/**
 * Execution object for the ListMachineTypes Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_MachineTypes_ListMachineTypes_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the ListMachineTypes Choreo.
     *
     * @param Temboo_Session $session The session that owns this ListMachineTypes execution.
     * @param Google_ComputeEngine_MachineTypes_ListMachineTypes $choreo The choreography object for this execution.
     * @param Google_ComputeEngine_MachineTypes_ListMachineTypes_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_MachineTypes_ListMachineTypes_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_MachineTypes_ListMachineTypes_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_ComputeEngine_MachineTypes_ListMachineTypes $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this ListMachineTypes execution.
     *
     * @return Google_ComputeEngine_MachineTypes_ListMachineTypes_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this ListMachineTypes execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_ComputeEngine_MachineTypes_ListMachineTypes_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_ComputeEngine_MachineTypes_ListMachineTypes_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the ListMachineTypes Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_MachineTypes_ListMachineTypes_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the ListMachineTypes Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_ComputeEngine_MachineTypes_ListMachineTypes_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this ListMachineTypes execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this ListMachineTypes execution.
     *
     * @return string (json) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Deletes the specified Network resource.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Networks_DeleteNetwork extends Temboo_Choreography
{
    /**
     * Deletes the specified Network resource.
     *
     * @param Temboo_Session $session The session that owns this DeleteNetwork Choreo.
     * @return Google_ComputeEngine_Networks_DeleteNetwork New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/ComputeEngine/Networks/DeleteNetwork/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this DeleteNetwork Choreo.
     *
     * @param Google_ComputeEngine_Networks_DeleteNetwork_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Networks_DeleteNetwork_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Networks_DeleteNetwork_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_ComputeEngine_Networks_DeleteNetwork_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this DeleteNetwork Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Networks_DeleteNetwork_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_ComputeEngine_Networks_DeleteNetwork_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the DeleteNetwork Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Networks_DeleteNetwork_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the DeleteNetwork Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Networks_DeleteNetwork_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this DeleteNetwork input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_ComputeEngine_Networks_DeleteNetwork_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_ComputeEngine_Networks_DeleteNetwork_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this DeleteNetwork Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Google_ComputeEngine_Networks_DeleteNetwork_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this DeleteNetwork Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Networks_DeleteNetwork_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this DeleteNetwork Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Networks_DeleteNetwork_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Fields input for this DeleteNetwork Choreo.
     *
     * @param string $value (optional, string) Comma-seperated list of fields you want to include in the response.
     * @return Google_ComputeEngine_Networks_DeleteNetwork_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Network input for this DeleteNetwork Choreo.
     *
     * @param string $value (required, string) The name of the network to delete.
     * @return Google_ComputeEngine_Networks_DeleteNetwork_Inputs For method chaining.
     */
    public function setNetwork($value)
    {
        return $this->set('Network', $value);
    }

    /**
     * Set the value for the Project input for this DeleteNetwork Choreo.
     *
     * @param string $value (required, string) The ID of a Google Compute project.
     * @return Google_ComputeEngine_Networks_DeleteNetwork_Inputs For method chaining.
     */
    public function setProject($value)
    {
        return $this->set('Project', $value);
    }

    /**
     * Set the value for the RefreshToken input for this DeleteNetwork Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Networks_DeleteNetwork_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }
}


/**
 * Execution object for the DeleteNetwork Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Networks_DeleteNetwork_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the DeleteNetwork Choreo.
     *
     * @param Temboo_Session $session The session that owns this DeleteNetwork execution.
     * @param Google_ComputeEngine_Networks_DeleteNetwork $choreo The choreography object for this execution.
     * @param Google_ComputeEngine_Networks_DeleteNetwork_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Networks_DeleteNetwork_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Networks_DeleteNetwork_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_ComputeEngine_Networks_DeleteNetwork $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this DeleteNetwork execution.
     *
     * @return Google_ComputeEngine_Networks_DeleteNetwork_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this DeleteNetwork execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_ComputeEngine_Networks_DeleteNetwork_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_ComputeEngine_Networks_DeleteNetwork_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the DeleteNetwork Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Networks_DeleteNetwork_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the DeleteNetwork Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_ComputeEngine_Networks_DeleteNetwork_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this DeleteNetwork execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this DeleteNetwork execution.
     *
     * @return string (json) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Retrieves information about the specified Network.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Networks_GetNetwork extends Temboo_Choreography
{
    /**
     * Retrieves information about the specified Network.
     *
     * @param Temboo_Session $session The session that owns this GetNetwork Choreo.
     * @return Google_ComputeEngine_Networks_GetNetwork New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/ComputeEngine/Networks/GetNetwork/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this GetNetwork Choreo.
     *
     * @param Google_ComputeEngine_Networks_GetNetwork_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Networks_GetNetwork_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Networks_GetNetwork_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_ComputeEngine_Networks_GetNetwork_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this GetNetwork Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Networks_GetNetwork_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_ComputeEngine_Networks_GetNetwork_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the GetNetwork Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Networks_GetNetwork_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the GetNetwork Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Networks_GetNetwork_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this GetNetwork input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_ComputeEngine_Networks_GetNetwork_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_ComputeEngine_Networks_GetNetwork_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this GetNetwork Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Google_ComputeEngine_Networks_GetNetwork_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this GetNetwork Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Networks_GetNetwork_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this GetNetwork Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Networks_GetNetwork_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Fields input for this GetNetwork Choreo.
     *
     * @param string $value (optional, string) Comma-seperated list of fields you want to include in the response.
     * @return Google_ComputeEngine_Networks_GetNetwork_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Network input for this GetNetwork Choreo.
     *
     * @param string $value (required, string) The name of the network to retrieve.
     * @return Google_ComputeEngine_Networks_GetNetwork_Inputs For method chaining.
     */
    public function setNetwork($value)
    {
        return $this->set('Network', $value);
    }

    /**
     * Set the value for the Project input for this GetNetwork Choreo.
     *
     * @param string $value (required, string) The ID of a Google Compute project.
     * @return Google_ComputeEngine_Networks_GetNetwork_Inputs For method chaining.
     */
    public function setProject($value)
    {
        return $this->set('Project', $value);
    }

    /**
     * Set the value for the RefreshToken input for this GetNetwork Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Networks_GetNetwork_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }
}


/**
 * Execution object for the GetNetwork Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Networks_GetNetwork_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the GetNetwork Choreo.
     *
     * @param Temboo_Session $session The session that owns this GetNetwork execution.
     * @param Google_ComputeEngine_Networks_GetNetwork $choreo The choreography object for this execution.
     * @param Google_ComputeEngine_Networks_GetNetwork_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Networks_GetNetwork_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Networks_GetNetwork_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_ComputeEngine_Networks_GetNetwork $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this GetNetwork execution.
     *
     * @return Google_ComputeEngine_Networks_GetNetwork_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this GetNetwork execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_ComputeEngine_Networks_GetNetwork_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_ComputeEngine_Networks_GetNetwork_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the GetNetwork Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Networks_GetNetwork_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the GetNetwork Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_ComputeEngine_Networks_GetNetwork_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this GetNetwork execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this GetNetwork execution.
     *
     * @return string (json) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Creates a new Network resource in the specified project.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Networks_InsertNetwork extends Temboo_Choreography
{
    /**
     * Creates a new Network resource in the specified project.
     *
     * @param Temboo_Session $session The session that owns this InsertNetwork Choreo.
     * @return Google_ComputeEngine_Networks_InsertNetwork New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/ComputeEngine/Networks/InsertNetwork/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this InsertNetwork Choreo.
     *
     * @param Google_ComputeEngine_Networks_InsertNetwork_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Networks_InsertNetwork_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Networks_InsertNetwork_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_ComputeEngine_Networks_InsertNetwork_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this InsertNetwork Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Networks_InsertNetwork_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_ComputeEngine_Networks_InsertNetwork_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the InsertNetwork Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Networks_InsertNetwork_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the InsertNetwork Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Networks_InsertNetwork_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this InsertNetwork input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_ComputeEngine_Networks_InsertNetwork_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_ComputeEngine_Networks_InsertNetwork_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the NetworkResource input for this InsertNetwork Choreo.
     *
     * @param string $value (optional, json) A JSON string containing the network resource properties you wish to set. This can be used as an alternative to individual inputs that represent network resource properties.
     * @return Google_ComputeEngine_Networks_InsertNetwork_Inputs For method chaining.
     */
    public function setNetworkResource($value)
    {
        return $this->set('NetworkResource', $value);
    }

    /**
     * Set the value for the AccessToken input for this InsertNetwork Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Google_ComputeEngine_Networks_InsertNetwork_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this InsertNetwork Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Networks_InsertNetwork_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this InsertNetwork Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Networks_InsertNetwork_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Description input for this InsertNetwork Choreo.
     *
     * @param string $value (optional, string) A description of the network.
     * @return Google_ComputeEngine_Networks_InsertNetwork_Inputs For method chaining.
     */
    public function setDescription($value)
    {
        return $this->set('Description', $value);
    }

    /**
     * Set the value for the GatewayIP input for this InsertNetwork Choreo.
     *
     * @param string $value (optional, string) An optional address used for default routing to other networks. Must be within the range specified by IPRange.
     * @return Google_ComputeEngine_Networks_InsertNetwork_Inputs For method chaining.
     */
    public function setGatewayIP($value)
    {
        return $this->set('GatewayIP', $value);
    }

    /**
     * Set the value for the IPRange input for this InsertNetwork Choreo.
     *
     * @param string $value (conditional, string) The range of internal addresses that are allowed on the network.
     * @return Google_ComputeEngine_Networks_InsertNetwork_Inputs For method chaining.
     */
    public function setIPRange($value)
    {
        return $this->set('IPRange', $value);
    }

    /**
     * Set the value for the Name input for this InsertNetwork Choreo.
     *
     * @param string $value (conditional, string) The name of the network.
     * @return Google_ComputeEngine_Networks_InsertNetwork_Inputs For method chaining.
     */
    public function setName($value)
    {
        return $this->set('Name', $value);
    }

    /**
     * Set the value for the Project input for this InsertNetwork Choreo.
     *
     * @param string $value (required, string) The ID of a Google Compute project.
     * @return Google_ComputeEngine_Networks_InsertNetwork_Inputs For method chaining.
     */
    public function setProject($value)
    {
        return $this->set('Project', $value);
    }

    /**
     * Set the value for the RefreshToken input for this InsertNetwork Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Networks_InsertNetwork_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }
}


/**
 * Execution object for the InsertNetwork Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Networks_InsertNetwork_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the InsertNetwork Choreo.
     *
     * @param Temboo_Session $session The session that owns this InsertNetwork execution.
     * @param Google_ComputeEngine_Networks_InsertNetwork $choreo The choreography object for this execution.
     * @param Google_ComputeEngine_Networks_InsertNetwork_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Networks_InsertNetwork_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Networks_InsertNetwork_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_ComputeEngine_Networks_InsertNetwork $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this InsertNetwork execution.
     *
     * @return Google_ComputeEngine_Networks_InsertNetwork_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this InsertNetwork execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_ComputeEngine_Networks_InsertNetwork_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_ComputeEngine_Networks_InsertNetwork_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the InsertNetwork Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Networks_InsertNetwork_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the InsertNetwork Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_ComputeEngine_Networks_InsertNetwork_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this InsertNetwork execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this InsertNetwork execution.
     *
     * @return string (json) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Retrieves the list of Network resources for the specified project.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Networks_ListNetworks extends Temboo_Choreography
{
    /**
     * Retrieves the list of Network resources for the specified project.
     *
     * @param Temboo_Session $session The session that owns this ListNetworks Choreo.
     * @return Google_ComputeEngine_Networks_ListNetworks New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/ComputeEngine/Networks/ListNetworks/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this ListNetworks Choreo.
     *
     * @param Google_ComputeEngine_Networks_ListNetworks_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Networks_ListNetworks_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Networks_ListNetworks_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_ComputeEngine_Networks_ListNetworks_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this ListNetworks Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Networks_ListNetworks_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_ComputeEngine_Networks_ListNetworks_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the ListNetworks Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Networks_ListNetworks_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the ListNetworks Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Networks_ListNetworks_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this ListNetworks input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_ComputeEngine_Networks_ListNetworks_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_ComputeEngine_Networks_ListNetworks_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this ListNetworks Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Google_ComputeEngine_Networks_ListNetworks_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this ListNetworks Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Networks_ListNetworks_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this ListNetworks Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Networks_ListNetworks_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Fields input for this ListNetworks Choreo.
     *
     * @param string $value (optional, string) Comma-seperated list of fields you want to include in the response.
     * @return Google_ComputeEngine_Networks_ListNetworks_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Filter input for this ListNetworks Choreo.
     *
     * @param string $value (optional, string) A filter expression for narrowing results in the form: {field_name} {comparison_string} {literal_string} (e.g. name eq default). Comparison strings can be eq (equals) or ne (not equals).
     * @return Google_ComputeEngine_Networks_ListNetworks_Inputs For method chaining.
     */
    public function setFilter($value)
    {
        return $this->set('Filter', $value);
    }

    /**
     * Set the value for the MaxResults input for this ListNetworks Choreo.
     *
     * @param int $value (optional, integer) The maximum number of results to return.
     * @return Google_ComputeEngine_Networks_ListNetworks_Inputs For method chaining.
     */
    public function setMaxResults($value)
    {
        return $this->set('MaxResults', $value);
    }

    /**
     * Set the value for the PageToken input for this ListNetworks Choreo.
     *
     * @param string $value (optional, string) The "nextPageToken" found in the response which is used to page through results.
     * @return Google_ComputeEngine_Networks_ListNetworks_Inputs For method chaining.
     */
    public function setPageToken($value)
    {
        return $this->set('PageToken', $value);
    }

    /**
     * Set the value for the Project input for this ListNetworks Choreo.
     *
     * @param string $value (required, string) The ID of a Google Compute project.
     * @return Google_ComputeEngine_Networks_ListNetworks_Inputs For method chaining.
     */
    public function setProject($value)
    {
        return $this->set('Project', $value);
    }

    /**
     * Set the value for the RefreshToken input for this ListNetworks Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Networks_ListNetworks_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }
}


/**
 * Execution object for the ListNetworks Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Networks_ListNetworks_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the ListNetworks Choreo.
     *
     * @param Temboo_Session $session The session that owns this ListNetworks execution.
     * @param Google_ComputeEngine_Networks_ListNetworks $choreo The choreography object for this execution.
     * @param Google_ComputeEngine_Networks_ListNetworks_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Networks_ListNetworks_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Networks_ListNetworks_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_ComputeEngine_Networks_ListNetworks $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this ListNetworks execution.
     *
     * @return Google_ComputeEngine_Networks_ListNetworks_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this ListNetworks execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_ComputeEngine_Networks_ListNetworks_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_ComputeEngine_Networks_ListNetworks_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the ListNetworks Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Networks_ListNetworks_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the ListNetworks Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_ComputeEngine_Networks_ListNetworks_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this ListNetworks execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this ListNetworks execution.
     *
     * @return string (json) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Retrieves the specified Project resource.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Projects_GetProject extends Temboo_Choreography
{
    /**
     * Retrieves the specified Project resource.
     *
     * @param Temboo_Session $session The session that owns this GetProject Choreo.
     * @return Google_ComputeEngine_Projects_GetProject New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/ComputeEngine/Projects/GetProject/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this GetProject Choreo.
     *
     * @param Google_ComputeEngine_Projects_GetProject_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Projects_GetProject_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Projects_GetProject_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_ComputeEngine_Projects_GetProject_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this GetProject Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Projects_GetProject_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_ComputeEngine_Projects_GetProject_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the GetProject Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Projects_GetProject_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the GetProject Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Projects_GetProject_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this GetProject input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_ComputeEngine_Projects_GetProject_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_ComputeEngine_Projects_GetProject_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this GetProject Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Google_ComputeEngine_Projects_GetProject_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this GetProject Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Projects_GetProject_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this GetProject Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Projects_GetProject_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Fields input for this GetProject Choreo.
     *
     * @param string $value (optional, string) Comma-seperated list of fields you want to include in the response.
     * @return Google_ComputeEngine_Projects_GetProject_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Project input for this GetProject Choreo.
     *
     * @param string $value (required, string) The ID of a Google Compute project.
     * @return Google_ComputeEngine_Projects_GetProject_Inputs For method chaining.
     */
    public function setProject($value)
    {
        return $this->set('Project', $value);
    }

    /**
     * Set the value for the RefreshToken input for this GetProject Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Projects_GetProject_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }
}


/**
 * Execution object for the GetProject Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Projects_GetProject_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the GetProject Choreo.
     *
     * @param Temboo_Session $session The session that owns this GetProject execution.
     * @param Google_ComputeEngine_Projects_GetProject $choreo The choreography object for this execution.
     * @param Google_ComputeEngine_Projects_GetProject_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Projects_GetProject_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Projects_GetProject_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_ComputeEngine_Projects_GetProject $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this GetProject execution.
     *
     * @return Google_ComputeEngine_Projects_GetProject_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this GetProject execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_ComputeEngine_Projects_GetProject_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_ComputeEngine_Projects_GetProject_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the GetProject Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Projects_GetProject_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the GetProject Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_ComputeEngine_Projects_GetProject_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this GetProject execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this GetProject execution.
     *
     * @return string (json) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Sets metadata common to all instances within the specified Project.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Projects_SetCommonInstanceMetadata extends Temboo_Choreography
{
    /**
     * Sets metadata common to all instances within the specified Project.
     *
     * @param Temboo_Session $session The session that owns this SetCommonInstanceMetadata Choreo.
     * @return Google_ComputeEngine_Projects_SetCommonInstanceMetadata New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/ComputeEngine/Projects/SetCommonInstanceMetadata/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this SetCommonInstanceMetadata Choreo.
     *
     * @param Google_ComputeEngine_Projects_SetCommonInstanceMetadata_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Projects_SetCommonInstanceMetadata_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Projects_SetCommonInstanceMetadata_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_ComputeEngine_Projects_SetCommonInstanceMetadata_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this SetCommonInstanceMetadata Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Projects_SetCommonInstanceMetadata_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_ComputeEngine_Projects_SetCommonInstanceMetadata_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the SetCommonInstanceMetadata Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Projects_SetCommonInstanceMetadata_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the SetCommonInstanceMetadata Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Projects_SetCommonInstanceMetadata_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this SetCommonInstanceMetadata input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_ComputeEngine_Projects_SetCommonInstanceMetadata_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_ComputeEngine_Projects_SetCommonInstanceMetadata_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this SetCommonInstanceMetadata Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Google_ComputeEngine_Projects_SetCommonInstanceMetadata_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this SetCommonInstanceMetadata Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Projects_SetCommonInstanceMetadata_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this SetCommonInstanceMetadata Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Projects_SetCommonInstanceMetadata_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Fingerprint input for this SetCommonInstanceMetadata Choreo.
     *
     * @param string $value (required, string) The fingerprint of this resource, which is a hash of the metadata's contents. This field is used for optimistic locking. Providing an up-to-date metadata fingerprint is required to modify metadata.
     * @return Google_ComputeEngine_Projects_SetCommonInstanceMetadata_Inputs For method chaining.
     */
    public function setFingerprint($value)
    {
        return $this->set('Fingerprint', $value);
    }

    /**
     * Set the value for the Items input for this SetCommonInstanceMetadata Choreo.
     *
     * @param string $value (conditional, json) An array of key/value pairs. The max size of all keys and values is 512 KB.
     * @return Google_ComputeEngine_Projects_SetCommonInstanceMetadata_Inputs For method chaining.
     */
    public function setItems($value)
    {
        return $this->set('Items', $value);
    }

    /**
     * Set the value for the Project input for this SetCommonInstanceMetadata Choreo.
     *
     * @param string $value (required, string) The ID of a Google Compute project.
     * @return Google_ComputeEngine_Projects_SetCommonInstanceMetadata_Inputs For method chaining.
     */
    public function setProject($value)
    {
        return $this->set('Project', $value);
    }

    /**
     * Set the value for the RefreshToken input for this SetCommonInstanceMetadata Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Projects_SetCommonInstanceMetadata_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }
}


/**
 * Execution object for the SetCommonInstanceMetadata Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Projects_SetCommonInstanceMetadata_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the SetCommonInstanceMetadata Choreo.
     *
     * @param Temboo_Session $session The session that owns this SetCommonInstanceMetadata execution.
     * @param Google_ComputeEngine_Projects_SetCommonInstanceMetadata $choreo The choreography object for this execution.
     * @param Google_ComputeEngine_Projects_SetCommonInstanceMetadata_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Projects_SetCommonInstanceMetadata_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Projects_SetCommonInstanceMetadata_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_ComputeEngine_Projects_SetCommonInstanceMetadata $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this SetCommonInstanceMetadata execution.
     *
     * @return Google_ComputeEngine_Projects_SetCommonInstanceMetadata_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this SetCommonInstanceMetadata execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_ComputeEngine_Projects_SetCommonInstanceMetadata_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_ComputeEngine_Projects_SetCommonInstanceMetadata_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the SetCommonInstanceMetadata Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Projects_SetCommonInstanceMetadata_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the SetCommonInstanceMetadata Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_ComputeEngine_Projects_SetCommonInstanceMetadata_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this SetCommonInstanceMetadata execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this SetCommonInstanceMetadata execution.
     *
     * @return string (json) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Deletes the specified operation within a region.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_RegionOperations_DeleteRegionOperation extends Temboo_Choreography
{
    /**
     * Deletes the specified operation within a region.
     *
     * @param Temboo_Session $session The session that owns this DeleteRegionOperation Choreo.
     * @return Google_ComputeEngine_RegionOperations_DeleteRegionOperation New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/ComputeEngine/RegionOperations/DeleteRegionOperation/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this DeleteRegionOperation Choreo.
     *
     * @param Google_ComputeEngine_RegionOperations_DeleteRegionOperation_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_RegionOperations_DeleteRegionOperation_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_RegionOperations_DeleteRegionOperation_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_ComputeEngine_RegionOperations_DeleteRegionOperation_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this DeleteRegionOperation Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_RegionOperations_DeleteRegionOperation_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_ComputeEngine_RegionOperations_DeleteRegionOperation_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the DeleteRegionOperation Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_RegionOperations_DeleteRegionOperation_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the DeleteRegionOperation Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_RegionOperations_DeleteRegionOperation_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this DeleteRegionOperation input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_ComputeEngine_RegionOperations_DeleteRegionOperation_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_ComputeEngine_RegionOperations_DeleteRegionOperation_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this DeleteRegionOperation Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Google_ComputeEngine_RegionOperations_DeleteRegionOperation_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this DeleteRegionOperation Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_RegionOperations_DeleteRegionOperation_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this DeleteRegionOperation Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_RegionOperations_DeleteRegionOperation_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Fields input for this DeleteRegionOperation Choreo.
     *
     * @param string $value (optional, string) Comma-seperated list of fields you want to include in the response.
     * @return Google_ComputeEngine_RegionOperations_DeleteRegionOperation_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Operation input for this DeleteRegionOperation Choreo.
     *
     * @param string $value (required, string) The name of the operation to delete.
     * @return Google_ComputeEngine_RegionOperations_DeleteRegionOperation_Inputs For method chaining.
     */
    public function setOperation($value)
    {
        return $this->set('Operation', $value);
    }

    /**
     * Set the value for the Project input for this DeleteRegionOperation Choreo.
     *
     * @param string $value (required, string) The ID of a Google Compute project.
     * @return Google_ComputeEngine_RegionOperations_DeleteRegionOperation_Inputs For method chaining.
     */
    public function setProject($value)
    {
        return $this->set('Project', $value);
    }

    /**
     * Set the value for the RefreshToken input for this DeleteRegionOperation Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_RegionOperations_DeleteRegionOperation_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }

    /**
     * Set the value for the Region input for this DeleteRegionOperation Choreo.
     *
     * @param string $value (required, string) The name of the region associated with the request.
     * @return Google_ComputeEngine_RegionOperations_DeleteRegionOperation_Inputs For method chaining.
     */
    public function setRegion($value)
    {
        return $this->set('Region', $value);
    }
}


/**
 * Execution object for the DeleteRegionOperation Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_RegionOperations_DeleteRegionOperation_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the DeleteRegionOperation Choreo.
     *
     * @param Temboo_Session $session The session that owns this DeleteRegionOperation execution.
     * @param Google_ComputeEngine_RegionOperations_DeleteRegionOperation $choreo The choreography object for this execution.
     * @param Google_ComputeEngine_RegionOperations_DeleteRegionOperation_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_RegionOperations_DeleteRegionOperation_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_RegionOperations_DeleteRegionOperation_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_ComputeEngine_RegionOperations_DeleteRegionOperation $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this DeleteRegionOperation execution.
     *
     * @return Google_ComputeEngine_RegionOperations_DeleteRegionOperation_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this DeleteRegionOperation execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_ComputeEngine_RegionOperations_DeleteRegionOperation_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_ComputeEngine_RegionOperations_DeleteRegionOperation_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the DeleteRegionOperation Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_RegionOperations_DeleteRegionOperation_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the DeleteRegionOperation Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_ComputeEngine_RegionOperations_DeleteRegionOperation_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this DeleteRegionOperation execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "ResponseStatusCode" output from this DeleteRegionOperation execution.
     *
     * @return int (integer) The response status code returned from Google. A 204 is expected for a successful delete operation.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponseStatusCode()
    {
        return $this->get('ResponseStatusCode');
    }
    /**
     * Retrieve the value for the "Response" output from this DeleteRegionOperation execution.
     *
     * @return string (json) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Retrieves information about the specified operation within a region.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_RegionOperations_GetRegionOperation extends Temboo_Choreography
{
    /**
     * Retrieves information about the specified operation within a region.
     *
     * @param Temboo_Session $session The session that owns this GetRegionOperation Choreo.
     * @return Google_ComputeEngine_RegionOperations_GetRegionOperation New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/ComputeEngine/RegionOperations/GetRegionOperation/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this GetRegionOperation Choreo.
     *
     * @param Google_ComputeEngine_RegionOperations_GetRegionOperation_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_RegionOperations_GetRegionOperation_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_RegionOperations_GetRegionOperation_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_ComputeEngine_RegionOperations_GetRegionOperation_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this GetRegionOperation Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_RegionOperations_GetRegionOperation_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_ComputeEngine_RegionOperations_GetRegionOperation_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the GetRegionOperation Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_RegionOperations_GetRegionOperation_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the GetRegionOperation Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_RegionOperations_GetRegionOperation_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this GetRegionOperation input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_ComputeEngine_RegionOperations_GetRegionOperation_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_ComputeEngine_RegionOperations_GetRegionOperation_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this GetRegionOperation Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Google_ComputeEngine_RegionOperations_GetRegionOperation_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this GetRegionOperation Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_RegionOperations_GetRegionOperation_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this GetRegionOperation Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_RegionOperations_GetRegionOperation_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Fields input for this GetRegionOperation Choreo.
     *
     * @param string $value (optional, string) Comma-seperated list of fields you want to include in the response.
     * @return Google_ComputeEngine_RegionOperations_GetRegionOperation_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Operation input for this GetRegionOperation Choreo.
     *
     * @param string $value (required, string) The name of the operation to retrieve.
     * @return Google_ComputeEngine_RegionOperations_GetRegionOperation_Inputs For method chaining.
     */
    public function setOperation($value)
    {
        return $this->set('Operation', $value);
    }

    /**
     * Set the value for the Project input for this GetRegionOperation Choreo.
     *
     * @param string $value (required, string) The ID of a Google Compute project.
     * @return Google_ComputeEngine_RegionOperations_GetRegionOperation_Inputs For method chaining.
     */
    public function setProject($value)
    {
        return $this->set('Project', $value);
    }

    /**
     * Set the value for the RefreshToken input for this GetRegionOperation Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_RegionOperations_GetRegionOperation_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }

    /**
     * Set the value for the Region input for this GetRegionOperation Choreo.
     *
     * @param string $value (required, string) The name of the region associated with the request.
     * @return Google_ComputeEngine_RegionOperations_GetRegionOperation_Inputs For method chaining.
     */
    public function setRegion($value)
    {
        return $this->set('Region', $value);
    }
}


/**
 * Execution object for the GetRegionOperation Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_RegionOperations_GetRegionOperation_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the GetRegionOperation Choreo.
     *
     * @param Temboo_Session $session The session that owns this GetRegionOperation execution.
     * @param Google_ComputeEngine_RegionOperations_GetRegionOperation $choreo The choreography object for this execution.
     * @param Google_ComputeEngine_RegionOperations_GetRegionOperation_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_RegionOperations_GetRegionOperation_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_RegionOperations_GetRegionOperation_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_ComputeEngine_RegionOperations_GetRegionOperation $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this GetRegionOperation execution.
     *
     * @return Google_ComputeEngine_RegionOperations_GetRegionOperation_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this GetRegionOperation execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_ComputeEngine_RegionOperations_GetRegionOperation_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_ComputeEngine_RegionOperations_GetRegionOperation_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the GetRegionOperation Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_RegionOperations_GetRegionOperation_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the GetRegionOperation Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_ComputeEngine_RegionOperations_GetRegionOperation_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this GetRegionOperation execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this GetRegionOperation execution.
     *
     * @return string (json) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Retrieves a list of operation resources contained within the specified region.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_RegionOperations_ListRegionOperations extends Temboo_Choreography
{
    /**
     * Retrieves a list of operation resources contained within the specified region.
     *
     * @param Temboo_Session $session The session that owns this ListRegionOperations Choreo.
     * @return Google_ComputeEngine_RegionOperations_ListRegionOperations New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/ComputeEngine/RegionOperations/ListRegionOperations/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this ListRegionOperations Choreo.
     *
     * @param Google_ComputeEngine_RegionOperations_ListRegionOperations_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_RegionOperations_ListRegionOperations_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_RegionOperations_ListRegionOperations_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_ComputeEngine_RegionOperations_ListRegionOperations_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this ListRegionOperations Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_RegionOperations_ListRegionOperations_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_ComputeEngine_RegionOperations_ListRegionOperations_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the ListRegionOperations Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_RegionOperations_ListRegionOperations_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the ListRegionOperations Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_RegionOperations_ListRegionOperations_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this ListRegionOperations input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_ComputeEngine_RegionOperations_ListRegionOperations_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_ComputeEngine_RegionOperations_ListRegionOperations_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this ListRegionOperations Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Google_ComputeEngine_RegionOperations_ListRegionOperations_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this ListRegionOperations Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_RegionOperations_ListRegionOperations_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this ListRegionOperations Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_RegionOperations_ListRegionOperations_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Fields input for this ListRegionOperations Choreo.
     *
     * @param string $value (optional, string) Comma-seperated list of fields you want to include in the response.
     * @return Google_ComputeEngine_RegionOperations_ListRegionOperations_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Filter input for this ListRegionOperations Choreo.
     *
     * @param string $value (optional, string) A filter expression for narrowing results in the form: {field_name} {comparison_string} {literal_string} (e.g. name eq operation-1234). Comparison strings can be eq (equals) or ne (not equals).
     * @return Google_ComputeEngine_RegionOperations_ListRegionOperations_Inputs For method chaining.
     */
    public function setFilter($value)
    {
        return $this->set('Filter', $value);
    }

    /**
     * Set the value for the MaxResults input for this ListRegionOperations Choreo.
     *
     * @param int $value (optional, integer) The maximum number of results to return.
     * @return Google_ComputeEngine_RegionOperations_ListRegionOperations_Inputs For method chaining.
     */
    public function setMaxResults($value)
    {
        return $this->set('MaxResults', $value);
    }

    /**
     * Set the value for the PageToken input for this ListRegionOperations Choreo.
     *
     * @param string $value (optional, string) The "nextPageToken" found in the response which is used to page through results.
     * @return Google_ComputeEngine_RegionOperations_ListRegionOperations_Inputs For method chaining.
     */
    public function setPageToken($value)
    {
        return $this->set('PageToken', $value);
    }

    /**
     * Set the value for the Project input for this ListRegionOperations Choreo.
     *
     * @param string $value (required, string) The ID of a Google Compute project.
     * @return Google_ComputeEngine_RegionOperations_ListRegionOperations_Inputs For method chaining.
     */
    public function setProject($value)
    {
        return $this->set('Project', $value);
    }

    /**
     * Set the value for the RefreshToken input for this ListRegionOperations Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_RegionOperations_ListRegionOperations_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }

    /**
     * Set the value for the Region input for this ListRegionOperations Choreo.
     *
     * @param string $value (required, string) The name of the region associated with this request.
     * @return Google_ComputeEngine_RegionOperations_ListRegionOperations_Inputs For method chaining.
     */
    public function setRegion($value)
    {
        return $this->set('Region', $value);
    }
}


/**
 * Execution object for the ListRegionOperations Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_RegionOperations_ListRegionOperations_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the ListRegionOperations Choreo.
     *
     * @param Temboo_Session $session The session that owns this ListRegionOperations execution.
     * @param Google_ComputeEngine_RegionOperations_ListRegionOperations $choreo The choreography object for this execution.
     * @param Google_ComputeEngine_RegionOperations_ListRegionOperations_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_RegionOperations_ListRegionOperations_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_RegionOperations_ListRegionOperations_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_ComputeEngine_RegionOperations_ListRegionOperations $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this ListRegionOperations execution.
     *
     * @return Google_ComputeEngine_RegionOperations_ListRegionOperations_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this ListRegionOperations execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_ComputeEngine_RegionOperations_ListRegionOperations_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_ComputeEngine_RegionOperations_ListRegionOperations_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the ListRegionOperations Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_RegionOperations_ListRegionOperations_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the ListRegionOperations Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_ComputeEngine_RegionOperations_ListRegionOperations_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this ListRegionOperations execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this ListRegionOperations execution.
     *
     * @return string (json) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Retrieves information about the specified Region.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Regions_GetRegion extends Temboo_Choreography
{
    /**
     * Retrieves information about the specified Region.
     *
     * @param Temboo_Session $session The session that owns this GetRegion Choreo.
     * @return Google_ComputeEngine_Regions_GetRegion New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/ComputeEngine/Regions/GetRegion/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this GetRegion Choreo.
     *
     * @param Google_ComputeEngine_Regions_GetRegion_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Regions_GetRegion_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Regions_GetRegion_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_ComputeEngine_Regions_GetRegion_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this GetRegion Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Regions_GetRegion_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_ComputeEngine_Regions_GetRegion_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the GetRegion Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Regions_GetRegion_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the GetRegion Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Regions_GetRegion_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this GetRegion input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_ComputeEngine_Regions_GetRegion_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_ComputeEngine_Regions_GetRegion_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this GetRegion Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Google_ComputeEngine_Regions_GetRegion_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this GetRegion Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Regions_GetRegion_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this GetRegion Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Regions_GetRegion_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Fields input for this GetRegion Choreo.
     *
     * @param string $value (optional, string) Comma-seperated list of fields you want to include in the response.
     * @return Google_ComputeEngine_Regions_GetRegion_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Project input for this GetRegion Choreo.
     *
     * @param string $value (required, string) The ID of a Google Compute project.
     * @return Google_ComputeEngine_Regions_GetRegion_Inputs For method chaining.
     */
    public function setProject($value)
    {
        return $this->set('Project', $value);
    }

    /**
     * Set the value for the RefreshToken input for this GetRegion Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Regions_GetRegion_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }

    /**
     * Set the value for the Region input for this GetRegion Choreo.
     *
     * @param string $value (required, string) The name of the region to retrieve.
     * @return Google_ComputeEngine_Regions_GetRegion_Inputs For method chaining.
     */
    public function setRegion($value)
    {
        return $this->set('Region', $value);
    }
}


/**
 * Execution object for the GetRegion Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Regions_GetRegion_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the GetRegion Choreo.
     *
     * @param Temboo_Session $session The session that owns this GetRegion execution.
     * @param Google_ComputeEngine_Regions_GetRegion $choreo The choreography object for this execution.
     * @param Google_ComputeEngine_Regions_GetRegion_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Regions_GetRegion_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Regions_GetRegion_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_ComputeEngine_Regions_GetRegion $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this GetRegion execution.
     *
     * @return Google_ComputeEngine_Regions_GetRegion_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this GetRegion execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_ComputeEngine_Regions_GetRegion_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_ComputeEngine_Regions_GetRegion_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the GetRegion Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Regions_GetRegion_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the GetRegion Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_ComputeEngine_Regions_GetRegion_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this GetRegion execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this GetRegion execution.
     *
     * @return string (json) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Retrieves the list of Regions available to the specified project.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Regions_ListRegions extends Temboo_Choreography
{
    /**
     * Retrieves the list of Regions available to the specified project.
     *
     * @param Temboo_Session $session The session that owns this ListRegions Choreo.
     * @return Google_ComputeEngine_Regions_ListRegions New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/ComputeEngine/Regions/ListRegions/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this ListRegions Choreo.
     *
     * @param Google_ComputeEngine_Regions_ListRegions_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Regions_ListRegions_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Regions_ListRegions_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_ComputeEngine_Regions_ListRegions_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this ListRegions Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Regions_ListRegions_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_ComputeEngine_Regions_ListRegions_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the ListRegions Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Regions_ListRegions_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the ListRegions Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Regions_ListRegions_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this ListRegions input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_ComputeEngine_Regions_ListRegions_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_ComputeEngine_Regions_ListRegions_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this ListRegions Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Google_ComputeEngine_Regions_ListRegions_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this ListRegions Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Regions_ListRegions_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this ListRegions Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Regions_ListRegions_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Fields input for this ListRegions Choreo.
     *
     * @param string $value (optional, string) Comma-seperated list of fields you want to include in the response.
     * @return Google_ComputeEngine_Regions_ListRegions_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Filter input for this ListRegions Choreo.
     *
     * @param string $value (optional, string) A filter expression for narrowing results in the form: {field_name} {comparison_string} {literal_string} (e.g. name eq europe-west1). Comparison strings can be eq (equals) or ne (not equals).
     * @return Google_ComputeEngine_Regions_ListRegions_Inputs For method chaining.
     */
    public function setFilter($value)
    {
        return $this->set('Filter', $value);
    }

    /**
     * Set the value for the MaxResults input for this ListRegions Choreo.
     *
     * @param int $value (optional, integer) The maximum number of results to return.
     * @return Google_ComputeEngine_Regions_ListRegions_Inputs For method chaining.
     */
    public function setMaxResults($value)
    {
        return $this->set('MaxResults', $value);
    }

    /**
     * Set the value for the PageToken input for this ListRegions Choreo.
     *
     * @param string $value (optional, string) The "nextPageToken" found in the response which is used to page through results.
     * @return Google_ComputeEngine_Regions_ListRegions_Inputs For method chaining.
     */
    public function setPageToken($value)
    {
        return $this->set('PageToken', $value);
    }

    /**
     * Set the value for the Project input for this ListRegions Choreo.
     *
     * @param string $value (required, string) The ID of a Google Compute project.
     * @return Google_ComputeEngine_Regions_ListRegions_Inputs For method chaining.
     */
    public function setProject($value)
    {
        return $this->set('Project', $value);
    }

    /**
     * Set the value for the RefreshToken input for this ListRegions Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Regions_ListRegions_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }
}


/**
 * Execution object for the ListRegions Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Regions_ListRegions_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the ListRegions Choreo.
     *
     * @param Temboo_Session $session The session that owns this ListRegions execution.
     * @param Google_ComputeEngine_Regions_ListRegions $choreo The choreography object for this execution.
     * @param Google_ComputeEngine_Regions_ListRegions_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Regions_ListRegions_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Regions_ListRegions_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_ComputeEngine_Regions_ListRegions $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this ListRegions execution.
     *
     * @return Google_ComputeEngine_Regions_ListRegions_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this ListRegions execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_ComputeEngine_Regions_ListRegions_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_ComputeEngine_Regions_ListRegions_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the ListRegions Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Regions_ListRegions_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the ListRegions Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_ComputeEngine_Regions_ListRegions_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this ListRegions execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this ListRegions execution.
     *
     * @return string (json) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Deletes the specified Route.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Routes_DeleteRoute extends Temboo_Choreography
{
    /**
     * Deletes the specified Route.
     *
     * @param Temboo_Session $session The session that owns this DeleteRoute Choreo.
     * @return Google_ComputeEngine_Routes_DeleteRoute New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/ComputeEngine/Routes/DeleteRoute/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this DeleteRoute Choreo.
     *
     * @param Google_ComputeEngine_Routes_DeleteRoute_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Routes_DeleteRoute_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Routes_DeleteRoute_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_ComputeEngine_Routes_DeleteRoute_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this DeleteRoute Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Routes_DeleteRoute_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_ComputeEngine_Routes_DeleteRoute_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the DeleteRoute Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Routes_DeleteRoute_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the DeleteRoute Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Routes_DeleteRoute_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this DeleteRoute input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_ComputeEngine_Routes_DeleteRoute_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_ComputeEngine_Routes_DeleteRoute_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this DeleteRoute Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Google_ComputeEngine_Routes_DeleteRoute_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this DeleteRoute Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Routes_DeleteRoute_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this DeleteRoute Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Routes_DeleteRoute_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Fields input for this DeleteRoute Choreo.
     *
     * @param string $value (optional, string) Comma-seperated list of fields you want to include in the response.
     * @return Google_ComputeEngine_Routes_DeleteRoute_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Project input for this DeleteRoute Choreo.
     *
     * @param string $value (required, string) The ID of a Google Compute project.
     * @return Google_ComputeEngine_Routes_DeleteRoute_Inputs For method chaining.
     */
    public function setProject($value)
    {
        return $this->set('Project', $value);
    }

    /**
     * Set the value for the RefreshToken input for this DeleteRoute Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Routes_DeleteRoute_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }

    /**
     * Set the value for the Route input for this DeleteRoute Choreo.
     *
     * @param string $value (required, string) The name of the route to delete.
     * @return Google_ComputeEngine_Routes_DeleteRoute_Inputs For method chaining.
     */
    public function setRoute($value)
    {
        return $this->set('Route', $value);
    }
}


/**
 * Execution object for the DeleteRoute Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Routes_DeleteRoute_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the DeleteRoute Choreo.
     *
     * @param Temboo_Session $session The session that owns this DeleteRoute execution.
     * @param Google_ComputeEngine_Routes_DeleteRoute $choreo The choreography object for this execution.
     * @param Google_ComputeEngine_Routes_DeleteRoute_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Routes_DeleteRoute_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Routes_DeleteRoute_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_ComputeEngine_Routes_DeleteRoute $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this DeleteRoute execution.
     *
     * @return Google_ComputeEngine_Routes_DeleteRoute_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this DeleteRoute execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_ComputeEngine_Routes_DeleteRoute_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_ComputeEngine_Routes_DeleteRoute_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the DeleteRoute Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Routes_DeleteRoute_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the DeleteRoute Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_ComputeEngine_Routes_DeleteRoute_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this DeleteRoute execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this DeleteRoute execution.
     *
     * @return string (json) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Retrieves information about the specified Route.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Routes_GetRoute extends Temboo_Choreography
{
    /**
     * Retrieves information about the specified Route.
     *
     * @param Temboo_Session $session The session that owns this GetRoute Choreo.
     * @return Google_ComputeEngine_Routes_GetRoute New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/ComputeEngine/Routes/GetRoute/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this GetRoute Choreo.
     *
     * @param Google_ComputeEngine_Routes_GetRoute_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Routes_GetRoute_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Routes_GetRoute_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_ComputeEngine_Routes_GetRoute_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this GetRoute Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Routes_GetRoute_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_ComputeEngine_Routes_GetRoute_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the GetRoute Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Routes_GetRoute_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the GetRoute Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Routes_GetRoute_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this GetRoute input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_ComputeEngine_Routes_GetRoute_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_ComputeEngine_Routes_GetRoute_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this GetRoute Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Google_ComputeEngine_Routes_GetRoute_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this GetRoute Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Routes_GetRoute_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this GetRoute Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Routes_GetRoute_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Fields input for this GetRoute Choreo.
     *
     * @param string $value (optional, string) Comma-seperated list of fields you want to include in the response..
     * @return Google_ComputeEngine_Routes_GetRoute_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Project input for this GetRoute Choreo.
     *
     * @param string $value (required, string) The ID of a Google Compute project.
     * @return Google_ComputeEngine_Routes_GetRoute_Inputs For method chaining.
     */
    public function setProject($value)
    {
        return $this->set('Project', $value);
    }

    /**
     * Set the value for the RefreshToken input for this GetRoute Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Routes_GetRoute_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }

    /**
     * Set the value for the Route input for this GetRoute Choreo.
     *
     * @param string $value (required, string) The name of the route to retrieve.
     * @return Google_ComputeEngine_Routes_GetRoute_Inputs For method chaining.
     */
    public function setRoute($value)
    {
        return $this->set('Route', $value);
    }
}


/**
 * Execution object for the GetRoute Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Routes_GetRoute_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the GetRoute Choreo.
     *
     * @param Temboo_Session $session The session that owns this GetRoute execution.
     * @param Google_ComputeEngine_Routes_GetRoute $choreo The choreography object for this execution.
     * @param Google_ComputeEngine_Routes_GetRoute_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Routes_GetRoute_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Routes_GetRoute_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_ComputeEngine_Routes_GetRoute $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this GetRoute execution.
     *
     * @return Google_ComputeEngine_Routes_GetRoute_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this GetRoute execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_ComputeEngine_Routes_GetRoute_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_ComputeEngine_Routes_GetRoute_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the GetRoute Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Routes_GetRoute_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the GetRoute Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_ComputeEngine_Routes_GetRoute_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this GetRoute execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this GetRoute execution.
     *
     * @return string (json) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Creates a Route resource in the specified project.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Routes_InsertRoute extends Temboo_Choreography
{
    /**
     * Creates a Route resource in the specified project.
     *
     * @param Temboo_Session $session The session that owns this InsertRoute Choreo.
     * @return Google_ComputeEngine_Routes_InsertRoute New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/ComputeEngine/Routes/InsertRoute/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this InsertRoute Choreo.
     *
     * @param Google_ComputeEngine_Routes_InsertRoute_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Routes_InsertRoute_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Routes_InsertRoute_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_ComputeEngine_Routes_InsertRoute_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this InsertRoute Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Routes_InsertRoute_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_ComputeEngine_Routes_InsertRoute_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the InsertRoute Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Routes_InsertRoute_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the InsertRoute Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Routes_InsertRoute_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this InsertRoute input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_ComputeEngine_Routes_InsertRoute_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_ComputeEngine_Routes_InsertRoute_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the RouteResource input for this InsertRoute Choreo.
     *
     * @param string $value (required, json) A JSON string containing the route resource fields to set. Required properties include: destRange, name, network, priority, and at at least one nextHop property.
     * @return Google_ComputeEngine_Routes_InsertRoute_Inputs For method chaining.
     */
    public function setRouteResource($value)
    {
        return $this->set('RouteResource', $value);
    }

    /**
     * Set the value for the AccessToken input for this InsertRoute Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Google_ComputeEngine_Routes_InsertRoute_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this InsertRoute Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Routes_InsertRoute_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this InsertRoute Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Routes_InsertRoute_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Project input for this InsertRoute Choreo.
     *
     * @param string $value (required, string) The ID of a Google Compute project.
     * @return Google_ComputeEngine_Routes_InsertRoute_Inputs For method chaining.
     */
    public function setProject($value)
    {
        return $this->set('Project', $value);
    }

    /**
     * Set the value for the RefreshToken input for this InsertRoute Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Routes_InsertRoute_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }
}


/**
 * Execution object for the InsertRoute Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Routes_InsertRoute_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the InsertRoute Choreo.
     *
     * @param Temboo_Session $session The session that owns this InsertRoute execution.
     * @param Google_ComputeEngine_Routes_InsertRoute $choreo The choreography object for this execution.
     * @param Google_ComputeEngine_Routes_InsertRoute_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Routes_InsertRoute_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Routes_InsertRoute_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_ComputeEngine_Routes_InsertRoute $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this InsertRoute execution.
     *
     * @return Google_ComputeEngine_Routes_InsertRoute_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this InsertRoute execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_ComputeEngine_Routes_InsertRoute_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_ComputeEngine_Routes_InsertRoute_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the InsertRoute Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Routes_InsertRoute_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the InsertRoute Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_ComputeEngine_Routes_InsertRoute_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this InsertRoute execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this InsertRoute execution.
     *
     * @return string (json) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Retrieves a list of route resources available to the specified project.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Routes_ListRoutes extends Temboo_Choreography
{
    /**
     * Retrieves a list of route resources available to the specified project.
     *
     * @param Temboo_Session $session The session that owns this ListRoutes Choreo.
     * @return Google_ComputeEngine_Routes_ListRoutes New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/ComputeEngine/Routes/ListRoutes/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this ListRoutes Choreo.
     *
     * @param Google_ComputeEngine_Routes_ListRoutes_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Routes_ListRoutes_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Routes_ListRoutes_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_ComputeEngine_Routes_ListRoutes_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this ListRoutes Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Routes_ListRoutes_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_ComputeEngine_Routes_ListRoutes_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the ListRoutes Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Routes_ListRoutes_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the ListRoutes Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Routes_ListRoutes_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this ListRoutes input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_ComputeEngine_Routes_ListRoutes_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_ComputeEngine_Routes_ListRoutes_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this ListRoutes Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Google_ComputeEngine_Routes_ListRoutes_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this ListRoutes Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Routes_ListRoutes_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this ListRoutes Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Routes_ListRoutes_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Fields input for this ListRoutes Choreo.
     *
     * @param string $value (optional, string) Comma-seperated list of fields you want to include in the response.
     * @return Google_ComputeEngine_Routes_ListRoutes_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Filter input for this ListRoutes Choreo.
     *
     * @param string $value (optional, string) A filter expression for narrowing results in the form: {field_name} {comparison_string} {literal_string} (e.g. name eq default-route-1234). Comparison strings can be eq (equals) or ne (not equals).
     * @return Google_ComputeEngine_Routes_ListRoutes_Inputs For method chaining.
     */
    public function setFilter($value)
    {
        return $this->set('Filter', $value);
    }

    /**
     * Set the value for the MaxResults input for this ListRoutes Choreo.
     *
     * @param int $value (optional, integer) The maximum number of results to return.
     * @return Google_ComputeEngine_Routes_ListRoutes_Inputs For method chaining.
     */
    public function setMaxResults($value)
    {
        return $this->set('MaxResults', $value);
    }

    /**
     * Set the value for the PageToken input for this ListRoutes Choreo.
     *
     * @param string $value (optional, string) The "nextPageToken" found in the response which is used to page through results.
     * @return Google_ComputeEngine_Routes_ListRoutes_Inputs For method chaining.
     */
    public function setPageToken($value)
    {
        return $this->set('PageToken', $value);
    }

    /**
     * Set the value for the Project input for this ListRoutes Choreo.
     *
     * @param string $value (required, string) The ID of a Google Compute project.
     * @return Google_ComputeEngine_Routes_ListRoutes_Inputs For method chaining.
     */
    public function setProject($value)
    {
        return $this->set('Project', $value);
    }

    /**
     * Set the value for the RefreshToken input for this ListRoutes Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Routes_ListRoutes_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }
}


/**
 * Execution object for the ListRoutes Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Routes_ListRoutes_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the ListRoutes Choreo.
     *
     * @param Temboo_Session $session The session that owns this ListRoutes execution.
     * @param Google_ComputeEngine_Routes_ListRoutes $choreo The choreography object for this execution.
     * @param Google_ComputeEngine_Routes_ListRoutes_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Routes_ListRoutes_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Routes_ListRoutes_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_ComputeEngine_Routes_ListRoutes $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this ListRoutes execution.
     *
     * @return Google_ComputeEngine_Routes_ListRoutes_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this ListRoutes execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_ComputeEngine_Routes_ListRoutes_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_ComputeEngine_Routes_ListRoutes_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the ListRoutes Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Routes_ListRoutes_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the ListRoutes Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_ComputeEngine_Routes_ListRoutes_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this ListRoutes execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this ListRoutes execution.
     *
     * @return string (json) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Deletes a specified Snapshot resource.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Snapshots_DeleteSnapshot extends Temboo_Choreography
{
    /**
     * Deletes a specified Snapshot resource.
     *
     * @param Temboo_Session $session The session that owns this DeleteSnapshot Choreo.
     * @return Google_ComputeEngine_Snapshots_DeleteSnapshot New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/ComputeEngine/Snapshots/DeleteSnapshot/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this DeleteSnapshot Choreo.
     *
     * @param Google_ComputeEngine_Snapshots_DeleteSnapshot_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Snapshots_DeleteSnapshot_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Snapshots_DeleteSnapshot_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_ComputeEngine_Snapshots_DeleteSnapshot_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this DeleteSnapshot Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Snapshots_DeleteSnapshot_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_ComputeEngine_Snapshots_DeleteSnapshot_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the DeleteSnapshot Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Snapshots_DeleteSnapshot_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the DeleteSnapshot Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Snapshots_DeleteSnapshot_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this DeleteSnapshot input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_ComputeEngine_Snapshots_DeleteSnapshot_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_ComputeEngine_Snapshots_DeleteSnapshot_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this DeleteSnapshot Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Google_ComputeEngine_Snapshots_DeleteSnapshot_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this DeleteSnapshot Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Snapshots_DeleteSnapshot_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this DeleteSnapshot Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Snapshots_DeleteSnapshot_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Fields input for this DeleteSnapshot Choreo.
     *
     * @param string $value (optional, string) Comma-seperated list of fields you want to include in the response.
     * @return Google_ComputeEngine_Snapshots_DeleteSnapshot_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Project input for this DeleteSnapshot Choreo.
     *
     * @param string $value (required, string) The ID of a Google Compute project.
     * @return Google_ComputeEngine_Snapshots_DeleteSnapshot_Inputs For method chaining.
     */
    public function setProject($value)
    {
        return $this->set('Project', $value);
    }

    /**
     * Set the value for the RefreshToken input for this DeleteSnapshot Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Snapshots_DeleteSnapshot_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }

    /**
     * Set the value for the Snapshot input for this DeleteSnapshot Choreo.
     *
     * @param string $value (required, string) The name of the snapshot to delete.
     * @return Google_ComputeEngine_Snapshots_DeleteSnapshot_Inputs For method chaining.
     */
    public function setSnapshot($value)
    {
        return $this->set('Snapshot', $value);
    }
}


/**
 * Execution object for the DeleteSnapshot Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Snapshots_DeleteSnapshot_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the DeleteSnapshot Choreo.
     *
     * @param Temboo_Session $session The session that owns this DeleteSnapshot execution.
     * @param Google_ComputeEngine_Snapshots_DeleteSnapshot $choreo The choreography object for this execution.
     * @param Google_ComputeEngine_Snapshots_DeleteSnapshot_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Snapshots_DeleteSnapshot_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Snapshots_DeleteSnapshot_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_ComputeEngine_Snapshots_DeleteSnapshot $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this DeleteSnapshot execution.
     *
     * @return Google_ComputeEngine_Snapshots_DeleteSnapshot_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this DeleteSnapshot execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_ComputeEngine_Snapshots_DeleteSnapshot_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_ComputeEngine_Snapshots_DeleteSnapshot_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the DeleteSnapshot Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Snapshots_DeleteSnapshot_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the DeleteSnapshot Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_ComputeEngine_Snapshots_DeleteSnapshot_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this DeleteSnapshot execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this DeleteSnapshot execution.
     *
     * @return string (json) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Retrieves information about the specified Snapshot.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Snapshots_GetSnapshot extends Temboo_Choreography
{
    /**
     * Retrieves information about the specified Snapshot.
     *
     * @param Temboo_Session $session The session that owns this GetSnapshot Choreo.
     * @return Google_ComputeEngine_Snapshots_GetSnapshot New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/ComputeEngine/Snapshots/GetSnapshot/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this GetSnapshot Choreo.
     *
     * @param Google_ComputeEngine_Snapshots_GetSnapshot_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Snapshots_GetSnapshot_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Snapshots_GetSnapshot_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_ComputeEngine_Snapshots_GetSnapshot_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this GetSnapshot Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Snapshots_GetSnapshot_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_ComputeEngine_Snapshots_GetSnapshot_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the GetSnapshot Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Snapshots_GetSnapshot_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the GetSnapshot Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Snapshots_GetSnapshot_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this GetSnapshot input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_ComputeEngine_Snapshots_GetSnapshot_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_ComputeEngine_Snapshots_GetSnapshot_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this GetSnapshot Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Google_ComputeEngine_Snapshots_GetSnapshot_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this GetSnapshot Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Snapshots_GetSnapshot_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this GetSnapshot Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Snapshots_GetSnapshot_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Fields input for this GetSnapshot Choreo.
     *
     * @param string $value (optional, string) Comma-seperated list of fields you want to include in the response.
     * @return Google_ComputeEngine_Snapshots_GetSnapshot_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Project input for this GetSnapshot Choreo.
     *
     * @param string $value (required, string) The ID of a Google Compute project.
     * @return Google_ComputeEngine_Snapshots_GetSnapshot_Inputs For method chaining.
     */
    public function setProject($value)
    {
        return $this->set('Project', $value);
    }

    /**
     * Set the value for the RefreshToken input for this GetSnapshot Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Snapshots_GetSnapshot_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }

    /**
     * Set the value for the Snapshot input for this GetSnapshot Choreo.
     *
     * @param string $value (required, string) The name of the snapshot to retrieve.
     * @return Google_ComputeEngine_Snapshots_GetSnapshot_Inputs For method chaining.
     */
    public function setSnapshot($value)
    {
        return $this->set('Snapshot', $value);
    }
}


/**
 * Execution object for the GetSnapshot Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Snapshots_GetSnapshot_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the GetSnapshot Choreo.
     *
     * @param Temboo_Session $session The session that owns this GetSnapshot execution.
     * @param Google_ComputeEngine_Snapshots_GetSnapshot $choreo The choreography object for this execution.
     * @param Google_ComputeEngine_Snapshots_GetSnapshot_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Snapshots_GetSnapshot_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Snapshots_GetSnapshot_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_ComputeEngine_Snapshots_GetSnapshot $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this GetSnapshot execution.
     *
     * @return Google_ComputeEngine_Snapshots_GetSnapshot_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this GetSnapshot execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_ComputeEngine_Snapshots_GetSnapshot_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_ComputeEngine_Snapshots_GetSnapshot_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the GetSnapshot Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Snapshots_GetSnapshot_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the GetSnapshot Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_ComputeEngine_Snapshots_GetSnapshot_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this GetSnapshot execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this GetSnapshot execution.
     *
     * @return string (json) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Retrieves a list of persistent disk snapshot resources for the specified project.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Snapshots_ListSnapshots extends Temboo_Choreography
{
    /**
     * Retrieves a list of persistent disk snapshot resources for the specified project.
     *
     * @param Temboo_Session $session The session that owns this ListSnapshots Choreo.
     * @return Google_ComputeEngine_Snapshots_ListSnapshots New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/ComputeEngine/Snapshots/ListSnapshots/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this ListSnapshots Choreo.
     *
     * @param Google_ComputeEngine_Snapshots_ListSnapshots_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Snapshots_ListSnapshots_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Snapshots_ListSnapshots_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_ComputeEngine_Snapshots_ListSnapshots_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this ListSnapshots Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Snapshots_ListSnapshots_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_ComputeEngine_Snapshots_ListSnapshots_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the ListSnapshots Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Snapshots_ListSnapshots_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the ListSnapshots Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Snapshots_ListSnapshots_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this ListSnapshots input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_ComputeEngine_Snapshots_ListSnapshots_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_ComputeEngine_Snapshots_ListSnapshots_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this ListSnapshots Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Google_ComputeEngine_Snapshots_ListSnapshots_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this ListSnapshots Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Snapshots_ListSnapshots_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this ListSnapshots Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Snapshots_ListSnapshots_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Fields input for this ListSnapshots Choreo.
     *
     * @param string $value (optional, string) Comma-seperated list of fields you want to include in the response.
     * @return Google_ComputeEngine_Snapshots_ListSnapshots_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Filter input for this ListSnapshots Choreo.
     *
     * @param string $value (optional, string) A filter expression for narrowing results in the form: {field_name} {comparison_string} {literal_string} (e.g. name eq testsnapshot). Comparison strings can be eq (equals) or ne (not equals).
     * @return Google_ComputeEngine_Snapshots_ListSnapshots_Inputs For method chaining.
     */
    public function setFilter($value)
    {
        return $this->set('Filter', $value);
    }

    /**
     * Set the value for the MaxResults input for this ListSnapshots Choreo.
     *
     * @param int $value (optional, integer) The maximum number of results to return.
     * @return Google_ComputeEngine_Snapshots_ListSnapshots_Inputs For method chaining.
     */
    public function setMaxResults($value)
    {
        return $this->set('MaxResults', $value);
    }

    /**
     * Set the value for the PageToken input for this ListSnapshots Choreo.
     *
     * @param string $value (optional, string) The "nextPageToken" found in the response which is used to page through results.
     * @return Google_ComputeEngine_Snapshots_ListSnapshots_Inputs For method chaining.
     */
    public function setPageToken($value)
    {
        return $this->set('PageToken', $value);
    }

    /**
     * Set the value for the Project input for this ListSnapshots Choreo.
     *
     * @param string $value (required, string) The ID of a Google Compute project.
     * @return Google_ComputeEngine_Snapshots_ListSnapshots_Inputs For method chaining.
     */
    public function setProject($value)
    {
        return $this->set('Project', $value);
    }

    /**
     * Set the value for the RefreshToken input for this ListSnapshots Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Snapshots_ListSnapshots_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }
}


/**
 * Execution object for the ListSnapshots Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Snapshots_ListSnapshots_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the ListSnapshots Choreo.
     *
     * @param Temboo_Session $session The session that owns this ListSnapshots execution.
     * @param Google_ComputeEngine_Snapshots_ListSnapshots $choreo The choreography object for this execution.
     * @param Google_ComputeEngine_Snapshots_ListSnapshots_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Snapshots_ListSnapshots_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Snapshots_ListSnapshots_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_ComputeEngine_Snapshots_ListSnapshots $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this ListSnapshots execution.
     *
     * @return Google_ComputeEngine_Snapshots_ListSnapshots_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this ListSnapshots execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_ComputeEngine_Snapshots_ListSnapshots_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_ComputeEngine_Snapshots_ListSnapshots_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the ListSnapshots Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Snapshots_ListSnapshots_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the ListSnapshots Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_ComputeEngine_Snapshots_ListSnapshots_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this ListSnapshots execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this ListSnapshots execution.
     *
     * @return string (json) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Deletes the specified Zone Operation resource.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_ZoneOperations_DeleteZoneOperation extends Temboo_Choreography
{
    /**
     * Deletes the specified Zone Operation resource.
     *
     * @param Temboo_Session $session The session that owns this DeleteZoneOperation Choreo.
     * @return Google_ComputeEngine_ZoneOperations_DeleteZoneOperation New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/ComputeEngine/ZoneOperations/DeleteZoneOperation/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this DeleteZoneOperation Choreo.
     *
     * @param Google_ComputeEngine_ZoneOperations_DeleteZoneOperation_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_ZoneOperations_DeleteZoneOperation_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_ZoneOperations_DeleteZoneOperation_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_ComputeEngine_ZoneOperations_DeleteZoneOperation_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this DeleteZoneOperation Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_ZoneOperations_DeleteZoneOperation_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_ComputeEngine_ZoneOperations_DeleteZoneOperation_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the DeleteZoneOperation Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_ZoneOperations_DeleteZoneOperation_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the DeleteZoneOperation Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_ZoneOperations_DeleteZoneOperation_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this DeleteZoneOperation input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_ComputeEngine_ZoneOperations_DeleteZoneOperation_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_ComputeEngine_ZoneOperations_DeleteZoneOperation_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this DeleteZoneOperation Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Google_ComputeEngine_ZoneOperations_DeleteZoneOperation_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this DeleteZoneOperation Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_ZoneOperations_DeleteZoneOperation_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this DeleteZoneOperation Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_ZoneOperations_DeleteZoneOperation_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Fields input for this DeleteZoneOperation Choreo.
     *
     * @param string $value (optional, string) Comma-seperated list of fields you want to include in the response.
     * @return Google_ComputeEngine_ZoneOperations_DeleteZoneOperation_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Operation input for this DeleteZoneOperation Choreo.
     *
     * @param string $value (required, string) The name of the operation to delete.
     * @return Google_ComputeEngine_ZoneOperations_DeleteZoneOperation_Inputs For method chaining.
     */
    public function setOperation($value)
    {
        return $this->set('Operation', $value);
    }

    /**
     * Set the value for the Project input for this DeleteZoneOperation Choreo.
     *
     * @param string $value (required, string) The ID of a Google Compute project.
     * @return Google_ComputeEngine_ZoneOperations_DeleteZoneOperation_Inputs For method chaining.
     */
    public function setProject($value)
    {
        return $this->set('Project', $value);
    }

    /**
     * Set the value for the RefreshToken input for this DeleteZoneOperation Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_ZoneOperations_DeleteZoneOperation_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }

    /**
     * Set the value for the Zone input for this DeleteZoneOperation Choreo.
     *
     * @param string $value (required, string) The name of the zone associated with the operation being deleted.
     * @return Google_ComputeEngine_ZoneOperations_DeleteZoneOperation_Inputs For method chaining.
     */
    public function setZone($value)
    {
        return $this->set('Zone', $value);
    }
}


/**
 * Execution object for the DeleteZoneOperation Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_ZoneOperations_DeleteZoneOperation_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the DeleteZoneOperation Choreo.
     *
     * @param Temboo_Session $session The session that owns this DeleteZoneOperation execution.
     * @param Google_ComputeEngine_ZoneOperations_DeleteZoneOperation $choreo The choreography object for this execution.
     * @param Google_ComputeEngine_ZoneOperations_DeleteZoneOperation_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_ZoneOperations_DeleteZoneOperation_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_ZoneOperations_DeleteZoneOperation_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_ComputeEngine_ZoneOperations_DeleteZoneOperation $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this DeleteZoneOperation execution.
     *
     * @return Google_ComputeEngine_ZoneOperations_DeleteZoneOperation_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this DeleteZoneOperation execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_ComputeEngine_ZoneOperations_DeleteZoneOperation_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_ComputeEngine_ZoneOperations_DeleteZoneOperation_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the DeleteZoneOperation Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_ZoneOperations_DeleteZoneOperation_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the DeleteZoneOperation Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_ComputeEngine_ZoneOperations_DeleteZoneOperation_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this DeleteZoneOperation execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "ResponseStatusCode" output from this DeleteZoneOperation execution.
     *
     * @return int (integer) The response status code returned from Google. A 204 is expected for a successful delete operation.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponseStatusCode()
    {
        return $this->get('ResponseStatusCode');
    }
    /**
     * Retrieve the value for the "Response" output from this DeleteZoneOperation execution.
     *
     * @return string (json) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Retrieves information about the specified Zone Operation.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_ZoneOperations_GetZoneOperation extends Temboo_Choreography
{
    /**
     * Retrieves information about the specified Zone Operation.
     *
     * @param Temboo_Session $session The session that owns this GetZoneOperation Choreo.
     * @return Google_ComputeEngine_ZoneOperations_GetZoneOperation New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/ComputeEngine/ZoneOperations/GetZoneOperation/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this GetZoneOperation Choreo.
     *
     * @param Google_ComputeEngine_ZoneOperations_GetZoneOperation_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_ZoneOperations_GetZoneOperation_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_ZoneOperations_GetZoneOperation_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_ComputeEngine_ZoneOperations_GetZoneOperation_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this GetZoneOperation Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_ZoneOperations_GetZoneOperation_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_ComputeEngine_ZoneOperations_GetZoneOperation_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the GetZoneOperation Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_ZoneOperations_GetZoneOperation_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the GetZoneOperation Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_ZoneOperations_GetZoneOperation_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this GetZoneOperation input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_ComputeEngine_ZoneOperations_GetZoneOperation_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_ComputeEngine_ZoneOperations_GetZoneOperation_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this GetZoneOperation Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Google_ComputeEngine_ZoneOperations_GetZoneOperation_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this GetZoneOperation Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_ZoneOperations_GetZoneOperation_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this GetZoneOperation Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_ZoneOperations_GetZoneOperation_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Fields input for this GetZoneOperation Choreo.
     *
     * @param string $value (optional, string) Comma-seperated list of fields you want to include in the response.
     * @return Google_ComputeEngine_ZoneOperations_GetZoneOperation_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Operation input for this GetZoneOperation Choreo.
     *
     * @param string $value (required, string) The name of the operation to retrieve.
     * @return Google_ComputeEngine_ZoneOperations_GetZoneOperation_Inputs For method chaining.
     */
    public function setOperation($value)
    {
        return $this->set('Operation', $value);
    }

    /**
     * Set the value for the Project input for this GetZoneOperation Choreo.
     *
     * @param string $value (required, string) The ID of a Google Compute project.
     * @return Google_ComputeEngine_ZoneOperations_GetZoneOperation_Inputs For method chaining.
     */
    public function setProject($value)
    {
        return $this->set('Project', $value);
    }

    /**
     * Set the value for the RefreshToken input for this GetZoneOperation Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_ZoneOperations_GetZoneOperation_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }

    /**
     * Set the value for the Zone input for this GetZoneOperation Choreo.
     *
     * @param string $value (required, string) The name of the zone associated with the operation being retrieved.
     * @return Google_ComputeEngine_ZoneOperations_GetZoneOperation_Inputs For method chaining.
     */
    public function setZone($value)
    {
        return $this->set('Zone', $value);
    }
}


/**
 * Execution object for the GetZoneOperation Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_ZoneOperations_GetZoneOperation_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the GetZoneOperation Choreo.
     *
     * @param Temboo_Session $session The session that owns this GetZoneOperation execution.
     * @param Google_ComputeEngine_ZoneOperations_GetZoneOperation $choreo The choreography object for this execution.
     * @param Google_ComputeEngine_ZoneOperations_GetZoneOperation_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_ZoneOperations_GetZoneOperation_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_ZoneOperations_GetZoneOperation_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_ComputeEngine_ZoneOperations_GetZoneOperation $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this GetZoneOperation execution.
     *
     * @return Google_ComputeEngine_ZoneOperations_GetZoneOperation_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this GetZoneOperation execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_ComputeEngine_ZoneOperations_GetZoneOperation_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_ComputeEngine_ZoneOperations_GetZoneOperation_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the GetZoneOperation Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_ZoneOperations_GetZoneOperation_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the GetZoneOperation Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_ComputeEngine_ZoneOperations_GetZoneOperation_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this GetZoneOperation execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this GetZoneOperation execution.
     *
     * @return string (json) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Retrieves the list of Zone Operation resources contained within the specified Zone.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_ZoneOperations_ListZoneOperations extends Temboo_Choreography
{
    /**
     * Retrieves the list of Zone Operation resources contained within the specified Zone.
     *
     * @param Temboo_Session $session The session that owns this ListZoneOperations Choreo.
     * @return Google_ComputeEngine_ZoneOperations_ListZoneOperations New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/ComputeEngine/ZoneOperations/ListZoneOperations/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this ListZoneOperations Choreo.
     *
     * @param Google_ComputeEngine_ZoneOperations_ListZoneOperations_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_ZoneOperations_ListZoneOperations_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_ZoneOperations_ListZoneOperations_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_ComputeEngine_ZoneOperations_ListZoneOperations_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this ListZoneOperations Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_ZoneOperations_ListZoneOperations_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_ComputeEngine_ZoneOperations_ListZoneOperations_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the ListZoneOperations Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_ZoneOperations_ListZoneOperations_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the ListZoneOperations Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_ZoneOperations_ListZoneOperations_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this ListZoneOperations input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_ComputeEngine_ZoneOperations_ListZoneOperations_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_ComputeEngine_ZoneOperations_ListZoneOperations_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this ListZoneOperations Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Google_ComputeEngine_ZoneOperations_ListZoneOperations_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this ListZoneOperations Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_ZoneOperations_ListZoneOperations_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this ListZoneOperations Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_ZoneOperations_ListZoneOperations_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Fields input for this ListZoneOperations Choreo.
     *
     * @param string $value (optional, string) Comma-seperated list of fields you want to include in the response.
     * @return Google_ComputeEngine_ZoneOperations_ListZoneOperations_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Filter input for this ListZoneOperations Choreo.
     *
     * @param string $value (optional, string) A filter expression for narrowing results in the form: {field_name} {comparison_string} {literal_string} (e.g. name eq europe-west1-a). Comparison strings can be eq (equals) or ne (not equals).
     * @return Google_ComputeEngine_ZoneOperations_ListZoneOperations_Inputs For method chaining.
     */
    public function setFilter($value)
    {
        return $this->set('Filter', $value);
    }

    /**
     * Set the value for the MaxResults input for this ListZoneOperations Choreo.
     *
     * @param int $value (optional, integer) The maximum number of results to return.
     * @return Google_ComputeEngine_ZoneOperations_ListZoneOperations_Inputs For method chaining.
     */
    public function setMaxResults($value)
    {
        return $this->set('MaxResults', $value);
    }

    /**
     * Set the value for the PageToken input for this ListZoneOperations Choreo.
     *
     * @param string $value (optional, string) The "nextPageToken" found in the response which is used to page through results.
     * @return Google_ComputeEngine_ZoneOperations_ListZoneOperations_Inputs For method chaining.
     */
    public function setPageToken($value)
    {
        return $this->set('PageToken', $value);
    }

    /**
     * Set the value for the Project input for this ListZoneOperations Choreo.
     *
     * @param string $value (required, string) The ID of a Google Compute project.
     * @return Google_ComputeEngine_ZoneOperations_ListZoneOperations_Inputs For method chaining.
     */
    public function setProject($value)
    {
        return $this->set('Project', $value);
    }

    /**
     * Set the value for the RefreshToken input for this ListZoneOperations Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_ZoneOperations_ListZoneOperations_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }

    /**
     * Set the value for the Zone input for this ListZoneOperations Choreo.
     *
     * @param string $value (required, string) The name of the zone that contains the operation resources to retrieve.
     * @return Google_ComputeEngine_ZoneOperations_ListZoneOperations_Inputs For method chaining.
     */
    public function setZone($value)
    {
        return $this->set('Zone', $value);
    }
}


/**
 * Execution object for the ListZoneOperations Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_ZoneOperations_ListZoneOperations_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the ListZoneOperations Choreo.
     *
     * @param Temboo_Session $session The session that owns this ListZoneOperations execution.
     * @param Google_ComputeEngine_ZoneOperations_ListZoneOperations $choreo The choreography object for this execution.
     * @param Google_ComputeEngine_ZoneOperations_ListZoneOperations_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_ZoneOperations_ListZoneOperations_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_ZoneOperations_ListZoneOperations_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_ComputeEngine_ZoneOperations_ListZoneOperations $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this ListZoneOperations execution.
     *
     * @return Google_ComputeEngine_ZoneOperations_ListZoneOperations_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this ListZoneOperations execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_ComputeEngine_ZoneOperations_ListZoneOperations_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_ComputeEngine_ZoneOperations_ListZoneOperations_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the ListZoneOperations Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_ZoneOperations_ListZoneOperations_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the ListZoneOperations Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_ComputeEngine_ZoneOperations_ListZoneOperations_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this ListZoneOperations execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this ListZoneOperations execution.
     *
     * @return string (json) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Retrieves information about the specified Zone.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Zones_GetZone extends Temboo_Choreography
{
    /**
     * Retrieves information about the specified Zone.
     *
     * @param Temboo_Session $session The session that owns this GetZone Choreo.
     * @return Google_ComputeEngine_Zones_GetZone New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/ComputeEngine/Zones/GetZone/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this GetZone Choreo.
     *
     * @param Google_ComputeEngine_Zones_GetZone_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Zones_GetZone_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Zones_GetZone_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_ComputeEngine_Zones_GetZone_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this GetZone Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Zones_GetZone_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_ComputeEngine_Zones_GetZone_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the GetZone Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Zones_GetZone_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the GetZone Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Zones_GetZone_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this GetZone input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_ComputeEngine_Zones_GetZone_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_ComputeEngine_Zones_GetZone_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this GetZone Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Google_ComputeEngine_Zones_GetZone_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this GetZone Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Zones_GetZone_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this GetZone Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Zones_GetZone_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Fields input for this GetZone Choreo.
     *
     * @param string $value (optional, string) Comma-seperated list of fields you want to include in the response.
     * @return Google_ComputeEngine_Zones_GetZone_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Project input for this GetZone Choreo.
     *
     * @param string $value (required, string) The ID of a Google Compute project.
     * @return Google_ComputeEngine_Zones_GetZone_Inputs For method chaining.
     */
    public function setProject($value)
    {
        return $this->set('Project', $value);
    }

    /**
     * Set the value for the RefreshToken input for this GetZone Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Zones_GetZone_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }

    /**
     * Set the value for the Zone input for this GetZone Choreo.
     *
     * @param string $value (required, string) The name of the zone to retrieve.
     * @return Google_ComputeEngine_Zones_GetZone_Inputs For method chaining.
     */
    public function setZone($value)
    {
        return $this->set('Zone', $value);
    }
}


/**
 * Execution object for the GetZone Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Zones_GetZone_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the GetZone Choreo.
     *
     * @param Temboo_Session $session The session that owns this GetZone execution.
     * @param Google_ComputeEngine_Zones_GetZone $choreo The choreography object for this execution.
     * @param Google_ComputeEngine_Zones_GetZone_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Zones_GetZone_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Zones_GetZone_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_ComputeEngine_Zones_GetZone $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this GetZone execution.
     *
     * @return Google_ComputeEngine_Zones_GetZone_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this GetZone execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_ComputeEngine_Zones_GetZone_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_ComputeEngine_Zones_GetZone_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the GetZone Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Zones_GetZone_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the GetZone Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_ComputeEngine_Zones_GetZone_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this GetZone execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this GetZone execution.
     *
     * @return string (json) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Retrieves the list of Zone resources for the specified project.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Zones_ListZones extends Temboo_Choreography
{
    /**
     * Retrieves the list of Zone resources for the specified project.
     *
     * @param Temboo_Session $session The session that owns this ListZones Choreo.
     * @return Google_ComputeEngine_Zones_ListZones New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/ComputeEngine/Zones/ListZones/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this ListZones Choreo.
     *
     * @param Google_ComputeEngine_Zones_ListZones_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Zones_ListZones_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Zones_ListZones_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_ComputeEngine_Zones_ListZones_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this ListZones Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Zones_ListZones_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_ComputeEngine_Zones_ListZones_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the ListZones Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Zones_ListZones_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the ListZones Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_ComputeEngine_Zones_ListZones_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this ListZones input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_ComputeEngine_Zones_ListZones_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_ComputeEngine_Zones_ListZones_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this ListZones Choreo.
     *
     * @param string $value (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
     * @return Google_ComputeEngine_Zones_ListZones_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this ListZones Choreo.
     *
     * @param string $value (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Zones_ListZones_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this ListZones Choreo.
     *
     * @param string $value (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Zones_ListZones_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Fields input for this ListZones Choreo.
     *
     * @param string $value (optional, string) Comma-seperated list of fields you want to include in the response.
     * @return Google_ComputeEngine_Zones_ListZones_Inputs For method chaining.
     */
    public function setFields($value)
    {
        return $this->set('Fields', $value);
    }

    /**
     * Set the value for the Filter input for this ListZones Choreo.
     *
     * @param string $value (optional, string) A filter expression for narrowing results in the form: {field_name} {comparison_string} {literal_string} (e.g. name eq europe-west1-a). Comparison strings can be eq (equals) or ne (not equals).
     * @return Google_ComputeEngine_Zones_ListZones_Inputs For method chaining.
     */
    public function setFilter($value)
    {
        return $this->set('Filter', $value);
    }

    /**
     * Set the value for the MaxResults input for this ListZones Choreo.
     *
     * @param int $value (optional, integer) The maximum number of results to return.
     * @return Google_ComputeEngine_Zones_ListZones_Inputs For method chaining.
     */
    public function setMaxResults($value)
    {
        return $this->set('MaxResults', $value);
    }

    /**
     * Set the value for the PageToken input for this ListZones Choreo.
     *
     * @param string $value (optional, string) The "nextPageToken" found in the response which is used to page through results.
     * @return Google_ComputeEngine_Zones_ListZones_Inputs For method chaining.
     */
    public function setPageToken($value)
    {
        return $this->set('PageToken', $value);
    }

    /**
     * Set the value for the Project input for this ListZones Choreo.
     *
     * @param string $value (required, string) The ID of a Google Compute project.
     * @return Google_ComputeEngine_Zones_ListZones_Inputs For method chaining.
     */
    public function setProject($value)
    {
        return $this->set('Project', $value);
    }

    /**
     * Set the value for the RefreshToken input for this ListZones Choreo.
     *
     * @param string $value (conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
     * @return Google_ComputeEngine_Zones_ListZones_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }
}


/**
 * Execution object for the ListZones Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Zones_ListZones_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the ListZones Choreo.
     *
     * @param Temboo_Session $session The session that owns this ListZones execution.
     * @param Google_ComputeEngine_Zones_ListZones $choreo The choreography object for this execution.
     * @param Google_ComputeEngine_Zones_ListZones_Inputs|array $inputs (optional) Inputs as Google_ComputeEngine_Zones_ListZones_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_ComputeEngine_Zones_ListZones_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_ComputeEngine_Zones_ListZones $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this ListZones execution.
     *
     * @return Google_ComputeEngine_Zones_ListZones_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this ListZones execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_ComputeEngine_Zones_ListZones_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_ComputeEngine_Zones_ListZones_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the ListZones Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_ComputeEngine_Zones_ListZones_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the ListZones Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_ComputeEngine_Zones_ListZones_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "NewAccessToken" output from this ListZones execution.
     *
     * @return string (string) Contains a new AccessToken when the RefreshToken is provided.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getNewAccessToken()
    {
        return $this->get('NewAccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this ListZones execution.
     *
     * @return string (json) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Create a new contact.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_Contacts_CreateContact extends Temboo_Choreography
{
    /**
     * Create a new contact.
     *
     * @param Temboo_Session $session The session that owns this CreateContact Choreo.
     * @return Google_Contacts_CreateContact New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/Contacts/CreateContact/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this CreateContact Choreo.
     *
     * @param Google_Contacts_CreateContact_Inputs|array $inputs (optional) Inputs as Google_Contacts_CreateContact_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_Contacts_CreateContact_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_Contacts_CreateContact_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this CreateContact Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_Contacts_CreateContact_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_Contacts_CreateContact_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the CreateContact Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_Contacts_CreateContact_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the CreateContact Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_Contacts_CreateContact_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this CreateContact input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_Contacts_CreateContact_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_Contacts_CreateContact_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this CreateContact Choreo.
     *
     * @param string $value (optional, string) The access token retrieved in the last step of the OAuth process. Access tokens that are expired will be refreshed and returned in the Choreo output.
     * @return Google_Contacts_CreateContact_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this CreateContact Choreo.
     *
     * @param string $value (conditional, string) The OAuth client ID provided by Google when you register your application.
     * @return Google_Contacts_CreateContact_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this CreateContact Choreo.
     *
     * @param string $value (conditional, string) The OAuth client secret provided by Google when you registered your application.
     * @return Google_Contacts_CreateContact_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Email input for this CreateContact Choreo.
     *
     * @param string $value (conditional, string) The new contact's email address.
     * @return Google_Contacts_CreateContact_Inputs For method chaining.
     */
    public function setEmail($value)
    {
        return $this->set('Email', $value);
    }

    /**
     * Set the value for the FirstName input for this CreateContact Choreo.
     *
     * @param string $value (conditional, string) The new contact's first name.
     * @return Google_Contacts_CreateContact_Inputs For method chaining.
     */
    public function setFirstName($value)
    {
        return $this->set('FirstName', $value);
    }

    /**
     * Set the value for the LastName input for this CreateContact Choreo.
     *
     * @param string $value (conditional, string) The new contact's last name.
     * @return Google_Contacts_CreateContact_Inputs For method chaining.
     */
    public function setLastName($value)
    {
        return $this->set('LastName', $value);
    }

    /**
     * Set the value for the Phone input for this CreateContact Choreo.
     *
     * @param string $value (optional, string) The phone number for the new contact. It's best to use the "(555) 123-4567" format.
     * @return Google_Contacts_CreateContact_Inputs For method chaining.
     */
    public function setPhone($value)
    {
        return $this->set('Phone', $value);
    }

    /**
     * Set the value for the RefreshToken input for this CreateContact Choreo.
     *
     * @param string $value (conditional, string) The refresh token retrieved in the last step of the OAuth process. This is used when an access token is expired or not provided.
     * @return Google_Contacts_CreateContact_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }
}


/**
 * Execution object for the CreateContact Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_Contacts_CreateContact_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the CreateContact Choreo.
     *
     * @param Temboo_Session $session The session that owns this CreateContact execution.
     * @param Google_Contacts_CreateContact $choreo The choreography object for this execution.
     * @param Google_Contacts_CreateContact_Inputs|array $inputs (optional) Inputs as Google_Contacts_CreateContact_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_Contacts_CreateContact_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_Contacts_CreateContact $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this CreateContact execution.
     *
     * @return Google_Contacts_CreateContact_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this CreateContact execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_Contacts_CreateContact_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_Contacts_CreateContact_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the CreateContact Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_Contacts_CreateContact_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the CreateContact Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_Contacts_CreateContact_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "AccessToken" output from this CreateContact execution.
     *
     * @return string (optional, string) The access token retrieved in the last step of the OAuth process. Access tokens that are expired will be refreshed and returned in the Choreo output.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getAccessToken()
    {
        return $this->get('AccessToken');
    }
    /**
     * Retrieve the value for the "ContactID" output from this CreateContact execution.
     *
     * @return string (string) The unique ID supplied by Google for the new user.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getContactID()
    {
        return $this->get('ContactID');
    }
    /**
     * Retrieve the value for the "Response" output from this CreateContact execution.
     *
     * @return string (xml) The response from the API.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Deletes a specified contact.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_Contacts_DeleteContact extends Temboo_Choreography
{
    /**
     * Deletes a specified contact.
     *
     * @param Temboo_Session $session The session that owns this DeleteContact Choreo.
     * @return Google_Contacts_DeleteContact New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/Contacts/DeleteContact/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this DeleteContact Choreo.
     *
     * @param Google_Contacts_DeleteContact_Inputs|array $inputs (optional) Inputs as Google_Contacts_DeleteContact_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_Contacts_DeleteContact_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_Contacts_DeleteContact_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this DeleteContact Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_Contacts_DeleteContact_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_Contacts_DeleteContact_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the DeleteContact Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_Contacts_DeleteContact_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the DeleteContact Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_Contacts_DeleteContact_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this DeleteContact input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_Contacts_DeleteContact_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_Contacts_DeleteContact_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this DeleteContact Choreo.
     *
     * @param string $value (optional, string) The access token retrieved in the last step of the OAuth process. Access tokens that are expired will be refreshed and returned in the Choreo output.
     * @return Google_Contacts_DeleteContact_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this DeleteContact Choreo.
     *
     * @param string $value (required, string) The OAuth client ID provided by Google when you register your application.
     * @return Google_Contacts_DeleteContact_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this DeleteContact Choreo.
     *
     * @param string $value (required, string) The OAuth client secret provided by Google when you registered your application.
     * @return Google_Contacts_DeleteContact_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the ContactID input for this DeleteContact Choreo.
     *
     * @param string $value (required, string) The unique ID string for the contact you want to delete.
     * @return Google_Contacts_DeleteContact_Inputs For method chaining.
     */
    public function setContactID($value)
    {
        return $this->set('ContactID', $value);
    }

    /**
     * Set the value for the RefreshToken input for this DeleteContact Choreo.
     *
     * @param string $value (required, string) The refresh token retrieved in the last step of the OAuth process. This is used when an access token is expired or not provided.
     * @return Google_Contacts_DeleteContact_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }
}


/**
 * Execution object for the DeleteContact Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_Contacts_DeleteContact_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the DeleteContact Choreo.
     *
     * @param Temboo_Session $session The session that owns this DeleteContact execution.
     * @param Google_Contacts_DeleteContact $choreo The choreography object for this execution.
     * @param Google_Contacts_DeleteContact_Inputs|array $inputs (optional) Inputs as Google_Contacts_DeleteContact_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_Contacts_DeleteContact_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_Contacts_DeleteContact $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this DeleteContact execution.
     *
     * @return Google_Contacts_DeleteContact_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this DeleteContact execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_Contacts_DeleteContact_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_Contacts_DeleteContact_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the DeleteContact Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_Contacts_DeleteContact_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the DeleteContact Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_Contacts_DeleteContact_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "AccessToken" output from this DeleteContact execution.
     *
     * @return string (optional, string) The access token retrieved in the last step of the OAuth process. Access tokens that are expired will be refreshed and returned in the Choreo output.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getAccessToken()
    {
        return $this->get('AccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this DeleteContact execution.
     *
     * @return string The response from Google. No content is returned for a successful delete request.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Retrieve data for all contacts in an account.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_Contacts_GetAllContacts extends Temboo_Choreography
{
    /**
     * Retrieve data for all contacts in an account.
     *
     * @param Temboo_Session $session The session that owns this GetAllContacts Choreo.
     * @return Google_Contacts_GetAllContacts New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/Contacts/GetAllContacts/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this GetAllContacts Choreo.
     *
     * @param Google_Contacts_GetAllContacts_Inputs|array $inputs (optional) Inputs as Google_Contacts_GetAllContacts_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_Contacts_GetAllContacts_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_Contacts_GetAllContacts_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this GetAllContacts Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_Contacts_GetAllContacts_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_Contacts_GetAllContacts_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the GetAllContacts Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_Contacts_GetAllContacts_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the GetAllContacts Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_Contacts_GetAllContacts_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this GetAllContacts input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_Contacts_GetAllContacts_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_Contacts_GetAllContacts_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this GetAllContacts Choreo.
     *
     * @param string $value (optional, string) The access token retrieved in the last step of the OAuth process. Access tokens that are expired will be refreshed and returned in the Choreo output.
     * @return Google_Contacts_GetAllContacts_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this GetAllContacts Choreo.
     *
     * @param string $value (required, string) The client ID provided by Google when you register your application.
     * @return Google_Contacts_GetAllContacts_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this GetAllContacts Choreo.
     *
     * @param string $value (required, string) The client secret provided by Google when you registered your application.
     * @return Google_Contacts_GetAllContacts_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the Group input for this GetAllContacts Choreo.
     *
     * @param string $value (optional, string) Constrains the results to only the contacts belonging to the group specified. The value of this parameter specifies group ID.
     * @return Google_Contacts_GetAllContacts_Inputs For method chaining.
     */
    public function setGroup($value)
    {
        return $this->set('Group', $value);
    }

    /**
     * Set the value for the MaxResults input for this GetAllContacts Choreo.
     *
     * @param int $value (optional, integer) The maximum number of entries to return.
     * @return Google_Contacts_GetAllContacts_Inputs For method chaining.
     */
    public function setMaxResults($value)
    {
        return $this->set('MaxResults', $value);
    }

    /**
     * Set the value for the RefreshToken input for this GetAllContacts Choreo.
     *
     * @param string $value (required, string) The refresh token retrieved in the last step of the OAuth process. This is used when an access token is expired or not provided.
     * @return Google_Contacts_GetAllContacts_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }

    /**
     * Set the value for the SortOrder input for this GetAllContacts Choreo.
     *
     * @param string $value (optional, string) Sorting order direction. Can be either ascending or descending.
     * @return Google_Contacts_GetAllContacts_Inputs For method chaining.
     */
    public function setSortOrder($value)
    {
        return $this->set('SortOrder', $value);
    }

    /**
     * Set the value for the StartIndex input for this GetAllContacts Choreo.
     *
     * @param int $value (optional, integer) The index of the first result to be retrieved (for paging).
     * @return Google_Contacts_GetAllContacts_Inputs For method chaining.
     */
    public function setStartIndex($value)
    {
        return $this->set('StartIndex', $value);
    }

    /**
     * Set the value for the UpdatedMin input for this GetAllContacts Choreo.
     *
     * @param string $value (optional, date) The lower bound on entry update dates to filter by (e.g., 2015-01-16T00:00:00).
     * @return Google_Contacts_GetAllContacts_Inputs For method chaining.
     */
    public function setUpdatedMin($value)
    {
        return $this->set('UpdatedMin', $value);
    }

    /**
     * Set the value for the UserEmail input for this GetAllContacts Choreo.
     *
     * @param string $value (optional, string) The email address of the user whose contacts you want to retrieve. Defaults to "default," or the user whose OAuth access token is passed.
     * @return Google_Contacts_GetAllContacts_Inputs For method chaining.
     */
    public function setUserEmail($value)
    {
        return $this->set('UserEmail', $value);
    }
}


/**
 * Execution object for the GetAllContacts Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_Contacts_GetAllContacts_Execution extends Temboo_Choreography_Execution
{
    /**
     * Execution object for the GetAllContacts Choreo.
     *
     * @param Temboo_Session $session The session that owns this GetAllContacts execution.
     * @param Google_Contacts_GetAllContacts $choreo The choreography object for this execution.
     * @param Google_Contacts_GetAllContacts_Inputs|array $inputs (optional) Inputs as Google_Contacts_GetAllContacts_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_Contacts_GetAllContacts_Execution New execution.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     */
    public function __construct(Temboo_Session $session, Google_Contacts_GetAllContacts $choreo, $inputs = array(), $async = false, $store_results = true)
    {
        parent::__construct($session, $choreo, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new results object.
     *
     * Includes getters appropriate for this GetAllContacts execution.
     *
     * @return Google_Contacts_GetAllContacts_Results New results object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occurred in asynchronous execution.
     * @throws Temboo_Exception_Notfound if execution does not exist.
     * @throws Temboo_Exception if result request fails.
     */
    public function getResults()
    {
        return parent::getResults();
    }

    /**
     * Wraps results in appropriate results class for this GetAllContacts execution.
     *
     * @param array $outputs Associative array of output names and values.
     * @return Google_Contacts_GetAllContacts_Results New results object.
     */
    protected function wrapResults($outputs)
    {
        return new Google_Contacts_GetAllContacts_Results($outputs);
    }
}


/**
 * Results object with appropriate getters for the GetAllContacts Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_Contacts_GetAllContacts_Results extends Temboo_Results
{
    /**
     * Results object with appropriate getters for the GetAllContacts Choreo.
     *
     * @param array $outputs (optional) Associative array of output names and values.
     * @return Google_Contacts_GetAllContacts_Results New instance.
     * @throws Temboo_Exception if provided output set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($outputs = array())
    {
        parent::__construct($outputs);
    }
    /**
     * Retrieve the value for the "AccessToken" output from this GetAllContacts execution.
     *
     * @return string (optional, string) The access token retrieved in the last step of the OAuth process. Access tokens that are expired will be refreshed and returned in the Choreo output.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getAccessToken()
    {
        return $this->get('AccessToken');
    }
    /**
     * Retrieve the value for the "Response" output from this GetAllContacts execution.
     *
     * @return string (xml) The response from Google.
     * @throws Temboo_Exception_Notfound if output does not exist. (Note an empty response is considered valid.)
     */
    public function getResponse()
    {
        return $this->get('Response');
    }
}

/**
 * Retrieve data for all groups in an account.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_Contacts_GetAllGroups extends Temboo_Choreography
{
    /**
     * Retrieve data for all groups in an account.
     *
     * @param Temboo_Session $session The session that owns this GetAllGroups Choreo.
     * @return Google_Contacts_GetAllGroups New instance.
     */
    public function __construct(Temboo_Session $session)
    {
        parent::__construct($session, '/Library/Google/Contacts/GetAllGroups/');
    }

    /**
     * Executes this Choreo.
     *
     * Execution object provides access to results appropriate for this GetAllGroups Choreo.
     *
     * @param Google_Contacts_GetAllGroups_Inputs|array $inputs (optional) Inputs as Google_Contacts_GetAllGroups_Inputs or associative array.
     * @param bool $async Whether to execute in asynchronous mode. Default false.
     * @param bool $store_results Whether to store results of asynchronous execution. Default true.
     * @return Google_Contacts_GetAllGroups_Execution New execution object.
     * @throws Temboo_Exception_Authentication if session authentication fails.
     * @throws Temboo_Exception_Execution if runtime errors occur in synchronous execution or execution fails to start. NOT thrown for post-launch errors in asynchronous execution -- check status or results to determine asynchronous success.
     * @throws Temboo_Exception_Notfound if choreography does not exist.
     * @throws Temboo_Exception if execution request fails.
     */
    public function execute($inputs = array(), $async = false, $store_results = true)
    {
        return new Google_Contacts_GetAllGroups_Execution($this->session, $this, $inputs, $async, $store_results);
    }

    /**
     * Obtains a new inputs object.
     *
     * Includes setters appropriate for this GetAllGroups Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_Contacts_GetAllGroups_Inputs New inputs object.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function newInputs($inputs = array())
    {
        return new Google_Contacts_GetAllGroups_Inputs($inputs);
    }
}


/**
 * Inputs object with appropriate setters for the GetAllGroups Choreo.
 *
 * @package Temboo
 * @subpackage Google
 */
class Google_Contacts_GetAllGroups_Inputs extends Temboo_Inputs
{
   /**
     * Inputs object with appropriate setters for the GetAllGroups Choreo.
     *
     * @param array $inputs (optional) Associative array of input names and values.
     * @return Google_Contacts_GetAllGroups_Inputs New instance.
     * @throws Temboo_Exception if provided input set is invalid. (Note an empty set is considered valid.)
     */
    public function __construct($inputs = array())
    {
        parent::__construct($inputs);
    }

    /**
     * Set arbitrary input this GetAllGroups input set.
     *
     * Input names are case sensitive.
     *
     * @param string $name Input name.
     * @param string $value Input value.
     * @return Google_Contacts_GetAllGroups_Inputs For method chaining.
     */
    public function set($name, $value)
    {
        return parent::set($name, $value);
    }

    /**
     * Set credential
     *
     * @param string $credentialName The name of a credential in your account specifying presets for this set of inputs.
     * @return Google_Contacts_GetAllGroups_Inputs For method chaining.
     */
    public function setCredential($credentialName)
    {
        return parent::setCredential($credentialName);
    }

    /**
     * Set the value for the AccessToken input for this GetAllGroups Choreo.
     *
     * @param string $value (optional, string) The access token retrieved in the last step of the OAuth process. Access tokens that are expired will be refreshed and returned in the Choreo output.
     * @return Google_Contacts_GetAllGroups_Inputs For method chaining.
     */
    public function setAccessToken($value)
    {
        return $this->set('AccessToken', $value);
    }

    /**
     * Set the value for the ClientID input for this GetAllGroups Choreo.
     *
     * @param string $value (required, string) The OAuth client ID provided by Google when you register your application.
     * @return Google_Contacts_GetAllGroups_Inputs For method chaining.
     */
    public function setClientID($value)
    {
        return $this->set('ClientID', $value);
    }

    /**
     * Set the value for the ClientSecret input for this GetAllGroups Choreo.
     *
     * @param string $value (required, string) The OAuth client secret provided by Google when you registered your application.
     * @return Google_Contacts_GetAllGroups_Inputs For method chaining.
     */
    public function setClientSecret($value)
    {
        return $this->set('ClientSecret', $value);
    }

    /**
     * Set the value for the MaxResults input for this GetAllGroups Choreo.
     *
     * @param int $value (optional, integer) The maximum number of entries to return.
     * @return Google_Contacts_GetAllGroups_Inputs For method chaining.
     */
    public function setMaxResults($value)
    {
        return $this->set('MaxResults', $value);
    }

    /**
     * Set the value for the RefreshToken input for this GetAllGroups Choreo.
     *
     * @param string $value (required, string) The refresh token retrieved in the last step of the OAuth process. This is used when an access token is expired or not provided.
     * @return Google_Contacts_GetAllGroups_Inputs For method chaining.
     */
    public function setRefreshToken($value)
    {
        return $this->set('RefreshToken', $value);
    }

    /**
     * Set the value for the StartIndex input for this GetAllGroups Choreo.
     *
     * @param int $value (optional, integer) The index of the first result to be retrieved (for paging).
     * @return Google