/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
 */
 var tembooSession = require("./temboosession.js");

var Choreography = function(session, choreoUri) {
    var jsClientVersion;
    var session = session;
    var uri = choreoUri;

    var getPath = function() {
        return [session.getBasePath(), "choreos", uri].join("/");
    }

    this.setJSClientVersion = function(versionString){
        jsClientVersion = versionString;
    }

    this._execute = function(inputSet, formatter, callback, errorCallback) {
        if (!inputSet) {
            inputSet = new InputSet();
        }
        var params = {};
        var body = inputSet.formatInputs();
        var path = getPath();
        session.postRequest(path, params, body, jsClientVersion,
            function(stream) {
                callback(formatter(stream));
            },
            function(stream) {
                errorCallback(stream);
        });
    }
}

var InputSet = function(inputs, outputFilters, credentialName) {

    // If adding/removing members, make sure to update the clone() method as well
    var inputs = inputs || {},
        outputFilters = outputFilters || [],
        credentialName = credentialName || null;

    this.clone = function(){
        var c = JSON.parse(
            JSON.stringify({
                inputs:inputs,
                outputFilters:outputFilters,
                credentialName:credentialName
            })
        );
        return new InputSet(c.inputs, c.outputFilters, c.credentialName);
    }

    this.setInput = function(name, value) {
        inputs[name] = value;
    }
    this.setCredential = function(target) {
        credentialName = target;
    }
    this.addProfile = this.setCredential;

    this.addOutputFilter = function(filterName, path, outputVariableSource) {
        outputFilters.push({name: filterName, path: path, variable: outputVariableSource});
    }

    this.formatInputs = function() {
        fullInputs = {};
        if (Object.keys(inputs).length > 0) {
            var inputArray = [];
            for (var key in inputs) {
                currentInput = {
                    "name": key,
                    "value": inputs[key]
                };
                inputArray.push(currentInput);
                // console.log(inputArray);
            }
            fullInputs["inputs"] = inputArray;
        }
        if (outputFilters.length > 0) {
            fullInputs["outputFilters"] = outputFilters;
        }
        if (credentialName) {
            fullInputs["preset"] = credentialName;
        }
        var formattedInputs = JSON.stringify(fullInputs);
        // console.log("These are the formatted inputs.");
        // console.log(formattedInputs);
        return formattedInputs;
    }
}

var ResultSet = function(resultStream) {
    // console.log(resultStream);
    var resultHash = JSON.parse(resultStream);
    var id = resultHash["execution"]["id"];
    var status = resultHash["execution"]["status"];
    if (status == "ERROR") {
        var errorTime = resultHash["execution"]["endtime"];
    } else {
        var errorTime = null;
    }
    var lastError = resultHash["execution"]["lasterror"];
    var startTime = resultHash["execution"]["starttime"];
    var endTime = resultHash["execution"]["endtime"];
    var outputs = resultHash["output"];
    // console.log(outputs);

    var processStamp = function(stampString) {
        return new Date(Number(stampString));
    }

    this.getCompletionStatus = function() {
        return status;
    }

    this.getStartTime = function() {
        return processStamp(startTime);
    }

    this.getCompletionTime = function() {
        return processStamp(endTime);
    }
    this.getID = function() {
        return id;
    }

    this.getResult = function(key) {
        return outputs[key];
    }

    this.getResultString = function(key) {
        var output = this.getResult(key);
        return typeof output == 'string' ? output : JSON.stringify(output);
    }

    this.getResultList = function(key) {
        var output = this.getResult(key);
        return typeof output == 'string' ? [output] : output;
    }

    this.getKeySet = function() {
        return Object.keys(output);
    }

    this.getOutputs = function() {
        return outputs;
    }

    this.getLastError = function() {
        return lastError;
    }
}

exports.Choreography = Choreography;
exports.InputSet = InputSet;
exports.ResultSet = ResultSet;