
var util = require("util");
var choreography = require("temboo/core/choreography");


/*
    GetPageSummary
    Retrieves a summary response including a text extract of the first several sentences, as well as information about a thumbnail that represents the page.
*/


var GetPageSummary = function(session) {
    /*
        Create a new instance of the GetPageSummary Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Wikipedia/GetPageSummary"
    GetPageSummary.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new GetPageSummaryResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new GetPageSummaryInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the GetPageSummary
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var GetPageSummaryInputSet = function() {
    GetPageSummaryInputSet.super_.call(this);
        /*
        Set the value of the Title input for this Choreo. ((required, string) The Wikipedia page title.)
        */
        this.set_Title = function(value) {
            this.setInput("Title", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the GetPageSummary Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var GetPageSummaryResultSet = function(resultStream) {
    GetPageSummaryResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Extract" output from this Choreo execution. ((string) The page summary.)
        */
        this.get_Extract = function() {
            return this.getResult("Extract");
        }
        /*
        Retrieve the value for the "ResponseCode" output from this Choreo execution. ((integer) The response code returned by the API.)
        */
        this.get_ResponseCode = function() {
            return this.getResult("ResponseCode");
        }
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Wikipedia.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(GetPageSummary, choreography.Choreography);
util.inherits(GetPageSummaryInputSet, choreography.InputSet);
util.inherits(GetPageSummaryResultSet, choreography.ResultSet);
exports.GetPageSummary = GetPageSummary;

