
var util = require("util");
var choreography = require("temboo/core/choreography");


/*
    GetValuesFromJSON
    Searches for the specified property in the supplied JSON string.
*/


var GetValuesFromJSON = function(session) {
    /*
        Create a new instance of the GetValuesFromJSON Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Utilities/JSON/GetValuesFromJSON"
    GetValuesFromJSON.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new GetValuesFromJSONResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new GetValuesFromJSONInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the GetValuesFromJSON
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var GetValuesFromJSONInputSet = function() {
    GetValuesFromJSONInputSet.super_.call(this);
        /*
        Set the value of the JSON input for this Choreo. ((required, json) JSON String to search.)
        */
        this.set_JSON = function(value) {
            this.setInput("JSON", value);
        }

        /*
        Set the value of the Property input for this Choreo. ((required, string) Property to match in the specified JSON string.)
        */
        this.set_Property = function(value) {
            this.setInput("Property", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the GetValuesFromJSON Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var GetValuesFromJSONResultSet = function(resultStream) {
    GetValuesFromJSONResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) Value(s) that match the property.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(GetValuesFromJSON, choreography.Choreography);
util.inherits(GetValuesFromJSONInputSet, choreography.InputSet);
util.inherits(GetValuesFromJSONResultSet, choreography.ResultSet);
exports.GetValuesFromJSON = GetValuesFromJSON;

