
var util = require("util");
var choreography = require("temboo/core/choreography");


/*
    RemoveWhiteSpace
    Returns the specified formatted text as a compact string with no new lines, tabs, or preceding/trailing white space.
*/


var RemoveWhiteSpace = function(session) {
    /*
        Create a new instance of the RemoveWhiteSpace Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Utilities/Formatting/RemoveWhiteSpace"
    RemoveWhiteSpace.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new RemoveWhiteSpaceResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new RemoveWhiteSpaceInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the RemoveWhiteSpace
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var RemoveWhiteSpaceInputSet = function() {
    RemoveWhiteSpaceInputSet.super_.call(this);
        /*
        Set the value of the FormattedText input for this Choreo. ((required, multiline) The formatted text that should have line breaks and tabs removed.)
        */
        this.set_FormattedText = function(value) {
            this.setInput("FormattedText", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the RemoveWhiteSpace Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var RemoveWhiteSpaceResultSet = function(resultStream) {
    RemoveWhiteSpaceResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "CompactText" output from this Choreo execution. ((string) )
        */
        this.get_CompactText = function() {
            return this.getResult("CompactText");
        }
}

util.inherits(RemoveWhiteSpace, choreography.Choreography);
util.inherits(RemoveWhiteSpaceInputSet, choreography.InputSet);
util.inherits(RemoveWhiteSpaceResultSet, choreography.ResultSet);
exports.RemoveWhiteSpace = RemoveWhiteSpace;

