
var util = require("util");
var choreography = require("temboo/core/choreography");


/*
    GetDate
    Formats a specified timestamp, or generates the current date in a desired format.
*/


var GetDate = function(session) {
    /*
        Create a new instance of the GetDate Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Utilities/Dates/GetDate"
    GetDate.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new GetDateResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new GetDateInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the GetDate
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var GetDateInputSet = function() {
    GetDateInputSet.super_.call(this);
        /*
        Set the value of the AddDays input for this Choreo. ((optional, integer) Adds the specified number of days to the specified date serial number. A negative number will subtract.)
        */
        this.set_AddDays = function(value) {
            this.setInput("AddDays", value);
        }

        /*
        Set the value of the AddHours input for this Choreo. ((optional, integer) Adds the specified number of hours to the specified date serial number. A negative number will subtract.)
        */
        this.set_AddHours = function(value) {
            this.setInput("AddHours", value);
        }

        /*
        Set the value of the AddMinutes input for this Choreo. ((optional, integer) Adds the specified number of minutes to the specified date serial number. A negative number will subtract.)
        */
        this.set_AddMinutes = function(value) {
            this.setInput("AddMinutes", value);
        }

        /*
        Set the value of the AddMonths input for this Choreo. ((optional, integer) Adds the specified number of months to the specified date serial number. A negative number will subtract.)
        */
        this.set_AddMonths = function(value) {
            this.setInput("AddMonths", value);
        }

        /*
        Set the value of the AddSeconds input for this Choreo. ((optional, integer) Adds the specified number of seconds to the specified date serial number. A negative number will subtract.)
        */
        this.set_AddSeconds = function(value) {
            this.setInput("AddSeconds", value);
        }

        /*
        Set the value of the AddYears input for this Choreo. ((optional, integer) Adds the specified number of years to the specified date serial number. A negative number will subtract.)
        */
        this.set_AddYears = function(value) {
            this.setInput("AddYears", value);
        }

        /*
        Set the value of the Format input for this Choreo. ((conditional, string) The format that the timestamp should be in. Java SimpleDateFormat conventions are supported. Defaults to "yyyy-MM-dd HH:mm:ss".)
        */
        this.set_Format = function(value) {
            this.setInput("Format", value);
        }

        /*
        Set the value of the LocaleCountry input for this Choreo. ((optional, string) An ISO country code to specify locale.)
        */
        this.set_LocaleCountry = function(value) {
            this.setInput("LocaleCountry", value);
        }

        /*
        Set the value of the LocaleLanguage input for this Choreo. ((optional, string) An ISO language code to specify locale.)
        */
        this.set_LocaleLanguage = function(value) {
            this.setInput("LocaleLanguage", value);
        }

        /*
        Set the value of the LocaleVariant input for this Choreo. ((optional, string) A local variant code such as "NY" to add additional context for a locale.)
        */
        this.set_LocaleVariant = function(value) {
            this.setInput("LocaleVariant", value);
        }

        /*
        Set the value of the SetDay input for this Choreo. ((optional, integer) Sets the day of month (1-31) of the specified date serial number.)
        */
        this.set_SetDay = function(value) {
            this.setInput("SetDay", value);
        }

        /*
        Set the value of the SetHour input for this Choreo. ((optional, integer) Sets the hours (0-23) of the specified date serial number.)
        */
        this.set_SetHour = function(value) {
            this.setInput("SetHour", value);
        }

        /*
        Set the value of the SetMinute input for this Choreo. ((optional, integer) Sets the minutes (0-59) of the specified date serial number.)
        */
        this.set_SetMinute = function(value) {
            this.setInput("SetMinute", value);
        }

        /*
        Set the value of the SetMonth input for this Choreo. ((optional, integer) Sets the month (1-12) of the specified date serial number.)
        */
        this.set_SetMonth = function(value) {
            this.setInput("SetMonth", value);
        }

        /*
        Set the value of the SetSecond input for this Choreo. ((optional, integer) Sets the seconds (0-59) of the specified date serial number.)
        */
        this.set_SetSecond = function(value) {
            this.setInput("SetSecond", value);
        }

        /*
        Set the value of the SetYear input for this Choreo. ((optional, integer) Sets the year (such as 1989) of the specified date serial number.)
        */
        this.set_SetYear = function(value) {
            this.setInput("SetYear", value);
        }

        /*
        Set the value of the TimeZone input for this Choreo. ((optional, string) The timezone to use for the date formatting function. Defaults to UTC.)
        */
        this.set_TimeZone = function(value) {
            this.setInput("TimeZone", value);
        }

        /*
        Set the value of the Timestamp input for this Choreo. ((conditional, date) A number representing the desired formatted date and time, expressed as the number of milliseconds since January 1, 1970 (epoch time). If not provided, this defaults to NOW().)
        */
        this.set_Timestamp = function(value) {
            this.setInput("Timestamp", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the GetDate Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var GetDateResultSet = function(resultStream) {
    GetDateResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "FormattedDate" output from this Choreo execution. ((date) The formatted version of the timestamp.)
        */
        this.get_FormattedDate = function() {
            return this.getResult("FormattedDate");
        }
}

util.inherits(GetDate, choreography.Choreography);
util.inherits(GetDateInputSet, choreography.InputSet);
util.inherits(GetDateResultSet, choreography.ResultSet);
exports.GetDate = GetDate;


/*
    GetDateDifference
    Returns the difference between two specified dates, expressed as the number of milliseconds since January 1, 1970 (epoch time).
*/


var GetDateDifference = function(session) {
    /*
        Create a new instance of the GetDateDifference Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Utilities/Dates/GetDateDifference"
    GetDateDifference.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new GetDateDifferenceResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new GetDateDifferenceInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the GetDateDifference
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var GetDateDifferenceInputSet = function() {
    GetDateDifferenceInputSet.super_.call(this);
        /*
        Set the value of the EarlierDate input for this Choreo. ((required, date) The earlier date to use for the date comparision (e.g., March 2, 2014).)
        */
        this.set_EarlierDate = function(value) {
            this.setInput("EarlierDate", value);
        }

        /*
        Set the value of the LaterDate input for this Choreo. ((required, date) The later date to use for the date comparision (e.g., March 3, 2014).)
        */
        this.set_LaterDate = function(value) {
            this.setInput("LaterDate", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the GetDateDifference Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var GetDateDifferenceResultSet = function(resultStream) {
    GetDateDifferenceResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Difference" output from this Choreo execution. ((integer) The difference between two specified dates, expressed as the number of milliseconds since January 1, 1970 (epoch time). )
        */
        this.get_Difference = function() {
            return this.getResult("Difference");
        }
}

util.inherits(GetDateDifference, choreography.Choreography);
util.inherits(GetDateDifferenceInputSet, choreography.InputSet);
util.inherits(GetDateDifferenceResultSet, choreography.ResultSet);
exports.GetDateDifference = GetDateDifference;


/*
    GetTimestamp
    Returns the current date and time, expressed as seconds or milliseconds since January 1, 1970 (epoch time).
*/


var GetTimestamp = function(session) {
    /*
        Create a new instance of the GetTimestamp Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Utilities/Dates/GetTimestamp"
    GetTimestamp.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new GetTimestampResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new GetTimestampInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the GetTimestamp
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var GetTimestampInputSet = function() {
    GetTimestampInputSet.super_.call(this);
        /*
        Set the value of the AddDays input for this Choreo. ((optional, integer) Adds the specified number of days to the specified date serial number. A negative number will subtract.)
        */
        this.set_AddDays = function(value) {
            this.setInput("AddDays", value);
        }

        /*
        Set the value of the AddHours input for this Choreo. ((optional, integer) Adds the specified number of hours to the specified date serial number. A negative number will subtract.)
        */
        this.set_AddHours = function(value) {
            this.setInput("AddHours", value);
        }

        /*
        Set the value of the AddMinutes input for this Choreo. ((optional, integer) Adds the specified number of minutes to the specified date serial number. A negative number will subtract.)
        */
        this.set_AddMinutes = function(value) {
            this.setInput("AddMinutes", value);
        }

        /*
        Set the value of the AddMonths input for this Choreo. ((optional, integer) Adds the specified number of months to the specified date serial number. A negative number will subtract.)
        */
        this.set_AddMonths = function(value) {
            this.setInput("AddMonths", value);
        }

        /*
        Set the value of the AddSeconds input for this Choreo. ((optional, integer) Adds the specified number of seconds to the specified date serial number. A negative number will subtract.)
        */
        this.set_AddSeconds = function(value) {
            this.setInput("AddSeconds", value);
        }

        /*
        Set the value of the AddYears input for this Choreo. ((optional, integer) Adds the specified number of years to the specified date serial number. A negative number will subtract.)
        */
        this.set_AddYears = function(value) {
            this.setInput("AddYears", value);
        }

        /*
        Set the value of the Granularity input for this Choreo. ((optional, string) Set to "seconds" to return the number of seconds since the epoch. Defaults to "milliseconds".)
        */
        this.set_Granularity = function(value) {
            this.setInput("Granularity", value);
        }

        /*
        Set the value of the SetDay input for this Choreo. ((optional, integer) Sets the day of month (1-31) of the specified date serial number.)
        */
        this.set_SetDay = function(value) {
            this.setInput("SetDay", value);
        }

        /*
        Set the value of the SetHour input for this Choreo. ((optional, integer) Sets the hours (0-23) of the specified date serial number.)
        */
        this.set_SetHour = function(value) {
            this.setInput("SetHour", value);
        }

        /*
        Set the value of the SetMinute input for this Choreo. ((optional, integer) Sets the minutes (0-59) of the specified date serial number.)
        */
        this.set_SetMinute = function(value) {
            this.setInput("SetMinute", value);
        }

        /*
        Set the value of the SetMonth input for this Choreo. ((optional, integer) Sets the month (1-12) of the specified date serial number.)
        */
        this.set_SetMonth = function(value) {
            this.setInput("SetMonth", value);
        }

        /*
        Set the value of the SetSecond input for this Choreo. ((optional, integer) Sets the seconds (0-59) of the specified date serial number.)
        */
        this.set_SetSecond = function(value) {
            this.setInput("SetSecond", value);
        }

        /*
        Set the value of the SetYear input for this Choreo. ((optional, integer) Sets the year (such as 1989) of the specified date serial number.)
        */
        this.set_SetYear = function(value) {
            this.setInput("SetYear", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the GetTimestamp Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var GetTimestampResultSet = function(resultStream) {
    GetTimestampResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Timestamp" output from this Choreo execution. ((date) A the current timestamp, expressed as the number of seconds or milliseconds since January 1, 1970 (epoch time). The Granularity input is used to indicate seconds or milliseconds.)
        */
        this.get_Timestamp = function() {
            return this.getResult("Timestamp");
        }
}

util.inherits(GetTimestamp, choreography.Choreography);
util.inherits(GetTimestampInputSet, choreography.InputSet);
util.inherits(GetTimestampResultSet, choreography.ResultSet);
exports.GetTimestamp = GetTimestamp;


/*
    GetTimestampFromDateParameters
    Returns the specified date parameters, expressed as the number of seconds or milliseconds since January 1, 1970 (epoch time).
*/


var GetTimestampFromDateParameters = function(session) {
    /*
        Create a new instance of the GetTimestampFromDateParameters Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Utilities/Dates/GetTimestampFromDateParameters"
    GetTimestampFromDateParameters.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new GetTimestampFromDateParametersResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new GetTimestampFromDateParametersInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the GetTimestampFromDateParameters
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var GetTimestampFromDateParametersInputSet = function() {
    GetTimestampFromDateParametersInputSet.super_.call(this);
        /*
        Set the value of the Day input for this Choreo. ((conditional, integer) Sets the day (1-31) of the timestamp.)
        */
        this.set_Day = function(value) {
            this.setInput("Day", value);
        }

        /*
        Set the value of the Granularity input for this Choreo. ((optional, string) Set to "seconds" to return the number of seconds since the epoch. Defaults to "milliseconds".)
        */
        this.set_Granularity = function(value) {
            this.setInput("Granularity", value);
        }

        /*
        Set the value of the Hour input for this Choreo. ((optional, integer) Sets the hours (0-23) of the timestamp.)
        */
        this.set_Hour = function(value) {
            this.setInput("Hour", value);
        }

        /*
        Set the value of the Milliseconds input for this Choreo. ((optional, integer) Sets the milliseconds (0-999) of the timestamp.)
        */
        this.set_Milliseconds = function(value) {
            this.setInput("Milliseconds", value);
        }

        /*
        Set the value of the Minute input for this Choreo. ((optional, integer) Sets the minutes (0-59) of the timestamp.)
        */
        this.set_Minute = function(value) {
            this.setInput("Minute", value);
        }

        /*
        Set the value of the Month input for this Choreo. ((conditional, integer) Sets the month (1-12) of the timestamp.)
        */
        this.set_Month = function(value) {
            this.setInput("Month", value);
        }

        /*
        Set the value of the Second input for this Choreo. ((optional, integer) Sets the seconds (0-59) of the timestamp.)
        */
        this.set_Second = function(value) {
            this.setInput("Second", value);
        }

        /*
        Set the value of the Year input for this Choreo. ((conditional, integer) Sets the year of the timestamp.)
        */
        this.set_Year = function(value) {
            this.setInput("Year", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the GetTimestampFromDateParameters Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var GetTimestampFromDateParametersResultSet = function(resultStream) {
    GetTimestampFromDateParametersResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Timestamp" output from this Choreo execution. ((date) A number representing the specified date and time, expressed as the number of seconds or milliseconds since January 1, 1970. The Granularity input is used to indicate seconds or milliseconds.)
        */
        this.get_Timestamp = function() {
            return this.getResult("Timestamp");
        }
}

util.inherits(GetTimestampFromDateParameters, choreography.Choreography);
util.inherits(GetTimestampFromDateParametersInputSet, choreography.InputSet);
util.inherits(GetTimestampFromDateParametersResultSet, choreography.ResultSet);
exports.GetTimestampFromDateParameters = GetTimestampFromDateParameters;


/*
    GetTimestampFromDateString
    Returns the the specified date string, expressed as seconds or milliseconds since January 1, 1970 (epoch time).
*/


var GetTimestampFromDateString = function(session) {
    /*
        Create a new instance of the GetTimestampFromDateString Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Utilities/Dates/GetTimestampFromDateString"
    GetTimestampFromDateString.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new GetTimestampFromDateStringResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new GetTimestampFromDateStringInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the GetTimestampFromDateString
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var GetTimestampFromDateStringInputSet = function() {
    GetTimestampFromDateStringInputSet.super_.call(this);
        /*
        Set the value of the AddDays input for this Choreo. ((optional, integer) Adds the specified number of days to the specified date serial number. A negative number will subtract.)
        */
        this.set_AddDays = function(value) {
            this.setInput("AddDays", value);
        }

        /*
        Set the value of the AddHours input for this Choreo. ((optional, integer) Adds the specified number of hours to the specified date serial number. A negative number will subtract.)
        */
        this.set_AddHours = function(value) {
            this.setInput("AddHours", value);
        }

        /*
        Set the value of the AddMinutes input for this Choreo. ((optional, integer) Adds the specified number of minutes to the specified date serial number. A negative number will subtract.)
        */
        this.set_AddMinutes = function(value) {
            this.setInput("AddMinutes", value);
        }

        /*
        Set the value of the AddMonths input for this Choreo. ((optional, integer) Adds the specified number of months to the specified date serial number. A negative number will subtract.)
        */
        this.set_AddMonths = function(value) {
            this.setInput("AddMonths", value);
        }

        /*
        Set the value of the AddSeconds input for this Choreo. ((optional, integer) Adds the specified number of seconds to the specified date serial number. A negative number will subtract.)
        */
        this.set_AddSeconds = function(value) {
            this.setInput("AddSeconds", value);
        }

        /*
        Set the value of the AddYears input for this Choreo. ((optional, integer) Adds the specified number of years to the specified date serial number. A negative number will subtract.)
        */
        this.set_AddYears = function(value) {
            this.setInput("AddYears", value);
        }

        /*
        Set the value of the Date input for this Choreo. ((required, string) A date string to convert to a timestamp (e.g., March 2, 2014).)
        */
        this.set_Date = function(value) {
            this.setInput("Date", value);
        }

        /*
        Set the value of the Granularity input for this Choreo. ((optional, string) Set to "seconds" to return the number of seconds since the epoch. Defaults to "milliseconds".)
        */
        this.set_Granularity = function(value) {
            this.setInput("Granularity", value);
        }

        /*
        Set the value of the SetDay input for this Choreo. ((optional, integer) Sets the day of month (1-31) of the specified date serial number.)
        */
        this.set_SetDay = function(value) {
            this.setInput("SetDay", value);
        }

        /*
        Set the value of the SetHour input for this Choreo. ((optional, integer) Sets the hours (0-23) of the specified date serial number.)
        */
        this.set_SetHour = function(value) {
            this.setInput("SetHour", value);
        }

        /*
        Set the value of the SetMinute input for this Choreo. ((optional, integer) Sets the minutes (0-59) of the specified date serial number.)
        */
        this.set_SetMinute = function(value) {
            this.setInput("SetMinute", value);
        }

        /*
        Set the value of the SetMonth input for this Choreo. ((optional, integer) Sets the month (1-12) of the specified date serial number.)
        */
        this.set_SetMonth = function(value) {
            this.setInput("SetMonth", value);
        }

        /*
        Set the value of the SetSecond input for this Choreo. ((optional, integer) Sets the seconds (0-59) of the specified date serial number.)
        */
        this.set_SetSecond = function(value) {
            this.setInput("SetSecond", value);
        }

        /*
        Set the value of the SetYear input for this Choreo. ((optional, integer) Sets the year (such as 1989) of the specified date serial number.)
        */
        this.set_SetYear = function(value) {
            this.setInput("SetYear", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the GetTimestampFromDateString Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var GetTimestampFromDateStringResultSet = function(resultStream) {
    GetTimestampFromDateStringResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Timestamp" output from this Choreo execution. ((date) A the current timestamp, expressed as the number of seconds or milliseconds since January 1, 1970 (epoch time). The Granularity input is used to indicate seconds or milliseconds.)
        */
        this.get_Timestamp = function() {
            return this.getResult("Timestamp");
        }
}

util.inherits(GetTimestampFromDateString, choreography.Choreography);
util.inherits(GetTimestampFromDateStringInputSet, choreography.InputSet);
util.inherits(GetTimestampFromDateStringResultSet, choreography.ResultSet);
exports.GetTimestampFromDateString = GetTimestampFromDateString;

