
var util = require("util");
var choreography = require("temboo/core/choreography");


/*
    GetProductTypes
    Returns information about the Uber products offered at a given location.
*/


var GetProductTypes = function(session) {
    /*
        Create a new instance of the GetProductTypes Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Uber/Products/GetProductTypes"
    GetProductTypes.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new GetProductTypesResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new GetProductTypesInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the GetProductTypes
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var GetProductTypesInputSet = function() {
    GetProductTypesInputSet.super_.call(this);
        /*
        Set the value of the Latitude input for this Choreo. ((required, decimal) The latitude coordinate for the location e.g., 40.71863.)
        */
        this.set_Latitude = function(value) {
            this.setInput("Latitude", value);
        }

        /*
        Set the value of the Longitude input for this Choreo. ((required, decimal) The longitude coordinate for the location e.g., -74.005584.)
        */
        this.set_Longitude = function(value) {
            this.setInput("Longitude", value);
        }

        /*
        Set the value of the ServerToken input for this Choreo. ((required, string) The Sever Token provided by Uber.)
        */
        this.set_ServerToken = function(value) {
            this.setInput("ServerToken", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the GetProductTypes Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var GetProductTypesResultSet = function(resultStream) {
    GetProductTypesResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Uber.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(GetProductTypes, choreography.Choreography);
util.inherits(GetProductTypesInputSet, choreography.InputSet);
util.inherits(GetProductTypesResultSet, choreography.ResultSet);
exports.GetProductTypes = GetProductTypes;

