
var util = require("util");
var choreography = require("temboo/core/choreography");


/*
    AcknowledgeIncident
    Acknowledges an incident.
*/


var AcknowledgeIncident = function(session) {
    /*
        Create a new instance of the AcknowledgeIncident Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/PagerDuty/Incidents/AcknowledgeIncident"
    AcknowledgeIncident.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new AcknowledgeIncidentResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new AcknowledgeIncidentInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the AcknowledgeIncident
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var AcknowledgeIncidentInputSet = function() {
    AcknowledgeIncidentInputSet.super_.call(this);
        /*
        Set the value of the APIKey input for this Choreo. ((required, string) The API Key provided by PagerDuty.)
        */
        this.set_APIKey = function(value) {
            this.setInput("APIKey", value);
        }

        /*
        Set the value of the IncidentID input for this Choreo. ((required, string) The ID of the incident to acknowledge.)
        */
        this.set_IncidentID = function(value) {
            this.setInput("IncidentID", value);
        }

        /*
        Set the value of the RequesterID input for this Choreo. ((required, string) The ID of the user making the request. This will be added to the incident log entry.)
        */
        this.set_RequesterID = function(value) {
            this.setInput("RequesterID", value);
        }

        /*
        Set the value of the SubDomain input for this Choreo. ((required, string) The subdomain of your PagerDuty site address.)
        */
        this.set_SubDomain = function(value) {
            this.setInput("SubDomain", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the AcknowledgeIncident Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var AcknowledgeIncidentResultSet = function(resultStream) {
    AcknowledgeIncidentResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from PagerDuty.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(AcknowledgeIncident, choreography.Choreography);
util.inherits(AcknowledgeIncidentInputSet, choreography.InputSet);
util.inherits(AcknowledgeIncidentResultSet, choreography.ResultSet);
exports.AcknowledgeIncident = AcknowledgeIncident;


/*
    CountIncidents
    Returns a count of incidents that match a specified criteria.
*/


var CountIncidents = function(session) {
    /*
        Create a new instance of the CountIncidents Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/PagerDuty/Incidents/CountIncidents"
    CountIncidents.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new CountIncidentsResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new CountIncidentsInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the CountIncidents
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var CountIncidentsInputSet = function() {
    CountIncidentsInputSet.super_.call(this);
        /*
        Set the value of the APIKey input for this Choreo. ((required, string) The API Key provided by PagerDuty.)
        */
        this.set_APIKey = function(value) {
            this.setInput("APIKey", value);
        }

        /*
        Set the value of the AssignedToUser input for this Choreo. ((optional, string) Returns the count of incidents assigned to the specified user.)
        */
        this.set_AssignedToUser = function(value) {
            this.setInput("AssignedToUser", value);
        }

        /*
        Set the value of the DateRange input for this Choreo. ((optional, string) When set to "all", this allows you to retrieve the count of all incidents since the account was created.)
        */
        this.set_DateRange = function(value) {
            this.setInput("DateRange", value);
        }

        /*
        Set the value of the IncidentKey input for this Choreo. ((optional, string) Returns the count of incidents with the specified key.)
        */
        this.set_IncidentKey = function(value) {
            this.setInput("IncidentKey", value);
        }

        /*
        Set the value of the Service input for this Choreo. ((optional, string) Returns the count of incidents associated with the specified service.)
        */
        this.set_Service = function(value) {
            this.setInput("Service", value);
        }

        /*
        Set the value of the Since input for this Choreo. ((optional, date) The start of the date range to search (e.g., 2013-03-06T15:28-05). Note that including the time is optional.)
        */
        this.set_Since = function(value) {
            this.setInput("Since", value);
        }

        /*
        Set the value of the Status input for this Choreo. ((optional, string) Returns the count of incidents with this specified status. Valid values are: triggered, acknowledged, and resolved.)
        */
        this.set_Status = function(value) {
            this.setInput("Status", value);
        }

        /*
        Set the value of the SubDomain input for this Choreo. ((required, string) The subdomain of your PagerDuty site address.)
        */
        this.set_SubDomain = function(value) {
            this.setInput("SubDomain", value);
        }

        /*
        Set the value of the Until input for this Choreo. ((optional, date) The end of the date range to search (e.g., 2013-03-06T15:28-05). Note that including the time is optional.)
        */
        this.set_Until = function(value) {
            this.setInput("Until", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the CountIncidents Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var CountIncidentsResultSet = function(resultStream) {
    CountIncidentsResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from PagerDuty.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(CountIncidents, choreography.Choreography);
util.inherits(CountIncidentsInputSet, choreography.InputSet);
util.inherits(CountIncidentsResultSet, choreography.ResultSet);
exports.CountIncidents = CountIncidents;


/*
    GetIncident
    Returns detailed information about a specified incident.
*/


var GetIncident = function(session) {
    /*
        Create a new instance of the GetIncident Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/PagerDuty/Incidents/GetIncident"
    GetIncident.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new GetIncidentResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new GetIncidentInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the GetIncident
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var GetIncidentInputSet = function() {
    GetIncidentInputSet.super_.call(this);
        /*
        Set the value of the APIKey input for this Choreo. ((required, string) The API Key provided by PagerDuty.)
        */
        this.set_APIKey = function(value) {
            this.setInput("APIKey", value);
        }

        /*
        Set the value of the IncidentID input for this Choreo. ((required, string) An incident ID, or an incident number.)
        */
        this.set_IncidentID = function(value) {
            this.setInput("IncidentID", value);
        }

        /*
        Set the value of the SubDomain input for this Choreo. ((required, string) The subdomain of your PagerDuty site address.)
        */
        this.set_SubDomain = function(value) {
            this.setInput("SubDomain", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the GetIncident Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var GetIncidentResultSet = function(resultStream) {
    GetIncidentResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from PagerDuty.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(GetIncident, choreography.Choreography);
util.inherits(GetIncidentInputSet, choreography.InputSet);
util.inherits(GetIncidentResultSet, choreography.ResultSet);
exports.GetIncident = GetIncident;


/*
    ListIncidents
    Allows you to list or search PagerDuty incidents.
*/


var ListIncidents = function(session) {
    /*
        Create a new instance of the ListIncidents Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/PagerDuty/Incidents/ListIncidents"
    ListIncidents.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new ListIncidentsResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new ListIncidentsInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the ListIncidents
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var ListIncidentsInputSet = function() {
    ListIncidentsInputSet.super_.call(this);
        /*
        Set the value of the APIKey input for this Choreo. ((required, string) The API Key provided by PagerDuty.)
        */
        this.set_APIKey = function(value) {
            this.setInput("APIKey", value);
        }

        /*
        Set the value of the AssignedToUser input for this Choreo. ((optional, string) Returns only incidents assigned to the specified user.)
        */
        this.set_AssignedToUser = function(value) {
            this.setInput("AssignedToUser", value);
        }

        /*
        Set the value of the DateRange input for this Choreo. ((optional, string) When set to "all", this allows you to retrieve all incidents since the account was created.)
        */
        this.set_DateRange = function(value) {
            this.setInput("DateRange", value);
        }

        /*
        Set the value of the Fields input for this Choreo. ((optional, string) Allows you to select specific incident properties to be returned in the response.)
        */
        this.set_Fields = function(value) {
            this.setInput("Fields", value);
        }

        /*
        Set the value of the IncidentKey input for this Choreo. ((optional, string) Returns only incidents with the specified key.)
        */
        this.set_IncidentKey = function(value) {
            this.setInput("IncidentKey", value);
        }

        /*
        Set the value of the Limit input for this Choreo. ((optional, integer) The number of incidents returned. Default (and max limit) is 100.)
        */
        this.set_Limit = function(value) {
            this.setInput("Limit", value);
        }

        /*
        Set the value of the Offset input for this Choreo. ((optional, integer) The offset of the first incident record returned. Default is 0.)
        */
        this.set_Offset = function(value) {
            this.setInput("Offset", value);
        }

        /*
        Set the value of the Service input for this Choreo. ((optional, string) Returns only incidents associated with the specified service.)
        */
        this.set_Service = function(value) {
            this.setInput("Service", value);
        }

        /*
        Set the value of the Since input for this Choreo. ((optional, date) The start of the date range to search (e.g., 2013-03-06T15:28-05). Note that including the time is optional.)
        */
        this.set_Since = function(value) {
            this.setInput("Since", value);
        }

        /*
        Set the value of the SortBy input for this Choreo. ((optional, string) Used to specify both the field you wish to sort the results on (incident_number, created_on, or resolved_on), as well as the direction (asc/desc) of the results (e.g., created_on:desc).)
        */
        this.set_SortBy = function(value) {
            this.setInput("SortBy", value);
        }

        /*
        Set the value of the Status input for this Choreo. ((optional, string) Returns only the incidents with this specified status. Valid values are: triggered, acknowledged, and resolved.)
        */
        this.set_Status = function(value) {
            this.setInput("Status", value);
        }

        /*
        Set the value of the SubDomain input for this Choreo. ((required, string) The subdomain of your PagerDuty site address.)
        */
        this.set_SubDomain = function(value) {
            this.setInput("SubDomain", value);
        }

        /*
        Set the value of the TimeZone input for this Choreo. ((optional, string) The time zone in which dates in the result will be rendered. Defaults to account time zone.)
        */
        this.set_TimeZone = function(value) {
            this.setInput("TimeZone", value);
        }

        /*
        Set the value of the Until input for this Choreo. ((optional, date) The end of the date range to search (e.g., 2013-03-06T15:28-05). Note that including the time is optional.)
        */
        this.set_Until = function(value) {
            this.setInput("Until", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the ListIncidents Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var ListIncidentsResultSet = function(resultStream) {
    ListIncidentsResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from PagerDuty.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(ListIncidents, choreography.Choreography);
util.inherits(ListIncidentsInputSet, choreography.InputSet);
util.inherits(ListIncidentsResultSet, choreography.ResultSet);
exports.ListIncidents = ListIncidents;


/*
    ReassignIncident
    Reassigns an incident.
*/


var ReassignIncident = function(session) {
    /*
        Create a new instance of the ReassignIncident Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/PagerDuty/Incidents/ReassignIncident"
    ReassignIncident.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new ReassignIncidentResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new ReassignIncidentInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the ReassignIncident
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var ReassignIncidentInputSet = function() {
    ReassignIncidentInputSet.super_.call(this);
        /*
        Set the value of the APIKey input for this Choreo. ((required, string) The API Key provided by PagerDuty.)
        */
        this.set_APIKey = function(value) {
            this.setInput("APIKey", value);
        }

        /*
        Set the value of the AssignedToUser input for this Choreo. ((required, string) Assigns this incident to the specified user id.)
        */
        this.set_AssignedToUser = function(value) {
            this.setInput("AssignedToUser", value);
        }

        /*
        Set the value of the EscalationLevel input for this Choreo. ((optional, integer) Escalates the incident to this level in the escalation policy.)
        */
        this.set_EscalationLevel = function(value) {
            this.setInput("EscalationLevel", value);
        }

        /*
        Set the value of the IncidentID input for this Choreo. ((required, string) The ID of the incident to reassign.)
        */
        this.set_IncidentID = function(value) {
            this.setInput("IncidentID", value);
        }

        /*
        Set the value of the RequesterID input for this Choreo. ((required, string) The ID of the user making the request. This will be added to the incident log entry.)
        */
        this.set_RequesterID = function(value) {
            this.setInput("RequesterID", value);
        }

        /*
        Set the value of the SubDomain input for this Choreo. ((required, string) The subdomain of your PagerDuty site address.)
        */
        this.set_SubDomain = function(value) {
            this.setInput("SubDomain", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the ReassignIncident Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var ReassignIncidentResultSet = function(resultStream) {
    ReassignIncidentResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from PagerDuty.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(ReassignIncident, choreography.Choreography);
util.inherits(ReassignIncidentInputSet, choreography.InputSet);
util.inherits(ReassignIncidentResultSet, choreography.ResultSet);
exports.ReassignIncident = ReassignIncident;


/*
    ResolveIncident
    Resolves an incident.
*/


var ResolveIncident = function(session) {
    /*
        Create a new instance of the ResolveIncident Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/PagerDuty/Incidents/ResolveIncident"
    ResolveIncident.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new ResolveIncidentResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new ResolveIncidentInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the ResolveIncident
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var ResolveIncidentInputSet = function() {
    ResolveIncidentInputSet.super_.call(this);
        /*
        Set the value of the APIKey input for this Choreo. ((required, string) The API Key provided by PagerDuty.)
        */
        this.set_APIKey = function(value) {
            this.setInput("APIKey", value);
        }

        /*
        Set the value of the IncidentID input for this Choreo. ((required, string) The ID of the incident to resolve.)
        */
        this.set_IncidentID = function(value) {
            this.setInput("IncidentID", value);
        }

        /*
        Set the value of the RequesterID input for this Choreo. ((required, string) The ID of the user making the request. This will be added to the incident log entry.)
        */
        this.set_RequesterID = function(value) {
            this.setInput("RequesterID", value);
        }

        /*
        Set the value of the SubDomain input for this Choreo. ((required, string) The subdomain of your PagerDuty site address.)
        */
        this.set_SubDomain = function(value) {
            this.setInput("SubDomain", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the ResolveIncident Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var ResolveIncidentResultSet = function(resultStream) {
    ResolveIncidentResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from PagerDuty.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(ResolveIncident, choreography.Choreography);
util.inherits(ResolveIncidentInputSet, choreography.InputSet);
util.inherits(ResolveIncidentResultSet, choreography.ResultSet);
exports.ResolveIncident = ResolveIncident;


/*
    UpdateIncidents
    Allows you to acknowledge, resolve, escalate or reassign one or more incidents.
*/


var UpdateIncidents = function(session) {
    /*
        Create a new instance of the UpdateIncidents Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/PagerDuty/Incidents/UpdateIncidents"
    UpdateIncidents.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new UpdateIncidentsResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new UpdateIncidentsInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the UpdateIncidents
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var UpdateIncidentsInputSet = function() {
    UpdateIncidentsInputSet.super_.call(this);
        /*
        Set the value of the APIKey input for this Choreo. ((required, string) The API Key provided by PagerDuty.)
        */
        this.set_APIKey = function(value) {
            this.setInput("APIKey", value);
        }

        /*
        Set the value of the Incidents input for this Choreo. ((required, json) An array of incident objects that each include an incident ID. Other optional incident properties that can be present include: status, escalation_level, assigned_to_user, and escalation_policy.)
        */
        this.set_Incidents = function(value) {
            this.setInput("Incidents", value);
        }

        /*
        Set the value of the RequesterID input for this Choreo. ((required, string) The ID of the user making the request. This will be added to the incident log entry.)
        */
        this.set_RequesterID = function(value) {
            this.setInput("RequesterID", value);
        }

        /*
        Set the value of the SubDomain input for this Choreo. ((required, string) The subdomain of your PagerDuty site address.)
        */
        this.set_SubDomain = function(value) {
            this.setInput("SubDomain", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the UpdateIncidents Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var UpdateIncidentsResultSet = function(resultStream) {
    UpdateIncidentsResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from PagerDuty.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(UpdateIncidents, choreography.Choreography);
util.inherits(UpdateIncidentsInputSet, choreography.InputSet);
util.inherits(UpdateIncidentsResultSet, choreography.ResultSet);
exports.UpdateIncidents = UpdateIncidents;

