
var util = require("util");
var choreography = require("temboo/core/choreography");


/*
    EventData
    Gets unique, total, or average data for a set of events over the last N days, weeks, or months.
*/


var EventData = function(session) {
    /*
        Create a new instance of the EventData Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Mixpanel/DataExport/Events/EventData"
    EventData.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new EventDataResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new EventDataInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the EventData
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var EventDataInputSet = function() {
    EventDataInputSet.super_.call(this);
        /*
        Set the value of the APIKey input for this Choreo. ((required, string) The API Key provided my Mixpanel. You can find your Mixpanel API Key in the project settings dialog in the Mixpanel app.)
        */
        this.set_APIKey = function(value) {
            this.setInput("APIKey", value);
        }

        /*
        Set the value of the APISecret input for this Choreo. ((required, string) The API Secret provided by Mixpanel. You can find your Mixpanel API Secret in the project settings dialog in the Mixpanel app.)
        */
        this.set_APISecret = function(value) {
            this.setInput("APISecret", value);
        }

        /*
        Set the value of the EventNames input for this Choreo. ((required, json) A JSON array containing the event or events you wish to get data for.)
        */
        this.set_EventNames = function(value) {
            this.setInput("EventNames", value);
        }

        /*
        Set the value of the Expire input for this Choreo. ((optional, integer) The amount of minutes past NOW() before the request will expire. Defaults to 1.)
        */
        this.set_Expire = function(value) {
            this.setInput("Expire", value);
        }

        /*
        Set the value of the Interval input for this Choreo. ((required, integer) The time interval to return. This relates to the value provided for Unit.)
        */
        this.set_Interval = function(value) {
            this.setInput("Interval", value);
        }

        /*
        Set the value of the ResponseFormat input for this Choreo. ((optional, string) The format that the response should be in. Valid values are: json (the default) and csv.)
        */
        this.set_ResponseFormat = function(value) {
            this.setInput("ResponseFormat", value);
        }

        /*
        Set the value of the Type input for this Choreo. ((required, string) The analysis type you would like to get data for. Valid values are: general, unique, or average)
        */
        this.set_Type = function(value) {
            this.setInput("Type", value);
        }

        /*
        Set the value of the Unit input for this Choreo. ((required, string) The granularity of the data to return. Valid values are: minute, hour, day, week, or month.)
        */
        this.set_Unit = function(value) {
            this.setInput("Unit", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the EventData Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var EventDataResultSet = function(resultStream) {
    EventDataResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from Mixpanel.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(EventData, choreography.Choreography);
util.inherits(EventDataInputSet, choreography.InputSet);
util.inherits(EventDataResultSet, choreography.ResultSet);
exports.EventData = EventData;


/*
    TopEvents
    Gets the top events for today, with their counts and the normalized percent change from yesterday.
*/


var TopEvents = function(session) {
    /*
        Create a new instance of the TopEvents Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Mixpanel/DataExport/Events/TopEvents"
    TopEvents.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new TopEventsResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new TopEventsInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the TopEvents
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var TopEventsInputSet = function() {
    TopEventsInputSet.super_.call(this);
        /*
        Set the value of the APIKey input for this Choreo. ((required, string) The API Key provided my Mixpanel. You can find your Mixpanel API Key in the project settings dialog in the Mixpanel app.)
        */
        this.set_APIKey = function(value) {
            this.setInput("APIKey", value);
        }

        /*
        Set the value of the APISecret input for this Choreo. ((required, string) The API Secret provided by Mixpanel. You can find your Mixpanel API Secret in the project settings dialog in the Mixpanel app.)
        */
        this.set_APISecret = function(value) {
            this.setInput("APISecret", value);
        }

        /*
        Set the value of the Expire input for this Choreo. ((optional, integer) The amount of minutes past NOW() before the request will expire. Defaults to 1.)
        */
        this.set_Expire = function(value) {
            this.setInput("Expire", value);
        }

        /*
        Set the value of the Limit input for this Choreo. ((optional, integer) The maximum number of events to return. Defaults to 100 (the max the limit).)
        */
        this.set_Limit = function(value) {
            this.setInput("Limit", value);
        }

        /*
        Set the value of the Type input for this Choreo. ((required, string) The analysis type you would like to get data for. Valid values are: general, unique, or average)
        */
        this.set_Type = function(value) {
            this.setInput("Type", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the TopEvents Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var TopEventsResultSet = function(resultStream) {
    TopEventsResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from Mixpanel.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(TopEvents, choreography.Choreography);
util.inherits(TopEventsInputSet, choreography.InputSet);
util.inherits(TopEventsResultSet, choreography.ResultSet);
exports.TopEvents = TopEvents;


/*
    TopNames
    Gets a list of the most common events over the last 31 days.
*/


var TopNames = function(session) {
    /*
        Create a new instance of the TopNames Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Mixpanel/DataExport/Events/TopNames"
    TopNames.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new TopNamesResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new TopNamesInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the TopNames
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var TopNamesInputSet = function() {
    TopNamesInputSet.super_.call(this);
        /*
        Set the value of the APIKey input for this Choreo. ((required, string) The API Key provided my Mixpanel. You can find your Mixpanel API Key in the project settings dialog in the Mixpanel app.)
        */
        this.set_APIKey = function(value) {
            this.setInput("APIKey", value);
        }

        /*
        Set the value of the APISecret input for this Choreo. ((required, string) The API Secret provided by Mixpanel. You can find your Mixpanel API Secret in the project settings dialog in the Mixpanel app.)
        */
        this.set_APISecret = function(value) {
            this.setInput("APISecret", value);
        }

        /*
        Set the value of the Expire input for this Choreo. ((optional, integer) The amount of minutes past NOW() before the request will expire. Defaults to 1.)
        */
        this.set_Expire = function(value) {
            this.setInput("Expire", value);
        }

        /*
        Set the value of the Limit input for this Choreo. ((optional, integer) The maximum number of events to return. Defaults to 100 (the max the limit).)
        */
        this.set_Limit = function(value) {
            this.setInput("Limit", value);
        }

        /*
        Set the value of the Type input for this Choreo. ((required, string) The analysis type you would like to get data for. Valid values are: general, unique, or average)
        */
        this.set_Type = function(value) {
            this.setInput("Type", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the TopNames Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var TopNamesResultSet = function(resultStream) {
    TopNamesResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from Mixpanel.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(TopNames, choreography.Choreography);
util.inherits(TopNamesInputSet, choreography.InputSet);
util.inherits(TopNamesResultSet, choreography.ResultSet);
exports.TopNames = TopNames;

