
var util = require("util");
var choreography = require("temboo/core/choreography");


/*
    AddRow
    Adds rows to a table in a dataset
*/


var AddRow = function(session) {
    /*
        Create a new instance of the AddRow Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Microsoft/PowerBI/AddRow"
    AddRow.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new AddRowResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new AddRowInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the AddRow
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var AddRowInputSet = function() {
    AddRowInputSet.super_.call(this);
        /*
        Set the value of the Rows input for this Choreo. ((required, json) A JSON object contain one or more rows to insert into a Power BI table. See Choreo notes for formatting details.)
        */
        this.set_Rows = function(value) {
            this.setInput("Rows", value);
        }

        /*
        Set the value of the AccessToken input for this Choreo. ((optional, string) A valid Access Token retrieved during the OAuth process. This can be passed if your application is authenticating multiple Power BI users.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the ClientID input for this Choreo. ((conditional, string) The Client ID provided by Power BI. This is requried unless providing a valid AccessToken (see optional inputs).)
        */
        this.set_ClientID = function(value) {
            this.setInput("ClientID", value);
        }

        /*
        Set the value of the ClientSecret input for this Choreo. ((conditional, string) The Client Secret provided by Power BI. This is requried unless providing a valid AccessToken (see optional inputs).)
        */
        this.set_ClientSecret = function(value) {
            this.setInput("ClientSecret", value);
        }

        /*
        Set the value of the DatasetID input for this Choreo. ((required, string) The ID of the dataset that your table belongs to.)
        */
        this.set_DatasetID = function(value) {
            this.setInput("DatasetID", value);
        }

        /*
        Set the value of the Password input for this Choreo. ((conditional, password) Your Power BI password. This is requried unless providing a valid AccessToken (see optional inputs).)
        */
        this.set_Password = function(value) {
            this.setInput("Password", value);
        }

        /*
        Set the value of the TableName input for this Choreo. ((required, string) The name of the Power BI table to insert a row into.)
        */
        this.set_TableName = function(value) {
            this.setInput("TableName", value);
        }

        /*
        Set the value of the Username input for this Choreo. ((conditional, string) Your Power BI username. This is requried unless providing a valid AccessToken (see optional inputs).)
        */
        this.set_Username = function(value) {
            this.setInput("Username", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the AddRow Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var AddRowResultSet = function(resultStream) {
    AddRowResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "ResponseCode" output from this Choreo execution. ((integer) The response status code returned from Power BI.)
        */
        this.get_ResponseCode = function() {
            return this.getResult("ResponseCode");
        }
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Power BI.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(AddRow, choreography.Choreography);
util.inherits(AddRowInputSet, choreography.InputSet);
util.inherits(AddRowResultSet, choreography.ResultSet);
exports.AddRow = AddRow;


/*
    CreateDataset
    Creates a new Dataset from a JSON schema definition and returns the Dataset ID and the properties of the dataset created.
*/


var CreateDataset = function(session) {
    /*
        Create a new instance of the CreateDataset Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Microsoft/PowerBI/CreateDataset"
    CreateDataset.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new CreateDatasetResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new CreateDatasetInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the CreateDataset
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var CreateDatasetInputSet = function() {
    CreateDatasetInputSet.super_.call(this);
        /*
        Set the value of the SchemaDefinition input for this Choreo. ((required, json) A JSON object containing information about the dataset table and columns. See Choreo notes for formatting details.)
        */
        this.set_SchemaDefinition = function(value) {
            this.setInput("SchemaDefinition", value);
        }

        /*
        Set the value of the AccessToken input for this Choreo. ((optional, string) A valid Access Token retrieved during the OAuth process. This can be passed if your application is authenticating multiple Power BI users.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the ClientID input for this Choreo. ((conditional, string) The Client ID provided by Power BI. This is requried unless providing a valid AccessToken (see optional inputs).)
        */
        this.set_ClientID = function(value) {
            this.setInput("ClientID", value);
        }

        /*
        Set the value of the ClientSecret input for this Choreo. ((conditional, string) The Client Secret provided by Power BI. This is requried unless providing a valid AccessToken (see optional inputs).)
        */
        this.set_ClientSecret = function(value) {
            this.setInput("ClientSecret", value);
        }

        /*
        Set the value of the DefaultRetentionPolicy input for this Choreo. ((optional, string) Enables a default retention policy to automatically clean up old data while keeping a constant flow of new data going into your dashboard. Valid values are: None (the default) or basicFIFO.)
        */
        this.set_DefaultRetentionPolicy = function(value) {
            this.setInput("DefaultRetentionPolicy", value);
        }

        /*
        Set the value of the Password input for this Choreo. ((conditional, password) Your Power BI password. This is requried unless providing a valid AccessToken (see optional inputs).)
        */
        this.set_Password = function(value) {
            this.setInput("Password", value);
        }

        /*
        Set the value of the Username input for this Choreo. ((conditional, string) Your Power BI username. This is requried unless providing a valid AccessToken (see optional inputs).)
        */
        this.set_Username = function(value) {
            this.setInput("Username", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the CreateDataset Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var CreateDatasetResultSet = function(resultStream) {
    CreateDatasetResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "ResponseCode" output from this Choreo execution. ((integer) The response status code returned from Power BI.)
        */
        this.get_ResponseCode = function() {
            return this.getResult("ResponseCode");
        }
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Power BI.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(CreateDataset, choreography.Choreography);
util.inherits(CreateDatasetInputSet, choreography.InputSet);
util.inherits(CreateDatasetResultSet, choreography.ResultSet);
exports.CreateDataset = CreateDataset;

