
var util = require("util");
var choreography = require("temboo/core/choreography");


/*
    GetAttachment
    Gets the specified message attachment.
*/


var GetAttachment = function(session) {
    /*
        Create a new instance of the GetAttachment Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Google/Gmailv2/Attachments/GetAttachment"
    GetAttachment.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new GetAttachmentResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new GetAttachmentInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the GetAttachment
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var GetAttachmentInputSet = function() {
    GetAttachmentInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((optional, string) A valid access token retrieved during the OAuth2 process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the AttachmentID input for this Choreo. ((required, string) The ID of the attachment to retrieve.)
        */
        this.set_AttachmentID = function(value) {
            this.setInput("AttachmentID", value);
        }

        /*
        Set the value of the ClientID input for this Choreo. ((conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.)
        */
        this.set_ClientID = function(value) {
            this.setInput("ClientID", value);
        }

        /*
        Set the value of the ClientSecret input for this Choreo. ((conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.)
        */
        this.set_ClientSecret = function(value) {
            this.setInput("ClientSecret", value);
        }

        /*
        Set the value of the Fields input for this Choreo. ((optional, string) Selector specifying a subset of fields to include in the response.)
        */
        this.set_Fields = function(value) {
            this.setInput("Fields", value);
        }

        /*
        Set the value of the Format input for this Choreo. ((optional, boolean) Specifies the format of the message returned. Valid values are: full (the default), minimal, and raw. See Choreo notes for more details about these formats.)
        */
        this.set_Format = function(value) {
            this.setInput("Format", value);
        }

        /*
        Set the value of the MessageID input for this Choreo. ((required, string) The ID of the message to retrieve.)
        */
        this.set_MessageID = function(value) {
            this.setInput("MessageID", value);
        }

        /*
        Set the value of the RefreshToken input for this Choreo. ((conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.)
        */
        this.set_RefreshToken = function(value) {
            this.setInput("RefreshToken", value);
        }

        /*
        Set the value of the UserID input for this Choreo. ((optional, string) The id of the acting user. Defaults to "me" indicating the user associated with the access token or refresh token provided.)
        */
        this.set_UserID = function(value) {
            this.setInput("UserID", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the GetAttachment Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var GetAttachmentResultSet = function(resultStream) {
    GetAttachmentResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "NewAccessToken" output from this Choreo execution. ((string) Contains a new AccessToken when the RefreshToken is provided.)
        */
        this.get_NewAccessToken = function() {
            return this.getResult("NewAccessToken");
        }
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Google.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(GetAttachment, choreography.Choreography);
util.inherits(GetAttachmentInputSet, choreography.InputSet);
util.inherits(GetAttachmentResultSet, choreography.ResultSet);
exports.GetAttachment = GetAttachment;

