
var util = require("util");
var choreography = require("temboo/core/choreography");


/*
    AddChild
    Moves a specified folder into a parent folder.
*/


var AddChild = function(session) {
    /*
        Create a new instance of the AddChild Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Amazon/CloudDrive/Children/AddChild"
    AddChild.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new AddChildResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new AddChildInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the AddChild
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var AddChildInputSet = function() {
    AddChildInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the ChildID input for this Choreo. ((required, string) The ID of the folder that is being moved within a parent folder.)
        */
        this.set_ChildID = function(value) {
            this.setInput("ChildID", value);
        }

        /*
        Set the value of the ClientID input for this Choreo. ((conditional, string) The Client ID provided by Amazon. Required unless providing a valid AccessToken.)
        */
        this.set_ClientID = function(value) {
            this.setInput("ClientID", value);
        }

        /*
        Set the value of the ClientSecret input for this Choreo. ((conditional, string) The Client Secret provided by Amazon. Required unless providing a valid AccessToken.)
        */
        this.set_ClientSecret = function(value) {
            this.setInput("ClientSecret", value);
        }

        /*
        Set the value of the HandleRequestThrottling input for this Choreo. ((optional, boolean) Whether or not to perform a retry sequence if a throttling error occurs. Set to true to enable this feature. The request will be retried up-to five times when enabled.)
        */
        this.set_HandleRequestThrottling = function(value) {
            this.setInput("HandleRequestThrottling", value);
        }

        /*
        Set the value of the MetaDataURL input for this Choreo. ((optional, string) The appropriate metadataUrl for your account. When not provided, the Choreo will lookup the URL using the Account.GetEndpoint Choreo.)
        */
        this.set_MetaDataURL = function(value) {
            this.setInput("MetaDataURL", value);
        }

        /*
        Set the value of the ParentID input for this Choreo. ((required, string) The ID of the parent folder that will contain the child folder that's being moved.)
        */
        this.set_ParentID = function(value) {
            this.setInput("ParentID", value);
        }

        /*
        Set the value of the RefreshToken input for this Choreo. ((conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.)
        */
        this.set_RefreshToken = function(value) {
            this.setInput("RefreshToken", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the AddChild Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var AddChildResultSet = function(resultStream) {
    AddChildResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "NewAccessToken" output from this Choreo execution. ((string) Contains a new AccessToken when the RefreshToken is provided.)
        */
        this.get_NewAccessToken = function() {
            return this.getResult("NewAccessToken");
        }
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Amazon.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(AddChild, choreography.Choreography);
util.inherits(AddChildInputSet, choreography.InputSet);
util.inherits(AddChildResultSet, choreography.ResultSet);
exports.AddChild = AddChild;


/*
    ListChildren
    Returns the children of a specified parent folder.
*/


var ListChildren = function(session) {
    /*
        Create a new instance of the ListChildren Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Amazon/CloudDrive/Children/ListChildren"
    ListChildren.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new ListChildrenResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new ListChildrenInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the ListChildren
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var ListChildrenInputSet = function() {
    ListChildrenInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the ClientID input for this Choreo. ((conditional, string) The Client ID provided by Amazon. Required unless providing a valid AccessToken.)
        */
        this.set_ClientID = function(value) {
            this.setInput("ClientID", value);
        }

        /*
        Set the value of the ClientSecret input for this Choreo. ((conditional, string) The Client Secret provided by Amazon. Required unless providing a valid AccessToken.)
        */
        this.set_ClientSecret = function(value) {
            this.setInput("ClientSecret", value);
        }

        /*
        Set the value of the Fields input for this Choreo. ((optional, string) A comma-separated list of additional fields to include in the response.)
        */
        this.set_Fields = function(value) {
            this.setInput("Fields", value);
        }

        /*
        Set the value of the Filters input for this Choreo. ((optional, string) A filter used to narrow the result set (e.g., name:Documents). The default value is "kind:FOLDER". To a make a request using no filters, you can pass "none".)
        */
        this.set_Filters = function(value) {
            this.setInput("Filters", value);
        }

        /*
        Set the value of the HandleRequestThrottling input for this Choreo. ((optional, boolean) Whether or not to perform a retry sequence if a throttling error occurs. Set to true to enable this feature. The request will be retried up-to five times when enabled.)
        */
        this.set_HandleRequestThrottling = function(value) {
            this.setInput("HandleRequestThrottling", value);
        }

        /*
        Set the value of the Limit input for this Choreo. ((optional, string) The maximum number of records to be returned.)
        */
        this.set_Limit = function(value) {
            this.setInput("Limit", value);
        }

        /*
        Set the value of the MetaDataURL input for this Choreo. ((optional, string) The appropriate metadataUrl for you account. When not provided, the Choreo will lookup the URL using the Account.GetEndpoint Choreo.)
        */
        this.set_MetaDataURL = function(value) {
            this.setInput("MetaDataURL", value);
        }

        /*
        Set the value of the ParentID input for this Choreo. ((required, string) The ID of the parent that contains the list of children to retrieve.)
        */
        this.set_ParentID = function(value) {
            this.setInput("ParentID", value);
        }

        /*
        Set the value of the RefreshToken input for this Choreo. ((conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.)
        */
        this.set_RefreshToken = function(value) {
            this.setInput("RefreshToken", value);
        }

        /*
        Set the value of the Sort input for this Choreo. ((optional, json) A JSON array containing sort properties (e.g., ["name ASC","contentProperties.size" DESC]).)
        */
        this.set_Sort = function(value) {
            this.setInput("Sort", value);
        }

        /*
        Set the value of the StartToken input for this Choreo. ((optional, string) The nextToken returned from a previous request. Used to paginate through results.)
        */
        this.set_StartToken = function(value) {
            this.setInput("StartToken", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the ListChildren Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var ListChildrenResultSet = function(resultStream) {
    ListChildrenResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "NewAccessToken" output from this Choreo execution. ((string) Contains a new AccessToken when the RefreshToken is provided.)
        */
        this.get_NewAccessToken = function() {
            return this.getResult("NewAccessToken");
        }
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Amazon.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(ListChildren, choreography.Choreography);
util.inherits(ListChildrenInputSet, choreography.InputSet);
util.inherits(ListChildrenResultSet, choreography.ResultSet);
exports.ListChildren = ListChildren;


/*
    RemoveChild
    Removes a specified folder from a parent folder.
*/


var RemoveChild = function(session) {
    /*
        Create a new instance of the RemoveChild Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Amazon/CloudDrive/Children/RemoveChild"
    RemoveChild.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new RemoveChildResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new RemoveChildInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the RemoveChild
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var RemoveChildInputSet = function() {
    RemoveChildInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the ChildID input for this Choreo. ((required, string) The ID of the folder that is being removed from a parent folder.)
        */
        this.set_ChildID = function(value) {
            this.setInput("ChildID", value);
        }

        /*
        Set the value of the ClientID input for this Choreo. ((conditional, string) The Client ID provided by Amazon. Required unless providing a valid AccessToken.)
        */
        this.set_ClientID = function(value) {
            this.setInput("ClientID", value);
        }

        /*
        Set the value of the ClientSecret input for this Choreo. ((conditional, string) The Client Secret provided by Amazon. Required unless providing a valid AccessToken.)
        */
        this.set_ClientSecret = function(value) {
            this.setInput("ClientSecret", value);
        }

        /*
        Set the value of the HandleRequestThrottling input for this Choreo. ((optional, boolean) Whether or not to perform a retry sequence if a throttling error occurs. Set to true to enable this feature. The request will be retried up-to five times when enabled.)
        */
        this.set_HandleRequestThrottling = function(value) {
            this.setInput("HandleRequestThrottling", value);
        }

        /*
        Set the value of the MetaDataURL input for this Choreo. ((optional, string) The appropriate metadataUrl for your account. When not provided, the Choreo will lookup the URL using the Account.GetEndpoint Choreo.)
        */
        this.set_MetaDataURL = function(value) {
            this.setInput("MetaDataURL", value);
        }

        /*
        Set the value of the ParentID input for this Choreo. ((required, string) The ID of the parent folder that contains the child folder that's being removed.)
        */
        this.set_ParentID = function(value) {
            this.setInput("ParentID", value);
        }

        /*
        Set the value of the RefreshToken input for this Choreo. ((conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.)
        */
        this.set_RefreshToken = function(value) {
            this.setInput("RefreshToken", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the RemoveChild Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var RemoveChildResultSet = function(resultStream) {
    RemoveChildResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "NewAccessToken" output from this Choreo execution. ((string) Contains a new AccessToken when the RefreshToken is provided.)
        */
        this.get_NewAccessToken = function() {
            return this.getResult("NewAccessToken");
        }
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Amazon.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(RemoveChild, choreography.Choreography);
util.inherits(RemoveChildInputSet, choreography.InputSet);
util.inherits(RemoveChildResultSet, choreography.ResultSet);
exports.RemoveChild = RemoveChild;

