/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
 */
 var determineException = function(errorStream, errorCode, errorCallback) {
    try {
        var errorMessage = JSON.parse(errorStream).error.message;
        // console.log(errorHash.error.message);
        if (errorCode === 401) {
            errorCallback(new TembooCredentialError(errorMessage));
        } else if (errorCode === 404) {
            errorCallback(new TembooCredentialError(errorMessage));
        } else {
            errorCallback(new TembooError(errorHash.message));
        };
    } catch(SyntaxError) {
        errorCallback(new NonTembooException(errorStream));
    }
}

var TembooError = function(/*polymorphic*/) {
    this.error = true;
    this.type = arguments.length == 2 ? arguments[0] : "TembooError";
    this.message = arguments.length == 2 ? arguments[1] : arguments[0];
}

var TembooDisallowedInputError = function(message, inputName) {
    var e = new TembooError('DisallowedInput', message);
    e.inputName = inputName;
    return e;
}

var TembooCredentialError = function(message) {
    return new TembooError('TembooCredentialError', message);
}

var TembooNotFoundError = function(message) {
    return new TembooError('NotFound', message);
}

var TembooObjectNotAccessibleError = function(message) {
    return new TembooError('TembooObjectNotAccessibleError', message);
}

var NonTembooException = function(message) {
    return new TembooError('NonTembooException', message);
}

exports.determineException = determineException;
exports.TembooDisallowedInputError = TembooDisallowedInputError;
exports.TembooNotFoundError = TembooNotFoundError;
exports.TembooError = TembooError;
