
var util = require("util");
var choreography = require("temboo/core/choreography");


/*
    RunQuery
    Executes a specified YQL (Yahoo Query Language) statement.
*/


var RunQuery = function(session) {
    /*
        Create a new instance of the RunQuery Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Yahoo/YQL/RunQuery"
    RunQuery.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new RunQueryResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new RunQueryInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the RunQuery
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var RunQueryInputSet = function() {
    RunQueryInputSet.super_.call(this);
        /*
        Set the value of the Diagnostics input for this Choreo. ((optional, boolean) When set to "true" (the default), additional debug information about the request is returned.)
        */
        this.set_Diagnostics = function(value) {
            this.setInput("Diagnostics", value);
        }

        /*
        Set the value of the Query input for this Choreo. ((required, string) A YQL (Yahoo! Query Language) statement to execute.)
        */
        this.set_Query = function(value) {
            this.setInput("Query", value);
        }

        /*
        Set the value of the ResponseFormat input for this Choreo. ((optional, string) The format that the response should be in. Valid values are: json (the default) and xml.)
        */
        this.set_ResponseFormat = function(value) {
            this.setInput("ResponseFormat", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the RunQuery Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var RunQueryResultSet = function(resultStream) {
    RunQueryResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from Yahoo.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(RunQuery, choreography.Choreography);
util.inherits(RunQueryInputSet, choreography.InputSet);
util.inherits(RunQueryResultSet, choreography.ResultSet);
exports.RunQuery = RunQuery;


/*
    ScrapeWebPage
    Scrapes HTML from a web page and converts it to JSON or XML so that it can be reused by an application.
*/


var ScrapeWebPage = function(session) {
    /*
        Create a new instance of the ScrapeWebPage Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Yahoo/YQL/ScrapeWebPage"
    ScrapeWebPage.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new ScrapeWebPageResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new ScrapeWebPageInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the ScrapeWebPage
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var ScrapeWebPageInputSet = function() {
    ScrapeWebPageInputSet.super_.call(this);
        /*
        Set the value of the Diagnostics input for this Choreo. ((optional, boolean) When set to "true" (the default), additional debug information about the request is returned.)
        */
        this.set_Diagnostics = function(value) {
            this.setInput("Diagnostics", value);
        }

        /*
        Set the value of the ResponseFormat input for this Choreo. ((optional, string) The format that the response should be in. Valid values are: json (the default) and xml.)
        */
        this.set_ResponseFormat = function(value) {
            this.setInput("ResponseFormat", value);
        }

        /*
        Set the value of the URL input for this Choreo. ((required, string) The URL of the web page to scrape.)
        */
        this.set_URL = function(value) {
            this.setInput("URL", value);
        }

        /*
        Set the value of the XPATH input for this Choreo. ((optional, string) An XPATH statement that can be used to extract specific information from the HTML.)
        */
        this.set_XPATH = function(value) {
            this.setInput("XPATH", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the ScrapeWebPage Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var ScrapeWebPageResultSet = function(resultStream) {
    ScrapeWebPageResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from Yahoo.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(ScrapeWebPage, choreography.Choreography);
util.inherits(ScrapeWebPageInputSet, choreography.InputSet);
util.inherits(ScrapeWebPageResultSet, choreography.ResultSet);
exports.ScrapeWebPage = ScrapeWebPage;

