
var util = require("util");
var choreography = require("temboo/core/choreography");


/*
    DeleteToken
    Deletes a specified token.
*/


var DeleteToken = function(session) {
    /*
        Create a new instance of the DeleteToken Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Utilities/TokenStorage/DeleteToken"
    DeleteToken.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new DeleteTokenResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new DeleteTokenInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the DeleteToken
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var DeleteTokenInputSet = function() {
    DeleteTokenInputSet.super_.call(this);
        /*
        Set the value of the Name input for this Choreo. ((required, string) The name of the token to delete.)
        */
        this.set_Name = function(value) {
            this.setInput("Name", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the DeleteToken Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var DeleteTokenResultSet = function(resultStream) {
    DeleteTokenResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Deleted" output from this Choreo execution. ((boolean) Returns true when token is successfully deleted.)
        */
        this.get_Deleted = function() {
            return this.getResult("Deleted");
        }
}

util.inherits(DeleteToken, choreography.Choreography);
util.inherits(DeleteTokenInputSet, choreography.InputSet);
util.inherits(DeleteTokenResultSet, choreography.ResultSet);
exports.DeleteToken = DeleteToken;


/*
    GetTokenDetails
    Returns one or more tokens represented by a specified list of names.
*/


var GetTokenDetails = function(session) {
    /*
        Create a new instance of the GetTokenDetails Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Utilities/TokenStorage/GetTokenDetails"
    GetTokenDetails.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new GetTokenDetailsResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new GetTokenDetailsInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the GetTokenDetails
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var GetTokenDetailsInputSet = function() {
    GetTokenDetailsInputSet.super_.call(this);
        /*
        Set the value of the Names input for this Choreo. ((required, json) A list of tokens to return. This should be formated as a JSON array.)
        */
        this.set_Names = function(value) {
            this.setInput("Names", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the GetTokenDetails Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var GetTokenDetailsResultSet = function(resultStream) {
    GetTokenDetailsResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Tokens" output from this Choreo execution. ((json) The token values.)
        */
        this.get_Tokens = function() {
            return this.getResult("Tokens");
        }
}

util.inherits(GetTokenDetails, choreography.Choreography);
util.inherits(GetTokenDetailsInputSet, choreography.InputSet);
util.inherits(GetTokenDetailsResultSet, choreography.ResultSet);
exports.GetTokenDetails = GetTokenDetails;


/*
    IsLocked
    Returns true or false depending on whether the token is locked or not.
*/


var IsLocked = function(session) {
    /*
        Create a new instance of the IsLocked Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Utilities/TokenStorage/IsLocked"
    IsLocked.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new IsLockedResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new IsLockedInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the IsLocked
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var IsLockedInputSet = function() {
    IsLockedInputSet.super_.call(this);
        /*
        Set the value of the Name input for this Choreo. ((required, string) The name of the token to check.)
        */
        this.set_Name = function(value) {
            this.setInput("Name", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the IsLocked Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var IsLockedResultSet = function(resultStream) {
    IsLockedResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Locked" output from this Choreo execution. ((boolean) Returns true or false depending on whether the token is locked or not.)
        */
        this.get_Locked = function() {
            return this.getResult("Locked");
        }
}

util.inherits(IsLocked, choreography.Choreography);
util.inherits(IsLockedInputSet, choreography.InputSet);
util.inherits(IsLockedResultSet, choreography.ResultSet);
exports.IsLocked = IsLocked;


/*
    IsValid
    Returns true or false depending on whether the token is valid or not.
*/


var IsValid = function(session) {
    /*
        Create a new instance of the IsValid Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Utilities/TokenStorage/IsValid"
    IsValid.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new IsValidResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new IsValidInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the IsValid
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var IsValidInputSet = function() {
    IsValidInputSet.super_.call(this);
        /*
        Set the value of the Name input for this Choreo. ((required, string) The name of the token to check.)
        */
        this.set_Name = function(value) {
            this.setInput("Name", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the IsValid Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var IsValidResultSet = function(resultStream) {
    IsValidResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Valid" output from this Choreo execution. ((boolean) Returns true or false depending on whether the token is valid or not.)
        */
        this.get_Valid = function() {
            return this.getResult("Valid");
        }
}

util.inherits(IsValid, choreography.Choreography);
util.inherits(IsValidInputSet, choreography.InputSet);
util.inherits(IsValidResultSet, choreography.ResultSet);
exports.IsValid = IsValid;


/*
    LockToken
    Locks a specified token.
*/


var LockToken = function(session) {
    /*
        Create a new instance of the LockToken Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Utilities/TokenStorage/LockToken"
    LockToken.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new LockTokenResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new LockTokenInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the LockToken
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var LockTokenInputSet = function() {
    LockTokenInputSet.super_.call(this);
        /*
        Set the value of the Name input for this Choreo. ((required, string) The name of the token to lock.)
        */
        this.set_Name = function(value) {
            this.setInput("Name", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the LockToken Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var LockTokenResultSet = function(resultStream) {
    LockTokenResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Token" output from this Choreo execution. ((string) When a lock has been obtained, the token value will be returned. If a lock can not be obtained, and empty string is returned.)
        */
        this.get_Token = function() {
            return this.getResult("Token");
        }
}

util.inherits(LockToken, choreography.Choreography);
util.inherits(LockTokenInputSet, choreography.InputSet);
util.inherits(LockTokenResultSet, choreography.ResultSet);
exports.LockToken = LockToken;


/*
    RetrieveToken
    Retrieves a specified token.
*/


var RetrieveToken = function(session) {
    /*
        Create a new instance of the RetrieveToken Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Utilities/TokenStorage/RetrieveToken"
    RetrieveToken.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new RetrieveTokenResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new RetrieveTokenInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the RetrieveToken
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var RetrieveTokenInputSet = function() {
    RetrieveTokenInputSet.super_.call(this);
        /*
        Set the value of the LockToken input for this Choreo. ((optional, boolean) If set to true, the Choreo will attempt to lock the token after retrieving it. If the token is already locked, the Choreo will attempt to get the lock for up-to 1 minute.)
        */
        this.set_LockToken = function(value) {
            this.setInput("LockToken", value);
        }

        /*
        Set the value of the Name input for this Choreo. ((required, string) The name of the token to retrieve.)
        */
        this.set_Name = function(value) {
            this.setInput("Name", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the RetrieveToken Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var RetrieveTokenResultSet = function(resultStream) {
    RetrieveTokenResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Token" output from this Choreo execution. ((string) The token value. This will return an empty string if there is no token or if the token has expired.)
        */
        this.get_Token = function() {
            return this.getResult("Token");
        }
        /*
        Retrieve the value for the "Locked" output from this Choreo execution. ((boolean) Returns true or false depending on whether the token is locked or not.)
        */
        this.get_Locked = function() {
            return this.getResult("Locked");
        }
        /*
        Retrieve the value for the "Valid" output from this Choreo execution. ((boolean) Returns true or false depending on whether the token is valid or not.)
        */
        this.get_Valid = function() {
            return this.getResult("Valid");
        }
}

util.inherits(RetrieveToken, choreography.Choreography);
util.inherits(RetrieveTokenInputSet, choreography.InputSet);
util.inherits(RetrieveTokenResultSet, choreography.ResultSet);
exports.RetrieveToken = RetrieveToken;


/*
    SetValid
    Sets a specified token as valid or invalid.
*/


var SetValid = function(session) {
    /*
        Create a new instance of the SetValid Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Utilities/TokenStorage/SetValid"
    SetValid.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new SetValidResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new SetValidInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the SetValid
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var SetValidInputSet = function() {
    SetValidInputSet.super_.call(this);
        /*
        Set the value of the Name input for this Choreo. ((required, string) The name of the token to modify.)
        */
        this.set_Name = function(value) {
            this.setInput("Name", value);
        }

        /*
        Set the value of the Valid input for this Choreo. ((conditional, boolean) Can be set to true or false depending on whether the token is valid or not.)
        */
        this.set_Valid = function(value) {
            this.setInput("Valid", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the SetValid Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var SetValidResultSet = function(resultStream) {
    SetValidResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Updated" output from this Choreo execution. ((boolean) Returns true if the operation was successful.)
        */
        this.get_Updated = function() {
            return this.getResult("Updated");
        }
}

util.inherits(SetValid, choreography.Choreography);
util.inherits(SetValidInputSet, choreography.InputSet);
util.inherits(SetValidResultSet, choreography.ResultSet);
exports.SetValid = SetValid;


/*
    StoreToken
    Stores a token.
*/


var StoreToken = function(session) {
    /*
        Create a new instance of the StoreToken Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Utilities/TokenStorage/StoreToken"
    StoreToken.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new StoreTokenResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new StoreTokenInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the StoreToken
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var StoreTokenInputSet = function() {
    StoreTokenInputSet.super_.call(this);
        /*
        Set the value of the Expires input for this Choreo. ((optional, integer) The lifetime of the token (in seconds). Defaults to 0 indicating no expiration.)
        */
        this.set_Expires = function(value) {
            this.setInput("Expires", value);
        }

        /*
        Set the value of the Name input for this Choreo. ((required, string) The token name. When a token does not exist, it will be inserted. When a token does exist, an update is performed.)
        */
        this.set_Name = function(value) {
            this.setInput("Name", value);
        }

        /*
        Set the value of the Value input for this Choreo. ((required, string) The token value to store. The maximum number of characters for a token is 4096.)
        */
        this.set_Value = function(value) {
            this.setInput("Value", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the StoreToken Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var StoreTokenResultSet = function(resultStream) {
    StoreTokenResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Updated" output from this Choreo execution. ((boolean) Returns true if token is stored successfully.)
        */
        this.get_Updated = function() {
            return this.getResult("Updated");
        }
}

util.inherits(StoreToken, choreography.Choreography);
util.inherits(StoreTokenInputSet, choreography.InputSet);
util.inherits(StoreTokenResultSet, choreography.ResultSet);
exports.StoreToken = StoreToken;

