
var util = require("util");
var choreography = require("temboo/core/choreography");


/*
    GenerateGUID
    Obtain a unique, randomly generated ID or GUID (Globally Unique Identifier).
*/


var GenerateGUID = function(session) {
    /*
        Create a new instance of the GenerateGUID Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Utilities/Text/GenerateGUID"
    GenerateGUID.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new GenerateGUIDResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new GenerateGUIDInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the GenerateGUID
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var GenerateGUIDInputSet = function() {
    GenerateGUIDInputSet.super_.call(this);
}

/*
A ResultSet with methods tailored to the values returned by the GenerateGUID Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var GenerateGUIDResultSet = function(resultStream) {
    GenerateGUIDResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "GUID" output from this Choreo execution. ((string) The generated GUID.)
        */
        this.get_GUID = function() {
            return this.getResult("GUID");
        }
}

util.inherits(GenerateGUID, choreography.Choreography);
util.inherits(GenerateGUIDInputSet, choreography.InputSet);
util.inherits(GenerateGUIDResultSet, choreography.ResultSet);
exports.GenerateGUID = GenerateGUID;


/*
    Lowercase
    Returns the contents of the specified string converted to lowercase.
*/


var Lowercase = function(session) {
    /*
        Create a new instance of the Lowercase Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Utilities/Text/Lowercase"
    Lowercase.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new LowercaseResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new LowercaseInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the Lowercase
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var LowercaseInputSet = function() {
    LowercaseInputSet.super_.call(this);
        /*
        Set the value of the Text input for this Choreo. ((required, multiline) The text that should be converted to lowercase.)
        */
        this.set_Text = function(value) {
            this.setInput("Text", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the Lowercase Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var LowercaseResultSet = function(resultStream) {
    LowercaseResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((string) The converted lowercase text.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(Lowercase, choreography.Choreography);
util.inherits(LowercaseInputSet, choreography.InputSet);
util.inherits(LowercaseResultSet, choreography.ResultSet);
exports.Lowercase = Lowercase;


/*
    Split
    Splits a string into sub-strings delimited by the specified delmiter pattern.
*/


var Split = function(session) {
    /*
        Create a new instance of the Split Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Utilities/Text/Split"
    Split.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new SplitResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new SplitInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the Split
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var SplitInputSet = function() {
    SplitInputSet.super_.call(this);
        /*
        Set the value of the Delimiter input for this Choreo. ((required, string) The delimiter to search for when splitting the string into sub-strings. See Choreo notes for restrictions with delimiters.)
        */
        this.set_Delimiter = function(value) {
            this.setInput("Delimiter", value);
        }

        /*
        Set the value of the Text input for this Choreo. ((required, multiline) The text that should be split into sub-strings.)
        */
        this.set_Text = function(value) {
            this.setInput("Text", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the Split Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var SplitResultSet = function(resultStream) {
    SplitResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((string) Contains the sub-strings formatted as a JSON array.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(Split, choreography.Choreography);
util.inherits(SplitInputSet, choreography.InputSet);
util.inherits(SplitResultSet, choreography.ResultSet);
exports.Split = Split;


/*
    Substitute
    Replaces all instances of the specified sub-string within the specified text with a new sub-string. 
*/


var Substitute = function(session) {
    /*
        Create a new instance of the Substitute Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Utilities/Text/Substitute"
    Substitute.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new SubstituteResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new SubstituteInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the Substitute
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var SubstituteInputSet = function() {
    SubstituteInputSet.super_.call(this);
        /*
        Set the value of the New input for this Choreo. ((required, string) New sub-string to replace with.)
        */
        this.set_New = function(value) {
            this.setInput("New", value);
        }

        /*
        Set the value of the Old input for this Choreo. ((required, string) Old sub-string to replace.)
        */
        this.set_Old = function(value) {
            this.setInput("Old", value);
        }

        /*
        Set the value of the Text input for this Choreo. ((required, string) Text to peform substitution.)
        */
        this.set_Text = function(value) {
            this.setInput("Text", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the Substitute Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var SubstituteResultSet = function(resultStream) {
    SubstituteResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((string) The result after the substitution.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(Substitute, choreography.Choreography);
util.inherits(SubstituteInputSet, choreography.InputSet);
util.inherits(SubstituteResultSet, choreography.ResultSet);
exports.Substitute = Substitute;


/*
    SubstituteRegex
    Finds all instances of the specified regular expression pattern within the given string and passes the specified new sub-string to the result variable. 
*/


var SubstituteRegex = function(session) {
    /*
        Create a new instance of the SubstituteRegex Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Utilities/Text/SubstituteRegex"
    SubstituteRegex.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new SubstituteRegexResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new SubstituteRegexInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the SubstituteRegex
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var SubstituteRegexInputSet = function() {
    SubstituteRegexInputSet.super_.call(this);
        /*
        Set the value of the New input for this Choreo. ((required, string) New sub-string to replace with.)
        */
        this.set_New = function(value) {
            this.setInput("New", value);
        }

        /*
        Set the value of the Pattern input for this Choreo. ((required, string) Regex pattern to use.)
        */
        this.set_Pattern = function(value) {
            this.setInput("Pattern", value);
        }

        /*
        Set the value of the Text input for this Choreo. ((required, string) Text to peform substitution.)
        */
        this.set_Text = function(value) {
            this.setInput("Text", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the SubstituteRegex Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var SubstituteRegexResultSet = function(resultStream) {
    SubstituteRegexResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((string) The result after the substitution.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(SubstituteRegex, choreography.Choreography);
util.inherits(SubstituteRegexInputSet, choreography.InputSet);
util.inherits(SubstituteRegexResultSet, choreography.ResultSet);
exports.SubstituteRegex = SubstituteRegex;


/*
    Uppercase
    Returns the contents of the specified string converted to uppercase.
*/


var Uppercase = function(session) {
    /*
        Create a new instance of the Uppercase Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Utilities/Text/Uppercase"
    Uppercase.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new UppercaseResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new UppercaseInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the Uppercase
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var UppercaseInputSet = function() {
    UppercaseInputSet.super_.call(this);
        /*
        Set the value of the Text input for this Choreo. ((required, multiline) The text that should be converted to uppercase.)
        */
        this.set_Text = function(value) {
            this.setInput("Text", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the Uppercase Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var UppercaseResultSet = function(resultStream) {
    UppercaseResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((string) The converted uppercase text.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(Uppercase, choreography.Choreography);
util.inherits(UppercaseInputSet, choreography.InputSet);
util.inherits(UppercaseResultSet, choreography.ResultSet);
exports.Uppercase = Uppercase;

