
var util = require("util");
var choreography = require("temboo/core/choreography");


/*
    HelloWorld
    Allows you to run a simple test that outputs "Hello, world!" when executed.
*/


var HelloWorld = function(session) {
    /*
        Create a new instance of the HelloWorld Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Utilities/Test/HelloWorld"
    HelloWorld.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new HelloWorldResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new HelloWorldInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the HelloWorld
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var HelloWorldInputSet = function() {
    HelloWorldInputSet.super_.call(this);
        /*
        Set the value of the Value input for this Choreo. ((conditional, string) An optional test value to pass into the result message.)
        */
        this.set_Value = function(value) {
            this.setInput("Value", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the HelloWorld Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var HelloWorldResultSet = function(resultStream) {
    HelloWorldResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Result" output from this Choreo execution. ((string) Contains a sample Choreo output. If no input is provided, the result will be "Hello, world!". When passing an input value, the result will be "Hello, {Value}!".)
        */
        this.get_Result = function() {
            return this.getResult("Result");
        }
}

util.inherits(HelloWorld, choreography.Choreography);
util.inherits(HelloWorldInputSet, choreography.InputSet);
util.inherits(HelloWorldResultSet, choreography.ResultSet);
exports.HelloWorld = HelloWorld;

