
var util = require("util");
var choreography = require("temboo/core/choreography");


/*
    PostEvent
    Triggers an event on one or more channels.
*/


var PostEvent = function(session) {
    /*
        Create a new instance of the PostEvent Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Pusher/Events/PostEvent"
    PostEvent.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new PostEventResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new PostEventInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the PostEvent
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var PostEventInputSet = function() {
    PostEventInputSet.super_.call(this);
        /*
        Set the value of the AppID input for this Choreo. ((required, string) The application ID provided by Pusher.)
        */
        this.set_AppID = function(value) {
            this.setInput("AppID", value);
        }

        /*
        Set the value of the AppKey input for this Choreo. ((required, string) The authenticaion key provided by Pusher.)
        */
        this.set_AppKey = function(value) {
            this.setInput("AppKey", value);
        }

        /*
        Set the value of the AppSecret input for this Choreo. ((required, string) The authentication secret provided by Pusher.)
        */
        this.set_AppSecret = function(value) {
            this.setInput("AppSecret", value);
        }

        /*
        Set the value of the ChannelName input for this Choreo. ((required, string) The name of the channel to publish to. This can also be a list of channels formatted as a JSON array.)
        */
        this.set_ChannelName = function(value) {
            this.setInput("ChannelName", value);
        }

        /*
        Set the value of the EventData input for this Choreo. ((required, json) A JSON object containing the event data.)
        */
        this.set_EventData = function(value) {
            this.setInput("EventData", value);
        }

        /*
        Set the value of the EventName input for this Choreo. ((required, string) The name of the event being triggered.)
        */
        this.set_EventName = function(value) {
            this.setInput("EventName", value);
        }

        /*
        Set the value of the SocketID input for this Choreo. ((optional, string) Excludes the event from being sent to a specific connection.)
        */
        this.set_SocketID = function(value) {
            this.setInput("SocketID", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the PostEvent Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var PostEventResultSet = function(resultStream) {
    PostEventResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Pusher. A successful request returns an empty JSON hash.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(PostEvent, choreography.Choreography);
util.inherits(PostEventInputSet, choreography.InputSet);
util.inherits(PostEventResultSet, choreography.ResultSet);
exports.PostEvent = PostEvent;

