
var util = require("util");
var choreography = require("temboo/core/choreography");


/*
    DeleteRange
    Deletes the cells associated with the range.
*/


var DeleteRange = function(session) {
    /*
        Create a new instance of the DeleteRange Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Microsoft/Excel/Range/DeleteRange"
    DeleteRange.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new DeleteRangeResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new DeleteRangeInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the DeleteRange
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var DeleteRangeInputSet = function() {
    DeleteRangeInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((optional, string) A valid Access Token retrieved during the OAuth process. This can be passed if your application is authenticating multiple Office 365 users.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the ClientID input for this Choreo. ((conditional, string) The Client ID provided by Microsoft. This is requried unless providing a valid AccessToken (see optional inputs).)
        */
        this.set_ClientID = function(value) {
            this.setInput("ClientID", value);
        }

        /*
        Set the value of the ClientSecret input for this Choreo. ((conditional, string) The Client Secret provided by Microsoft. This is requried unless providing a valid AccessToken (see optional inputs).)
        */
        this.set_ClientSecret = function(value) {
            this.setInput("ClientSecret", value);
        }

        /*
        Set the value of the ItemPath input for this Choreo. ((required, string) The location of the spreadsheet in OneDrive (e.g. MyFolder/Book.xlsx).)
        */
        this.set_ItemPath = function(value) {
            this.setInput("ItemPath", value);
        }

        /*
        Set the value of the Password input for this Choreo. ((conditional, password) Your Microsoft password. This is requried unless providing a valid AccessToken (see optional inputs).)
        */
        this.set_Password = function(value) {
            this.setInput("Password", value);
        }

        /*
        Set the value of the Range input for this Choreo. ((conditional, string) A cell ange to delete (e.g. A1:B2).)
        */
        this.set_Range = function(value) {
            this.setInput("Range", value);
        }

        /*
        Set the value of the Shift input for this Choreo. ((required, string) Specifies which way to shift the cells.  Possible values are: Up, Left.)
        */
        this.set_Shift = function(value) {
            this.setInput("Shift", value);
        }

        /*
        Set the value of the Username input for this Choreo. ((conditional, string) Your Microsoft username. This is requried unless providing a valid AccessToken (see optional inputs).)
        */
        this.set_Username = function(value) {
            this.setInput("Username", value);
        }

        /*
        Set the value of the Worksheet input for this Choreo. ((required, string) The name or id of the worksheet.)
        */
        this.set_Worksheet = function(value) {
            this.setInput("Worksheet", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the DeleteRange Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var DeleteRangeResultSet = function(resultStream) {
    DeleteRangeResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "ResponseCode" output from this Choreo execution. ((integer) The response status code. A 204 is returned for a successful deletion.)
        */
        this.get_ResponseCode = function() {
            return this.getResult("ResponseCode");
        }
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Microsoft.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(DeleteRange, choreography.Choreography);
util.inherits(DeleteRangeInputSet, choreography.InputSet);
util.inherits(DeleteRangeResultSet, choreography.ResultSet);
exports.DeleteRange = DeleteRange;


/*
    GetLastCell
    Retrieves the last cell within a specified range.
*/


var GetLastCell = function(session) {
    /*
        Create a new instance of the GetLastCell Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Microsoft/Excel/Range/GetLastCell"
    GetLastCell.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new GetLastCellResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new GetLastCellInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the GetLastCell
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var GetLastCellInputSet = function() {
    GetLastCellInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((optional, string) A valid Access Token retrieved during the OAuth process. This can be passed if your application is authenticating multiple Office 365 users.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the ClientID input for this Choreo. ((conditional, string) The Client ID provided by Microsoft. This is requried unless providing a valid AccessToken (see optional inputs).)
        */
        this.set_ClientID = function(value) {
            this.setInput("ClientID", value);
        }

        /*
        Set the value of the ClientSecret input for this Choreo. ((conditional, string) The Client Secret provided by Microsoft. This is requried unless providing a valid AccessToken (see optional inputs).)
        */
        this.set_ClientSecret = function(value) {
            this.setInput("ClientSecret", value);
        }

        /*
        Set the value of the ItemPath input for this Choreo. ((required, string) The location of the spreadsheet in OneDrive (e.g. MyFolder/Book.xlsx).)
        */
        this.set_ItemPath = function(value) {
            this.setInput("ItemPath", value);
        }

        /*
        Set the value of the Password input for this Choreo. ((conditional, password) Your Microsoft password. This is requried unless providing a valid AccessToken (see optional inputs).)
        */
        this.set_Password = function(value) {
            this.setInput("Password", value);
        }

        /*
        Set the value of the Range input for this Choreo. ((conditional, string) The cell range to consider (e.g. A1:C100).)
        */
        this.set_Range = function(value) {
            this.setInput("Range", value);
        }

        /*
        Set the value of the Select input for this Choreo. ((optional, string) Comma-separated list of properties to include in the response.)
        */
        this.set_Select = function(value) {
            this.setInput("Select", value);
        }

        /*
        Set the value of the Username input for this Choreo. ((conditional, string) Your Microsoft username. This is requried unless providing a valid AccessToken (see optional inputs).)
        */
        this.set_Username = function(value) {
            this.setInput("Username", value);
        }

        /*
        Set the value of the Worksheet input for this Choreo. ((required, string) The name or id of the worksheet.)
        */
        this.set_Worksheet = function(value) {
            this.setInput("Worksheet", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the GetLastCell Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var GetLastCellResultSet = function(resultStream) {
    GetLastCellResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Microsoft.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(GetLastCell, choreography.Choreography);
util.inherits(GetLastCellInputSet, choreography.InputSet);
util.inherits(GetLastCellResultSet, choreography.ResultSet);
exports.GetLastCell = GetLastCell;


/*
    GetLastColumn
    Retrieves the last column within a specified range.
*/


var GetLastColumn = function(session) {
    /*
        Create a new instance of the GetLastColumn Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Microsoft/Excel/Range/GetLastColumn"
    GetLastColumn.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new GetLastColumnResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new GetLastColumnInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the GetLastColumn
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var GetLastColumnInputSet = function() {
    GetLastColumnInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((optional, string) A valid Access Token retrieved during the OAuth process. This can be passed if your application is authenticating multiple Office 365 users.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the ClientID input for this Choreo. ((conditional, string) The Client ID provided by Microsoft. This is requried unless providing a valid AccessToken (see optional inputs).)
        */
        this.set_ClientID = function(value) {
            this.setInput("ClientID", value);
        }

        /*
        Set the value of the ClientSecret input for this Choreo. ((conditional, string) The Client Secret provided by Microsoft. This is requried unless providing a valid AccessToken (see optional inputs).)
        */
        this.set_ClientSecret = function(value) {
            this.setInput("ClientSecret", value);
        }

        /*
        Set the value of the ItemPath input for this Choreo. ((required, string) The location of the spreadsheet in OneDrive (e.g. MyFolder/Book.xlsx).)
        */
        this.set_ItemPath = function(value) {
            this.setInput("ItemPath", value);
        }

        /*
        Set the value of the Password input for this Choreo. ((conditional, password) Your Microsoft password. This is requried unless providing a valid AccessToken (see optional inputs).)
        */
        this.set_Password = function(value) {
            this.setInput("Password", value);
        }

        /*
        Set the value of the Range input for this Choreo. ((conditional, string) The cell range to consider (e.g. A1:C100).)
        */
        this.set_Range = function(value) {
            this.setInput("Range", value);
        }

        /*
        Set the value of the Select input for this Choreo. ((optional, string) Comma-separated list of properties to include in the response.)
        */
        this.set_Select = function(value) {
            this.setInput("Select", value);
        }

        /*
        Set the value of the Username input for this Choreo. ((conditional, string) Your Microsoft username. This is requried unless providing a valid AccessToken (see optional inputs).)
        */
        this.set_Username = function(value) {
            this.setInput("Username", value);
        }

        /*
        Set the value of the Worksheet input for this Choreo. ((required, string) The name or id of the worksheet.)
        */
        this.set_Worksheet = function(value) {
            this.setInput("Worksheet", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the GetLastColumn Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var GetLastColumnResultSet = function(resultStream) {
    GetLastColumnResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Microsoft.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(GetLastColumn, choreography.Choreography);
util.inherits(GetLastColumnInputSet, choreography.InputSet);
util.inherits(GetLastColumnResultSet, choreography.ResultSet);
exports.GetLastColumn = GetLastColumn;


/*
    GetLastRow
    Retrieves the last row within a specified range.
*/


var GetLastRow = function(session) {
    /*
        Create a new instance of the GetLastRow Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Microsoft/Excel/Range/GetLastRow"
    GetLastRow.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new GetLastRowResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new GetLastRowInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the GetLastRow
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var GetLastRowInputSet = function() {
    GetLastRowInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((optional, string) A valid Access Token retrieved during the OAuth process. This can be passed if your application is authenticating multiple Office 365 users.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the ClientID input for this Choreo. ((conditional, string) The Client ID provided by Microsoft. This is requried unless providing a valid AccessToken (see optional inputs).)
        */
        this.set_ClientID = function(value) {
            this.setInput("ClientID", value);
        }

        /*
        Set the value of the ClientSecret input for this Choreo. ((conditional, string) The Client Secret provided by Microsoft. This is requried unless providing a valid AccessToken (see optional inputs).)
        */
        this.set_ClientSecret = function(value) {
            this.setInput("ClientSecret", value);
        }

        /*
        Set the value of the ItemPath input for this Choreo. ((required, string) The location of the spreadsheet in OneDrive (e.g. MyFolder/Book.xlsx).)
        */
        this.set_ItemPath = function(value) {
            this.setInput("ItemPath", value);
        }

        /*
        Set the value of the Password input for this Choreo. ((conditional, password) Your Microsoft password. This is requried unless providing a valid AccessToken (see optional inputs).)
        */
        this.set_Password = function(value) {
            this.setInput("Password", value);
        }

        /*
        Set the value of the Range input for this Choreo. ((conditional, string) The cell range to consider (e.g. A1:C100).)
        */
        this.set_Range = function(value) {
            this.setInput("Range", value);
        }

        /*
        Set the value of the Select input for this Choreo. ((optional, string) Comma-separated list of properties to include in the response.)
        */
        this.set_Select = function(value) {
            this.setInput("Select", value);
        }

        /*
        Set the value of the Username input for this Choreo. ((conditional, string) Your Microsoft username. This is requried unless providing a valid AccessToken (see optional inputs).)
        */
        this.set_Username = function(value) {
            this.setInput("Username", value);
        }

        /*
        Set the value of the Worksheet input for this Choreo. ((required, string) The name or id of the worksheet.)
        */
        this.set_Worksheet = function(value) {
            this.setInput("Worksheet", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the GetLastRow Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var GetLastRowResultSet = function(resultStream) {
    GetLastRowResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Microsoft.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(GetLastRow, choreography.Choreography);
util.inherits(GetLastRowInputSet, choreography.InputSet);
util.inherits(GetLastRowResultSet, choreography.ResultSet);
exports.GetLastRow = GetLastRow;


/*
    GetRange
    Retrieves the properties and relationships of range object.
*/


var GetRange = function(session) {
    /*
        Create a new instance of the GetRange Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Microsoft/Excel/Range/GetRange"
    GetRange.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new GetRangeResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new GetRangeInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the GetRange
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var GetRangeInputSet = function() {
    GetRangeInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((optional, string) A valid Access Token retrieved during the OAuth process. This can be passed if your application is authenticating multiple Office 365 users.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the ClientID input for this Choreo. ((conditional, string) The Client ID provided by Microsoft. This is requried unless providing a valid AccessToken (see optional inputs).)
        */
        this.set_ClientID = function(value) {
            this.setInput("ClientID", value);
        }

        /*
        Set the value of the ClientSecret input for this Choreo. ((conditional, string) The Client Secret provided by Microsoft. This is requried unless providing a valid AccessToken (see optional inputs).)
        */
        this.set_ClientSecret = function(value) {
            this.setInput("ClientSecret", value);
        }

        /*
        Set the value of the ItemPath input for this Choreo. ((required, string) The location of the spreadsheet in OneDrive (e.g. MyFolder/Book.xlsx).)
        */
        this.set_ItemPath = function(value) {
            this.setInput("ItemPath", value);
        }

        /*
        Set the value of the Password input for this Choreo. ((conditional, password) Your Microsoft password. This is requried unless providing a valid AccessToken (see optional inputs).)
        */
        this.set_Password = function(value) {
            this.setInput("Password", value);
        }

        /*
        Set the value of the Range input for this Choreo. ((conditional, string) A range to return (e.g. A1:B2).)
        */
        this.set_Range = function(value) {
            this.setInput("Range", value);
        }

        /*
        Set the value of the Select input for this Choreo. ((optional, string) Comma-separated list of properties to include in the response.)
        */
        this.set_Select = function(value) {
            this.setInput("Select", value);
        }

        /*
        Set the value of the Username input for this Choreo. ((conditional, string) Your Microsoft username. This is requried unless providing a valid AccessToken (see optional inputs).)
        */
        this.set_Username = function(value) {
            this.setInput("Username", value);
        }

        /*
        Set the value of the Worksheet input for this Choreo. ((required, string) The name or id of the worksheet.)
        */
        this.set_Worksheet = function(value) {
            this.setInput("Worksheet", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the GetRange Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var GetRangeResultSet = function(resultStream) {
    GetRangeResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Microsoft.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(GetRange, choreography.Choreography);
util.inherits(GetRangeInputSet, choreography.InputSet);
util.inherits(GetRangeResultSet, choreography.ResultSet);
exports.GetRange = GetRange;

