
var util = require("util");
var choreography = require("temboo/core/choreography");


/*
    AppendValues
    Appends values to a spreadsheet.
*/


var AppendValues = function(session) {
    /*
        Create a new instance of the AppendValues Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Google/Sheets/AppendValues"
    AppendValues.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new AppendValuesResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new AppendValuesInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the AppendValues
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var AppendValuesInputSet = function() {
    AppendValuesInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the ClientID input for this Choreo. ((conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.)
        */
        this.set_ClientID = function(value) {
            this.setInput("ClientID", value);
        }

        /*
        Set the value of the ClientSecret input for this Choreo. ((conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.)
        */
        this.set_ClientSecret = function(value) {
            this.setInput("ClientSecret", value);
        }

        /*
        Set the value of the Fields input for this Choreo. ((optional, string) A comma-separated list of fields to include in the response. See Choreo notes for syntax details.)
        */
        this.set_Fields = function(value) {
            this.setInput("Fields", value);
        }

        /*
        Set the value of the InsertDataOption input for this Choreo. ((optional, string) Specifies how the input data should be inserted. Valid values are: INSERT_ROWS (the default) and OVERWRITE.)
        */
        this.set_InsertDataOption = function(value) {
            this.setInput("InsertDataOption", value);
        }

        /*
        Set the value of the MajorDimension input for this Choreo. ((optional, string) Indicates the dimension that the values array applies to. Valid values are ROWS (the default) or COLUMNS.)
        */
        this.set_MajorDimension = function(value) {
            this.setInput("MajorDimension", value);
        }

        /*
        Set the value of the Range input for this Choreo. ((optional, string) The A1 notation of a range to begin appending to. Defaults to "A1" (begins at the first row). Values will be appended at the first empty row of this range. See Choreos notes for more details.)
        */
        this.set_Range = function(value) {
            this.setInput("Range", value);
        }

        /*
        Set the value of the RefreshToken input for this Choreo. ((conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.)
        */
        this.set_RefreshToken = function(value) {
            this.setInput("RefreshToken", value);
        }

        /*
        Set the value of the SpreadsheetID input for this Choreo. ((required, string) The ID of the spreadsheet. This can be found in the URL when viewing your spreadsheet in your web browser.)
        */
        this.set_SpreadsheetID = function(value) {
            this.setInput("SpreadsheetID", value);
        }

        /*
        Set the value of the ValueInputOption input for this Choreo. ((optional, string) Specifies how the input data should be interpreted. Valid values are: RAW (the default) and USER_ENTERED.)
        */
        this.set_ValueInputOption = function(value) {
            this.setInput("ValueInputOption", value);
        }

        /*
        Set the value of the Values input for this Choreo. ((required, json) This is an array of arrays. The outer array can represent one or more rows while the inner array can represent one or more cell values. See Choreo notes below for more details.)
        */
        this.set_Values = function(value) {
            this.setInput("Values", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the AppendValues Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var AppendValuesResultSet = function(resultStream) {
    AppendValuesResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "NewAccessToken" output from this Choreo execution. ((string) Contains a new AccessToken when the RefreshToken is provided.)
        */
        this.get_NewAccessToken = function() {
            return this.getResult("NewAccessToken");
        }
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Google.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(AppendValues, choreography.Choreography);
util.inherits(AppendValuesInputSet, choreography.InputSet);
util.inherits(AppendValuesResultSet, choreography.ResultSet);
exports.AppendValues = AppendValues;


/*
    BatchGetValues
    Returns one or more ranges of values from a spreadsheet.
*/


var BatchGetValues = function(session) {
    /*
        Create a new instance of the BatchGetValues Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Google/Sheets/BatchGetValues"
    BatchGetValues.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new BatchGetValuesResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new BatchGetValuesInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the BatchGetValues
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var BatchGetValuesInputSet = function() {
    BatchGetValuesInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the ClientID input for this Choreo. ((conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.)
        */
        this.set_ClientID = function(value) {
            this.setInput("ClientID", value);
        }

        /*
        Set the value of the ClientSecret input for this Choreo. ((conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.)
        */
        this.set_ClientSecret = function(value) {
            this.setInput("ClientSecret", value);
        }

        /*
        Set the value of the DateTimeRenderOption input for this Choreo. ((optional, string) How dates, times, and durations should be represented in the output. Valid values are: SERIAL_NUMBER or FORMATTED_STRING. This is ignored if valueRenderOption is FORMATTED_VALUE.)
        */
        this.set_DateTimeRenderOption = function(value) {
            this.setInput("DateTimeRenderOption", value);
        }

        /*
        Set the value of the Fields input for this Choreo. ((optional, string) A comma-separated list of fields to include in the response. See Choreo notes for syntax details.)
        */
        this.set_Fields = function(value) {
            this.setInput("Fields", value);
        }

        /*
        Set the value of the MajorDimension input for this Choreo. ((optional, string) Indicates the dimension that results should use. Valid values are ROWS (the default) or COLUMNS.)
        */
        this.set_MajorDimension = function(value) {
            this.setInput("MajorDimension", value);
        }

        /*
        Set the value of the Ranges input for this Choreo. ((required, string) The A1 notation of the values to retrieve formatted as an array (e.g. ["Sheet1!A2:C3"]). Note, this input supports up to 10 ranges.)
        */
        this.set_Ranges = function(value) {
            this.setInput("Ranges", value);
        }

        /*
        Set the value of the RefreshToken input for this Choreo. ((conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.)
        */
        this.set_RefreshToken = function(value) {
            this.setInput("RefreshToken", value);
        }

        /*
        Set the value of the SpreadsheetID input for this Choreo. ((required, string) The ID of the spreadsheet. This can be found in the URL when viewing your spreadsheet in your web browser.)
        */
        this.set_SpreadsheetID = function(value) {
            this.setInput("SpreadsheetID", value);
        }

        /*
        Set the value of the ValueRenderOption input for this Choreo. ((optional, string) How values should be represented in the output. Valid values are: FORMATTED_VALUE, UNFORMATTED_VALUE, or FORMULA.)
        */
        this.set_ValueRenderOption = function(value) {
            this.setInput("ValueRenderOption", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the BatchGetValues Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var BatchGetValuesResultSet = function(resultStream) {
    BatchGetValuesResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "NewAccessToken" output from this Choreo execution. ((string) Contains a new AccessToken when the RefreshToken is provided.)
        */
        this.get_NewAccessToken = function() {
            return this.getResult("NewAccessToken");
        }
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Google.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(BatchGetValues, choreography.Choreography);
util.inherits(BatchGetValuesInputSet, choreography.InputSet);
util.inherits(BatchGetValuesResultSet, choreography.ResultSet);
exports.BatchGetValues = BatchGetValues;


/*
    BatchUpdateValues
    Updates values in one or more ranges of a spreadsheet. 
*/


var BatchUpdateValues = function(session) {
    /*
        Create a new instance of the BatchUpdateValues Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Google/Sheets/BatchUpdateValues"
    BatchUpdateValues.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new BatchUpdateValuesResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new BatchUpdateValuesInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the BatchUpdateValues
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var BatchUpdateValuesInputSet = function() {
    BatchUpdateValuesInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the ClientID input for this Choreo. ((conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.)
        */
        this.set_ClientID = function(value) {
            this.setInput("ClientID", value);
        }

        /*
        Set the value of the ClientSecret input for this Choreo. ((conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.)
        */
        this.set_ClientSecret = function(value) {
            this.setInput("ClientSecret", value);
        }

        /*
        Set the value of the Data input for this Choreo. ((required, json) An array of JSON objects containing the ranges and values to update. See Choreo notes below for more details.)
        */
        this.set_Data = function(value) {
            this.setInput("Data", value);
        }

        /*
        Set the value of the Fields input for this Choreo. ((optional, string) A comma-separated list of fields to include in the response. See Choreo notes for syntax details.)
        */
        this.set_Fields = function(value) {
            this.setInput("Fields", value);
        }

        /*
        Set the value of the RefreshToken input for this Choreo. ((conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.)
        */
        this.set_RefreshToken = function(value) {
            this.setInput("RefreshToken", value);
        }

        /*
        Set the value of the SpreadsheetID input for this Choreo. ((required, string) The ID of the spreadsheet. This can be found in the URL when viewing your spreadsheet in your web browser.)
        */
        this.set_SpreadsheetID = function(value) {
            this.setInput("SpreadsheetID", value);
        }

        /*
        Set the value of the ValueInputOption input for this Choreo. ((optional, string) Specifies how the input data should be interpreted. Valid values are: RAW (the default) and USER_ENTERED.)
        */
        this.set_ValueInputOption = function(value) {
            this.setInput("ValueInputOption", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the BatchUpdateValues Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var BatchUpdateValuesResultSet = function(resultStream) {
    BatchUpdateValuesResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "NewAccessToken" output from this Choreo execution. ((string) Contains a new AccessToken when the RefreshToken is provided.)
        */
        this.get_NewAccessToken = function() {
            return this.getResult("NewAccessToken");
        }
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Google.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(BatchUpdateValues, choreography.Choreography);
util.inherits(BatchUpdateValuesInputSet, choreography.InputSet);
util.inherits(BatchUpdateValuesResultSet, choreography.ResultSet);
exports.BatchUpdateValues = BatchUpdateValues;


/*
    ClearValues
    Clears values from a spreadsheet.
*/


var ClearValues = function(session) {
    /*
        Create a new instance of the ClearValues Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Google/Sheets/ClearValues"
    ClearValues.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new ClearValuesResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new ClearValuesInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the ClearValues
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var ClearValuesInputSet = function() {
    ClearValuesInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the ClientID input for this Choreo. ((conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.)
        */
        this.set_ClientID = function(value) {
            this.setInput("ClientID", value);
        }

        /*
        Set the value of the ClientSecret input for this Choreo. ((conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.)
        */
        this.set_ClientSecret = function(value) {
            this.setInput("ClientSecret", value);
        }

        /*
        Set the value of the Fields input for this Choreo. ((optional, string) A comma-separated list of fields to include in the response. See Choreo notes for syntax details.)
        */
        this.set_Fields = function(value) {
            this.setInput("Fields", value);
        }

        /*
        Set the value of the Range input for this Choreo. ((required, string) The A1 notation of the values to clear (e.g. Sheet1!A2:C3).)
        */
        this.set_Range = function(value) {
            this.setInput("Range", value);
        }

        /*
        Set the value of the RefreshToken input for this Choreo. ((conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.)
        */
        this.set_RefreshToken = function(value) {
            this.setInput("RefreshToken", value);
        }

        /*
        Set the value of the SpreadsheetID input for this Choreo. ((required, string) The ID of the spreadsheet. This can be found in the URL when viewing your spreadsheet in your web browser.)
        */
        this.set_SpreadsheetID = function(value) {
            this.setInput("SpreadsheetID", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the ClearValues Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var ClearValuesResultSet = function(resultStream) {
    ClearValuesResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "NewAccessToken" output from this Choreo execution. ((string) Contains a new AccessToken when the RefreshToken is provided.)
        */
        this.get_NewAccessToken = function() {
            return this.getResult("NewAccessToken");
        }
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Google.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(ClearValues, choreography.Choreography);
util.inherits(ClearValuesInputSet, choreography.InputSet);
util.inherits(ClearValuesResultSet, choreography.ResultSet);
exports.ClearValues = ClearValues;


/*
    CopyToSheet
    Copies a single sheet from a spreadsheet to another spreadsheet.
*/


var CopyToSheet = function(session) {
    /*
        Create a new instance of the CopyToSheet Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Google/Sheets/CopyToSheet"
    CopyToSheet.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new CopyToSheetResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new CopyToSheetInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the CopyToSheet
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var CopyToSheetInputSet = function() {
    CopyToSheetInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the ClientID input for this Choreo. ((conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.)
        */
        this.set_ClientID = function(value) {
            this.setInput("ClientID", value);
        }

        /*
        Set the value of the ClientSecret input for this Choreo. ((conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.)
        */
        this.set_ClientSecret = function(value) {
            this.setInput("ClientSecret", value);
        }

        /*
        Set the value of the DestinationSpreadsheetID input for this Choreo. ((required, string) The ID of the spreadsheet to copy the sheet to.)
        */
        this.set_DestinationSpreadsheetID = function(value) {
            this.setInput("DestinationSpreadsheetID", value);
        }

        /*
        Set the value of the Fields input for this Choreo. ((optional, string) A comma-separated list of fields to include in the response. See Choreo notes for syntax details.)
        */
        this.set_Fields = function(value) {
            this.setInput("Fields", value);
        }

        /*
        Set the value of the RefreshToken input for this Choreo. ((conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.)
        */
        this.set_RefreshToken = function(value) {
            this.setInput("RefreshToken", value);
        }

        /*
        Set the value of the SheetID input for this Choreo. ((required, integer) The ID of the sheet to copy. SheetIDs can be retrieved using the GetSpreadsheet Choreo.)
        */
        this.set_SheetID = function(value) {
            this.setInput("SheetID", value);
        }

        /*
        Set the value of the SpreadsheetID input for this Choreo. ((required, string) The ID of the spreadsheet. This can be found in the URL when viewing your spreadsheet in your web browser.)
        */
        this.set_SpreadsheetID = function(value) {
            this.setInput("SpreadsheetID", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the CopyToSheet Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var CopyToSheetResultSet = function(resultStream) {
    CopyToSheetResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "NewAccessToken" output from this Choreo execution. ((string) Contains a new AccessToken when the RefreshToken is provided.)
        */
        this.get_NewAccessToken = function() {
            return this.getResult("NewAccessToken");
        }
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Google.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(CopyToSheet, choreography.Choreography);
util.inherits(CopyToSheetInputSet, choreography.InputSet);
util.inherits(CopyToSheetResultSet, choreography.ResultSet);
exports.CopyToSheet = CopyToSheet;


/*
    CreateSpreadsheet
    Creates a spreadsheet.
*/


var CreateSpreadsheet = function(session) {
    /*
        Create a new instance of the CreateSpreadsheet Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Google/Sheets/CreateSpreadsheet"
    CreateSpreadsheet.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new CreateSpreadsheetResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new CreateSpreadsheetInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the CreateSpreadsheet
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var CreateSpreadsheetInputSet = function() {
    CreateSpreadsheetInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the ClientID input for this Choreo. ((conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.)
        */
        this.set_ClientID = function(value) {
            this.setInput("ClientID", value);
        }

        /*
        Set the value of the ClientSecret input for this Choreo. ((conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.)
        */
        this.set_ClientSecret = function(value) {
            this.setInput("ClientSecret", value);
        }

        /*
        Set the value of the Fields input for this Choreo. ((optional, string) A comma-separated list of fields to include in the response. See Choreo notes for syntax details.)
        */
        this.set_Fields = function(value) {
            this.setInput("Fields", value);
        }

        /*
        Set the value of the NamedRanges input for this Choreo. ((optional, json) The named ranges defined in a spreadsheet. This is a JSON array. See Choreo notes for more details.)
        */
        this.set_NamedRanges = function(value) {
            this.setInput("NamedRanges", value);
        }

        /*
        Set the value of the RefreshToken input for this Choreo. ((conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.)
        */
        this.set_RefreshToken = function(value) {
            this.setInput("RefreshToken", value);
        }

        /*
        Set the value of the Sheets input for this Choreo. ((optional, json) The sheets that are part of a spreadsheet. This is a JSON array. See Choreo notes for more details.)
        */
        this.set_Sheets = function(value) {
            this.setInput("Sheets", value);
        }

        /*
        Set the value of the SpreadsheetProperties input for this Choreo. ((required, json) A JSON object containing properties of the spreadsheet e.g. {"title": "SensorData"}.)
        */
        this.set_SpreadsheetProperties = function(value) {
            this.setInput("SpreadsheetProperties", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the CreateSpreadsheet Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var CreateSpreadsheetResultSet = function(resultStream) {
    CreateSpreadsheetResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "NewAccessToken" output from this Choreo execution. ((string) Contains a new AccessToken when the RefreshToken is provided.)
        */
        this.get_NewAccessToken = function() {
            return this.getResult("NewAccessToken");
        }
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Google.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(CreateSpreadsheet, choreography.Choreography);
util.inherits(CreateSpreadsheetInputSet, choreography.InputSet);
util.inherits(CreateSpreadsheetResultSet, choreography.ResultSet);
exports.CreateSpreadsheet = CreateSpreadsheet;


/*
    GetLastRow
    Returns the last row in a sheet.
*/


var GetLastRow = function(session) {
    /*
        Create a new instance of the GetLastRow Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Google/Sheets/GetLastRow"
    GetLastRow.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new GetLastRowResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new GetLastRowInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the GetLastRow
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var GetLastRowInputSet = function() {
    GetLastRowInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the ClientID input for this Choreo. ((conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.)
        */
        this.set_ClientID = function(value) {
            this.setInput("ClientID", value);
        }

        /*
        Set the value of the ClientSecret input for this Choreo. ((conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.)
        */
        this.set_ClientSecret = function(value) {
            this.setInput("ClientSecret", value);
        }

        /*
        Set the value of the DateTimeRenderOption input for this Choreo. ((optional, string) How dates, times, and durations should be represented in the output. Valid values are: SERIAL_NUMBER or FORMATTED_STRING. This is ignored if valueRenderOption is FORMATTED_VALUE.)
        */
        this.set_DateTimeRenderOption = function(value) {
            this.setInput("DateTimeRenderOption", value);
        }

        /*
        Set the value of the Fields input for this Choreo. ((optional, string) A comma-separated list of fields to include in the response. See Choreo notes for syntax details.)
        */
        this.set_Fields = function(value) {
            this.setInput("Fields", value);
        }

        /*
        Set the value of the MaxColumn input for this Choreo. ((optional, string) The last column in the range to return. Defaults to "Z".)
        */
        this.set_MaxColumn = function(value) {
            this.setInput("MaxColumn", value);
        }

        /*
        Set the value of the MinColumn input for this Choreo. ((optional, string) The first column in the range to return. Defaults to "A".)
        */
        this.set_MinColumn = function(value) {
            this.setInput("MinColumn", value);
        }

        /*
        Set the value of the RefreshToken input for this Choreo. ((conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.)
        */
        this.set_RefreshToken = function(value) {
            this.setInput("RefreshToken", value);
        }

        /*
        Set the value of the SheetName input for this Choreo. ((optional, string) The sheet name.)
        */
        this.set_SheetName = function(value) {
            this.setInput("SheetName", value);
        }

        /*
        Set the value of the SpreadsheetID input for this Choreo. ((required, string) The ID of the spreadsheet. This can be found in the URL when viewing your spreadsheet in your web browser.)
        */
        this.set_SpreadsheetID = function(value) {
            this.setInput("SpreadsheetID", value);
        }

        /*
        Set the value of the ValueRenderOption input for this Choreo. ((optional, string) How values should be represented in the output. Valid values are: FORMATTED_VALUE, UNFORMATTED_VALUE, or FORMULA.)
        */
        this.set_ValueRenderOption = function(value) {
            this.setInput("ValueRenderOption", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the GetLastRow Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var GetLastRowResultSet = function(resultStream) {
    GetLastRowResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "NewAccessToken" output from this Choreo execution. ((string) Contains a new AccessToken when the RefreshToken is provided.)
        */
        this.get_NewAccessToken = function() {
            return this.getResult("NewAccessToken");
        }
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Google.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(GetLastRow, choreography.Choreography);
util.inherits(GetLastRowInputSet, choreography.InputSet);
util.inherits(GetLastRowResultSet, choreography.ResultSet);
exports.GetLastRow = GetLastRow;


/*
    GetSpreadsheet
    Returns the spreadsheet at the given ID.
*/


var GetSpreadsheet = function(session) {
    /*
        Create a new instance of the GetSpreadsheet Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Google/Sheets/GetSpreadsheet"
    GetSpreadsheet.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new GetSpreadsheetResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new GetSpreadsheetInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the GetSpreadsheet
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var GetSpreadsheetInputSet = function() {
    GetSpreadsheetInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the ClientID input for this Choreo. ((conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.)
        */
        this.set_ClientID = function(value) {
            this.setInput("ClientID", value);
        }

        /*
        Set the value of the ClientSecret input for this Choreo. ((conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.)
        */
        this.set_ClientSecret = function(value) {
            this.setInput("ClientSecret", value);
        }

        /*
        Set the value of the Fields input for this Choreo. ((optional, string) A comma-separated list of fields to include in the response. See Choreo notes for syntax details.)
        */
        this.set_Fields = function(value) {
            this.setInput("Fields", value);
        }

        /*
        Set the value of the IncludeGridData input for this Choreo. ((optional, boolean) Set to True if grid data should be returned.)
        */
        this.set_IncludeGridData = function(value) {
            this.setInput("IncludeGridData", value);
        }

        /*
        Set the value of the Ranges input for this Choreo. ((optional, string) The A1 notation of the values to retrieve formatted as an array (e.g. ["Sheet1!A2:C3"]). Note, this input support up to 10 ranges.)
        */
        this.set_Ranges = function(value) {
            this.setInput("Ranges", value);
        }

        /*
        Set the value of the RefreshToken input for this Choreo. ((conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.)
        */
        this.set_RefreshToken = function(value) {
            this.setInput("RefreshToken", value);
        }

        /*
        Set the value of the SpreadsheetID input for this Choreo. ((required, string) The ID of the spreadsheet. This can be found in the URL when viewing your spreadsheet in your web browser.)
        */
        this.set_SpreadsheetID = function(value) {
            this.setInput("SpreadsheetID", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the GetSpreadsheet Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var GetSpreadsheetResultSet = function(resultStream) {
    GetSpreadsheetResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "NewAccessToken" output from this Choreo execution. ((string) Contains a new AccessToken when the RefreshToken is provided.)
        */
        this.get_NewAccessToken = function() {
            return this.getResult("NewAccessToken");
        }
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Google.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(GetSpreadsheet, choreography.Choreography);
util.inherits(GetSpreadsheetInputSet, choreography.InputSet);
util.inherits(GetSpreadsheetResultSet, choreography.ResultSet);
exports.GetSpreadsheet = GetSpreadsheet;


/*
    GetValues
    Returns a range of values from a spreadsheet.
*/


var GetValues = function(session) {
    /*
        Create a new instance of the GetValues Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Google/Sheets/GetValues"
    GetValues.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new GetValuesResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new GetValuesInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the GetValues
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var GetValuesInputSet = function() {
    GetValuesInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the ClientID input for this Choreo. ((conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.)
        */
        this.set_ClientID = function(value) {
            this.setInput("ClientID", value);
        }

        /*
        Set the value of the ClientSecret input for this Choreo. ((conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.)
        */
        this.set_ClientSecret = function(value) {
            this.setInput("ClientSecret", value);
        }

        /*
        Set the value of the DateTimeRenderOption input for this Choreo. ((optional, string) How dates, times, and durations should be represented in the output. Valid values are: SERIAL_NUMBER or FORMATTED_STRING. This is ignored if valueRenderOption is FORMATTED_VALUE.)
        */
        this.set_DateTimeRenderOption = function(value) {
            this.setInput("DateTimeRenderOption", value);
        }

        /*
        Set the value of the Fields input for this Choreo. ((optional, string) A comma-separated list of fields to include in the response. See Choreo notes for syntax details.)
        */
        this.set_Fields = function(value) {
            this.setInput("Fields", value);
        }

        /*
        Set the value of the MajorDimension input for this Choreo. ((optional, string) Indicates the dimension that results should use. Valid values are ROWS (the default) or COLUMNS.)
        */
        this.set_MajorDimension = function(value) {
            this.setInput("MajorDimension", value);
        }

        /*
        Set the value of the Range input for this Choreo. ((required, string) The A1 notation of the values to retrieve (e.g. Sheet1!A2:C3).)
        */
        this.set_Range = function(value) {
            this.setInput("Range", value);
        }

        /*
        Set the value of the RefreshToken input for this Choreo. ((conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.)
        */
        this.set_RefreshToken = function(value) {
            this.setInput("RefreshToken", value);
        }

        /*
        Set the value of the SpreadsheetID input for this Choreo. ((required, string) The ID of the spreadsheet. This can be found in the URL when viewing your spreadsheet in your web browser.)
        */
        this.set_SpreadsheetID = function(value) {
            this.setInput("SpreadsheetID", value);
        }

        /*
        Set the value of the ValueRenderOption input for this Choreo. ((optional, string) How values should be represented in the output. Valid values are: FORMATTED_VALUE, UNFORMATTED_VALUE, or FORMULA.)
        */
        this.set_ValueRenderOption = function(value) {
            this.setInput("ValueRenderOption", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the GetValues Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var GetValuesResultSet = function(resultStream) {
    GetValuesResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "NewAccessToken" output from this Choreo execution. ((string) Contains a new AccessToken when the RefreshToken is provided.)
        */
        this.get_NewAccessToken = function() {
            return this.getResult("NewAccessToken");
        }
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Google.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(GetValues, choreography.Choreography);
util.inherits(GetValuesInputSet, choreography.InputSet);
util.inherits(GetValuesResultSet, choreography.ResultSet);
exports.GetValues = GetValues;


/*
    UpdateValues
    Updates values in the specified range of a spreadsheet.
*/


var UpdateValues = function(session) {
    /*
        Create a new instance of the UpdateValues Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Google/Sheets/UpdateValues"
    UpdateValues.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new UpdateValuesResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new UpdateValuesInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the UpdateValues
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var UpdateValuesInputSet = function() {
    UpdateValuesInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the ClientID input for this Choreo. ((conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.)
        */
        this.set_ClientID = function(value) {
            this.setInput("ClientID", value);
        }

        /*
        Set the value of the ClientSecret input for this Choreo. ((conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.)
        */
        this.set_ClientSecret = function(value) {
            this.setInput("ClientSecret", value);
        }

        /*
        Set the value of the Fields input for this Choreo. ((optional, string) A comma-separated list of fields to include in the response. See Choreo notes for syntax details.)
        */
        this.set_Fields = function(value) {
            this.setInput("Fields", value);
        }

        /*
        Set the value of the MajorDimension input for this Choreo. ((optional, string) Indicates the dimension that the values array applies to. Valid values are ROWS (the default) or COLUMNS.)
        */
        this.set_MajorDimension = function(value) {
            this.setInput("MajorDimension", value);
        }

        /*
        Set the value of the Range input for this Choreo. ((required, string) The A1 notation of a range to update. See Choreos notes for more details.)
        */
        this.set_Range = function(value) {
            this.setInput("Range", value);
        }

        /*
        Set the value of the RefreshToken input for this Choreo. ((conditional, string) An OAuth refresh token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.)
        */
        this.set_RefreshToken = function(value) {
            this.setInput("RefreshToken", value);
        }

        /*
        Set the value of the SpreadsheetID input for this Choreo. ((required, string) The ID of the spreadsheet. This can be found in the URL when viewing your spreadsheet in your web browser.)
        */
        this.set_SpreadsheetID = function(value) {
            this.setInput("SpreadsheetID", value);
        }

        /*
        Set the value of the ValueInputOption input for this Choreo. ((optional, string) Specifies how the input data should be interpreted. Valid values are: RAW (the default) and USER_ENTERED.)
        */
        this.set_ValueInputOption = function(value) {
            this.setInput("ValueInputOption", value);
        }

        /*
        Set the value of the Values input for this Choreo. ((required, json) This is an array of arrays. The outer array can represent one or more rows while the inner array can represent one or more cell values. See Choreo notes below for more details.)
        */
        this.set_Values = function(value) {
            this.setInput("Values", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the UpdateValues Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var UpdateValuesResultSet = function(resultStream) {
    UpdateValuesResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "NewAccessToken" output from this Choreo execution. ((string) Contains a new AccessToken when the RefreshToken is provided.)
        */
        this.get_NewAccessToken = function() {
            return this.getResult("NewAccessToken");
        }
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Google.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(UpdateValues, choreography.Choreography);
util.inherits(UpdateValuesInputSet, choreography.InputSet);
util.inherits(UpdateValuesResultSet, choreography.ResultSet);
exports.UpdateValues = UpdateValues;

