
var util = require("util");
var choreography = require("temboo/core/choreography");


/*
    AnalyzeEntities
    Finds named entities (currently proper names and common nouns) in the text along with entity types, salience, mentions for each entity, and other properties.
*/


var AnalyzeEntities = function(session) {
    /*
        Create a new instance of the AnalyzeEntities Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Google/NaturalLanguage/Documents/AnalyzeEntities"
    AnalyzeEntities.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new AnalyzeEntitiesResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new AnalyzeEntitiesInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the AnalyzeEntities
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var AnalyzeEntitiesInputSet = function() {
    AnalyzeEntitiesInputSet.super_.call(this);
        /*
        Set the value of the APIKey input for this Choreo. ((conditional, string) The API Key provided by Google.)
        */
        this.set_APIKey = function(value) {
            this.setInput("APIKey", value);
        }

        /*
        Set the value of the Content input for this Choreo. ((conditional, string) The content to analyze.)
        */
        this.set_Content = function(value) {
            this.setInput("Content", value);
        }

        /*
        Set the value of the EncodingType input for this Choreo. ((optional, string) The encoding type used by the API to calculate sentence offsets. Defaults to UTF-8.)
        */
        this.set_EncodingType = function(value) {
            this.setInput("EncodingType", value);
        }

        /*
        Set the value of the Fields input for this Choreo. ((optional, string) Selector specifying which fields to include in a partial response.)
        */
        this.set_Fields = function(value) {
            this.setInput("Fields", value);
        }

        /*
        Set the value of the GCSContentUri input for this Choreo. ((optional, string) The Google Cloud Storage URI where the file content is located. This can be used instead of the Content input.)
        */
        this.set_GCSContentUri = function(value) {
            this.setInput("GCSContentUri", value);
        }

        /*
        Set the value of the Language input for this Choreo. ((optional, string) The language of the document. This is specified with the ISO-639-1 Code (e.g. "en"). If not specified, the language is detected if possible.)
        */
        this.set_Language = function(value) {
            this.setInput("Language", value);
        }

        /*
        Set the value of the Type input for this Choreo. ((optional, string) The type of content being sent. Valid values are PLAIN_TEXT (the default) and HTML.)
        */
        this.set_Type = function(value) {
            this.setInput("Type", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the AnalyzeEntities Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var AnalyzeEntitiesResultSet = function(resultStream) {
    AnalyzeEntitiesResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Google.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(AnalyzeEntities, choreography.Choreography);
util.inherits(AnalyzeEntitiesInputSet, choreography.InputSet);
util.inherits(AnalyzeEntitiesResultSet, choreography.ResultSet);
exports.AnalyzeEntities = AnalyzeEntities;


/*
    AnalyzeSentiment
    Analyzes the sentiment of the provided text.
*/


var AnalyzeSentiment = function(session) {
    /*
        Create a new instance of the AnalyzeSentiment Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Google/NaturalLanguage/Documents/AnalyzeSentiment"
    AnalyzeSentiment.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new AnalyzeSentimentResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new AnalyzeSentimentInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the AnalyzeSentiment
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var AnalyzeSentimentInputSet = function() {
    AnalyzeSentimentInputSet.super_.call(this);
        /*
        Set the value of the APIKey input for this Choreo. ((conditional, string) The API Key provided by Google.)
        */
        this.set_APIKey = function(value) {
            this.setInput("APIKey", value);
        }

        /*
        Set the value of the Content input for this Choreo. ((conditional, string) The content to analyze.)
        */
        this.set_Content = function(value) {
            this.setInput("Content", value);
        }

        /*
        Set the value of the EncodingType input for this Choreo. ((optional, string) The encoding type used by the API to calculate sentence offsets. Defaults to UTF-8.)
        */
        this.set_EncodingType = function(value) {
            this.setInput("EncodingType", value);
        }

        /*
        Set the value of the Fields input for this Choreo. ((optional, string) Selector specifying which fields to include in a partial response.)
        */
        this.set_Fields = function(value) {
            this.setInput("Fields", value);
        }

        /*
        Set the value of the GCSContentUri input for this Choreo. ((optional, string) The Google Cloud Storage URI where the file content is located. This can be used instead of the Content input.)
        */
        this.set_GCSContentUri = function(value) {
            this.setInput("GCSContentUri", value);
        }

        /*
        Set the value of the Language input for this Choreo. ((optional, string) The language of the document. This is specified with the ISO-639-1 Code (e.g. "en"). If not specified, the language is detected if possible.)
        */
        this.set_Language = function(value) {
            this.setInput("Language", value);
        }

        /*
        Set the value of the Type input for this Choreo. ((optional, string) The type of content being sent. Valid values are PLAIN_TEXT (the default) and HTML.)
        */
        this.set_Type = function(value) {
            this.setInput("Type", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the AnalyzeSentiment Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var AnalyzeSentimentResultSet = function(resultStream) {
    AnalyzeSentimentResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Score" output from this Choreo execution. ((decimal) The overall sentiment score of the input document.)
        */
        this.get_Score = function() {
            return this.getResult("Score");
        }
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Google.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(AnalyzeSentiment, choreography.Choreography);
util.inherits(AnalyzeSentimentInputSet, choreography.InputSet);
util.inherits(AnalyzeSentimentResultSet, choreography.ResultSet);
exports.AnalyzeSentiment = AnalyzeSentiment;


/*
    AnalyzeSyntax
    Analyzes the syntax of the text and provides sentence boundaries and tokenization along with part of speech tags, dependency trees, and other properties.
*/


var AnalyzeSyntax = function(session) {
    /*
        Create a new instance of the AnalyzeSyntax Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Google/NaturalLanguage/Documents/AnalyzeSyntax"
    AnalyzeSyntax.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new AnalyzeSyntaxResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new AnalyzeSyntaxInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the AnalyzeSyntax
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var AnalyzeSyntaxInputSet = function() {
    AnalyzeSyntaxInputSet.super_.call(this);
        /*
        Set the value of the APIKey input for this Choreo. ((conditional, string) The API Key provided by Google.)
        */
        this.set_APIKey = function(value) {
            this.setInput("APIKey", value);
        }

        /*
        Set the value of the Content input for this Choreo. ((conditional, string) The content to analyze.)
        */
        this.set_Content = function(value) {
            this.setInput("Content", value);
        }

        /*
        Set the value of the EncodingType input for this Choreo. ((optional, string) The encoding type used by the API to calculate sentence offsets. Defaults to UTF-8.)
        */
        this.set_EncodingType = function(value) {
            this.setInput("EncodingType", value);
        }

        /*
        Set the value of the Fields input for this Choreo. ((optional, string) Selector specifying which fields to include in a partial response.)
        */
        this.set_Fields = function(value) {
            this.setInput("Fields", value);
        }

        /*
        Set the value of the GCSContentUri input for this Choreo. ((optional, string) The Google Cloud Storage URI where the file content is located. This can be used instead of the Content input.)
        */
        this.set_GCSContentUri = function(value) {
            this.setInput("GCSContentUri", value);
        }

        /*
        Set the value of the Language input for this Choreo. ((optional, string) The language of the document. This is specified with the ISO-639-1 Code (e.g. "en"). If not specified, the language is detected if possible.)
        */
        this.set_Language = function(value) {
            this.setInput("Language", value);
        }

        /*
        Set the value of the Type input for this Choreo. ((optional, string) The type of content being sent. Valid values are PLAIN_TEXT (the default) and HTML.)
        */
        this.set_Type = function(value) {
            this.setInput("Type", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the AnalyzeSyntax Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var AnalyzeSyntaxResultSet = function(resultStream) {
    AnalyzeSyntaxResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Google.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(AnalyzeSyntax, choreography.Choreography);
util.inherits(AnalyzeSyntaxInputSet, choreography.InputSet);
util.inherits(AnalyzeSyntaxResultSet, choreography.ResultSet);
exports.AnalyzeSyntax = AnalyzeSyntax;


/*
    AnnotateText
    A convenience method that provides all the features that analyzeSentiment, analyzeEntities, and analyzeSyntax provide in one call.
*/


var AnnotateText = function(session) {
    /*
        Create a new instance of the AnnotateText Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Google/NaturalLanguage/Documents/AnnotateText"
    AnnotateText.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new AnnotateTextResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new AnnotateTextInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the AnnotateText
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var AnnotateTextInputSet = function() {
    AnnotateTextInputSet.super_.call(this);
        /*
        Set the value of the APIKey input for this Choreo. ((conditional, string) The API Key provided by Google.)
        */
        this.set_APIKey = function(value) {
            this.setInput("APIKey", value);
        }

        /*
        Set the value of the Content input for this Choreo. ((conditional, string) The content to analyze.)
        */
        this.set_Content = function(value) {
            this.setInput("Content", value);
        }

        /*
        Set the value of the EncodingType input for this Choreo. ((optional, string) The encoding type used by the API to calculate sentence offsets. Defaults to UTF-8.)
        */
        this.set_EncodingType = function(value) {
            this.setInput("EncodingType", value);
        }

        /*
        Set the value of the ExtractDocumentSentiment input for this Choreo. ((optional, boolean) Extract document-level sentiment. Defaults to true.)
        */
        this.set_ExtractDocumentSentiment = function(value) {
            this.setInput("ExtractDocumentSentiment", value);
        }

        /*
        Set the value of the ExtractEntities input for this Choreo. ((optional, boolean) Extract entities. Defaults to true.)
        */
        this.set_ExtractEntities = function(value) {
            this.setInput("ExtractEntities", value);
        }

        /*
        Set the value of the ExtractSyntax input for this Choreo. ((optional, boolean) Extract syntax information. Defaults to true.)
        */
        this.set_ExtractSyntax = function(value) {
            this.setInput("ExtractSyntax", value);
        }

        /*
        Set the value of the Fields input for this Choreo. ((optional, string) Selector specifying which fields to include in a partial response.)
        */
        this.set_Fields = function(value) {
            this.setInput("Fields", value);
        }

        /*
        Set the value of the GCSContentUri input for this Choreo. ((optional, string) The Google Cloud Storage URI where the file content is located. This can be used instead of the Content input.)
        */
        this.set_GCSContentUri = function(value) {
            this.setInput("GCSContentUri", value);
        }

        /*
        Set the value of the Language input for this Choreo. ((optional, string) The language of the document. This is specified with the ISO-639-1 Code (e.g. "en"). If not specified, the language is detected if possible.)
        */
        this.set_Language = function(value) {
            this.setInput("Language", value);
        }

        /*
        Set the value of the Type input for this Choreo. ((optional, string) The type of content being sent. Valid values are PLAIN_TEXT (the default) and HTML.)
        */
        this.set_Type = function(value) {
            this.setInput("Type", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the AnnotateText Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var AnnotateTextResultSet = function(resultStream) {
    AnnotateTextResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Google.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(AnnotateText, choreography.Choreography);
util.inherits(AnnotateTextInputSet, choreography.InputSet);
util.inherits(AnnotateTextResultSet, choreography.ResultSet);
exports.AnnotateText = AnnotateText;

