
var util = require("util");
var choreography = require("temboo/core/choreography");


/*
    PostalCodeInquiry
    Retrieves location information from FedEx Web Services for a specified postal code.
*/


var PostalCodeInquiry = function(session) {
    /*
        Create a new instance of the PostalCodeInquiry Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/FedEx/CountryService/PostalCodeInquiry"
    PostalCodeInquiry.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new PostalCodeInquiryResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new PostalCodeInquiryInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the PostalCodeInquiry
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var PostalCodeInquiryInputSet = function() {
    PostalCodeInquiryInputSet.super_.call(this);
        /*
        Set the value of the AccountNumber input for this Choreo. ((required, string) Your FedEx Account Number or Test Account Number.)
        */
        this.set_AccountNumber = function(value) {
            this.setInput("AccountNumber", value);
        }

        /*
        Set the value of the AuthenticationKey input for this Choreo. ((required, string) The Production Authentication Key or Development Test Key provided by FedEx Web Services.)
        */
        this.set_AuthenticationKey = function(value) {
            this.setInput("AuthenticationKey", value);
        }

        /*
        Set the value of the CountryCode input for this Choreo. ((required, string) The country code to use in the inquiry request (e.g., US).)
        */
        this.set_CountryCode = function(value) {
            this.setInput("CountryCode", value);
        }

        /*
        Set the value of the Endpoint input for this Choreo. ((conditional, string) Set to "test" to direct requests to the FedEx test environment. Defaults to "production" indicating that requests are sent to the production URL.)
        */
        this.set_Endpoint = function(value) {
            this.setInput("Endpoint", value);
        }

        /*
        Set the value of the MeterNumber input for this Choreo. ((required, string) The Production or Test Meter Number provided by FedEx Web Services.)
        */
        this.set_MeterNumber = function(value) {
            this.setInput("MeterNumber", value);
        }

        /*
        Set the value of the Password input for this Choreo. ((required, password) The Production or Test Password provided by FedEx Web Services.)
        */
        this.set_Password = function(value) {
            this.setInput("Password", value);
        }

        /*
        Set the value of the PostalCode input for this Choreo. ((required, string) The postal code to use in the inquiry request.)
        */
        this.set_PostalCode = function(value) {
            this.setInput("PostalCode", value);
        }

        /*
        Set the value of the ResponseFormat input for this Choreo. ((optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".)
        */
        this.set_ResponseFormat = function(value) {
            this.setInput("ResponseFormat", value);
        }

        /*
        Set the value of the ShipDate input for this Choreo. ((optional, string) The ship date to use for the inquiry. Dates should be formatted as YYYY-MM-DD. Defautls to today's date.)
        */
        this.set_ShipDate = function(value) {
            this.setInput("ShipDate", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the PostalCodeInquiry Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var PostalCodeInquiryResultSet = function(resultStream) {
    PostalCodeInquiryResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from FedEx.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(PostalCodeInquiry, choreography.Choreography);
util.inherits(PostalCodeInquiryInputSet, choreography.InputSet);
util.inherits(PostalCodeInquiryResultSet, choreography.ResultSet);
exports.PostalCodeInquiry = PostalCodeInquiry;

