
var util = require("util");
var choreography = require("temboo/core/choreography");


/*
    ServiceAvailability
    Retrieves available shipping options and delivery dates for a specified origin and destination.
*/


var ServiceAvailability = function(session) {
    /*
        Create a new instance of the ServiceAvailability Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/FedEx/Availability/ServiceAvailability"
    ServiceAvailability.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new ServiceAvailabilityResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new ServiceAvailabilityInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the ServiceAvailability
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var ServiceAvailabilityInputSet = function() {
    ServiceAvailabilityInputSet.super_.call(this);
        /*
        Set the value of the AccountNumber input for this Choreo. ((required, string) Your FedEx Account Number or Test Account Number.)
        */
        this.set_AccountNumber = function(value) {
            this.setInput("AccountNumber", value);
        }

        /*
        Set the value of the AuthenticationKey input for this Choreo. ((required, string) The Production Authentication Key or Development Test Key provided by FedEx Web Services.)
        */
        this.set_AuthenticationKey = function(value) {
            this.setInput("AuthenticationKey", value);
        }

        /*
        Set the value of the DestinationCountryCode input for this Choreo. ((required, string) The destination country code to use for the service availability request (e.g., US).)
        */
        this.set_DestinationCountryCode = function(value) {
            this.setInput("DestinationCountryCode", value);
        }

        /*
        Set the value of the DestinationPostalCode input for this Choreo. ((required, string) The destination postal code to use for  the service availability request.)
        */
        this.set_DestinationPostalCode = function(value) {
            this.setInput("DestinationPostalCode", value);
        }

        /*
        Set the value of the Endpoint input for this Choreo. ((conditional, string) Set to "test" to direct requests to the FedEx test environment. Defaults to "production" indicating that requests are sent to the production URL.)
        */
        this.set_Endpoint = function(value) {
            this.setInput("Endpoint", value);
        }

        /*
        Set the value of the MeterNumber input for this Choreo. ((required, string) The Production or Test Meter Number provided by FedEx Web Services.)
        */
        this.set_MeterNumber = function(value) {
            this.setInput("MeterNumber", value);
        }

        /*
        Set the value of the OriginCountryCode input for this Choreo. ((required, string) The origin country code to use for the service availability request (e.g., US).)
        */
        this.set_OriginCountryCode = function(value) {
            this.setInput("OriginCountryCode", value);
        }

        /*
        Set the value of the OriginPostalCode input for this Choreo. ((required, string) The origin postal code to use for the service availability request.)
        */
        this.set_OriginPostalCode = function(value) {
            this.setInput("OriginPostalCode", value);
        }

        /*
        Set the value of the Password input for this Choreo. ((required, password) The Production or Test Password provided by FedEx Web Services.)
        */
        this.set_Password = function(value) {
            this.setInput("Password", value);
        }

        /*
        Set the value of the ResponseFormat input for this Choreo. ((optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".)
        */
        this.set_ResponseFormat = function(value) {
            this.setInput("ResponseFormat", value);
        }

        /*
        Set the value of the ShipDate input for this Choreo. ((optional, date) The date to use for the service availability request. Dates should be formatted as YYYY-MM-DD. Defautls to today's date.)
        */
        this.set_ShipDate = function(value) {
            this.setInput("ShipDate", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the ServiceAvailability Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var ServiceAvailabilityResultSet = function(resultStream) {
    ServiceAvailabilityResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from FedEx.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(ServiceAvailability, choreography.Choreography);
util.inherits(ServiceAvailabilityInputSet, choreography.InputSet);
util.inherits(ServiceAvailabilityResultSet, choreography.ResultSet);
exports.ServiceAvailability = ServiceAvailability;

