
var util = require("util");
var choreography = require("temboo/core/choreography");


/*
    CreateSharedLink
    Creates a shared link.
*/


var CreateSharedLink = function(session) {
    /*
        Create a new instance of the CreateSharedLink Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Dropbox/Sharing/CreateSharedLink"
    CreateSharedLink.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new CreateSharedLinkResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new CreateSharedLinkInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the CreateSharedLink
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var CreateSharedLinkInputSet = function() {
    CreateSharedLinkInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((required, string) The access token for a specific Dropbox user.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the Path input for this Choreo. ((required, string) The path to share.)
        */
        this.set_Path = function(value) {
            this.setInput("Path", value);
        }

        /*
        Set the value of the ShortURL input for this Choreo. ((optional, boolean) Whether to return a shortened URL. The default for this field is false.)
        */
        this.set_ShortURL = function(value) {
            this.setInput("ShortURL", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the CreateSharedLink Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var CreateSharedLinkResultSet = function(resultStream) {
    CreateSharedLinkResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Dropbox.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(CreateSharedLink, choreography.Choreography);
util.inherits(CreateSharedLinkInputSet, choreography.InputSet);
util.inherits(CreateSharedLinkResultSet, choreography.ResultSet);
exports.CreateSharedLink = CreateSharedLink;


/*
    RevokeSharedLink
    Revokes a shared link.
*/


var RevokeSharedLink = function(session) {
    /*
        Create a new instance of the RevokeSharedLink Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Dropbox/Sharing/RevokeSharedLink"
    RevokeSharedLink.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new RevokeSharedLinkResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new RevokeSharedLinkInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the RevokeSharedLink
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var RevokeSharedLinkInputSet = function() {
    RevokeSharedLinkInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((required, string) The access token for a specific Dropbox user.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the URL input for this Choreo. ((required, string) The URL of the shared link.)
        */
        this.set_URL = function(value) {
            this.setInput("URL", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the RevokeSharedLink Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var RevokeSharedLinkResultSet = function(resultStream) {
    RevokeSharedLinkResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Dropbox.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(RevokeSharedLink, choreography.Choreography);
util.inherits(RevokeSharedLinkInputSet, choreography.InputSet);
util.inherits(RevokeSharedLinkResultSet, choreography.ResultSet);
exports.RevokeSharedLink = RevokeSharedLink;

