/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
 */

exports.ChoreographyExecution = function(parentSession, execId) {
    var session = parentSession;
    var id = execId;
    var status = null;
    var completionStatus = null;
    var resultSet = null;

    var getPath = function() {
        return [session.getBasePath(), "choreo-executions", id].join("/");
    }

    return {
        getStatus: function() {
            if (completionStatus) {
                return completionStatus;
            }
            var response = JSON.parse(session.getRequest(getPath()));
            var currentStatus = response["execution"]["status"];
            status = currentStatus;

            if (currentStatus != "RUNNING") {
                var resultResponse = session.getRequest(getPath(), 
                                                    {"view": "outputs"});
                completionStatus = currentStatus;
                resultSet = new ResultSet(resultResponse);
            }
            return status;
        },
        getResults: function() {
            if (!resultSet) {
                getStatus();
            }
            return resultSet;
        }
    }
}