
var util = require("util");
var choreography = require("temboo/core/choreography");


/*
    GetTemperature
    Retrieves the current temperature from Yahoo Weather for the specified location.
*/


var GetTemperature = function(session) {
    /*
        Create a new instance of the GetTemperature Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Yahoo/Weather/GetTemperature"
    GetTemperature.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new GetTemperatureResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new GetTemperatureInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the GetTemperature
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var GetTemperatureInputSet = function() {
    GetTemperatureInputSet.super_.call(this);
        /*
        Set the value of the Address input for this Choreo. ((required, string) The address to be searched.)
        */
        this.set_Address = function(value) {
            this.setInput("Address", value);
        }

        /*
        Set the value of the Units input for this Choreo. ((optional, string) The unit of temperature in the response. Acceptable inputs: f for Fahrenheit or c for Celsius. Defaults to f. When c is specified, all units measurements returned are changed to metric.)
        */
        this.set_Units = function(value) {
            this.setInput("Units", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the GetTemperature Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var GetTemperatureResultSet = function(resultStream) {
    GetTemperatureResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Temperature" output from this Choreo execution. ((integer) The current temperature (defaults to Fahrenheit).)
        */
        this.get_Temperature = function() {
            return this.getResult("Temperature");
        }
}

util.inherits(GetTemperature, choreography.Choreography);
util.inherits(GetTemperatureInputSet, choreography.InputSet);
util.inherits(GetTemperatureResultSet, choreography.ResultSet);
exports.GetTemperature = GetTemperature;


/*
    GetWeather
    Retrieves the Yahoo Weather RSS Feed for any specified location by WOEID.
*/


var GetWeather = function(session) {
    /*
        Create a new instance of the GetWeather Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Yahoo/Weather/GetWeather"
    GetWeather.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new GetWeatherResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new GetWeatherInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the GetWeather
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var GetWeatherInputSet = function() {
    GetWeatherInputSet.super_.call(this);
        /*
        Set the value of the Day input for this Choreo. ((optional, integer) An index in the range 1 to 5 that corresponds to the forecast day you want to retrieve. Today corresponds to 1, tomorrow corresponds to 2, and so on. Defaults to 1.)
        */
        this.set_Day = function(value) {
            this.setInput("Day", value);
        }

        /*
        Set the value of the ResponseFormat input for this Choreo. ((optional, string) The format that the response should be in. Valid values are: xml (the default) and json.)
        */
        this.set_ResponseFormat = function(value) {
            this.setInput("ResponseFormat", value);
        }

        /*
        Set the value of the Units input for this Choreo. ((optional, string) The unit of temperature in the response. Acceptable inputs: f for Fahrenheit or c for Celsius. Defaults to f. When c is specified, all units measurements returned are changed to metric.)
        */
        this.set_Units = function(value) {
            this.setInput("Units", value);
        }

        /*
        Set the value of the WOEID input for this Choreo. ((required, integer) Where On Earth ID for the desired location. This unique integer can be found by first running the GetWeatherByCoordinates Choreo.)
        */
        this.set_WOEID = function(value) {
            this.setInput("WOEID", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the GetWeather Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var GetWeatherResultSet = function(resultStream) {
    GetWeatherResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "ConditionCode" output from this Choreo execution. ((integer) A code representing the current condition.)
        */
        this.get_ConditionCode = function() {
            return this.getResult("ConditionCode");
        }
        /*
        Retrieve the value for the "ConditionText" output from this Choreo execution. ((string) The textual description for the current condition.)
        */
        this.get_ConditionText = function() {
            return this.getResult("ConditionText");
        }
        /*
        Retrieve the value for the "ForecastCode" output from this Choreo execution. ((integer) A code representing the forecast condition.)
        */
        this.get_ForecastCode = function() {
            return this.getResult("ForecastCode");
        }
        /*
        Retrieve the value for the "ForecastText" output from this Choreo execution. ((string) The textual description for the specified day's forecast condition.)
        */
        this.get_ForecastText = function() {
            return this.getResult("ForecastText");
        }
        /*
        Retrieve the value for the "High" output from this Choreo execution. ((integer) The high temperature forecast for the specified day.)
        */
        this.get_High = function() {
            return this.getResult("High");
        }
        /*
        Retrieve the value for the "Humidity" output from this Choreo execution. ((decimal) The current measurement for atmospheric humidity.)
        */
        this.get_Humidity = function() {
            return this.getResult("Humidity");
        }
        /*
        Retrieve the value for the "Low" output from this Choreo execution. ((integer) The low temperature forecast for the specified day.)
        */
        this.get_Low = function() {
            return this.getResult("Low");
        }
        /*
        Retrieve the value for the "Pressure" output from this Choreo execution. ((decimal) The current measurement for atmospheric pressure.)
        */
        this.get_Pressure = function() {
            return this.getResult("Pressure");
        }
        /*
        Retrieve the value for the "Temperature" output from this Choreo execution. ((integer) The current temperature.)
        */
        this.get_Temperature = function() {
            return this.getResult("Temperature");
        }
        /*
        Retrieve the value for the "Visibility" output from this Choreo execution. ((decimal) The current measurement for visibility.)
        */
        this.get_Visibility = function() {
            return this.getResult("Visibility");
        }
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from Yahoo Weather.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(GetWeather, choreography.Choreography);
util.inherits(GetWeatherInputSet, choreography.InputSet);
util.inherits(GetWeatherResultSet, choreography.ResultSet);
exports.GetWeather = GetWeather;


/*
    GetWeatherByAddress
    Retrieves the Yahoo Weather RSS Feed for any specified location by address.
*/


var GetWeatherByAddress = function(session) {
    /*
        Create a new instance of the GetWeatherByAddress Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Yahoo/Weather/GetWeatherByAddress"
    GetWeatherByAddress.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new GetWeatherByAddressResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new GetWeatherByAddressInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the GetWeatherByAddress
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var GetWeatherByAddressInputSet = function() {
    GetWeatherByAddressInputSet.super_.call(this);
        /*
        Set the value of the Address input for this Choreo. ((required, string) The address to be searched.)
        */
        this.set_Address = function(value) {
            this.setInput("Address", value);
        }

        /*
        Set the value of the AppID input for this Choreo. ((optional, string) Deprecated (retained for backward compatibility only).)
        */
        this.set_AppID = function(value) {
            this.setInput("AppID", value);
        }

        /*
        Set the value of the Day input for this Choreo. ((optional, integer) An index in the range 1 to 5 that corresponds to the forecast day you want to retrieve. Today corresponds to 1, tomorrow corresponds to 2, and so on. Defaults to 1.)
        */
        this.set_Day = function(value) {
            this.setInput("Day", value);
        }

        /*
        Set the value of the ResponseFormat input for this Choreo. ((optional, string) The format that the response should be in. Valid values are: xml (the default) and json.)
        */
        this.set_ResponseFormat = function(value) {
            this.setInput("ResponseFormat", value);
        }

        /*
        Set the value of the Units input for this Choreo. ((optional, string) The unit of temperature in the response. Acceptable inputs: f for Fahrenheit or c for Celsius. Defaults to f. When c is specified, all units measurements returned are changed to metric.)
        */
        this.set_Units = function(value) {
            this.setInput("Units", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the GetWeatherByAddress Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var GetWeatherByAddressResultSet = function(resultStream) {
    GetWeatherByAddressResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "ConditionCode" output from this Choreo execution. ((integer) A code representing the current condition.)
        */
        this.get_ConditionCode = function() {
            return this.getResult("ConditionCode");
        }
        /*
        Retrieve the value for the "ConditionText" output from this Choreo execution. ((string) The textual description for the current condition.)
        */
        this.get_ConditionText = function() {
            return this.getResult("ConditionText");
        }
        /*
        Retrieve the value for the "ForecastCode" output from this Choreo execution. ((integer) A code representing the forecast condition.)
        */
        this.get_ForecastCode = function() {
            return this.getResult("ForecastCode");
        }
        /*
        Retrieve the value for the "ForecastText" output from this Choreo execution. ((string) The textual description for the specified day's forecast condition.)
        */
        this.get_ForecastText = function() {
            return this.getResult("ForecastText");
        }
        /*
        Retrieve the value for the "High" output from this Choreo execution. ((integer) The high temperature forecast for the specified day.)
        */
        this.get_High = function() {
            return this.getResult("High");
        }
        /*
        Retrieve the value for the "Humidity" output from this Choreo execution. ((decimal) The current measurement for atmospheric humidity.)
        */
        this.get_Humidity = function() {
            return this.getResult("Humidity");
        }
        /*
        Retrieve the value for the "Low" output from this Choreo execution. ((integer) The low temperature forecast for the specified day.)
        */
        this.get_Low = function() {
            return this.getResult("Low");
        }
        /*
        Retrieve the value for the "Pressure" output from this Choreo execution. ((decimal) The current measurement for atmospheric pressure.)
        */
        this.get_Pressure = function() {
            return this.getResult("Pressure");
        }
        /*
        Retrieve the value for the "Temperature" output from this Choreo execution. ((integer) The current temperature.)
        */
        this.get_Temperature = function() {
            return this.getResult("Temperature");
        }
        /*
        Retrieve the value for the "Visibility" output from this Choreo execution. ((decimal) The current measurement for visibility.)
        */
        this.get_Visibility = function() {
            return this.getResult("Visibility");
        }
        /*
        Retrieve the value for the "WOEID" output from this Choreo execution. ((integer) The unique Where On Earth ID of the location.)
        */
        this.get_WOEID = function() {
            return this.getResult("WOEID");
        }
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from Yahoo Weather.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(GetWeatherByAddress, choreography.Choreography);
util.inherits(GetWeatherByAddressInputSet, choreography.InputSet);
util.inherits(GetWeatherByAddressResultSet, choreography.ResultSet);
exports.GetWeatherByAddress = GetWeatherByAddress;


/*
    GetWeatherByCoordinates
    Retrieves the Yahoo Weather RSS Feed for any specified location by geo-coordinates.
*/


var GetWeatherByCoordinates = function(session) {
    /*
        Create a new instance of the GetWeatherByCoordinates Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Yahoo/Weather/GetWeatherByCoordinates"
    GetWeatherByCoordinates.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new GetWeatherByCoordinatesResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new GetWeatherByCoordinatesInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the GetWeatherByCoordinates
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var GetWeatherByCoordinatesInputSet = function() {
    GetWeatherByCoordinatesInputSet.super_.call(this);
        /*
        Set the value of the AppID input for this Choreo. ((optional, string) Deprecated (retained for backward compatibility only).)
        */
        this.set_AppID = function(value) {
            this.setInput("AppID", value);
        }

        /*
        Set the value of the Day input for this Choreo. ((optional, integer) An index in the range 1 to 5 that corresponds to the forecast day you want to retrieve. Today corresponds to 1, tomorrow corresponds to 2, and so on. Defaults to 1.)
        */
        this.set_Day = function(value) {
            this.setInput("Day", value);
        }

        /*
        Set the value of the Latitude input for this Choreo. ((required, decimal) The latitude coordinate of the location you want to search (e.g., 38.898717).)
        */
        this.set_Latitude = function(value) {
            this.setInput("Latitude", value);
        }

        /*
        Set the value of the Longitude input for this Choreo. ((required, decimal) The longitude coordinate of the location you want to search (e.g., -77.035974).)
        */
        this.set_Longitude = function(value) {
            this.setInput("Longitude", value);
        }

        /*
        Set the value of the ResponseFormat input for this Choreo. ((optional, string) The format that the response should be in. Valid values are: xml (the default) and json.)
        */
        this.set_ResponseFormat = function(value) {
            this.setInput("ResponseFormat", value);
        }

        /*
        Set the value of the Units input for this Choreo. ((optional, string) The unit of temperature in the response. Acceptable inputs: f for Fahrenheit or c for Celsius. Defaults to f. When c is specified, all units measurements returned are changed to metric.)
        */
        this.set_Units = function(value) {
            this.setInput("Units", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the GetWeatherByCoordinates Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var GetWeatherByCoordinatesResultSet = function(resultStream) {
    GetWeatherByCoordinatesResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "ConditionCode" output from this Choreo execution. ((integer) A code representing the current condition.)
        */
        this.get_ConditionCode = function() {
            return this.getResult("ConditionCode");
        }
        /*
        Retrieve the value for the "ConditionText" output from this Choreo execution. ((string) The textual description for the current condition.)
        */
        this.get_ConditionText = function() {
            return this.getResult("ConditionText");
        }
        /*
        Retrieve the value for the "ForecastCode" output from this Choreo execution. ((integer) A code representing the forecast condition.)
        */
        this.get_ForecastCode = function() {
            return this.getResult("ForecastCode");
        }
        /*
        Retrieve the value for the "ForecastText" output from this Choreo execution. ((string) The textual description for the specified day's forecast condition.)
        */
        this.get_ForecastText = function() {
            return this.getResult("ForecastText");
        }
        /*
        Retrieve the value for the "High" output from this Choreo execution. ((integer) The high temperature forecast for the specified day.)
        */
        this.get_High = function() {
            return this.getResult("High");
        }
        /*
        Retrieve the value for the "Humidity" output from this Choreo execution. ((decimal) The current measurement for atmospheric humidity.)
        */
        this.get_Humidity = function() {
            return this.getResult("Humidity");
        }
        /*
        Retrieve the value for the "Low" output from this Choreo execution. ((integer) The low temperature forecast for the specified day.)
        */
        this.get_Low = function() {
            return this.getResult("Low");
        }
        /*
        Retrieve the value for the "Pressure" output from this Choreo execution. ((decimal) The current measurement for atmospheric pressure.)
        */
        this.get_Pressure = function() {
            return this.getResult("Pressure");
        }
        /*
        Retrieve the value for the "Temperature" output from this Choreo execution. ((integer) The current temperature.)
        */
        this.get_Temperature = function() {
            return this.getResult("Temperature");
        }
        /*
        Retrieve the value for the "Visibility" output from this Choreo execution. ((decimal) The current measurement for visibility.)
        */
        this.get_Visibility = function() {
            return this.getResult("Visibility");
        }
        /*
        Retrieve the value for the "WOEID" output from this Choreo execution. ((integer) The unique Where On Earth ID of the location.)
        */
        this.get_WOEID = function() {
            return this.getResult("WOEID");
        }
        /*
        Retrieve the value for the "Response" output from this Choreo execution. (The response from Yahoo Weather.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(GetWeatherByCoordinates, choreography.Choreography);
util.inherits(GetWeatherByCoordinatesInputSet, choreography.InputSet);
util.inherits(GetWeatherByCoordinatesResultSet, choreography.ResultSet);
exports.GetWeatherByCoordinates = GetWeatherByCoordinates;

