
var util = require("util");
var choreography = require("temboo/core/choreography");


/*
    CreateCoupon
    Creates a coupon that can be redeemed by customers for a discount.
*/


var CreateCoupon = function(session) {
    /*
        Create a new instance of the CreateCoupon Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Stripe/Coupons/CreateCoupon"
    CreateCoupon.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new CreateCouponResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new CreateCouponInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the CreateCoupon
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var CreateCouponInputSet = function() {
    CreateCouponInputSet.super_.call(this);
        /*
        Set the value of the APIKey input for this Choreo. ((required, string) The API Key provided by Stripe)
        */
        this.set_APIKey = function(value) {
            this.setInput("APIKey", value);
        }

        /*
        Set the value of the CouponID input for this Choreo. ((optional, string) The unique identifier of your choice for the coupon. If not specified, a random code will be generated by Stripe.)
        */
        this.set_CouponID = function(value) {
            this.setInput("CouponID", value);
        }

        /*
        Set the value of the Duration input for this Choreo. ((required, string) Indicates how long the discount will be in effect. Valid values are: forever, once, repeating.)
        */
        this.set_Duration = function(value) {
            this.setInput("Duration", value);
        }

        /*
        Set the value of the DurationInMonths input for this Choreo. ((optional, integer) If Duration is set to 'repeating', specify the number of months the discount will be valid.)
        */
        this.set_DurationInMonths = function(value) {
            this.setInput("DurationInMonths", value);
        }

        /*
        Set the value of the MaxRedemptions input for this Choreo. ((optional, integer) Specify the number times the coupon can be used.)
        */
        this.set_MaxRedemptions = function(value) {
            this.setInput("MaxRedemptions", value);
        }

        /*
        Set the value of the PercentOff input for this Choreo. ((required, integer) A integer between 1 and 100 that represents the discount that the coupon will apply when used by a customer)
        */
        this.set_PercentOff = function(value) {
            this.setInput("PercentOff", value);
        }

        /*
        Set the value of the RedeemBy input for this Choreo. ((optional, date) An epoch timestamp in seconds representing the the last time at which the coupon can be used. Specify timestamp in UTC.)
        */
        this.set_RedeemBy = function(value) {
            this.setInput("RedeemBy", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the CreateCoupon Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var CreateCouponResultSet = function(resultStream) {
    CreateCouponResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Stripe)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(CreateCoupon, choreography.Choreography);
util.inherits(CreateCouponInputSet, choreography.InputSet);
util.inherits(CreateCouponResultSet, choreography.ResultSet);
exports.CreateCoupon = CreateCoupon;


/*
    DeleteCoupon
    Deletes a specified coupon.
*/


var DeleteCoupon = function(session) {
    /*
        Create a new instance of the DeleteCoupon Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Stripe/Coupons/DeleteCoupon"
    DeleteCoupon.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new DeleteCouponResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new DeleteCouponInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the DeleteCoupon
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var DeleteCouponInputSet = function() {
    DeleteCouponInputSet.super_.call(this);
        /*
        Set the value of the APIKey input for this Choreo. ((required, string) The API Key provided by Stripe)
        */
        this.set_APIKey = function(value) {
            this.setInput("APIKey", value);
        }

        /*
        Set the value of the CouponID input for this Choreo. ((required, string) The unique identifier of the coupon you wish to delete)
        */
        this.set_CouponID = function(value) {
            this.setInput("CouponID", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the DeleteCoupon Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var DeleteCouponResultSet = function(resultStream) {
    DeleteCouponResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Stripe)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(DeleteCoupon, choreography.Choreography);
util.inherits(DeleteCouponInputSet, choreography.InputSet);
util.inherits(DeleteCouponResultSet, choreography.ResultSet);
exports.DeleteCoupon = DeleteCoupon;


/*
    ListAllCoupons
    Retrieves a a list of your coupons.
*/


var ListAllCoupons = function(session) {
    /*
        Create a new instance of the ListAllCoupons Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Stripe/Coupons/ListAllCoupons"
    ListAllCoupons.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new ListAllCouponsResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new ListAllCouponsInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the ListAllCoupons
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var ListAllCouponsInputSet = function() {
    ListAllCouponsInputSet.super_.call(this);
        /*
        Set the value of the APIKey input for this Choreo. ((required, string) The API Key provided by Stripe)
        */
        this.set_APIKey = function(value) {
            this.setInput("APIKey", value);
        }

        /*
        Set the value of the Count input for this Choreo. ((optional, integer) A limit on the number of coupons to be returned. Valid values are 1 through 100.)
        */
        this.set_Count = function(value) {
            this.setInput("Count", value);
        }

        /*
        Set the value of the Offset input for this Choreo. ((optional, integer) An offset into your coupons array. The API will return the requested number of coupons starting at that the specified offset.)
        */
        this.set_Offset = function(value) {
            this.setInput("Offset", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the ListAllCoupons Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var ListAllCouponsResultSet = function(resultStream) {
    ListAllCouponsResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Stripe)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(ListAllCoupons, choreography.Choreography);
util.inherits(ListAllCouponsInputSet, choreography.InputSet);
util.inherits(ListAllCouponsResultSet, choreography.ResultSet);
exports.ListAllCoupons = ListAllCoupons;


/*
    RetrieveCoupon
    Retrieves a coupon with specified coupon id.
*/


var RetrieveCoupon = function(session) {
    /*
        Create a new instance of the RetrieveCoupon Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/Stripe/Coupons/RetrieveCoupon"
    RetrieveCoupon.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new RetrieveCouponResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new RetrieveCouponInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the RetrieveCoupon
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var RetrieveCouponInputSet = function() {
    RetrieveCouponInputSet.super_.call(this);
        /*
        Set the value of the APIKey input for this Choreo. ((required, string) The API Key provided by Stripe)
        */
        this.set_APIKey = function(value) {
            this.setInput("APIKey", value);
        }

        /*
        Set the value of the CouponID input for this Choreo. ((required, string) The unique identifier of the coupon you want to retrieve)
        */
        this.set_CouponID = function(value) {
            this.setInput("CouponID", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the RetrieveCoupon Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var RetrieveCouponResultSet = function(resultStream) {
    RetrieveCouponResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from Stripe)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(RetrieveCoupon, choreography.Choreography);
util.inherits(RetrieveCouponInputSet, choreography.InputSet);
util.inherits(RetrieveCouponResultSet, choreography.ResultSet);
exports.RetrieveCoupon = RetrieveCoupon;

