
var util = require("util");
var choreography = require("temboo/core/choreography");


/*
    CreateEntry
    Adds a weight entry to a user's feed.
*/


var CreateEntry = function(session) {
    /*
        Create a new instance of the CreateEntry Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/RunKeeper/Weight/CreateEntry"
    CreateEntry.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new CreateEntryResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new CreateEntryInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the CreateEntry
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var CreateEntryInputSet = function() {
    CreateEntryInputSet.super_.call(this);
        /*
        Set the value of the Entry input for this Choreo. ((required, json) A JSON string containing the key/value pairs for the entry to create. See documentation for formatting examples.)
        */
        this.set_Entry = function(value) {
            this.setInput("Entry", value);
        }

        /*
        Set the value of the AccessToken input for this Choreo. ((required, string) The Access Token retrieved after the final step in the OAuth process.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the CreateEntry Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var CreateEntryResultSet = function(resultStream) {
    CreateEntryResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "URI" output from this Choreo execution. ((string) The entry uri that was created.)
        */
        this.get_URI = function() {
            return this.getResult("URI");
        }
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((boolean) Contains the string 'true" when a new entry is created successfully.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(CreateEntry, choreography.Choreography);
util.inherits(CreateEntryInputSet, choreography.InputSet);
util.inherits(CreateEntryResultSet, choreography.ResultSet);
exports.CreateEntry = CreateEntry;


/*
    DeleteEntry
    Removes an individual weight entry from a user’s feed.
*/


var DeleteEntry = function(session) {
    /*
        Create a new instance of the DeleteEntry Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/RunKeeper/Weight/DeleteEntry"
    DeleteEntry.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new DeleteEntryResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new DeleteEntryInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the DeleteEntry
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var DeleteEntryInputSet = function() {
    DeleteEntryInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((required, string) The Access Token retrieved after the final step in the OAuth process.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the EntryID input for this Choreo. ((required, string) This can be the individual id of the weight entry, or you can pass the full uri for the entry as returned from the RetrieveEntries Choreo (i.e. /weight/20775350).)
        */
        this.set_EntryID = function(value) {
            this.setInput("EntryID", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the DeleteEntry Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var DeleteEntryResultSet = function(resultStream) {
    DeleteEntryResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((boolean) Contains the string "true" when an entry is deleted successfully.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(DeleteEntry, choreography.Choreography);
util.inherits(DeleteEntryInputSet, choreography.InputSet);
util.inherits(DeleteEntryResultSet, choreography.ResultSet);
exports.DeleteEntry = DeleteEntry;


/*
    RetrieveEntries
    Returns the feed for a user's weight entries.
*/


var RetrieveEntries = function(session) {
    /*
        Create a new instance of the RetrieveEntries Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/RunKeeper/Weight/RetrieveEntries"
    RetrieveEntries.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new RetrieveEntriesResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new RetrieveEntriesInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the RetrieveEntries
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var RetrieveEntriesInputSet = function() {
    RetrieveEntriesInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((required, string) The Access Token retrieved after the final step in the OAuth process.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the Page input for this Choreo. ((optional, integer) The page of entries to return. This parameter is used in combination with the PageSize input to page through results. Defaults to 0 (the first page).)
        */
        this.set_Page = function(value) {
            this.setInput("Page", value);
        }

        /*
        Set the value of the PageSize input for this Choreo. ((optional, integer) The number entries to return per page. Defaults to 25.)
        */
        this.set_PageSize = function(value) {
            this.setInput("PageSize", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the RetrieveEntries Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var RetrieveEntriesResultSet = function(resultStream) {
    RetrieveEntriesResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Next" output from this Choreo execution. ((integer) The next page of entries that is available. This value can be passed into the Page input while paging through entries.)
        */
        this.get_Next = function() {
            return this.getResult("Next");
        }
        /*
        Retrieve the value for the "Previous" output from this Choreo execution. ((integer) The previous page of entries that is available. This value can be passed into the Page input while paging through entries.)
        */
        this.get_Previous = function() {
            return this.getResult("Previous");
        }
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from RunKeeper.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(RetrieveEntries, choreography.Choreography);
util.inherits(RetrieveEntriesInputSet, choreography.InputSet);
util.inherits(RetrieveEntriesResultSet, choreography.ResultSet);
exports.RetrieveEntries = RetrieveEntries;


/*
    RetrieveEntry
    Retrieves a weight entry from a user's feed.
*/


var RetrieveEntry = function(session) {
    /*
        Create a new instance of the RetrieveEntry Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/RunKeeper/Weight/RetrieveEntry"
    RetrieveEntry.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new RetrieveEntryResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new RetrieveEntryInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the RetrieveEntry
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var RetrieveEntryInputSet = function() {
    RetrieveEntryInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((required, string) The Access Token retrieved after the final step in the OAuth process.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the EntryID input for this Choreo. ((required, string) This can be the individual id of the weight entry, or you can pass the full uri for the entry as returned from the RetrieveEntries Choreo (i.e. /weight/24085455).)
        */
        this.set_EntryID = function(value) {
            this.setInput("EntryID", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the RetrieveEntry Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var RetrieveEntryResultSet = function(resultStream) {
    RetrieveEntryResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from RunKeeper.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(RetrieveEntry, choreography.Choreography);
util.inherits(RetrieveEntryInputSet, choreography.InputSet);
util.inherits(RetrieveEntryResultSet, choreography.ResultSet);
exports.RetrieveEntry = RetrieveEntry;


/*
    RetrieveLatestEntry
    Returns the lastest entry in a user's weight history.
*/


var RetrieveLatestEntry = function(session) {
    /*
        Create a new instance of the RetrieveLatestEntry Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/RunKeeper/Weight/RetrieveLatestEntry"
    RetrieveLatestEntry.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new RetrieveLatestEntryResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new RetrieveLatestEntryInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the RetrieveLatestEntry
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var RetrieveLatestEntryInputSet = function() {
    RetrieveLatestEntryInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((required, string) The Access Token retrieved after the final step in the OAuth process.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the RetrieveLatestEntry Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var RetrieveLatestEntryResultSet = function(resultStream) {
    RetrieveLatestEntryResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Timestamp" output from this Choreo execution. ((date) The timestamp of the latest weight entry.)
        */
        this.get_Timestamp = function() {
            return this.getResult("Timestamp");
        }
        /*
        Retrieve the value for the "URI" output from this Choreo execution. ((string) The URI of the entry.)
        */
        this.get_URI = function() {
            return this.getResult("URI");
        }
        /*
        Retrieve the value for the "Weight" output from this Choreo execution. ((decimal) The latest weight entry.)
        */
        this.get_Weight = function() {
            return this.getResult("Weight");
        }
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from RunKeeper.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(RetrieveLatestEntry, choreography.Choreography);
util.inherits(RetrieveLatestEntryInputSet, choreography.InputSet);
util.inherits(RetrieveLatestEntryResultSet, choreography.ResultSet);
exports.RetrieveLatestEntry = RetrieveLatestEntry;


/*
    UpdateEntry
    Updates a weight entry in a user’s feed.
*/


var UpdateEntry = function(session) {
    /*
        Create a new instance of the UpdateEntry Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/RunKeeper/Weight/UpdateEntry"
    UpdateEntry.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new UpdateEntryResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new UpdateEntryInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the UpdateEntry
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var UpdateEntryInputSet = function() {
    UpdateEntryInputSet.super_.call(this);
        /*
        Set the value of the Entry input for this Choreo. ((required, json) A JSON string containing the key/value pairs for the fields to be updated in the weight entry. See documentation for formatting examples.)
        */
        this.set_Entry = function(value) {
            this.setInput("Entry", value);
        }

        /*
        Set the value of the AccessToken input for this Choreo. ((required, string) The Access Token retrieved after the final step in the OAuth process.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the EntryID input for this Choreo. ((required, string) This can be the individual id of the weight entry, or you can pass the full uri for the entry as returned from the RetrieveEntries Choreo (i.e. /weight/24085455).)
        */
        this.set_EntryID = function(value) {
            this.setInput("EntryID", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the UpdateEntry Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var UpdateEntryResultSet = function(resultStream) {
    UpdateEntryResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from RunKeeper.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(UpdateEntry, choreography.Choreography);
util.inherits(UpdateEntryInputSet, choreography.InputSet);
util.inherits(UpdateEntryResultSet, choreography.ResultSet);
exports.UpdateEntry = UpdateEntry;

