
var util = require("util");
var choreography = require("temboo/core/choreography");


/*
    PostComment
    Posts a comment about a user's activity.
*/


var PostComment = function(session) {
    /*
        Create a new instance of the PostComment Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/RunKeeper/CommentThreads/PostComment"
    PostComment.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new PostCommentResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new PostCommentInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the PostComment
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var PostCommentInputSet = function() {
    PostCommentInputSet.super_.call(this);
        /*
        Set the value of the Comment input for this Choreo. ((required, string) The comment text.)
        */
        this.set_Comment = function(value) {
            this.setInput("Comment", value);
        }

        /*
        Set the value of the AccessToken input for this Choreo. ((required, string) The Access Token retrieved after the final step in the OAuth process.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the URI input for this Choreo. ((required, string) The URI of the activity thread to post a comment to (e.g., /fitnessActivities/327844402).)
        */
        this.set_URI = function(value) {
            this.setInput("URI", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the PostComment Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var PostCommentResultSet = function(resultStream) {
    PostCommentResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from RunKeeper.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(PostComment, choreography.Choreography);
util.inherits(PostCommentInputSet, choreography.InputSet);
util.inherits(PostCommentResultSet, choreography.ResultSet);
exports.PostComment = PostComment;


/*
    RetrieveCommentThread
    Retrieves a comment thread for a given activity.
*/


var RetrieveCommentThread = function(session) {
    /*
        Create a new instance of the RetrieveCommentThread Choreo. A TembooSession object, containing a valid
        set of Temboo credentials, must be supplied.
	*/
    var location = "/Library/RunKeeper/CommentThreads/RetrieveCommentThread"
    RetrieveCommentThread.super_.call(this, session, location);

    /*
    Define a callback that will be used to appropriately format the results of this Choreo.
    */
    var newResultSet = function(resultStream) {
        return new RetrieveCommentThreadResultSet(resultStream);
    }

	/*
	Obtain a new InputSet object, used to specify the input values for an execution of this Choreo.
	*/
    this.newInputSet = function() {
        return new RetrieveCommentThreadInputSet();
    }
    
	/*
	Execute this Choreo with the specified inputs, calling the specified callback upon success,
	and the specified errorCallback upon error.
	*/
    this.execute = function(inputs, callback, errorCallback) {
        this._execute(inputs, newResultSet, callback, errorCallback);
    }
}


/*
An InputSet with methods appropriate for specifying the inputs to the RetrieveCommentThread
Choreo. The InputSet object is used to specify input parameters when executing this Choreo.
*/

var RetrieveCommentThreadInputSet = function() {
    RetrieveCommentThreadInputSet.super_.call(this);
        /*
        Set the value of the AccessToken input for this Choreo. ((required, string) The Access Token retrieved after the final step in the OAuth process.)
        */
        this.set_AccessToken = function(value) {
            this.setInput("AccessToken", value);
        }

        /*
        Set the value of the URI input for this Choreo. ((required, string) The URI of the activity thread to retrieve comments for (e.g., /fitnessActivities/327844402).)
        */
        this.set_URI = function(value) {
            this.setInput("URI", value);
        }

}

/*
A ResultSet with methods tailored to the values returned by the RetrieveCommentThread Choreo.
The ResultSet object is used to retrieve the results of a Choreo execution.
*/

var RetrieveCommentThreadResultSet = function(resultStream) {
    RetrieveCommentThreadResultSet.super_.call(this, resultStream);    
        /*
        Retrieve the value for the "Response" output from this Choreo execution. ((json) The response from RunKeeper.)
        */
        this.get_Response = function() {
            return this.getResult("Response");
        }
}

util.inherits(RetrieveCommentThread, choreography.Choreography);
util.inherits(RetrieveCommentThreadInputSet, choreography.InputSet);
util.inherits(RetrieveCommentThreadResultSet, choreography.ResultSet);
exports.RetrieveCommentThread = RetrieveCommentThread;

